const express = require('express');
const bodyParser = require('body-parser');
const nodemailer = require("nodemailer");
const HashMap = require('hashmap');
const cron = require("node-cron");
const mysql = require('mysql');
const app = express();
app.use(bodyParser.json());
const map = new HashMap();

/* Test mode stripe key */
//const Secret_Key = 'sk_test_51HAL9TGdXmhCeqBzWbxBTiVUDlCqizGP8NWwxDC8zIRKuef4i9kerhyixCqVZPw5Ik3fmfUe7BR2Wy2cUqrOZdWx00IQ2MEmbO';

/*  production Stripe key */
const Secret_Key = "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";

const stripe = require('stripe')(Secret_Key)

const con = mysql.createPool({
   host: "103.65.192.7",
    user: "signalmash_db",
    password: "Yn95ph4$#%A1AC0B",
    database: "signalmash_prod2",
    port: 3306
});

const query = (sql, values) => {
    return new Promise((resolve, reject) => {
        con.query(sql, values, (error, results) => {
            if (error) {
                return reject(error);
            }
            resolve(results);
        });
    });
};

cron.schedule("*/5 * * * *", async function() {
    console.log("Running a task every 5 minutes");
    await setTemp();
});

cron.schedule("* * * * *", async function() {
    console.log("Running a task every minute");
    await autoTopup();
});

async function setTemp() {
    try {
        const templates = await query("SELECT subject, type, template FROM email_template WHERE idemail_template IN ('6', '7', '8', '9')");
        templates.forEach(template => {
            map.set(template.type, template);
        });
    } catch (err) {
        console.error("Error in setTemp (Email template not found):", err);
    }
}

async function autoTopup() {
    try {
        const sql = `
            SELECT u.type, u.iduser, u.username, w.idaccount, w.customer_id, w.status, w.min_balance, w.balance, w.topup_amount, w.isEmail, w.isEmailSent, u.trust_score, up.email 
            FROM user u 
            INNER JOIN wallet w ON u.idaccount = w.idaccount 
            LEFT JOIN user_profile up ON u.iduser = up.iduser 
            WHERE u.type = 2 AND u.is_deleted = 0 AND COALESCE(w.balance, 0) < COALESCE(w.min_balance, 0) AND w.status = 1 AND w.customer_id IS NOT NULL 
            ORDER BY w.status LIMIT 1`;
        
        const resp = await query(sql);
        if (resp.length === 0) {
            console.log("No records found");
            return;
        }

        const ele = resp[0];
        
        const userProfile = await query("SELECT email, firstname, lastname FROM user_profile WHERE iduser=?", [ele.iduser]);
        if (userProfile.length === 0) {
            console.log("No user profile found");
            return;
        }
        
        const custdata = userProfile[0];
        if (ele.isEmail === "true" && ele.isEmailSent === 0) {
            let template = map.get("autopay_low_balance");
            template.template = template.template.replace(/{FIRST_NAME}/g, custdata.firstname);
            template.template = template.template.replace(/{LAST_NAME}/g, custdata.lastname);
            template.template = template.template.replace(/{MINIMUM_BALANCE}/g, ele.min_balance);
            
            console.log("Email :: ", template);

            await sendEmail(custdata.email, "Thank You!", template.subject, template.template);
            await query("UPDATE wallet SET isEmailSent=1 WHERE idaccount=?", [ele.idaccount]);
        }

        if (ele.topup_amount > 0) {
            if (ele.status === "true" && ele.customer_id && ele.customer_id != null && ele.customer_id != "") {
                const respCard = await query("SELECT customer_id FROM stripe_card WHERE idaccount=? AND `default`='true'", [ele.idaccount]);
                let customer = respCard.length > 0 ? respCard[0].customer_id : ele.customer_id;
                try {
                    const charge = await stripe.charges.create({
                        amount: ele.topup_amount * 100,
                        description: 'Auto payment deduction',
                        currency: 'USD',
                        customer: customer,
                        metadata: {
                            email: ele.email,
                            san: Math.floor(Math.floor(100000000) + Math.floor(ele.idaccount)),
                            trust_score: ele.trust_score
                        }
                    });
                    /* Send Recharge success email*/
                    await query("UPDATE wallet SET balance = balance + ? WHERE idaccount=?", [ele.topup_amount, ele.idaccount]);
                    
                    let template = map.get("recharge_success");
                    template.template = template.template.replace(/{FIRST_NAME}/g, custdata.firstname);
                    template.template = template.template.replace(/{LAST_NAME}/g, custdata.lastname);
                    template.template = template.template.replace(/{TOPUP_AMOUNT}/g, ele.topup_amount);
                    template.template = template.template.replace(/{BALANCE}/g, (ele.topup_amount + ele.balance));
                    template.template = template.template.replace(/{MINIMUM_BALANCE}/g, ele.min_balance);
                    await sendEmail(custdata.email, "Thank You!", template.subject, template.template);
                    await query("UPDATE wallet SET isEmailSent=0 WHERE idaccount=?", [ele.idaccount]);

                    let logSql = "INSERT INTO wallet_recharge_log (idaccount, amount, purpose, status, description) VALUES (?, ?, 'Wallet successfully recharged by Auto topup', 1, ?)";
                    await query(logSql, [ele.idaccount, "+" + ele.topup_amount, charge.description]);

                    let stripeLogSql = "INSERT INTO stripe_payment (idaccount, amount, email, charge_id, customer_id, balance_transaction, created, status, description, type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'stripe')";

                    await query(stripeLogSql, [ele.idaccount, "+" + ele.topup_amount, custdata.email, charge.id, charge.customer, charge.balance_transaction, charge.created, charge.status, charge.description]);

                } catch (err) {

                    console.log(err);
                    /* Send Recharge failed email */
                    let template = map.get("recharge_failed");
                    template.template = template.template.replace(/{FIRST_NAME}/g, custdata.firstname);
                    template.template = template.template.replace(/{LAST_NAME}/g, custdata.lastname);
                    template.template = template.template.replace(/{TOPUP_AMOUNT}/g, ele.topup_amount);
                    template.template = template.template.replace(/{MINIMUM_BALANCE}/g, ele.min_balance);
                    await sendEmail(custdata.email, "Thank You!", template.subject, template.template);
                    await query("UPDATE wallet SET isEmailSent=1, status='false' WHERE idaccount=?", [ele.idaccount]);

                }
            } 
            else {
                console.log("Auto debit is disabled");
            }
        } 
        else {
            console.log("Invalid topup amount.");
        }
    } 
    catch (err) {
        console.error("Error in AutoTopup:", err);
    }
}

async function sendEmail(email, text, subject, tmpData) {
    //var text1 = tmpData.replace(/<[^>]*>/g, '').replace(/&nbsp;/g, " ");
    let text1 = tmpData.replace( /<p>/ig, '\n').replace( /(<([^>]+)>)/ig, '').replace(/&nbsp;/ig," ");
    console.log(text1);
    let smtpTransport = nodemailer.createTransport({
        service: "gmail",
        host: "smtp-relay.gmail.com",
        port: 587,
        secure: true,
        auth: {
            user: "donotreply@nglcommunications.com",
            pass: "yr%5V9GB"
        }
    });
    let mailOptions = {
        from: 'Signalmash <donotreply@signalmash.com>',
        to: email,
        bcc: 'Signalmash <help@signalmash.com>',
        // bcc: 'Signalmash <rahulv@gventure.co.in>',
        username: email,
        email: email,
        subject: subject,
        text: `${text1}`,
        html: `${tmpData}`
    };
    console.log(mailOptions);
    try {
        let emailRes = await smtpTransport.sendMail(mailOptions);
        console.log("Email Sent ::", emailRes);
        return emailRes;
    } catch (emailError) {
        console.log("Email Failed ::", emailError);
        return emailError;
    }
}

app.listen(4500, () => {
    setTemp();
    console.log("Server started at Port: 4500")
});
