const express = require('express');
const request = require('request');
const bodyPareser = require('body-parser');
const mysql = require('mysql');
var app = express();
app.use = (bodyPareser.json());
const path = require('path');
const cron = require("node-cron");

const con = mysql.createConnection({

    // Production
    host: "10.128.0.2",
    user: "signalmash",
    password: "lAq3@HbzYllQFsuC",
    database: "signalmash",

    // Staging
    /* host: "103.65.192.7",
    user: "signalmash_db",
    password: "Yn95ph4$#%A1AC0B",
    database: "signalmash_prod2", */

    port: "3306",
});

// Connect to the database
con.connect((err) => {
    if (err) {
        console.error('Error connecting to the database:', err);
        return;
    }
    console.log('Connected to the database.');
});

function sendBrandWebhook(data, resp) {
    con.query("SELECT `webhook_url` FROM `webhook_endpoint` WHERE `idaccount`='" + data.idaccount + "' AND `webhook_category`='A2P Campaign'", (errr, resp) => {
        if (errr) {
            console.log("No Records Found");
        }
        else {
            if (resp.length > 0) {
                let body = '';
                if (data.webhook_full_log) {
                    body = data.webhook_full_log
                }
                else {
                    body = {
                        "sm_reference_no": data.sm_reference_no,
                        "BrandId":data.brand_key,
                        "campaignId": data.campaign_key,                        
                        "eventType": data.webhook_event_type,
                        "description": data.description,
                        "mock": false
                    }
                }

                let options = {
                    method: 'POST',
                    url: resp[0].webhook_url,
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': ''
                    },
                    body: JSON.stringify(body)
                };
                request(options, (error, response, body) => {
                    if (error) {
                        console.log("Error sending response to URL:", error);
                        let sql = "UPDATE `brand_log` SET `webhook_dlr`='2' WHERE `idbrandlog`=" + data.idbrandlog + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand log");
                        });
                    } else {
                        console.log("Response sent successfully to URL:", resp[0].webhook_url);
                        let sql = "UPDATE `brand_log` SET `webhook_dlr`='1' WHERE `idbrandlog`=" + data.idbrandlog + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand log");
                        });
                    }
                });
            }
            else {
                console.log("No Detail Available!");
            }
        }
    });
}
function sendBrandVettingWebhook(data, resp) {
    con.query("SELECT `webhook_url` FROM `webhook_endpoint` WHERE `idaccount`='" + data.idaccount + "' AND `webhook_category`='A2P Campaign'", (errr, resp) => {
        if (errr) {
            console.log("No Records Found");
        }
        else {
            if (resp.length > 0) {
                let body = '';
                if (data.webhook_full_log) {
                    body = data.webhook_full_log
                }
                else {
                    body = {
                        //"sm_reference_no": data.sm_reference_no,
                        "BrandId":data.brand_key,                      
                        "eventType": data.webhook_event_type,
                        "description": data.description,
                        "mock": false
                    }
                }

                let options = {
                    method: 'POST',
                    url: resp[0].webhook_url,
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': ''
                    },
                    body: JSON.stringify(body)
                };
                request(options, (error, response, body) => {
                    if (error) {
                        console.log("Error sending response to URL:", error);
                        let sql = "UPDATE `brand_vetting_log` SET `webhook_dlr`='2' WHERE `vettinglogid`=" + data.vettinglogid + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand Vetting log");
                        });
                    } else {
                        console.log("Response sent successfully to URL:", resp[0].webhook_url);
                        let sql = "UPDATE `brand_appeal_log` SET `webhook_dlr`='1' WHERE `vettinglogid`=" + data.vettinglogid + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand Vetting log");
                        });
                    }
                });
            }
            else {
                console.log("No Detail Available!");
            }
        }
    });
}

function sendBrandAppealWebhook(data, resp) {
    con.query("SELECT `webhook_url` FROM `webhook_endpoint` WHERE `idaccount`='" + data.idaccount + "' AND `webhook_category`='A2P Campaign'", (errr, resp) => {
        if (errr) {
            console.log("No Records Found");
        }
        else {
            if (resp.length > 0) {
                let body = '';
                if (data.webhook_full_log) {
                    body = data.webhook_full_log
                }
                else {
                    body = {  
                        "BrandId":data.brandId,                      
                        "eventType": data.webhook_event_type,
                        "description": data.description,
                        "mock": false
                    }
                }

                let options = {
                    method: 'POST',
                    url: resp[0].webhook_url,
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': ''
                    },
                    body: JSON.stringify(body)
                };
                request(options, (error, response, body) => {
                    if (error) {
                        console.log("Error sending response to URL:", error);
                        let sql = "UPDATE `brand_appeal_log` SET `webhook_dlr`='2' WHERE `idappeal`=" + data.idappeal + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand Appeal log");
                        });
                    } else {
                        console.log("Response sent successfully to URL:", resp[0].webhook_url);
                        let sql = "UPDATE `brand_appeal_log` SET `webhook_dlr`='1' WHERE `idappeal`=" + data.idappeal + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand Appeal log");
                        });
                    }
                });
            }
            else {
                console.log("No Detail Available!");
            }
        }
    });
}

function sendBrandVettingAppealWebhook(data, resp) {
    con.query("SELECT `webhook_url` FROM `webhook_endpoint` WHERE `idaccount`='" + data.idaccount + "' AND `webhook_category`='A2P Campaign'", (errr, resp) => {
        if (errr) {
            console.log("No Records Found");
        }
        else {
            if (resp.length > 0) {
                let body = '';
                if (data.webhook_full_log) {
                    body = data.webhook_full_log
                }
                else {
                    body = {  
                        "BrandId":data.brandId,                      
                        "eventType": data.webhook_event_type,
                        "description": data.description,
                        "mock": false
                    }
                }

                let options = {
                    method: 'POST',
                    url: resp[0].webhook_url,
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': ''
                    },
                    body: JSON.stringify(body)
                };
                request(options, (error, response, body) => {
                    if (error) {
                        console.log("Error sending response to URL:", error);
                        let sql = "UPDATE `brand_vetting_appeal_log` SET `webhook_dlr`='2' WHERE `idappeal`=" + data.idappeal + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand Vetting Appeal log");
                        });
                    } else {
                        console.log("Response sent successfully to URL:", resp[0].webhook_url);
                        let sql = "UPDATE `brand_vetting_appeal_log` SET `webhook_dlr`='1' WHERE `idappeal`=" + data.idappeal + "";
                        con.query(sql, (err, res) => {
                            console.log("Webhook DLR Status updated on Brand Vetting Appeal log");
                        });
                    }
                });
            }
            else {
                console.log("No Detail Available!");
            }
        }
    });
}

cron.schedule("* * * * *", function () {
    function brandWebhook() {
        con.query("SELECT bl.idbrandlog, bl.idaccount,bl.webhook_full_log,bl.sm_reference_no,bl.brand_key,bl.campaign_key,bl.webhook_event_type,(CASE WHEN bl.webhook_description_detail IS NOT NULL THEN bl.webhook_description_detail ELSE bl.description END) AS DESCRIPTION,bl.event_type,ed.event_title FROM brand_log bl JOIN event_description ed ON bl.event_type = ed.event_type WHERE bl.webhook_dlr IN ('0', '2') AND bl.event_type IN ('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18') AND ed.table = 'brand_log' LIMIT 1000;", (errr, resp) => {
            if (errr) {
                console.log("No Records Found!");
            }
            else {
                if (resp.length > 0) {
                    resp.forEach((data, index) => {
                        sendBrandWebhook(data, resp);
                    });
                }
                else {
                    console.log("No Detail Available!");
                }
            }
        });
    }
    brandWebhook();
});

cron.schedule("* * * * *", function () {
    function brandVettingWebhook() {
        con.query("SELECT bvl.vettinglogid,bvl.idaccount,bvl.webhook_full_log,bvl.brand_key,bvl.evpId,bvl.vettingId,bvl.webhook_event_type,(CASE WHEN bvl.webhook_description_detail IS NOT NULL THEN bvl.webhook_description_detail ELSE bvl.description END) AS DESCRIPTION, ed.event_title FROM brand_vetting_log bvl JOIN event_description ed ON bvl.event_type = ed.event_type WHERE bvl.webhook_dlr IN ('0', '2') AND bvl.event_type IN ('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16') AND ed.table = 'brand_vetting_log' LIMIT 1000;", (errr, resp) => {
            if (errr) {
                console.log("No Records Found!");
            }
            else {
                if (resp.length > 0) {
                    resp.forEach((data, index) => {
                        sendBrandVettingWebhook(data, resp);
                    });
                }
                else {
                    console.log("No Detail Available!");
                }
            }
        });
    }
    brandVettingWebhook();
});

cron.schedule("* * * * *", function () {
    function brandAppealWebhook() {
        con.query("SELECT bal.idappeal, bal.idaccount,bal.webhook_full_log,bal.brandId,bal.webhook_event_type,(CASE WHEN bal.webhook_description_detail IS NOT NULL THEN bal.webhook_description_detail ELSE bal.description END) AS DESCRIPTION,ed.event_title FROM brand_appeal_log bal JOIN event_description ed ON bal.event_type = ed.event_type WHERE bal.webhook_dlr IN ('0', '2') AND bal.event_type IN ('1', '2', '3', '4') AND ed.table = 'brand_appeal_log' LIMIT 1000;", (errr, resp) => {
            if (errr) {
                console.log("No Records Found!");
            }
            else {
                if (resp.length > 0) {
                    resp.forEach((data, index) => {
                        sendBrandAppealWebhook(data, resp);
                    });
                }
                else {
                    console.log("No Detail Available!");
                }
            }
        });
    }
    brandAppealWebhook();
});

cron.schedule("* * * * *", function () {
    function brandVettingAppealWebhook() {
        con.query("SELECT bval.idappeal,bval.idaccount,bval.webhook_full_log,bval.brandId,bval.vettingId,bval.webhook_event_type,(CASE WHEN bval.webhook_description_detail IS NOT NULL THEN bval.webhook_description_detail ELSE bval.description END) AS DESCRIPTION,ed.event_title FROM brand_vetting_appeal_log bval JOIN event_description ed ON bval.event_type = ed.event_type WHERE bval.webhook_dlr IN ('0', '2') AND bval.event_type IN ('1', '2', '3', '4') AND ed.table = 'brand_vetting_appeal_log' LIMIT 1000", (errr, resp) => {
            if (errr) {
                console.log("No Records Found!");
            }
            else {
                if (resp.length > 0) {
                    resp.forEach((data, index) => {
                        sendBrandVettingAppealWebhook(data, resp);
                    });
                }
                else {
                    console.log("No Detail Available!");
                }
            }
        });
    }
    brandVettingAppealWebhook();
});

app.listen(5600, () => {
    console.log("Server started at Port: 5600");
});