'use strict';

export class DataFields
{
    public field:string="";
    public value?:string="";
    public type?:boolean=false;
}

export class Module{
    public path:string="";
    public table?:string="";
    public fields?:string[]=[];
    public sqlqry?:string="";
    public filter?:any;
    public group?:string="";
    public order?:string="";
    public limit?:number=-1;
    public type?:string="";
    public session?:any;
    public label?:string="";
    public value?:string="";
    public where?:boolean=false;
    public procedure?:string="";
}

export class Login
{
    public postfield:DataFields[]=[];
    public tablefield:string[]=[];
    public selectfield:string[]=[];
    public md5:boolean=false;
    public table:string="";
    public filter?:any;
}

export class Session
{
    public session:string="";
    public field:string[]=[];
    public table:string="";
    public filter?:any;
}
export class SuspendService
{
    public key:string="";
    public field:string[]=[];
    public table:string="";
    public filter?:any;
}

export class modData
{
    private _status:boolean=false;
    public data:Module[]=[
        {procedure:"AddUser", path:"/user",type:"main",fields: ["-1", "-1", "user_name", "password", "type", "first_name", "last_name", "email","phone","","1","1"]},
    ];    

    public get status():boolean
    {
        return this._status;
    }

    public Search(path:string):Module[]
    {
        this._status=false;
        let ret:Module[]=[];
        this.data.forEach(element => {
            if(element.path==path)
            {
                ret.push(element);
                this._status=true;
            }
        });
        return ret;
    }

    public Type(type:string, row:Module[]):Module
    {
        this._status=false;
        let ret:Module=new Module();
        row.forEach(element => {
            if(element.type==type)
            {
                ret=element;
                this._status=true;
            }
        });
        return ret;
    }
}

export class modLogin{
    public data:Login={table:"user", postfield: [{field:"username",type:true}, {field:"password",type:true}], tablefield:["username", "password"], selectfield:["iduser", "idaccount", "username", "password","type", "default", "idtariff", "isEmailVerify", "isMobileVerify", "isPlan", "isAddress"], md5:false,filter:{}};
}

export class modSwagger{
    public data:Login={table:"api", postfield: [{field:"username",type:true}, {field:"password",type:true}], tablefield:["name", "key"], selectfield:["idapi", "idaccount","type","idtariff","iduser","path"], md5:false,filter:{}}
}

export class modEmailVerify{
    public data:Login={table:"user", postfield: [{field:"validationKey",type:false}, {field:"isEmailVerify",type:true}, {field: "isMobileVerify", type: true}], tablefield:["validationKey", "isEmailVerify", "isMobileVerify"], selectfield:["iduser", "idaccount", "username", "password","type", "default", "idtariff", "isEmailVerify", "isMobileVerify", "isAddress", "isPlan","isCard","newUser_status"], md5:false,filter:{}}
}

export class modAgent{
    public data:Login={table:"agents", postfield: [{field:"username",type:true}, {field:"password",type:true}], tablefield:["username", "password"], selectfield:["idaccount",'idagent'], md5:false,filter:{}}
}

/**
 * TimeZone enabled in the session
 */
export class modSession {
    public data: Session = { table: "session", session: "authkey", field: ["iduser", "idaccount", "username", "type", "default", "idtariff", "authkey", "status", "isEmailVerify", "isMobileVerify","isCard","newUser_status", "idapi", "isAddress", "isPlan", "tz_diff", "server_time", "client_time", "sessionType"] };
}

export class modSuspendService {
    public data: SuspendService = { table: "account_service", key: "idaccount", field: ["fs_id", "idaccount", "as_status"] };
}