"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OsrApi = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const numberRegistry_1 = require("../include/numberRegistry");
const SinchSubmitNumber_1 = require("../include/SinchSubmitNumber");
const RawView_1 = require("../lib/view/RawView");
const setting_config_1 = require("../config/setting.config");
const getOsrRecords = new setting_config_1.GetOsrRecord();
const cron = require('node-cron');
let request = require('request');
let insertdid = new APIBase_1.APIBase();
// const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
// const devurl = 'http://osrdev-e1.netnumber.net:84/osr/v2/entries/';
// const myip = "iplink";
// const nnid = "104141";
class OsrApi extends numberRegistry_1.NumberRegistry {
    constructor(proirity, sessdata) {
        super(proirity, sessdata);
    }
    /**
     * To Add entry into OSR :: first method
     */
    addNumber(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let options = {
            'method': 'PUT',
            // 'url': produrl + "" + `${number1}`,
            'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
            'headers': {
                'Content-Type': 'application/json'
            },
            // body: '{id:"' + myip + '", nnid: "' + nnid + '"}'
            body: '{id:"' + getOsrRecords.OsrMyip + '", nnid: "' + getOsrRecords.Osrnnid + '"}'
        };
        console.log("options", options);
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register' where `iduser` = '" + this.sessdata.iduser + "' AND TRIM(`did`)=" + number + "";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (resp) {
                                if (sdata.CampaignId !== undefined) {
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 201, message: "DID buy and SMS enabled successfully" });
                                    obj.execute();
                                }
                            }
                            return callback(err, '');
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: Osr->addNumber::", e);
                    callback(error, "");
                }
            }
            else {
                callback(error, "");
            }
        });
    }
    /**
    //  * To Update entry into OSR :: first method //  Not in use
     */
    updateNumber(req, res, did_id, callback) {
        let userPayLoad = {
            iduser: this.sessdata.iduser,
            idaccount: this.sessdata.idaccount
        };
        let otherPayLoad = {
            idtariff: this.sessdata.idtariff
        };
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        if (sdata.CampaignId != null && sdata.CampaignId != '') {
            let checkMasterAc = new APIBase_1.APIBase();
            checkMasterAc.getMasterSlave(req, res, this.sessdata, userPayLoad.idaccount, 2, (err, resp1) => {
                if (resp1.status == 200) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND `idaccount` = '" + userPayLoad.idaccount + "' GROUP BY campaign_key";
                    obj1.prepare();
                    obj1.execute((error, camp_res) => {
                        if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                            if (camp_res[0].did_count >= camp_res[0].did_limit) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 400,
                                    message: "DID Buy Successfully but you can enable only [" + camp_res[0].did_limit + "] DID's in this Campaign.",
                                    result: [
                                        {
                                            "did": number
                                        }
                                    ]
                                });
                                objv.execute();
                            }
                            else {
                                let objh = new RawQuery_1.ModelRawQuery(req, res);
                                objh.qrysql = "SELECT `did`, `camp_registry`, `sms_provider`, `provider`,`osr_status`,`sinch_status`,`type` FROM `did_buy` WHERE `account_id` = '" + userPayLoad.idaccount + "' AND TRIM(`did`) = " + sdata.DID.trim() + " GROUP BY `did`";
                                objh.prepare();
                                objh.execute((error, responce) => {
                                    if (error == 1 && responce.length > 0) {
                                        let category = responce[0].type == 'NN' || responce[0].type == 'INN' ? 'NN' : 'TF';
                                        if (category == 'NN') {
                                            console.log("condition >>::::>> if osr_status == 'unregister' and sinch_status == '0'");
                                            let rate = new APIBase_1.APIBase();
                                            rate.getMessageRate(req, res, otherPayLoad.idtariff, "message_activation", category, (err, message_rate) => {
                                                if (err == 1) {
                                                    let nrcMsgRate = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0, mrcMsgRate = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;
                                                    let rate = new APIBase_1.APIBase();
                                                    rate.checkBalance(req, res, userPayLoad.idaccount, nrcMsgRate, (walletError, wallet) => {
                                                        if (walletError == 1) {
                                                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj0.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                                                            obj0.prepare();
                                                            obj0.execute((camperr, campres) => {
                                                                if (camperr == 1 && campres.length > 0) {
                                                                    if (responce[0].provider == "inteliQ" || responce[0].provider == "thinQ" || responce[0].provider == "Peerless" || responce[0].provider == 'Importnumber') {
                                                                        let did = sdata.DID;
                                                                        let len = did.length - 10;
                                                                        let number = did.slice(len, did.length);
                                                                        let number1 = "+1" + number;
                                                                        let options = {
                                                                            'method': 'PUT',
                                                                            // 'url': produrl + "" + `${number1}`,
                                                                            'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                                                            'headers': {
                                                                                'Content-Type': 'application/json'
                                                                            },
                                                                            body: '{ id: "' + campres[0].myip + '", nnid:"' + campres[0].nnid + '" , "context": "A2P", "campaign_id": "' + sdata.CampaignId + '" }'
                                                                        };
                                                                        request(options, (error, response) => {
                                                                            if (!error) {
                                                                                try {
                                                                                    let data = JSON.parse(response.body);
                                                                                    let __tn = typeof data.tn != 'undefined' ? data.tn : '';
                                                                                    let __message = typeof data.message != 'undefined' ? data.message : '';
                                                                                    let __campaign_id = typeof data.campaign_id != 'undefined' ? data.campaign_id : '';
                                                                                    let rDt = {
                                                                                        tn: __tn,
                                                                                        message: __message,
                                                                                        campaign_id: __campaign_id
                                                                                    };
                                                                                    if (data.message == "Success") {
                                                                                        if (nrcMsgRate > 0) {
                                                                                            let payload = {
                                                                                                idaccount: userPayLoad.idaccount,
                                                                                                amount: nrcMsgRate,
                                                                                                purpose: 'EnableSMS',
                                                                                                type: '-'
                                                                                            };
                                                                                            insertdid.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                                console.log("Osr->updateNumber Wallet deduction response:", errorD, dataD);
                                                                                            });
                                                                                            // To Insert nrc
                                                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + userPayLoad.iduser + "','" + userPayLoad.idaccount + "','" + number + "','" + nrcMsgRate + "')";
                                                                                            obj4.prepare();
                                                                                            obj4.execute((osr_err, resp) => {
                                                                                                console.log("SMS Enabled Charges Log Inserted :: ", nrcMsgRate);
                                                                                            });
                                                                                        }
                                                                                        /* let obj2 = new ModelRawNonQuery(req, res);
                                                                                        obj2.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` + 1  WHERE `idaccount` = '" + userPayLoad.idaccount + "' AND `campaign_key` = '" + sdata.CampaignId + "'";
                                                                                        obj2.prepare();
                                                                                        obj2.execute((osr_errrr, resppp) => { */
                                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                        obj3.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "', `sms_mrc`='" + mrcMsgRate + "' WHERE `account_id` = '" + userPayLoad.idaccount + "' AND TRIM(`did`)=" + number + "";
                                                                                        obj3.prepare();
                                                                                        obj3.execute((osr_err, resp) => {
                                                                                            if (osr_err == 1) {
                                                                                                if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSinch(req, res, resp1, userPayLoad, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400,
                                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SINCH!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSyniverse(req, res, resp1, userPayLoad, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400,
                                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SYNIVERSE!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                objv.prepare({
                                                                                                    status: 400,
                                                                                                    message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                    result: [
                                                                                                        {
                                                                                                            "did": number
                                                                                                        }
                                                                                                    ],
                                                                                                    error: "Something went wrong with updation!"
                                                                                                });
                                                                                                objv.execute();
                                                                                            }
                                                                                            // let obj6 = new ModelRawNonQuery(req, res);
                                                                                            // obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'6','DID provisioned','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                            // obj6.prepare();
                                                                                            // obj6.execute((er, ins_result) => {
                                                                                            //     console.log("DID Log Inserted.");
                                                                                            // });
                                                                                            let logPayload = {
                                                                                                funDetail: {
                                                                                                    tableName: 'did_log',
                                                                                                    functionName: 'updateNumber',
                                                                                                    logName: 'DID'
                                                                                                },
                                                                                                data: {
                                                                                                    account_id: this.sessdata.idaccount,
                                                                                                    did: sdata.DID.trim(),
                                                                                                    campaign_key: sdata.CampaignId,
                                                                                                    iduser: this.sessdata.iduser,
                                                                                                    event_type: 6,
                                                                                                    description: 'DID provisioned',
                                                                                                }
                                                                                            };
                                                                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                                                console.log("DID Log Inserted.");
                                                                                            });
                                                                                        });
                                                                                        /* }); */
                                                                                    }
                                                                                    else {
                                                                                        console.log("condition >>::::>> if osr_status == 'unregister' and need to enable from sinch");
                                                                                        let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                        obj8.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND TRIM(`did`)=" + number + "";
                                                                                        obj8.prepare();
                                                                                        obj8.execute((osr_failed, resp) => {
                                                                                            if (osr_failed == 1) {
                                                                                                if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSinch(req, res, resp1, userPayLoad, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400, message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SINCH!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSyniverse(req, res, resp1, userPayLoad, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400,
                                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SYNIVERSE!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                objv.prepare({
                                                                                                    status: 400,
                                                                                                    message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                    result: [
                                                                                                        {
                                                                                                            "did": number
                                                                                                        }
                                                                                                    ],
                                                                                                    error: "Something went wrong with updation!"
                                                                                                });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                        // let obj7 = new ModelRawNonQuery(req, res);
                                                                                        // obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'12','provisioning failed','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                        // obj7.prepare();
                                                                                        // obj7.execute((er, ins_result) => {
                                                                                        //     console.log("DID Log Inserted.");
                                                                                        // });
                                                                                        let logPayload = {
                                                                                            funDetail: {
                                                                                                tableName: 'did_log',
                                                                                                functionName: 'updateNumber',
                                                                                                logName: 'DID'
                                                                                            },
                                                                                            data: {
                                                                                                account_id: this.sessdata.idaccount,
                                                                                                did: sdata.DID.trim(),
                                                                                                campaign_key: sdata.CampaignId,
                                                                                                iduser: this.sessdata.iduser,
                                                                                                event_type: 12,
                                                                                                description: 'provisioned failed',
                                                                                            }
                                                                                        };
                                                                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                                            console.log("DID Log Inserted.");
                                                                                        });
                                                                                    }
                                                                                }
                                                                                catch (e) {
                                                                                    console.log("Error :: Osr->updateNumber::", e);
                                                                                    let obj = new RawView_1.RawView(res);
                                                                                    obj.prepare({
                                                                                        error_code: 0, status: 502,
                                                                                        message: "DID Buy Successfully but Something went wrong!",
                                                                                        result: [
                                                                                            {
                                                                                                "did": number
                                                                                            }
                                                                                        ],
                                                                                        error: "Something went wrong!"
                                                                                    });
                                                                                    obj.execute();
                                                                                }
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({
                                                                                    status: 400,
                                                                                    message: "DID buy successfully but SMS enabled Failed",
                                                                                    result: [
                                                                                        {
                                                                                            "did": number
                                                                                        }
                                                                                    ],
                                                                                    error: "DID not submission failed to OSR!"
                                                                                });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            status: 404,
                                                                            message: "DID Buy Successfully but SMS enabled Failed",
                                                                            result: [
                                                                                {
                                                                                    "did": number
                                                                                }
                                                                            ],
                                                                            error: "Provider not found!"
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        status: 404,
                                                                        message: "DID buy successfully but SMS enabled Failed",
                                                                        result: [
                                                                            {
                                                                                "did": number
                                                                            }
                                                                        ],
                                                                        error: "SMS provider not found!"
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                status: 404,
                                                                message: "DID buy successfully but SMS enabled Failed",
                                                                result: [
                                                                    {
                                                                        "did": number
                                                                    }
                                                                ],
                                                                error: "Amount is not enough!"
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 400,
                                                        message: "DID Buy Successfully but SMS enabled Failed!",
                                                        result: [
                                                            {
                                                                "did": number
                                                            }
                                                        ],
                                                        error: "Rates Setting Invalid!"
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                status: 400,
                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                result: [
                                                    {
                                                        "did": number
                                                    }
                                                ],
                                                error: "Service not available!"
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            status: 404,
                                            message: "DID Buy Successfully but This Campaign is not approved yet.Please try with another one!",
                                            result: [
                                                {
                                                    "did": number
                                                }
                                            ],
                                            error: "DID Not Found for enable SMS"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 404,
                                message: "DID Buy Successfully but This Campaign is not approved yet.Please try with another one!",
                                result: [
                                    {
                                        "did": number
                                    }
                                ],
                                error: "Campaign is not available or not approved!"
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        status: resp1.status,
                        message: resp1.message.replace(/::MG::/g, "Enable SMS")
                    });
                    objv.execute();
                }
            });
        }
        else {
            let obj = new RawView_1.RawView(res);
            obj.prepare({
                error_code: 1,
                status: 400,
                message: "DID Buy Successfully but SMS enabled Failed!",
                result: [
                    {
                        "did": number
                    }
                ],
                error: "Campaign Not found!"
            });
            obj.execute();
        }
    }
    /**
     * To Update entry with toll-free provisioning into OSR :: first method
     */
    updateNumberWithTollfree(req, res, callback) {
        let sdata = req.body;
        let options = {
            'method': 'PUT',
            // 'url': 'https://208.254.45.98/osr/v2/entries/1800551212',
            'url': getOsrRecords.OsrNumWithTollFree + `1800551212`,
            'headers': {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ "id": "mypid", "nnid": "123456", "context": "A2P", "ownertspid": "3434" })
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let ddata = JSON.parse(response.body);
                    if (ddata.rows.length > 0) {
                    }
                    else {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.prepare();
                        obj.execute((err, data) => {
                            callback(err, data);
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: Osr->updateNumberWithTollfree::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.prepare();
                obj.execute((err, data) => {
                    callback(err, data);
                });
            }
        });
    }
    /**
     * To Delete entry from OSR And Then SINCH :: first method
     */
    deleteNumber(req, res, functionName, userPayLoad, callback) {
        console.log("Calling Function ::: => ", functionName);
        let sdata = functionName == 'disconnectDID' ? req.body : req.query;
        let disDIDStatus = functionName == 'disconnectDID' ? 3 : 1;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `did`,`camp_registry`, `did_sub_type`, `type`, `osr_status`, `sinch_status`, `sinch_retry`, `provider`, `did_disconnect_days`, DATEDIFF(NOW(), `created_at`) AS remaining_days FROM `did_buy` WHERE TRIM(`did`)=" + number + " AND `account_id` = '" + userPayLoad.idaccount + "' AND `disconnect_did_status`=" + disDIDStatus + "";
        obj0.prepare();
        obj0.execute((err, result_did) => {
            console.log("result_did ::::::", result_did);
            if (err == 1 && result_did.length > 0) {
                let checkMasterAc = new APIBase_1.APIBase();
                checkMasterAc.getMasterSlave(req, res, this.sessdata, userPayLoad.idaccount, 2, (err, resp1) => {
                    if (resp1.status == 200) {
                        let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name, upstreamCnpId, provisioning_status FROM `campaign` WHERE " + resp1.condition + " AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
                        obj00.prepare();
                        obj00.execute((err, result_camp) => {
                            if (err == 1 && result_camp.length > 0) {
                                if (result_camp[0].provisioning_status == 3) {
                                    let msg = '';
                                    const sinchStatus = result_did[0].sinch_status == 0 || result_did[0].sinch_status == undefined || result_did[0].sinch_status == null || result_did[0].sinch_status == 'undefined' || result_did[0].sinch_status == 'null' || result_did[0].sinch_status == '' ? 0 : parseInt(result_did[0].sinch_status);
                                    const sinchRetry = parseInt(result_did[0].sinch_retry);
                                    switch (true) {
                                        case [0].includes(sinchStatus):
                                            msg = "SMS Service [" + result_did[0].camp_registry + "] is Already Disabled on this DID [" + result_did[0].did + "].";
                                            break;
                                        case [2, 3, 4, 10, 20].includes(sinchStatus):
                                            msg = 'SMS Disabled failed. Please try again.';
                                            break;
                                        case [5, 7].includes(sinchStatus) && sinchRetry < 2:
                                            msg = 'SMS Disabled failed. Please try again!';
                                            break;
                                    }
                                    if (msg) {
                                        callback(0, { status: 502, message: msg });
                                        return;
                                    }
                                    let payLoad = {
                                        result_camp: result_camp,
                                        result_did: result_did,
                                        number1: number1,
                                        number: number,
                                        sdata: sdata
                                    };
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'did_sms_failed',
                                            functionName: 'deleteNumber',
                                            logName: 'DID SMS Disable'
                                        },
                                        data: {
                                            iduser: userPayLoad.iduser,
                                            idaccount: userPayLoad.idaccount,
                                            did: number,
                                            campaign_key: result_did[0].camp_registry,
                                            provider: result_did[0].provider,
                                            sms_provider: result_camp[0].upstreamCnpId == 'SINCH' ? 0 : 1,
                                            failed_type: 0,
                                            retry: 0
                                        }
                                    };
                                    if ((result_did[0].osr_status == 'unregister' || result_did[0].osr_status == 'undefined' || result_did[0].osr_status == undefined || result_did[0].osr_status == null || result_did[0].osr_status == 'null') && (result_did[0].sinch_status == '1')) {
                                        console.log("Disable SMS condition >>::::>> if sinch_status='1' and osr_status='unregister'");
                                        if (result_camp[0].upstreamCnpId == 'SINCH') {
                                            // Delete from sinch
                                            let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                            sinch.deleteNumber(req, res, result_camp, resp1, userPayLoad, functionName, (errorr, resp11) => {
                                                if (errorr == 1) {
                                                    callback(1, { status: 201, message: "SMS facility has been successfully disabled." });
                                                }
                                                else {
                                                    /* To insert failed log */
                                                    if (errorr == 2) {
                                                        logPayload.data.failed_type = 1; /* SINCH/SYNIV Failed */
                                                        let insertdid = new APIBase_1.APIBase();
                                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                            log_error == 1 ? console.log("DID Disable Log Inserted Successfully") : console.log("DID Disable Log Not Inserted ");
                                                        });
                                                    }
                                                    callback(0, { status: resp11.status, message: resp11.message });
                                                }
                                            });
                                        }
                                        else {
                                            //  Delete from syniverse
                                            let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                            sinch.deleteNumberfromSyniverse(req, res, result_camp, resp1, userPayLoad, functionName, (errorr, resp11) => {
                                                if (errorr == 1) {
                                                    callback(1, { status: 201, message: "SMS facility has been successfully disabled." });
                                                }
                                                else {
                                                    /* To insert failed log */
                                                    if (errorr == 2) {
                                                        logPayload.data.failed_type = 1; /* SINCH/SYNIV Failed */
                                                        let insertdid = new APIBase_1.APIBase();
                                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                            log_error == 1 ? console.log("DID Disable Log Inserted Successfully") : console.log("DID Disable Log Not Inserted ");
                                                        });
                                                    }
                                                    callback(0, { status: resp11.status, message: resp11.message });
                                                }
                                            });
                                        }
                                    }
                                    else if (result_did[0].osr_status == 'register' && result_did[0].sinch_status == '1') {
                                        console.log("Disable SMS condition >>::::>> if sinch_status='1' and osr_status='register'");
                                        if (result_camp[0].upstreamCnpId == 'SINCH') {
                                            // Delete from sinch
                                            let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                            sinch.deleteNumber(req, res, result_camp, resp1, userPayLoad, functionName, (errorr, resp11) => {
                                                if (errorr == 1) {
                                                    let sinch = new OsrApi('', this.sessdata);
                                                    sinch.SMSDisableFromOSR(req, res, payLoad, userPayLoad, functionName, (er, resp) => {
                                                        if (er == 2) {
                                                            /* To insert failed log */
                                                            logPayload.data.failed_type = 0; /* OSR Failed */
                                                            let insertdid = new APIBase_1.APIBase();
                                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                log_error == 1 ? console.log("DID Disable Log Inserted Successfully") : console.log("DID Disable Log Not Inserted ");
                                                            });
                                                        }
                                                        callback(er, resp);
                                                    });
                                                }
                                                else {
                                                    /* To insert failed log */
                                                    if (errorr == 2) {
                                                        logPayload.data.failed_type = 1; /* SINCH/SYNIV Failed */
                                                        let insertdid = new APIBase_1.APIBase();
                                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                            log_error == 1 ? console.log("DID Disable Log Inserted Successfully") : console.log("DID Disable Log Not Inserted ");
                                                        });
                                                    }
                                                    callback(0, { status: resp11.status, message: resp11.message });
                                                }
                                            });
                                        }
                                        else {
                                            //  Delete from syniverse
                                            let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                            sinch.deleteNumberfromSyniverse(req, res, result_camp, resp1, userPayLoad, functionName, (errorr, resp11) => {
                                                if (errorr == 1) {
                                                    let sinch = new OsrApi('', this.sessdata);
                                                    sinch.SMSDisableFromOSR(req, res, payLoad, userPayLoad, functionName, (er, resp) => {
                                                        if (er == 2) {
                                                            /* To insert failed log */
                                                            logPayload.data.failed_type = 0; /* OSR Failed */
                                                            let insertdid = new APIBase_1.APIBase();
                                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                log_error == 1 ? console.log("DID Disable Log Inserted Successfully") : console.log("DID Disable Log Not Inserted ");
                                                            });
                                                        }
                                                        callback(er, resp);
                                                    });
                                                }
                                                else {
                                                    /* To insert failed log */
                                                    if (errorr == 2) {
                                                        logPayload.data.failed_type = 1; /* SINCH/SYNIV Failed */
                                                        let insertdid = new APIBase_1.APIBase();
                                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                            log_error == 1 ? console.log("DID Disable Log Inserted Successfully") : console.log("DID Disable Log Not Inserted ");
                                                        });
                                                    }
                                                    callback(0, { status: resp11.status, message: resp11.message });
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        console.log("Disable SMS condition >>::::>> if sinch_status='0' and osr_status='register'");
                                        let sinch = new OsrApi('', this.sessdata);
                                        sinch.SMSDisableFromOSR(req, res, payLoad, userPayLoad, functionName, (er, resp) => {
                                            if (er == 2) {
                                                /* To insert failed log */
                                                logPayload.data.failed_type = 0; /* OSR Failed */
                                                let insertdid = new APIBase_1.APIBase();
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                    log_error == 1 ? console.log("DID SMS Disable Log Inserted Successfully") : console.log("DID SMS Disable Log Not Inserted ");
                                                });
                                            }
                                            callback(er, resp);
                                        });
                                    }
                                }
                                else {
                                    callback(0, { status: 503, message: "Campaign is not approved!" });
                                }
                            }
                            else {
                                callback(0, { status: 404, message: 'Cannot find ImportedNumber' });
                            }
                        });
                    }
                    else {
                        callback(0, {
                            status: resp1.status,
                            message: resp1.message.replace(/::MG::/g, "Disable SMS Facility!")
                        });
                    }
                });
            }
            else {
                callback(0, { status: 502, message: 'DID Detail Not Available!' });
            }
        });
    }
    SMSDisableFromOSR(req, res, payLoad, userPayLoad, functionName, callback) {
        let objk = new RawQuery_1.ModelRawQuery(req, res);
        objk.qrysql = "SELECT `myip`, `nnid`, `nnid2`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + payLoad.result_camp[0].upstreamCnpId + "'";
        objk.prepare();
        objk.execute((camperr, nniddata) => {
            if (camperr == 1 && nniddata.length > 0) {
                let addDelCon = '';
                if (functionName == 'disconnectDID') {
                    addDelCon = ", `disconnect_did_status`='0'";
                }
                let nnid = payLoad.result_did[0].did_sub_type == 1 && payLoad.result_did[0].type == 'NN' ? nniddata[0].nnid2 : nniddata[0].nnid;
                let options = {
                    'method': 'DELETE',
                    // 'url': produrl + "" + `${number1}`,
                    'url': getOsrRecords.OsrProdurl + "" + `${payLoad.number1}`,
                    'headers': {
                        'Content-Type': 'application/json'
                    },
                    body: '{id:"' + nniddata[0].myip + '", nnid: "' + nnid + '"}'
                };
                request(options, (error, response) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            if (data.message == "Success") {
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister', `sinch_status` = '0', `sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_retry`=0 " + addDelCon + " WHERE `account_id` = '" + userPayLoad.idaccount + "' AND TRIM(`did`)=" + payLoad.number + "";
                                obj2.prepare();
                                obj2.execute((uperr, updt_stts) => {
                                });
                                /* here in this query we are using session's iduser and id account for the understanding who is performed this action. */
                                // let obj4 = new ModelRawNonQuery(req, res);
                                // obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'10','DID disconnect From OSR','" + payLoad.sdata.DID.trim() + "','" + payLoad.result_camp[0].campaign_key + "', '"+response.body+"')";
                                // obj4.prepare();
                                // obj4.execute((er, ins_result) => {
                                //     console.log("SMS Disabled Successfully From OSR");
                                // });
                                let logPayload = {
                                    funDetail: {
                                        tableName: 'did_log',
                                        functionName: 'SMSDisableFromOSR',
                                        logName: 'DID'
                                    },
                                    data: {
                                        account_id: userPayLoad.idaccount,
                                        did: payLoad.sdata.DID.trim(),
                                        campaign_key: payLoad.result_camp[0].campaign_key,
                                        iduser: userPayLoad.iduser,
                                        event_type: 10,
                                        description: 'DID disconnect from OSR',
                                        full_log: response.body
                                    }
                                };
                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    console.log("SMS Disabled Successfully From OSR");
                                });
                                callback(1, { status: 201, message: "SMS facility has been successfully disabled." });
                            }
                            else {
                                // let obj6 = new ModelRawNonQuery(req, res);
                                // obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'17','DID disconnect failed from OSR','" + payLoad.sdata.DID.trim() + "','" + payLoad.result_camp[0].campaign_key + "', '"+response.body+"')";
                                // obj6.prepare();
                                // obj6.execute((er, ins_result) => {
                                //     console.log("SMS is not Disabled From OSR");
                                // });
                                let logPayload = {
                                    funDetail: {
                                        tableName: 'did_log',
                                        functionName: 'SMSDisableFromOSR',
                                        logName: 'DID'
                                    },
                                    data: {
                                        account_id: userPayLoad.idaccount,
                                        did: payLoad.sdata.DID.trim(),
                                        campaign_key: payLoad.result_camp[0].campaign_key,
                                        iduser: userPayLoad.iduser,
                                        event_type: 17,
                                        description: 'DID disconnect failed from OSR',
                                        full_log: response.body
                                    }
                                };
                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    console.log("SMS is not Disabled From OSR");
                                });
                                console.log({ status: 400, message: "SMS Disabled failed. Please try again." });
                                callback(2, { status: data.response_code, message: data.message });
                            }
                        }
                        catch (e) {
                            console.log("Error :: Osr->deleteNumber::", e);
                            callback(2, { error_code: 0, status: 502, message: "Something went wrong!" });
                        }
                    }
                    else {
                        // let obj7 = new ModelRawNonQuery(req, res);
                        // obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'17','DID disconnect failed from OSR','" + payLoad.sdata.DID.trim() + "','" + payLoad.result_camp[0].campaign_key + "')";
                        // obj7.prepare();
                        // obj7.execute((er, ins_result) => {
                        //     console.log("SMS is not Disabled From OSR");
                        // });
                        let logPayload = {
                            funDetail: {
                                tableName: 'did_log',
                                functionName: 'SMSDisableFromOSR',
                                logName: 'DID'
                            },
                            data: {
                                account_id: userPayLoad.idaccount,
                                did: payLoad.sdata.DID.trim(),
                                campaign_key: payLoad.result_camp[0].campaign_key,
                                iduser: userPayLoad.iduser,
                                event_type: 17,
                                description: 'DID disconnect failed from OSR',
                            }
                        };
                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                            console.log("SMS is not Disabled From OSR");
                        });
                        callback(2, { status: 400, message: "SMS Disabled failed. Please try again." });
                    }
                });
            }
            else {
                callback(0, { status: 404, message: "SMS Provider does Not Exist!" });
            }
        });
    }
    /**
     * To retrieve entry from OSR :: first method
     */
    retrieveOsrEntry(req, res, callback) {
        let sdata = req.query;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "1" + number;
        let options = {
            'method': 'GET',
            // 'url': produrl + "" + number1 + "?id=" + myip,
            'url': getOsrRecords.OsrProdurl + "" + number1 + "?id=" + getOsrRecords.OsrMyip,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 200, message: "OSR Details Find Successfully", result: data });
                        obj.execute();
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: data.response_code, message: data.message, result: data });
                        obj.execute();
                    }
                }
                catch (e) {
                    console.log("Error :: Osr->retrieveOsrEntry::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawView_1.RawView(res);
                obj.prepare({ status: 400, result: error });
                obj.execute();
            }
        });
    }
    /**
     * To retrieve notification from OSR :: first method
     */
    retrieveOsrNotifications(req, res, callback) {
        let sdata = req.query;
        let options = {
            'method': 'GET',
            // 'url': "http://65.214.42.91:84/osr/v2/notifications?id=" + myip + "&tid=" + sdata.TID,
            'url': getOsrRecords.OsrNotification + getOsrRecords.OsrMyip + "&tid=" + sdata.TID,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        console.log("options", options);
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    console.log("Data", data);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ status: 200, message: "OSR Details Find Successfully", result: data });
                    obj.execute();
                }
                catch (e) {
                    console.log("Error :: Osr->retrieveOsrNotifications::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawView_1.RawView(res);
                obj.prepare({ status: 400, result: error });
                obj.execute();
            }
        });
    }
    /**
     * To Delete entry from OSR :: second method
     */
    // Not in Use
    deleteNumberM2(req, res, payLoad, callback) {
        let checkMasterAc = new APIBase_1.APIBase();
        checkMasterAc.getMasterSlave(req, res, this.sessdata, this.sessdata.idaccount, 2, (err, resp1) => {
            if (resp1.status == 200) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + payLoad.campaign + "' AND " + resp1.condition + " GROUP BY campaign_key";
                obj1.prepare();
                obj1.execute((error, camp_res) => {
                    console.log("Campaign Data >:::::::", camp_res);
                    if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `myip`, `nnid`, nnid2, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                        obj0.prepare();
                        obj0.execute((camperr, campres) => {
                            if (camperr == 1 && campres.length > 0) {
                                let did = payLoad.DID;
                                let len = did.length - 10;
                                let number = did.slice(len, did.length);
                                let number1 = "+1" + number;
                                let nnid = payLoad.did_sub_type == 1 && payLoad.type == 'NN' ? campres[0].nnid2 : campres[0].nnid;
                                let options = {
                                    'method': 'DELETE',
                                    // 'url': produrl + "" + `${number1}`,
                                    'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                    'headers': {
                                        'Content-Type': 'application/json'
                                    },
                                    // body: '{id:"' + myip + '", nnid: "' + nnid + '"}'
                                    body: '{id:"' + getOsrRecords.OsrMyip + '", nnid: "' + nnid + '"}'
                                };
                                request(options, (error, response) => {
                                    if (!error) {
                                        try {
                                            let data = JSON.parse(response.body);
                                            if (data.message == "Success") {
                                                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE TRIM(`did`)=" + number + " AND `account_id` = '" + this.sessdata.idaccount + "'";
                                                obj0.prepare();
                                                obj0.execute((_err, result_did) => {
                                                    if (_err == 1 && result_did.length > 0) {
                                                        let checkMasterAc = new APIBase_1.APIBase();
                                                        checkMasterAc.getMasterSlave(req, res, this.sessdata, this.sessdata.iduser, 22, (err, resp1) => {
                                                            if (resp1.status == 200) {
                                                                let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                                                                obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name FROM `campaign` WHERE " + resp1.condition + " AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
                                                                obj00.prepare();
                                                                obj00.execute((__err, result_camp) => {
                                                                    if (__err == 1 && result_camp.length > 0) {
                                                                        /* let obj1 = new ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = "UPDATE `campaign` SET did_count=`did_count` - 1 WHERE " + resp1.condition + " AND campaign_key = '" + result_camp[0].campaign_key + "'";
                                                                        obj1.prepare();
                                                                        obj1.execute((___err, updt_didby) => {
                                                                            if (___err == 1) {
                                                                                console.log("Counting Updated.");
                                                                            }
                                                                            else {
                                                                                console.log("Counting Not Updated!");
                                                                            }
                                                                        }); */
                                                                        /* let obj2 = new ModelRawNonQuery(req, res);
                                                                        obj2.nonqrysql = "UPDATE `did_buy` SET `camp_registry` = '' WHERE `account_id`='" + this.sessdata.idaccount + "' AND `did`='" + number + "';";
                                                                        obj2.prepare();
                                                                        obj2.execute((err, resp) => {
                                                                        }) */
                                                                    }
                                                                    else {
                                                                        console.log("Campaign Data Not Found.");
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                console.log(resp1.message.replace(/::MG::/g, "Disconnect Number Facility!"));
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Campaign Registry Not Found.");
                                                    }
                                                });
                                                // let objn = new ModelRawNonQuery(req, res);
                                                // objn.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'10','DID disconnect From OSR','" + number + "', '" + payLoad.campaign + "')"
                                                // objn.prepare();
                                                // objn.execute((errorDiDLg: any, resDiDLg: any) => { });
                                                let logPayload = {
                                                    funDetail: {
                                                        tableName: 'did_log',
                                                        functionName: 'deleteNumberM2',
                                                        logName: 'DID'
                                                    },
                                                    data: {
                                                        account_id: this.sessdata.idaccount,
                                                        did: number,
                                                        campaign_key: payLoad.campaign,
                                                        iduser: this.sessdata.iduser,
                                                        event_type: 10,
                                                        description: 'DID disconnect From OSR',
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                });
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` SET `osr_status`='unregister', `disconnect_did_status`='4' WHERE `account_id`='" + this.sessdata.idaccount + "' AND TRIM(`did`)=" + number + ";";
                                                obj.prepare();
                                                obj.execute((err, resp) => {
                                                    if (err == 1) {
                                                        callback(1, resp);
                                                    }
                                                    else {
                                                        callback(0, err);
                                                    }
                                                });
                                            }
                                            else {
                                                // let objn = new ModelRawNonQuery(req, res);
                                                // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnect failed from OSR','" + number + "', '" + payLoad.campaign + "')"
                                                // objn.prepare();
                                                // objn.execute((errorDiDLg: any, resDiDLg: any) => { });
                                                let logPayload = {
                                                    funDetail: {
                                                        tableName: 'did_log',
                                                        functionName: 'deleteNumberM2',
                                                        logName: 'DID'
                                                    },
                                                    data: {
                                                        account_id: this.sessdata.idaccount,
                                                        did: number,
                                                        campaign_key: payLoad.campaign,
                                                        iduser: this.sessdata.iduser,
                                                        event_type: 17,
                                                        description: 'DID disconnect failed from OSR',
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                });
                                                callback(0, data);
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: Osr->deleteNumberM2::", e);
                                            callback(0, error);
                                        }
                                    }
                                    else {
                                        callback(0, error);
                                    }
                                });
                            }
                            else {
                                // let objv = new RawView(res);
                                // objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                // objv.execute();
                                callback(1, '');
                            }
                        });
                    }
                    else {
                        // let objv = new RawView(res);
                        // objv.prepare({ status: 404, message: "This Campaign is not approved yet or not available in our entity. Please try with another one!" });
                        // objv.execute();
                        callback(1, '');
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    status: resp1.status,
                    message: resp1.message.replace(/::MG::/g, "Disconnect Number")
                });
                objv.execute();
            }
        });
    }
}
exports.OsrApi = OsrApi;
