"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThinQAPI = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Osr_1 = require("./Osr");
const RawView_1 = require("../lib/view/RawView");
const markError_1 = require("./markError");
var request = require('request');
const setting_config_1 = require("../config/setting.config");
let insertdid = new APIBase_1.APIBase();
const ThinQRecords = new setting_config_1.GetThinQRecord();
class ThinQAPI extends APIBase_1.APIBase {
    //private key: string;
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        // this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
        this.timekey = timekey;
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }
    getNpaNxx(req, res, pLoad, callback) {
        if (this.priority == "100") {
            console.log("Exit from ThinQAPI");
            callback('', '');
        }
        else {
            const sdata = req.query;
            var url;
            if (sdata.NPA != undefined && sdata.NPA != 'null') {
                // url = "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=npa&quantity=" + sdata.Qty + "&contiguous=false&npa=" + sdata.NPA + ""
                url = ThinQRecords.ThinQGetNPA + pLoad.searchqty + "&contiguous=false&npa=" + sdata.NPA + "";
            }
            if ((sdata.NPA != undefined && sdata.NPA != 'null') && (sdata.NXX != undefined && sdata.NXX != 'null')) {
                //url = "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=npanxx&quantity=" + sdata.Qty + "&contiguous=false&npa=" + sdata.NPA + "&nxx=" + sdata.NXX + ""
                url = ThinQRecords.ThinQBNpaNxx + pLoad.searchqty + "&contiguous=false&npa=" + sdata.NPA + "&nxx=" + sdata.NXX + "";
            }
            let options = {
                'method': 'GET',
                'url': url,
                'headers': {
                    //'Authorization': 'Basic ' + this.key
                    'Authorization': 'Basic ' + ThinQRecords.ThinQKEY
                },
            };
            request(options, (error, response) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let data = JSON.parse(response.body);
                            if (data.dids != undefined && data.dids.length > 0) {
                                let str = data.dids;
                                let found = false;
                                let hsmpData = [];
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qrystr = "INSERT INTO `did_search` (`idaccount`, `friendly_name`, `phone_number`, `locality`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`,`billing_frequency`) VALUE ";
                                str.forEach((ele) => {
                                    if (ele.thinqTier == 0) {
                                        let did = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        let hmp = {
                                            phone_number: number,
                                            rate_center: (0, markError_1.parseBody)(ele.ratecenter),
                                            state: (0, markError_1.parseBody)(ele.state),
                                            supplier_tier: (0, markError_1.setToZero)(ele.thinqTier),
                                            provider: 'thinQ',
                                            rates: pLoad.rate
                                        };
                                        hsmpData.push(hmp);
                                        qrystr += "('" + this.sessdata.idaccount + "', '" + ele.didSummary + "','" + number + "', '" + (0, markError_1.parseBody)(ele.ratecenter) + "', '" + (0, markError_1.parseBody)(ele.ratecenter) + "', '" + (0, markError_1.parseBody)(ele.state) + "', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + (0, markError_1.setToZero)(this.priority) + "','NN','" + (0, markError_1.setToZero)(ele.thinqTier) + "', '" + pLoad.rate + "','" + sdata.CampaignId + "','" + (0, markError_1.parseBody)(this.sessdata.path) + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + this.timekey + "','" + (0, markError_1.setToZero)(pLoad.billingfreq) + "'),";
                                        found = true;
                                    }
                                });
                                if (found) {
                                    this.saveHmp(this.timekey, 'thinQ', hsmpData);
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback('', data);
                                }
                            }
                            else {
                                callback('', data);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    }
                    catch (e) {
                        console.log("Error :: Thinq->getNpaNxx::", e);
                        callback(error, '');
                    }
                }
                else {
                    callback(error, '');
                }
            });
        }
    }
    getByRate(req, res, pLoad, callback) {
        console.log("pLoadpLoad", pLoad);
        if (this.priority == "100") {
            console.log("Exit from ThinQAPI");
            callback('', '');
        }
        else {
            var sdata = req.query;
            let options = {
                'method': 'GET',
                //'url': "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=ratecenter&quantity=" + pLoad.searchqty + "&contiguous=false&state=" + sdata.State + "&rateCenter=" + sdata.RateCenter + "",
                'url': ThinQRecords.ThinQByRate + pLoad.searchqty + "&contiguous=false&state=" + sdata.State + "&rateCenter=" + sdata.RateCenter + "",
                'headers': {
                    // 'Authorization': 'Basic ' + this.key
                    'Authorization': 'Basic ' + ThinQRecords.ThinQKEY
                },
            };
            request(options, (error, response) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let data = JSON.parse(response.body);
                            if (data.dids != undefined && data.dids.length > 0) {
                                let str = data.dids;
                                let hsmpData = [];
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let found = false;
                                let qrystr = "INSERT INTO `did_search` (`idaccount`, `friendly_name`, `phone_number`, `locality`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`,`billing_frequency`) VALUE ";
                                str.forEach((ele) => {
                                    if (ele.thinqTier == 0) {
                                        let did = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        let hmp = {
                                            phone_number: number,
                                            rate_center: (0, markError_1.parseBody)(ele.ratecenter),
                                            state: (0, markError_1.parseBody)(ele.state),
                                            supplier_tier: (0, markError_1.setToZero)(ele.thinqTier),
                                            provider: 'thinQ',
                                            rates: pLoad.rate
                                        };
                                        hsmpData.push(hmp);
                                        qrystr += "('" + this.sessdata.idaccount + "', '" + ele.didSummary + "','" + number + "', '" + (0, markError_1.parseBody)(ele.ratecenter) + "', '" + (0, markError_1.parseBody)(ele.ratecenter) + "', '" + (0, markError_1.parseBody)(ele.state) + "', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + (0, markError_1.setToZero)(this.priority) + "','NN','" + (0, markError_1.setToZero)(ele.thinqTier) + "','" + pLoad.rate + "','" + sdata.CampaignId + "','" + (0, markError_1.parseBody)(this.sessdata.path) + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + this.timekey + "','" + (0, markError_1.setToZero)(pLoad.billingfreq) + "'),";
                                        found = true;
                                    }
                                });
                                if (found) {
                                    this.saveHmp(this.timekey, 'thinQ', hsmpData);
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback(error, data);
                                }
                            }
                            else {
                                callback('', data);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    }
                    catch (e) {
                        console.log("Error :: Thinq->getByRate::", e);
                        callback(error, '');
                    }
                }
                else {
                    callback(error, '');
                }
            });
        }
    }
    getTollFree(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'GET',
                        //'url': "https://api.thinq.com/inbound/get-numbers?searchType=tollfree&searchBy=&quantity=" + sdata.Qty + "&contiguous=false",
                        'url': ThinQRecords.ThinQTF + sdata.Qty + "&contiguous=false",
                        'headers': {
                            //'Authorization': 'Basic ' + this.key
                            'Authorization': 'Basic ' + ThinQRecords.ThinQKEY
                        },
                    };
                    request(options, (error, response) => {
                        if (!error) {
                            try {
                                if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                    let data = JSON.parse(response.body);
                                    if (data.dids != undefined && data.dids.length > 0) {
                                        let str = data.dids;
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `locality`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                        str.forEach((ele) => {
                                            let did = "" + ele.id + "";
                                            let number = did.substring(1, 11);
                                            qrystr += "('" + ele.didSummary + "','" + number + "', '" + (0, markError_1.parseBody)(ele.ratecenter) + "', '" + (0, markError_1.parseBody)(ele.ratecenter) + "', '" + (0, markError_1.parseBody)(ele.state) + "', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + (0, markError_1.setToZero)(this.priority) + "','TF','" + (0, markError_1.setToZero)(ele.thinqTier) + "','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback('', data);
                                    }
                                }
                                else {
                                    callback(error, '');
                                }
                            }
                            catch (e) {
                                console.log("Error :: Thinq->getTollFree::", e);
                                callback(error, '');
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }
    buyDID(req, res, did_details, other_data, callback) {
        const sdata = req.body;
        let types;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let Did = did.slice(len, len + 10);
        let id_grouporder = other_data.id_grouporder;
        let sub_type = other_data.sub_type;
        let days = other_data.days;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            let frates = other_data.fullrates;
            let did_dis_days = days[0].day_num > 0 ? days[0].day_num : 0;
            let prorate = typeof other_data.prorate != 'undefined' && other_data.prorate > 0 ? other_data.prorate : 0;
            types = did_details[0].type == 'TF' ? 'TF' : 'NN';
            var options = {
                'method': 'POST',
                // 'url': 'https://api.thinq.com/account/15080/origination/order/create',
                'url': ThinQRecords.ThinQCreate,
                'headers': {
                    // 'Authorization': 'Basic ' + this.key,
                    'Authorization': 'Basic ' + ThinQRecords.ThinQKEY,
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    "order": {
                        "tns": [
                            {
                                "route_id": 7818,
                                "did": sdata.DID.trim()
                            }
                        ],
                        "blocks": []
                    }
                })
            };
            request(options, (error, response) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let data = JSON.parse(response.body);
                            // If order created on provider side
                            if (typeof data.id != 'undefined' && data.id) {
                                var options = {
                                    'method': 'POST',
                                    //'url': 'https://api.thinq.com/account/15080/origination/order/complete/' + `${data.id}`,
                                    'url': ThinQRecords.ThinQComplete + `${data.id}`,
                                    'headers': {
                                        // 'Authorization': 'Basic ' + this.key,
                                        'Authorization': 'Basic ' + ThinQRecords.ThinQKEY,
                                        'Content-Type': 'application/json'
                                    }
                                };
                                console.log("ThnQ Res:: options::::::", options);
                                request(options, (error, response) => {
                                    if (!error) {
                                        try {
                                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                let ddata = JSON.parse(response.body);
                                                // If order completed on provider side
                                                if (typeof ddata.id != 'undefined' && ddata.id) {
                                                    let providerOrderId = typeof data.id != 'undefined' && data.id ? data.id : '';
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`did_sub_type`,`subscription_end_date`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.idaccount + "','completed','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + (0, markError_1.parseBody)(sdata.InboundVoice) + "','" + (0, markError_1.parseBody)(sdata.OutboundVoice) + "','" + (0, markError_1.parseBody)(sdata.Connection) + "','" + (0, markError_1.parseBody)(sdata.InboundSMS) + "','" + (0, markError_1.parseBody)(sdata.OutboundSMS) + "','" + other_data.rateS + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + other_data.nrc_rates + "','" + sub_type + "','" + days[0].subscription_end_date + "','" + (0, markError_1.setToZero)(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        if (did_err == 1) {
                                                            let payLoadData = {
                                                                funDetail: {
                                                                    tableName: 'did_billing',
                                                                    functionName: 'buyDID',
                                                                    logName: 'DID Billing'
                                                                },
                                                                data: { idaccount: this.sessdata.idaccount, did: Did, type: types, did_sub_type: sub_type, cost: prorate, billing_type: '2'
                                                                }
                                                            };
                                                            insertdid.insertLog(req, res, payLoadData, (err_did, add_did) => {
                                                                console.log("ThinQ => buyDID ", types, " :: ", add_did);
                                                            });
                                                            let payload = {
                                                                idaccount: this.sessdata.idaccount,
                                                                amount: prorate,
                                                                purpose: 'buy a new DID',
                                                                type: '-'
                                                            };
                                                            insertdid.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                console.log("ThinQ => buyDID Wallet deduction response:", errorD, dataD);
                                                                let logPayload = {
                                                                    funDetail: {
                                                                        tableName: 'did_log',
                                                                        functionName: 'buyDID',
                                                                        logName: 'DID'
                                                                    },
                                                                    data: {
                                                                        account_id: this.sessdata.idaccount,
                                                                        status: 'completed',
                                                                        provider: 'thinQ',
                                                                        did: Did,
                                                                        order_id: data.id,
                                                                        type: types,
                                                                        npa: npa,
                                                                        nxx: nxx,
                                                                        state: state,
                                                                        disconnect_did_status: '1',
                                                                        iduser: this.sessdata.iduser,
                                                                        ratecenter: ratecenter,
                                                                        rates: other_data.rateS,
                                                                        idapi: this.sessdata.idapi,
                                                                        pro_rates: prorate,
                                                                        full_log: response.body,
                                                                        description: 'DID Buy',
                                                                        event_type: '1'
                                                                    }
                                                                };
                                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                });
                                                                // To delete the DID from cart
                                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE TRIM(`did`)=" + sdata.DID.trim() + "";
                                                                obj5.prepare();
                                                                obj5.execute((walletError1, wallet1) => { });
                                                                // To update the process count of group order
                                                                let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";";
                                                                objk.prepare();
                                                                objk.execute((error, result) => {
                                                                    console.log("GroupOrder process count::\n", result);
                                                                });
                                                                // To create the did_order
                                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + Did + "', '2', '" + types + "', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                                obj.prepare();
                                                                obj.execute((did_err, did_data) => {
                                                                    // To update the other data on current order
                                                                    if (did_err == 1) {
                                                                        let id_order = did_data.insertId;
                                                                        let orderID = "SORD" + id_order.toString();
                                                                        let log_error = "";
                                                                        let log_message = ddata.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                                        let log_result = JSON.stringify(ddata).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                                        obj.prepare();
                                                                        obj.execute((error, result) => { });
                                                                    }
                                                                });
                                                                // To submit the number on OSR
                                                                /* if (sdata.CampaignId && types == "NN") {
                                                                    let osr = new OsrApi(this.priority, this.sessdata)
                                                                    osr.updateNumber(req, res, did_data.insertId, (error, responce) => { })
                                                                }
                                                                else { */
                                                                let obj0 = new RawView_1.RawView(res);
                                                                obj0.prepare({
                                                                    error_code: 1,
                                                                    status: 201,
                                                                    message: "DID buy successfully.",
                                                                    result: [
                                                                        {
                                                                            "did": Did
                                                                        }
                                                                    ]
                                                                });
                                                                obj0.execute();
                                                                /*  } */
                                                            });
                                                        }
                                                        else {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({
                                                                error_code: 0,
                                                                status: 502,
                                                                message: "Something went wrong with connection!"
                                                            });
                                                            obj.execute();
                                                        }
                                                    });
                                                }
                                                // If order failed
                                                else {
                                                    let providerOrderId = typeof data.id != 'undefined' && data.id ? data.id : '';
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + Did + "', '4', '" + types + "', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        // To update the other data on current order
                                                        if (did_err == 1) {
                                                            let id_order = did_data.insertId;
                                                            let orderID = "SORD" + id_order.toString();
                                                            let log_error = JSON.stringify(ddata).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                            let log_message = ddata.message.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                            let log_result = "";
                                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + ddata.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                            obj.prepare();
                                                            obj.execute((error, result) => { });
                                                        }
                                                    });
                                                    // To update the status of group order
                                                    let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";";
                                                    objk.prepare();
                                                    objk.execute((error, result) => {
                                                        console.log("Failed");
                                                    });
                                                    // let objn = new ModelRawNonQuery(req, res);
                                                    // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + parseBody(response.body) + "')"
                                                    // objn.prepare();
                                                    // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                                    //     console.log("DID Buy failed from provider");
                                                    // });
                                                    let logPayload = {
                                                        funDetail: {
                                                            tableName: 'did_log',
                                                            functionName: 'buyDID',
                                                            logName: 'DID'
                                                        },
                                                        data: {
                                                            account_id: this.sessdata.idaccount,
                                                            did: sdata.DID.trim(),
                                                            iduser: this.sessdata.iduser,
                                                            full_log: response.body,
                                                            description: 'DID Buy failed from provider',
                                                            event_type: '40'
                                                        }
                                                    };
                                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                        console.log("DID Buy failed from provider");
                                                    });
                                                    let objV = new RawView_1.RawView(res);
                                                    objV.prepare({
                                                        error_code: 0,
                                                        status: ddata.code,
                                                        message: ddata.message,
                                                        error: ddata
                                                    });
                                                    objV.execute();
                                                }
                                            }
                                            else {
                                                callback(error, '');
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: Thinq->buyDID::", e);
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with DID Buy!"
                                            });
                                            obj.execute();
                                        }
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({
                                            error_code: 0,
                                            status: 502,
                                            message: "Something went wrong with DID Buy!"
                                        });
                                        obj.execute();
                                    }
                                });
                            }
                            // If order failed
                            else {
                                let providerOrderId = typeof data.id != 'undefined' && data.id ? data.id : '';
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + Did + "', '4', '" + types + "', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                obj.prepare();
                                obj.execute((did_err, did_data) => {
                                    // To update the other data on current order
                                    if (did_err == 1) {
                                        let id_order = did_data.insertId;
                                        let orderID = "SORD" + id_order.toString();
                                        let log_error = JSON.stringify(data).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                        let log_message = data.message.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                        let log_result = "";
                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + data.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                        obj.prepare();
                                        obj.execute((error, result) => { });
                                    }
                                });
                                // To update the status of group order
                                let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";";
                                objk.prepare();
                                objk.execute((error, result) => {
                                    console.log("Failed");
                                });
                                // let objn = new ModelRawNonQuery(req, res);
                                // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + parseBody(response.body) + "')"
                                // objn.prepare();
                                // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                //     console.log("DID Buy failed from provider");
                                // });
                                let logPayload = {
                                    funDetail: {
                                        tableName: 'did_log',
                                        functionName: 'buyDID',
                                        logName: 'DID'
                                    },
                                    data: {
                                        account_id: this.sessdata.idaccount,
                                        did: sdata.DID.trim(),
                                        iduser: this.sessdata.iduser,
                                        full_log: response.body,
                                        description: 'DID Buy failed from provider',
                                        event_type: '40'
                                    }
                                };
                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    console.log("DID Buy failed from provider");
                                });
                                let objV = new RawView_1.RawView(res);
                                objV.prepare({
                                    error_code: 0,
                                    status: data.code,
                                    message: data.message,
                                    error: data
                                });
                                objV.execute();
                            }
                        }
                        else {
                            console.log("Thinq->buyDID::");
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 502, message: "Something went wrong with DID buy!" });
                            obj.execute();
                        }
                    }
                    catch (e) {
                        console.log("Error :: Thinq->buyDID::", e);
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({
                            error_code: 0,
                            status: 502,
                            message: "Something went wrong!"
                        });
                        obj.execute();
                    }
                }
                else {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 400,
                        error: error
                    });
                    obj.execute();
                }
            });
        });
    }
    disconnectDID(req, res, payload, userPayLoad, callback) {
        let sdata = req.body;
        var options = {
            'method': 'POST',
            // 'url': 'https://api.thinq.com/account/15080/origination/disconnect',
            'url': ThinQRecords.ThinQDisConnt,
            'headers': {
                'Content-Type': 'application/json',
                //'Authorization': 'Basic ' + this.key
                'Authorization': 'Basic ' + ThinQRecords.ThinQKEY
            },
            body: JSON.stringify({
                "dids": [sdata.DID.trim()]
            })
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                        let data = JSON.parse(response.body);
                        if (data.status == "completed" || data.code == 403) {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE TRIM(`did`)=" + sdata.DID.trim() + " AND `account_id`='" + userPayLoad.idaccount + "'";
                            obj.prepare();
                            obj.execute((error, resp) => {
                                if (error == 1) {
                                    // To  update updated_at date in did log
                                    // let obj = new ModelRawNonQuery(req, res);
                                    // obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                                    // obj.prepare();
                                    // obj.execute((errorDiDLg: any, resDiDLg: any) => { });
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'did_log',
                                            functionName: 'disconnectDID',
                                            logName: 'DID'
                                        },
                                        data: {
                                            account_id: userPayLoad.idaccount,
                                            did: sdata.DID.trim(),
                                            iduser: userPayLoad.iduser,
                                            full_log: response.body,
                                            description: 'Disconnect DID from provider',
                                            event_type: '5'
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { });
                                    if (payload.campaign !== null && payload.campaign !== undefined && payload.campaign) {
                                        let osr = new Osr_1.OsrApi('', this.sessdata);
                                        osr.deleteNumber(req, res, 'disconnectDID', userPayLoad, (error, resp) => {
                                            console.log("Response from SMS Disable Facility ", resp);
                                        });
                                    }
                                    else {
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='0' WHERE account_id = '" + userPayLoad.idaccount + "' AND TRIM(`did`)=" + sdata.DID.trim() + "";
                                        obj1.prepare();
                                        obj1.execute((err1, resp1) => {
                                            console.log("DID Disconnected");
                                        });
                                        console.log("No Campaign found on this Number");
                                    }
                                    let pAyLoad = {
                                        idaccount: userPayLoad.idaccount,
                                        did: sdata.DID.trim()
                                    };
                                    insertdid.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                                        if (erroR == 1) {
                                            console.log("Deleted Successfully");
                                        }
                                        else {
                                            console.log("Deleted Not Successfully", resulT.message);
                                        }
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something went wrong with connection" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            // let objn = new ModelRawNonQuery(req, res);
                            // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'39','DID disconnect failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                            // objn.prepare();
                            // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                            //     console.log("DID disconnect failed FROM provider");
                            // });
                            let logPayload = {
                                funDetail: {
                                    tableName: 'did_log',
                                    functionName: 'disconnectDID',
                                    logName: 'DID'
                                },
                                data: {
                                    account_id: userPayLoad.idaccount,
                                    did: sdata.DID.trim(),
                                    iduser: userPayLoad.iduser,
                                    full_log: response.body,
                                    description: 'DID disconnect failed from provider',
                                    event_type: '39'
                                }
                            };
                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                console.log("DID disconnect failed FROM provider");
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: data.code, message: data.message });
                            objv.execute();
                        }
                    }
                    else {
                        console.log("Thinq->disconnectDID");
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 402, message: "Something went wrong with disconnect DID!" });
                        objv.execute();
                    }
                }
                catch (e) {
                    console.log("Error :: Thinq->disconnectDID::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                console.log("ThinQ :::::::::::::::::::");
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                objv.execute();
            }
        });
    }
}
exports.ThinQAPI = ThinQAPI;
