"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationSystem = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
// import { AppRoute } from "../lib/AppRoute";
const setting_config_1 = require("../config/setting.config");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const markError_1 = require("./markError");
// const socketSetting = new SocketIO();
// const request = require("request");
const APIBase_1 = require("./APIBase");
let validuser = new APIBase_1.APIBase();
const EmailNotify = new setting_config_1.EmailNotification();
class NotificationSystem {
    constructor() {
        // super();
    }
    Statuslist(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `title`,`cs_id` FROM `notification_customer_status` WHERE `show_status`='1'";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Customer Status Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    CategorieslistAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `title`,`nec_id` FROM `notification_email_category`  WHERE `show_status`='1'";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Category Fetched Successfully!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    CategorieslistCust(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `title`,`nec_id` FROM `notification_email_category` ORDER BY `title` ASC";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Customer Category Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    // SaveNotifyEmail(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((err: any, sessdata: any) => {
    //         if (err == 1) {
    //             if (sessdata.type == 1) {
    //                 let key = Math.random().toString(36).slice(2);
    //                 let sdata = JSON.parse(req.body.data);
    //                 const filenames = (req.files as Express.Multer.File[]).map(file => EmailNotify.emailnotify + file.filename);
    //                 const concatenatedFilenames = filenames.join(';');
    //                 let obj0 = new ModelRawNonQuery(req, res);
    //                 let qry0 = "INSERT INTO `email_send`(`iduser`, `idaccount`,`to`,`from`,`subject`,`text`,`html`,`type`,`status`,`file`,`cc`,`bcc`) VALUES ";
    //                 for (let i = 0; i < sdata.newdata.length; i++) {
    //                     let entry1 = sdata.newdata[i];
    //                     qry0 += "('" + entry1.iduser + "','" + entry1.idaccount + "','" + entry1.email.trim() + "','" + sdata.data.from + "','" + parseBody(sdata.data.subject) + "','Email Notification System', '" + parseBody(sdata.data.body) + "','Email Notification System','17','" + concatenatedFilenames + "','" + sdata.data.cc + "','" + sdata.data.bcc + "'),"
    //                 }
    //                 obj0.nonqrysql = qry0.slice(0, -1)
    //                 obj0.prepare();
    //                 obj0.execute((_error: any, result: any) => {
    //                     console.log("Data Inserted Successfully!");
    //                 });
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 let qry = "INSERT INTO `notification_email` (`iduser`, `idaccount`,`to`,`from`,`cs_id`,`nec_id`,`cc`,`bcc`,`subject`,`description`,`file`,`view_status`,`key`) VALUES ";
    //                 for (let i = 0; i < sdata.newdata.length; i++) {
    //                     let entry = sdata.newdata[i];
    //                     qry += "('" + entry.iduser + "','" + entry.idaccount + "','" + entry.email.trim() + "','" + sdata.data.from + "','" + sdata.data.status + "','" + sdata.data.categories + "','" + sdata.data.cc + "','" + sdata.data.bcc + "','" + parseBody(sdata.data.subject) + "','" + parseBody(sdata.data.body) + "','" + concatenatedFilenames + "','0','" + key + "'),";
    //                 }
    //                 obj.nonqrysql = qry.slice(0, -1)
    //                 obj.prepare();
    //                 obj.execute((_error: any, result: any) => {
    //                     console.log("data inserted successfully!");
    //                     if (_error == 1) {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ message: "Mail Sent Successfully!", status: 201 });
    //                         objv.execute();
    //                     } else {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ message: "Something Went Wrong!", status: 502 });
    //                         objv.execute();
    //                     }
    //                 });
    //             } else {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ message: "Service Unavailable", status: 502 });
    //                 objv.execute();
    //             }
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    SaveNotifyEmail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let key = Math.random().toString(36).slice(2);
                        let sdata = JSON.parse(req.body.data);
                        const filenames = req.files.map(file => EmailNotify.emailnotify + file.filename);
                        const concatenatedFilenames = filenames.join(';');
                        let data = [];
                        let dataid = [];
                        let data2 = [];
                        let data1 = [];
                        for (let i = 0; i < sdata.newdata.length; i++) {
                            let entry1 = sdata.newdata[i];
                            data.push(entry1.iduser);
                            dataid.push(entry1.idaccount);
                        }
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `iduser`,`firstname`,`lastname`,`email`,`phone` FROM `user_profile` WHERE `iduser` IN (" + data + ")";
                        obj1.prepare();
                        obj1.execute((errr, resp) => {
                            if (errr == 1) {
                                data1.push(resp);
                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `idaccount`,`balance`,`min_balance`,`topup_amount` FROM `wallet` WHERE `idaccount` IN (" + dataid + ")";
                                obj2.prepare();
                                obj2.execute((err, resp) => {
                                    if (err == 1) {
                                        data2.push(resp);
                                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qry0 = "INSERT INTO `email_send`(`iduser`, `idaccount`,`to`,`from`,`subject`,`text`,`html`,`type`,`status`,`file`,`cc`,`bcc`) VALUES ";
                                        for (let i = 0; i < sdata.newdata.length; i++) {
                                            let entry1 = sdata.newdata[i];
                                            let tmpDataSup = sdata.data.body;
                                            let resp1Entry = data1[0].find((respEntry) => respEntry.iduser === entry1.iduser);
                                            let resp2Entry = data2[0].find((respEntry) => respEntry.idaccount === entry1.idaccount);
                                            if (resp1Entry || resp2Entry) {
                                                let san = Math.floor(Math.floor(100000000) + Math.floor(entry1.idaccount));
                                                tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.firstname ? resp1Entry.firstname : '');
                                                tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.email ? resp1Entry.email : '');
                                                tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.lastname ? resp1Entry.lastname : '');
                                                tmpDataSup = tmpDataSup.replace(/{CONTACT}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.phone ? resp1Entry.phone : '');
                                                tmpDataSup = tmpDataSup.replace(/{BALANCE}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.balance ? resp2Entry.balance : 0);
                                                tmpDataSup = tmpDataSup.replace(/{TOPUP_AMOUNT}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.topup_amount ? resp2Entry.topup_amount : 0);
                                                tmpDataSup = tmpDataSup.replace(/{MINIMUM_BALANCE}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.min_balance ? resp2Entry.min_balance : 0);
                                                tmpDataSup = tmpDataSup.replace(/{SAN}/g, san);
                                            }
                                            qry0 += "('" + entry1.iduser + "','" + entry1.idaccount + "','" + (0, markError_1.parseBody)(entry1.email.trim()) + "','" + sdata.data.from + "','" + (0, markError_1.parseBody)(sdata.data.subject) + "','Email Notification System', '" + (0, markError_1.parseBody)(tmpDataSup) + "','Email Notification System','17','" + concatenatedFilenames + "','" + (0, markError_1.parseBody)(sdata.data.cc) + "','" + (0, markError_1.parseBody)(sdata.data.bcc) + "'),";
                                        }
                                        obj0.nonqrysql = qry0.slice(0, -1);
                                        obj0.prepare();
                                        obj0.execute((_error, result) => {
                                            console.log("Data Inserted Successfully!");
                                        });
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qry = "INSERT INTO `notification_email` (`iduser`, `idaccount`,`to`,`from`,`cs_id`,`nec_id`,`cc`,`bcc`,`subject`,`admin_body`,`file`,`view_status`,`key`,`description`) VALUES ";
                                        for (let i = 0; i < sdata.newdata.length; i++) {
                                            let entry = sdata.newdata[i];
                                            let tmpDataSup = sdata.data.body;
                                            let resp1Entry = data1[0].find((respEntry) => respEntry.iduser === entry.iduser);
                                            let resp2Entry = data2[0].find((respEntry) => respEntry.idaccount === entry.idaccount);
                                            if (resp1Entry || resp2Entry) {
                                                let san = Math.floor(Math.floor(100000000) + Math.floor(entry.idaccount));
                                                tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.firstname ? resp1Entry.firstname : '');
                                                tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.email ? resp1Entry.email : '');
                                                tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.lastname ? resp1Entry.lastname : '');
                                                tmpDataSup = tmpDataSup.replace(/{CONTACT}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.phone ? resp1Entry.phone : '');
                                                tmpDataSup = tmpDataSup.replace(/{BALANCE}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.balance ? resp2Entry.balance : 0);
                                                tmpDataSup = tmpDataSup.replace(/{TOPUP_AMOUNT}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.topup_amount ? resp2Entry.topup_amount : 0);
                                                tmpDataSup = tmpDataSup.replace(/{MINIMUM_BALANCE}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.min_balance ? resp2Entry.min_balance : 0);
                                                tmpDataSup = tmpDataSup.replace(/{SAN}/g, san);
                                            }
                                            qry += "('" + entry.iduser + "','" + entry.idaccount + "','" + (0, markError_1.parseBody)(entry.email.trim()) + "','" + sdata.data.from + "','" + sdata.data.status + "','" + sdata.data.categories + "','" + (0, markError_1.parseBody)(sdata.data.cc) + "','" + (0, markError_1.parseBody)(sdata.data.bcc) + "','" + (0, markError_1.parseBody)(sdata.data.subject) + "','" + (0, markError_1.parseBody)(sdata.data.body) + "','" + concatenatedFilenames + "','0','" + key + "','" + (0, markError_1.parseBody)(tmpDataSup) + "'),";
                                            // let obj0 = new ModelRawQuery(req, res);
                                            // obj0.qrysql = "SELECT `authkey` FROM `session` where `idaccount` = '"+ entry.idaccount +"' ORDER BY `id` DESC LIMIT 1";
                                            // obj0.prepare();
                                            // obj0.execute((errs: any, result: any) => {
                                            //   if(errs == 1 && result.length > 0){
                                            //         request({
                                            //             url: socketSetting.socket_url+'/send-notification', //on 3000 put your port no.
                                            //             method: 'POST',
                                            //             'headers': {
                                            //                 'Content-Type': 'application/json',
                                            //                 'Authorization': result[0].authkey
                                            //             },
                                            //             json: {
                                            //                 auth: result[0].authkey,
                                            //                 count:1,
                                            //                 title:parseBody(sdata.data.subject)
                                            //             }
                                            //         }, function (error:any, response:any, body:any) {
                                            //             console.log("send email notification");
                                            //         });
                                            //   }
                                            //     else{
                                            //     console.log("sendNotification:: Record Not Found");
                                            //     } 
                                            // })
                                        }
                                        obj.nonqrysql = qry.slice(0, -1);
                                        obj.prepare();
                                        obj.execute((_error, result) => {
                                            console.log("data inserted successfully!");
                                            if (_error == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Mail Sent Successfully!", status: 201 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Wallet Details Not Found!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Record Not Found!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    get_emailNotification(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let condition = '';
                if (sessdata.type == 1)
                    condition += '';
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition += "WHERE idaccount='" + sessdata.idaccount + "'";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`,`idaccount`,`from`,`key`,`cs_id`,`to`,`nec_id`,`subject`,`view_status`,`admin_body`,`description`,`created_at` FROM `notification_email`" + condition + " ORDER BY `created_at` DESC LIMIT 2000";
                obj.prepare();
                obj.execute((_err, result) => {
                    if (_err == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Email Notification Fetched!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    get_singlemailNotify(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sdata = req.query;
                let condition = '';
                if (sessdata.type == 1)
                    condition = "WHERE `key`='" + sdata.type + "'";
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition += " WHERE `key`='" + sdata.type + "' AND idaccount='" + sessdata.idaccount + "'";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`,`idaccount`,`from`,`to`,`cc`,`bcc`,`subject`,`description`,`admin_body`,`file` FROM `notification_email`" + condition + "";
                obj.prepare();
                obj.execute((_err, result) => {
                    if (_err == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Notification Detail Fetched!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    NotifyCustomerList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT up.`firstname`,up.`lastname`,nm.`idaccount`,nm.`iduser`,nm.`to` FROM user_profile up JOIN `notification_email` nm ON up.`iduser` = nm.`iduser` WHERE nm.`key`='" + sdata.type + "'";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Notified Customers List Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    SaveCustomerMail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = JSON.parse(req.body.data);
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `notification_subscriber_email` (`iduser`, `idaccount`, `nec_id`, `email`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.nec_id + "', '" + (0, markError_1.parseBody)(sdata.Email_ID) + "')";
                        obj1.prepare();
                        obj1.execute((errors, result) => {
                            if (errors == 1) {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ status: 201, message: "Email Inserted Successfully!" });
                                objv0.execute();
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session you are trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    UpdateCustomerMail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = JSON.parse(req.body.data);
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `notification_subscriber_email` SET `email` = '" + (0, markError_1.parseBody)(sdata.Email_ID) + "' WHERE idaccount = '" + sessdata.idaccount + "' AND nec_id = '" + sdata.nec_id + "'";
                        obj1.prepare();
                        obj1.execute((errors, result) => {
                            if (errors == 1) {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ status: 201, message: "Email Updated Successfully!" });
                                objv0.execute();
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session you are trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    ToEmailList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `idaccount`,`iduser`,`email`,`nec_id` FROM `notification_subscriber_email`";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Customer Subscriber Email Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    UpdateStatusViewEmail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = JSON.parse(req.body.data);
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `notification_email` SET `view_status` = 1 WHERE `key` = '" + sdata.key + "' AND `to` = '" + (0, markError_1.parseBody)(sdata.email) + "' AND `idaccount` = " + sessdata.idaccount;
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Status Updated successfully!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session you are trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    get_emailsubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser`,`idaccount`,`nec_id`,`email` FROM `notification_subscriber_email` WHERE `idaccount`='" + sessdata.idaccount + "'";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Email Subscription Detail Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    NotificationCountList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `subject`,`created_at`,`key`,`view_status`,`to` FROM `notification_email` WHERE `idaccount` ='" + sessdata.idaccount + "' AND `view_status` =0  ORDER BY `created_at` DESC";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Email Notification List Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    viewNotification(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errorrr, sessData) => {
            if (errorrr == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT ncs.cs_id , ns.description ,GROUP_CONCAT(idaccount) AS idaccount, ns.created_at , ns.view_status , ns.title AS ns_title, ncs.title AS ncs_title, ns.admin_body FROM notification_system ns JOIN notification_customer_status ncs ON ncs.cs_id = ns.cs_id GROUP BY ns.ns_key ORDER BY ns.ns_id DESC";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Notification data Fetch Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetching Notification Data !", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    displayNotificationForCustomer(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errorrr, sessData) => {
            if (errorrr == 1) {
                let sdata = req.body.data;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `title`, `description` ,`ns_key`, `created_at`,`view_status` FROM `notification_system` WHERE `idaccount` ='" + sessData.idaccount + "'";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Notification data Fetch Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetching Notification Data !", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    NotificationCountForCustomer(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errorrr, sessData) => {
            if (errorrr == 1) {
                let sdata = req.body.data;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `title`, `description` ,`ns_key`, `created_at` FROM `notification_system` WHERE `idaccount` ='" + sessData.idaccount + "' AND `view_status` =0";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Notification data Fetch Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetching Notification Data !", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UpdateViewNotificationStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errorrr, sessData) => {
            if (errorrr == 1) {
                let keys = req.body.data;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `notification_system` set `view_status` = 1 WHERE idaccount ='" + sessData.idaccount + "' AND `ns_key` ='" + keys + "'";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Update Notification Count Status Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With 'Update Notification Count Status !", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSystemNotificationStatus(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1_2(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT cs_id, title, show_status FROM `notification_customer_status` where `show_status` = '1'";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Notification Status Fetched!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // public sendNotification(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         let qry: any = "";
    //         if (error == 1) {
    //             if (sessdata.type == 1) {
    //                 let sdata = req.body.data;
    //                 let key = Math.random().toString(36).slice(2);
    //                 let status = sdata.status[0].combinedData.split('-');
    //                 let CSID = status[0];
    //                 // let viewStatus = status[1];
    //                 qry = "INSERT INTO `notification_system` (`iduser`,`idaccount`,`cs_id`,`title`,`description`,`ns_key`) VALUES";
    //                 sdata.customers.forEach((ele: any) => {
    //                     let numbersArray = ele.combinedId.split('-');
    //                     let Idaccount = numbersArray[0];
    //                     let Iduser = numbersArray[1];
    //                     qry += "('" + Iduser + "','" + Idaccount + "','" + CSID + "','" + parseBody(sdata.title) + "','" + parseBody(sdata.body) + "','" + key + "'),";
    //                 });
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 obj.nonqrysql = qry.slice(0, -1);
    //                 obj.prepare();
    //                 obj.execute((_err: any, data: any) => {
    //                     if (_err == 1) {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ message: "Notification Send Successfully!", status: 201 });
    //                         objv.execute();
    //                     }
    //                     else {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
    //                         objv.execute();
    //                     }
    //                 });
    //             }
    //         }
    //     });
    // }
    sendNotification(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        let key = Math.random().toString(36).slice(2);
                        let status = sdata.status[0].combinedData.split('-');
                        let CSID = status[0];
                        let data = [];
                        let dataid = [];
                        let data1 = [];
                        let data2 = [];
                        for (let i = 0; i < sdata.customers.length; i++) {
                            let entry1 = sdata.customers[i];
                            let numbersArray = entry1.combinedId.split('-');
                            let Idaccount = numbersArray[0];
                            let Iduser = numbersArray[1];
                            data.push(Iduser);
                            dataid.push(Idaccount);
                        }
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `iduser`,`firstname` ,`lastname`, `email` ,`phone` FROM `user_profile` WHERE `iduser` IN (" + data + ")";
                        obj1.prepare();
                        obj1.execute((errr, resp) => {
                            if (errr == 1) {
                                data1.push(resp);
                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `idaccount`,`balance`,`min_balance`,`topup_amount` FROM `wallet` WHERE `idaccount` IN (" + dataid + ")";
                                obj2.prepare();
                                obj2.execute((err, resp) => {
                                    if (err == 1) {
                                        data2.push(resp);
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qry = "INSERT INTO `notification_system` (`iduser`,`idaccount`,`cs_id`,`title`,`description`,`admin_body`,`ns_key`) VALUES ";
                                        for (let i = 0; i < sdata.customers.length; i++) {
                                            let entry1 = sdata.customers[i];
                                            let numbersArray = entry1.combinedId.split('-');
                                            let Idaccount = numbersArray[0];
                                            let Iduser = numbersArray[1];
                                            let tmpDataSup = sdata.body.replace(/\n/g, '\n ');
                                            let resp1Entry = data1[0].find((respEntry) => respEntry.iduser == Iduser);
                                            let resp2Entry = data2[0].find((respEntry) => respEntry.idaccount == Idaccount);
                                            if (resp1Entry || resp2Entry) {
                                                let san = Math.floor(Math.floor(100000000) + Math.floor(Idaccount));
                                                tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.firstname ? resp1Entry.firstname : '');
                                                tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.email ? resp1Entry.email : '');
                                                tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.lastname ? resp1Entry.lastname : '');
                                                tmpDataSup = tmpDataSup.replace(/{CONTACT}/g, resp1Entry !== 'undefined' && resp1Entry !== undefined && resp1Entry.phone ? resp1Entry.phone : '');
                                                tmpDataSup = tmpDataSup.replace(/{BALANCE}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.balance ? resp2Entry.balance : 0);
                                                tmpDataSup = tmpDataSup.replace(/{TOP_UP_AMOUNT}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.topup_amount ? resp2Entry.topup_amount : 0);
                                                tmpDataSup = tmpDataSup.replace(/{MINIMUM_BALANCE}/g, resp2Entry !== 'undefined' && resp2Entry !== undefined && resp2Entry.min_balance ? resp2Entry.min_balance : 0);
                                                tmpDataSup = tmpDataSup.replace(/{SAN}/g, san);
                                            }
                                            qry += "('" + Iduser + "','" + Idaccount + "','" + CSID + "','" + (0, markError_1.parseBody)(sdata.title) + "','" + (0, markError_1.parseBody)(tmpDataSup) + "', '" + (0, markError_1.parseBody)(sdata.body.replace(/\n/g, '\n ')) + "', '" + key + "'),";
                                            // let obj0 = new ModelRawQuery(req, res);
                                            // obj0.qrysql = "SELECT `authkey` FROM `session` where `idaccount` = '"+ Idaccount +"' ORDER BY `id` DESC LIMIT 1";
                                            // obj0.prepare();
                                            // obj0.execute((errs: any, result: any) => {
                                            //     if(errs == 1 && result.length > 0 && result[0] && result[0]?.authkey){
                                            //         request({
                                            //         url: socketSetting.socket_url+'/send-notification', //on 3000 put your port no.
                                            //         method: 'POST',
                                            //         'headers': {
                                            //             'Content-Type': 'application/json',
                                            //             'Authorization': result[0]?.authkey
                                            //         },
                                            //         json: {
                                            //             auth: result[0].authkey,
                                            //             count:1,
                                            //             title:sdata.title
                                            //         }
                                            //      }, function (error:any, response:any, body:any) {
                                            //         console.log("Notification send");
                                            //      });
                                            //     }
                                            //     else{
                                            //     console.log("sendNotification:: Record Not Found");
                                            //     }
                                            // })
                                        }
                                        obj.nonqrysql = qry.slice(0, -1);
                                        obj.prepare();
                                        obj.execute((_error, result) => {
                                            console.log("data inserted successfully!");
                                            if (_error == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Notification Sent Successfully!", status: 201 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Wallet Details Not Found!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Record Not Found!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _406_1.Res406(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
        });
    }
    EmailSubscriptionMail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `email` FROM `user_profile` Where `iduser` ='" + sessdata.iduser + "'";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Customer Email Fetched!", status: 201, data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
}
exports.NotificationSystem = NotificationSystem;
