"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwaggerApi = void 0;
const Session_1 = require("../lib/model/Session");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const _406_1 = require("../lib/view/406");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const numberApi_1 = require("./numberApi");
const APIBase_1 = require("./APIBase");
const markError_1 = require("./markError");
let validuser = new APIBase_1.APIBase();
const request = require("request");
const Str = require('@supercharge/strings');
const makeNumber = (length) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeChar = (length) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeRanChar = (length) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const generatePassword = () => {
    let result = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
};
class SwaggerApi {
    constructor() {
    }
    BuyTollfree(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                validuser.checksessionvalid2_22_201_202(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = req.query ?? req.body.data;
                        let Quantity = sdata.Quantity ?? req.body.data;
                        let message = "";
                        switch (true) {
                            case (!sdata || sdata == '' || sdata == 'null' || sdata == 'undefined'):
                                message = "Missing parameter: Quantity!";
                                break;
                            case (!Quantity || Quantity == '' || Quantity == 'null' || Quantity == 'undefined'):
                                message = "Quantity is required!";
                                break;
                            case (!/^[1-9]\d*$/.test(Quantity)):
                                message = "Quantity must be an integer and greater than or equal to 1!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 507, message: message });
                            objv.execute();
                        }
                        else {
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT e.idendpoint, e.connection_key, i.inbound_key, o.outbound_key FROM `endpoint` e JOIN `inbound` i ON e.idendpoint = i.idendpoint JOIN `outbound` o ON e.idendpoint = o.idendpoint WHERE e.`isDefault`='true' AND e.`iduser`= '" + sessdata.iduser + "'";
                            obj0.prepare();
                            obj0.execute((connErr, connRes) => {
                                if (connErr == 1) {
                                    let quantity = Quantity;
                                    let fun = new numberApi_1.Number();
                                    fun.prorationGet(req, res, 'TF', 0, sessdata.idtariff, (error, proration) => {
                                        if (error == 1) {
                                            let rate = new APIBase_1.APIBase();
                                            rate.getRate(req, res, sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                                                rate.prorateCalculator(req, res, proration.proration, voice_rate[0].rate, proration.setup_cost, (pc_err, prorate1) => {
                                                    if (pc_err == 1) {
                                                        let fullrates = parseFloat(voice_rate[0].rate) + parseFloat(proration.setup_cost);
                                                        let prorate = typeof prorate1 != 'undefined' && prorate1 > 0 ? prorate1 : 0;
                                                        let RateS = (parseFloat(prorate) * quantity).toFixed(3);
                                                        rate.checkBalance(req, res, sessdata.idaccount, RateS, (walletError, wallet) => {
                                                            if (walletError == 1) {
                                                                let connKey = connRes.length > 0 ? connRes[0].connection_key : '';
                                                                let inbounKey = connRes.length > 0 ? connRes[0].inbound_key : '';
                                                                let outboundKey = connRes.length > 0 ? connRes[0].outbound_key : '';
                                                                let GOpayload = {
                                                                    name: "SOD" + String(new Date().getTime()),
                                                                    total_dids: Quantity,
                                                                    numbers: '',
                                                                    routing: connKey,
                                                                    in_routing: inbounKey,
                                                                    out_routing: outboundKey,
                                                                    campaign: '',
                                                                    sessdata: sessdata
                                                                };
                                                                let swag = new SwaggerApi();
                                                                swag.CreateGroupOrder(req, res, GOpayload, (error, response) => {
                                                                    if (error == 1) {
                                                                        let groupID = response.data.id_grouporder;
                                                                        let numberapi = new numberApi_1.Number();
                                                                        numberapi.BuyTollfreeNumber(req, res, groupID, err => {
                                                                            if (err == 0) {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: "200", message: "Tollfree Order Created Successfully!" });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 503, message: "Service Unavailable!" });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 201, message: "Group Order is not Created!" });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    error_code: 0,
                                                                    error: walletError,
                                                                    message: "You have insufficient funds in your account. Kindly add funds to your account!",
                                                                    status: 503
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            error_code: 0,
                                                            error: 'Wallet Issue',
                                                            message: "Something Went Wrong to Fetch Account Balance.",
                                                            status: 503
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 1,
                            status: 404,
                            message: "Not Permitted"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    CreateGroupOrder(req, res, GOpayload, callback) {
        let checkService = new APIBase_1.APIBase();
        checkService.serviceActivation(req, res, GOpayload.sessdata, "5", (err, resp) => {
            if (resp.status == 200) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let totalDID = GOpayload.total_dids;
                let process_dids = 0;
                obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + GOpayload.sessdata.iduser + ", idaccount=" + GOpayload.sessdata.idaccount + ", name='" + GOpayload.name + "', total_dids=" + (0, markError_1.setToZero)(totalDID) + ", process_dids=" + (0, markError_1.setToZero)(process_dids) + ", numbers='" + GOpayload.numbers + "', routing='" + GOpayload.routing + "', in_routing='" + GOpayload.in_routing + "', out_routing='" + GOpayload.out_routing + "', campaign='" + GOpayload.campaign + "';";
                obj.prepare();
                obj.execute((error, result) => {
                    callback(1, {
                        status: 202,
                        message: "Group successfully created.",
                        data: {
                            id_grouporder: result.insertId
                        }
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error: 1,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "DID Buy")
                });
                objv.execute();
            }
        });
    }
}
exports.SwaggerApi = SwaggerApi;
