"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Twillio = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const setting_config_1 = require("../config/setting.config");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
const numberApi_1 = require("./numberApi");
let insertdid = new APIBase_1.APIBase();
const twilio = new setting_config_1.Twilio();
const crypto = require('crypto');
const SMTP = new setting_config_1.SMTPDetails();
var request = require('request');
class Twillio extends APIBase_1.APIBase {
    sessdata;
    constructor(sessdata) {
        super();
        this.sessdata = sessdata;
    }
    createSubaccount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession(async (sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                insertdid.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let twilioFile = new Twillio(sessData);
                        const timestamp = new Date().toISOString().replace(/[-:TZ.]/g, '').slice(0, 14);
                        const uniqueFriendlyName = `${sessData.username}_${timestamp}`;
                        const sdata = JSON.parse(req.body.data);
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessData.iduser,
                            idaccount: sessData.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let funDetail = {
                            tableName: 'did_log',
                            functionName: 'createSubaccount',
                            logName: 'DID'
                        };
                        const options = {
                            method: 'POST',
                            url: `${twilio.accounturl}/Accounts.json`,
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded',
                                'Accept': 'application/json'
                            },
                            auth: {
                                user: twilio.Username,
                                pass: twilio.Password
                            },
                            form: {
                                FriendlyName: uniqueFriendlyName,
                            }
                        };
                        console.log("createSubaccount Request :: ", options);
                        request(options, async (error, response) => {
                            try {
                                let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                console.log("Twilio createSubaccount response.body :: ", response.body);
                                if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                    let data = JSON.parse(response.body);
                                    console.log("createSubaccount Response :: ", data);
                                    if (data.sid) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='" + data.sid + "',`provider`='1' WHERE `unique_request_id`='" + sdata.request_id + "' AND `idaccount`='" + sessData.idaccount + "'";
                                        obj.prepare();
                                        obj.execute((err5, resp5) => { });
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `twillio_subaccount` (`sid`,`friendly_name`,`status`,`auth_token`,`date_created`,`date_updated`,`owner_account_sid`,`uri`,`subresource_uris`,`full_res`) VALUES ('" + data.sid + "','" + data.friendly_name + "','" + data.status + "','" + data.auth_token + "','" + data.date_created + "','" + data.date_updated + "','" + data.owner_account_sid + "','" + data.uri + "','" + JSON.stringify(data.subresource_uris) + "','" + combinedLog + "')";
                                        obj1.prepare();
                                        obj1.execute((err5, resp5) => {
                                            if (err5 == 1) {
                                                let sesdata = {
                                                    idaccount: sessData.idaccount,
                                                    iduser: sessData.iduser,
                                                    id: sdata.request_id,
                                                    sid: data.sid /* sub account SID */
                                                };
                                                let twillio = new Twillio(sessData);
                                                twillio.getSecretSubaccount(req, res, next, data, sdata.DID.trim(), resp5.insertId, sdata.request_id, async (errr, resp1) => {
                                                    if (errr == 1) {
                                                        await twillio.movenumbermain2sub(req, res, next, data, sdata.request_id, sdata.incoming_phone_number_sid, sdata.DID.trim(), async (error, resp2) => {
                                                            /* resp2.sid => verified_sendr-> subaccount_sid */
                                                            if (error == 1) {
                                                                /* resp1 -> credential of subaccount */
                                                                /* resp2 -> used for TollfreePhoneNumberSid */
                                                                await twillio.VerifyProfile(req, res, next, sdata, resp1, resp2, (err, resp) => {
                                                                    if (err == 1) {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 200, message: "SMS Enable Facility is in Process! It take 2-3 days for verification!" });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let message = (err == 2) ? resp.message : "Something Went Wrong with Verify Profile!";
                                                                        twilioFile.movenumbersub2main(req, res, next, sesdata, sdata.DID.trim(), resp1, (errr, resp) => {
                                                                            if (errr == 1) {
                                                                                twilioFile.rejectSenderstatus(req, res, next, sesdata, sdata.DID.trim(), message, (err, respp) => {
                                                                                    console.log(respp);
                                                                                });
                                                                            }
                                                                        });
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 501, message: message });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let message = (error == 2) ? resp2.message : "Something Went Wrong with main to sub moving process!";
                                                                twilioFile.SuspendSubaccount(req, res, next, sesdata, data.sid, sdata.DID.trim(), (errr, resp) => {
                                                                    if (errr == 1) {
                                                                        twilioFile.rejectSenderstatus(req, res, next, sesdata, sdata.DID.trim(), message, (err, respp) => {
                                                                            console.log(respp);
                                                                        });
                                                                    }
                                                                });
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 501, message: message });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let message = (errr == 2) ? resp1.message : "Something Went Wrong with get sub account secret !";
                                                        twilioFile.SuspendSubaccount(req, res, next, sesdata, data.sid, sdata.DID.trim(), (errr, resp) => {
                                                            if (errr == 1) {
                                                                twilioFile.rejectSenderstatus(req, res, next, sesdata, sdata.DID.trim(), message, (err, respp) => {
                                                                    console.log(respp);
                                                                });
                                                            }
                                                        });
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 501, message: message });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 502, message: "Sub Account data not saved" });
                                                objv.execute();
                                            }
                                        });
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sessData.idaccount,
                                                iduser: sessData.iduser,
                                                did: sdata.DID.trim(),
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '66',
                                                description: 'SUB Account Created',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                    }
                                    else {
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sessData.idaccount,
                                                iduser: sessData.iduser,
                                                did: sdata.DID.trim(),
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '67',
                                                description: 'SUB Account Not Created',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                        let sesdata = {
                                            idaccount: sessData.idaccount,
                                            iduser: sessData.iduser,
                                            id: sdata.request_id,
                                        };
                                        let msg = data.message !== undefined ? data.message : 'SMS is not Enabled';
                                        twilioFile.rejectSenderstatus(req, res, next, sesdata, sdata.DID.trim(), msg, (err, respp) => {
                                            console.log(respp);
                                        });
                                        console.log({ status: 501, message: "Sub Account is not created!" });
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 501, message: msg });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 501, message: "SMS is not Enabled!" });
                                    objv.execute();
                                }
                            }
                            catch (err) {
                                console.error('createSubaccount Error:', err);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 501, message: "SMS is not Enabled" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    async movenumbermain2sub(req, res, next, subaccount, requestId, phone_sid, did, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                insertdid.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let funDetail = {
                            tableName: 'did_log',
                            functionName: 'movenumbermain2sub',
                            logName: 'DID'
                        };
                        let datasess = {
                            iduser: sessData.iduser,
                            idaccount: sessData.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        // fetch phone number sid and customer sub account 
                        const options = {
                            method: 'POST',
                            url: `${twilio.accounturl}/Accounts/${twilio.Username}/IncomingPhoneNumbers/${phone_sid}.json`,
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded',
                                'Accept': 'application/json'
                            },
                            auth: {
                                user: twilio.Username,
                                pass: twilio.Password
                            },
                            form: {
                                AccountSid: subaccount.sid,
                            }
                        };
                        console.log("movenumbermain2sub Request :: ", options);
                        request(options, (error, response) => {
                            try {
                                let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                console.log("Twilio movenumbermain2sub response.body :: ", response.body);
                                if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                    let data1 = JSON.parse(response.body);
                                    console.log("movenumbermain2sub Response :: ", data1);
                                    if (data1.sid) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `did_buy` SET `order_id`='" + data1.sid + "' WHERE `did`='" + did + "' AND `account_id`='" + sessData.idaccount + "' AND `type` = 'TF'";
                                        obj.prepare();
                                        obj.execute((err5, resp5) => { });
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sessData.idaccount,
                                                iduser: sessData.iduser,
                                                did: did,
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '68',
                                                description: 'Move Number From Main Account To SUB Account',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                        /* let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='" + data1.sid + "' WHERE `unique_request_id`='" + requestId + "' AND `idaccount`='" + sessData.idaccount + "'";
                                        obj1.prepare();
                                        obj1.execute((err5, resp5) => { }); */
                                        console.log({ status: 201, message: "Number Move Succesfully", data: data1 });
                                        callback(1, data1);
                                    }
                                    else {
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sessData.idaccount,
                                                iduser: sessData.iduser,
                                                did: did,
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '69',
                                                description: 'Number Not Move From Main Account To SUB Account',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                        console.log({ status: 501, message: "Number Not Move Successfully" });
                                        callback(2, { status: data1.status, message: data1.message });
                                    }
                                }
                                else {
                                    // throw error; // Throw the error to be caught in the catch block
                                    callback(0, 'Number Not Moved succesfully');
                                    console.error('movenumbermain2sub Error:', error);
                                }
                            }
                            catch (err) {
                                console.error('movenumbermain2sub Error:', err);
                                callback(0, 'Number Not Moved succesfully');
                            }
                        });
                    }
                    else {
                        console.log(dt);
                        callback(0, dt);
                    }
                });
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    async getSecretSubaccount(req, res, next, subaccount, did, insetid, requestId, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                insertdid.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let funDetail = {
                            tableName: 'did_log',
                            functionName: 'getsecretsub',
                            logName: 'DID'
                        };
                        let datasess = {
                            iduser: sessData.iduser,
                            idaccount: sessData.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        const options = {
                            method: 'POST',
                            url: twilio.accounturl + '/Accounts/' + subaccount.sid + '/Keys.json',
                            auth: {
                                user: twilio.Username,
                                pass: twilio.Password
                            },
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded',
                                'Accept': 'application/json'
                            },
                            form: {
                                FriendlyName: subaccount.friendly_name
                            }
                        };
                        console.log("getSecretSubaccount Request :: ", options);
                        request(options, (error, response) => {
                            try {
                                let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                console.log("Twilio getSecretSubaccount Response :: ", response.body);
                                if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                    let data1 = JSON.parse(response.body);
                                    console.log("getSecretSubaccount Response data1:: ", data1);
                                    if (data1.sid) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `twillio_subaccount` SET `subaccount_secret`='" + data1.secret + "',`subaccount_sid`='" + data1.sid + "',`subaccount_key_full_res`='" + response.body + "' WHERE `subaccid`='" + insetid + "'";
                                        obj.prepare();
                                        obj.execute((err5, resp5) => { });
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sessData.idaccount,
                                                iduser: sessData.iduser,
                                                did: did,
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '75',
                                                description: 'Get Secret Subaccount',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                        /* let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='" + data1.sid + "' WHERE `unique_request_id`='" + requestId + "' AND `idaccount`='" + sessData.idaccount + "'";
                                        obj1.prepare();
                                        obj1.execute((err5, resp5) => { }); */
                                        console.log({ status: 201, message: "Get Secret SubAccount", data: data1 });
                                        callback(1, data1);
                                    }
                                    else {
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sessData.idaccount,
                                                iduser: sessData.iduser,
                                                did: did,
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '76',
                                                description: 'Failed to Get Sub Account Secret',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                        console.log({ status: 501, message: "Failed to Get Subaccount Secret" });
                                        callback(2, { status: data1.status, message: data1.message });
                                    }
                                }
                                else {
                                    // throw error; // Throw the error to be caught in the catch block
                                    callback(0, 'Failed to GEt SubAccount Secret');
                                    console.error('GEtSecretSubaccount Error:', error);
                                }
                            }
                            catch (err) {
                                console.error('GetSecretSubaccount Error:', err);
                                callback(0, 'Failed to GEt SubAccount Secret');
                            }
                        });
                    }
                    else {
                        console.log(dt);
                        callback(0, dt);
                    }
                });
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    async VerifyProfile(req, res, next, otherdata, resp, data, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                insertdid.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessData.iduser,
                            idaccount: sessData.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let funDetail = {
                            tableName: 'did_log',
                            functionName: 'VerifyProfile',
                            logName: 'DID'
                        };
                        const sdata = otherdata;
                        let objj = new RawQuery_1.ModelRawQuery(req, res);
                        objj.qrysql = "SELECT vs.business_name, vs.address1, vs.address2, vs.city, vs.state, vs.zip, vs.business_country, vs.corporate_website_url, vs.first_name, vs.last_name, vs.business_email, vs.business_phone, vs.notification_email, vs.summarize_usecase, vs.use_case_category, vs.sample_message, vs.opt_in_type, vs.message_volume_per_month, vs.additional_supporting_documentation, vs.external_reference, GROUP_CONCAT(DISTINCT vsl.file_path) AS file_paths FROM `verified_sender` vs JOIN `verified_sender_file` vsl ON vs.unique_request_id = vsl.unique_request_id WHERE vs.unique_request_id = '" + sdata.request_id + "' AND vs.idaccount = '" + sessData.idaccount + "' GROUP BY vs.unique_request_id";
                        objj.prepare();
                        objj.execute((errr, respp) => {
                            if (errr == 1) {
                                const filePaths = respp[0].file_paths ? respp[0].file_paths.split(',') : [];
                                let optInImageUrls = [];
                                if (filePaths.length > 0) {
                                    optInImageUrls = filePaths.map((filePath, index) => {
                                        return `${filePath}`;
                                    });
                                }
                                const usecase = respp[0].use_case_category.split(',').map((s) => s.trim());
                                const formData = {
                                    BusinessName: respp[0].business_name,
                                    BusinessStreetAddress: respp[0].address1,
                                    BusinessStreetAddress2: respp[0].address2,
                                    BusinessCity: respp[0].city,
                                    BusinessStateProvinceRegion: respp[0].state,
                                    BusinessPostalCode: respp[0].zip,
                                    BusinessCountry: respp[0].business_country,
                                    BusinessWebsite: respp[0].corporate_website_url,
                                    BusinessContactFirstName: respp[0].first_name,
                                    BusinessContactLastName: respp[0].last_name,
                                    BusinessContactEmail: respp[0].business_email,
                                    BusinessContactPhone: respp[0].business_phone,
                                    NotificationEmail: respp[0].notification_email,
                                    UseCaseSummary: respp[0].summarize_usecase,
                                    ProductionMessageSample: respp[0].sample_message,
                                    OptInType: respp[0].opt_in_type,
                                    MessageVolume: respp[0].message_volume_per_month,
                                    AdditionalInformation: respp[0].additional_supporting_documentation,
                                    TollfreePhoneNumberSid: data.sid,
                                    ExternalReferenceId: respp[0].external_reference,
                                    StatusCallback: twilio.TFVerificationWebhook
                                };
                                // Append array fields properly
                                usecase.forEach((uc, i) => {
                                    if (i == 0) {
                                        formData[`UseCaseCategories`] = uc; // first item without index
                                    }
                                    else {
                                        formData[`UseCaseCategories[${i}]`] = uc; // others with index
                                    }
                                });
                                optInImageUrls.forEach((url, i) => {
                                    if (i == 0) {
                                        formData[`OptInImageUrls`] = url;
                                    }
                                    else {
                                        formData[`OptInImageUrls[${i}]`] = url;
                                    }
                                });
                                const options = {
                                    method: 'POST',
                                    /* url: `https://messaging.twilio.com/v1/Tollfree/Verifications`, */
                                    url: `${twilio.verifyurl}/Verifications`,
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded',
                                        'Accept': 'application/json'
                                    },
                                    auth: {
                                        user: resp.sid,
                                        pass: resp.secret
                                    },
                                    form: formData
                                };
                                console.log("options :::::::: ", options);
                                console.log("VerifyProfile Request :: ", options);
                                request(options, (error, response) => {
                                    try {
                                        console.log("VerifyProfile Error :: ", error);
                                        console.log("Twilio VerifyProfile response :: ", response.body);
                                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                            let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                            let data = JSON.parse(response.body);
                                            console.log("VerifyProfile Response :: ", data);
                                            if (data.sid) {
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `verified_sender` SET `status`= '4',`provider`= '1',`review_date`=NOW() WHERE `idaccount` = '" + sessData.idaccount + "' AND `unique_request_id` = '" + sdata.request_id + "'";
                                                obj.prepare();
                                                obj.execute((err, resp) => {
                                                    if (err == 1) {
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='15', `sms_provider`='twilio',`camp_registry`='" + sdata.request_id + "' WHERE `account_id` = '" + sessData.idaccount + "' AND `did` = '" + sdata.DID + "' AND `type` = 'TF'";
                                                        obj1.prepare();
                                                        obj1.execute((err1, resp1) => {
                                                            if (err1 == 1) {
                                                                let logPayload = {
                                                                    funDetail,
                                                                    data: {
                                                                        account_id: sessData.idaccount,
                                                                        iduser: sessData.iduser,
                                                                        did: sdata.DID.trim(),
                                                                        event_type: '64',
                                                                        description: 'Verifying Profile In Process',
                                                                        sinch_status: '15',
                                                                        full_log: combinedLog
                                                                    }
                                                                };
                                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                    if (log_error == 1) {
                                                                        let objj = new RawQuery_1.ModelRawQuery(req, res);
                                                                        objj.qrysql = "SELECT `did` FROM `tollfree_assigned_number` WHERE  `did`='" + sdata.DID.trim() + "' AND `idaccount`='" + sessData.idaccount + "'";
                                                                        objj.prepare();
                                                                        objj.execute((errj, resp) => {
                                                                            if (resp.length >= 1) {
                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "UPDATE `tollfree_assigned_number` SET `requestId`='" + sdata.request_id + "' WHERE `did`='" + sdata.DID.trim() + "' AND `idaccount`='" + sessData.idaccount + "'";
                                                                                obj3.prepare();
                                                                                obj3.execute((err3, resp3) => { });
                                                                            }
                                                                            else {
                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "INSERT INTO `tollfree_assigned_number`(`idaccount`,`iduser`,`requestId`,`did`,`statusCode`,`orderId`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + sdata.request_id + "','" + sdata.DID + "','" + (0, markError_1.setToZero)(data.statusCode) + "','" + data.tollfree_phone_number_sid + "')";
                                                                                obj3.prepare();
                                                                                obj3.execute((err3, resp3) => { });
                                                                            }
                                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj4.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`,`full_log`) VALUES ('" + sessData.iduser + "', '" + sessData.idaccount + "', '10', 'VERIFYING_PROFILE_STARTED', 'Verifying Profile Process started','" + sdata.request_id + "','" + combinedLog + "')";
                                                                            obj4.prepare();
                                                                            obj4.execute(async (err4, result4) => {
                                                                                if (err4 == 1) {
                                                                                    console.log('Verify sender log inserted');
                                                                                    callback(1, "Verify profile succesfully");
                                                                                }
                                                                                else {
                                                                                    console.log('Verify sender log not inserted');
                                                                                    callback(0, "Profile not verifield successfully");
                                                                                }
                                                                            });
                                                                        });
                                                                    }
                                                                    else {
                                                                        console.log('did_buy not inserted');
                                                                        callback(0, "Profile not verifield successfully");
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                console.log('did_buy not updated');
                                                                callback(0, "Profile not verifield successfully");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log('Verify sender not updated');
                                                        callback(0, "Profile not verifield successfully");
                                                    }
                                                });
                                            }
                                            else {
                                                let logPayload = {
                                                    funDetail,
                                                    data: {
                                                        account_id: sessData.idaccount,
                                                        iduser: sessData.iduser,
                                                        did: sdata.DID.trim(),
                                                        event_type: '65',
                                                        description: 'Verifying Profile Failed From Provider',
                                                        sinch_status: '0',
                                                        full_log: combinedLog
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                });
                                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj7.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`, `idaccount`, `event_type`, `event_desc`, `description`, `unique_request_id`,`full_log`) VALUES ('" + sessData.iduser + "', '" + sessData.idaccount + "', '11', 'VERIFYING_PROFILE_FAILED', 'Verifying Profile Failed', '" + sdata.request_id + "','" + combinedLog + "')";
                                                obj7.prepare();
                                                obj7.execute((err4, resp4) => { });
                                                console.log('Profile not verifield successfully!!!');
                                                callback(2, { status: data.status, message: data.message });
                                            }
                                        }
                                        else {
                                            // throw error; // Throw the error to be caught in the catch block
                                            console.error('Profile not verifield successfully!!');
                                            callback(0, "Profile not verifield successfully!!");
                                        }
                                    }
                                    catch (err) {
                                        console.error('Profile not verifield successfully!');
                                        callback(0, "Profile not verifield successfully!");
                                    }
                                });
                            }
                            else {
                                console.error('Profile not verifield successfully');
                                callback(0, "Profile not verifield successfully");
                            }
                        });
                    }
                    else {
                        console.log(dt);
                        callback(0, dt);
                    }
                });
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    async movenumbersub2main(req, res, next, sdata, DID, subAccData, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 1 || sessData.type == 2 || sessData.type == 22 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                insertdid.checksessionvalid1_2_22_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `order_id` FROM `did_buy` WHERE `account_id` = '" + sdata.idaccount + "' AND `did`='" + DID + "'";
                        obj1.prepare();
                        obj1.execute((err, res) => {
                            if (err == 1 && res.length > 0) {
                                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                                let datasess = {
                                    iduser: sessData.iduser ?? sdata.iduser,
                                    idaccount: sessData.idaccount ?? sdata.idaccount,
                                    ipAddress: sysInfo.ipAddress[0],
                                };
                                let funDetail = {
                                    tableName: 'did_log',
                                    functionName: 'movenumbersub2main',
                                    logName: 'DID'
                                };
                                /* Twilio API options
                                sdata.sid = Sub AccSid */
                                const options = {
                                    method: 'POST',
                                    url: `${twilio.accounturl}/Accounts/${sdata.sid}/IncomingPhoneNumbers/${res[0].order_id}.json`,
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded',
                                        'Accept': 'application/json'
                                    },
                                    auth: {
                                        user: subAccData.sid,
                                        pass: subAccData.secret
                                    },
                                    form: {
                                        AccountSid: twilio.AccSid, /* Main Account SID to move the number */
                                    },
                                };
                                console.log("movenumbersub2main Request :: ", options);
                                request(options, (error, response) => {
                                    try {
                                        let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                        if (error) {
                                            callback(0, "NOT MOVE");
                                        }
                                        else {
                                            let data1 = JSON.parse(response.body);
                                            console.log("TWilio movenumbersub2main Response :: ", data1);
                                            if (data1.sid) {
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` SET `order_id`='" + data1.sid + "',`sinch_status`='0' WHERE `did`='" + DID + "' AND `account_id`='" + sdata.idaccount + "' AND `type` = 'TF'";
                                                obj.prepare();
                                                obj.execute((err5, resp5) => { });
                                                let logPayload = {
                                                    funDetail,
                                                    data: {
                                                        account_id: sdata.idaccount,
                                                        iduser: sdata.iduser,
                                                        did: DID,
                                                        provider: 'twilio',
                                                        type: 'TF',
                                                        disconnect_did_status: '1',
                                                        event_type: '68',
                                                        description: 'Move Number From Sub Account To Main Account',
                                                        full_log: combinedLog
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                });
                                                let logPayload1 = {
                                                    funDetail,
                                                    data: {
                                                        account_id: sdata.idaccount,
                                                        iduser: sdata.iduser,
                                                        did: DID,
                                                        provider: 'twilio',
                                                        type: 'TF',
                                                        disconnect_did_status: '1',
                                                        event_type: '70',
                                                        description: 'SMS service Disable Process Started',
                                                        full_log: combinedLog
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                });
                                                let twillio = new Twillio(sessData);
                                                twillio.SuspendSubaccount(req, res, next, sdata, sdata.sid, DID, (error, resp) => {
                                                    if (error == 1) {
                                                        callback(1, "Suspenede suceesfully");
                                                    }
                                                    else {
                                                        callback(0, "Not SUSPENDED");
                                                    }
                                                });
                                                console.log({ status: 201, message: "Number moved successfully" });
                                            }
                                            else {
                                                let logPayload = {
                                                    funDetail,
                                                    data: {
                                                        account_id: sdata.idaccount,
                                                        iduser: sdata.iduser,
                                                        did: sdata.DID,
                                                        provider: 'twilio',
                                                        type: 'TF',
                                                        disconnect_did_status: '1',
                                                        event_type: '69',
                                                        description: 'Number Not Move From Sub Account To Main Account',
                                                        full_log: combinedLog
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                });
                                                callback(0, "Not MOVE");
                                            }
                                        }
                                    }
                                    catch (err) {
                                        console.error("movenumbersub2main Error:", err);
                                        callback(0, "Not MOVE");
                                    }
                                });
                            }
                            else {
                                console.error("movenumbersub2main Error:", "Data NOT FOund");
                                callback(0, 'Data NOT FOund');
                            }
                        });
                    }
                    else {
                        console.log(dt);
                        callback(0, dt);
                    }
                });
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    /* async SuspendSubaccount(req: Request, res: Response, next: NextFunction, sdata: any, subAccountSid: string, did: any, callback: (err: any, data: any) => void
    ) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (sessData.type == 1 || sessData.type == 2 || sessData.type == 22 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                    let sysInfo = ipAddressAndBrowser(req);
                    let datasess: any = {
                        iduser: sessData.iduser,
                        idaccount: sessData.idaccount,
                        ipAddress: sysInfo.ipAddress[0],
                    }
                    let funDetail = {
                        tableName: 'did_log',
                        functionName: 'SuspendSubaccount',
                        logName: 'DID'
                    }

                    const options = {
                        method: 'POST',
                        url: `${twilio.accounturl}/Accounts/${subAccountSid}.json`,
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                            'Accept': 'application/json'
                        },
                        auth: {
                            user: twilio.Username,
                            pass: twilio.Password
                        },
                        form: {
                            Status: 'suspended', // or 'active' depending on use-case
                        },
                    };

                    request(options, (error: any, response: any) => {
                        try {
                            let combinedLog: any = response.body + ',' + JSON.stringify(datasess)
                            if (error) {
                                callback(0, null);
                            } else {

                                const body = JSON.parse(response.body);
                                console.log("SuspendSubaccount Request :: ", body);

                                if (body.sid) {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='',`provider`='0' WHERE `unique_request_id`='" + sdata.id + "' AND `idaccount`='" + sdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((err5, resp5) => { });

                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE `did_buy` SET `order_id`='' WHERE `did`='" + did + "' AND `account_id`='" + sessData.idaccount + "' AND `type` = 'TF'";
                                    obj2.prepare();
                                    obj2.execute((err5, resp5) => { });
 

                                    // let obj1 = new ModelRawNonQuery(req, res);
                                    // obj1.nonqrysql = "INSERT INTO `twillio_subaccount` (`sid`,`friendly_name`,`status`,`auth_token`,`date_created`,`date_updated`,`owner_account_sid`,`uri`,`subresource_uris`,`full_res`) VALUES ('" + body.sid + "','" + body.friendly_name + "','" + body.status + "','" + body.auth_token + "','" + body.date_created + "','" + body.date_updated + "','" + body.owner_account_sid + "','" + body.uri + "','" + JSON.stringify(body.subresource_uris) + "','" + combinedLog + "')";
                                    // obj1.prepare();
                                    // obj1.execute((err5, resp5) => { });
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `twillio_subaccount` SET `deleted` = '0' WHERE `subaccount_sid`='"+body.sid+"' ";
                                    obj1.prepare();
                                    obj1.execute((err5, resp5) => { });
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sdata.idaccount,
                                            iduser: sdata.iduser,
                                            did: did,
                                            provider: 'twilio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '71',
                                            description: 'SUB Account Suspended',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    })

                                    console.log({ status: 200, message: "Subaccount status Suspended successfully!" });
                                    callback(1, { status: 200, message: "Subaccount status Suspended successfully!" });
                                } else {
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sdata.idaccount,
                                            iduser: sdata.iduser,
                                            did: did,
                                            provider: 'twilio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '72',
                                            description: 'SUB Account Not Suspended',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    })

                                    console.error("Twilio Error Response:", body);
                                    callback(0, null);
                                }
                            }
                        } catch (err) {
                            console.error("SuspendSubaccount Error:", err);
                            callback(0, null);
                        }
                    });
                } else {
                    console.log({ message: "Service Unavailable!", status: 503 });
                    callback(0, { message: "Service Unavailable!", status: 503 });
                }
            } else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    } */
    async SuspendSubaccount(req, res, next, sdata, subAccountSid, did, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                // if (sessData.type == 1 || sessData.type == 2 || sessData.type == 22 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                insertdid.checksessionvalid1_2_22_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessData.iduser,
                            idaccount: sessData.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let funDetail = {
                            tableName: 'did_log',
                            functionName: 'SuspendSubaccount',
                            logName: 'DID'
                        };
                        const options = {
                            method: 'POST',
                            url: `${twilio.accounturl}/Accounts/${subAccountSid}.json`,
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded',
                                'Accept': 'application/json'
                            },
                            auth: {
                                user: twilio.Username,
                                pass: twilio.Password
                            },
                            form: {
                                Status: 'suspended', // or 'active' depending on use-case
                            },
                        };
                        request(options, (error, response) => {
                            try {
                                let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                if (error) {
                                    callback(0, null);
                                }
                                else {
                                    const body = JSON.parse(response.body);
                                    console.log("SuspendSubaccount Request :: ", body);
                                    /* body.sid is same as sdata.sid(sub account SID) */
                                    if (body.sid) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='',`provider`='0' WHERE `unique_request_id`='" + sdata.id + "' AND `idaccount`='" + sdata.idaccount + "'";
                                        obj.prepare();
                                        obj.execute((err5, resp5) => { });
                                        /* let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `did_buy` SET `order_id`='" + body.sid + "' WHERE `did`='" + did + "' AND `account_id`='" + sessData.idaccount + "' AND `type` = 'TF'";
                                        obj2.prepare();
                                        obj2.execute((err5, resp5) => { }); */
                                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj3.qrysql = "SELECT `subaccid` FROM `twillio_subaccount` WHERE `sid` = '" + body.sid + "'";
                                        obj3.prepare();
                                        obj3.execute((err5, resp5) => {
                                            if (err5 == 1) {
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "UPDATE `twillio_subaccount` SET `status`='" + body.status + "' WHERE `subaccid`='" + resp5[0].subaccid + "'";
                                                obj1.prepare();
                                                obj1.execute((err5, resp5) => { });
                                                let logPayload = {
                                                    funDetail,
                                                    data: {
                                                        account_id: sdata.idaccount,
                                                        iduser: sdata.iduser,
                                                        did: did,
                                                        provider: 'twilio',
                                                        type: 'TF',
                                                        disconnect_did_status: '1',
                                                        event_type: '71',
                                                        description: 'SUB Account Suspended',
                                                        full_log: combinedLog
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                });
                                                console.log({ status: 200, message: "Subaccount status Suspended successfully!" });
                                                callback(1, { status: 200, message: "Subaccount status Suspended successfully!" });
                                            }
                                            else {
                                                console.error("Error Fetching subacc:");
                                                callback(0, null);
                                            }
                                        });
                                    }
                                    else {
                                        let logPayload = {
                                            funDetail,
                                            data: {
                                                account_id: sdata.idaccount,
                                                iduser: sdata.iduser,
                                                did: did,
                                                provider: 'twilio',
                                                type: 'TF',
                                                disconnect_did_status: '1',
                                                event_type: '72',
                                                description: 'SUB Account Not Suspended',
                                                full_log: combinedLog
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        });
                                        console.error("Twilio Error Response:", body);
                                        callback(0, null);
                                    }
                                }
                            }
                            catch (err) {
                                console.error("SuspendSubaccount Error:", err);
                                callback(0, null);
                            }
                        });
                    }
                    else {
                        console.log(dt);
                        callback(0, dt);
                    }
                });
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    tfRequest(req, res, groupId, callback) {
        let sdata = req.query;
        let quantity = sdata.Quantity ?? req.body.data;
        let fun = new numberApi_1.Number();
        fun.prorationGet(req, res, 'TF', 0, this.sessdata.idtariff, (error, proration) => {
            if (error == 1) {
                this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                    let rate = new APIBase_1.APIBase();
                    rate.prorateCalculator(req, res, proration.proration, voice_rate[0].rate, proration.setup_cost, (pc_err, prorate1) => {
                        if (pc_err == 1) {
                            let fullrates = parseFloat(voice_rate[0].rate) + parseFloat(proration.setup_cost);
                            let prorate = typeof prorate1 != 'undefined' && prorate1 > 0 ? prorate1 : 0;
                            let RateS = (parseFloat(prorate) * quantity).toFixed(3);
                            console.log("Fullrates ::> ", fullrates);
                            console.log("Final ProRate with quantity multiplied ::> ", RateS);
                            let rate = new APIBase_1.APIBase();
                            rate.checkBalance(req, res, this.sessdata.idaccount, RateS, (walletError, wallet) => {
                                if (walletError == 1) {
                                    rate.calculateNextBillingDate(req, res, voice_rate[0].billing_frequency, (billingError, billing) => {
                                        const orderId = `${Math.floor(1000000 + Math.random() * 9000000)}`;
                                        let objv6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        objv6.nonqrysql = "INSERT INTO `tollfree_request` (`iduser`, `idaccount`,`status`,`statusCode`,`orderId`,`quantity`,`order_status`,`rates`,`pro_rates`,`type`,`id_grouporder`,`billing_frequency`,`nextbilling_cycle`,`provider`,`nrc_rates`) VALUE('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','0','200','" + orderId + "','" + quantity + "','0','" + voice_rate[0].rate + "','" + prorate + "','TF','" + groupId + "','" + (0, markError_1.setToZero)(voice_rate[0].billing_frequency) + "', '" + billing + "','1','" + proration.setup_cost + "')";
                                        objv6.prepare();
                                        objv6.execute((tol_error, tf_req) => {
                                            if (tol_error == 1) {
                                                let payload = {
                                                    idaccount: this.sessdata.idaccount,
                                                    amount: RateS,
                                                    purpose: 'Toll-Free Order',
                                                    type: '-'
                                                };
                                                insertdid.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                    console.log("Twilio tfRequest Wallet deduction response:", errorD, dataD);
                                                });
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 200, message: "You have created your order successfully. Your Order will take 3 to 4 Business Days. Order ID is: (" + orderId + ")" });
                                                objv.execute();
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with connection!" });
                                                obj.execute();
                                            }
                                        });
                                        let logPayload = {
                                            funDetail: {
                                                tableName: 'did_log',
                                                functionName: 'tfRequest',
                                                logName: 'DID'
                                            },
                                            data: {
                                                account_id: this.sessdata.idaccount,
                                                status: '200',
                                                full_log: "'DID Order created successfully from provider from twilio",
                                                iduser: this.sessdata.iduser,
                                                event_type: 44,
                                                description: 'DID Order created successfully from provider',
                                                provider: 'twilio',
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                            console.log("DID Order created successfully from provider.");
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: 0,
                                        error: walletError,
                                        message: "You have insufficient funds in your account. Kindly add funds to your account!",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: 0,
                                error: 'Wallet Issue',
                                message: "Something Went Wrong to Fetch Account Balance.",
                                status: 503
                            });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error_code: 0,
                    status: 502,
                    message: "Something went wrong with connection!"
                });
                objv.execute();
            }
        });
    }
    getId() {
        return [2, 2, 2, 6].reduce((prev, len) => prev + '-' + crypto.randomBytes(len).toString('hex'), crypto.randomBytes(4).toString('hex'));
    }
    sendTFSMS(req, res, sessData, DIDData, callback) {
        let uuid = this.getId();
        let sdata = req.body;
        let TO = sdata.TO.replace(/\D/g, '').slice(-10);
        let FROM = sdata.FROM.replace(/\D/g, '').slice(-10);
        let base = new APIBase_1.APIBase();
        base.checkTwilioDID(req, res, FROM, (errorD, resD) => {
            if (errorD == 1) {
                let iduser = sessData.type == 1 ? sdata.iduser : sessData.iduser;
                let idaccount = sessData.type == 1 ? sdata.idaccount : sessData.idaccount;
                let rate = new APIBase_1.APIBase();
                rate.getTollfreeSMSRate(req, res, sessData.idtariff, "SMS", "toll_free", (err, message_rate) => {
                    if (err == 1 && message_rate.length > 0) {
                        let msgcount = Math.ceil((sdata.BODY.length) / 159);
                        let cost = msgcount * (message_rate[0].MT_rates + DIDData.dLergDt.rates);
                        let MT_rates = msgcount * message_rate[0].MT_rates;
                        let MT_surcharge = msgcount * DIDData.dLergDt.rates;
                        let msg_data = sdata.BODY;
                        rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                            if (errorR == 1) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT `order_id` FROM `did_buy` WHERE `account_id` = '" + idaccount + "' AND `did`='" + FROM + "'";
                                obj.prepare();
                                obj.execute((errr, ress) => {
                                    if (errr == 1 && ress.length > 0) {
                                        // subaccountdta
                                        var options = {
                                            'method': 'POST',
                                            'url': `${twilio.accounturl}/Accounts/${resD.subaccount_sid}/Messages.json`,
                                            headers: {
                                                'Content-Type': 'application/x-www-form-urlencoded',
                                                'Accept': 'application/json'
                                            },
                                            auth: {
                                                user: resD.sub_username,
                                                pass: resD.sub_password
                                            },
                                            form: {
                                                From: '+1' + FROM,
                                                To: '+1' + TO,
                                                Body: sdata.BODY
                                            }
                                        };
                                        console.log("Twilio Tollfree SMS Request :: ", options);
                                        request(options, function (error, response) {
                                            if (!error) {
                                                try {
                                                    console.log("Twilio sendTFSMS response.body :: ", response.body);
                                                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                        let data = JSON.parse(response.body);
                                                        console.log("Twilio Tollfree SMS Response :: ", data);
                                                        if (data.sid || data.status == 'queued') {
                                                            let payload = {
                                                                idaccount: idaccount,
                                                                amount: cost,
                                                                purpose: 'Toll-Free SMS',
                                                                type: '-'
                                                            };
                                                            insertdid.walletDeductionWithoutLog(req, res, payload, (errorD, dataD) => {
                                                                console.log("Wallet deduction response:", errorD, dataD);
                                                            });
                                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj0.nonqrysql = "INSERT INTO `mdrlive_tollfree` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`is_billable`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`) VALUES('" + data.sid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "',4,'" + idaccount + "','" + iduser + "','toll_free','1','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + (0, markError_1.setToZero)(sessData.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',1,NOW(),NOW(),NOW(),NOW())";
                                                            obj0.prepare();
                                                            obj0.execute((error, result) => {
                                                                if (error == 1) {
                                                                    console.log("Message Send Successfully!");
                                                                    callback(1, { status: 201, message: "SMS Submit Successfully", batch_id: data.sid });
                                                                }
                                                                else {
                                                                    console.log("Message Send Successfully But Something Went Wrong With Insertion!");
                                                                    callback(1, { status: 401, message: "Something went wrong!", batch_id: data.sid });
                                                                }
                                                            });
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`status`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + data.sid + "','1','" + data.status + "','" + data.sid + "','" + FROM + "','" + TO + "','" + (0, markError_1.parseBody)(msg_data) + "')";
                                                            obj1.prepare();
                                                            obj1.execute((error, result) => { });
                                                        }
                                                        else {
                                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj0.nonqrysql = "INSERT INTO `mdrlive_tollfree` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`) VALUES('" + uuid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "',2,'" + idaccount + "','" + iduser + "','toll_free','1','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + (0, markError_1.setToZero)(sessData.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',NOW(),NOW(),NOW(),NOW())";
                                                            obj0.prepare();
                                                            obj0.execute((error, result) => {
                                                                console.log("Something Went Wrong!");
                                                                callback(0, { status: 402, message: "SMS not Sent!" });
                                                            });
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + uuid + "','1','" + uuid + "','" + FROM + "','" + TO + "','" + (0, markError_1.parseBody)(msg_data) + "')";
                                                            obj1.prepare();
                                                            obj1.execute((error, result) => { });
                                                        }
                                                    }
                                                    else {
                                                        callback(0, { message: "SMS not Sent Successfully!", status: 507 });
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error :: Twilio->sendTFSMS::", e);
                                                    callback(0, { message: "Something Went Wrong with the server!", status: 504 });
                                                }
                                            }
                                            else {
                                                callback(0, { message: "Something went wrong!", status: 502 });
                                            }
                                        });
                                    }
                                    else {
                                        callback(0, { message: "Something Went Wrong! Subaccount ID not Found", status: 503 });
                                    }
                                });
                            }
                            else {
                                callback(0, { message: "Please add funds to your account or contact support.", status: 503 });
                            }
                        });
                    }
                    else {
                        callback(0, { status: 502, message: "MT Rates not Found!" });
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(resD);
                objv.execute();
            }
        });
    }
    getTollFree(req, res, key, callback) {
        this.getRate(req, res, this.sessdata.idtariff, "message", "VN", (err, voice_rate) => {
            if (err == 1 && voice_rate.length > 0) {
                let data1 = req.query;
                let containsValue = '';
                if (data1.quantity != '' && data1.tnMask1 != 'null') {
                    containsValue = data1.tnMask1 + data1.tnMask2 + data1.tnMask3;
                }
                if (data1.wildcard != '' && data1.quantity != '') {
                    containsValue = data1.wildcard;
                }
                const params = {
                    // AreaCode: code,
                    Contains: containsValue,
                    PageSize: data1.quantity,
                };
                var options = {
                    'method': 'GET',
                    'url': twilio.accounturl + '/Accounts/' + twilio.AccSid + '/AvailablePhoneNumbers/US/TollFree.json',
                    'qs': params,
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'Accept': 'application/json'
                    },
                    auth: {
                        user: twilio.Username,
                        pass: twilio.Password
                    },
                };
                console.log("getTollFree options :: ", options);
                request(options, (error, response) => {
                    if (!error) {
                        try {
                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                let ddata = JSON.parse(response.body);
                                console.log("getTollFree ddata :: ", ddata);
                                if (response.statusCode == 200) {
                                    if (ddata.available_phone_numbers != undefined && ddata.available_phone_numbers.length > 0) {
                                        let str = ddata.available_phone_numbers;
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`idaccount`,`phone_number`, `provider`, `iduser`, `priorty`,`type`,`rates`,`path`,`idapi`,`key`,`did_sub_type`) VALUE ";
                                        str.forEach((ele) => {
                                            qrystr += "('" + this.sessdata.idaccount + "', '" + ele.phone_number.slice(-10) + "','" + "twilio" + "', '" + this.sessdata.iduser + "', '100','TF','" + voice_rate[0].rate + "','" + (0, markError_1.parseBody)(this.sessdata.path) + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + key + "','1'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback('', ddata);
                                    }
                                }
                                else {
                                    callback('', ddata);
                                }
                            }
                            else {
                                callback(error, '');
                            }
                        }
                        catch (e) {
                            console.log("Error :: Twilio->getTollFree::", e);
                            callback(error, '');
                        }
                    }
                    else {
                        callback(error, '');
                    }
                });
            }
            else {
                callback(err, voice_rate);
            }
        });
    }
    buyDID(req, res, did_details, other_data, callback) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let id_grouporder = other_data.id_grouporder;
        let sub_type = other_data.sub_type;
        let days = other_data.days;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            let frates = other_data.fullrates;
            let did_dis_days = days[0].day_num > 0 ? days[0].day_num : 0;
            let prorate = typeof other_data.prorate != 'undefined' && other_data.prorate > 0 ? other_data.prorate : 0;
            // To purchase the toll free number
            if (did_details[0].type == "TF") {
                const options = {
                    method: 'POST',
                    url: twilio.accounturl + '/Accounts/' + twilio.AccSid + '/IncomingPhoneNumbers/TollFree.json',
                    auth: {
                        user: twilio.Username,
                        pass: twilio.Password
                    },
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'Accept': 'application/json'
                    },
                    form: {
                        PhoneNumber: sdata.DID.trim(),
                        SmsUrl: twilio.TwilioSMSIncoming,
                        StatusCallback: twilio.TwilioSMSDlr,
                    }
                };
                console.log("buyDID options :: ", options);
                request(options, (error, response, body) => {
                    console.log("error ::::::::: ", error);
                    console.log("body ::::::::: ", body);
                    if (!error) {
                        try {
                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                let sdata1 = JSON.parse(response.body);
                                //If order success
                                console.log("buyDID sdata1 :: ", sdata1);
                                if (sdata1.sid || sdata1.status == 'in-use') {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`did_sub_type`,`subscription_end_date`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','twilio','" + sdata1.sid + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + (0, markError_1.parseBody)(sdata.InboundVoice) + "','" + (0, markError_1.parseBody)(sdata.OutboundVoice) + "','" + (0, markError_1.parseBody)(sdata.Connection) + "','" + (0, markError_1.parseBody)(sdata.InboundSMS) + "','" + (0, markError_1.parseBody)(sdata.OutboundSMS) + "','" + other_data.rateS + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + other_data.nrc_rates + "','" + sub_type + "','" + days[0].subscription_end_date + "','" + (0, markError_1.setToZero)(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            let payLoadData = {
                                                funDetail: {
                                                    tableName: 'did_billing',
                                                    functionName: 'buyDID',
                                                    logName: 'DID Billing'
                                                },
                                                data: { idaccount: this.sessdata.idaccount, did: sdata.DID.trim(), type: 'TF', did_sub_type: sub_type, cost: prorate, billing_type: '2'
                                                }
                                            };
                                            insertdid.insertLog(req, res, payLoadData, (err_did, add_did) => {
                                                console.log("Twilio DID => buyDID ::", add_did);
                                            });
                                            let payload = {
                                                idaccount: this.sessdata.idaccount,
                                                amount: prorate,
                                                purpose: 'Twilio DID Purchase',
                                                type: '-'
                                            };
                                            insertdid.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("Wallet deduction response:", errorD, dataD);
                                            });
                                            let logPayload = {
                                                funDetail: {
                                                    tableName: 'did_log',
                                                    functionName: 'buyDID',
                                                    logName: 'DID'
                                                },
                                                data: {
                                                    account_id: this.sessdata.idaccount,
                                                    status: 'completed',
                                                    provider: 'twilio',
                                                    did: sdata.DID.trim(),
                                                    order_id: sdata1.sid,
                                                    type: 'TF',
                                                    npa: npa,
                                                    nxx: nxx,
                                                    state: state,
                                                    disconnect_did_status: 1,
                                                    iduser: this.sessdata.iduser,
                                                    ratecenter: ratecenter,
                                                    rates: other_data.rateS,
                                                    idapi: this.sessdata.idapi,
                                                    pro_rates: prorate,
                                                    full_log: response.body,
                                                    description: 'DID Buy Sucessfully from Twilio',
                                                    event_type: 73
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { });
                                            // To delete the DID from cart
                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                            obj5.prepare();
                                            obj5.execute((walletError, wallet) => { });
                                            // To update the process count of group order
                                            let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";";
                                            objk.prepare();
                                            objk.execute((error, result) => {
                                                console.log("GroupOrder process count::\n", result);
                                            });
                                            // To create the did_order
                                            let providerOrderId = typeof sdata1.sid != 'undefined' && sdata1.sid ? sdata1.sid : '';
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                            obj.prepare();
                                            obj.execute((did_err, did_data) => {
                                                // To update the other data on current order
                                                if (did_err == 1) {
                                                    let id_order = did_data.insertId;
                                                    let orderID = "SORD" + id_order.toString();
                                                    let log_error = "";
                                                    let log_message = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                    let log_result = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                    obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + response.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='twilio' WHERE `id_order`=" + id_order + ";";
                                                    obj.prepare();
                                                    obj.execute((error, result) => { });
                                                }
                                            });
                                            // Leave the successfull output
                                            let objV = new RawView_1.RawView(res);
                                            objV.prepare({ error_code: 1, status: 201, message: "DID buy successfully.", result: [{ "did": sdata.DID.trim() }] });
                                            objV.execute();
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                }
                                // If order failed
                                else {
                                    // To delete the DID from cart
                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                    obj5.prepare();
                                    obj5.execute((walletError, wallet) => { });
                                    let I1 = sdata1.status.indexOf("Waiting on internal port");
                                    let I2 = sdata1.status.indexOf("TN is on a pending order");
                                    let providerOrderId = typeof sdata1.sid != 'undefined' && sdata1.sid ? sdata1.sid : '';
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    // To update the status of group order
                                    let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";";
                                    objk.prepare();
                                    objk.execute((error, result) => {
                                        console.log("Failed");
                                    });
                                    // It will check, if order goes into pending
                                    if (I1 > -1 || I2 > -1) {
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`, `ordConf`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "', '0')";
                                    }
                                    else {
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                    }
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'did_log',
                                            functionName: 'buyDID',
                                            logName: 'DID'
                                        },
                                        data: {
                                            account_id: this.sessdata.idaccount,
                                            did: sdata.DID.trim(),
                                            full_log: response.body,
                                            iduser: this.sessdata.iduser,
                                            event_type: 74,
                                            description: 'DID Buy failed from Twilio',
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        console.log("DID Buy failed from provider");
                                    });
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order = did_data.insertId;
                                            let orderID = "SORD" + id_order.toString();
                                            let log_error = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_message = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_result = "";
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='twilio' WHERE `id_order`=" + id_order + ";";
                                            obj.prepare();
                                            obj.execute((error, result) => { });
                                        }
                                    });
                                    let objV = new RawView_1.RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: sdata1.statusCode,
                                        message: sdata1.status
                                    });
                                    objV.execute();
                                }
                            }
                            else {
                                console.log("Twilio->buyDID::");
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "Something went wrong with DID buy!" });
                                obj.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: Twilio->buyDID::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong DID Buy!" });
                            obj.execute();
                        }
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 400, error: error });
                        obj.execute();
                    }
                });
            }
        });
    }
    disconnectDID(req, res, next, payload, userPayLoad, callback) {
        let sdata = req.body;
        let objj = new RawQuery_1.ModelRawQuery(req, res);
        objj.qrysql = "SELECT ts.sid, ts.subaccount_secret, ts.subaccount_sid FROM twillio_subaccount ts WHERE ts.sid = (SELECT vs.subaccount_sid FROM verified_sender vs WHERE vs.unique_request_id = '" + payload.campaign + "')";
        objj.prepare();
        objj.execute((err, respp) => {
            if (err == 1) {
                /* respp[0].sid -> Sub AccSid
                twilio.AccSid > Main AccSid */
                let userkey = (respp[0].subaccount_sid !== undefined && respp[0].subaccount_sid !== null) ? respp[0].subaccount_sid : twilio.Username;
                let authkey = (respp[0].subaccount_secret !== undefined && respp[0].subaccount_secret !== null) ? respp[0].subaccount_secret : twilio.Password;
                let AccSid = ((respp[0].subaccount_secret !== undefined && respp[0].subaccount_secret !== null) && (respp[0].subaccount_sid !== undefined && respp[0].subaccount_sid !== null)) ? respp[0].sid : twilio.AccSid;
                const options = {
                    method: 'DELETE',
                    /*  https://api.twilio.com/2010-04-01/Accounts/$TWILIO_ACCOUNT_SID/IncomingPhoneNumbers/PNaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.json */
                    url: twilio.accounturl + '/Accounts/' + AccSid + '/IncomingPhoneNumbers/' + payload.orderId + '.json',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                        'Accept': 'application/json'
                    },
                    auth: {
                        user: userkey,
                        pass: authkey
                    },
                };
                request(options, (error, response) => {
                    if (!error) {
                        try {
                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                let data = JSON.parse(response.body);
                                if (response.statusCode == "200") {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE TRIM(`did`)=" + sdata.DID.trim() + " AND `account_id`='" + userPayLoad.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((error, resp) => {
                                        if (error == 1) {
                                            let logPayload = {
                                                funDetail: {
                                                    tableName: 'did_log',
                                                    functionName: 'disconnectDID',
                                                    logName: 'DID'
                                                },
                                                data: {
                                                    account_id: userPayLoad.idaccount,
                                                    did: sdata.DID.trim(),
                                                    iduser: userPayLoad.iduser,
                                                    full_log: response.body,
                                                    description: 'Disconnect DID from provider',
                                                    event_type: '5'
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { });
                                            if (payload.campaign !== null && payload.campaign !== undefined && payload.campaign) {
                                                let userp = {
                                                    idaccount: userPayLoad.idaccount,
                                                    iduser: userPayLoad.iduser,
                                                    sid: respp[0].sid,
                                                    id: payload.campaign
                                                };
                                                let subAccData = {
                                                    sid: respp[0].subaccount_sid,
                                                    secret: respp[0].subaccount_secret
                                                };
                                                let twilio = new Twillio(this.sessdata);
                                                twilio.movenumbersub2main(req, res, next, userp, sdata.DID.trim(), subAccData, (_error, resp) => {
                                                    console.log("Response from SMS Disable Facility ", resp);
                                                });
                                            }
                                            else {
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='0' WHERE account_id = '" + userPayLoad.idaccount + "' AND TRIM(`did`)=" + sdata.DID + "";
                                                obj1.prepare();
                                                obj1.execute((err1, resp1) => {
                                                    console.log("DID Disconnected");
                                                });
                                                console.log("No Campaign found on this Number");
                                            }
                                            let pAyLoad = {
                                                idaccount: userPayLoad.idaccount,
                                                did: sdata.DID
                                            };
                                            insertdid.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                                                if (erroR == 1) {
                                                    console.log("Deleted Successfully");
                                                }
                                                else {
                                                    console.log("Deleted Not Successfully", resulT.message);
                                                }
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something went wrong with connection" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'did_log',
                                            functionName: 'disconnectDID',
                                            logName: 'DID'
                                        },
                                        data: {
                                            account_id: userPayLoad.idaccount,
                                            did: sdata.DID.trim(),
                                            iduser: userPayLoad.iduser,
                                            full_log: response.body,
                                            description: 'DID disconnect failed from provider',
                                            event_type: '39'
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        console.log("DID disconnect failed FROM provider");
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: data.code, message: data.message });
                                    objv.execute();
                                }
                            }
                            else {
                                console.log("Twilio->disconnectDID");
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 402, message: "Something went wrong with disconnect DID!" });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: Twillio->disconnectDID::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        console.log("Twilio :::::::::::::::::::");
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                objv.execute();
            }
        });
    }
    DisableSMSTwillio(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                insertdid.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = JSON.parse(req.body.data);
                        let objj = new RawQuery_1.ModelRawQuery(req, res);
                        objj.qrysql = "SELECT ts.sid, ts.subaccount_secret, ts.subaccount_sid FROM twillio_subaccount ts WHERE ts.sid = (SELECT vs.subaccount_sid FROM verified_sender vs WHERE vs.unique_request_id = '" + sdata.request_ID + "')";
                        objj.prepare();
                        objj.execute((err, respp) => {
                            if (err == 1) {
                                let payload = {
                                    idaccount: sessdata.idaccount,
                                    iduser: sessdata.iduser,
                                    sid: respp[0].sid,
                                    id: sdata.request_ID
                                };
                                let subAccData = {
                                    sid: respp[0].subaccount_sid,
                                    secret: respp[0].subaccount_secret
                                };
                                let twilio = new Twillio(this.sessdata);
                                twilio.movenumbersub2main(req, res, next, payload, sdata.DID.trim(), subAccData, (errr, resP) => {
                                    if (errr == 1) {
                                        let objv0 = new RawView_1.RawView(res);
                                        objv0.prepare({ status: 201, message: "SMS Disabled  Successfully." });
                                        objv0.execute();
                                    }
                                    else {
                                        let objv0 = new RawView_1.RawView(res);
                                        objv0.prepare({ status: 502, message: "Something Went Wrong With Disable SMS!" });
                                        objv0.execute();
                                    }
                                });
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    rejectSenderstatus(req, res, next, sdata, did, description, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                insertdid.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `verified_sender` SET `status`= '2',`reject_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `unique_request_id`= '" + sdata.id + "'";
                        obj1.prepare();
                        obj1.execute((errors, result) => {
                            console.log("Status Updated Successfully!");
                        });
                        /* let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `email` FROM `user_profile` WHERE `iduser`='" + sdata.iduser + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
    
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES ('" + sdata.iduser + "','" + sdata.idaccount + "','" + SMTP.from + "','" + result[0].email + "', '" + parseBody(SMTP.RejectSubject) + "','" + parseBody(description) + "','Sender Request Rejected','11','" + parseBody(description) + "')";
                                obj1.prepare();
                                obj1.execute((_err: any, __result: any) => {
                                    if (_err == 1) {
                                        console.log("Mail Sent Successfully!")
                                    }
                                    else {
                                        console.log("Something went wrong!");
                                    }
                                });
                            }
                            else {
                                callback(0, { status: 502, message: "Not Rejcted Succesffully" })
                            }
                        }) */
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`,`full_log`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','2','REQUEST_REJECTED','" + (0, markError_1.parseBody)(description) + "', '" + sdata.id + "','" + JSON.stringify(datasess) + "')";
                        obj0.prepare();
                        obj0.execute((_error, result) => {
                        });
                        callback(1, { status: 201, message: "Rejcted Succesffully" });
                    }
                    else {
                        callback(0, dt);
                    }
                });
            }
            else {
                callback(0, { status: 401, message: "Invalid Session Trying to access" });
            }
        });
    }
}
exports.Twillio = Twillio;
