"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelDelete = void 0;
const ModelObject_1 = require("./ModelObject");
class ModelDelete extends ModelObject_1.ModelObject {
    constructor(req, res) {
        super(req, res);
        this.type = "DELETE";
    }
    prepare() {
        var ret = true;
        if (this.table.length < 1 || this.table == 'undefined' || this.table == null) {
            console.log("Table is not defined properly.");
            return false;
        }
        if (this.req.query.hasOwnProperty('filter')) {
            if (this._isfilter) {
                let tmp = this.req.query.filter;
                this.nonquery.filter = Object.assign(JSON.parse(tmp), this._filter);
                this.nonquery.isfilter = true;
            }
            else {
                this.nonquery.filter = JSON.parse(this.req.params.filter);
                this.nonquery.isfilter = true;
            }
        }
        else {
            if (this.req.query.hasOwnProperty('id')) {
                if (this._isfilter) {
                    this.nonquery.filter = Object.assign({ id: this.req.query.id }, this._filter);
                    this.nonquery.isfilter = true;
                }
                else {
                    this.nonquery.filter = { id: this.req.query.id };
                    this.nonquery.isfilter = true;
                }
            }
            else {
                ret = false;
            }
        }
        return ret;
    }
    execute(callback) {
        this.log.Debug("Calling Delete function in ModelObject.");
        this.nonquery.prepare();
        this.nonquery.Execute((err, data) => {
            this.respond(err, data, callback);
        });
    }
}
exports.ModelDelete = ModelDelete;
