import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { Res406 } from "../lib/view/406";
import { SessionManagment } from "../lib/model/Session";
import { OsrApi } from "./Osr";
import { SinchApi } from "./SinchSubmitNumber";
let insertdid = new APIBase();
export class Importnumber extends APIBase {

    private priority: string;
    private sessdata: any;
    private timekey: string;

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        this.timekey = timekey
        this.sessdata = sessdata;
        this.priority = proirity;
    }

    public importNumber(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                insertdid.checksessionvalid2_22_201_202(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        // changed the status 502 to 500;
                        insertdid.checkNumberValid(sdata.DID, 500,(err1, msg1)=>{
                            if(err1 == 1){
                                let objv = new RawView(res);
                                objv.prepare(msg1);
                                objv.execute();
                            }
                            else{
                                let did = sdata.DID.trim();
                                let len = did.length - 10;
                                let npa = did.slice(len, len + 3);
                                let nxx = did.slice(len + 3, len + 6);
                                // if (sdata.DID.length == 10) {
                                let type:any = '';
                                if ((npa == "800" || npa == "811" || npa == "822" || npa == "833" || npa == "844" || npa == "855" || npa == "866" || npa == "877" || npa == "888" || npa == "899")) {
                                    console.log("Number Type is ITF");
                                    type = "ITF";
                                }
                                else {
                                    console.log("Number Type is INN");
                                    type = "INN";
                                }
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`rates`) VALUE('" + sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','Importnumber','" + type + "','" + sessdata.iduser + "','1','" + npa + "','" + nxx + "','0')";
                                obj.prepare();
                                obj.execute((err, data) => {
                                    if (err == 1) {
                                        // update end subscription date
                                        let obj0 = new ModelRawQuery(req, res);
                                        obj0.qrysql = "SELECT d.iddid, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                        obj0.prepare();
                                        obj0.execute((dids_err, didRes) => {
                                            let currentDate = new Date();
                                            currentDate.setMonth(currentDate.getMonth() + 1);
                                            currentDate.setDate(0);
                                            currentDate.setUTCHours(0, 0, 0, 0);
                                            let lastDate = currentDate.toJSON().slice(0, 19).replace('T', ' ')
                                            let obj01 = new ModelRawNonQuery(req, res);
                                            obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + lastDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                            obj01.prepare();
                                            obj01.execute((error, result) => { })
                                        })
 
                                        // To create the DID log
                                        // let objv1 = new ModelRawNonQuery(req, res);
                                        // objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `status`, `did`,`provider`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`rates`,`pro_rates`,`event_type`,`description`) VALUE('" + sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','Importnumber','" + type + "','" + sessdata.iduser + "','1','" + npa + "','" + nxx + "','0','0','2','Import DID')"
                                        // objv1.prepare();
                                        // objv1.execute((log_error, did_log) => {
                                            let logPayload = {
                                                funDetail: {
                                                    tableName: 'did_log',
                                                    functionName: 'importNumber',
                                                    logName: 'DID'
                                                },
                                                data: {
                                                    account_id: sessdata.idaccount,
                                                    status: 'completed',
                                                    provider: 'Importnumber',
                                                    did: sdata.DID.trim(),
                                                    type: type,
                                                    npa: npa,
                                                    nxx: nxx,
                                                    disconnect_did_status: '1',
                                                    iduser: sessdata.iduser,
                                                    rates: '0',
                                                    pro_rates: '0',
                                                    description: 'Import DID',
                                                    event_type: '2'
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                            if (log_error == 1) {
                                                let obj = new RawView(res);
                                                obj.prepare({ status: 200, message: "DID Imported Successfully!" });
                                                obj.execute()
                                            }
                                            else {
                                                let obj = new RawView(res);
                                                obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                obj.execute()
                                            }
                                        });
                                    }
                                    else {
                                        let obj = new RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        obj.execute()
                                    }
                                });
                                // } else {
                                //     let obj = new RawView(res);
                                //     obj.prepare({ status: 502, message: "Please enter 10 digit number!" })
                                //     obj.execute();
                                // }
                            }
                        });
                    } else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    disconnectDID(req: Request, res: Response, payload: any, userPayLoad:any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        // let obj1 = new ModelRawNonQuery(req, res);
        // obj1.nonqrysql = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "', '" + sdata.DID.trim() + "','5','Disconnect DID from provider',NOW())";
        // obj1.prepare();
        // obj1.execute((error: any, result: any) => {
            let logPayload = {
                funDetail: {
                    tableName: 'did_log',
                    functionName: 'disconnectDID',
                    logName: 'DID'
                },
                data: {
                    account_id: userPayLoad.idaccount,
                    did: sdata.DID.trim(),
                    iduser:userPayLoad.iduser,
                    event_type: 5,
                    description: 'Disconnect DID from provider',
                }
            };
            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
            if(log_error==1){
                console.log("Toll-Free Disconnect DID Log From Provider Inserted");
            }
            else{
                console.log("Toll-Free Disconnect DID Log From Provider Not Inserted");
            }
        });
        let obj2 = new ModelRawNonQuery(req, res);
        obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE TRIM(`did`)=" + sdata.DID.trim() + "";
        obj2.prepare();
        obj2.execute((errorin: any, data: any) => {
            if (errorin == 1) {

                let pAyLoad = {
                    idaccount: userPayLoad.idaccount,
                    did: sdata.DID.trim()
                }
                insertdid.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                    if (erroR == 1) {
                        console.log("Deleted Successfully");
                    } else {
                        console.log("Deleted Not Successfully", resulT.message);
 
                    }
                });
 
                let objv = new RawView(res);
                objv.prepare({ status: 201, message: "DID Disconnected Successfully!" })
                objv.execute();
            } 
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "DID Not Disconnected Successfully!" })
                objv.execute();
            }
        });
    }
    
    disconnectDIDOTTMASH(req: Request, res: Response, payload: any, userPayLoad:any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let obj2 = new ModelRawNonQuery(req, res);
        obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='3' WHERE TRIM(`did`)=" + sdata.DID.trim() + "";
        obj2.prepare();
        obj2.execute((errorin: any, data: any) => {
            if (errorin == 1) {
                // To delete the number from OSR
                /* let payLoad: any = {
                    DID: sdata.DID.trim(),
                    campaign: payload.campaign,
                    iduser: iduser,
                    idaccount: idaccount,
                    type: payload.type,
                    did_sub_type: payload.did_sub_type
                }
                let osr = new OsrApi(this.priority, this.sessdata)
                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                    if (error == 1) {
                        if (payload.sms_provider && payload.sms_provider == 'sinch') {
                            // To delete the number from Sinch
                            let osr = new SinchApi(this.priority, this.sessdata)
                            osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                            })
                        } else {
                            // To delete the number from Syniverse
                            let osr = new SinchApi(this.priority, this.sessdata)
                            osr.deleteNumberM2fromSyniverse(req, res, payLoad, (error, response) => {
                            })
                        }
                    }
                }) */
                // if(payload.campaign && payload.campaign.startsWith("C")){
                if(payload.campaign !== null && payload.campaign !== undefined && payload.campaign){
                    let osr = new OsrApi('', this.sessdata);
                    osr.deleteNumber(req, res, 'disconnectDID', userPayLoad, (error, resp) => { 
                        console.log("Response from SMS Disable Facility ", resp);
                    });
                }
                else{
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='0' WHERE account_id = '" + userPayLoad.idaccount + "' AND `did`='" + sdata.DID.trim() + "'";
                    obj1.prepare();
                    obj1.execute((err1, resp1) => {
                        console.log("DID Disconnected");
                    });
                    console.log("No Campaign found on this Number");
                }

                // let obj1 = new ModelRawNonQuery(req, res);
                // obj1.nonqrysql = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "', '" + sdata.DID.trim() + "','5','Disconnect DID from provider',NOW())";
                // obj1.prepare();
                // obj1.execute((error: any, result: any) => {
                    let logPayload = {
                        funDetail:{
                            tableName :'did_log',
                            functionName : 'disconnectDIDOTTMASH',
                            logName : 'DID'
                        },
                        data:{
                            account_id: userPayLoad.idaccount,
                            did: sdata.DID.trim(),
                            iduser: userPayLoad.iduser,
                            event_type: 5,
                            description: 'Disconnect DID from provider',
                        }                                
                    };
                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                    if (log_error == 1) {
                        console.log("OTT_MASH Disconnect DID Log From Provider Inserted");
                    }
                    else{
                        console.log("OTT_MASH Disconnect DID Log From Provider Not Inserted");
                    }
                });

                let pAyLoad = {
                    idaccount: userPayLoad.idaccount,
                    did: sdata.DID.trim()
                }
                insertdid.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                    if (erroR == 1) {
                        console.log("Deleted Successfully");
                    } else {
                        console.log("Deleted Not Successfully", resulT.message);
 
                    }
                });
 
                let objv = new RawView(res);
                objv.prepare({ status: 201, message: "DID Disconnected Successfully!" })
                objv.execute();
            } 
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "DID Not Disconnected Successfully!" })
                objv.execute();
            }
        });
    }
}