import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Number } from "./numberApi";
import { RawView } from "../lib/view/RawView";
import { parseBody, setToZero } from "./markError";
import { GetTelApiRecord } from "../config/setting.config";
const TelApiRecords = new GetTelApiRecord();
let insertdid = new APIBase();
var request = require('request');

export class TeleAPI extends APIBase {
    // private key: string;
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey: string

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        // this.key = "48de6c84-7726-4879-bc08-f7a5dcf63f1c";
        this.timekey = timekey,
            this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }

    public getNpaNxx(req: Request, res: Response, pLoad:any, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            console.log("Exit from TeleAPI");
            callback('', '');
        } else {
            const sdata = req.query;
            var options = {
                'method': 'POST',
                // 'url': 'https://apiv1.teleapi.net/dids/list?token=' + this.key + '&npa=' + `${sdata.NPA}` + '&limit=' + `${pLoad.searchqty}`,
                'url': TelApiRecords.TelApiListUrl + TelApiRecords.TelApiKEY + '&npa=' + `${sdata.NPA}` + '&limit=' + `${pLoad.searchqty}`,
                'headers': {
                    'Content-Type': 'application/json'
                }
            };
            request(options, (error: any, response: any) => {
                if (!error) {
                    try {
                        let ddata = JSON.parse(response.body);
                        if (ddata.code == 200) {
                            if (ddata.data.dids != undefined && ddata.data.dids.length > 0) {
                                let str = ddata.data.dids;
                                let hsmpData:any= [];
                                let obj1 = new ModelRawNonQuery(req, res);
                                let qrystr = "INSERT INTO `did_search` (`idaccount`, `phone_number`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`,`billing_frequency`) VALUE";
                                str.forEach((ele: any) => {
                                    let hmp:any = {
                                        phone_number: ele.number,
                                        rate_center: parseBody(ele.rateCenter),
                                        state: parseBody(ele.state),
                                        supplier_tier: parseBody(ele.tier),
                                        provider :'teleapi',
                                        rates:pLoad.rate
                                    };
                                    hsmpData.push(hmp)
                                    qrystr += "('" + this.sessdata.idaccount + "', '" + ele.number + "', '" + parseBody(ele.ratecenter) + "', '" + parseBody(ele.state) + "', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + setToZero(this.priority) + "','NN','" + ele.tier + "','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + pLoad.rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "','" + setToZero(pLoad.billingfreq) + "'),";
                                });
                                this.saveHmp(this.timekey, 'teleapi', hsmpData);
                                obj1.nonqrysql = qrystr.slice(0, -1);
                                obj1.prepare();
                                obj1.execute((err, data) => {
                                    callback(err, data);
                                });
                            } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "No DID's found on [" + sdata.NPA + "]" });
                                obj.execute();
                            }
                        } else {
                            callback('', ddata);
                        }
                    }
                    catch (e) {
                        console.log("Error :: TeleApi->getNpaNxx::", e);
                        callback(error, '');
                    }

                } else {
                    callback(error, '');
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, pLoad:any, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            console.log("Exit from TeleAPI");
            callback('', '');
        } else {
            const sdata = req.query;
            var options = {
                'method': 'POST',
                // 'url': 'https://apiv1.teleapi.net/dids/list?token=' + this.key + '&state=' + `${sdata.State}` + '&ratecenter=' + `${sdata.RateCenter}` + '&limit=' + `${pLoad.searchqty}`,
                'url': TelApiRecords.TelApiListUrl + TelApiRecords.TelApiKEY + '&state=' + `${sdata.State}` + '&ratecenter=' + `${sdata.RateCenter}` + '&limit=' + `${pLoad.searchqty}`,

                'headers': {
                    'Content-Type': 'application/json'
                }
            };
            request(options, (error: any, response: any) => {
                if (!error) {
                    try {
                        let ddata = JSON.parse(response.body);
                        console.log("ddata", JSON.stringify(ddata));
                        if (ddata.code == 200) {
                            if (ddata.data.dids != undefined && ddata.data.dids.length > 0) {
                                let str = ddata.data.dids;
                                let hsmpData:any= [];
                                let obj1 = new ModelRawNonQuery(req, res);
                                let qrystr = "INSERT INTO `did_search` (`idaccount`, `phone_number`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`,`billing_frequency`) VALUE";
                                str.forEach((ele: any) => {
                                    let hmp:any = {
                                        phone_number: ele.number,
                                        rate_center: parseBody(ele.rateCenter),
                                        state: parseBody(ele.state),
                                        supplier_tier: parseBody(ele.tier),
                                        provider :'teleapi',
                                        rates:pLoad.rate
                                    };
                                    hsmpData.push(hmp)
                                    qrystr += "('" + this.sessdata.idaccount + "', '" + ele.number + "', '" + parseBody(ele.ratecenter) + "', '" + parseBody(ele.state) + "', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + setToZero(this.priority) + "','NN','" + ele.tier + "','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + pLoad.rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "','" + setToZero(pLoad.billingfreq) + "'),";
                                });
                                this.saveHmp(this.timekey, 'teleapi', hsmpData);
                                obj1.nonqrysql = qrystr.slice(0, -1);
                                obj1.prepare();
                                obj1.execute((err, data) => {
                                    callback(err, data);
                                });
                            } else {
                                callback('', ddata);
                            }
                        } else {
                            callback('', ddata);
                        }
                    }
                    catch (e) {
                        console.log("Error :: TeleApi->getByRate::", e);
                        callback(error, '');
                    }

                } else {
                    callback(error, '');
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'POST',
                        // 'url': 'https://apiv1.teleapi.net/dids/list?token=' + this.key + '&type=tollfree&limit=' + `${sdata.Qty}`,
                        'url': TelApiRecords.TelApiListUrl + TelApiRecords.TelApiKEY + '&type=tollfree&limit=' + `${sdata.Qty}`,
                        'headers': {
                            'Content-Type': 'application/json'
                        }
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let ddata = JSON.parse(response.body);
                                console.log("ddata", ddata);
                                console.log(ddata.code);
                                if (ddata.code == 200) {
                                    if (ddata.data.dids != undefined && ddata.data.dids.length > 0) {
                                        let str = ddata.data.dids;
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`idaccount` `phone_number`, `provider`, `iduser`, `priorty`,`type`,`supplier_rate`,`rates`,`path`,`idapi`,`key`) VALUE";
                                        str.forEach((ele: any) => {
                                            qrystr += "('" + this.sessdata.idaccount + "', '" + ele.number + "', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + setToZero(this.priority) + "','TF','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    } else {
                                        callback('', ddata);
                                    }
                                } else {
                                    callback('', ddata);
                                }
                            }
                            catch (e) {
                                console.log("Error :: TeleApi->getTollFree::", e);
                                callback(error, '');
                            }

                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let types: any;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let id_grouporder: number = other_data.id_grouporder;
        let sub_type: number = other_data.sub_type;
        let days:any = other_data.days;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''

            // To get the proration status
            /* let objv0 = new ModelRawQuery(req, res);
            // objv0.qrysql = "SELECT t.`proration`,t.`day_num` FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.qrysql = "SELECT t.`day_num`, DATE_FORMAT(IF(DATE_ADD(NOW(),INTERVAL t.day_num DAY) >NOW(), DATE_ADD(NOW(),INTERVAL t.day_num DAY),LAST_DAY(NOW())),'%Y-%m-%d %H:%i:%s') AS subscription_end_date FROM `user`u INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE u.iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((days_err, days) => {
                if (days_err == 1) { */
                    // let proration_status = days[0].proration;
                    let frates:number = other_data.fullrates;
                    let did_dis_days = days[0].day_num > 0 ? days[0].day_num : 0;
                    let prorate = typeof other_data.prorate != 'undefined' && other_data.prorate > 0 ? other_data.prorate : 0

                    types = did_details[0].type == 'TF' ? 'TF' : 'NN';
                    var options = {
                        'method': 'POST',
                        // 'url': 'https://apiv1.teleapi.net/dids/order?token=' + this.key + '&number=' + `${sdata.DID.trim()}`,
                        'url': TelApiRecords.TelApiOrderUrl + TelApiRecords.TelApiKEY + '&number=' + `${sdata.DID.trim()}`,
                        'headers': {
                            'Content-Type': 'application/json'
                        }
                    }
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                console.log("TeleAPI::", response.body)
                                let sdata1 = JSON.parse(response.body);
                                // If order successfully placed
                                if (sdata1.code == 200 && sdata1.status == 'success') {
                                    let providerOrderId: any = typeof sdata1.data.id != 'undefined' && sdata1.data.id ? sdata1.data.id : ''

                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`npa`,`nxx`,`ratecenter`,`state`,`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`sms_provider`,`did_disconnect_days`,`nrc_rates`,`did_sub_type`, `subscription_end_date`,`billing_frequency`,`nextbilling_cycle`,`pro_rates`) VALUE('" + npa + "','" + nxx + "','" + ratecenter + "','" + state + "','" + this.sessdata.idaccount + "','" + sdata1.data.user_id + "','completed','" + sdata1.data.number + "','teleapi','" + sdata1.data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + parseBody(sdata.InboundVoice) + "','" + parseBody(sdata.OutboundVoice) + "','" + parseBody(sdata.Connection) + "','" + parseBody(sdata.InboundSMS) + "','" + parseBody(sdata.OutboundSMS) + "','" + other_data.rateS + "','" + setToZero(this.sessdata.idapi) + "','teleapi','" + did_dis_days + "','" + other_data.nrc_rates + "','" + sub_type + "','" + days[0].subscription_end_date + "','" + setToZero(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "','" + prorate + "')";
                                     obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            console.log(prorate);
                                            let payLoadData = {
                                                funDetail: {
                                                    tableName: 'did_billing',
                                                    functionName: 'buyDID',
                                                    logName: 'DID Billing'
                                                },
                                                data: {
                                                    idaccount:this.sessdata.idaccount, did: sdata1.data.number,type: types,did_sub_type:sub_type, cost : prorate,billing_type : '2'
                                                }
                                            };
                                            insertdid.insertLog(req, res, payLoadData, (err_did, add_did) => {
                                                console.log("TeleApi => buyDID ", types, " :: ", add_did)
                                            });


                                            let payload = {
                                                idaccount: this.sessdata.idaccount,
                                                amount: prorate,
                                                purpose: 'buy a new DID',
                                                type: '-'
                                            };
                                            insertdid.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                console.log("buyDID => walletDeduction Wallet deduction response:", errorD, dataD);
                                            });
                                               
                                            let logPayload = {
                                                funDetail:{
                                                    tableName :'did_log',
                                                    functionName : 'buyDID',
                                                    logName : 'DID'
                                                },
                                                data:{
                                                    account_id: this.sessdata.idaccount,
                                                    status: 'completed',
                                                    provider: 'teleapi',
                                                    did: sdata1.data.number,
                                                    order_id: sdata1.data.id,
                                                    type: types,
                                                    npa: npa,
                                                    nxx: nxx,
                                                    state: state,
                                                    disconnect_did_status: 1,
                                                    iduser: this.sessdata.iduser,
                                                    ratecenter: ratecenter,
                                                    rates: other_data.rateS,
                                                    idapi: this.sessdata.idapi,
                                                    pro_rates: prorate,
                                                    full_log: response.body,
                                                    description: 'DID Buy',
                                                    event_type: 1
                                                }                                
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { 
                                                });

                                            // To delete the DID from cart
                                            let obj5 = new ModelRawNonQuery(req, res);
                                            obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                            obj5.prepare();
                                            obj5.execute((walletError: any, wallet: any) => { });

                                            // To update the process count of group order
                                            let objk = new ModelRawNonQuery(req, res)
                                            objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";"
                                            objk.prepare()
                                            objk.execute((error, result) => {
                                                console.log("GroupOrder process count::\n", result)
                                            })

                                            // To create the did_order
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201','" + sdata.DID + "', '2', '" + types + "', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                            obj.prepare();
                                            obj.execute((did_err, did_data) => {
                                                // To update the other data on current order
                                                if (did_err == 1) {
                                                    let id_order: number = did_data.insertId
                                                    let orderID: string = "SORD" + id_order.toString()

                                                    let log_error: string = ""
                                                    let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                    let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                    obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='teleapi', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                                    obj.prepare();
                                                    obj.execute((error, result) => { })
                                                }

                                                let objV = new RawView(res);
                                                objV.prepare({
                                                    error_code: 1,
                                                    status: 201,
                                                    message: "DID buy successfully.",
                                                    result: [
                                                        {
                                                            "did": sdata.DID
                                                        }
                                                    ]
                                                });
                                                objV.execute()
                                            });                                            
                                        }
                                        else {
                                            let obj = new RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection"
                                            });
                                            obj.execute()
                                        }
                                    });
                                    
                                }

                                // If order failed
                                else {
                                    let providerOrderId: any = typeof sdata1.data.id != 'undefined' && sdata1.data.id ? sdata1.data.id : ''

                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', '" + types + "', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order: number = did_data.insertId
                                            let orderID: string = "SORD" + id_order.toString()

                                            let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_message: string = sdata1.data.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_result: string = ""

                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='teleapi', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                            obj.prepare();
                                            obj.execute((error, result) => { })
                                        }

                                        // To update the status of group order
                                        let objk = new ModelRawNonQuery(req, res)
                                        objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";"
                                        objk.prepare()
                                        objk.execute((error, result) => {
                                            console.log("Failed")
                                        });

                                        // let objn = new ModelRawNonQuery(req, res);
                                        // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                                        // objn.prepare();
                                        // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                        //     console.log("DID Buy failed from provider");
                                        // });
                                        let logPayload = {
                                            funDetail:{
                                                tableName :'did_log',
                                                functionName : 'buyDID',
                                                logName : 'DID'
                                            },
                                            data:{
                                                account_id: this.sessdata.idaccount,
                                                did: sdata.DID.trim(),
                                                full_log: response.body,
                                                iduser: this.sessdata.iduser,
                                                event_type: 40,
                                                description: 'DID Buy failed from provider',
                                            }                                
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { 
                                            console.log("DID Buy failed from provider");
                                         });

                                        let objV = new RawView(res);
                                        objV.prepare({
                                            error_code: 0,
                                            status: sdata1.code,
                                            message: sdata1.data,
                                            error: sdata1
                                        });
                                        objV.execute()
                                    });
                                }
                            }
                            catch (e) {
                                console.log("Error :: TeleApi->buyDID::", e);
                                let obj = new RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 400,
                                    error: error
                                });
                                obj.execute()
                            }
                        }
                        else {
                            let obj = new RawView(res);
                            obj.prepare({
                                error_code: 0,
                                status: 400,
                                error: error
                            });
                            obj.execute()
                        }
                    });

                /* }
                else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            }); */
        });
    }

    disconnectDID(req: Request, res: Response, userPayLoad:any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        var options = {
            // 'url': 'https://apiv1.teleapi.net/user/dids/remove?token=' + this.key + '&number=' + `${sdata.DID.trim()}`,
            'url': TelApiRecords.TelApiRemoveUrl + TelApiRecords.TelApiKEY + '&number=' + `${sdata.DID.trim()}`,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        request(options, (error: any, response: any) => {
            console.log("TeleAPI Err::", error)
            if (!error) {
                try {
                    console.log("TeleAPI Res::", response.body)
                    let data = JSON.parse(response.body);
                    if (data.code == 200) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE TRIM(`did`)=" + sdata.DID.trim() + " AND `account_id`='" + userPayLoad.idaccount + "'";
                        obj.prepare();
                        obj.execute((error: any, resp: any) => {
                            if (error == 1) {
                                // To  update updated_at date in did log
                                // let obj = new ModelRawQuery(req, res);
                                // obj.qrysql = "UPDATE `did_log` SET `updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                // obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`disconnect_did_status`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "','3','" + response.body + "')"
                                // obj.prepare();
                                // obj.execute((errorDiDLg: any, resDiDLg: any) => { });
                                let logPayload = {
                                    funDetail:{
                                        tableName :'did_log',
                                        functionName : 'disconnectDID',
                                        logName : 'DID'
                                    },
                                    data:{
                                        account_id: userPayLoad.idaccount,
                                        did: sdata.DID.trim(),
                                        full_log: response.body,
                                        iduser: userPayLoad.iduser,
                                        event_type: 5,
                                        description: 'Disconnect DID from provider',
                                        disconnect_did_status:3
                                    }                                
                                };
                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { 
                                 });

                                let pAyLoad = {
                                    idaccount: userPayLoad.idaccount,
                                    did: sdata.DID.trim()
                                }
                                insertdid.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                                    if (erroR == 1) {
                                        console.log("Deleted Successfully");
                                    } else {
                                        console.log("Deleted Not Successfully", resulT.message);
 
                                    }
                                });
 
                                let objv = new RawView(res);
                                objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        // let objn = new ModelRawNonQuery(req, res);
                        // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'39','DID disconnect failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                        // objn.prepare();
                        // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                        //     console.log("DID disconnect failed FROM provider");
                        // });
                        let logPayload = {
                            funDetail:{
                                tableName :'did_log',
                                functionName : 'disconnectDID',
                                logName : 'DID'
                            },
                            data:{
                                account_id: userPayLoad.idaccount,
                                did: sdata.DID.trim(),
                                full_log: response.body,
                                iduser: userPayLoad.iduser,
                                event_type: 39,
                                description: 'DID disconnect failed from provider',
                            }                                
                        };
                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { 
                            console.log("DID disconnect failed FROM provider");
                         });
                        let objv = new RawView(res);
                        objv.prepare({ status: data.code, message: data.status, error: data.data });
                        objv.execute();
                    }
                }
                catch (e) {
                    console.log("Error :: TeleApi->disconnectDID::", e);
                    let objv = new RawView(res);
                    objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                    objv.execute();
                }
            }
            else {
                console.log("TeleApi :::::::::::::::::::");
                let objv = new RawView(res);
                objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                objv.execute();
            }
        });
    }

}