import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { Res406 } from "../lib/view/406";
import { Res403 } from "../lib/view/403";
import { modAgent } from "../config/module.config";
import { ModelLogin } from "../lib/model/ModelLogin";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { checkDid, checkGroupKey, checkvalue, isMissing, parseBody, setToZero } from "./markError";
import { APIBase } from "./APIBase";
const Str = require('@supercharge/strings');
let validuser = new APIBase();

export class AgentClass {
	constructor() {}

	addAgent(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						var sdata = req.body;
						console.log(sdata);
						const name = Math.floor(1000000 + Math.random() * 9000000);
						const contact = 'user/' + name;
						const agent_key = Str.random(12);
						let message: any = '';
						// const isMissing = (val: any) => val == undefined || val == null || (typeof val == 'string' && val.trim() == '');
						const requiredFields = ['UserName', 'Password', 'Group', 'VmPin', 'CallerId', 'FullName'];
						switch (true) {
							case (!sdata || typeof sdata != 'object' || Object.keys(sdata).length == 0):
								message = "Missing request body";
								break;
							case requiredFields.some(key => isMissing(sdata[key])):
								const missingKeys = requiredFields.filter(key => isMissing(sdata[key]));
								message = "Missing required : " + missingKeys.join(', ');
								break;
							case (sdata.FullName && (checkvalue(sdata.FullName) || !/^(?!\s*$).+$/i.test(sdata.FullName))):
								message = "FullName is Invalid";
								break;
							case (sdata.UserName && (checkvalue(sdata.UserName) || !/^\S+$/.test(sdata.UserName))):
								message = "UserName is Invalid";
								break;
							case (sdata.Password && (sdata.Password.length < 5 || sdata.Password.length > 50)):
								message = "Password must be at minimum 5 characters and Maximum 50 Characters Allowed";
								break;
							case (sdata.VmPin && !/^[0-9]{4}$/.test(sdata.VmPin.toString())):
								message = "VM Pin Only 4 Digit Integer Long.";
								break;
							case (sdata.Group && checkGroupKey(sdata.Group) != ''):
								message = checkGroupKey(sdata.Group);
								break;
							case (sdata.CallerId && checkDid(sdata.CallerId) != ''):
								message = checkDid(sdata.CallerId);
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ message: message, status: 501 });
							objv.execute();
						}else{
							let obj1 = new ModelRawQuery(req, res);
							obj1.qrysql = "SELECT `username` FROM agents WHERE `username` = '" + parseBody(sdata.UserName) + "'";
							obj1.prepare();
							obj1.execute((__error: any, agents: any) => {
								if (__error == 1) {
									if (agents.length > 0) {
										let objv = new RawView(res);
										objv.prepare({
											message: "Username Already Exists!",
											status: 404
										});
										objv.execute();
									}
									else {
										let obj = new ModelRawNonQuery(req, res);
										obj.nonqrysql = "INSERT INTO `agents` (`iduser`, `name`, `username`, `password`, `full_name`, `contact`, `system`, `callerid`, `agent_key`, `group`, `vm_pin`) VALUES(" + sessdata.iduser + ",'" + name + "', '" + parseBody(sdata.UserName) + "', '" + parseBody(sdata.Password) + "', '" + parseBody(sdata.FullName).trim() + "', '" + contact + "', 'single_box', '" + sdata.CallerId + "', '" + agent_key + "', '" + sdata.Group + "', " + setToZero(sdata.VmPin) + ")";
										obj.prepare();
										obj.execute((_error: any, result: any) => {
											if (_error == 1) {
												let objv = new RawView(res);
												objv.prepare({ status: 201, message: "Agent Added Successfully!" });
												objv.execute();
											}
											else {
												let objv = new RawView(res);
												objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
												objv.execute();
											}
										});
									}
								}
								else {
									let objv = new RawView(res);
									objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: agents });
									objv.execute();
								}
							});
						}
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						// objv.prepare({ status: 502, message: "Service Unavailable!" });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	updateAgent(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						var sdata = req.body;
						let obj = new ModelRawNonQuery(req, res);
						let str = '';
						let message: any = '';
						switch (true) {
							case (!sdata || typeof sdata != 'object' || Object.keys(sdata).length == 0):
								message = "Missing request body";
								break;
							case (sdata.FullName && (checkvalue(sdata.FullName) || !/^(?!\s*$).+$/i.test(sdata.FullName))):
								message = "FullName is Invalid";
								break;
							case (sdata.UserName && (checkvalue(sdata.UserName) || !/^\S+$/.test(sdata.UserName))):
								message = "UserName is Invalid";
								break;
							case (sdata.Password && (sdata.Password.length < 5 || sdata.Password.length > 50)):
								message = "Password must be at minimum 5 characters and Maximum 50 Characters Allowed";
								break;
							case (sdata.VmPin && !/^[0-9]{4}$/.test(sdata.VmPin.toString())):
								message = "VM Pin Only 4 Digit Integer Long.";
								break;
							case (sdata.CallerId && checkDid(sdata.CallerId) != ''):
								message = checkDid(sdata.CallerId);
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ message: message, status: 501 });
							objv.execute();
						} else {
							if (sdata.FullName) {
								str += '`full_name`="' + parseBody(sdata.FullName).trim() + '", '
							}
							if (sdata.UserName) {
								str += '`username`="' + parseBody(sdata.UserName) + '", '
							}
							if (sdata.Password) {
								str += '`password`="' + parseBody(sdata.Password) + '", '
							}
							if (sdata.CallerId) {
								str += '`callerid`="' + sdata.CallerId + '", '
							}
							if (sdata.VmPin) {
								str += '`vm_pin`="' + setToZero(sdata.VmPin) + '"'
							}
							str = str.trim().replace(/,\s*$/, "");
							obj.nonqrysql = "UPDATE `agents` SET " + str + " WHERE idagent = " + sdata.IdAgent + "";
							// obj.nonqrysql = "UPDATE `agents` SET `full_name` = '" + sdata.FullName + "', `username` = '" + sdata.UserName + "', `password` = '" + sdata.Password + "' where idaccount = '" + sessdata.idaccount + "' AND idagent = '" + sdata.IdAgent + "'";
							obj.prepare();
							obj.execute((_error: any, result: any) => {
								if (_error == 1) {
									let objv = new RawView(res);
									objv.prepare({ message: "Agent Updated Successfully!", status: 201 });
									objv.execute();
								} else {
									let objv = new RawView(res);
									objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
									objv.execute();
								}
							});
						}
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						// objv.prepare({ status: 502, message: "Service Unavailable!" });
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	updateAgentStatus(req: Request, res: Response, next: NextFunction) {
		var sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "UPDATE `agents` SET `status` = '" + sdata.status + "' AND idagent = " + sdata.idagent + "";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Agent Status Updated Successfully!", data: result, status: 201 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getAgents(req: Request, res: Response, next: NextFunction) {
		var sdata:any = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
					let con, message:any = "";
					let groupKey = (sdata.groupKey == undefined || sdata.groupKey == null || sdata.groupKey == 'undefined' || sdata.groupKey == 'null') ? "" : String(sdata.groupKey).trim();
					switch(true){
						case (groupKey && checkGroupKey(groupKey) != ''):
							message = checkGroupKey(groupKey);
							break;
						case (groupKey && checkvalue(groupKey)):
							message = "Groupkey is invalid";
							break;
						default:
							message = "";
					}
					if(message){
						let objv = new RawView(res);
						objv.prepare({ message: message, status: 501 });
						objv.execute();
					}else{
						if (sdata.groupKey && sdata.groupKey !== undefined && sdata.groupKey !== 'undefined' && sdata.groupKey !== null && sdata.groupKey !== 'null') {
							con = "AND `group`='" + sdata.groupKey + "'";
						}
						let obj = new ModelRawQuery(req, res);
						obj.qrysql = "SELECT `agent_key`, `idagent`, `name`, `full_name`, `username`, `password`, `vm_pin` from `agents` WHERE `iduser` = " + sessdata.iduser + " " + con + " ";
						obj.prepare();
						obj.execute((_error: any, result: any) => {
							if (_error == 1) {
								let objv = new RawView(res);
								objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
								objv.execute();
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
								objv.execute();
							}
						});	
					}				
				}
                else{
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    // objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();                    
                } 				
			})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getSingleAgent(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let ext_field:any;
				if(sessdata.type==1){
					ext_field="`iduser`,"
				}
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT "+ext_field+" `idagent`,`name`,`full_name`,`username`,`password`,`group`,`vm_pin`,`callerid` FROM `agents` WHERE `iduser` = " + sessdata.iduser + " AND `idagent`=" + req.query.type + "";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getAllAgent(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						let sdata:any = req.query;
						let message:any = "";
						switch (true) {
							case (!sdata || !('GroupName' in sdata)):
								message = 'Missing GroupName parameter';
								break;
							case (!sdata.GroupName || isMissing(sdata.GroupName)):
								message = "GroupName is required";
								break;
							case (sdata.GroupName && checkvalue(sdata.GroupName)):
								message = "GroupName is invalid";
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ status: 501, message: message });
							objv.execute();
						} else {
							let obj1 = new ModelRawQuery(req, res);
							obj1.qrysql = "SELECT `group_key` FROM `group` WHERE `iduser`=" + sessdata.iduser + " AND `group_name`='" + sdata.GroupName + "'";
							obj1.prepare();
							obj1.execute((error1: any, result1: any) => {
								if (error1 == 1 && result1.length > 0) {
								let obj = new ModelRawQuery(req, res);
								obj.qrysql = "SELECT `idagent`,`iduser`,`name`,`full_name`,`username`,`password`,`group`,`vm_pin`,`callerid` FROM `agents` WHERE `iduser`=" + sessdata.iduser + " AND `group`='" + result1[0].group_key + "'";
								obj.prepare();
								obj.execute((_error: any, result: any) => {
									if (_error == 1) {
										let objv = new RawView(res);
										objv.prepare({ message: "Agent List Get Successfully!", data: result, status: 200 });
										objv.execute();
									} else {
										let objv = new RawView(res);
										objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
										objv.execute();
									}
								});
								}else{
									let objv = new RawView(res);
									objv.prepare({status: 502, message: "Something went wrong with Groupname/invalid groupname"});
									objv.execute();
								}
							})
						}
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						// objv.prepare({ status: 502, message: "Service Unavailable!" });
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getAgent(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						let data: any = req.query;
						let message: any = "";
						switch (true) {
							case (!data || !('username' in data)):
								message = 'Missing username parameter';
								break;
							case (!data.username || isMissing(data.username)):
								message = "Username is required";
								break;
							case (data.username && checkvalue(data.username)):
								message = "Username is invalid";
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ status: 501, message: message });
							objv.execute();
						} else {
							let obj = new ModelRawQuery(req, res);
							obj.qrysql = "SELECT `idagent`,`full_name`,`contact`,`status`,`state`,`max_no_answer`,`wrap_up_time`,`reject_delay_time`,`busy_delay_time`,`no_answer_delay_time`,`last_bridge_start`,`last_bridge_end`,`last_offered_call`,`last_status_change`,`no_answer_count`,`calls_answered`,`talk_time`,`ready_time`,`extension`,`group` FROM `agents` WHERE `iduser` = " + sessdata.iduser + " AND `username`='" + req.query.username + "'";
							obj.prepare();
							obj.execute((_error: any, result: any) => {
								if (_error == 1) {
									let objv = new RawView(res);
									objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
									objv.execute();
								}
								else {
									let objv = new RawView(res);
									objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
									objv.execute();
								}
							});
						}
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	deleteAgent(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						let sdata: any = req.query;
						let message: any = "";
						switch (true) {
							case (!sdata || !('id' in sdata)):
								message = 'Missing id parameter';
								break;
							case (!sdata.id || isMissing(sdata.id)):
								message = "id is required";
								break;
							case (sdata.id && !/^[1-9]\d*$/.test(sdata.id)):
								message = "id is invalid";
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ status: 501, message: message });
							objv.execute();
						} else {
							let obj = new ModelRawNonQuery(req, res);
							obj.nonqrysql = "DELETE FROM `agents` where `idagent`=" + sdata.id + "";
							obj.prepare();
							obj.execute((_error: any, result: any) => {
								if (_error == 1) {
									let objv = new RawView(res);
									objv.prepare({ message: "Agent Deleted Successfully!", data: result, status: 201 });
									objv.execute();
								}
								else {
									let objv = new RawView(res);
									objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
									objv.execute();
								}
							});
						}
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						// objv.prepare({ status: 502, message: "Service Unavailable!" });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	addGroup(req: Request, res: Response, next: NextFunction) {
		var sdata = req.body;
		console.log(sdata);
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						let message: any = '';
						// const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
						// const isMissing = (val: any) => val == undefined || val == null || (typeof val == 'string' && val.trim() == '');
						const strategyOptions = ['ring-all', 'longest-idle-agent', 'round-robin', 'top-down', 'agent-with-least-talk-time', 'agent-with-fewest-calls', 'sequentially-by-agent-order', 'random', 'ring-progressively'];
						const requiredFields = ['GroupName', 'Description', 'TierRulesApply', 'Strategy'];
						switch (true) {
							case (!sdata || typeof sdata != 'object' || Object.keys(sdata).length == 0):
								message = "Missing request body.";
								break;
							case requiredFields.some(key => isMissing(sdata[key])):
								const missingKeys = requiredFields.filter(key => isMissing(sdata[key]));
								message = "Missing required : " + missingKeys.join(', ');
								break;
							case (sdata.GroupName && checkvalue(sdata.GroupName)):
								message = "GroupName is Invalid";
								break;
							case (sdata.Description && checkvalue(sdata.Description)):
								message = "Description is Invalid";
								break;
							case ('TierRulesApply' in sdata && !(sdata.TierRulesApply == 'true' || sdata.TierRulesApply == 'false' || sdata.TierRulesApply == true || sdata.TierRulesApply == false)):
								message = "TierRulesApply must be 'true' or 'false'.";
								break;
							case ('Strategy' in sdata && !strategyOptions.includes(sdata.Strategy)):
								message = "Strategy value is Invalid";
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ message: message, status: 501 });
							objv.execute();
							return;
						}
						let obj1 = new ModelRawQuery(req, res);
						obj1.qrysql = "SELECT * FROM `group` where `group_name` = '" + parseBody(sdata.GroupName) + "' AND `iduser`=" + sessdata.iduser + "";
						obj1.prepare();
						obj1.execute((_error: any, group: any) => {
							if (_error == 1) {
								if (group.length > 0) {
									let objv = new RawView(res);
									objv.prepare({
										message: "Group Name Already Exists In Your Group List!",
										status: 404
									});
									objv.execute();
								}
								else {
									const group_key = Str.random(10);
									let tierrules: any = sdata.TierRulesApply ? sdata.TierRulesApply : 'false';
									let obj = new ModelRawNonQuery(req, res);
									obj.nonqrysql = "INSERT INTO `group` (`iduser`, `group_name`, `strategy`, `tier_rules_apply`, `description`, `group_key`) VALUES (" + sessdata.iduser + ",'" + parseBody(sdata.GroupName) + "', '" + sdata.Strategy + "', '" + tierrules + "', '" + parseBody(sdata.Description) + "', '" + group_key + "')";
									obj.prepare();
									obj.execute((__error: any, result: any) => {
										if (__error == 1) {
											let objv = new RawView(res);
											objv.prepare({ message: "Group Added Successfully!", status: 201 });
											objv.execute();
										}
										else {
											let objv = new RawView(res);
											objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
											objv.execute();
										}
									});
								}
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: group });
								objv.execute();
							}
						});
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	updateGroup(req: Request, res: Response, next: NextFunction) {
		var sdata: any = req.body;
		console.log(sdata)
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
						let message: any = '';
						// const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
						const strategyOptions = ['ring-all', 'longest-idle-agent', 'round-robin', 'top-down', 'agent-with-least-talk-time', 'agent-with-fewest-calls', 'sequentially-by-agent-order', 'random', 'ring-progressively'];
						switch (true) {
							case (!sdata || typeof sdata != 'object' || Object.keys(sdata).length == 0):
								message = "Missing request body.";
								break;
							case (sdata.GroupName && checkvalue(sdata.GroupName)):
								message = "GroupName is Invalid";
								break;
							case (sdata.Description && checkvalue(sdata.Description)):
								message = "Description is Invalid";
								break;
							case ('TierRulesApply' in sdata && sdata.TierRulesApply != '' && !(sdata.TierRulesApply == 'true' || sdata.TierRulesApply == 'false')):
								message = "TierRulesApply must be 'true' or 'false'.";
								break;
							case ('Strategy' in sdata && sdata.Strategy != '' && !strategyOptions.includes(sdata.Strategy)):
								message = "Strategy value is Invalid";
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ message: message, status: 501 });
							objv.execute();
							return;
						}
						let obj1 = new ModelRawQuery(req, res);
						obj1.qrysql = "SELECT id_group,iduser,group_name,strategy,tier_rules_apply,description,group_key FROM `group` where `id_group` = '" + sdata.idgroup + "' AND `iduser`=" + sessdata.iduser + "";
						obj1.prepare();
						obj1.execute((_error: any, group_res: any) => {
							if (group_res.length > 0) {
								// let objv = new RawView(res);
								// objv.prepare({ message: "Group Name Already Exists In Your Group List!!", status: 502 });
								// objv.execute();
								// }
								// else {
								let obj = new ModelRawNonQuery(req, res);
								let str = '';
								let tierrules: any = sdata.TierRulesApply ? sdata.TierRulesApply : 'false';
								if (sdata.GroupName) {
									str += '`group_name`="' + parseBody(sdata.GroupName) + '", '
								}
								if (sdata.Strategy) {
									str += '`strategy`="' + sdata.Strategy + '", '
								}
								if (tierrules) {
									str += '`tier_rules_apply`="' + tierrules + '", '
								}
								if (sdata.Description) {
									str += '`description`="' + parseBody(sdata.Description) + '", '
								}
								str = str.trim().replace(/,\s*$/, "");
								obj.nonqrysql = "UPDATE `group` SET " + str + "  WHERE `id_group` = " + sdata.idgroup + "";
								obj.prepare();
								obj.execute((_error: any, result: any) => {
									if (_error == 1) {
										let objv = new RawView(res);
										objv.prepare({ message: "Group Updated Successfully!", status: 201 });
										objv.execute();
									}
									else {
										let objv = new RawView(res);
										objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
										objv.execute();
									}
								});
							}
						});					
					}
					else{
						let objv = new RawView(res);
						objv.prepare(dt);
						// objv.prepare({ status: 502, message: "Service Unavailable!" });
						objv.execute();                    
					} 				
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getGroup(req: Request, res: Response, next: NextFunction) {
		var sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT g.group_name, g.group_key, g.id_group, GROUP_CONCAT(a.full_name) `agents` FROM `group` g LEFT JOIN tiers t ON g.group_key=t.queue LEFT JOIN agents a ON a.name=t.agent WHERE g.iduser= '" + sessdata.iduser + "' GROUP BY g.id_group ";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Group Fetched Successfully!", data: result, status: 200 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
							objv.execute();
						}
					});					
				}
                else{
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    // objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();                    
                } 				
			});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getSingleGroup(req: Request, res: Response, next: NextFunction) {
		var sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let ext_field:any;
				if(sessdata.type==1){
					ext_field="`iduser`,"
				}
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT  "+ext_field+" `id_group` , `group_name`, `strategy` , `tier_rules_apply` , `description`, `group_key` from `group` where `iduser` = " + sessdata.iduser + " AND `id_group`=" + req.query.type + "";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Agent Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	deleteGroup(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
					if (err == 1) {
						let data:any =req.query;
						let message: any = '';
						switch (true) {
							case (!data || !('id' in data)):
								message = "Missing Parameter : id";
								break;
							case (data.id == '' || data.id == 'null' || data.id == 'undefined' || !/^[1-9]\d*$/.test(data.id)):
								message = "Group Id is Invalid";
								break;
							default:
								message = "";
						}
						if (message) {
							let objv = new RawView(res);
							objv.prepare({ message: message, status: 501 });
							objv.execute();
							return;
						}
						let obj = new ModelRawNonQuery(req, res);
						obj.nonqrysql = "DELETE from `group` where `id_group`=" + data.id + "";
						obj.prepare();
						obj.execute((_error: any, result: any) => {
							if (_error == 1) {
								let objv = new RawView(res);
								objv.prepare({ message: "Group Deleted Successfully!", data: result, status: 201 });
								objv.execute();
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
								objv.execute();
							}
						});
					}
					else {
						let objv = new RawView(res);
						objv.prepare(dt);
						// objv.prepare({ status: 502, message: "Service Unavailable!" });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getGroups(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 1 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `group_name`, `group_key` FROM `group` WHERE  iduser = " + sessdata.iduser + "";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Group Fetched Successfully!", data: result, status: 200 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
							objv.execute();
						}
					});					
				}
                else{
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    // objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();                    
                } 				
			})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	agentLogin(req: Request, res: Response, next: NextFunction) {
		req.body = { username: req.body.Username, password: req.body.Password };
		let obj = new ModelLogin(req, res);
		let swlogin = new modAgent();
		if (obj.prepare(swlogin)) {
			obj.execute((error: any, result: any) => {
				if (error == 2) {
					let session = new SessionManagment(req, res, next);
					session.SetSession(result, (error, sessdata) => {
						if (result.authkey !== undefined) {
							// if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
							validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
	                           let authkey = result.authkey;
								let obj1 = new ModelRawNonQuery(req, res);
								obj1.nonqrysql = "UPDATE `agents` SET `status`='Logged In' WHERE `idagent` = " + result.idagent + "";
								obj1.prepare();
								obj1.execute((err: any, resp: any) => {
									if (err == 1) {
										let objv = new RawView(res);
										objv.prepare({ "sessionkey": authkey });
										objv.execute();
									} else {
										let objv = new RawView(res);
										objv.prepare({ message: "Invalid Authkey!" });
										objv.execute();
									}
								})								
							}
							else{
								let objv = new RawView(res);
								objv.prepare(dt);
								// objv.prepare({ status: 502, message: "Service Unavailable!" });
								objv.execute();                    
							} 	
						});						
							
						} else {
							let objv = new RawView(res);
							objv.prepare("Invalid Session");
							objv.execute();
						}
					});
				} else {
					let objv = new Res403(res);
					objv.prepare({ error: "Invalid Username and password to set proper session" });
					objv.execute();
				}
			});
		}
	}

	agentLogout(req: Request, res: Response, next: NextFunction) {
		var sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `idagent` from `session` where `authkey`='" + sdata.Session + "'";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (result.length > 0) {
							let obj1 = new ModelRawNonQuery(req, res);
							obj1.nonqrysql = "UPDATE `agents` SET `status`='Logged Out' WHERE `idagent` = " + result[0].idagent + "";
							obj1.prepare();
							obj1.execute((err: any, rep: any) => {
								if (err == 1) {
									let obj2 = new ModelRawNonQuery(req, res);
									obj2.nonqrysql = "DELETE FROM `session` WHERE `idagent` = " + result[0].idagent + "";
									obj2.prepare();
									obj2.execute((err1: any, resp: any) => {
										if (err1 == 1) {
											let obj3 = new RawView(res);
											obj3.prepare({ Result: "Agent Logout Successfully", status: 201 });
											obj3.execute();
										} else {
											let obj3 = new RawView(res);
											obj3.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
											obj3.execute();
										}
									});
								} else {
									let obj2 = new RawView(res);
									obj2.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
									obj2.execute();
								}
							});
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "No Data Found!", status: 502, error: result });
							objv.execute();
						}
					});					
				}
                else{
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    // objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();                    
                } 				
			})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	changeStatus(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let status = req.body.AgentStatus === "Ready" ? "Available" : "On Break";
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203) {
				validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `idagent` from `session` where `authkey`='" + sdata.Session + "'";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							if (result.length > 0) {
								let obj1 = new ModelRawNonQuery(req, res);
								obj1.nonqrysql = "UPDATE `agents` SET `status`='" + status + "' WHERE `idagent` = '" + result[0].idagent + "'";
								obj1.prepare();
								obj1.execute((err: any, rep: any) => {
									if (err == 1) {
										let obj2 = new RawView(res);
										obj2.prepare({ message: "Update Agent Status Successfully", status: 201 });
										obj2.execute();
									} else {
										let obj2 = new RawView(res);
										obj2.prepare({ message: "Something Went Wrong With Connection", error: result, status: 502 });
										obj2.execute();
									}
								});
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ message: "No Data Found!", status: 502, error: result });
								objv.execute();
							}
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", error: result, status: 502 });
							objv.execute();
						}
					});					
				}
                else{
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    // objv.prepare({ status: 502, message: "Service Unavailable!" });
                    objv.execute();                    
                } 				
			});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	// To Send Channel Request
	saveChannelRequest(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let rdata: any = req.body.data;
				let obj2 = new ModelRawNonQuery(req, res);
				obj2.nonqrysql = "INSERT INTO channel_request (`iduser`,`idaccount`,`current_in_channel_limit`, `current_out_channel_limit`, `request_in_channel_limit`,`request_out_channel_limit`) VALUES(" + sessdata.iduser + "," + sessdata.idaccount + ",'" + setToZero(rdata.current_in_channel_limit) + "', '" + setToZero(rdata.current_out_channel_limit) + "', '" + setToZero(rdata.request_in_channel_limit) + "', '" + setToZero(rdata.request_out_channel_limit) + "')";
				obj2.prepare();
				obj2.execute((_error: any, allcamp: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ status: 200, message: "Channel Request Send Successfully!" });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ status: 501, message: "Channel Request Not Sent!" });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare("No session data there");
				objv.execute();
			}
		});
	}

	channelRequestList(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				var sdata = req.query;
				let ext_field:any;
				let condition: any;
				if (sessdata.type == 1){
					condition = sdata.type !== null && sdata.type !== undefined && sdata.type ? "WHERE `idaccount`= '" + sdata.type + "'" : '';
					ext_field=" `iduser`,`idaccount`,";
				}

				if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
					condition = "WHERE `idaccount`= " + sessdata.idaccount + "";

				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT "+ext_field+" `channel_id`, `current_in_channel_limit`,`current_out_channel_limit`,`request_in_channel_limit`,`request_out_channel_limit`,`created_at`,`updated_at`,`status` FROM `channel_request` " + condition + " ORDER BY  `channel_id` DESC";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						if (result.length > 0) {
							let objv = new RawView(res);
							objv.prepare({ message: "Channel Requests Fetched Successfully!", data: result, status: 200 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "No Channel Requests Available!", data: result, status: 404 });
							objv.execute();
						}
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "List Not Fetched Successfully!", status: 502, error: result });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	changeChanelStatus(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let data: any = req.body.data;
				let msgSuc: any;
				let msgErr: any;
				if (data.status == '1') {
					msgSuc = "Channel Limit Approved Successfully!";
					msgErr = "Channel Limit Not Approved!";
				}
				if (data.status == '2') {
					msgSuc = "Channel Limit Rejected Successfully!";
					msgErr = "Channel Limit Not Rejected!";
				}

				let obj1 = new ModelRawNonQuery(req, res);
				obj1.nonqrysql = "UPDATE `channel_request` SET `status`='" + data.status + "',`updated_at`=NOW() WHERE `channel_id`=" + data.channel_id + "";
				obj1.prepare();
				obj1.execute((error: any, result: any) => {
					if (error == 1) {
						if (data.status == '1') {
							let obj0 = new ModelRawNonQuery(req, res);
							obj0.nonqrysql = "UPDATE `account` SET `ib_channel`='" + setToZero(data.request_in_channel_limit) + "',`ob_channel`='" + setToZero(data.request_out_channel_limit) + "' WHERE `idaccount`='" + data.idaccount + "'";
							obj0.prepare();
							obj0.execute((error: any, result: any) => { });
						}
						let objv = new RawView(res);
						objv.prepare({ status: 201, message: msgSuc });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ status: 502, message: msgErr });
						objv.execute();
					}
				});

			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

}
