import { RawView } from "../lib/view/RawView";

const Str = require('@supercharge/strings');
const jwt = require('jsonwebtoken');
const { networkInterfaces } = require('os');
/* const rateLimit = require('express-rate-limit');


const userRateLimiter = rateLimit({
    windowMs:  1 * 60 * 1000, // 15 minutes
    max: 1, // Limit each user to 5 requests per windowMs
    keyGenerator: (req:any) => req.uniqueuserid.id, // Use user ID as the key
    handler: (req:any, res:any) => {
        let objv = new RawView(res);
        objv.prepare({ status: 429, message: 'Too Many Requests. You have exceeded the request limit. Please try again later.' });
        objv.execute();
    }
}); */

// const checkDesc = (desc: any) => {
//     let result: any = '';
//     if (desc) {
//         result = desc.replace(/"/g, '\\"').replace(/'/g, "\\'");
//         return result;
//     } else {
//         result = '';
//         return result;
//     }
// }

const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+/;
const checkvalue = (val: any): boolean => {
    if (typeof val !== 'string') return true; // invalid if not string
    return !prgmch.test(val); // true if it doesn't pass regex (invalid)
};

const checkDid = (did: any): string => {
    if (typeof did !== 'string') return "DID is invalid";   // invalid if not string
    if (!/^[1-9]\d*$/.test(did)) return "DID must be digits with 10 digits integer";  // must be digits
    if (did.length != 10) return "DID must be digits with 10 digits";     // must be exactly 10 digits
    return '';   // valid
};

const checkGroupKey = (value: any): string => {
    if (typeof value !== 'string') {
        return "Group key must be a string";
    }
    if (!/^(?!.*[-_].*[-_])(?=.*[-_])?[A-Za-z0-9_-]{10}$/.test(value)) {
        return "Group key is invalid/must be 10 letter of string";
    }
    return '';
};

const checkConnectionKey = (value: any): string => {
    if (typeof value !== "string" || !/^[A-Za-z0-9_-]{30}$/.test(value)) {
        return "Connection key is invalid";
    }
    return "";
};
const checkCampaignId = (value: any): string => {
    if (typeof value !== "string" || !/^C[A-Z0-9]{6}$/.test(value)) {
        return "CampaignId must be exactly 7 characters long and start with 'C'!";
    }
    return "";
};
const checkBrandId = (value: any): string => {
    if (typeof value !== "string" || !/^[A-Za-z0-9_-]{30}$/.test(value)) {
        return "brandId Must be upper-case alphanumeric characters with prefix letter 'B'!";
    }
    return "";
};
const checkCustomerId = (value: any): string => {
    if (typeof value !== "string" || !/^cus_[A-Za-z0-9]{14}$/.test(value)) {
        return "Must start with 'cus_' followed by 14 alphanumeric characters (letters and digits)";
    }
    return "";
};

const wordpattern = /^[A-Za-z0-9]+(?: [A-Za-z0-9]+)*$/;
const isAlphanumeric = (val: any): boolean => {
  if (typeof val !== "string") return false; // invalid if not string
  return wordpattern.test(val); // true if invalid
};
 

const isMissing = (val: any): boolean => {
    return (!val || val == undefined ||
        val == null ||
        val == "undefined" ||
        val == "null" ||
        (typeof val === "string" && val.trim() === "")
    );
};

const isValidUrl = (value: string): boolean => {
    const urlPattern = /^(https?:\/\/)?(([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}|localhost|(\d{1,3}\.){3}\d{1,3})(:\d+)?(\/[^\s]*)?$/;
    return urlPattern.test(value.trim());
};
 
const universalZip = /^[A-Za-z0-9](?:[A-Za-z0-9 \-]{0,8}[A-Za-z0-9])?$/;
const isPostalCode = (value: any): boolean => {
  if (typeof value !== "string") return true;
  return !universalZip.test(value.trim());
};

const checkToDid = (field: string, value: any): string => {
    if (typeof value !== 'string') return `${field} is invalid`;   // invalid if not string
    if (!/^[1-9]\d*$/.test(value)) return `${field} must be digits with 10 digits integer`;  // must be digits
    if (value.length != 10) return `${field} must be digits with 10 digits`;     // must be exactly 10 digits
    return '';   // valid
};

const checkFromDid = (field: string, value: any): string => {
    if (typeof value !== "string") return `${field} number is invalid`; // must be string
    if (!/^[1-9]\d*$/.test(value)) return `${field} number must contain digits integer`; // must be digits
    if (value.length < 5 || value.length > 10) return `${field} number must be Valid`;
    return ""; // valid
};


const checkUserPayload = (sdata: any): { iduser: any; idaccount: any } | null => {
    let result = null;
    if (sdata?.iduser || sdata?.idaccount) {
        result = {
            iduser: sdata.iduser,
            idaccount: sdata.idaccount
        };
    }
    return result;
};

const parseBody = (desc: any): string => {
    let result = '';
    if (typeof desc === 'string') {
        result = desc
            .replace(/\\/g, '\\\\')
            .replace(/"/g, '\\"')
            .replace(/'/g, "\\'");
    }
    return result;
};
 
const setToZero = (data: any) => {
    let description = data ?? '';
    let dest :any= Number(description);
    if(dest == ''){
       return 0;
    }
    else{
        return data;
    }
}
const setEnum = (data: any) => {
    if (data === null || data === undefined || data === '') {
        return false;
    }
    return data;
}
const isNumber = (num: any) => {
    let result: any = '';
    let number: any = num ? num : 0;
    if (isNaN(number) == false && typeof parseInt(number) == "number") {
        result = number
        console.log("result :: ", result);
        return result;
    }
    else {
        result = 'NaN';
        console.log("result :: ", result);
        return result;
    }
}
const ipAddressAndBrowser = (req: any) => {
    /* login history Create  Token */
    let secret = Str.random(15);
    let Token = jwt.sign({
        exp: Math.floor(Date.now() / 1000),
    }, secret);

    //To Get ipaddress
    const nets = networkInterfaces();
    const ipAddress: any = [];
    for (const name of Object.keys(nets)) {
        for (const net of nets[name]) {
            const familyV4Value = typeof net.family === 'string' ? 'IPv4' : 4
            if (net.family === familyV4Value && !net.internal) {
                ipAddress.push(net.address);
            }
        }
    }
    /*To Get Browser Name */
    const userAgentString = req.headers['user-agent']
    const userAgent: any = userAgentString;
    let browserName = 'unknown';

    if (userAgent?.includes('Safari')) {
        browserName = 'Safari'
    }
    if (userAgent?.includes('Chrome')) {
        browserName = 'Google Chrome'
    }
    if (userAgent?.includes('Edg')) {
        browserName = 'Microsoft Edge'
    }
    if (userAgent?.includes('OPR')) {
        browserName = 'Opera'
    }
    if (userAgent?.includes('msie')) {
        browserName = 'Internet Explorer'
    }
    if (userAgent?.includes('Firefox')) {
        browserName = 'Firefox'
    }
    let sysInfo = {
        ipAddress: [req.headers['x-forwarded-for'] || req.socket.remoteAddress],
        browserName: browserName, uniqueToken: Token
    }
    return sysInfo;

}

//export default checkDesc
export default parseBody
export {isNumber, ipAddressAndBrowser, parseBody ,setToZero, setEnum, checkUserPayload,checkvalue,checkDid,checkGroupKey,isMissing,checkToDid,checkConnectionKey,checkCampaignId,checkBrandId,checkCustomerId,checkFromDid, isAlphanumeric, isValidUrl, isPostalCode};

