import { Request, Response, NextFunction } from "express";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res404 } from "../lib/view/404";
const stripepay = require("stripe");
// import { AppRoute } from "../lib/AppRoute";
import { isAlphanumeric, isPostalCode, isValidUrl, parseBody, setToZero } from "./markError";
/* import { sessiondata } from "../server"; */
import { KYCPDF, SMTPDetails, StripeApiKey } from "../config/setting.config";
import { APIBase } from "./APIBase";
import { SubscriptionManagement } from "./SubscriptionManagement";
let rate = new APIBase();
const kycpdf = new KYCPDF();
// var nodemailer = require("nodemailer");
const FromSmtpMail = new SMTPDetails();
const FromEmail = FromSmtpMail.from;

const  stripekey = new StripeApiKey();
const secret_key = stripekey.secret_key;

// const secret_key = "sk_test_51HAL9TGdXmhCeqBzWbxBTiVUDlCqizGP8NWwxDC8zIRKuef4i9kerhyixCqVZPw5Ik3fmfUe7BR2Wy2cUqrOZdWx00IQ2MEmbO";
//const secret_key = "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";

const isEmpty = (value: any): boolean => !value || value == 'undefined' || value == 'null' || undefined || value == null || value === '';
const isAlpha = (value: string): boolean => /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/.test(value);
const isValidPhone = (value: string): boolean => /^[0-9]+$/.test(value);
export class StripeApi {

    constructor() {
        // super();
    }

    RechargeByAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if(sessdata.type == 1){
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                    let sdata = req.body;
                    let CRate: any = typeof sdata.amount != 'undefined' && sdata.amount > 0 ? sdata.amount : 0;
                    if (CRate > 0) {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount`=" + sdata.idaccount;
                        obj2.prepare();
                        obj2.execute((_error: any, customer: any) => {
                            if (_error == 1) {
                                if (customer.length > 0) {
                                    let qry:any=null,type:any='';
                                    if (sdata.paymentType == "3") {
                                        type = '-';
                                        qry = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                    }
                                    else {
                                        type = '+';
                                        qry = "UPDATE `wallet` SET `balance`=`balance`+" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                    }
                                    if(qry != null){
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = qry;
                                        obj.prepare();
                                        obj.execute((error: any, result: any) => {
                                            if (error == 1) {
                                                console.log("RechargeByAdmin => Wallet Updated");
                                                
                                                rate.walletRechargeLog(req, res, {
                                                    idaccount: sdata.idaccount,
                                                    amount: CRate,
                                                    purpose: 'Wallet Updated from Recharged by Admin'
                                                }, 1, type, (err: any, data: any) => { 
                                                    console.log("RechargeByAdmin => walletRechargeLog Wallet recharge log response:", err, data);
                                                });

                                                let pType = "Direct";
                                                if (sdata.paymentType == 1) {
                                                    pType = "Portal Payment";
                                                } else if (sdata.paymentType == 2) {
                                                    pType = "Manual Credit";
                                                } else if (sdata.paymentType == 3) {
                                                    pType = "Manual Debit";
                                                } else if (sdata.paymentType == 4) {
                                                    pType = "Bank Payment";
                                                } else if (sdata.paymentType == 5) {
                                                    pType = "Credit Card Payment by Admin";
                                                }
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `amount`, `created`, `description`, `type`,`status`,`is_status`) VALUE('" + sdata.idaccount + "', '" + parseBody(sdata.email) + "', '" + CRate + "', '" + sdata.currentDateTime + "', '" + parseBody(sdata.description.trim()) + "', '" + pType + "','succeeded','1')";
                                                obj1.prepare();
                                                obj1.execute((__error: any, result: any) => {
                                                    if (__error == 1) {
                                                        let objv1 = new RawView(res);
                                                        let message;
                                                        if (sdata.paymentType == 3) {
                                                            message = "Balance Deducted Successfully!";
                                                        }
                                                        else {
                                                            message = "Balance Credit Successfully!";
                                                        }
                                                        objv1.prepare({ data: result, message: message, status: 201 });
                                                        objv1.execute();
                                                    } else {
                                                        let objv1 = new RawView(res);
                                                        objv1.prepare({ message: "Balance Added Error With Log!", status: 502, error: result });
                                                        objv1.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                rate.walletRechargeLog(req, res, {
                                                    idaccount: sdata.idaccount,
                                                    amount: CRate,
                                                    purpose: 'Wallet not updated from Recharged by Admin'
                                                }, 2, type, (err: any, data: any) => { 
                                                    console.log("RechargeByAdmin => walletRechargeLog Wallet recharge log response:", err, data);
                                                });

                                                let objv1 = new RawView(res);
                                                objv1.prepare({ message: "Amount not updated!", status: 505});
                                                objv1.execute();
                                            }
                                        });
                                    }
                                    else{
                                        let objv1 = new RawView(res);
                                        objv1.prepare({ message: "Amount has not been updated!", status: 504});
                                        objv1.execute();
                                    }
                                }
                                else {
                                    let objv1 = new RawView(res);
                                    objv1.prepare({ message: "Customer Detail Not Found!", error: customer, status: 502 });
                                    objv1.execute();
                                }
                            }
                            else {
                                let objv1 = new RawView(res);
                                objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv1.execute();
                            }
                        });
                    }
                    else {
                        let objv1 = new RawView(res);
                        objv1.prepare({
                            message: "Balance amount should be greater then 0!",
                            status: 502,
                            error: ""
                        });
                        objv1.execute();
                    }
                }
                else{
                    let objvs = new RawView(res);
                    objvs.prepare(dt);
                    objvs.execute();
                }      
            })         
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Auth Key!", status: 401 });
                objv.execute();
            }
        });
    }

    public getBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idwallet`,`balance`,`min_balance`,`topup_amount`,`webhook_url`,`credit_limit`,`status`,`isEmail`,`isWebhook` FROM `wallet` WHERE idaccount=" + sessdata.idaccount;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    public getcustBalance(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `balance` FROM `wallet` WHERE idaccount=" + sdata.idaccount;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    public addBalance(req: Request, res: Response, next: NextFunction) {
        let spdata = JSON.parse(req.body.data);
        let stipedata = spdata.pdata;
        let stripeToken = spdata.token;
        const stripe = stripepay(secret_key);
        let session = new SessionManagment(req, res, next);
        session.GetSession((__error: any, sessdata: any) => {
            if (__error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `trust_score` From `user` WHERE `idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        stripe.customers.create(
                            {
                                email: stripeToken.email,
                                source: stripeToken.id,
                                name: stipedata.first_name + " " + stipedata.last_name,
                                phone: stipedata.contact,
                                metadata: {
                                    name: stipedata.first_name + " " + stipedata.last_name,
                                    contact: stipedata.contact,
                                    city: stipedata.city,
                                    san: Math.floor(Math.floor(100000000) + Math.floor(sessdata.idaccount)),
                                    email: stipedata.email,
                                },
                                shipping: {
                                    name: stipedata.first_name + " " + stipedata.last_name,
                                    phone: stipedata.contact,
                                    address: {
                                        line1: stipedata.address1,
                                        city: stipedata.city,
                                        country: stipedata.country,
                                        state: stipedata.state,
                                        postal_code: stipedata.postal_code
                                    }
                                },
                                address: {
                                    line1: stipedata.address1,
                                    city: stipedata.city,
                                    country: stipedata.country,
                                    state: stipedata.state,
                                    postal_code: stipedata.postal_code
                                }
                            }, (err: any, customer: any) => {
                                if (err) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
                                    objv.execute();
                                }
                                else {
                                    stripe.charges.create({
                                        customer: customer.id,
                                        amount: stipedata.amount * 100,
                                        currency: 'USD',
                                        description: 'Live Mode',
                                        metadata: {
                                            email: stipedata.email,
                                            san: Math.floor(Math.floor(100000000) + Math.floor(sessdata.idaccount)),
                                            trust_score: result[0].trust_score
                                        },
                                        shipping: {
                                            name: stipedata.first_name + " " + stipedata.last_name,
                                            phone: stipedata.contact,
                                            address: {
                                                line1: stipedata.address1,
                                                city: stipedata.city,
                                                country: stipedata.country,
                                                state: stipedata.state,
                                                postal_code: stipedata.postal_code
                                            }
                                        }
                                    }, (err: any, charge: any) => {
                                        if (err) {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + parseBody(stipedata.email) + "','', '', '', '" + stipedata.amount + "', NOW(), 'failed','" + parseBody(err.raw.message) + "','Credit Card Payment','0')";
                                            obj.prepare();
                                            obj.execute((serror: any, result: any) => {
                                                console.log("Payment failed");
                                            });

                                            let st = new StripeApi();
                                            st.sendAddBalanceMail(req, res, 'Failed', stipedata.amount, sessdata, stipedata, (error, resp) => {
                                                console.log('Send Failed Email on Customer Email Id');
                                            });

                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Wrong Billing Information!", status: 404 });
                                            objv.execute();
                                        }
                                        else {
                                            let obj10 = new ModelRawQuery(req, res);
                                            obj10.qrysql = "SELECT `customer_id` FROM `wallet` WHERE idaccount='" + sessdata.idaccount + "'";
                                            obj10.prepare();
                                            obj10.execute((__werror: any, __wresult: any) => {
                                                if (__werror == 1) {
                                                    if (__wresult.length > 0) {
                                                        if (__wresult[0].customer_id) {
                                                            const amount = stipedata.amount;

                                                            let CAmount: any = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0
                                                            let payload = {
                                                                idaccount: sessdata.idaccount,
                                                                amount: CAmount,
                                                                purpose: 'recharged by customer',
                                                                type: '-'
                                                            };
                                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                console.log("addBalance => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                if (errorD == 1) {
                                                                    let obj2 = new ModelRawNonQuery(req, res);
                                                                    obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`,`charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + parseBody(stripeToken.email) + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + parseBody(charge.description) + "', 'Credit Card Payment','1')";
                                                                    obj2.prepare();
                                                                    obj2.execute((eerror: any, result: any) => {
                                                                        if (eerror == 1) {
                                                                            let key = stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4;
                                                                            let obj3 = new ModelRawQuery(req, res);
                                                                            obj3.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `key`= '" + key + "'";
                                                                            obj3.prepare();
                                                                            obj3.execute((____error: any, stripeCard: any) => {
                                                                                if (____error == 1) {
                                                                                    if (stripeCard.length > 0) {
                                                                                        let objv1 = new RawView(res);
                                                                                        objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                        objv1.execute();
                                                                                    }
                                                                                    else {
                                                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                                                        obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + parseBody(stripeToken.email) + "','" + parseBody(stripeToken.card.name) + "','" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "','" + customer.id + "', '" + stripeToken.id + "', '" + stripeToken.card.id + "','" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "','" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "','" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "','" + stripeToken.client_ip + "','" + stripeToken.created + "', 'false', '" + parseBody(stripeToken.card.address_line1) + "','" + parseBody(stripeToken.card.address_city) + "', '" + parseBody(stripeToken.card.country) + "','" + parseBody(customer.address.state) + "','" + stripeToken.card.address_zip + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + parseBody(customer.metadata.city) + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + parseBody(customer.shipping.address.country) + "','" + parseBody(customer.shipping.address.state) + "','" + parseBody(customer.shipping.address.postal_code) + "')";
                                                                                        obj4.prepare();
                                                                                        obj4.execute((wwerror: any, ___result: any) => {
                                                                                            if (wwerror == 1) {
                                                                                                let objv1 = new RawView(res);
                                                                                                objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                                objv1.execute();
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView(res);
                                                                                                objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                }
                                                                                else {
                                                                                    let objv1 = new RawView(res);
                                                                                    objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                                    objv1.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: errorD });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            const amount = stipedata.amount;

                                                            let CAmount: any = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0

                                                            let payload = {
                                                                idaccount: sessdata.idaccount,
                                                                amount: CAmount,
                                                                purpose: 'recharged by customer',
                                                                type: '-'
                                                            };
                                                            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                console.log("addBalance => walletDeduction Wallet deduction response:", errorD, dataD);
                                                            
                                                                if (errorD == 1) {
                                                                    let obj2 = new ModelRawNonQuery(req, res);
                                                                    obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + parseBody(stripeToken.email) + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + parseBody(charge.description) + "', 'Credit Card Payment','1')";
                                                                    obj2.prepare();
                                                                    obj2.execute((___error: any, result: any) => {
                                                                        if (___error == 1) {
                                                                            let obj3 = new ModelRawQuery(req, res);
                                                                            obj3.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `key` = '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "'";
                                                                            obj3.prepare();
                                                                            obj3.execute((eerror: any, stripeCard: any) => {
                                                                                if (eerror == 1) {
                                                                                    if (stripeCard.length > 0) {
                                                                                        let objv1 = new RawView(res);
                                                                                        objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                        objv1.execute();
                                                                                    }
                                                                                    else {
                                                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                                                        obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + parseBody(stripeToken.email) + "','" + parseBody(stripeToken.card.name) + "','" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "','" + customer.id + "', '" + stripeToken.id + "', '" + stripeToken.card.id + "','" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "','" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "','" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "','" + stripeToken.client_ip + "','" + stripeToken.created + "', 'true', '" + parseBody(stripeToken.card.address_line1) + "','" + parseBody(stripeToken.card.address_city) + "', '" + parseBody(stripeToken.card.country) + "','" + parseBody(customer.address.state) + "','" + parseBody(stripeToken.card.address_zip) + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + parseBody(customer.metadata.city) + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + parseBody(customer.shipping.address.country) + "','" + parseBody(customer.shipping.address.state) + "','" + parseBody(customer.shipping.address.postal_code) + "')";

                                                                                        obj4.prepare();
                                                                                        obj4.execute((__werror: any, ___result: any) => {
                                                                                            if (__werror == 1) {
                                                                                                let objv1 = new RawView(res);
                                                                                                objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                                objv1.execute();
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView(res);
                                                                                                objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                }
                                                                                else {
                                                                                    let objv1 = new RawView(res);
                                                                                    objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                                    objv1.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: errorD });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                    }
                                                    else {
                                                        const amount = stipedata.amount;

                                                        let CAmount: any = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `wallet` (`idaccount`, `balance`, `customer_id`) VALUES('" + sessdata.idaccount + "', '" + CAmount + "', '" + charge.customer + "')";
                                                        obj1.prepare();
                                                        obj1.execute((__error: any, __result: any) => {
                                                            if (__error == 1) {
                                                                rate.walletRechargeLog(req, res, {
                                                                    idaccount: sessdata.idaccount,
                                                                    amount: amount,
                                                                    purpose: 'Wallet amount added by customer successfully'
                                                                }, 1, '+', (err: any, data: any) => { 
                                                                    console.log("addBalance => walletRechargeLog Wallet recharge log response:", err, data);
                                                                });
                                                                let obj2 = new ModelRawNonQuery(req, res);
                                                                obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + parseBody(stripeToken.email) + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + parseBody(charge.description) + "', 'Credit Card Payment','1')";
                                                                obj2.prepare();
                                                                obj2.execute((eerror: any, result: any) => {
                                                                    if (eerror == 1) {
                                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                                        //obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";

                                                                        obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + parseBody(stripeToken.email) + "','" + parseBody(stripeToken.card.name) + "','" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "','" + customer.id + "', '" + stripeToken.id + "', '" + stripeToken.card.id + "','" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "','" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "','" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "','" + stripeToken.client_ip + "','" + stripeToken.created + "', 'true', '" + parseBody(stripeToken.card.address_line1) + "','" + parseBody(stripeToken.card.address_city) + "', '" + parseBody(stripeToken.card.country) + "','" + parseBody(customer.address.state) + "','" + parseBody(stripeToken.card.address_zip) + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + parseBody(customer.metadata.city) + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + parseBody(customer.shipping.address.country) + "','" + parseBody(customer.shipping.address.state) + "','" + parseBody(customer.shipping.address.postal_code) + "')";
                                                                        obj4.prepare();
                                                                        obj4.execute((wwerror: any, ___result: any) => {
                                                                            if (wwerror == 1) {
                                                                                let objv1 = new RawView(res);
                                                                                objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                objv1.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                rate.walletRechargeLog(req, res, {
                                                                    idaccount: sessdata.idaccount,
                                                                    amount: amount,
                                                                    purpose: 'Wallet amount not added by customer successfully'
                                                                }, 2, '+', (err: any, data: any) => { 
                                                                    console.log("addBalance => walletRechargeLog Wallet recharge log response:", err, data);
                                                                });
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Error With Updating Wallet!", status: 502 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 404 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    });

                                }
                            });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    /* updateBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let stipedata = spdata.pdata;
                let st = new StripeApi();
                st.balanceDeduct(req, res, sessdata, stipedata,spdata, (error, resp) => {
                    let objv = new RawView(res);
                    objv.prepare({ message: resp.message, status: resp.status });
                    objv.execute();
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    } */

    updateBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let spdata: any;
                try {
                    if (typeof req.body.data === "string" && req.body.data.trim() !== "") {
                        spdata = JSON.parse(req.body.data);
                    } else {
                        spdata = req.body.data;
                    }
                } catch (err) {
                    spdata = req.body.data;
                }
                let message: any = '';
                const isEmpty = (value: any): boolean => !value || value == 'undefined' || value == 'null' || undefined || value == null || value === '';
                const isTwoUppercaseLetters = (value: string): boolean => /^[A-Z]{2}$/.test(value);
                const isValidPhone = (value: string): boolean => /^[0-9]+$/.test(value);
                const isValidEmail = (value: string): boolean => /^(?!.*\.\.)(?!\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,10}(?<!\.)$/.test(value);
                const requiredfield= {"amount": "amount","customer_id": "customer id","first_name": "first name","last_name": "last name","contact": "contact","email": "email","address1": "address1","city": "city","state": "state",
                    "postal_code": "postal code","country": "country"};
                switch (true) {
                    case (isEmpty(spdata) || isEmpty(spdata?.pdata)):
                        message = "Missing request body!";
                        break;
                     case Object.keys(requiredfield).some(f => isEmpty(spdata.pdata[f])):
                        const missingFields = Object.entries(requiredfield).filter(([f]) => isEmpty(spdata.pdata[f])).map(([_, label]) => label);
                        message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                        break;
                    case !isTwoUppercaseLetters(spdata.pdata.country):
                        message = "Country is invalid! It must be exactly two uppercase letters.";
                        break;
                    case isPostalCode(spdata.pdata.postal_code):
                        message = "Postal code is invalid!";
                        break;
 
                    case !isValidPhone(spdata.pdata.contact):
                        message = "Contact is invalid!";
                        break;
                    case !isValidEmail(spdata.pdata.email):
                        message = "Email is invalid!";
                        break;
                        case (spdata.pdata.amount<=0):
                        message = "amount can not be nagetive or zero!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                    return;
                }
                if (spdata.pdata.type && spdata.pdata.type == 'subscharge' && spdata.pdata.type !== '' && spdata.pdata.type !== undefined) {
                    let stipedata = spdata.pdata;
                    let st = new StripeApi();
                    st.subscriptionBalanceDeduct(req, res, sessdata, stipedata, spdata, (error, resp) => {
                        if (error == 1) {
                            let subscriptionmap = new SubscriptionManagement();
                            subscriptionmap.subscriptionlog(req, res, spdata.lodinfo, sessdata.idaccount, sessdata.iduser, (err: any) => {
                            });
                            let objv = new RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        }
                    });
                } else {
                    let stipedata = spdata.pdata;
                    let st = new StripeApi();
                    st.balanceDeduct(req, res, sessdata, stipedata, spdata, (error, resp) => {
                        let objv = new RawView(res);
                        objv.prepare({ message: resp.message, status: resp.status });
                        objv.execute();
                    });
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }


    public balanceDeduct(req: Request, res: Response, sessdata: any, stipedata: any, sdata: any, callback: (err: any, data: any) => void) {
        const stripe = stripepay(secret_key);
        const finalAmount:any = parseFloat(stipedata.amount).toFixed(2); 
        const numberAmount: number = Number(finalAmount);
        let idaccount = sdata.sesidaccount ?? sessdata.idaccount
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `trust_score` From `user` WHERE `idaccount` = '" + idaccount + "'";
        obj.prepare();
        obj.execute((_error: any, result: any) => {
            if (_error == 1) {
                stripe.charges.create({
                    customer: stipedata.customer_id,
                    amount: numberAmount * 100,
                    currency: 'USD',
                    description: 'Live Mode',
                    metadata: {
                        email: stipedata.email,
                        san: Math.floor(100000000 + idaccount),
                        trust_score: result[0].trust_score
                    },
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }
                }, (err: any, charge: any) => {
                    const amount = charge != null ? charge.amount / 100 : stipedata.amount;
                    if (err) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + idaccount + "', '" + parseBody(stipedata.email) + "','', '', '', '" + amount + "', NOW(), 'failed','" + parseBody(err.raw.message) + "','Credit Card Payment','0')";
                        obj.prepare();
                        obj.execute((serror: any, result: any) => {
                            if (serror == 1) {
                                console.log("Successfully Insert Record");
                                callback(0, { message: "Payment Failed", status: 504 });

                            }
                            else {
                                console.log("Something Went Wrong with Email Failed");
                                callback(0, { message: "Something Went Wrong with payment failed", status: 505 });

                            }
                        });
                        let st = new StripeApi();
                        st.sendAddBalanceMail(req, res, 'Failed', amount, sessdata, sdata, (error, resp) => {
                            console.log('Send Failed Email on Customer Email Id');
                        });
                    }
                    else {
                        if (stipedata.generateInvoice !== true || stipedata.generateInvoice == undefined) {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + amount + " WHERE `idaccount` = '" + idaccount + "'";;
                            obj.prepare();
                            obj.execute((error: any, result: any) => {
                                console.log("Successfully Insert Record");
                                if (error == 1) {
                                    rate.walletRechargeLog(req, res, {
                                        idaccount: idaccount,
                                        amount: amount,
                                        purpose: 'Wallet amount successfully updated by customer'
                                    }, 1, '+', (err: any, data: any) => { 
                                        console.log("balanceDeduct => walletRechargeLog Wallet recharge log response:", err, data);
                                    });
                                }
                                else {
                                    let purpose = stipedata.generateInvoice == true ? "Amount not deducted by stripe at closing Invoice" : "Wallet amount successfully not updated by customer";
                                    rate.walletRechargeLog(req, res, {
                                        idaccount: idaccount,
                                        amount: amount,
                                        purpose: purpose
                                    }, 2, '+', (err: any, data: any) => { 
                                        console.log("balanceDeduct => walletRechargeLog Wallet recharge log failed response:", err, data);
                                    });
                                }
                            });
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`,`card_last4`) VALUE('" + idaccount + "', '" + parseBody(stipedata.email) + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + parseBody(charge.description) + "', 'Credit Card Payment','1','"+charge.payment_method_details.card.last4+"')";
                            obj1.prepare();
                            obj1.execute((serror: any, result: any) => {
                                if (serror == 1) {
                                    callback(1, { data: [], message: "Balance Updated Successfully!", status: 201 });
                                }
                                else {
                                    callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 502, err: serror });
                                }
                            });
                            let st = new StripeApi();
                            st.sendAddBalanceMail(req, res, 'Success', amount, sessdata, sdata, (error, resp) => {
                                console.log('Email send function called');
                            });

                        }
                        if (stipedata.generateInvoice == true) {
                            let stripePaymentAmt = stipedata.generateInvoice == true ? stipedata.amount : amount;
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`,`card_last4`) VALUE('" + idaccount + "', '" + parseBody(stipedata.email) + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + stripePaymentAmt + "', '" + charge.created + "', '" + charge.status + "','" + parseBody(charge.description) + "', 'Credit Card Payment','1','"+charge.payment_method_details.card.last4+"')";
                            obj1.prepare();
                            obj1.execute((serror: any, result: any) => {
                                if (serror == 1) {
                                    callback(1, { data: [], message: "Balance Updated Successfully!", status: 201 });
                                }
                                else {
                                    callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 502 });
                                }
                            });
                            let st = new StripeApi();
                            st.sendAddBalanceMail(req, res, 'Success', stripePaymentAmt, sessdata, sdata, (error, resp) => {
                                console.log('Email send function called');
                            });
                        }
                    }

                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Something Went Wrong", status: 401 });
                objv.execute();
            }
        });
    }

    public sendAddBalanceMail(req: Request, res: Response, msg: any, amount: any, sessdata: any, sdata: any, callback: (err: any, data: any) => void) {
        let tempType = msg == 'Success' ? 'livemode_payment' : 'recharge_failed'
        let objem = new ModelRawQuery(req, res);
        let idaccount = sdata.sesidaccount ?? sessdata.idaccount
        let iduser = sdata.sesiduser ?? sessdata.iduser
        objem.qrysql = "SELECT `subject`, `template`, `cc`, `bcc` FROM `email_template` WHERE `type` = '" + tempType + "'";
        objem.prepare();
        objem.execute((errorem: any, _resultem: any) => {
            if (errorem == 1 && _resultem.length > 0) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `firstname` , `lastname`, `email` FROM `user_profile` WHERE `iduser` = '" + iduser + "'";
                obj1.prepare();
                obj1.execute((errorup: any, _resultup: any) => {
                    if (errorup == 1) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount` = '" + idaccount + "'";
                        obj.prepare();
                        obj.execute((errorw: any, wallet: any) => {
                            if (errorw == 1) {
                                let emailTemplate = _resultem[0].template;
                                emailTemplate = emailTemplate.replace('{FIRST_NAME}', _resultup[0].firstname).replace('{LAST_NAME}', _resultup[0].lastname).replace('{BALANCE}', wallet[0].balance).replace('{TOPUP_AMOUNT}', amount);

                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`,`subject`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + iduser + "','" + idaccount + "','" + FromEmail + "','" + parseBody(_resultup[0].email) + "', '" + parseBody(_resultem[0].subject) + "','" + parseBody(emailTemplate) + "','Balance Added','19','" + _resultem[0].cc + "','" + _resultem[0].bcc + "')";
                                obj1.prepare();
                                obj1.execute((_err: any, __result: any) => {
                                    if (_err == 1) {
                                        console.log("Email Send Succesfully!");
                                    }
                                    else {
                                        console.log("Opps Email Not Sent!");
                                    }
                                });
                            }
                            else {
                                console.log('Wallet Balance Not Found at the Time Stripe Payment');
                            }
                        });
                    }
                    else {
                        console.log('Account Profile Not Found at the Time Stripe Payment');
                    }
                });
            }
            else {
                console.log('Live Payment Email Template Not Found at the Time Stripe Payment');
            }
        });
    }

    // updateBalance(req: Request, res: Response, next: NextFunction) {
    //     let spdata = JSON.parse(req.body.data);
    //     let stipedata = spdata.pdata;
    //     const stripe = stripepay(secret_key);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             stripe.charges.create({
    //                 customer: stipedata.customer_id,
    //                 amount: stipedata.amount * 100,
    //                 currency: 'USD',
    //                 description: 'Live Mode',
    //                 shipping: {
    //                     name: stipedata.first_name + " " + stipedata.last_name,
    //                     phone: stipedata.contact,
    //                     address: {
    //                         line1: stipedata.address1,
    //                         city: stipedata.city,
    //                         country: stipedata.country,
    //                         state: stipedata.state,
    //                         postal_code: stipedata.postal_code
    //                     }
    //                 }
    //             }, (err: any, charge: any) => {
    //                 if (err) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     const amount = charge.amount / 100;
    //                     let obj = new ModelRawNonQuery(req, res);
    //                     obj.nonqrysql = "UPDATE wallet SET `balance`= `balance`+ " + stipedata.amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
    //                     obj.prepare();
    //                     obj.execute((_error: any, wallet: any) => {
    //                         if (_error == 1) {

    //                             let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

    //                             iQry += "`idaccount`=" + sessdata.idaccount + ", "

    //                             iQry += "`amount`='+" + amount + "', "

    //                             iQry += "`purpose`='Wallet amount successfully updated by customer', "

    //                             iQry += "`status`=1;"

    //                             let objWL = new ModelRawNonQuery(req, res);
    //                             objWL.nonqrysql = iQry
    //                             objWL.prepare()
    //                             objWL.execute((error: any, result: any) => {
    //                                 console.log("Transaction response::", result)
    //                             })

    //                             let obj = new ModelRawNonQuery(req, res);
    //                             obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stipedata.email + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
    //                             obj.prepare();
    //                             obj.execute((serror: any, result: any) => {
    //                                 if (serror == 1) {
    //                                     let obj1 = new ModelRawQuery(req, res);
    //                                     obj1.qrysql = "SELECT `customer_id` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount;
    //                                     obj1.prepare();
    //                                     obj1.execute((____error: any, _result: any) => {
    //                                         if (____error == 1) {
    //                                             let objv1 = new RawView(res);
    //                                             objv1.prepare({ data: [], message: "Balance Updated Successfully!", status: 201 });
    //                                             objv1.execute();
    //                                         } else {
    //                                             let objv1 = new RawView(res);
    //                                             objv1.prepare({ message: "Balance Updated Error With Connection!", status: 502, error: _result });
    //                                             objv1.execute();
    //                                         }
    //                                     });
    //                                 }
    //                                 else {
    //                                     let objv = new RawView(res);
    //                                     objv.prepare({ message: "Balance Updated Error With Connection!", err: error, status: 502 });
    //                                     objv.execute();
    //                                 }
    //                             });
    //                         }
    //                         else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ message: "Error With Updating Balance!", err: error, status: 502 });
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

        updatePaymentSetting(req: Request, res: Response, next: NextFunction) {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                if (error == 1) {
                    let spdata = req.body.data;  
                    console.log(spdata);
                    let message = '';
                    const isEmpty = (value: any): boolean =>
                        value == undefined || value == null || value == '' || value == 'null' || value == 'undefined';
                    const isNumeric = (value: any): boolean => /^[0-9]+$/.test(String(value));
                    const requiredFields = {'idwallet' : 'idwallet', 'defaultamt': 'Balance DIPS'};
                    const numericFields = {'idwallet' : 'idwallet', 'defaultamt': 'Balance DIPS', 'topup_amount': 'Topup Amount', 'credit_limit':'Credit limit'};
                    switch (true) {
                        case (!spdata):
                            message = "Payment setting Data is required"
                            break;
                        case Object.keys(requiredFields).some(f => isEmpty(spdata.data[f])):
                            const missingFields = Object.entries(requiredFields).filter(([f]) => isEmpty(spdata.data[f])).map(([_, label]) => label);
                            message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                            break;
                        case Object.keys(numericFields).some(f => !isEmpty(spdata.data[f]) && !isNumeric(spdata.data[f])):
                            const invalidNumbers = Object.entries(numericFields).filter(([f]) => !isEmpty(spdata.data[f]) && !isNumeric(spdata.data[f])).map(([_, label]) => label);
                            message = invalidNumbers.join(', ') + ' ' + (invalidNumbers.length > 1 ? 'must be numeric!' : 'must be numeric!');
                            break;
                        case spdata.isAutoPayment == 'true' && isEmpty(spdata.data.topup_amount):
                            message = "topup amount is required because Auto Payment option is on!";
                            break; 
                        case spdata.isAutowebhook === 'true' && isEmpty(spdata.data.webhook_url):
                            message = "webhook url is required because Auto Webhook option is on!";
                            break;
                        case spdata.isAutowebhook === 'true' && !isEmpty(spdata.data.webhook_url) && !isValidUrl(spdata.data.webhook_url):
                            message = "webhook url is invalid!";
                            break;
                        case !['true', 'false'].includes(spdata.isAutoEmail) ||
                            !['true', 'false'].includes(spdata.isAutowebhook) ||
                            !['true', 'false'].includes(spdata.isAutoPayment):
                            const invalidFlags = ['isAutoEmail', 'isAutowebhook', 'isAutoPayment'].filter(f => !['true', 'false'].includes(spdata[f]));
                            message = invalidFlags.join(', ') + ' ' + (invalidFlags.length > 1 ? "must be 'true' or 'false'" : "must be 'true' or 'false'");
                            break;
                        default:
                            message = "";
                    }
                    if (message) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: message });
                        objv.execute();
                    } else {
                        let parsedTopup = parseFloat(spdata.data.topup_amount || '0') || 0;
                        const topupAmount = parsedTopup >= 50 ? parsedTopup.toFixed(3) : 50;
                        const minBalance = (parseFloat(spdata.data.defaultamt || '0') || 0).toFixed(3);
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'updatePaymentSetting',
                                logName: 'Wallet Update'
                            },
                            data: {
                                status: spdata.isAutoPayment,
                                isEmail: spdata.isAutoEmail,
                                isWebhook: spdata.isAutowebhook,
                                min_balance: minBalance,
                                topup_amount: topupAmount,
                                webhook_url: spdata.data.webhook_url
                            },
                            connWhere: {
                                idwallet: spdata.data.idwallet
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                let tmp: string = "{\"amount_Update\": \"" + topupAmount + "\"}";
                                let emType = JSON.parse(tmp);
                                let spdataa: any = Object.assign(spdata, emType);
                                let st = new StripeApi();
                                spdata.isAutoPayment = spdata.isAutoPayment == 'true' ? 1 : 0;
                                st.insertAutoPaymentLog(req, res, next, spdataa);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Setting Changed Successfully!", result: did_log1, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                }
                else {
                    let objv = new Res404(res);
                    objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                    objv.execute();
                }
            });
        }
     
    getTopupuser(req: Request, res: Response, spdata: any, callback: (err: any, result: any) => void) {
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `idaccount`,`topup_amount` FROM `wallet` WHERE  `idwallet` = '" + spdata.idwallet + "'";
        obj1.prepare()
        obj1.execute((error: any, result: any) => {
            if (error == 1) {
                callback(1, result)
            } else {
                callback(0, error)
            }

        })
    }

    insertAutoPaymentLog(req: Request, res: Response, next: NextFunction, spdata: any) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let obj3 = new ModelRawNonQuery(req, res);
                const topupAmount = (parseFloat(spdata.amount_Update || '0') || 0).toFixed(3);
                obj3.nonqrysql = "INSERT INTO auto_payment_log (status, topup_balance, user_type, iduser, idaccount) VALUES ('" + setToZero(spdata.isAutoPayment) + "', '" + topupAmount + "', '" + sessdata.type + "', '" + sessdata.iduser + "', '" + sessdata.idaccount + "')";
                obj3.prepare();
                obj3.execute((logError: any, logRes: any) => {
                    if (logError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Log Created Successfully!", status: 201 });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went wrong while inserting log!", status: 502 });
                    }
                });
            } else {
                let objv = new Res404(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    paymentHistory(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                console.log(sdata);
                let condition: any = "";
                let ext_field: any
                if(sessdata.type == 1){
                    ext_field = "acc.san,"
                }  
                let obj2 = new ModelRawQuery(req, res);
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                    if (sdata.selectedUser || (sdata.toDate && sdata.fromDate) || sdata.payment_Status || (sdata.from_amount && sdata.to_amount) || sdata.cardnumber) {
                        if (sdata.fromDate && sdata.toDate && !(sdata.selectedUser && sdata.from_amount && sdata.to_amount && sdata.payment_Status)) {
                            condition += 's.`timestamp` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                        }
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            condition += ' AND s.`idaccount`="' + sessdata.idaccount + '"';
                        }
                        if (sdata.selectedUser && !(sdata.toDate && sdata.fromDate && sdata.payment_Status && sdata.from_amount && sdata.to_amount)) {
                            condition += ' AND s.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        if (sdata.selectedUser && sdata.fromDate && sdata.toDate && sdata.payment_Status && sdata.from_amount && sdata.to_amount) {
                            condition += 's.timestamp BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND s.`idaccount`="' + sdata.selectedUser + '" AND s.`status`="' + sdata.payment_Status + '" AND s.`amount` BETWEEN ' + sdata.from_amount + ' AND ' + sdata.to_amount + '';
                        }
                        if (sdata.payment_Status && !(sdata.selectedUser && sdata.toDate && sdata.fromDate && sdata.from_amount && sdata.to_amount)) {
                            condition += ' AND s.`status`="' + sdata.payment_Status + '"';
                        }
                        if (sdata.from_amount && sdata.to_amount && !(sdata.selectedUser && sdata.payment_Status && sdata.fromDate && sdata.toDate)) {
                            condition += ' AND s.`amount` BETWEEN ' + sdata.from_amount + ' AND ' + sdata.to_amount + '';
                        }
                        if ((sdata.toDate && sdata.fromDate && sdata.from_amount && sdata.to_amount && sdata.payment_Status) && !sdata.selectedUser) {
                            condition += ' AND s.timestamp BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND s.`status`="' + sdata.payment_Status + '" AND s.`amount` BETWEEN ' + sdata.from_amount + ' AND ' + sdata.to_amount + '';
                        }
                        if (sdata.cardnumber && !(sdata.fromDate && sdata.toDate)) {
                            condition += ' AND s.`card_last4`="' + sdata.cardnumber + '"';
                        }
                        if (sdata.fromDate && sdata.toDate && sdata.cardnumber) {
                            condition += ' AND s.`card_last4`="' + sdata.cardnumber + '" AND s.`timestamp` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" ';
                        }
                        obj2.qrysql = "SELECT " + ext_field + " CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type`, s.`card_last4`, DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`,s.idstripe, `charge_id`, `balance_transaction`,  s.`status` FROM `stripe_payment` s  LEFT JOIN user_profile b ON s.idaccount = b.account_id  left JOIN `account` acc ON acc.idaccount=b.account_id WHERE " + condition + " GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                    else {
                        obj2.qrysql = "SELECT " + ext_field + " CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , s.`card_last4`, DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  LEFT JOIN `account`acc ON acc.idaccount=b.account_id GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                }
                else {
                    obj2.qrysql = "SELECT " + ext_field + " CONCAT(MAX(b.firstname),' ', MAX(b.lastname)) AS `customer_name`, s.email, `amount`, s.`type`, s.`card_last4`, DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id LEFT JOIN `account`acc ON acc.idaccount=b.account_id WHERE s.idaccount='" + sessdata.idaccount + "' GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                }
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Payment History Fetched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    stripeCards(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let condition: any = '';
                let extrafield: any = '';
                if (sessdata.type == 1)
                    extrafield = `,idaccount`;
                    
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232)
                    condition += "WHERE idaccount='" + sessdata.idaccount + "' AND `isdeleted`='0'";

                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `idstripecard`,`default`,`name`,`email`,`con_fullname`,`client_ip`,`customer_id`,`created_at`,`authorize_date`,`deleted_at`,`card_brand`,`last4`,`isdeleted`,`exp_month`,`exp_year`,`card_pdf` " + extrafield + " FROM `stripe_card`  " + condition + "";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    onBoardstripecards(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `idstripecard`, `name`, `email`, `last4`,`customer_id`,`con_fullname`, `exp_month`, `exp_year`, `client_ip`, `default`, DATE_FORMAT(`created_at`, '%m-%d-%Y') AS `created_at` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "' ORDER BY `idstripecard` DESC";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Not Found!", data: result, status: 400 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCardForAddBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'AND `default`='true'";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result == null || result.length < 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    stripeCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            const stripe = stripepay(secret_key);
                            stripe.paymentMethods.list({
                                customer: result[0].customer_id,
                                type: 'card',
                            }, (_err: any, success: any) => {
                                if (!_err) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Card Details Fetched Succesfully!", data: success, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    createCustomerCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let token: any = req.body.token;
                let message: any = '';
                const isEmpty = (value: any): boolean =>
                    value === undefined || value === null || value === '' || value === 'undefined' || value === 'null';
                const isValidPhone = (value: string): boolean =>
                    /^[0-9]+$/.test(value);
                const isValidEmail = (value: string): boolean =>
                    /^(?!.*\.\.)(?!\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,10}(?<!\.)$/.test(value);
                switch (true) {
                    case (!token || isEmpty(token)):
                        message = "token is required!";
                        break;
                    case (isEmpty(token.id) ||
                        isEmpty(token.card.address_city) ||
                        isEmpty(token.card.address_country) ||
                        isEmpty(token.card.address_line1) ||
                        isEmpty(token.card.address_zip) ||
                        isEmpty(token.card.brand) ||
                        isEmpty(token.card.country) ||
                        isEmpty(token.card.last4) ||
                        isEmpty(token.email) || isEmpty(token.card.name)):
                        message = "All id, address city, address country, address line1, address zip, brand, country, last4, email and name fields are required!";
 
                        break;
                    case (!isEmpty(token.card.last4) && !isValidPhone(token.card.last4)):
                        message = "Contact is invalid!";
                        break;
                    case (!isEmpty(token.email) && !isValidEmail(token.email)):
                        message = "Email is invalid!";
                        break;
                    case (!isEmpty(token.card.exp_month) && !isValidPhone(token.card.exp_month)):
                        message = "card exp month is invalid!";
                        break;
                    case (!isEmpty(token.card.exp_year) && !isValidPhone(token.card.exp_year)):
                        message = "card exp year is invalid!";
                        break;

                   default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else{
                    const stripe = stripepay(secret_key);
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT last4 as card FROM stripe_card WHERE idaccount = '" + sessdata.idaccount + "' AND isdeleted = 0";
                    obj1.prepare();
                    obj1.execute((error: any, result: any) => {
                        if (error == 1) {
                            const cardcount = result
                            if (cardcount.length < 5) {
                                let obj2 = new ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT u.iduser, u.idaccount, up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser='" + sessdata.iduser + "'";
                                obj2.prepare();
                                obj2.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        console.log(result);
                                        let obj10 = new ModelRawQuery(req, res);
                                        obj10.qrysql = "SELECT `customer_id` FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                                        obj10.prepare();
                                        obj10.execute((_werror: any, __result: any) => {
                                            if (_werror == 1) {
                                                let obj3 = new ModelRawQuery(req, res);
                                                // obj3.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `key` = '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                                /* obj3.qrysql = "SELECT `last4` FROM `stripe_card` WHERE idaccount = '" + sessdata.idaccount + "' AND isdeleted = 0";
                                                obj3.prepare();
                                                obj3.execute((____error: any, stripeCard: any) => {
                                                    if (____error == 1) {
                                                        //if (stripeCard.length > 0) {
                                                        const cardExists = stripeCard.some((card: any) => card.last4 === token.card.last4);
                                                        if (cardExists) {
                                                            let objv1 = new RawView(res);
                                                            objv1.prepare({ data: result, message: "This Card Already Exist!", status: 401 });
                                                            objv1.execute();
                                                        }
                                                        else { */
                                                stripe.customers.create({
                                                    email: token.email,
                                                    name: token.card.name,
                                                    source: token.id,
                                                    address: {
                                                        line1: token.card.address_line1,
                                                        city: token.card.address_city,
                                                        country: token.card.country,
                                                        state: token.card.address_state,
                                                        postal_code: token.card.address_zip
                                                    },
                                                    metadata: {
                                                        name: token.card.name,
                                                        contact: result[0].phone,
                                                        city: token.card.address_city,
                                                        email: result[0].email,
                                                        san: Math.floor(Math.floor(100000000) + Math.floor(result[0].idaccount))
                                                    },
                                                    // metadata: {
                                                    //     name: result[0].firstname + " " + result[0].lastname,
                                                    //     contact: result[0].phone,
                                                    //     city: result[0].city
                                                    // },
                                                    shipping: {
                                                        name: token.card.name,
                                                        phone: result[0].contact,
                                                        address: {
                                                            line1: token.card.address_line1,
                                                            city: token.card.address_city,
                                                            country: token.card.country,
                                                            state: token.card.address_state,
                                                            postal_code: token.card.address_zip
                                                        }
                                                    },
                                                    // shipping: {
                                                    //     name: result[0].firstname + " " + result[0].lastname,
                                                    //     phone: result[0].contact,
                                                    //     address: {
                                                    //         line1: result[0].address1,
                                                    //         city: result[0].city,
                                                    //         country: result[0].country,
                                                    //         state: result[0].state,
                                                    //         postal_code: result[0].postal_code
                                                    //     }
                                                    // },
                                                }, (err: any, customer: any) => {
                                                    if (!err) {
                                                        if (__result.length > 0) {
                                                            var defaultCard: any;
                                                            if (__result[0].customer_id) {
                                                                defaultCard = 'false';
                                                                let obj1 = new ModelRawNonQuery(req, res);
                                                                //obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";

                                                                obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + parseBody(token.email) + "','" + parseBody(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + parseBody(token.card.address_line1) + "','" + parseBody(token.card.address_city) + "', '" + parseBody(token.card.country) + "','" + parseBody(customer.address.state) + "','" + parseBody(token.card.address_zip) + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + parseBody(customer.metadata.city) + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + parseBody(customer.shipping.address.country) + "','" + parseBody(customer.shipping.address.state) + "','" + parseBody(customer.shipping.address.postal_code) + "')";
                                                                obj1.prepare();
                                                                obj1.execute((wwerror: any, ___result: any) => {
                                                                    if (wwerror == 1) {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                defaultCard = 'true';
                                                                // let obj = new ModelRawNonQuery(req, res);
                                                                // obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                                // obj.prepare();
                                                                // obj.execute((werror: any, _result: any) => {
                                                                //     if (werror == 1) {
                                                                let logPayload = {
                                                                    funDetail: {
                                                                        tableName: 'wallet',
                                                                        functionName: 'createCustomerCard',
                                                                        logName: 'Wallet Update'
                                                                    },
                                                                    data: {
                                                                        customer_id: customer.id
                                                                    },
                                                                    connWhere: {
                                                                        idaccount: sessdata.idaccount
                                                                    }
                                                                };
                                                                rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                                    if (log_error1 == 1) {
                                                                        let obj1 = new ModelRawNonQuery(req, res);

                                                                        obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + parseBody(token.email) + "','" + parseBody(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + parseBody(token.card.address_line1) + "','" + parseBody(token.card.address_city) + "', '" + token.card.country + "','" + parseBody(customer.address.state) + "','" + token.card.address_zip + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + customer.metadata.city + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + customer.shipping.address.country + "','" + customer.shipping.address.state + "','" + parseBody(customer.shipping.address.postal_code) + "')";
                                                                        obj1.prepare();
                                                                        obj1.execute((wwerror: any, ___result: any) => {
                                                                            if (wwerror == 1) {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            let objv1 = new RawView(res);
                                                            objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                            objv1.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                                        objv.execute();
                                                    }
                                                });
                                                /* }
                                            }
                                            else {
                                                let objv1 = new RawView(res);
                                                objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                                objv1.execute();
                                            }
                                        }); */
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                                objv.execute();
                                            }
                                        });

                                        //});
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Please Update Billing Address!", status: 401 });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "You Can Add Only 5 Cards!", status: 401 });
                                objv.execute();
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 401 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    onBoardcreateCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let token: any = req.body.token;
                let message: any = '';
                const isEmpty = (value: any): boolean =>
                    value === undefined || value === null || value === '' || value === 'undefined' || value === 'null';
                const isValidPhone = (value: string): boolean =>
                    /^[0-9]+$/.test(value);
                const isValidEmail = (value: string): boolean =>
                    /^(?!.*\.\.)(?!\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,10}(?<!\.)$/.test(value);
                switch (true) {
                    case (!token || isEmpty(token)):
                        message = "token is required!";
                        break;
                    case (
                        isEmpty(token.id) ||
                        isEmpty(token.card.address_city) ||
                        isEmpty(token.card.address_country) ||
                        isEmpty(token.card.address_line1) ||
                        isEmpty(token.card.address_zip) ||
                        isEmpty(token.card.brand) ||
                        isEmpty(token.card.country) ||
                        isEmpty(token.card.last4) ||
                        isEmpty(token.email) || isEmpty(token.card.name)
                    ):
                        message = "All id, address city, address country,  address line1, address zip, brand, country, last4, email and name fields are required!";
                        break;
                    case (!isEmpty(token.card.last4) && !isValidPhone(token.card.last4)):
                        message = "Contact is invalid!";
                        break;
                    case (!isEmpty(token.email) && !isValidEmail(token.email)):
                        message = "Email is invalid!";
                        break;
                    case (!isEmpty(token.card.exp_month) && !isValidPhone(token.card.exp_month)):
                        message = "Card Exp month is invalid!";
                        break;
                    case (!isEmpty(token.card.exp_year) && !isValidPhone(token.card.exp_year)):
                        message = "Card Exp year is invalid!";
                        break;

                   default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else{
                    const stripe = stripepay(secret_key);
                    let ext_field: any
                    if(sessdata.type == 1){
                        ext_field = "u.iduser, u.idaccount,"
                    }
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT "+ext_field+" up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country,ba.contact FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser=" + sessdata.iduser + " AND u.is_deleted=0";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            let obj10 = new ModelRawQuery(req, res);
                            obj10.qrysql = "SELECT `customer_id` FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                            obj10.prepare();
                            obj10.execute((_werror: any, __result: any) => {
                                if (_werror == 1) {
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = "SELECT `name`,`last4` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "' AND isdeleted ='0'";
                                    obj2.prepare();
                                    obj2.execute((stripeErr: any, stripeCards: any) => {
                                        if (stripeErr == 1) {
                                            if (stripeCards.length >= 5) {
                                                let objv1 = new RawView(res);
                                                objv1.prepare({ message: "Card Limit Exceeded!", status: 502 });
                                                objv1.execute();
                                            }
                                            else {
                                                /* let obj3 = new ModelRawQuery(req, res);
                                                obj3.qrysql = "SELECT `name`,`last4`,`exp_month`,`exp_year`,`client_ip`,`created_at` FROM `stripe_card` WHERE `card_brand` = '" + token.card.brand + "' AND `last4`='" + token.card.last4 + "' AND `idaccount`='" + sessdata.idaccount + "' AND `isdeleted` = '0'";
                                                obj3.prepare();
                                                obj3.execute((____error: any, stripeCard: any) => {
                                                    if (____error == 1) {
                                                        if (stripeCard.length > 0) {
                                                            let objv1 = new RawView(res);
                                                            objv1.prepare({ data: result, usedData: stripeCard, message: "This Card Already Exist!", status: 401 });
                                                            objv1.execute();
                                                        }
                                                        else { */
                                                stripe.customers.create({
                                                    email: token.email,
                                                    name: token.card.name,
                                                    source: token.id,
                                                    address: {
                                                        line1: token.card.address_line1,
                                                        city: token.card.address_city,
                                                        country: token.card.country,
                                                        state: token.card.address_state,
                                                        postal_code: token.card.address_zip
                                                    },
                                                    metadata: {
                                                        name: token.card.name,
                                                        contact: result[0].phone,
                                                        city: token.card.address_city,
                                                        email: result[0].email,
                                                        san: Math.floor(Math.floor(100000000) + Math.floor(result[0].idaccount))
                                                    },
                                                    // metadata: {
                                                    //     name: result[0].firstname + " " + result[0].lastname,
                                                    //     contact: result[0].phone,
                                                    //     city: result[0].city
                                                    // },
                                                    shipping: {
                                                        name: token.card.name,
                                                        phone: result[0].contact,
                                                        address: {
                                                            line1: token.card.address_line1,
                                                            city: token.card.address_city,
                                                            country: token.card.country,
                                                            state: token.card.address_state,
                                                            postal_code: token.card.address_zip
                                                        }
                                                    },
                                                    // shipping: {
                                                    //     name: result[0].firstname + " " + result[0].lastname,
                                                    //     phone: result[0].contact,
                                                    //     address: {
                                                    //         line1: result[0].address1,
                                                    //         city: result[0].city,
                                                    //         country: result[0].country,
                                                    //         state: result[0].state,
                                                    //         postal_code: result[0].postal_code
                                                    //     }
                                                    // },
                                                }, (err: any, customer: any) => {
                                                    if (!err) {
                                                        if (__result.length > 0) {
                                                            var defaultCard: any
                                                            if (__result[0].customer_id) {
                                                                defaultCard = 'false';
                                                                let obj1 = new ModelRawNonQuery(req, res);
                                                                //obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`,`authorize_date`) VALUES ('" + sessdata.idaccount + "','" + parseBody(token.email) + "','" + parseBody(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + parseBody(token.card.address_line1) + "','" + parseBody(token.card.address_city) + "', '" + parseBody(token.card.country) + "','" + parseBody(customer.address.state) + "','" + parseBody(token.card.address_zip) + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + parseBody(customer.metadata.city) + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + parseBody(customer.shipping.address.country) + "','" + parseBody(customer.shipping.address.state) + "','" + parseBody(customer.shipping.address.postal_code) + "',NOW())";
                                                                obj1.prepare();
                                                                obj1.execute((wwerror: any, ___result: any) => {
                                                                    if (wwerror == 1) {
                                                                        let obj2 = new ModelRawQuery(req, res);
                                                                        obj2.qrysql = "SELECT sc.`idstripecard`,sc.`customer_id`,sc.`name`,sc.`email`,sc.`exp_month`,sc.`exp_year`,sc.`key`,sc.`last4` ,sc.`client_ip`,DATE_FORMAT(sc.`created_at`, '%Y-%m-%d') AS created_at,DATE_FORMAT(sc.`authorize_date`, '%Y-%m-%d') AS authorize_date, sc.`con_fullname` FROM `stripe_card` AS sc JOIN `user` ON user.`idaccount`= sc.`idaccount` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                        // obj2.qrysql = "SELECT `idstripecard`,`name`,`email`,`exp_month`,`exp_year`,`key`,`last4` FROM `stripe_card` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                        obj2.prepare();
                                                                        obj2.execute((_error: any, scRes: any) => {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result, data1: scRes });
                                                                            objv.execute();
                                                                        })
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                defaultCard = 'true';
                                                                // let obj = new ModelRawNonQuery(req, res);
                                                                // obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                                // obj.prepare();
                                                                // obj.execute((werror: any, _result: any) => {
                                                                //     if (werror == 1) {
                                                                let logPayload = {
                                                                    funDetail: {
                                                                        tableName: 'wallet',
                                                                        functionName: 'onBoardcreateCard',
                                                                        logName: 'Wallet Update'
                                                                    },
                                                                    data: {
                                                                        customer_id: customer.id
                                                                    },
                                                                    connWhere: {
                                                                        idaccount: sessdata.idaccount
                                                                    }
                                                                };
                                                                rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                                    if (log_error1 == 1) {
                                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                                        //obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                        obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`,`authorize_date`) VALUES ('" + sessdata.idaccount + "','" + parseBody(token.email) + "','" + parseBody(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + parseBody(token.card.address_line1) + "','" + parseBody(token.card.address_city) + "', '" + parseBody(token.card.country) + "','" + parseBody(customer.address.state) + "','" + parseBody(token.card.address_zip) + "','" + parseBody(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + parseBody(customer.metadata.city) + "','" + parseBody(customer.metadata.email) + "','" + customer.metadata.san + "','" + parseBody(customer.shipping.name) + "','" + customer.shipping.phone + "','" + parseBody(customer.shipping.address.line1) + "','" + parseBody(customer.shipping.address.city) + "','" + parseBody(customer.shipping.address.country) + "','" + parseBody(customer.shipping.address.state) + "','" + parseBody(customer.shipping.address.postal_code) + "',NOW())";
                                                                        obj1.prepare();
                                                                        obj1.execute((wwwerror: any, ___result: any) => {
                                                                            if (wwwerror == 1) {
                                                                                let obj2 = new ModelRawQuery(req, res);
                                                                                obj2.qrysql = "SELECT sc.`idstripecard`,sc.`customer_id`,sc.`name`,sc.`email`,sc.`exp_month`,sc.`exp_year`,sc.`key`,sc.`last4` ,sc.`client_ip`,DATE_FORMAT(sc.`created_at`, '%Y-%m-%d') AS created_at,DATE_FORMAT(sc.`authorize_date`, '%Y-%m-%d') AS authorize_date, sc.`con_fullname` FROM `stripe_card` AS sc JOIN `user` ON user.`idaccount`= sc.`idaccount` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                                // obj2.qrysql = "SELECT `idstripecard`,`name`,`email`,`exp_month`,`exp_year`,`key`,`last4` FROM `stripe_card` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                                obj2.prepare();
                                                                                obj2.execute((_error: any, scRes: any) => {
                                                                                    let objv = new RawView(res);
                                                                                    objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result, data1: scRes });
                                                                                    objv.execute();
                                                                                })
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                                objv.execute();
                                                                            }

                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            let objv1 = new RawView(res);
                                                            objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                            objv1.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                                        objv.execute();
                                                    }
                                                });
                                                /* }
                                            }
                                            else {
                                                let objv1 = new RawView(res);
                                                objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                                objv1.execute();
                                            }
                                        }); */
                                            }
                                        }
                                        else {
                                            let objv1 = new RawView(res);
                                            objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                            objv1.execute();
                                        }
                                    });

                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "User not Authorized or Please Update Billing Address!", status: 401 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    setDfaultCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                rate.checkcustomerIDValid(req.body.customer_id, '501', (err2, msg2) => {
                    if (err2 == 1) {
                        let objv = new RawView(res);
                        objv.prepare(msg2);
                        objv.execute();
                    }
                    else {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `customer_id`='" + req.body.customer_id + "' AND `idaccount` = '" + sessdata.idaccount + "' AND `card_pdf` IS NOT NULL AND `card_pdf` LIKE '%card_pdf%'";
                        obj.prepare();
                        obj.execute((errCrd: any, resultCrd: any) => {
                            if (errCrd == 1 && resultCrd.length > 0) {
                                // let obj = new ModelRawNonQuery(req, res);
                                // obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + req.body.customer_id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                // obj.prepare();
                                // obj.execute((_err: any, result: any) => {
                                //     if (_err == 1) {
                                let logPayload = {
                                    funDetail: {
                                        tableName: 'wallet',
                                        functionName: 'setDfaultCard',
                                        logName: 'Wallet Update'
                                    },
                                    data: {
                                        customer_id: req.body.customer_id
                                    },
                                    connWhere: {
                                        idaccount: sessdata.idaccount
                                    }
                                };
                                rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                    if (log_error1 == 1) {
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `stripe_card` SET `default`= 'false' WHERE idaccount='" + sessdata.idaccount + "'";
                                        obj1.prepare();
                                        obj1.execute((___err: any, wallet: any) => {
                                            if (___err == 1) {
                                                let obj2 = new ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "UPDATE `stripe_card` SET `default`= 'true' WHERE customer_id='" + req.body.customer_id + "'";
                                                obj2.prepare();
                                                obj2.execute((__err: any, card: any) => {
                                                    if (__err == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Default Card Changed Successfully!", status: 201, data: card });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: card });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: wallet });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: did_log1 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 503, message: "You have to authorized card before make it default card!" });
                                objv.execute();
                            }
                        });                        

                    }
                })


            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }


    deleteCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                rate.checksessionvalid2_201(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        rate.checkcustomerIDValid(req.query.customer_id, '501', (err2, msg2) => {
                            if (err2 == 1) {
                                let objv = new RawView(res);
                                objv.prepare(msg2);
                                objv.execute();
                            }
                            else {
                                let obj11 = new ModelRawQuery(req, res);
                                obj11.qrysql = "SELECT `default`,isdeleted FROM `stripe_card` WHERE `customer_id`='" + req.query.customer_id + "'";
                                obj11.prepare();
                                obj11.execute((error: any, resultcard: any) => {
                                    if (error == 1) {
                                        if (resultcard[0].isdeleted == '0') {
                                            if (resultcard && String(resultcard[0].default).toLowerCase() === 'false') {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE stripe_card SET isdeleted = 1, deleted_at = NOW() WHERE `customer_id`='" + req.query.customer_id + "' AND `default`='false'";
                                                obj.prepare();
                                                obj.execute((err: any, result: any) => {
                                                    console.log("result::", result);
                                                    if (err == 1) {
                                                        if (result.affectedRows > 0) {
                                                            // let obj1 = new ModelRawNonQuery(req, res);
                                                            // obj1.nonqrysql = "UPDATE `wallet` SET `customer_id`=NULL WHERE `customer_id`='" + req.query.customer_id + "'";
                                                            // obj1.prepare();
                                                            // obj1.execute((_err: any, rescard: any) => {
                                                            //     console.log("Card Deleted Successfully!");
                                                            // });
                                                            let logPayload = {
                                                                funDetail: {
                                                                    tableName: 'wallet',
                                                                    functionName: 'deleteCard',
                                                                    logName: 'Wallet Update'
                                                                },
                                                                data: {
                                                                    customer_id: 'NULL'
                                                                },
                                                                connWhere: {
                                                                    customer_id: req.query.customer_id
                                                                }
                                                            };
                                                            rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                                console.log("Card Deleted Successfully!");
                                                            })
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                                                            objv.execute();
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Default Card cannot be deleted!", status: 501, error: result });
                                                            objv.execute();
                                                        }
                                                    } else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                                        objv.execute();
                                                    }
                                                });
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Default Card can not be delete!", status: 400 });
                                                objv.execute();
                                            }

                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Card Already Deleted", status: 500 });
                                            objv.execute();

                                        }


                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something went wrong while fetching default card!", status: 500 });
                                        objv.execute();
                                    }
                                });

                            }
                        })
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                })
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    deleteOnBoardCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `stripe_card` WHERE `customer_id`='" + req.query.customer_id + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err == 1) {
                        // let obj1 = new ModelRawNonQuery(req, res);
                        // obj1.nonqrysql = "UPDATE `wallet` SET `customer_id`=NULL WHERE `customer_id`='" + req.query.customer_id + "'";
                        // obj1.prepare();
                        // obj1.execute((_err: any, rescard: any) => {
                        //     console.log("Card Deleted Successfully!");
                        // });
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'deleteOnBoardCard',
                                logName: 'Wallet Update'
                            },
                            data: {
                                customer_id: 'NULL'
                            },
                            connWhere: {
                                customer_id: req.query.customer_id
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            console.log("Card Deleted Successfully!");
                        })
                        let objv = new RawView(res);
                        objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    public saveCardForm(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any;
                try {
                    if (typeof req.body.data == "string" && req.body.data.trim() !== "") {
                        sdata = JSON.parse(req.body.data);
                    } else {
                        sdata = req.body.data;
                    }
                } catch (err) {
                    sdata = req.body.data;
                }
                let message: any = '';
                switch (true) {
                    case (!sdata || isEmpty(sdata)):
                        message = "Missing request body!";
                        break;
                    case (!sdata.formData || isEmpty(sdata.formData)):
                        message = "formData is missing in request body!";
                        break;
                    case (!sdata.idstripecard || isEmpty(sdata.idstripecard)):
                        message = "idstripecard is required!";
                        break;
                    case !isValidPhone(sdata.idstripecard):
                        message = "idstripe card is invalid!";
                        break;
                    case (!sdata.formData.con_fullname || isEmpty(sdata.formData.con_fullname)):
                        message = "full name is required!";
                        break;
                    case !isAlpha(sdata.formData.con_fullname):
                        message = "full name is invalid!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                } else {
                    let formData = sdata.formData;
                    let idcard = sdata.idstripecard;
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `user` SET `isCard`='true' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((_error, upRes) => {
                        if (_error == 1) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "UPDATE `stripe_card` SET `con_fullname`='" + parseBody(formData.con_fullname) + "',`authorize_date` = NOW() WHERE `idaccount`='" + sessdata.idaccount + "' AND `idstripecard`='" + idcard + "'"
                            obj0.prepare();
                            obj0.execute((__error, upcardRes) => {
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `session` SET `isCard`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj5.prepare();
                                obj5.execute((_err: any, user: any) => {
                                    if (_err == 1) {
                                        console.log("Session Updated Successfully!");
                                    }
                                    else {
                                        console.log("Session Not Updated!");
                                    }
                                    let obj6 = new ModelRawQuery(req, res);
                                    obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`kyc_verify_status` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                    obj6.prepare();
                                    obj6.execute((_sessError: any, sessData: any) => {
                                        let obj7 = new ModelRawQuery(req, res);
                                        obj7.qrysql = "SELECT `con_fullname` FROM `stripe_card` WHERE `idstripecard`='" + idcard + "'";
                                        obj7.prepare();
                                        obj7.execute((_error: any, scRes: any) => {
                                            if (_sessError == 1) {
                                                let objup7 = new ModelRawQuery(req, res);
                                                objup7.qrysql = "SELECT country FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                objup7.prepare();
                                                objup7.execute((__errorEE: any, result7: any) => {
                                                    let country = result7.length > 0 && result7[0].country ? result7[0].country.trim() : '';
                                                    let tmpcountry: string = "{\"country\": \"" + country + "\"}";
                                                    let ct = JSON.parse(tmpcountry);
                                                    let data1: any = Object.assign(sessData[0], ct);
                                                    let objv = new RawView(res);
                                                    objv.prepare({ session: [data1], data: [data1], result: scRes, iduser: sessdata.iduser, message: "Card Saved Successfully!", status: 201 });
                                                    objv.execute();
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                                                objv.execute();
                                            }
                                        })

                                    });
                                });

                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 501 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }

        });
    }

    public saveCardPdf(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any;
                try {
                    sdata = JSON.parse(req.body.payload);
                } catch (e) {
                    console.log("Error :: saveCardPdf::", e);
                    sdata = req.body.payload;
                }
                const requiredFields = ['idstripecard'];
                let message = "";
                switch (true as boolean) {
                    case (!sdata || !('payload' in req.body)):
                        message = "Missing request body";
                        break;
                    case !req.file:
                        message = "file is required!";
                        break;
                    case requiredFields.some(f => isEmpty(sdata[f])):
                        const missingFields = requiredFields.filter(f => isEmpty(sdata[f]));
                        message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                        break;
                    case (sdata.idstripecard && !/^\d+$/.test(sdata.idstripecard.toString())):
                        message = "idstripecard must be numeric!";
                        break;
                    case (req.file && req.file.mimetype != 'application/pdf'):
                        message = "Only PDF files is allowed!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ message: message, status: 502 });
                    objv.execute();
                } else {
                    let idcard = sdata.idstripecard;
                        let value: any = '';
                        const fileName = req.file.filename;
                        value = kycpdf.generateCardPDF + fileName;
 
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
                        obj.prepare();
                        obj.execute((_error, upRes) => {
 
                        })
                 
                }
 
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        })
    }

    // public saveCardPdfOnboarding(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let sdata = JSON.parse(req.body.payload);
    //             let idcard = sdata.idstripecard;
    //             if (req.file) {
    //                 let value: any = '';
    //                 const fileName = req.file.filename; 
    //                 value = kycpdf.generateCardPDF + fileName;
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
    //                 obj.prepare();
    //                 obj.execute((_error, upRes) => {
    //                     if (_error == 1) {
    //                         let obj2 = new ModelRawQuery(req, res);
    //                         obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idstripecard`='" +idcard+ "'";
    //                         obj2.prepare();
    //                         obj2.execute((_error: any, result: any) => {
    //                             if (_error == 1) {
    //                                 if (result.length > 0) {
    //                                     let customerId = result[0].customer_id;
    //                                     let temp2: string = "{\"customer_id\": \"" + customerId + "\"}";
    //                                     let addcustumerid = JSON.parse(temp2);
    //                                     let data1: any = Object.assign(sdata.paymentdata, addcustumerid);
    //                                     if (sdata.paymentdata != null && sdata.paymentdata != "" && sdata.paymentdata != "undefined" && sdata.paymentdata.amount > 0) {
    //                                         let spdata = JSON.parse(req.body.payload);
    //                                         let stipedata = data1;
    //                                         let st = new StripeApi();
    //                                         st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
    //                                             if (error == 1) {
    //                                                 console.log("Subscription Balance Deducted Successfully!");
    //                                             }
    //                                         });
    //                                     }
    //                                 }
    //                             } else {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({ message: "Something went wrong!", status: 501 });
    //                                 objv.execute();
    //                             }
    //                         });
    //                     } else {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
    //                         objv.execute();
    //                     }
    //                 });
    //             }
    //         } else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

    // public saveCardPdfOnboarding(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let sdata = JSON.parse(req.body.payload);
    //             let idcard = sdata.idstripecard;
    //             if (req.file) {
    //                 let value: any = '';
    //                 const fileName = req.file.filename; 
    //                 value = kycpdf.generateCardPDF + fileName;
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
    //                 obj.prepare();
    //                 obj.execute((_error, upRes) => {
    //                     if (_error == 1) {
    //                         let obj2 = new ModelRawQuery(req, res);
    //                         obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idstripecard`='" +idcard+ "'";
    //                         obj2.prepare();
    //                         obj2.execute((_error: any, result: any) => {
    //                             if (_error == 1) {
    //                                 if (result.length > 0) {

    //                                   let rate = new APIBase();
    //                                   rate.subscriptionProrationCalculator(req, res, sessData.idaccount, (pc_err, prorate1) => {
    //                                       if(pc_err==1){
    //                                         let finalamount =prorate1;
    //                                         let temp3: string = "{\"amount\": \"" + finalamount + "\"}";
    //                                         let fianlprratedamount = JSON.parse(temp3);
    //                                         let customerId = result[0].customer_id;
    //                                         let temp2: string = "{\"customer_id\": \"" + customerId + "\"}";
    //                                         let addcustumerid = JSON.parse(temp2);
    //                                         let data1: any = Object.assign(sdata.paymentdata, addcustumerid,fianlprratedamount);

    //                                         if (sdata.paymentdata != null && sdata.paymentdata != "" && sdata.paymentdata != "undefined" && sdata.paymentdata.amount > 0) {
    //                                             let spdata = JSON.parse(req.body.payload);
    //                                             let stipedata = data1;
    //                                             let st = new StripeApi();
    //                                             st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
    //                                                 if (error == 1) {
    //                                                     console.log("Subscription Balance Deducted Successfully!");
    //                                                 }
    //                                             });
    //                                         }
    //                                       }else{
    //                                           let objvs = new RawView(res);
    //                                           objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
    //                                            objvs.execute();
    //                                       }
    //                                   });
    //                                 }
    //                             } else {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({ message: "Something went wrong!", status: 501 });
    //                                 objv.execute();
    //                             }
    //                         });
    //                     } else {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
    //                         objv.execute();
    //                     }
    //                 });
    //             }
    //         } else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

    public saveCardPdfOnboarding(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = JSON.parse(req.body.payload);
                let idcard = sdata.idstripecard;
                if (req.file) {
                    let value: any = '';
                    const fileName = req.file.filename;
                    value = kycpdf.generateCardPDF + fileName;
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
                    obj.prepare();
                    obj.execute((_error, upRes) => {
                        if (_error == 1) {
                            let obj2 = new ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idstripecard`='" + idcard + "'";
                            obj2.prepare();
                            obj2.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    if (result.length > 0) {
                                        let subscriptionmap = new SubscriptionManagement();
                                        subscriptionmap.Savesuscriptioncontrolmapping(req, res, sessData, (err: any,data:any) => {
                                            if (err == 1) {
                                                if (data.length>0) {
                                                    let rate = new APIBase();
                                                    rate.subscriptionProrationCalculator(req, res, sessData.idaccount, (pc_err, prorate1, dataprorate3) => {
                                                        if (pc_err == 1) {
                                                            let finalamount = prorate1;
                                                            let temp3: string = "{\"amount\": \"" + finalamount + "\"}";
                                                            let fianlprratedamount = JSON.parse(temp3);
                                                            let customerId = result[0].customer_id;
                                                            let temp2: string = "{\"customer_id\": \"" + customerId + "\"}";
                                                            let addcustumerid = JSON.parse(temp2);
                                                            let data1: any = Object.assign(sdata.paymentdata, addcustumerid, fianlprratedamount);
                                                            if (sdata.paymentdata != null && sdata.paymentdata != "" && sdata.paymentdata != "undefined" && sdata.paymentdata.amount > 0) {
                                                                let spdata = JSON.parse(req.body.payload);
                                                                let stipedata = data1;
                                                                let st = new StripeApi();
                                                                st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
                                                                    if (error == 1) {
                                                                        let subscriptionmap = new SubscriptionManagement();
                                                                        subscriptionmap.subscriptionlog(req, res, dataprorate3, sessData.idaccount, sessData.iduser, (err: any) => {
                                                                            if (err == 0) {
                                                                                console.log("Something went Wrong");
                                                                            } else {
                                                                                console.log("Subscription Log created successfully");
                                                                            }
                                                                        });
                                                                    }
                                                                });
                                                            }
     
                                                        } else {
                                                            let objvs = new RawView(res);
                                                            objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                                                            objvs.execute();
                                                        }
                                                    });
                                                }
     
                                            } else {
                                                let obj21 = new ModelRawNonQuery(req, res);
                                                obj21.nonqrysql = "UPDATE account SET subscription_payment = 1 WHERE idaccount = '" + sessData.idaccount + "'"
                                                obj21.prepare()
                                                obj21.execute((_error: any, result: any) => {
                                                    if (_error == 1) {
                                                        console.log('subscription payment updated success full')
                                                    } else {
                                                        console.log('subscription payment updated failed')
                                                    }
                                                })
     
                                            }
                                        });
     
                                    }    
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something went wrong!", status: 501 });
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
                            objv.execute();
                        }
                    });
                }
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }

    /**GET Card Pdf For Admin */
    getCardPdfForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                    let sdata: any = req.query;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount`,`card_pdf` FROM `stripe_card`";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Fetch Successfully", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }

    deleteCustomerCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                    let sdata = req.body.data
                    const stripe = stripepay(secret_key);
                    let obj3 = new ModelRawQuery(req, res);
                    obj3.qrysql = "SELECT `idaccount`, `name`, `confirm_name`, `con_fullname`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`, `email`, `source`, `address_line1`, `address_city`, `address_country`, `address_state`, `address_postal_code`, `metadata_name`, `metadata_email`, `metadata_contact`, `metadata_city`, `metadata_san`, `shipping_name`, `shipping_phone`, `shipping_address_line1`, `shipping_address_city`, `shipping_address_country`, `card_pdf`, `shipping_address_postal_code`, `shipping_address_state`,`authorize_date` FROM `stripe_card` WHERE customer_id = '" + sdata.id + "' AND idaccount = '" + sdata.idaccount + "'";
                    obj3.prepare();
                    obj3.execute((____error: any, stripeCard: any) => {
                        if (stripeCard.length > 0) {
                            stripe.customers.del(
                                stripeCard[0].customer_id
                                , (err: any, customer: any) => {
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `stripe_archive_card` (`idaccount`, `name`, `confirm_name`, `con_fullname`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`, `email`, `source`, `address_line1`, `address_city`, `address_country`, `address_state`, `address_postal_code`, `metadata_name`, `metadata_email`, `metadata_contact`, `metadata_city`, `metadata_san`, `shipping_name`, `shipping_phone`, `shipping_address_line1`, `shipping_address_city`, `shipping_address_country`, `card_pdf`, `shipping_address_postal_code`, `shipping_address_state`,`authorize_date`) VALUES ('" + stripeCard[0].idaccount + "', '" + parseBody(stripeCard[0].name) + "', '" + parseBody(stripeCard[0].confirm_name) + "', '" + parseBody(stripeCard[0].con_fullname) + "', '" + stripeCard[0].key + "', '" + stripeCard[0].customer_id + "', '" + stripeCard[0].token + "', '" + stripeCard[0].card_id + "', '" + stripeCard[0].card_brand + "', '" + stripeCard[0].last4 + "', '" + stripeCard[0].cvc_check + "', '" + stripeCard[0].exp_month + "', '" + stripeCard[0].exp_year + "', '" + stripeCard[0].funding + "', '" + stripeCard[0].client_ip + "', '" + stripeCard[0].created + "', '" + stripeCard[0].default + "', '" + parseBody(stripeCard[0].email) + "', '" + stripeCard[0].source + "', '" + parseBody(stripeCard[0].address_line1) + "', '" + parseBody(stripeCard[0].address_city) + "', '" + parseBody(stripeCard[0].address_country) + "', '" + parseBody(stripeCard[0].address_state) + "', '" + stripeCard[0].address_postal_code + "', '" + parseBody(stripeCard[0].metadata_name) + "', '" + parseBody(stripeCard[0].metadata_email) + "', '" + stripeCard[0].metadata_contact + "', '" + parseBody(stripeCard[0].metadata_city) + "', '" + stripeCard[0].metadata_san + "', '" + parseBody(stripeCard[0].shipping_name) + "', '" + stripeCard[0].shipping_phone + "', '" + parseBody(stripeCard[0].shipping_address_line1) + "', '" + parseBody(stripeCard[0].shipping_address_city) + "', '" + parseBody(stripeCard[0].shipping_address_country) + "', '" + stripeCard[0].card_pdf + "', '" + stripeCard[0].shipping_address_postal_code + "', '" + parseBody(stripeCard[0].shipping_address_state) + "',NOW())";
                                    obj1.prepare()
                                    obj1.execute((_err: any, result: any) => {
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "DELETE FROM stripe_card WHERE customer_id = '" + sdata.id + "' AND idaccount = '" + sdata.idaccount + "'"
                                        obj2.prepare()
                                        obj2.execute((_err: any, result: any) => {
                                            if (_err == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                                objv.execute();
                                            }
                                        })
                                    }
                                    )
                                });
                        }
                        else {
                            let objv1 = new RawView(res);
                            objv1.prepare({ message: "There is no Stripe Card!", status: 502 });
                            objv1.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    CustomercardData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT s.`idaccount`,s.`name`,s.`confirm_name`,s.`con_fullname`,s.`key`,s.`customer_id`,s.`token`,s.`card_id`,s.`created_at`,s.`deleted_at`,s.`card_brand`,s.`last4`,s.`cvc_check`,s.`exp_month`,s.`exp_year`,s.`funding`,s.`client_ip`,s.`created`,s.`default`,s.`email`,s.`source`,s.`address_line1`,s.`address_city`,s.`address_country`,s.`address_state`,s.`address_postal_code`,s.`metadata_name`,s.`metadata_email`,s.`metadata_contact`,s.`metadata_city`,s.`metadata_san`,s.`shipping_name`,s.`shipping_phone`,s.`shipping_address_line1`,s.`shipping_address_city`,s.`shipping_address_country`,s.`card_pdf`,s.`shipping_address_postal_code`,s.`shipping_address_state`,`b`.`address1` AS `address11`,`b`.`address2` AS `address21`,`b`.`city` AS `city1`,`b`.`state` AS `state1`,`b`.`postal_code` AS `postal_code1`,`b`.`country` AS `country1`,`up`.`firstname` AS `first_name1`,`up`.`lastname` AS `last_name1`,`up`.`email` AS `email1` FROM `stripe_card` AS s INNER JOIN `billing_address` AS `b` ON s.`idaccount` = `b`.`idaccount` INNER JOIN `user_profile` AS `up` ON `b`.`idaccount` = `up`.`account_id` WHERE s.`idstripecard` = '" + req.query.type + "' GROUP BY s.`customer_id`"
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Card Details Fetch Successfully", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }

    CustomerStripecardData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                    const stripe = stripepay(secret_key);
                    stripe.customers.retrieve(
                        req.query.type
                        , (err: any, customer: any) => {
                            if (!err) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Stripe Data Fetched Successfully!", status: 201, data: customer });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: customer });
                                objv.execute();
                            }
                        });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }

    public subscriptionBalanceDeduct(req: Request, res: Response, sessdata: any, stipedata: any, sdata: any, callback: (err: any, data: any) => void) {
        const stripe = stripepay(secret_key);
        const finalAmount:any = parseFloat(stipedata.amount).toFixed(2); 
        const numberAmount: number = Number(finalAmount * 100);
        let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT trust_score FROM user WHERE idaccount = '" + idaccount + "'";
        obj.prepare();
        obj.execute((_error: any, result: any) => {
            if (_error === 1) {
                stripe.charges.create({
                    customer: stipedata.customer_id,
                    amount: numberAmount,
                    currency: 'USD',
                    description: 'Subscription Payment',
                    metadata: {
                        email: stipedata.email,
                        san: Math.floor(100000000 + idaccount),
                        trust_score: result[0].trust_score
                    },
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }
                }, (err: any, charge: any) => {
                    const amount = charge ? charge.amount / 100 : stipedata.amount;
                    if (err) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO stripe_payment (idaccount, email, charge_id, customer_id, balance_transaction, amount, created, status, description, type, is_status) VALUES ('" + idaccount + "', '" + parseBody(stipedata.email) + "', '', '', '', '" + amount + "', NOW(), 'failed', 'Subscription payment failed (" + parseBody(err.raw.message) + ")', 'Credit Card Payment', '0')";
                        obj.prepare();
                        obj.execute((serror: any, result: any) => {
                            if (serror === 1) {
                                callback(0, { message: "Payment Failed !", status: 504 });
                            } else {
                                callback(0, { message: "Something Went Wrong with payment failed !", status: 505 });
                            }
                        });
                    } else {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO stripe_payment (idaccount, email, charge_id, customer_id, balance_transaction, amount, created, status, description, type, is_status, card_last4) VALUES ('" + idaccount + "', '" + parseBody(stipedata.email) + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "', '" + parseBody(charge.description) + " Success', 'Credit Card Payment', '1', '"+charge.payment_method_details.card.last4+"')";
                        obj1.prepare();
                        obj1.execute((serror1: any, result: any) => {
                            if (serror1 == 1) {
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE account SET subscription_payment = 1 WHERE idaccount = '" + idaccount + "'";
                                obj5.prepare();
                                obj5.execute((serror: any, result: any) => {
                                    if (serror == 1) {
                                        let obj9 = new ModelRawNonQuery(req, res);
                                        obj9.nonqrysql = "UPDATE `subscription_account` SET `status` = 1 WHERE idaccount = '" + sessdata.idaccount + "'";
                                        obj9.prepare();
                                        obj9.execute((paymentError: any, result: any) => {
                                            if (paymentError == 1) {
                                                callback(1, { message: "Subscription charges deducted successfully !", status: 201 });

                                            } else {
                                                callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 501 });
                                            }

                                        })
                                    } else {
                                        callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 502, err: serror });
                                    }
                                });
                            } else {
                                callback(0, { message: "Payment update failed", status: 501 });
                            }
                        });
                    }
                });
            } else {
                callback(0, { message: "Failed to fetch user trust score", status: 500 });
            }
        });
    }

}