import { Request, Response, NextFunction } from "express";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { ModelPdfUpload } from "../lib/model/ModelPdfUpload";
import { SubscriptionManagement } from "./SubscriptionManagement";
// import { AppRoute } from "../lib/AppRoute";
import { checkvalue, parseBody, setToZero } from "./markError";
import { APIBase } from "./APIBase";
let validuser = new APIBase();
export class TierManagement {

    constructor() {
        // super();
    }

    // get Tariffs
    getTraiffs(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,name,description,type,day_num,proration,tariff_link FROM tariff where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    })
                    objv.execute()
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    // Get Tariff Via Type

    // get Tariffs
    getTypesTraiffs(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,name,description,type,day_num,proration,tariff_link FROM tariff where `idaccount` = '" + sessdata.idaccount + "' AND `type`= '" + req.query.type + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    })
                    objv.execute()
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    // get Tariffs
    getTraiff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,name,description,type,day_num,proration,tariff_link FROM tariff where `idtariff` = '" + req.query.type + "' ";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({ data: allcamp, message: "Data Fetched Succesfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    saveTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var rdata: any = [];
                rdata = req.body.data;
                let subscriptiondata = rdata.subscription;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where name = '" + parseBody(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Tariff Already Exists!", status: 409
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.filter = null;
                        // obj2.qrysql = "INSERT into tariff (`idaccount`,`name`, `description`, `type`) VALUES('"+sessdata.idaccount+"', '" + rdata.name + "', '" + rdata.description + "', '"+rdata.type+"')";
                        obj2.qrysql = "Call AddTariff(" + sessdata.idaccount + ", 'Registered', '" + parseBody(rdata.name) + "', '" + parseBody(rdata.description) + "', " + setToZero(rdata.day_num) + ", '" + parseBody(rdata.tarifflink) + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp.length > 0) {
                                if (subscriptiondata.length > 0) {
                                    let subscriptionmap = new SubscriptionManagement();
                                    subscriptionmap.subscriptiontariffmapping(req, res, subscriptiondata, allcamp[0], (err: any) => {
                                        if (err == 0) {
                                            console.log("Something went Wrong");
                                        } else {
                                            console.log("Subscription Data Saved");
                                        }
                                    });
                                }
                                let objv = new RawView(res);
                                objv.prepare({ data: allcamp[0], message: "Tariff Saved Successfully", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                        // });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    copyTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var rdata: any = [];
                rdata = req.body.data;
                let subscription = rdata.subscription;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where name = '" + parseBody(rdata.name) + "'";
                obj.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where name = '" + parseBody(rdata.name) + " -copy'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 504, message: "Tariff Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.filter = null;
                        // obj2.qrysql = "Call AddTariff(" + sessdata.idaccount + ", 'Registered', '" + parseBody(rdata.name) + "', '" + parseBody(rdata.description) + "', " + setToZero(rdata.day_num) + ")";
                        obj2.qrysql = "Call AddTariff(" + sessdata.idaccount + ", 'Registered', '" + parseBody(rdata.name) + " -copy', '" + parseBody(rdata.description) + "', " + setToZero(rdata.day_num) + ", '" + parseBody(rdata.tarifflink) + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // Copy TARIFF
                            if (allcamp.length > 0 && rdata.id) {
                                let IDtar = allcamp[0][0].idtariff;
                                // voice rate Table
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "SELECT idrates,idaccount,idtariff,type,subtype,rate,final_rate,mo,mt,mocfpc,mocfpm,state,city,category,description,priority,rateType,billing_type,billing_frequency,proration FROM `voice_rates` WHERE `idtariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                obj.prepare();
                                obj.execute((errors: any, data1: any) => {
                                    if (errors == 1 && data1.length > 0) {
                                        let result: any = {};
                                        result = data1;
                                        result.forEach((element: any) => {
                                            let updatedPrice = element.rate;
                                            switch (element.billing_frequency) {
                                                case '0': updatedPrice = element.rate * 1;
                                                    break;
                                                case '1': updatedPrice = element.rate * 3;
                                                    break;
                                                case '2': updatedPrice = element.rate * 6;
                                                    break;
                                                case '3': updatedPrice = element.rate * 12;
                                                    break;
                                                default:
                                                    break;
                                            }
                                            let proration = element.proration && element.proration !== undefined ? element.proration : false;

                                            let obj3 = new ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "UPDATE `voice_rates` SET `rate`='" + setToZero(element.rate) + "', `mo` = '" + setToZero(element.mo) + "', `mt` = '" + setToZero(element.mt) + "', `mocfpc` = '" + setToZero(element.mocfpc) + "', `mocfpm` = '" + setToZero(element.mocfpm) + "', `billing_frequency` = " + setToZero(element.billing_frequency) + " , `proration` = '" + proration + "', `final_rate` = " + setToZero(updatedPrice) + " WHERE `idtariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `subtype` = '" + element.subtype + "' AND `category` = '" + element.category + "'";
                                            obj3.prepare();
                                            obj3.execute((eror: any, voiceRate: any) => {
                                                console.log("Voice Rate Updated Found");
                                            });
                                        });
                                    }
                                    else {
                                        console.log("Voice Rate Not Found");
                                    }
                                });
                                let obj2 = new ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `day_num`,`proration` FROM `tariff` WHERE `idtariff`=" + rdata.id + "";
                                obj2.prepare();
                                obj2.execute((error1: any, DayNUM: any) => {
                                    if (error1 == 1 && DayNUM.length > 0) {
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `tariff` SET `day_num`=" + setToZero(DayNUM[0].day_num) + ",`proration`='" + DayNUM[0].proration + "' WHERE `idtariff` = " + IDtar + "";
                                        obj2.prepare();
                                        obj2.execute((error2: any, uDayNUM: any) => {
                                            console.log("Proration Updated");
                                        })
                                    }
                                    else {
                                        console.log("Proration not Updated");
                                    }
                                });
                                // sms rates table
                                let objs = new ModelRawQuery(req, res);
                                objs.qrysql = "SELECT idsmsrate,id_tariff,idaccount,category,categoryvalue,subcategory,priority,type,MO_rates,MT_rates,state,city from `sms_rate` WHERE `id_tariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                objs.prepare();
                                objs.execute((error: any, data2: any) => {
                                    if (error == 1 && data2.length > 0) {
                                        let result2: any = {};
                                        result2 = data2;
                                        result2.forEach((element: any) => {
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "UPDATE `sms_rate` SET `MO_rates`='" + setToZero(element.MO_rates) + "', `MT_rates` = '" + setToZero(element.MT_rates) + "' WHERE `id_tariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `category` = '" + element.category + "' AND `subcategory` = '" + element.subcategory + "'";
                                            obj4.prepare();
                                            obj4.execute((error: any, smsRate: any) => {
                                                console.log("SMS Rate Updated");
                                            })
                                        });
                                    }
                                    else {
                                        console.log("SMS Rate Not Found");
                                    }
                                });
                                let objkk = new ModelRawQuery(req, res);
                                objkk.qrysql = "SELECT idrates,idaccount,iduser,idtariff,type,rate,category,description,priority FROM `lookup_api_rates` WHERE `idtariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                objkk.prepare();
                                objkk.execute((errors: any, look_res: any) => {
                                    if (errors == 1 && look_res.length > 0) {
                                        let result2: any = {};
                                        result2 = look_res;
                                        result2.forEach((element: any) => {
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "UPDATE `lookup_api_rates` SET `rate`='" + setToZero(element.rate) + "' WHERE `idtariff` = '" + IDtar + "' AND `type` = '" + element.type + "' AND `category` = '" + element.category + "'";
                                            obj4.prepare();
                                            obj4.execute((error: any, smsRate: any) => {
                                                console.log("Lookups API Rate updated");
                                            })
                                        });
                                    }
                                    else {
                                        console.log("Lookups API Rate Not Found");
                                    }
                                });
                                // msg activation price
                                let obj10 = new ModelRawQuery(req, res);
                                obj10.qrysql = "SELECT `idrates`,`idaccount`,`iduser`,`idtariff`,`type`,`mrc`,`nrc`,`category`,`priority` FROM `message_activation_pricing` WHERE `idtariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                obj10.prepare();
                                obj10.execute((errors: any, msgPrices: any) => {
                                    if (errors == 1 && msgPrices.length > 0) {
                                        let result4: any = {};
                                        result4 = msgPrices;
                                        result4.forEach((element: any) => {
                                            let obj04 = new ModelRawNonQuery(req, res);
                                            obj04.nonqrysql = "UPDATE `message_activation_pricing` SET `mrc`='" + setToZero(element.mrc) + "',`nrc`= '" + setToZero(element.nrc) + "' WHERE `idtariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `category` = '" + element.category + "'";
                                            obj04.prepare();
                                            obj04.execute((error: any, upmsgRes: any) => {
                                                console.log("Message Activation Pricing Inserted Successfully");
                                            })
                                        });
                                    }
                                    else {
                                        console.log("Message Activation Rate Not Found");
                                    }
                                });

                                let obj00 = new ModelRawQuery(req, res);
                                obj00.qrysql = "SELECT campaign_rate_id,idaccount,iduser,idtariff,type,rate,category,priority,mrc FROM `campaign_rates` WHERE `idtariff` = '" + rdata.id + "' ORDER BY `priority` ASC";
                                obj00.prepare();
                                obj00.execute((errors: any, Campres: any) => {
                                    if (errors == 1 && Campres.length > 0) {
                                        let result3: any = {};
                                        result3 = Campres;
                                        result3.forEach((element: any) => {
                                            let obj04 = new ModelRawNonQuery(req, res);
                                            obj04.nonqrysql = "UPDATE `campaign_rates` SET `rate`=" + setToZero(element.rate) + ",`mrc`=" + setToZero(element.mrc) + " WHERE `idtariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `category` = '" + element.category + "'";
                                            obj04.prepare();
                                            obj04.execute((error: any, upCampRes: any) => {
                                                console.log("Campaign Rates Inserted");
                                            })
                                        });
                                    }
                                    else {
                                        console.log("Campaign Rates Not Found");
                                    }
                                });

                                if (subscription.length >= 0) {
                                    let subscriptionmap = new SubscriptionManagement();
                                    subscriptionmap.Updatesubscriptiontariffmapping(req, res, subscription, IDtar, (err: any) => {
                                        if (err == 0) {
                                            console.log("Something went Wrong");
                                        } else {
                                            console.log("Subscription Data Saved");
                                        }
                                    });
                                }

                                let obj1 = new RawView(res);
                                obj1.prepare({ data: allcamp[0], message: "Tariff Copied Successfully", status: 201 });
                                obj1.execute();

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Copy Tariff!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    updateTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const isEmpty = (value: any): boolean =>
                    value == undefined || value == null || value == '' || value == 'null' || value == 'undefined';
                const requiredFields = ['id', 'name', 'description'];
                let sdata = req.body.data;
                let message = "";
                const urlRegex =
                    /^(https?:\/\/)?([\p{L}\p{N}\u0900-\u097F-]+\.)+[\p{L}\u0900-\u097F]{2,}(\/[\p{L}\p{N}\u0900-\u097F\-._~:/?#\[\]@!$&'()*+,;=%]*)?(?:\?[^#\s]*)?(?:#[^\s]*)?$/u;
                switch (true) {
                    case (!sdata || !('data' in req.body)):
                        message = "Missing request body";
                        break;
                    case requiredFields.some(f => isEmpty(sdata[f])):
                        const missingFields = requiredFields.filter(f => isEmpty(sdata[f]));
                        message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                        break;
                    case (sdata.name && sdata.name.length < 3):
                        message = "name must be at least 3 characters!";
                        break;
                    case (sdata.name && checkvalue(sdata.name)):
                        message = "name is invalid!";
                        break;
                    case (sdata.id && !/^\d+$/.test(sdata.id.toString())):
                        message = "id must be numeric!";
                        break;
                    case (sdata.description && sdata.description.length < 10):
                        message = "description must be at least 5 characters!";
                        break;
                    case (sdata.description && checkvalue(sdata.description)):
                        message = "description is invalid!";
                        break;
                    case (sdata.tarifflink && !urlRegex.test(sdata.tarifflink)):
                        message = "tarifflink must be a valid URL!";
                        break;
                    case (!isEmpty(sdata.subscription) && (!Array.isArray(sdata.subscription) || sdata.subscription.length === 0)):
                        message = "subscription must be a non-empty array!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ message: message, status: 502 });
                    objv.execute();
                } else {
                    let obj = new ModelRawNonQuery(req, res)
                    let terrifid = sdata.id
                    let subscription = sdata.subscription;
                    obj.nonqrysql = "UPDATE tariff SET name='" + parseBody(sdata.name) + "', description='" + parseBody(sdata.description) + "',tariff_link='" + parseBody(sdata.tarifflink) + "' WHERE idtariff = " + sdata.id + "";
                    obj.prepare();
                    obj.execute((_error: any, allcamp: any) => {
                        if (_error == 1) {
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "Select idtariff,idaccount,name,description,type,day_num,proration from tariff where idaccount = " + sessdata.idaccount + "";
                            obj1.prepare();
                            obj1.execute((__error: any, resResult: any) => {
                                if (__error == 1) {

                                    if (subscription.length >= 0) {
                                        let subscriptionmap = new SubscriptionManagement();
                                        subscriptionmap.Updatesubscriptiontariffmapping(req, res, subscription, terrifid, (err: any) => {
                                            if (err == 0) {
                                                console.log("Something went Wrong");
                                            } else {
                                                console.log("Subscription Data Saved");
                                            }
                                        });
                                    }

                                    let objv2 = new RawView(res);
                                    objv2.prepare({ message: "Tarrif Update Successfully!", data: resResult, session: sessdata, status: 201 });
                                    objv2.execute();
                                }
                                else {
                                    let objv2 = new RawView(res);
                                    objv2.prepare({ message: "Rate Plan Updated Connection break with fetch data!", data: resResult, status: 502 });
                                    objv2.execute();
                                }
                            });
                        }
                        else {
                            let objv2 = new RawView(res);
                            objv2.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv2.execute();
                        }
                    });
                }


            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
 

    // public deleteTariff(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((_error: any, _sessdata: any) => {
    //         let obj = new ModelRawNonQuery(req, res);
    //         obj.nonqrysql = "delete from tariff WHERE idtariff = " + req.query.id + "";
    //         obj.prepare();
    //         obj.execute((_error: any, lastid: any) => {
    //             if (_error == 10) {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ message: "Tariff is already mapped to some accounts!", status: 401 });
    //                 objv.execute();
    //             }
    //             else {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ message: "Tariff Deleted Successfully", data: lastid[0], status: 201 });
    //                 objv.execute();
    //             }
    //         });
    //     });
    // }
    public deleteTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let idservice = req.query.ID
            let obj1 = new ModelRawQuery(req, res);
            obj1.qrysql = "SELECT `idaccount` FROM `user` WHERE `idtariff` = '" + idservice + "'";
            obj1.prepare();
            obj1.execute((error: any, result: any) => {
                if(error == 1){
                    if (result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 401, message: "This tariff is mapped with " + result.length + " customers and cannot be deleted!" });
                        objv.execute();
                    } else {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "DELETE FROM `tariff` WHERE `idtariff` = '" + req.query.ID + "'";
                        obj.prepare();
                        obj.execute((error1: any, lastid: any) => {
                            if (error1 == 1) {
                                let objv = new RawView(res);
                                objv.prepare({status: 201, data: lastid[0], message: "Tariff Deleted Successfully!" });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 501, message: "Something Went Wrong With Delete Tariff!" });
                                objv.execute();
                            }
                        });
                    }
                }
                else{
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Something Went Wrong With Check Tariff!" });
                    objv.execute();
                }
                
            });
        });
    }


    // Save Tariff 
    saveSurcharge(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idsurcharge,idaccount,name,description FROM surcharge where name = '" + parseBody(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Surcharge Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.filter = null;
                        obj2.nonqrysql = "INSERT into surcharge (`idaccount`,`name`, `description`) VALUES (" + sessdata.idaccount + ", '" + parseBody(rdata.name) + "', '" + parseBody(rdata.description) + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp) {
                                let objv = new RawView(res);
                                objv.prepare({ data: allcamp, message: "Surcharge Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    public updateSurcharge(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, session: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let Qry: any = '';
                for (let key of Object.keys(rdata)) {
                    let num: any = [];
                    num = key.match(/[\d\.]+/g);
                    let index = num.length;
                    let idoperator = num[index - 1];
                    // let idoperator = num.at(-1);

                    /*
                    If you will request some data other than priority and rates from angular side, then you will have to change this below condition.
                    */
                    if (key !== 'priority_' + idoperator) {
                        if (key !== 'idoperator_' + idoperator) {
                            // console.log("keykey",key);
                            let type = key.split('_')[0];
                            let subtype = key.split('_')[1];
                            let direction = key.split('_')[2];
                            Qry += "UPDATE `surcharge_rates` SET `rates`=" + setToZero(rdata[key]) + " WHERE `idoperator`= " + setToZero(idoperator) + " AND `type`= '" + type + "' AND `subtype`= '" + subtype + "' AND `direction`= '" + direction + "';\n"
                        }
                    }
                }
                if (Qry) {
                    let objk = new ModelRawNonQuery(req, res);
                    objk.nonqrysql = Qry
                    objk.prepare()
                    objk.execute((error: any, data: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Surcharge Updated Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Surcharge Not Updated Successfully!", status: 502 });
                            objv.execute();
                        }
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Surcharge Not Updated!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!", status: 504 });
                objv.execute();
            }
        });
    }
    public editSurcharge(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, session: any) => {
            if (error == 1) {
                let rdata: any = req.body.data;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `surcharge` SET `name`='" + parseBody(rdata.name) + "', `description`='" + parseBody(rdata.description) + "' WHERE `idsurcharge`= " + rdata.idsurcharge + "";
                obj.prepare()
                obj.execute((error: any, data: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Surcharge Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Surcharge Not Updated Successfully!", status: 502 });
                        objv.execute();
                    }

                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }


    public updateTariffDay(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `tariff` SET `day_num`=" + setToZero(rdata.day_num) + " WHERE `idtariff` = " + rdata.idtariff + "";
                obj2.prepare();
                obj2.execute((errorr: any, allcamp: any) => {
                    if (errorr == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, message: "(" + rdata.day_num + ") Days Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Days Not Updated!" });
                        objv.execute();
                    }
                });

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateProRate(req: Request, res: Response, next: NextFunction) {
        let spdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                if (spdata.proration === "true" || spdata.proration === "false") {
                    obj2.nonqrysql = "UPDATE `tariff` SET `proration`='" + spdata.proration + "' WHERE `idtariff` = " + spdata.idtariff + "";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Proration Successfully Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Prorate!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Pro-rate!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    updateProration(req: Request, res: Response, next: NextFunction) {
        let prorateData = req.body.data;
        console.log(prorateData, "proration data")
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (prorateData.proration === "true" || prorateData.proration === "false") {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `voice_rates` SET `proration`='" + prorateData.proration + "' WHERE `idtariff` = " + prorateData.idtariff + " AND `category` = '" + prorateData.category + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Proration Successfully Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Prorate!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Pro-rate!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    // Save Service Profile
    saveServiceProfile(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idservice,iduser,name,description,is_default FROM service where name = '" + parseBody(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Service Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.filter = null;
                        obj2.nonqrysql = "INSERT into `service` (`iduser`,`name`, `description`) VALUES (" + sessdata.iduser + ", '" + parseBody(rdata.name) + "', '" + parseBody(rdata.description) + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: allcamp, message: "Service Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }


    savePreference(req: Request, res: Response, next: NextFunction) {
        let sdata: any = {};
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = JSON.parse(req.body.data);
                let tmpqurty = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `description`, `type`) VALUES  ";
                rdata.forEach((element: any) => {
                    tmpqurty += "('" + sessdata.idaccount + "', '" + setToZero(element.idservice) + "', '" + setToZero(element.idsupplier) + "','" + setToZero(element.priority) + "','" + 'Description' + "', '" + parseBody(element.type) + "'),";
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Preference Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    updatePreference(req: Request, res: Response, next: NextFunction) {
        let sdata: any = {};
        sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                sdata.forEach((result: any) => {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `type`, `key`) VALUE ('" + sessdata.idaccount + "','" + setToZero(result.idservice) + "', '" + result.idsupplier + "','" + setToZero(result.priority) + "', '" + parseBody(result.type) + "', '" + sessdata.idaccount + "-" + setToZero(result.idservice) + "-" + parseBody(result.type) + "-" + setToZero(result.priority) + "' ) ON DUPLICATE KEY UPDATE `idservice`='" + setToZero(result.idservice) + "', `idsupplier`='" + setToZero(result.idsupplier) + "',`priority`='" + setToZero(result.priority) + "', `key`='" + sessdata.idaccount + "-" + setToZero(result.idservice) + "-" + parseBody(result.type) + "-" + setToZero(result.priority) + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Preference Update Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getPreference(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idpreference`, `key`, `idservice`, `idsupplier`, `priority`, `type`, `created`, `description` FROM `preference` WHERE `type` = '" + sdata.type + "' AND `idservice`='" + sdata.idservice + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }

    updatePreferenceService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res)
            let sdata: any = [];
            sdata = req.body.data;
            obj.nonqrysql = "UPDATE service SET name='" + parseBody(sdata.name) + "', description='" + parseBody(sdata.description) + "' WHERE idservice = '" + sdata.idservice + "'";
            obj.prepare();
            obj.execute((_error: any, allcamp: any) => {
                if (allcamp) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "select idservice,name,description,is_default from service where iduser = '" + sessdata.iduser + "'";
                    obj1.prepare();
                    obj1.execute((_error: any, resResult: any) => {
                        let objv2 = new RawView(res);
                        objv2.prepare({ message: "Service Profile Update Successfully!", data: resResult });
                        objv2.execute();
                    });
                }
                else {
                    let objv2 = new RawView(res);
                    objv2.prepare({ message: "Something Went Wrong!" });
                    objv2.execute();
                }
            });
        });
    }

    getServiceProfiles(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idservice,name,description,is_default FROM `service` WHERE `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }

    getServiceProfile(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idservice,iduser,name,description,is_default FROM `service` WHERE `idservice`='" + sdata.idservice + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }

    setDefaultService(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "UPDATE `service` SET `is_default`='false' WHERE `iduser`='" + sessData.iduser + "'";
                obj1.prepare();
                obj1.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `service` SET `is_default`='true' WHERE `iduser`='" + sessData.iduser + "' AND `idservice`='" + sdata.data.split('-')[0] + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Default Preference Service Changed Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Preference Service", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    // public deletePreferenceService(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((_error: any, _sessdata: any) => {
    //         let obj = new ModelRawNonQuery(req, res);
    //         obj.nonqrysql = "delete from `service` WHERE `idservice` = '" + req.query.id + "'";
    //         obj.prepare();
    //         obj.execute((_error: any, lastid: any) => {
    //             if (_error == 10) {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ message: "Something Went Wrong!" });
    //                 objv.execute();
    //             }
    //             else {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ message: "Service Profile Deleted Successfully", data: lastid[0] });
    //                 objv.execute();
    //             }
    //         });
    //     });
    // }
    public deletePreferenceService(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((_error: any, _sessdata: any) => {
        let idservice = req.query.ID
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `idaccount` FROM `user` WHERE `idservice` = '" + idservice + "'";
        obj1.prepare();
        obj1.execute((error: any, result: any) => {
            if(error == 1){
                if (result.length > 0) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 401, message: "This service is mapped with " + result.length + " customers and cannot be deleted!" });
                    objv.execute();
                } 
                else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `service` WHERE `idservice` = '" + idservice + "' AND `is_default` = 'false'";
                    obj.prepare();
                    obj.execute((error1: any, lastid: any) => {
                        if (error1 == 1 && lastid.affectedRows > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, data: lastid[0], message: "Service Profile Deleted Successfully" });
                            objv.execute();
                        } else if (lastid && lastid.affectedRows === 0) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 401, message: "Default service cannot be deleted!" });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 501, message: "Something Went Wrong With Check Service!" });
                            objv.execute();
                        }
                    });
                }
            } else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong With Delete Service!" });
                objv.execute();
            }
        });
    });
}

    // get Surcharge
    getSurcharges(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idsurcharge, name, description FROM `surcharge` where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1 && allcamp.length > 0) {
                        let objv = new RawView(res)
                        objv.prepare({
                            data: allcamp,
                            message: "Data Fetched Succesfully.",
                            status: 200
                        })
                        objv.execute()
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            data: allcamp,
                            message: "No Data Available!",
                            status: 502
                        })
                        objv.execute()
                    }

                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    getTariffList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idtariff,name,description,type,day_num,proration FROM tariff";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Tariff Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    getSingleTraiff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        let trfid = req.query.type
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,name,description,type,day_num,proration FROM tariff where `idtariff` = " + trfid + " AND `idaccount` = " + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    })
                    objv.execute()
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    public deleteSurcharge(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from surcharge WHERE idsurcharge = " + req.query.id + "";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                if (_error == 10) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Surcharge is already mapped to some Tariff!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Surcharge Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }

    // public SaveRate(req: Request, res: Response, next: NextFunction) {
    //     console.log("Data===>"+req.body.data);
    //     console.log("req.query", req.query);
    //     let sdata: any;
    //     try {
    //         sdata = req.body.data;
    //     } catch (e) {
    //         sdata =  req.body.data;
    //     }

    //     console.log(sdata);

    //     let session = new SessionManagment(req, res, next);
    //     let msg = "";
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "CALL AddBilling('" + sessdata.iduser + "', '"+sdata+"', '20')";
    //             obj.prepare();
    //             obj.execute((error: any, result: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: result[0], message: msg });
    //                 objv.execute();
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    public SaveRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        let msg = "";

        session.GetSession((error: any, sessdata: any) => {
            let obj2 = new ModelRawQuery(req, res);

            var result: any = [];
            obj2.filter = null;
            let rdata: any = req.body.data;
            rdata.forEach((element: any) => {
                element.forEach((ele: any) => {
                    result[ele.field] = ele.value;
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `billing_rate` (`id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc`) VALUES(" + setToZero(result.idtariff) + ", " + setToZero(result.idpriority) + " , '" + parseBody(result.feature) + "', " + setToZero(result.usage) + " ," + setToZero(result.disconnect) + ", " + setToZero(result.setup) + ", " + setToZero(result.recurringmrc) + ", " + setToZero(result.portinnrc) + ", " + setToZero(result.portoutnrc) + ")";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                });
            });
            let objv = new RawView(res);
            objv.prepare({ message: "Rate Saved Successfully!" });
            objv.execute();
        });
    }


    updateData(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `billing_rate` SET `feature`='" + result.feature + "', `usage`='" + setToZero(result.usage) + "', `disconnect`='" + setToZero(result.disconnect) + "', `setup`='" + setToZero(result.setup) + "', `recurring_mrc`='" + setToZero(result.recurringmrc) + "', `port_in_nrc`='" + setToZero(result.portinnrc) + "', `port_out_nrc`='" + setToZero(result.portoutnrc) + "' WHERE `idbilling_rate`= '" + result.idbillingrate + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public UploadCSV(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawNonQuery(req, res);
        let sdata: any = {};
        let session = new SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.body;
                let objfile = new ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new ModelRawNonQuery(req, res);
                let tier_csv = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'")
                obj.nonqrysql = "INSERT INTO `upload` (`FileName`,`DestinationPath`,`FileType`,`UserID`)	VALUES ('" + tier_csv + "', '" + req.file.destination + "', '" + req.body.filetype + "','" + req.body.sessionid + "')";
                obj.prepare();
                obj.execute((error: any, lastid: any) => {
                    let objv = new RawView(res);
                    let filepath = req.file.destination + tier_csv;
                    objv.prepare({ message: "Rate CSV Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getTierFeature(req: Request, res: Response, next: NextFunction) {
        let obj2 = new ModelRawQuery(req, res);
        obj2.qrysql = "SELECT idinbound_rates, feature FROM billing_feature";
        obj2.prepare();
        obj2.execute((error: any, allcamp: any) => {
            let objv = new RawView(res)
            objv.prepare({
                error: 0,
                data: allcamp,
                message: "Data Fetched Successfully"
            })
            objv.execute()
        });
    }

    getBillingRatename(req: Request, res: Response, next: NextFunction) {
        let obj2 = new ModelRawQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            obj2.qrysql = "SELECT idbilling_ratename,idtariff,name FROM billing_ratename";
            obj2.prepare();
            obj2.execute((error: any, allcamp: any) => {
                let objv = new RawView(res)
                objv.prepare({
                    error: 0,
                    data: allcamp,
                    message: "Data Fetched Succesfully"
                })
                objv.execute()
            });
        });
    }

    public getBillingRate(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select `idbilling_rate`, `id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc` from `billing_rate` where `id_tariff` = '" + req.query.type + "' ORDER BY `idinbound_rates` ASC";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: result, message: msg });
                    objv.execute();
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    // public USA_SMS_Rates(req: Request, res: Response, next: NextFunction) {

    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES('"+sessdata.idaccount+"', '"+result.idtariff+"', '"+result.priority+"' ,'"+result.category+"', '"+result.MO+"', '"+result.MT+"', '"+result.subCategory+"', '"+result.categoryValue+"')";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //              });
    //         });
    //         let objv = new RawView(res);
    //         objv.prepare({ message: "Rate Saved Successfully!" });
    //         objv.execute();
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }


    public Add10DLCA2P(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `10DLC_A2P_surcharge` (`idaccount`, `id_tariff`, `priority` ,`category`, `a`, `b`, `c`, `d`, `e`, `inbound_A2P_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "','" + result.category + "', '" + result.a + "', '" + result.b + "', '" + result.c + "', '" + result.d + "', '" + result.e + "', '" + result.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public TollFreeA2p(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `surcharge_rates` (`idaccount`, `id_tariff`, `type` ,`operator`, `direction`, `sms1`, `sms2`, `mms1`, `mms2`,`a`,`b`,`c`,`d`,`e`,`Inbound_a2p_surcharge`) VALUES('" + sessdata.idaccount + "', '" + element.idtariff + "', '" + element.type + "', '" + element.operator + "', '" + element.direction + "', '" + element.sms1 + "', '" + element.sms2 + "','" + element.sms1 + "', '" + element.sms2 + "', '" + element.a + "', '" + element.b + "','" + element.c + "','" + element.d + "','" + element.e + "', '" + element.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public ShortCodeRate(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `short_code_rates` (`idaccount`, `id_tariff`, `priority` ,`category`, `outbound_message_surcharge`, `inbound_message_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + setToZero(result.priority) + "' ,'" + result.category + "', '" + setToZero(result.outboundSurcharge) + "', '" + setToZero(result.inboundSurcharge) + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public VoiceRates(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = [];
                result = req.body.data;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `voice_rates` (`idaccount`, `id_tariff`, `usa_rate`, `canada_rate`) VALUES('" + sessdata.idaccount + "', '" + result.id_tariff + "', '" + result.cvoicerate + "', '" + result.uvoicerate + "')";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Rate Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    // Get rates 

    public GetUSA_SMS_Rates(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "select idsmsrate,id_tariff,category,categoryvalue,subcategory,priority,type,MO_rates,MT_rates,state,city from `sms_rate` where `id_tariff` = " + req.query.idtariff + " AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public GetCampaignSur_Rates(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select `displayName`,`rate`,`nrc_rates` from `campaign_cases`";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public GetCoverage_Rates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if(sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201|| sessdata.type == 202|| sessdata.type == 203){
                validuser.checksessionvalid2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `display_name`,`rate` FROM `sc_carrier_coverage`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!" });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public Get10DLCA2P(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select id_dlc_a2p,id_tariff,priority,category,a,b,c,d,e,inbound_A2P_surcharge from `10DLC_A2P_surcharge` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public GetTollFreeA2p(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select id_tollfree,id_tariff,priority,category,a,b,c,d,e,inbound_A2P_surcharge from `tollfree_a2p_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public GetShortCodeRate(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select idshort_code,id_tariff,idaccount,priority,category,outbound_message_surcharge,inbound_message_surcharge from `short_code_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }


    public GetVoiceRates(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select `id_voicerate`, `id_tariff`, `usa_rate`, `canada_rate` from `voice_rates` where `id_tariff` = '" + req.query.type + "'";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data[0], message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }


    // Update Rates

    public update10DLCRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });

                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `10DLC_A2P_surcharge` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_dlc_a2p` = '" + result.iddlca2p + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateTollFreeRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `tollfree_a2p_rates` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_tollfree` = '" + result.idtollfree + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateSMSRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let idsrt;
                    if (result.idsmsratenew !== null) {
                        idsrt = result.idsmsratenew;
                    } else {
                        idsrt = result.idsmsrate;
                    }
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `sms_rate` SET `MO_rates`=" + setToZero(result.MO) + ", `MT_rates` = " + setToZero(result.MT) + " WHERE `idsmsrate` = " + idsrt + "";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateShortCodeRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });

                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `short_code_rates` SET `outbound_message_surcharge`='" + setToZero(result.outboundSurcharge) + "', `inbound_message_surcharge`='" + setToZero(result.inboundSurcharge) + "' WHERE `idshort_code` = '" + result.idshortcode + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateVoiceRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                let rdata: any = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "update `voice_rates` SET `usa_rate`='" + rdata.uvoicerate + "', `canada_rate`='" + rdata.cvoicerate + "' where `id_voicerate` = '" + rdata.id_voicerate + "'";
                obj2.prepare();
                obj2.execute((error: any, allcamp: any) => {
                    if (allcamp) {
                        let objv = new RawView(res)
                        objv.prepare({
                            data: allcamp,
                            message: "Rates Updated successfully!"
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: error,
                            message: "Something went wrong!"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }



    // Unregistered Rates 

    addvoiceRates(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `mo`, `mt`, `category`) VALUES ";
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "(" + sessdata.idaccount + ", " + setToZero(result.idtariff) + ", '" + result.priority + "', '" + result.type + "', '" + result.subtype + "', " + setToZero(result.price) + ", " + setToZero(result.mo) + "," + setToZero(result.mt) + ", '" + result.category + "' ),";
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    // addiVoiceApiRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // addDepthVoiceRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // addNumberRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // onSipRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.mo + "', '"+result.mt+"','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // sipNumberPrice(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate` , `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // onDepthVoiceRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"','" + result.mo + "', '" + result.mt + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    onSmsRates(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `type`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES ";
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "(" + sessdata.idaccount + ", " + setToZero(result.idtariff) + ", '" + result.priority + "' ,'" + result.category + "', '" + result.type + "' ," + setToZero(result.MO) + ", " + setToZero(result.MT) + ", '" + result.subCategory + "', '" + result.categoryValue + "'),";
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    // numberActivationRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"','"+result.priority+"', '"+result.type+"', '"+result.subtype+"','" + result.price + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    //  Get Rates For Customers
    // subCustomerRates(req: Request, res: Response, next: NextFunction) {
    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "select * from `voice_rates` where `idtariff` = '"+sessdata.idtariff+"' AND `type`='"+req.query.type+"' AND `subtype`='"+req.query.subtype+"' ORDER BY `priority` ASC";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
    //                 objv.execute();
    //              });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // Get Single Unregistered rates
    voiceApiRates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idrates,idtariff,type,subtype,rate,mo,mt,mocfpc,mocfpm,state,city,category,description,priority,rateType, billing_type , billing_frequency,proration, `final_rate` from `voice_rates` WHERE `idtariff` = " + req.query.idtariff + " AND `type`='" + req.query.type + "' AND `subtype`='" + req.query.subtype + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    // Update Unregistered rates
    unregisteredRates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let idrats: any = [];
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let prc = (result.price == null || result.price == undefined || result.price == '') ? 0 : result.price;
                    let updatedPrice = prc;
                    switch (result.billingfrequency) {
                        case '0':
                            updatedPrice = prc * 1;
                            break;
                        case '1':
                            updatedPrice = prc * 3;
                            break;
                        case '2':
                            updatedPrice = prc * 6;
                            break;
                        case '3':
                            updatedPrice = prc * 12;
                            break;
                        default:
                            break;
                    }
                    updatedPrice = parseFloat(updatedPrice ?? 0).toFixed(3);
                    let idrt: any;
                    if (result.idratesnew !== null) {
                        idrt = result.idratesnew;
                    } else {
                        idrt = result.idrates;
                    }
                    if (result.idrates !== null) {
                        idrats.push(result.idrates);
                    }
                    let pr = result.proration && result.proration !== undefined ? result.proration : false;
                    if (result.idrates == null && result.idrates == undefined && result.idrates == '') {
                        console.log("Record Inserted");
                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `idtariff` FROM `voice_rates` WHERE `idrates` IN (" + idrats + ")";
                        obj0.prepare();
                        obj0.execute((error: any, data: any) => {
                            if (error == 1) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT into voice_rates (`idaccount`,`idtariff`, `priority`, `type`, `subtype`,`rate`, `mo`, `mt`,`mocfpc`,`mocfpm`,`billing_frequency`,`category`,`proration`,`final_rate`) VALUES (" + sessdata.idaccount + ", " + setToZero(data[0].idtariff) + ", '" + 5 + "', 'message', 'message_activation'," + setToZero(result.price) + "," + setToZero(result.mo) + "," + setToZero(result.mt) + "," + setToZero(result.mocfpc) + "," + setToZero(result.mocfpm) + ",'" + setToZero(result.billingfrequency) + "','" + result.category + "','" + pr + "','" + setToZero(updatedPrice) + "')";
                                obj1.prepare();
                                obj1.execute((_error: any, res: any) => {
                                    console.log("Rates Updated Successfully!");
                                })
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                                objv.execute();
                            }
                        })

                    }
                    else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `voice_rates` SET `rate`=" + setToZero(result.price) + ", `mo` = " + setToZero(result.mo) + ", `mt` = " + setToZero(result.mt) + ", `mocfpc` = " + setToZero(result.mocfpc) + ", `mocfpm` = " + setToZero(result.mocfpm) + ", `billing_frequency` = " + setToZero(result.billingfrequency) + ", `proration`='" + pr + "', `final_rate` = '" + setToZero(updatedPrice) + "' WHERE `idrates` = " + setToZero(idrt) + "";
                        obj2.prepare();
                        obj2.execute((__error: any, allcamp: any) => { });

                    }
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!", status: 201 })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    // SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id

    getSurcharge(req: Request, res: Response, next: NextFunction) {
        console.log(req.query);
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id";  
                obj.qrysql = `SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(data), '}') data FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction,CONCAT('"',sr.type, '_',sr.subtype,'_', sr.direction, '":',sr.rates) data FROM surcharge_rates sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction, sr.rates) tbl GROUP BY tbl.id`
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }

    public updatelookupRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let indexID = 0;
                rdata.forEach((element: any) => {
                    indexID++;
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let idsrt = result.idrates;
                    if (idsrt == null || idsrt == undefined) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT into `lookup_api_rates` (`idaccount`,`idtariff`, `type`, `rate`,`category`,`priority`) VALUES (" + sessdata.idaccount + ", " + setToZero(result.idtariff) + ",'" + result.type + "'," + setToZero(result.price) + ",'" + result.categoryValue + "'," + setToZero(indexID) + ")";
                        obj1.prepare();
                        obj1.execute((error: any, allcamp: any) => {
                        })
                    } else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `lookup_api_rates` SET `rate`=" + setToZero(result.price) + " WHERE `idrates` = " + idsrt + "";
                        obj2.prepare();
                        obj2.execute((error: any, allcamp: any) => {
                        })
                    }
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Lookup Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    public updateCampaignReviewRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let indexID = 0;
                rdata.forEach((element: any) => {
                    indexID++;
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let idsrt = result.idrates;

                    if (idsrt == null || idsrt == undefined) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT into `campaign_rates` (`idaccount`,`idtariff`, `type`, `rate`,`category`,`priority`,`mrc`) VALUES (" + sessdata.idaccount + ", " + setToZero(result.idtariff) + ",'" + result.type + "'," + setToZero(result.price) + ",'" + result.category + "','" + setToZero(result.priority) + "','" + setToZero(result.mrc) + "')";
                        obj1.prepare();
                        obj1.execute((error: any, Inscamp: any) => {
                            console.log("Campaign Review & Redundant Campaign Rates Updated Successfully");
                        })
                    }
                    else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `campaign_rates` SET `rate`=" + setToZero(result.price) + ",`mrc`=" + setToZero(result.mrc) + " WHERE `campaign_rate_id` = " + idsrt + "";
                        obj2.prepare();
                        obj2.execute((error: any, upcamp: any) => {
                            console.log("Campaign Review & Redundant Campaign Rates Updated Successfully");
                        })
                    }

                });
                let objv = new RawView(res);
                objv.prepare({ message: "A2P Charges Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }


    lookupRates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select idrates,idtariff,type,rate,category,description,priority from `lookup_api_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Lookup Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    CampaignReviewRates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select campaign_rate_id,idtariff,type,rate,category,priority,mrc from `campaign_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Campaign Review & Redundant Campaign Rates Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /*Edit Activate Msg Pricing*/
    public updateActivatemessage(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let indexID = 0;
                rdata.forEach((element: any) => {
                    indexID++;
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let idsrt = result.idrates;
                    if (idsrt == null || idsrt == undefined) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT into `message_activation_pricing` (`idaccount`,`iduser`,`idtariff`,`type`,`mrc`,`nrc`,`category`,`priority`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ", " + setToZero(result.idtariff) + ",'" + result.type + "'," + setToZero(result.mrc) + "," + setToZero(result.nrc) + ",'" + result.category + "'," + setToZero(indexID) + ")";
                        obj1.prepare();
                        obj1.execute((error: any, allcamp: any) => {

                        })
                    } else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `message_activation_pricing` SET `mrc`=" + setToZero(result.mrc) + ",`nrc`=" + setToZero(result.nrc) + "  WHERE `idrates` = " + idsrt + "";
                        obj2.prepare();
                        obj2.execute((error: any, allcamp: any) => {
                            console.log("Activation Message Pricing Updated Successfully!");
                        })
                    }

                });
                let objv = new RawView(res);
                objv.prepare({ message: "Activate Message Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    /*Get Activate Msg Pricing*/
    get_activatemsg(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select idrates,idtariff,type,mrc,nrc,category,priority from `message_activation_pricing` where `idtariff` = " + req.query.idtariff + " AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Activate Message Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getPlanRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next)
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `idtariff`,`name`,`description`,`rate` ,`tariff_link` ,`is_default` FROM tariff";
                // obj1.qrysql = "SELECT `idtariff`,`rate` FROM tariff";
                obj1.prepare();
                obj1.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "Tariff rate fetched successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong while fetching tarriff rate!" });
                        objv.execute();
                    }
                })

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    getUrlTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next)
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let link_id = req.query.type;
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT su.idlinktariff, su.link_id, su.idtariff, su.order_by, t.name FROM `signup_referral_link_tariff` su JOIN `tariff` t ON su.idtariff = t.idtariff WHERE su.link_id='" + link_id + "'";
                    obj2.prepare();
                    obj2.execute((err: any, result1: any) => {
                        if (err == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, data: result1, message: "Tariff rate fetched successfully!" });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 501, message: "Something went wrong while fetching get tariff url!" });
                            objv.execute();
                        }
                    })                            
                } 
                else {
                    let objvs = new RawView(res);
                    objvs.prepare({ status: 401, message: "Unauthorize Access!" });
                    objvs.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

}
