import { SMS } from "./APISMSBase";
import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { InteliquentAPI } from "./Inteliquent";
import { InfobipAPI } from "./InfobipAPI";
import { Twillio } from "./twillio";

export class TwilioSMS extends SMS {
    constructor() {
        super();
    }

    public SendSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {        
        this.saveSMS(req, res, next, Data.sessdata, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }

    public SendMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        this.saveMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }   

    // Not in Use. it may be changed as per requirement
    public SendTFSms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let twilio = new Twillio(sessdata);
        twilio.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }

    public SendTFMms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }
   
    public SendSynivMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }

    public SendSCSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let info = new InfobipAPI("", Data.sessdata, "");
        info.saveSCSMS(req, res, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }

    public SendSCMms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let info = new InfobipAPI("", Data.sessdata, "");
        info.saveSCMMS(req, res, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }
}