'use strict';
import { Request, Response, NextFunction } from "express";
import { modEmailVerify, Module } from "../config/module.config";
import { ModelLogin } from "./model/ModelLogin";
import { SessionManagment } from "./model/Session";
import { RawView } from "./view/RawView";
import { Res403 } from "./view/403";
import { ModelRawNonQuery } from "./model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { sessiondata } from "../server";


export class SignUPLogin {
    protected sessdata: any;

    constructor() { }

    public SignUPLogin(req: Request, res: Response, next: NextFunction) {
        let validationKey = req.body.key;
        let isEmailVerify = req.body.isEmailVerify;
        req.body={validationKey: validationKey, isEmailVerify: isEmailVerify, isMobileVerfy: false};
        let obj3 = new ModelRawNonQuery(req, res);
        obj3.nonqrysql = "UPDATE `user` SET `isEmailVerify`='"+isEmailVerify+"' WHERE `validationKey`='"+validationKey+"' AND `email_verification_date` > DATE_ADD(NOW(), INTERVAL -1 DAY) AND `is_deleted`=0";
        obj3.prepare();
        obj3.execute((_err: any, __result: any) => {
            if(_err == 1){
                if(__result.affectedRows > 0){
                    let obj = new ModelLogin(req, res);
                    let modEmail= new modEmailVerify()
                    if (obj.prepare(modEmail)) {
                        obj.execute((error: any, result: any) => {
                            if (error == 2) {
                                let obj5 = new ModelRawQuery(req, res);
                                obj5.qrysql = "SELECT iduser FROM `user` WHERE `validationKey`='"+validationKey+"' AND is_deleted=0";
                                obj5.prepare();
                                obj5.execute((__error: any, user: any) => {
                                    if(__error == 1){
                                        if(user.length > 0){
                                            let objup = new ModelRawQuery(req, res);
                                            objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='"+user[0].iduser+"'";
                                            objup.prepare();
                                            objup.execute((__errorE: any, emailE: any) => {
                                                sessiondata.set(user[0].iduser, result);
                                                let session = new SessionManagment(req, res, next);
                                                session.SetSession(result, (error, sessdata) => {
                                                    let obj4 = new ModelRawNonQuery(req, res);
                                                    obj4.nonqrysql = "UPDATE `session` SET `isEmailVerify`='"+isEmailVerify+"', `sessionType`='PANEL' WHERE `iduser`='"+user[0].iduser+"'";
                                                    obj4.prepare();
                                                    obj4.execute((__err: any, __result: any) => {
                                                        if(__err == 1){
                                                            console.log("Session Updated.");
                                                        }
                                                        else{
                                                            console.log("Session Not Updated.");
                                                        }
                                                    });
                                                    let tmp: string = "{\"email\": \""+emailE[0].email+"\"}";
                                                    let emType = JSON.parse(tmp);
                                                    let Result1: any = Object.assign(result,emType);
                                                    
                                                    let objv = new RawView(res);
                                                    objv.prepare({session: result.authkey, type:"email", data:Result1, status: 201});
                                                    objv.execute();
                                                });
                                            });
                                        }
                                        else{
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "You are trying to access deleted account!", status: 401});
                                            objv.execute();
                                        }
                                    }
                                    else{
                                        let objv = new Res403(res);
                                        objv.prepare({ message: "Database Connection Break", status: 401});
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new Res403(res);
                                objv.prepare({ message: "Invalid User to set proper session!", status: 401});
                                objv.execute();
                            }
                        });
                    }
                    else{
                        let objv = new Res403(res);
                        objv.prepare({ message: "Opps Something went wrong with Connection!", status: 502 });
                        objv.execute();
                    }
                }
                else{
                    let objv = new RawView(res);
                    objv.prepare({ message: "Key has expired/Invalid Account!", status: 401});
                    objv.execute();
                }
            }
        });
    }
}
