import { ModelObject } from "./ModelObject";
import { modLogin,Login } from "../../config/module.config";
import { Res403 } from "../view/403";
import md5 from "md5";

export class ModelLogin extends ModelObject
{
	public prepare(config?:any):boolean
	{
		var ret=true;
		if(config==undefined)
			config=new modLogin();
		
		let paramdata; 
		if(this.req.body.data == undefined){
			
			try{
				paramdata=this.req.body;
			} catch(error)
			{
				paramdata=this.req.body;
			}
		}else{
			try{
				paramdata=JSON.parse(this.req.body.data);
			} catch(error)
			{
				paramdata=this.req.body.data;
			}
		}
		
		this.table=config.data.table;
		this.query.field=config.data.selectfield;

		let uname="", passwd="";
	
        if(paramdata.hasOwnProperty(config.data.postfield[0].field))
        {
            uname=paramdata[config.data.postfield[0].field];
        }
        else
        {
			let objv= new Res403(this.res);
			objv.prepare({error:"Invalid Username/Password, Kindly check again."});
			objv.execute();
            return false;
        }

		if(paramdata.hasOwnProperty(config.data.postfield[1].field))
        {
			if(config.data.md5)
				passwd=md5(paramdata[config.data.postfield[1].field]);	
			else
				passwd=paramdata[config.data.postfield[1].field];
        }
        else
        {
			let objv= new Res403(this.res);
			objv.prepare({error:"Invalid Username/Password, Kindly check again."});
			objv.execute();
            return false;
        }
		this.query.isfilter=true;
		let dbfield=config.data.tablefield;
		let filter:any={};
		if(config.data.filter==undefined)
			filter="{\""+dbfield[0]+"\":\""+uname+"\", \""+dbfield[1]+"\":\""+passwd+"\"}";
		else
		{
			filter=config.data.filter;
			filter[dbfield[0]]=uname;
			filter[dbfield[1]]=passwd;
		}
		try{
			this.query.filter=JSON.parse(filter);
		} catch(e){
			this.query.filter=filter;
		}
		this.query.isfilter=true;
		return ret;
	}

	public execute(callback:(error: any, data:any)=>void)
	{		
		this.query.prepare();		
		this.query.Row((err: any, data:any)=>{
			if(err>1)
				err=8;
			if(err==1)
				err=2;

			this.respond(err, data, callback);
		});
	}
}
