import { Request, Response, NextFunction } from "express";
import { ModelObject } from "./ModelObject";

export class ModelProcedure extends ModelObject
{
	constructor(req:Request, res:Response)
	{
		super(req,res);
		this.type="PROCEDURE";		
	}

	public prepare(fields:string[]):boolean
	{
		var ret = true;
		console.log(this.req.query);
		console.log(this.req.body);

		if(this.name.length < 1 || this.name==null)
		{
			console.log("Procedure is not defined properly.");
			return false;
		}
		let tmpdata:any={}, tmp:any={};

		if(this.req.body.hasOwnProperty('data'))
		{
			try{
				tmpdata=JSON.parse(this.req.body.data);
			}
			catch(e)
			{
				tmpdata=this.req.body.data;
			}
		}
		else
		{
			console.log("Data is not found into the request");
			return false;
		}

		fields.forEach((element) => {
			if(tmpdata.hasOwnProperty(element))
			{
				tmp[element]=tmpdata[element];
			}
		});
		this.nonquery.data=tmp;
		
		return ret;
	}

	public execute(callback:(error: any, data:any)=>void)
	{
		
		this.log.Debug("Calling uPDATE function in ModelObject.");
		this.nonquery.prepare();
		this.nonquery.Execute((err: any, data:any)=>{			
			this.respond(err, data, callback);
		});
	}
}