/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the SourceIpMappingList
 *
 * @param version - Version of the resource
 */
declare function SourceIpMappingList(version: V1): SourceIpMappingListInstance;

/**
 * Options to pass to update
 *
 * @property sipDomainSid - The unique string that identifies a SIP Domain
 */
interface SourceIpMappingInstanceUpdateOptions {
  sipDomainSid: string;
}

interface SourceIpMappingListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SourceIpMappingContext;
  /**
   * create a SourceIpMappingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: SourceIpMappingListInstanceCreateOptions, callback?: (error: Error | null, item: SourceIpMappingInstance) => any): Promise<SourceIpMappingInstance>;
  /**
   * Streams SourceIpMappingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: SourceIpMappingInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams SourceIpMappingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SourceIpMappingListInstanceEachOptions, callback?: (item: SourceIpMappingInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a source_ip_mapping
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): SourceIpMappingContext;
  /**
   * Retrieve a single target page of SourceIpMappingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: SourceIpMappingPage) => any): Promise<SourceIpMappingPage>;
  /**
   * Retrieve a single target page of SourceIpMappingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SourceIpMappingPage) => any): Promise<SourceIpMappingPage>;
  /**
   * Lists SourceIpMappingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: SourceIpMappingInstance[]) => any): Promise<SourceIpMappingInstance[]>;
  /**
   * Lists SourceIpMappingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SourceIpMappingListInstanceOptions, callback?: (error: Error | null, items: SourceIpMappingInstance[]) => any): Promise<SourceIpMappingInstance[]>;
  /**
   * Retrieve a single page of SourceIpMappingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: SourceIpMappingPage) => any): Promise<SourceIpMappingPage>;
  /**
   * Retrieve a single page of SourceIpMappingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SourceIpMappingListInstancePageOptions, callback?: (error: Error | null, items: SourceIpMappingPage) => any): Promise<SourceIpMappingPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property ipRecordSid - The unique string that identifies an IP Record
 * @property sipDomainSid - The unique string that identifies a SIP Domain
 */
interface SourceIpMappingListInstanceCreateOptions {
  ipRecordSid: string;
  sipDomainSid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface SourceIpMappingListInstanceEachOptions {
  callback?: (item: SourceIpMappingInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface SourceIpMappingListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface SourceIpMappingListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface SourceIpMappingPayload extends SourceIpMappingResource, Page.TwilioResponsePayload {
}

interface SourceIpMappingResource {
  date_created: Date;
  date_updated: Date;
  ip_record_sid: string;
  sid: string;
  sip_domain_sid: string;
  url: string;
}

interface SourceIpMappingSolution {
}


declare class SourceIpMappingContext {
  /**
   * Initialize the SourceIpMappingContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a SourceIpMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SourceIpMappingInstance) => any): Promise<SourceIpMappingInstance>;
  /**
   * remove a SourceIpMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SourceIpMappingInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SourceIpMappingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: SourceIpMappingInstanceUpdateOptions, callback?: (error: Error | null, items: SourceIpMappingInstance) => any): Promise<SourceIpMappingInstance>;
}


declare class SourceIpMappingInstance extends SerializableClass {
  /**
   * Initialize the SourceIpMappingContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: SourceIpMappingPayload, sid: string);

  private _proxy: SourceIpMappingContext;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a SourceIpMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SourceIpMappingInstance) => any): Promise<SourceIpMappingInstance>;
  ipRecordSid: string;
  /**
   * remove a SourceIpMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SourceIpMappingInstance) => any): Promise<boolean>;
  sid: string;
  sipDomainSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SourceIpMappingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: SourceIpMappingInstanceUpdateOptions, callback?: (error: Error | null, items: SourceIpMappingInstance) => any): Promise<SourceIpMappingInstance>;
  url: string;
}


declare class SourceIpMappingPage extends Page<V1, SourceIpMappingPayload, SourceIpMappingResource, SourceIpMappingInstance> {
  /**
   * Initialize the SourceIpMappingPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SourceIpMappingSolution);

  /**
   * Build an instance of SourceIpMappingInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SourceIpMappingPayload): SourceIpMappingInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SourceIpMappingContext, SourceIpMappingInstance, SourceIpMappingInstanceUpdateOptions, SourceIpMappingList, SourceIpMappingListInstance, SourceIpMappingListInstanceCreateOptions, SourceIpMappingListInstanceEachOptions, SourceIpMappingListInstanceOptions, SourceIpMappingListInstancePageOptions, SourceIpMappingPage, SourceIpMappingPayload, SourceIpMappingResource, SourceIpMappingSolution }
