import https from "https";
import http from "http";
import express, { request } from 'express';
import bodyParser from 'body-parser';
import path from "path";
import fs from 'fs';
import HashMap from 'hashmap';
import cookieParser from "cookie-parser";
import { Request, Response, NextFunction } from "express";
import { SessionManagment, CurrentSession } from './lib/model/Session';
var cron = require("node-cron");
var net = require('net');
const CRLF = "\r\n";
const END = "\r\n\r\n";
var client = new net.Socket();
import { VoiceServer, Setting, YMLDirectory } from './config/setting.config';
import { Res406 } from "./lib/view/406";
import { modData } from "./config/module.config";
import swaggerUi from 'swagger-ui-express';
import YMLJS from 'yamljs';
import { VoiceRates } from "./include/common.lib";
import { Logger } from "./lib/logger";
//import * as swaggerJsonDocument from './swagger.json'

const vs_server = new VoiceServer();
const setting = new Setting();
const yml = new YMLDirectory()
export const sessiondata = new HashMap<any, any>();
export const invalidsessdata = new HashMap<any, any>();
export const setservicedata = new HashMap();
export const DIDSearchHMData = new HashMap<any, any>();
export const cursess = new CurrentSession();
export const voicerates = new HashMap<string, VoiceRates>();
export const login_logout = new HashMap<any, any>();
export const getMod = new modData();

/** To generate the dynamic smsid for synverse */
sessiondata.set("smscID", 4)

const app = express();

// app.use(bodyParser.urlencoded({ limit: "50mb", extended: true, parameterLimit: 50000 }));
app.use(bodyParser.json({ limit: '50mb' }));
app.use(bodyParser.urlencoded({ limit: '50mb', extended: true }));
app.use(bodyParser.json());
app.use(cookieParser());
app.use(function (req: Request, res: Response, next: NextFunction) {
  res.header("Access-Control-Allow-Origin", "*");
  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Authorization");
  res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
  res.setHeader('Cache-Control', 'no-store, no-cache, must-revalidate, proxy-revalidate');
  res.setHeader('Pragma', 'no-cache');
  res.setHeader('Expires', '0');
  next();
});

app.use("/uploads", express.static(path.join(__dirname, "uploads")));

const swaggerDocument = YMLJS.load(process.cwd() + "/swagger/testing.yml");

var options = {
  customCss: `
    .topbar-wrapper img {content:url('https://portal.signalmash.com/assets/img/logo-left-white.png'); width:300px; height:auto;}
    .swagger-ui .topbar { background-color: black;}`,
  customSiteTitle: "Signalmash API Documentation",
  customfavIcon: "https://portal.signalmash.com/assets/img/icon.png"
}



app.use('/doc', swaggerUi.serve, swaggerUi.setup(swaggerDocument, options));


app.use((req, res, next) => {
  const timestamp = new Date().toISOString();
  const ipAddress = req.headers['x-forwarded-for'] || req.connection.remoteAddress;
 
  let url = req.url.split("?");
  if (url[0] == "/login" || url[0] == "/delete-user" || url[0] == "/apilogin" || url[0] == "smsdelivery" || url[0] == "/signup" || url[0] == '/forgot-mail' || url[0] == "/verify-token" || url[0] == "/update-password" || url[0] == "/emailverify" || url[0] == "/callbackmms/v1/sinch_mms" || url[0] == "/callbackdlr/v1/sinch_dlr" || url[0] == "/restore-account" || url[0] == "/voltauth" || url[0] == "/enhancedVettingReport" || url[0] == "/verify-url" || url[0] == "/setpassworduser") {
    Logger.warn(JSON.stringify({
      "warning": {
        endpoint: url[0],
        message: "Whitelisted endpoint accessed",
        ipAddress: ipAddress,
        request: {
          timestamp: timestamp,
          requestQuery: req.query,
          requestBody: req.body,
          method: req.method,
          headers: req.headers,
        },
        response: {
          timestamp: timestamp,
          status: res.statusCode,
          result: ''
        }
      }
    }));
    next();
  } else {
    if (req.method == "OPTIONS") {
      res.status(200).send();
    } else {
      let sess = new SessionManagment(req, res, next);
      sess.GetSession((error, data) => {
        if (error == 1) {
          cursess.session = data;
          cursess.error = 0;

          const originalSend = res.send;
          let logOnce = false;
          res.send = function (body) {
            if (!logOnce) {
              // Log the API data
              if (url[0] == "/user" || url[0] == "/details_cdr" || url[0] == "/SummeryCdrForm" || url[0] == "/getmdrfilter" || url[0] == "/summerysmsmdrfilter" || url[0] == "/getmmsmdrfilter" || url[0] == "/summerymmsmdrfilter") {
                Logger.info(JSON.stringify({
                  "info": {
                    endpoint: url[0],
                    "Current Session": cursess.session.authkey,
                    idaccount: cursess.session.idaccount,
                    ipAddress: ipAddress,
                    sessionType: cursess.session.sessionType,
                    request: {
                      timestamp: timestamp,
                      requestQuery: req.query,
                      requestBody: req.body
                    },
                    response: {
                      timestamp: timestamp,
                      status: res.statusCode,
                      message: "Data Fetch Successfully!"
                    }
                  }
                }));
              } else if (url[0] == "/reseller_login") {
                Logger.info(JSON.stringify({
                  "info": {
                    endpoint: url[0],
                    "Current Session": cursess.session.authkey,
                    idaccount: cursess.session.idaccount,
                    ipAddress: ipAddress,
                    request: {
                      timestamp: timestamp,
                      requestQuery: req.query,
                      requestBody: req.body
                    },
                    response: {
                      timestamp: timestamp,
                      status: res.statusCode,
                      result: body
                    }
                  }
                }));
              } else {
                // Log for undefined requests
                if (res.statusCode === 404) {
                  Logger.warn(JSON.stringify({
                    "warning": {
                      endpoint: url[0],
                      message: "Undefined request",
                      idaccount: cursess.session.idaccount,
                      ipAddress: ipAddress,
                      requestDetails: {
                        timestamp: timestamp,
                        requestQuery: req.query,
                        requestBody: req.body
                      }
                    }
                  }));
                } else {
                  // Log other API requests
                  Logger.info(JSON.stringify({
                    "info": {
                      endpoint: url[0],
                      "Current Session": cursess.session.authkey,
                      idaccount: cursess.session.idaccount,
                      ipAddress: ipAddress,
                      sessionType: cursess.session.sessionType,
                      request: {
                        timestamp: timestamp,
                        requestQuery: req.query,
                        requestBody: req.body
                      },
                      response: {
                        timestamp: timestamp,
                        status: res.statusCode,
                        result: body
                      }
                    }
                  }));
                }
              }
              logOnce = true;
            }
            return originalSend.call(this, body);
          };

        } else {          
          Logger.warn(JSON.stringify({
            "warning": {
              message: "Unauthorized access",
              endpoint: url[0],
              ipAddress: ipAddress,
              requestDetails: {
                timestamp: timestamp,
                method: req.method,
                url: req.originalUrl,
                headers: req.headers,
                body: req.body,
              }
            }
          }));
          if (res.headersSent) return;
          let objv = new Res406(res);
          objv.prepare({ message: "Error in session" });
          objv.execute();
          return;
        }
        next();
      });
    }
  }
});


//app.use(session({secret:"gventureworksforyou", resave: false, saveUninitialized: false}));

var routes = require('./routes/routes.class'); //importing route


/*if(vs_server.TYPE.toLowerCase()=="freeswitch")
{
  client.connect(vs_server.PORT, vs_server.HOST, function () {
    console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
    client.write('auth '+vs_server.PASS+'\n\n');
    console.log("Password : "+vs_server.PASS);
  });
}

if(vs_server.TYPE.toLowerCase()=="asterisk"){
  client.connect(vs_server.PORT, vs_server.HOST, function () {
    console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
    var obj = { Action: 'Login', Username: vs_server.USER, Secret: vs_server.PASS, ActionID:1};
    var str = '';
    Object.entries(obj).forEach(([key, value]) => {
        str += (key + ": " + value + CRLF);
    });
    str+=CRLF;
    client.write(str, 'ascii');
  });
}*/

//HTTPS server
if (setting.HTTPS) {
  const options = {
    key: fs.readFileSync(setting.KEY),
    cert: fs.readFileSync(setting.CERT),
  };
  let serversocket = new https.Server(options);

  serversocket = https.createServer(options, app);

  if (vs_server.TYPE != "none") {
    const io = require("socket.io").listen(serversocket);
    //var iosocket = new SocketIO(io, client);
  }

  // Websocket start
  app.set("socketport", process.env.SOCKETPORT || setting.SOCKETPORT);
  routes(app);

  app.post("/send-notification", (req, res) => {
    const notify = { data: req.body };

    socket.emit("notificationCount", notify);
    res.send(notify);
  });
  const socketIO = https.createServer(options, app);
  const serverIO = socketIO.listen(app.get("socketport"), () => {
    console.log(
      `Server connection on  http://127.0.0.1:${app.get("socketport")}`
    );
  });
  const socket = require("socket.io")(serverIO, options);
  socket.on("connection", (socket: any) => {
    console.log("Socket Connected");
  });

  // Websocket end

  app.set("port", process.env.PORT || setting.PORT);
  routes(app); //register the route
  const server = serversocket.listen(app.get("port"), setting.DOMAIN, () => {
    console.log("App is running at https://%s:%d in %s mode", setting.DOMAIN, app.get("port"), app.get("env"));
    console.log("  Press CTRL-C to stop\n");
  });
}
//HTTP server generation setting with complete socket
else {
  let serversocket = new http.Server();
  serversocket = http.createServer(app);
  if (vs_server.TYPE != "none") {
    const io = require("socket.io").listen(serversocket);
    //var iosocket = new SocketIO(io, client);
  }
  //Websocket Start
  app.set("socketport", process.env.SOCKETPORT || setting.SOCKETPORT);
  routes(app);
  app.post("/send-notification", (req, res) => {
    const notify = { data: req.body };

    socket.emit("notificationCount", notify);
    res.send(notify);
  });
  const socketIO = http.createServer(app);
  const serverIO = socketIO.listen(app.get("socketport"), () => {
    console.log(
      `Server connection on  http://127.0.0.1:${app.get("socketport")}`
    );
  });
  const socket = require("socket.io")(serverIO);
  socket.on("connection", (socket: any) => {
    console.log("Socket Connected");
  });

  // Websocket end

  app.set("port", process.env.PORT || setting.PORT);
  routes(app); //register the route

  const server = serversocket.listen(app.get("port"), setting.DOMAIN, () => {
    console.log("App is running at http://%s:%d in %s mode", setting.DOMAIN, app.get("port"), app.get("env"));
    console.log("Press CTRL-C to stop\n");
  });
}