const express = require('express');
const mysql = require('mysql2/promise');
const app = express();

app.use(express.json()); // parse JSON body

const dbPool = mysql.createPool({
  host: 'localhost',
  user: 'dbuser',
  password: 'dbpass',
  database: 'dbname',
  waitForConnections: true,
  connectionLimit: 20
});

app.post('/scInfobipSmsDLR', async (req, res) => {
  try {
    const data = req.body;

    if (!data.results || !Array.isArray(data.results)) {
      return res.status(400).json({ error: 'Invalid payload' });
    }

    for (const dVal of data.results) {
      let status = 2, isBillable = 0;
      switch (dVal.status.groupName) {
        case "DELIVERED":
        case "ACCEPTED":
          status = 1;
          isBillable = 1;
          break;
        case "UNDELIVERABLE":
        case "EXPIRED":
        case "REJECTED":
          isBillable = 1;
          status = 2;
          break;
      }

      const query = `
        INSERT INTO sms_dlr 
        (dca, tracking_id, \`to\`, type, status, status_num, status_details, sms_count)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
      `;

      await dbPool.query(query, [
        'infobip',
        dVal.messageId,
        dVal.to,
        'SC',
        dVal.status.groupName,
        status,
        dVal.status.name,
        dVal.smsCount
      ]);
    }

    res.status(200).json({ success: true });

  } catch (err) {
    console.error('Error:', err);
    res.status(500).json({ error: 'Internal server error' });
  }
});

app.listen(3000, () => {
  console.log('Webhook listening on port 3000');
});
