const express = require("express");
var mysql = require('mysql');
const bodyparser = require("body-parser");
var app = express();
const HashMap = require("hashmap");
const allDID = new HashMap();
const allWalletBalance = new HashMap();
const allservice = new HashMap();
app.use(bodyparser.json());

// Production
/* var connection = mysql.createPool({
    host: "10.128.0.2",
    user: "signalmash",
    password: "lAq3@HbzYllQFsuC",
    database: "signalmash",
    port: 3306
}); 
const key = "xdfuetydbhdynfihdvhwiljdsb"; */


// Staging
var connection = mysql.createPool({
    host: "103.65.192.7",
    user: "signalmash_db",
    password: "Yn95ph4$#%A1AC0B",
    database: "signalmash_prod2",
    port: 3306
});
const key = "xdfuetydbhdynfihdvhwiljdsb";


// To Load DIDs in HashMap
function loadDIDs() {
    getAllDIDs(function (err, resDID) {
        if (err == 1 && resDID.length > 0) {
            for (let i = 0; i < resDID.length; i++) {
                allDID.set(resDID[i].did.trim(), resDID[i]);
            }
            // console.log("DID HashMap Set :: ", allDID);
            console.log("DID HashMap Set");
        }
        else
            console.info("No Record Available in did_buy ");
    });
}

// To Get DIDs
function getAllDIDs(callback) {
    let qry = "SELECT TRIM(db.`did`) `did`, db.`type`, db.iduser, db.account_id, i.forward_type, i.forward, i.connection_key, i.idaccount, ib.dnis,ib.ani, u.`is_deleted` FROM did_buy db LEFT JOIN `endpoint` i ON i.connection_key=db.connection_key LEFT JOIN inbound ib ON ib.idendpoint=i.idendpoint LEFT JOIN `user` u ON u.iduser=db.iduser WHERE  db.disconnect_did_status='1' GROUP BY db.did";
    console.log("DID Query Load:: ", qry);
    connection.query(qry, function (err, rows) {
        if (err) return callback(0, []);
        callback(1, rows);
    });
};

// To Load Wallet Data in HashMap
function loadBalance() {
    getWalletBalance(function (err, resBAl) {
        if (err == 1 && resBAl.length > 0) {
            for (let i = 0; i < resBAl.length; i++) {
                allWalletBalance.set(resBAl[i].idaccount, resBAl[i]);
            }
            //console.log("Wallet HashMap Set :: ", allWalletBalance);
            console.log("Wallet HashMap Set");
        }
        else
            console.info("No Record Available in wallet ");
    });
}

// To Get Balance
function getWalletBalance(callback) {
    let qry = "SELECT w.idaccount, IF(w.`balance`+w.`credit_limit`>0,1,0) isbalance, w.balance,(w.`balance`+w.`credit_limit`) `totalBalance`, u.`is_deleted` FROM wallet w LEFT JOIN `user` u ON u.idaccount=w.idaccount";
    console.log("DID Query Load:: ", qry);
    connection.query(qry, function (err, rows) {
        if (err) return callback(0, []);
        callback(1, rows);
    });
};

// To Load service in HashMap
function loadService() {
    getServiceActivate(function (err, resSer) {
        if (err == 1 && resSer.length > 0) {
            allservice.clear();
            for (let i = 0; i < resSer.length; i++) {
                if (!allservice.has(resSer[i].idaccount)) {
                    allservice.set(resSer[i].idaccount, new Map());
                }
                allservice.get(resSer[i].idaccount).set(resSer[i].fs_id, resSer[i]);
            }
            console.log("Service HashMap Set");
        } else {
            console.info("No Record Available in account_service");
        }
    });
}

// To Get Service
function getServiceActivate(callback) {
    let qry = "SELECT fs_id, idaccount FROM `account_service` WHERE `as_status`='1'";
    console.log("Service Query Load:: ", qry);
    connection.query(qry, function (err, rows) {
        if (err) return callback(0, []);
        callback(1, rows);
    });
}

// Route  : To Get DID Detail By DID
app.get('/getdid/:did', (req, res) => {
    let token = req.headers.authorization || req.headers.token
    if (token !== key) {
        res.send({
            "message": "Invalid Session you are trying to access",
            "error": "Invalid session is called to access!"
        });
        return false;
    }
    const did = req.params.did;
    console.log("Requested DID :: ", did);

    let message = "";
    if (!did)
        message = "Invalid DID";

    if (!message) {
        let data = allDID.get(parseInt(did));
        if (data) {
            res.send(data);
        }
        else {
            loadDIDs();
            let qry = "SELECT TRIM(db.`did`) `did`, db.`type`, db.`iduser`,db.`account_id`, i.`forward_type`, i.`forward`, i.connection_key, i.idaccount, ib.`dnis`,ib.ani, u.`is_deleted` FROM `did_buy` db LEFT JOIN `endpoint` i ON i.`connection_key`=db.`connection_key` LEFT JOIN `inbound` ib ON ib.`idendpoint`=i.`idendpoint` LEFT JOIN `user` u ON u.`iduser`=db.`iduser` WHERE  db.`disconnect_did_status`='1' AND db.`did`='" + did.trim() + "' GROUP BY db.did LIMIT 1";
            console.log("Query DID Get:: ", qry);
            connection.query(qry, function (err, rows) {
                if (!err && rows.length > 0)
                    res.send(rows);
                else
                    res.send({ status: 404, message: "DID Data Does Not Exist!" });
            });
        }
    }
    else {
        res.send({ status: 401, message: message });
    }
});

// Route  : To Get Wallet Detail By Idaccount
app.get('/getbalance/:idaccount', (req, res) => {
    let token = req.headers.authorization || req.headers.token
    if (token !== key) {

        res.send({
            "message": "Invalid Session you are trying to access",
            "error": "Invalid session is called to access!"
        });
        return false;
    }
    const idaccount = req.params.idaccount;
    console.log("Requested Idaccount :: ", idaccount);

    let message = "";
    if (!idaccount)
        message = "Invalid Idaccount";

    if (!message) {
        let data = allWalletBalance.get(parseInt(idaccount));

        if (Object.keys(data).length > 0) {

            res.send({ status: 200, data: data });
        }

        else {
            loadBalance();
            let qry = "SELECT w.idaccount, IF(w.`balance`+w.`credit_limit`>0,1,0) isbalance, w.balance,(w.`balance`+w.`credit_limit`) `totalBalance`, u.`is_deleted` FROM wallet w LEFT JOIN `user` u ON u.idaccount=w.idaccount WHERE w.idaccount='" + idaccount + "' LIMIT 1";
            console.log("Query Wallet Get:: ", qry);
            connection.query(qry, function (err, rows) {
                if (!err && Object.keys(rows).length > 0) {
                    res.send({ status: 200, data: rows });
                } else
                    res.send({ status: 404, message: "Wallet Data Does Not Exist!" });
            });
        }
    }
    else {
        res.send({ status: 401, message: message });
    }
});


// Route  : To Get Service Detail By Idaccount & fservice_id
app.get('/getService/:idaccount/:fservice_id', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        res.send({
            "message": "Invalid Session you are trying to access",
            "error": "Invalid session is called to access!"
        });
        return false;
    }
    const idaccount = req.params.idaccount;
    const fsid = req.params.fservice_id;
    console.log("Requested Idaccount :: ", idaccount);
    console.log("Requested fservice_id :: ", fsid);

    let message = "";
    if (!fsid || !idaccount) {
        message = "Invalid Fs_ID OR IDAccount";
    }

    if (!message) {
        let data = allservice.get(parseInt(idaccount))?.get(parseInt(fsid));
        console.log("Retrieved Data :: ", data);

        if (data) {
            res.send({ status: 200, data: data, message: "::SN:: service is activated" });
        } else {
            loadService();
            let qry = "SELECT fs_id FROM `account_service` WHERE idaccount='" + idaccount + "' AND fs_id='" + fsid + "' AND `as_status`='1'  LIMIT 1";
            console.log("Query Service Get:: ", qry);
            connection.query(qry, function (err, rows) {
                if (!err && rows.length > 0) {
                    res.send({ status: 200, data: rows[0], message: "::SN:: service is activated" });
                } else {
                    res.send({ status: 404, message: "Service Data Does Not Exist!" });
                }
            });
        }
    } else {
        res.send({ status: 401, message: message });
    }
});

setInterval(() => loadDIDs(), 5 * 60 * 1000);
setInterval(() => loadBalance(), 60 * 1000);
setInterval(() => loadService(), 60 * 1000);

app.listen(3001, () => {
    loadDIDs();
    loadBalance();
    loadService();
    console.log("Server is Connected at Port :: 3001");
});