import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { parseBody } from "./markError";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { AvalaraTax, CSPApiConfig, AppealEvidence, SMTPDetails } from "../config/setting.config";
const request = require("request");
import { sessiondata } from '../server';
import { StripeApi } from "./stripeApi";
const Str = require('@supercharge/strings');
var nodemailer = require("nodemailer");
const jwt = require('jsonwebtoken');
const appealEvidence = new AppealEvidence();
const cspSetting = new CSPApiConfig();
const authKey = cspSetting.AUTHKEY;
const apiUrl = cspSetting.APIURL;
const avalaraTax = new AvalaraTax();
const urlLogin = avalaraTax.URLLOGIN;
const apiusername = avalaraTax.APIUSERNAME;
const apipassword = avalaraTax.APIPASSWORD;
const urlPcode = avalaraTax.URLPCODE;
const urlGeoCode = avalaraTax.URLGEOCODE;
const urlCal_tacx = avalaraTax.URLCALTACX;
const urlcommit = avalaraTax.URLCOMMIT;
const FromSmtpMail = new SMTPDetails();
const FromEmail = FromSmtpMail.from;

export class AccountDelete extends AppRoute {
    constructor() {
        super();
    }

    getLastInvoiceId(req: Request, res: Response, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let inName: any = "IN"
                let randNo: any = Math.floor(10000000 + Math.random() * 99999999);
                let invoice_number: any = inName.toUpperCase() + randNo;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `san`,ba.`first_name`,`last_name`,`address1`,`address2`,`city`,`state`,`postal_code`,country,`email`,`contact` FROM `billing_address` ba JOIN `account` a ON ba.idaccount = a.idaccount  WHERE ba.`idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute(async (_error: any, result: any) => {
                    let customer_name: any = result[0].first_name + ' ' + result[0].last_name;
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "INSERT INTO `account_invoice`(`idaccount`,`invoice_number`,`san`,`first_name`,`last_name`,`address1`,`address2`,`city`,`state`,`postal_code`,`country`,`email`,`phone`,`customer_name`) VALUES ('" + sessdata.idaccount + "','" + invoice_number + "','" + result[0].san + "','" + result[0].first_name + "','" + result[0].last_name + "','" + result[0].address1 + "','" + result[0].address2 + "','" + result[0].city + "','" + result[0].state + "','" + result[0].postal_code + "','" + result[0].country + "','" + result[0].email + "','" + result[0].contact + "','" + customer_name + "')";
                    obj1.prepare();
                    obj1.execute((__error: any, data: any) => {
                        if (__error == 1) {
                            resolve(data.insertId);
                            console.log("insert successfully");
                        }
                        else {
                            console.log("something went wrong");
                            reject(0);
                        }
                    });
                })
            });
        });
    }
    // Fetching MRC Local Number data
    getMrcLocalNo(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0002 = new ModelRawQuery(req, res);
                // obj0002.qrysql = "SELECT iduser, COUNT(*) `dids`, SUM(nrc_rates)`cost` FROM did_buy WHERE `type`='NN' AND iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND DATE_FORMAT(created_at,'%Y-%m')='" + cmon + "' AND `disconnect_did_status`=1";
                obj0002.qrysql = "SELECT iduser, COUNT(*) `dids`, SUM(nrc_rates)`cost` FROM did_buy WHERE `type`='NN' AND iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND `disconnect_did_status`=1";
                obj0002.prepare();
                obj0002.execute((___error: any, ibpredid: any) => {
                    let dids = ibpredid[0].dids !== undefined && ibpredid[0].dids !== null && ibpredid[0].dids ? ibpredid[0].dids : 0
                    let cost = ibpredid[0].cost !== undefined && ibpredid[0].cost !== null && ibpredid[0].cost ? ibpredid[0].cost : 0
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'pre_dids_nn','"
                        + dids + "','" + cost + "','5','0','US/CAN Local Number - Tier 1')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                    });
                    if (ibpredid.length > 0) {
                        totalamt += ibpredid[0].cost ? ibpredid[0].cost : 0;
                        resolve({ ibpredid, totalamt });
                    } else {
                        resolve({ ibpredid, totalamt });
                    }
                });
            });
        });
    }
    // Fetching MRC Local Toll Free Number data
    getMrcLocalTollFreeNo(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0003 = new ModelRawQuery(req, res);
                // obj0003.qrysql = "SELECT iduser, COUNT(*) `dids`, SUM(nrc_rates)`cost` FROM did_buy WHERE `type`='TF' AND iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND DATE_FORMAT(created_at,'%Y-%m')='" + cmon + "' AND `disconnect_did_status`=1";
                obj0003.qrysql = "SELECT iduser, COUNT(*) `dids`, SUM(nrc_rates)`cost` FROM did_buy WHERE `type`='TF' AND iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND `disconnect_did_status`=1";
                obj0003.prepare();
                obj0003.execute((___error: any, ibpredidtf: any) => {
                    let dids = ibpredidtf[0].dids !== undefined && ibpredidtf[0].dids !== null && ibpredidtf[0].dids ? ibpredidtf[0].dids : 0;
                    let cost = ibpredidtf[0].cost !== undefined && ibpredidtf[0].cost !== null && ibpredidtf[0].cost ? ibpredidtf[0].cost : 0;
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "','pre_dids_tf','" + dids + "','" + cost + "','5','1','US/CAN Tollfree Number - Tier 1')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                    });
                    if (ibpredidtf.length > 0) {
                        totalamt += ibpredidtf[0].cost ? ibpredidtf[0].cost : 0;
                        resolve({ ibpredidtf, totalamt });
                    } else {
                        resolve({ ibpredidtf, totalamt });
                    }
                });
            });
        });
    }

    //Fetching MRC Campaign data
    getMrcCampData(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0004 = new ModelRawQuery(req, res);
                // obj0004.qrysql = "SELECT SUM(IF(campaign_key IS NOT NULL, 1, 0)) `campaigns`, SUM(IF(campaign_key IS NOT NULL, cost, 0)) `cost` FROM brand_log  WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`current_date`,'%Y-%m')='" + cmon + "'";
                obj0004.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`cost` FROM (SELECT * FROM `campaign` WHERE `deleted`=0 AND `status`=0 GROUP BY `campaign_key`)`cc` WHERE cc.idaccount='" + sessdata.idaccount + "'";
                obj0004.prepare();
                obj0004.execute((___error: any, ibprecamp: any) => {
                    let campaigns = ibprecamp[0].campaigns !== undefined && ibprecamp[0].campaigns !== null && ibprecamp[0].campaigns ? ibprecamp[0].campaigns : 0;
                    let cost = ibprecamp[0].cost !== undefined && ibprecamp[0].cost !== null && ibprecamp[0].cost ? ibprecamp[0].cost : 0;
                    let objb = new ModelRawNonQuery(req, res);
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'pre_campaign','"
                        + campaigns + "','" + cost + "','6','0','Campaigns')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (ibprecamp.length > 0) {
                        totalamt += ibprecamp[0].cost ? ibprecamp[0].cost : 0;
                        resolve({ ibprecamp, totalamt });
                    } else {
                        resolve({ ibprecamp, totalamt });
                    }
                });
            });
        });
    }
    //Fetching MRC Redundant Campaign data
    getMrcRedCampData(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0004 = new ModelRawQuery(req, res);
                obj0004.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`cost` FROM (SELECT * FROM `campaign` WHERE `deleted`=0 AND `status` = 2 GROUP BY `campaign_key`)`cc` WHERE cc.idaccount='" + sessdata.idaccount + "'";
                obj0004.prepare();
                obj0004.execute((___error: any, ibprecamp: any) => {
                    let campaigns = ibprecamp[0].campaigns !== undefined && ibprecamp[0].campaigns !== null && ibprecamp[0].campaigns ? ibprecamp[0].campaigns : 0;
                    let cost = ibprecamp[0].cost !== undefined && ibprecamp[0].cost !== null && ibprecamp[0].cost ? ibprecamp[0].cost : 0;
                    let objb = new ModelRawNonQuery(req, res);
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'red_campaign','"
                        + campaigns + "','" + cost + "','6','1','Redundant Campaign')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (ibprecamp.length > 0) {
                        totalamt += ibprecamp[0].cost ? ibprecamp[0].cost : 0;
                        resolve({ ibprecamp, totalamt });
                    } else {
                        resolve({ ibprecamp, totalamt });
                    }
                });
            });
        });
    }
    //Fetching Redunant Campaign Registration
    fetchRedCampaignData(req: any, res: any, cmon: any, last_invoice: any, totalamt: number, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                const date = new Date();
                let obj0001 = new ModelRawQuery(req, res);
                obj0001.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`ccost` FROM campaign_log  WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`date`,'%Y-%m')='" + cmon + "' AND event_type=38";
                obj0001.prepare();
                obj0001.execute((___error: any, ibbrand: any) => {
                    let ibcampaigns = ibbrand[0].campaigns !== undefined && ibbrand[0].campaigns !== null && ibbrand[0].campaigns ? ibbrand[0].campaigns : 0;
                    let cost = ibbrand[0].ccost !== undefined && ibbrand[0].ccost !== null && ibbrand[0].ccost ? ibbrand[0].ccost : 0;
                    let objc = new ModelRawNonQuery(req, res);
                    objc.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'red_camp_reg','"
                        + ibcampaigns + "','" + cost + "','4','2','Redundant Campaign')";
                    objc.prepare();
                    objc.execute((__error: any, data: any) => {
                    });
                    if (ibbrand.length > 0) {
                        totalamt += ibbrand[0].ccost ? ibbrand[0].ccost : 0;
                        resolve(totalamt);
                    } else {
                        resolve(totalamt)
                    }
                });
            });
        });
    }
    // Fetching MRC Local Phone Number SMS Enablement data
    getPhoneNoSmsEnablement(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0003 = new ModelRawQuery(req, res);
                obj0003.qrysql = "SELECT iduser, COUNT(*) AS dids, SUM(sms_mrc) AS cost FROM did_buy WHERE sms_mrc > 0 AND iduser IN (SELECT iduser FROM user WHERE idaccount = '" + sessdata.idaccount + "')  AND disconnect_did_status = 1";
                obj0003.prepare();
                obj0003.execute((___error: any, smsenable: any) => {
                    let dids = smsenable[0].dids !== undefined && smsenable[0].dids !== null && smsenable[0].dids ? smsenable[0].dids : 0;
                    let cost = smsenable[0].cost !== undefined && smsenable[0].cost !== null && smsenable[0].cost ? smsenable[0].cost : 0;
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "','sms_enable_mrc','" + dids + "','" + cost + "','5','2','Phone Number SMS Enablement')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                    });
                    if (smsenable.length > 0) {
                        totalamt += smsenable[0].cost ? smsenable[0].cost : 0;
                        resolve({ smsenable, totalamt });
                    } else {
                        resolve({ smsenable, totalamt });
                    }
                });
            });
        });
    }
    //  Fetching loop api data
    getlookupApiData(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0004 = new ModelRawQuery(req, res);
                obj0004.qrysql = "SELECT COUNT(*)`api`, SUM(`cost`)`cost` FROM `api_charges_log` WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`created_at`,'%Y-%m')='" + cmon + "'";
                obj0004.prepare();
                obj0004.execute((___error: any, lookupRes: any) => {
                    let api = lookupRes[0].api !== undefined && lookupRes[0].api !== null && lookupRes[0].api ? lookupRes[0].api : 0;
                    let cost = lookupRes[0].cost !== undefined && lookupRes[0].cost !== null && lookupRes[0].cost ? lookupRes[0].cost : 0;
                    let objb = new ModelRawNonQuery(req, res);
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'lookup','"
                        + api + "','" + cost + "','8','0','Lookup - Number Details')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (lookupRes.length > 0) {
                        totalamt += lookupRes[0].cost ? lookupRes[0].cost : 0;
                        resolve({ lookupRes, totalamt });
                    } else {
                        resolve({ lookupRes, totalamt });
                    }
                });
            });
        });
    }
    //  Fetching Subscription Charges data
    getSubscriptionData(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0004 = new ModelRawQuery(req, res);
                obj0004.qrysql = "SELECT a.idaccount, a.quantity, (a.quantity * b.mrc)`cost`, b.description FROM `subscription_account` a INNER JOIN `subscription` b ON a.subscription_id=b.subscription_id WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`end_date`,'%Y-%m')='" + cmon + "' OR DATE_FORMAT(end_date, '%Y-%m') = '0000-00' AND status = 1";
                obj0004.prepare();
                obj0004.execute((___error: any, subsRes: any) => {
                    let ct = 0;
                    let subcost = 0;
                    let objb = new ModelRawNonQuery(req, res);
                    if (subsRes.length > 0) {
                        let qry = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES";
                        subsRes.forEach((ele: any) => {
                            totalamt += ele.cost ? ele.cost : 0;
                            subcost += ele.cost ? ele.cost : 0;
                            ct++;
                            let skey = 'sub_' + ct;
                            qry += "('" + last_invoice + "' ,'" + skey + "','" + ele.quantity + "','" + ele.cost + "','7','1','" + ele.description + "'),";

                        });
                        objb.nonqrysql = qry.slice(0, -1)
                        objb.prepare();
                        objb.execute((_error: any, result: any) => {

                        });

                        // totalamt += subsRes[0].cost ? subsRes[0].cost : 0;
                        resolve({ subcost, totalamt });
                    } else {
                        resolve({ subcost, totalamt });
                    }
                });
            });
        });
    }

    //Fetching Campaign Review data
    getMrcCampReviewData(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0004 = new ModelRawQuery(req, res);
                // obj0004.qrysql = "SELECT SUM(IF(campaign_key IS NOT NULL, 1, 0)) `campaigns`, SUM(IF(campaign_key IS NOT NULL, cost, 0)) `cost` FROM campaign_log  WHERE idaccount='" + sessdata.idaccount + "' AND event_type='27' AND DATE_FORMAT(`date`,'%Y-%m')='" + cmon + "'";
                obj0004.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`ccost` FROM campaign_log  WHERE idaccount='" + sessdata.idaccount + "' AND event_type='27' AND DATE_FORMAT(`date`,'%Y-%m')='" + cmon + "'";
                obj0004.prepare();
                obj0004.execute((___error: any, campReviewRes: any) => {
                    let objb = new ModelRawNonQuery(req, res);
                    let campaigns = campReviewRes[0].campaigns !== undefined && campReviewRes[0].campaigns !== null && campReviewRes[0].campaigns ? campReviewRes[0].campaigns : 0;
                    let cost = campReviewRes[0].ccost !== undefined && campReviewRes[0].ccost !== null && campReviewRes[0].ccost ? campReviewRes[0].ccost : 0;
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'campaign_review','"
                        + campaigns + "','" + cost + "','4','0','Campaign Review')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (campReviewRes.length > 0) {
                        totalamt += campReviewRes[0].cost ? campReviewRes[0].cost : 0;
                        resolve({ campReviewRes, totalamt });
                    } else {
                        resolve({ campReviewRes, totalamt });
                    }
                });
            });
        });
    }
    getTotalCallCostAmt(req: Request, res: Response, cmon: any, totalamt: number, last_invoice: any, key: any, bound: any, zone: any, category: any, subcategory: any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                const date = new Date();
                let obj02 = new ModelRawQuery(req, res);
                obj02.qrysql = "SELECT iduser, SUM(`duration`) `duration`, SUM(`cost`) `callcost` FROM invoice_cdr WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND `zone` IN ('Zone " + zone + "'," + zone + ") AND `direction`='" + bound + "' AND DATE_FORMAT(`start_stamp`,'%Y-%m')='" + cmon + "'";
                obj02.prepare();
                obj02.execute((___error: any, ibcall: any) => {
                    let ibcallDuration = ibcall[0].duration !== undefined && ibcall[0].duration !== null && ibcall[0].duration ? ibcall[0].duration : 0;
                    let cost = ibcall[0].callcost !== undefined && ibcall[0].callcost !== null && ibcall[0].callcost ? ibcall[0].callcost : 0;
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'" + key + "','"
                        + ibcallDuration + "','" + cost + "','" + category + "','" + subcategory + "','USA Tier " + zone + "')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                        console.log("USA Tier " + zone + " Inserted Successfully");
                    });
                    if (ibcall.length > 0) {
                        totalamt += ibcall[0].callcost ? ibcall[0].callcost : 0;
                        console.log("Get total call cost Amount=>", totalamt);
                        resolve(totalamt);
                    } else {
                        resolve(totalamt);
                    }
                });
            });
        });
    }
    tollFreeInAndOut(req: any, res: any, cmon: any, last_invoice: any, totalamt: number, direction: any, key: any, subcategory: any, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj07 = new ModelRawQuery(req, res);
                obj07.qrysql = "SELECT iduser, SUM(`duration`) `duration`, SUM(`cost`) `callcost` FROM invoice_cdr WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND `zone` IN ('toll_free',800) AND `direction`='" + direction + "' AND DATE_FORMAT(`start_stamp`,'%Y-%m')='" + cmon + "'";
                obj07.prepare();
                obj07.execute((___error: any, ibcall: any) => {
                    let ibcallDuration = ibcall[0].duration !== undefined && ibcall[0].duration !== null && ibcall[0].duration ? ibcall[0].duration : 0;
                    let cost = ibcall[0].callcost !== undefined && ibcall[0].callcost !== null && ibcall[0].callcost ? ibcall[0].callcost : 0
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'" + key + "','"
                        + ibcallDuration + "','" + cost + "','1','" + subcategory + "','Toll Free')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                        console.log("Toll Free Inserted Successfully");
                    });
                    if (ibcall.length > 0) {
                        totalamt += ibcall[0].callcost ? ibcall[0].callcost : 0;
                        console.log("Get Toll Free Inbound And Outbound Amount=>", totalamt);
                        resolve(totalamt)
                    } else {
                        resolve(totalamt);
                    }
                });
            });
        });
    }

    smsInAndOutData(req: any, res: any, cmon: any, last_invoice: any, totalamt: number, direction: any, key1: any, key2: any, subcategory: any, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let msgcount = 0;
                let msgrates = 0;
                let msgsur = 0;
                let obj007 = new ModelRawQuery(req, res);
                obj007.qrysql = "SELECT iduser, SUM(msg_count)`msg`,SUM(IFNULL(MT_rates,0))`rate`,SUM(IFNULL(MT_surcharge,0))`sur` FROM mdr WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND DATE_FORMAT(created_at,'%Y-%m')='" + cmon + "' AND `direction`='" + direction + "'";
                obj007.prepare();
                obj007.execute((___error: any, ibsms: any) => {
                    if (ibsms.length > 0) {
                        totalamt += ibsms[0].rate ? ibsms[0].rate : 0
                        totalamt += ibsms[0].sur ? ibsms[0].sur : 0;
                        msgcount = msgcount + ibsms[0].msg;
                        msgrates = msgrates + ibsms[0].rate;
                        msgsur = msgsur + ibsms[0].sur;
                    }
                    let obj008 = new ModelRawQuery(req, res);
                    obj008.qrysql = "SELECT iduser, SUM(msg_count)`msg`,SUM(IFNULL(MT_rates,0))`rate`,SUM(IFNULL(MT_surcharge,0))`sur` FROM mdr WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND DATE_FORMAT(created_at,'%Y-%m')='" + cmon + "' AND `direction`='" + direction + "'";
                    obj008.prepare();
                    obj008.execute((___error: any, ibmms: any) => {
                        if (ibmms.length > 0) {
                            totalamt += ibmms[0].rate ? ibmms[0].rate : 0
                            totalamt += ibmms[0].sur ? ibmms[0].sur : 0;
                            msgcount = msgcount + ibmms[0].msg;
                            msgrates = msgrates + ibmms[0].rate;
                            msgsur = msgsur + ibmms[0].sur;
                        }
                    })
                    let ibsmsMsg = ibsms[0].msg !== undefined && ibsms[0].msg !== null && ibsms[0].msg ? ibsms[0].msg : 0;
                    let rate = ibsms[0].rate !== undefined && ibsms[0].rate !== null && ibsms[0].rate ? ibsms[0].rate : 0;
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'" + key1 + "','"
                        + msgcount + "','" + msgrates + "','2','" + subcategory + "','Transit Charge')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                        console.log("Transit Charge Inserted Successfully");
                    });
                    let sur = ibsms[0].sur ? ibsms[0].sur : 0;
                    let obj00 = new ModelRawNonQuery(req, res);
                    obj00.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'" + key2 + "','"
                        + msgcount + "','" + msgrates + "','2','" + subcategory + "','Surcharge')";
                    obj00.prepare();
                    obj00.execute((__error: any, data: any) => {
                    });
                    // if (ibsms.length > 0) {
                    //     totalamt += ibsms[0].rate ? ibsms[0].rate : 0
                    //     totalamt += ibsms[0].sur ? ibsms[0].sur : 0;
                    //     msgcount = msgcount + ibsms[0].msg;
                    //     msgrates = msgrates + ibsms[0].rate;
                    //     msgsur = msgsur + ibsms[0].sur;
                    //     console.log("Get SMS Inbound And Outbound Amount=>", totalamt);
                    //     resolve(totalamt)
                    // } else {
                    resolve(totalamt);
                    // }
                });
            });
        });
    }
    fetchTollFreeAndLocalNoData(req: any, res: any, cmon: any, last_invoice: any, totalamt: number, key: any, category: any, subcategory: any, label: any, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj009 = new ModelRawQuery(req, res);
                obj009.qrysql = "SELECT iduser, COUNT(*) `dids`, SUM(`pro_rates`)`cost` FROM did_buy WHERE `type`='NN' AND iduser IN (SELECT iduser FROM `user` WHERE idaccount='" + sessdata.idaccount + "') AND DATE_FORMAT(created_at,'%Y-%m')='" + cmon + "'";
                obj009.prepare();
                obj009.execute((___error: any, ibdid: any) => {
                    let dids = ibdid[0].dids !== undefined && ibdid[0].dids !== null && ibdid[0].dids ? ibdid[0].dids : 0;
                    let cost = ibdid[0].cost !== undefined && ibdid[0].cost !== null && ibdid[0].cost ? ibdid[0].cost : 0
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'" + key + "','"
                        + dids + "','" + cost + "','" + category + "','" + subcategory + "','" + label + "')";
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                    });
                    if (ibdid.length > 0) {
                        totalamt += ibdid[0].cost ? ibdid[0].cost : 0;
                        console.log("Get Toll Free Local number data Amount=>", totalamt);
                        resolve(totalamt);
                    } else {
                        resolve(totalamt)
                    }

                });
            });
        });
    }
    fetchBrandData(req: any, res: any, cmon: any, last_invoice: any, totalamt: number, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                const date = new Date();
                let obj0001 = new ModelRawQuery(req, res);
                // obj0001.qrysql = "SELECT SUM(IF(brand_key IS NOT NULL, 1, 0)) `brands`, SUM(IF(brand_key IS NOT NULL, cost, 0)) `bcost` FROM brand_log WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`current_date`,'%Y-%m')='" + cmon + "' AND event_type=1";
                obj0001.qrysql = "SELECT COUNT(*)`brands`, SUM(`cost`)`bcost` FROM `brand_log` WHERE `event_type` IN (1,7) AND idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`current_date`,'%Y-%m')='" + cmon + "'";
                obj0001.prepare();
                obj0001.execute((___error: any, ibbrand: any) => {
                    let ibbrands = ibbrand[0].brands !== undefined && ibbrand[0].brands !== null && ibbrand[0].brands ? ibbrand[0].brands : 0;
                    let bcost = ibbrand[0].bcost !== undefined && ibbrand[0].bcost !== null && ibbrand[0].bcost ? ibbrand[0].bcost : 0;
                    let objb = new ModelRawNonQuery(req, res);
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'brand','"
                        + ibbrands + "','" + bcost + "','4','0','Brand Registration')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (ibbrand.length > 0) {
                        totalamt += ibbrand[0].bcost ? ibbrand[0].bcost : 0;
                        resolve(totalamt);
                    } else {
                        resolve(totalamt)
                    }
                });
            });
        });
    }
    fetchCampaignData(req: any, res: any, cmon: any, last_invoice: any, totalamt: number, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                const date = new Date();
                let obj0001 = new ModelRawQuery(req, res);
                // obj0001.qrysql = "SELECT SUM(IF(campaign_key IS NOT NULL, 1, 0)) `campaigns`, SUM(IF(campaign_key IS NOT NULL, (cost+nrc_rates), 0))`ccost` FROM campaign_log  WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`date`,'%Y-%m')='" + cmon + "' AND event_type=1";
                obj0001.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`ccost` FROM campaign_log  WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`date`,'%Y-%m')='" + cmon + "' AND event_type=1";
                obj0001.prepare();
                obj0001.execute((___error: any, ibbrand: any) => {
                    let ibcampaigns = ibbrand[0].campaigns !== undefined && ibbrand[0].campaigns !== null && ibbrand[0].campaigns ? ibbrand[0].campaigns : 0;
                    let cost = ibbrand[0].ccost !== undefined && ibbrand[0].ccost !== null && ibbrand[0].ccost ? ibbrand[0].ccost : 0;
                    let objc = new ModelRawNonQuery(req, res);
                    objc.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'campaign','"
                        + ibcampaigns + "','" + cost + "','4','0','Campaign Registration')";
                    objc.prepare();
                    objc.execute((__error: any, data: any) => {
                    });
                    if (ibbrand.length > 0) {
                        totalamt += ibbrand[0].ccost ? ibbrand[0].ccost : 0;
                        resolve(totalamt);
                    } else {
                        resolve(totalamt)
                    }
                });
            });
        });
    }
    //Fetching brand vetting data
    getBrandVettData(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj0004 = new ModelRawQuery(req, res);
                // obj0004.qrysql = "SELECT SUM(IF(brand_key IS NOT NULL, 1, 0)) `brands`, SUM(IF(brand_key IS NOT NULL, cost, 0)) `cost` FROM brand_vetting_log WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`created_at`,'%Y-%m')='" + cmon + "' AND event_type=1";
                obj0004.qrysql = "SELECT COUNT(*)`brands`, SUM(`priceDeducted`)`bcost` FROM `brand_vetting` WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`createdDate`,'%Y-%m')='" + cmon + "'";
                obj0004.prepare();
                obj0004.execute((___error: any, brandVett: any) => {
                    let brandVetting = brandVett[0].brands !== undefined && brandVett[0].brands !== null && brandVett[0].brands ? brandVett[0].brands : 0;
                    let cost = brandVett[0].bcost !== undefined && brandVett[0].bcost !== null && brandVett[0].bcost ? brandVett[0].bcost : 0;
                    let objb = new ModelRawNonQuery(req, res);
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'brand_vetting','"
                        + brandVetting + "','" + cost + "','4','1','Brand Vetting')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (brandVett.length > 0) {
                        totalamt += brandVett[0].cost ? brandVett[0].cost : 0;
                        resolve({ brandVett, totalamt });
                    } else {
                        resolve({ brandVett, totalamt });
                    }
                });
            });
        });
    }
    // Fetching Brand Appeal data

    getBrandAppeal(req: Request, res: Response, cmon: any, last_invoice: any, totalamt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                const date = new Date();
                let obj0004 = new ModelRawQuery(req, res);
                obj0004.qrysql = "SELECT SUM(IF(brandId IS NOT NULL, 1, 0)) `brands`, SUM(IF(brandId IS NOT NULL, cost, 0)) `cost` FROM brand_appeal_log  WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`created_at`,'%Y-%m')='" + cmon + "' AND event_type=1";
                obj0004.prepare();
                obj0004.execute((___error: any, brandAppeal: any) => {
                    let brandAppeals = brandAppeal[0].brands !== undefined && brandAppeal[0].brands !== null && brandAppeal[0].brands ? brandAppeal[0].brands : 0;
                    let cost = brandAppeal[0].cost !== undefined && brandAppeal[0].cost !== null && brandAppeal[0].cost ? brandAppeal[0].cost : 0;
                    let objb = new ModelRawNonQuery(req, res);
                    objb.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'brand_appeal','"
                        + brandAppeals + "','" + cost + "','4','0','Brand Appeal')";
                    objb.prepare();
                    objb.execute((__error: any, data: any) => {
                    });
                    if (brandAppeal.length > 0) {
                        totalamt += brandAppeal[0].cost ? brandAppeal[0].cost : 0;
                        resolve({ brandAppeal, totalamt });
                    } else {
                        resolve({ brandAppeal, totalamt });
                    }
                });
            });
        });
    }
    // Fetching wallet data
    getwalletData(req: Request, res: Response, last_invoice: any, deductTotalAmt: number, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                const date = new Date();
                let bmon: any = null;
                bmon = `${date.getFullYear()}-${date.getMonth() + 1}`;
                let obj0004 = new ModelRawQuery(req, res);
                obj0004.qrysql = "SELECT balance FROM wallet WHERE idaccount='" + sessdata.idaccount + "'";
                obj0004.prepare();
                obj0004.execute((___error: any, walletRes: any) => {
                    let outstanding_amount: any = 0;
                    let minimum_amount: any = 0;
                    if (walletRes[0].balance >= deductTotalAmt) {
                        outstanding_amount = walletRes[0].balance - deductTotalAmt
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE wallet SET `balance`=" + outstanding_amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                        obj.prepare();
                        obj.execute((_error: any, wallet: any) => {
                            if (_error == 1) {
                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                iQry += "`amount`='+" + walletRes[0].balance + "', "
                                iQry += "`purpose`='Wallet amount successfully updated for invoice closing', "
                                iQry += "`status`=1;"
                                let objWL = new ModelRawNonQuery(req, res);
                                objWL.nonqrysql = iQry
                                objWL.prepare()
                                objWL.execute((error: any, result: any) => {
                                    console.log("Transaction response::", result)
                                })
                            }
                            else {
                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                iQry += "`amount`='+" + walletRes[0].balance + "', "
                                iQry += "`purpose`='Wallet amount successfully not updated for invoice closing', "
                                iQry += "`status`=2;"
                                let objWL = new ModelRawNonQuery(req, res);
                                objWL.nonqrysql = iQry
                                objWL.prepare()
                                objWL.execute((error: any, result: any) => {
                                    console.log("Transaction response::", result)
                                })
                            }
                            console.log("customer account updated");
                        });
                        console.log("outstanding_amountoutstanding_amount=>", outstanding_amount);

                        resolve({ remainingWellet: outstanding_amount, previousDue: 0 })
                    }
                    else {
                        let obj04 = new ModelRawQuery(req, res);
                        obj04.qrysql = "SELECT ai.`san`,ai.`first_name`,ai.`last_name`,ai.`email`,ai.`address1`,ai.`address2`,ai.`city`,ai.`state`,ai.`postal_code`,ai.`country`,ai.`phone` AS contact, sc.customer_id FROM `account_invoice` ai JOIN `stripe_card` sc ON sc.`idaccount`= ai.`idaccount` WHERE ai.`idaccount`='" + sessdata.idaccount + "' AND sc.default = true ORDER BY idinvoice DESC LIMIT 1";
                        obj04.prepare();
                        obj04.execute((___error: any, invoiceRes: any) => {
                            if (invoiceRes.length > 0) {
                                let payLoad: any;
                                minimum_amount = deductTotalAmt - walletRes[0].balance;
                                payLoad = Object.assign(invoiceRes[0], { amount: minimum_amount.toFixed(2) }, { generateInvoice: true });
                                let stp = new StripeApi();
                                stp.balanceDeduct(req, res, sessdata, payLoad, (error, resp) => {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE wallet SET `balance`=0 WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, wallet: any) => {
                                        console.log("customer account updated", wallet);
                                    });
                                });
                                (walletRes[0].balance < 0) ? resolve({ remainingWellet: 0, previousDue: walletRes[0].balance * -1 }) : resolve({ remainingWellet: 0, previousDue: 0 });
                            }
                            else {
                                resolve({ remainingWellet: 0, previousDue: 0 });
                            }
                        });
                    }
                });
            });
        });
    }

    dateDiffInDays(dateFrom: any, dateTo: any) {
        const oneDay = 24 * 60 * 60 * 1000;
        const utcDateFrom = Date.UTC(dateFrom.getFullYear(), dateFrom.getMonth(), dateFrom.getDate());
        const utcDateTo = Date.UTC(dateTo.getFullYear(), dateTo.getMonth(), dateTo.getDate());
        const diffDays = Math.floor((utcDateTo - utcDateFrom) / oneDay);
        return diffDays;
    }

    getExtraDidMrc(req: any, res: any, cmon: any, last_invoice: any, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT COUNT(did) `didcount`,SUM(TIMESTAMPDIFF(MONTH, DATE_FORMAT(NOW(),'%Y-%m-%d'),DATE_FORMAT(subscription_end_date,'%Y-%m-%d'))*nrc_rates) `extraMrc`, `iddid`,account_id,nrc_rates,created_at, `did_disconnect_days`,`subscription_end_date`,`did` FROM `did_buy` WHERE account_id='" + sessdata.idaccount + "' AND disconnect_did_status='1' AND DATE_FORMAT(subscription_end_date,'%Y-%m-%d') > DATE_FORMAT(NOW(),'%Y-%m-%d')";
                obj.prepare();
                obj.execute((___error: any, extDidRes: any) => {
                    if (extDidRes.length > 0) {
                        let extraAmt = extDidRes[0].didcount !== undefined && extDidRes[0].didcount !== null && extDidRes[0].didcount ? extDidRes[0].didcount : 0;
                        let extraMrc = extDidRes[0].extraMrc !== undefined && extDidRes[0].extraMrc !== null && extDidRes[0].extraMrc ? extDidRes[0].extraMrc : 0;
                        let obj0 = new ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "INSERT INTO `account_invoice_closing` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'extra_did','"
                            + extraAmt + "','" + extraMrc + "','5','0','EXTRA DIDs')";
                        obj0.prepare();
                        obj0.execute((__error: any, data: any) => {
                        });
                        resolve({ did_qty: extraAmt, cost: extraMrc });
                    }
                    else {
                        resolve(0);
                    }
                })
            });
        });
    }
    geTotalTax(req: any, res: any, cmon: any, idinvoice: any, next: any) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let idinvoiceObj = new AccountDelete();
                const date = new Date();
                let cday: any = date.getDate();
                let mday: any = date.getMonth() + 1;
                let yday: any = date.getFullYear();
                let crnt_date: any = mday + '/' + cday + '/' + yday
                let localToken: any
                let invoNumber: any
                var options = {
                    'method': 'POST',
                    'url': urlLogin,
                    'headers': {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        "apiusername": apiusername,
                        "apipassword": apipassword
                    })

                };
                request(options, function (err: any, response: any) {
                    let data1: any = JSON.parse(response.body);
                    localToken = data1.result.token;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT ai.idaccount, ai.invoice_number, ai.city, ai.state, ai.postal_code, ai.country, ai.email, ai.idinvoice, ai.created_at, ai.address1 FROM `account_invoice` AS ai JOIN `account_invoice_closing` AS ci ON ai.idinvoice = ci.idinvoice WHERE ai.`created_at` LIKE '%" + cmon + "%' GROUP BY ai.idaccount";
                    obj.prepare();
                    obj.execute((_error: any, invoceRes: any) => {
                        if (_error == 1) {
                            if (invoceRes.length > 0) {
                                invoNumber = invoceRes[0].invoice_number;
                                let city: any = invoceRes[0].city;
                                let postal_code: any = invoceRes[0].postal_code;
                                let state: any = invoceRes[0].state;
                                let addr: any = invoceRes[0].address1;
                                /** To Check GeoCode*/
                                var options = {
                                    'method': 'POST',
                                    'url': urlGeoCode,
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Cookie': 'AuthToken=' + localToken
                                    },
                                    body: JSON.stringify({
                                        "ref": "Address Request",
                                        "cass": true,
                                        "addr": addr,
                                        "city": city,
                                        "st": state,
                                        "zip": postal_code
                                    })
                                };
                                request(options, async function (__error: any, response: any) {
                                    let dataGeo: any = JSON.parse(response.body);
                                    let pCode: any = dataGeo.result[0].pcd;
                                    if (pCode) {
                                        // To US/CAN Local Number - Tier 1   mrc_nn
                                        let mrcNn: any = {};
                                        mrcNn = await idinvoiceObj.getCostQty(req, res, idinvoice, 'pre_dids', next);
                                        console.log("mrcNn ::=> ", mrcNn);

                                        let mrcTf: any = {};
                                        mrcTf = await idinvoiceObj.getCostQty(req, res, idinvoice, 'pre_dids_tf', next);
                                        console.log("mrcTf ::=> ", mrcTf);

                                        let campMrc: any = {};
                                        campMrc = await idinvoiceObj.getCostQty(req, res, idinvoice, 'pre_campaign', next);
                                        console.log("campMrc ::=> ", campMrc);

                                        let obcallTollfree: any = {};
                                        obcallTollfree = await idinvoiceObj.getCostQty(req, res, idinvoice, 'call_ob_tf', next);
                                        console.log("obcallTollfree ::=> ", obcallTollfree);

                                        let ibcallTollfree: any = {};
                                        ibcallTollfree = await idinvoiceObj.getCostQty(req, res, idinvoice, 'call_ib_tf', next);
                                        console.log("ibcallTollfree ::=> ", ibcallTollfree);

                                        let smsIbtc: any = {};
                                        smsIbtc = await idinvoiceObj.getCostQty(req, res, idinvoice, 'mdrs_ib_tc', next);
                                        console.log("smsIbtc ::=> ", smsIbtc);

                                        let smsIbsr: any = {};
                                        smsIbsr = await idinvoiceObj.getCostQty(req, res, idinvoice, 'mdrs_ib_sc', next);
                                        console.log("smsIbsr ::=> ", smsIbsr);

                                        let smsObtc: any = {};
                                        smsObtc = await idinvoiceObj.getCostQty(req, res, idinvoice, 'mdrs_ob_tc', next);
                                        console.log("smsObtc ::=> ", smsObtc);

                                        let smsObsr: any = {};
                                        smsObsr = await idinvoiceObj.getCostQty(req, res, idinvoice, 'mdrs_ob_sc', next);
                                        console.log("smsObsr ::=> ", smsObsr);

                                        let ncaNn: any = {};
                                        ncaNn = await idinvoiceObj.getCostQty(req, res, idinvoice, 'did', next);
                                        console.log("ncaNn ::=> ", ncaNn);

                                        let ncaTf: any = {};
                                        ncaTf = await idinvoiceObj.getCostQty(req, res, idinvoice, 'did_tf', next);
                                        console.log("ncaTf ::=> ", ncaTf);

                                        let a2ppacNrcbrnd: any = {};
                                        a2ppacNrcbrnd = await idinvoiceObj.getCostQty(req, res, idinvoice, 'brand', next);
                                        console.log("a2ppacNrcbrnd ::=> ", a2ppacNrcbrnd);

                                        let a2ppacNrcmp: any = {};
                                        a2ppacNrcmp = await idinvoiceObj.getCostQty(req, res, idinvoice, 'campaign', next);
                                        console.log("a2ppacNrcmp ::=> ", a2ppacNrcmp);

                                        let resultIb: any = {};
                                        resultIb = await idinvoiceObj.getCostQtyKey(req, res, idinvoice, "'call_ib_t1', 'call_ib_t2', 'call_ib_t3', 'call_ib_t4', 'call_ib_t5'", next);
                                        console.log("resultIb ::=> ", resultIb);

                                        let resultOb: any = {};
                                        resultOb = await idinvoiceObj.getCostQtyKey(req, res, idinvoice, "'call_ob_t1', 'call_ob_t2', 'call_ob_t3', 'call_ob_t4', 'call_ob_t5'", next);
                                        console.log("resultOb ::=> ", resultOb);

                                        let resultSqlALl: any = {};
                                        resultSqlALl = await idinvoiceObj.getCostQtyKey(req, res, idinvoice, "'pre_dids', 'pre_dids_tf', 'pre_campaign', 'call_ob_tf', 'call_ib_tf', 'mdrs_ib_tc', 'mdrs_ib_sc', 'mdrs_ob_tc', 'mdrs_ob_sc', 'did', 'did_tf', 'brand', 'campaign'", next);
                                        if (invoNumber) {
                                            let amt1 = mrcNn.total;
                                            let qty1 = mrcNn.qty;
                                            let amt2 = mrcTf.total;
                                            let qty2 = mrcTf.qty;
                                            let amt3 = campMrc.total;
                                            let qty3 = campMrc.qty;
                                            let amt4 = obcallTollfree.total;
                                            let qty4 = obcallTollfree.qty;
                                            let amt5 = ibcallTollfree.total;
                                            let qty5 = ibcallTollfree.qty;
                                            let amt6 = smsIbtc.total;
                                            let qty6 = smsIbtc.qty;
                                            let amt7 = smsIbsr.total;
                                            let qty7 = smsIbsr.qty;
                                            let amt8 = smsObtc.total;
                                            let qty8 = smsObtc.qty;
                                            let amt9 = smsObsr.total;
                                            let qty9 = smsObsr.qty;
                                            let amt10 = ncaNn.total;
                                            let qty10 = ncaNn.qty;
                                            let amt11 = ncaTf.total;
                                            let qty11 = ncaTf.qty;
                                            let amt12 = a2ppacNrcbrnd.total;
                                            let qty12 = a2ppacNrcbrnd.qty;
                                            let amt13 = a2ppacNrcmp.total;
                                            let qty13 = a2ppacNrcmp.qty;
                                            let amt14 = resultIb.total;
                                            let qty14 = resultIb.qty;
                                            let amt15 = resultOb.total;
                                            let qty15 = resultOb.qty;
                                            let Post_Fields: any = JSON.stringify({
                                                "token": authKey,
                                                "country": "USA",
                                                "state": state,
                                                "city": city,
                                                "zip": postal_code,
                                                "pcode": pCode,
                                                "document": 'doc_' + invoNumber,
                                                "invoice": 'doc' + invoNumber,
                                                "idinvoice": idinvoice,
                                                "date": crnt_date,
                                                "account_ref": sessdata.idaccount,
                                                "customer_ref": invoceRes.email,
                                                "company_identy": "Gventure",
                                                "itms": [
                                                    {
                                                        "type": "mrc_nn",
                                                        "amount": amt1,
                                                        "quantity": qty1
                                                    },
                                                    {
                                                        "type": "mrc_tf",
                                                        "amount": amt2,
                                                        "quantity": qty2
                                                    },
                                                    {
                                                        "type": "camp_mrc",
                                                        "amount": amt3,
                                                        "quantity": qty3
                                                    },
                                                    {
                                                        "type": "obcall_usatier",
                                                        "amount": amt4,
                                                        "quantity": qty4
                                                    },
                                                    {
                                                        "type": "obcall_tollfree",
                                                        "amount": amt5,
                                                        "quantity": qty5
                                                    },
                                                    {
                                                        "type": "ibcall_usatier",
                                                        "amount": amt6,
                                                        "quantity": qty6
                                                    },
                                                    {
                                                        "type": "ibcall_tollfree",
                                                        "amount": amt7,
                                                        "quantity": qty7
                                                    },
                                                    {
                                                        "type": "sms_ibtc",
                                                        "amount": amt8,
                                                        "quantity": qty8
                                                    },
                                                    {
                                                        "type": "sms_ibsr",
                                                        "amount": amt9,
                                                        "quantity": qty9
                                                    },
                                                    {
                                                        "type": "sms_obtc",
                                                        "amount": amt10,
                                                        "quantity": qty10
                                                    },
                                                    {
                                                        "type": "sms_obsr",
                                                        "amount": amt11,
                                                        "quantity": qty11
                                                    },
                                                    {
                                                        "type": "nca_nn",
                                                        "amount": amt12,
                                                        "quantity": qty12
                                                    },
                                                    {
                                                        "type": "nca_tf",
                                                        "amount": amt13,
                                                        "quantity": qty13
                                                    },
                                                    {
                                                        "type": "a2ppac_nrcbrnd",
                                                        "amount": amt14,
                                                        "quantity": qty14
                                                    },
                                                    {
                                                        "type": "a2ppac_nrcmp",
                                                        "amount": amt15,
                                                        "quantity": qty15
                                                    },
                                                ]
                                            });
                                            /** To Tax Calculation*/
                                            var options = {
                                                'method': 'POST',
                                                'url': urlCal_tacx,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Cookie': 'AuthToken=' + localToken
                                                },
                                                body: Post_Fields
                                            };

                                            request(options, async function (___error: any, response: any) {
                                                //To Update Invoice Tax
                                                let ava_data: any = JSON.parse(response.body);
                                                if (___error == null) {
                                                    let sales_tax: any = ava_data.result.sales_tax ? ava_data.result.sales_tax : '0.00';
                                                    let bussiness_tax: any = ava_data.result.bussiness_tax ? ava_data.result.bussiness_tax : '0.00';
                                                    let grt_tax: any = ava_data.result.grt_tax ? ava_data.result.grt_tax : '0.00';
                                                    let excise_tax: any = ava_data.result.excise_tax ? ava_data.result.excise_tax : '0.00';
                                                    let ucf_tax: any = ava_data.result.ucf_tax ? ava_data.result.ucf_tax : '0.00';
                                                    let fcc_tax: any = ava_data.result.fcc_tax ? ava_data.result.fcc_tax : '0.00';
                                                    let e911_tax: any = ava_data.result.e911_tax ? ava_data.result.e911_tax : '0.00';
                                                    let utility_user_tax: any = ava_data.result.utility_user_tax ? ava_data.result.utility_user_tax : '0.00';
                                                    let rwf_tax: any = ava_data.result.rwf_tax ? ava_data.result.rwf_tax : '0.00';
                                                    let comm_service_tax: any = ava_data.result.comm_service_tax ? ava_data.result.comm_service_tax : '0.00';
                                                    let crf_tax: any = ava_data.result.crf_tax ? ava_data.result.crf_tax : '0.00';
                                                    let reserve_tax: any = ava_data.result.reserve_tax ? ava_data.result.reserve_tax : '0.00';
                                                    let va_tax: any = ava_data.result.va_tax ? ava_data.result.va_tax : '0.00';
                                                    let all_tax_sum: any = ava_data.result.all_tax_sum ? ava_data.result.all_tax_sum : '0.00';
                                                    let obj1 = new ModelRawNonQuery(req, res);

                                                    obj1.nonqrysql = "UPDATE `account_invoice` SET `sales_tax`='" + sales_tax + "',`bussiness_tax`='" + bussiness_tax + "',`grt_tax`='" + grt_tax + "',`excise_tax`='" + excise_tax + "', `ucf_tax`='" + ucf_tax + "', `fcc_tax`='" + fcc_tax + "', `e911_tax`='" + e911_tax + "', `utility_user_tax`='" + utility_user_tax + "', `rwf_tax`='" + rwf_tax + "', `comm_service_tax`='" + comm_service_tax + "', `crf_tax`='" + crf_tax + "',`reserve_tax`='" + reserve_tax + "', `va_tax`='" + va_tax + "' WHERE `idaccount`='" + sessdata.idaccount + "' AND `idinvoice`='" + idinvoice + "'";
                                                    let obj2 = new ModelRawNonQuery(req, res);
                                                    obj2.nonqrysql = "UPDATE `account_invoice_closing` SET `tax`='" + all_tax_sum + "' WHERE `idinvoice`='" + idinvoice + "'";
                                                    obj2.prepare();
                                                    obj2.execute((errs: any, data: any) => {
                                                        // To Commit Invoice Tax
                                                        if (errs == 1) {
                                                            resolve(all_tax_sum);
                                                        }
                                                        else {
                                                            console.log("Invoice Monthly tax not updated ::" + invoNumber);
                                                        }
                                                    })
                                                } else {
                                                    console.log("Invoice tax not updated 123 ::" + invoNumber);
                                                }
                                            })
                                        }
                                        else {
                                            console.log("Invalid Invoice Detail at this account ::" + invoNumber);
                                        }

                                    }
                                    else {
                                        console.log("No Geo Code Available ::" + invoNumber);
                                    }
                                })
                            }
                            else {
                                console.log("Record Not Found");
                            }
                        }
                        else {
                            console.log("something went wrong");
                        }
                    });
                })

            });
        });
    }

    // To US/CAN Local Number - Tier 1   mrc_nn
    getCostQty(req: Request, res: Response, idinvoice: any, keys: any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let obj0 = new ModelRawQuery(req, res);
            obj0.qrysql = "SELECT SUM(IFNULL(value,0))`qty`, SUM(IFNULL(cost,0))`total` FROM `account_invoice_closing` WHERE idinvoice=" + idinvoice + " AND `key`='" + keys + "'";
            obj0.prepare();
            obj0.execute((___error: any, ibprecamp: any) => {
                let qty = ibprecamp[0].qty;
                let total = ibprecamp[0].total
                resolve({ qty, total })
            });
        });
    }
    getCostQtyKey(req: Request, res: Response, idinvoice: any, keys: any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let obj0 = new ModelRawQuery(req, res);
            obj0.qrysql = "SELECT SUM(IFNULL(cost,0)) AS total, SUM(IFNULL(value,0)) AS qty FROM `account_invoice_closing` WHERE idinvoice=" + idinvoice + " AND `key` IN (" + keys + ")";
            obj0.prepare();
            obj0.execute((___error: any, ibprecamp: any) => {
                if (ibprecamp.length > 0) {
                    let qty = ibprecamp[0].qty;
                    let total = ibprecamp[0].total
                    resolve({ qty, total })
                }
            });
        });
    }
    closingInvoice(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession(async (error: any, sessdata: any) => {
            if (error == 1) {
                let idinvoiceObj = new AccountDelete();
                if (sessdata.type == 2) {
                    const date = new Date();
                    let cday: any = date.getDate();
                    let mday: any = date.getMonth() + 1;
                    let yday: any = date.getFullYear();
                    if (mday <= 9)
                        mday = '0' + mday;
                    if (cday <= 9)
                        cday = '0' + cday;
                    let currentd: any = yday + '-' + mday
                    let amon: any = null;
                    let bmon: any = null;
                    let cmon: any = null;
                    let pt1: any = null;
                    let pt2: any = null;
                    let pty2: any = null;
                    amon = `${date.getFullYear()}-${date.getMonth() - 1}`;
                    bmon = `${date.getFullYear()}-${date.getMonth()}`;
                    cmon = currentd;
                    pt1 = `${mday}-01-${date.getFullYear()}`;
                    pt2 = `${mday}`;
                    pty2 = `${date.getFullYear()}`;
                    let daysCount = new Date(yday, mday - 1, 0).getDate();
                    let daysCount_pt = new Date(pty2, pt2, 0).getDate();
                    let mrcDate = `${mday}-${cday}-${yday} to ${mday}-${daysCount}-${yday}`;
                    let lastDate = `${pt1} to ${pt2}-${daysCount_pt}-${pty2}`;
                    // return;
                    var last_invoice: any = 0;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT idinvoice FROM `account_invoice` WHERE `idaccount`='" + sessdata.idaccount + "' AND DATE_FORMAT(`created_at`, '%Y-%m')='" + currentd + "' AND `ai_status`='0' ORDER BY idinvoice DESC LIMIT 1";
                    obj.prepare();
                    obj.execute(async (_error: any, result: any) => {
                        if (result.length == 0) {
                            // Creating data for `invoice` table: monthwise
                            last_invoice = await idinvoiceObj.getLastInvoiceId(req, res, next)
                        }
                        else {
                            last_invoice = result[0].idinvoice;
                        }
                        if (last_invoice > 0) {
                            var totalamt: any = 0;
                            // Fetching Inbound calling data for last monthwise
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ib_t1', 'inbound', 1, '1', '1', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ib_t2', 'inbound', 2, '1', '1', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ib_t3', 'inbound', 3, '1', '1', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ib_t4', 'inbound', 4, '1', '1', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ib_t5', 'inbound', 5, '1', '1', next);
                            totalamt = await idinvoiceObj.tollFreeInAndOut(req, res, cmon, last_invoice, totalamt, 'inbound', 'call_ib_tf', '1', next)

                            //  Fetching Outbound calling data for last monthwise
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ob_t1', 'outbound', 1, '1', '2', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ob_t2', 'outbound', 2, '1', '2', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ob_t3', 'outbound', 3, '1', '2', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ob_t4', 'outbound', 4, '1', '2', next);
                            totalamt = await idinvoiceObj.getTotalCallCostAmt(req, res, cmon, totalamt, last_invoice, 'call_ob_t5', 'outbound', 5, '1', '2', next);
                            console.log("getTotalCallCostAmt call_ob_t5 total amount=>", totalamt);
                            totalamt = await idinvoiceObj.tollFreeInAndOut(req, res, cmon, last_invoice, totalamt, 'outbound', 'call_ob_tf', '2', next)

                            //Fetching Inbound SMS data for last monthwise
                            totalamt = await idinvoiceObj.smsInAndOutData(req, res, cmon, last_invoice, totalamt, 'inbound', 'mdrs_ib_tc', 'mdrs_ib_sc', '1', next)

                            //Fetching Outbound SMS data for last monthwise

                            totalamt = await idinvoiceObj.smsInAndOutData(req, res, cmon, last_invoice, totalamt, 'outbound', 'mdrs_ob_tc', 'mdrs_ob_sc', '2', next)
                            //Fetching Local Number data for last monthwise
                            totalamt = await idinvoiceObj.fetchTollFreeAndLocalNoData(req, res, cmon, last_invoice, totalamt, 'did_nn', '3', '0', '**US/CAN Local Number - Tier 1', next)
                            // Fetching Toll Free Number data for last monthwise
                            totalamt = await idinvoiceObj.fetchTollFreeAndLocalNoData(req, res, cmon, last_invoice, totalamt, 'did_tf', '3', '1', '**US/CAN Tollfree Number - Tier 1', next);
                            
                            //Fetching US/CAN Tollfree Number - Vanity
                            totalamt = await idinvoiceObj.fetchTollFreeAndLocalNoData(req, res, cmon, last_invoice, totalamt, 'US/CAN_tf_no', '3', '4', 'US/CAN Tollfree Number - Vanity', next);
                            //Fetching Shortcode Random Data 
                            totalamt = await idinvoiceObj.fetchTollFreeAndLocalNoData(req, res, cmon, last_invoice, totalamt, 'short_code_rn', '3', '5', 'Short Code Lease  - Random', next);
                            //Fetching Shortcode Random Data 
                            totalamt = await idinvoiceObj.fetchTollFreeAndLocalNoData(req, res, cmon, last_invoice, totalamt, 'short_code_vn', '3', '6', 'Short Code Lease  - Vanity', next);
                            //Fetching Shortcode Random Data 
                            totalamt = await idinvoiceObj.fetchTollFreeAndLocalNoData(req, res, cmon, last_invoice, totalamt, 'short_code_mg', '3', '7', 'Short Code Lease  - Migrated', next);

                            // Fetching MRC Local Number data
                            let getMrcLocalNoData: any = {};
                            getMrcLocalNoData = await idinvoiceObj.getMrcLocalNo(req, res, cmon, last_invoice, totalamt, next)
                            //totalamt = getMrcLocalNoData.totalamt


                            //Fetching MRC Local tollfree number data
                            let getMrcLocalTollFreeNo: any = {};
                            getMrcLocalTollFreeNo = await idinvoiceObj.getMrcLocalTollFreeNo(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getMrcLocalTollFreeNo.totalamt;

                            //Fetching Brand & Campaign data for last monthwise
                            totalamt = await idinvoiceObj.fetchBrandData(req, res, cmon, last_invoice, totalamt, next)

                            //Fetching Brand Vetting  data
                            let getBrandVettData: any = {};
                            getBrandVettData = await idinvoiceObj.getBrandVettData(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getBrandVettData.totalamt;

                            //Fetching Brand Vetting  data
                            let getBrandAppeal: any = {};
                            getBrandAppeal = await idinvoiceObj.getBrandAppeal(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getBrandAppeal.totalamt;

                            //Fetching MRC Campaign data
                            let getMrcCampData: any = {};
                            getMrcCampData = await idinvoiceObj.getMrcCampData(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getMrcCampData.totalamt;

                            //Fetching MRC Redundant Campaign
                            let getMrcredCampData: any = {};
                            getMrcCampData = await idinvoiceObj.getMrcRedCampData(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getMrcredCampData.totalamt;

                            totalamt = await idinvoiceObj.fetchCampaignData(req, res, cmon, last_invoice, totalamt, next)

                            //Fetching Campaign Review data
                            let getMrcCampReviewData: any = {};
                            getMrcCampReviewData = await idinvoiceObj.getMrcCampReviewData(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getMrcCampReviewData.totalamt;

                            totalamt = await idinvoiceObj.fetchRedCampaignData(req, res, cmon, last_invoice, totalamt, next)

                            //Fetching MRC Local SMS enable data
                            let getPhoneNoSmsEnablement: any = {};
                            getPhoneNoSmsEnablement = await idinvoiceObj.getPhoneNoSmsEnablement(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getPhoneNoSmsEnablement.totalamt;

                            // Lookup API charge log
                            let getlookupApiData: any = {};
                            getlookupApiData = await idinvoiceObj.getlookupApiData(req, res, cmon, last_invoice, totalamt, next)
                            totalamt = getlookupApiData.totalamt;

                            // Subscription Charges
                            let getSubscriptionData: any = {};
                            getSubscriptionData = await idinvoiceObj.getSubscriptionData(req, res, cmon, last_invoice, totalamt, next)
                            // totalamt = getSubscriptionData.totalamt;

                            //Fetching TAX calculation  data
                            let taxes: any = 0
                            taxes = await idinvoiceObj.geTotalTax(req, res, cmon, last_invoice, next);

                            let getextradidMrc: any = {};
                            getextradidMrc = await idinvoiceObj.getExtraDidMrc(req, res, cmon, last_invoice, next)

                            //  totalamt = getextradidMrc.cost;
                            let deductTotalAmt: number = 0;
                            if (getextradidMrc.cost == undefined || getextradidMrc.cost == 'undefined') {
                                deductTotalAmt = +taxes;
                            }
                            else {
                                deductTotalAmt = +taxes + +getextradidMrc.cost;
                            }

                            // Update Total Amount
                            let obj0005 = new ModelRawNonQuery(req, res);
                            obj0005.nonqrysql = "UPDATE `account_invoice_closing` SET `total_amount`='" + totalamt + "', `last_date`='" + lastDate + "', `mrc_date`='" + mrcDate + "' WHERE idinvoice='" + last_invoice + "'";
                            obj0005.prepare();
                            obj0005.execute((errro: any, data: any) => {
                            })
                            // Update MRC Cost
                            let mrccost: number = 0;
                            if (getMrcLocalNoData.ibpredid[0].cost > 0) {
                                mrccost = mrccost + getMrcLocalNoData.ibpredid[0].cost;
                            }
                            if (getMrcLocalTollFreeNo.ibpredidtf[0].cost > 0) {
                                mrccost = mrccost + getMrcLocalTollFreeNo.ibpredidtf[0].cost;
                            }
                            if (getMrcCampData.ibprecamp[0].cost > 0) {
                                mrccost = mrccost + getMrcCampData.ibprecamp[0].cost;
                            }
                            if (getPhoneNoSmsEnablement.smsenable[0].cost > 0) {
                                mrccost = mrccost + getPhoneNoSmsEnablement.smsenable[0].cost;
                            }
                            if (getSubscriptionData.subcost > 0) {
                                mrccost = mrccost + getSubscriptionData.subcost;
                            }

                            console.log("mrccostmrccost=>", mrccost);

                            //Fetching wallet data
                            let wallet: any = await idinvoiceObj.getwalletData(req, res, last_invoice, deductTotalAmt, next)
                            console.log("walletwallet=>", wallet);

                            let obj0006 = new ModelRawNonQuery(req, res);
                            obj0006.nonqrysql = "UPDATE `account_invoice` SET `mrc_cost`= '" + mrccost + "' WHERE idaccount = '" + sessdata.idaccount + "'";
                            obj0006.prepare();
                            obj0006.execute((__ers: any, data: any) => {
                            })
                            let toDate: any = null;
                            let fromDate: any = null;
                            toDate = `${mday}-01-${yday}`
                            fromDate = `${mday}-${daysCount}-${yday}`
                            idinvoiceObj.geTFinalAccountSummary(req, res, fromDate, toDate, last_invoice, (errorr, resp) => {
                                if (resp.status == 200) {
                                    // To Delete Account
                                    idinvoiceObj.closeCustomerAccount(req, res, last_invoice, next)
                                    let objv = new RawView(res);
                                    objv.prepare({ message: 'Copy of final Invoice send to register mail & Final invoice charges will deducted from your Credit card successfully!', data: resp.data, finalCharge: mrccost, totalamt: totalamt, previousDue: wallet.previousDue, remainingWallet: wallet.remainingWellet, taxes: taxes, getextradidMrc: getextradidMrc, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 502, message: resp.message });
                                    objv.execute();
                                }
                            });

                        }
                        else {
                            console.log("Invoice record did not found for current month");
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invoice record did not found for current month!", status: 503 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
    geTFinalAccountSummary(req: Request, res: Response, fromDate: any, toDate: any, last_invoice: any, callback: (err: any, data: any) => void) {
        let obj01 = new ModelRawQuery(req, res);
        obj01.qrysql = "SELECT `idinvoice`, `created_at`, `key`, `value`, `cost`, `category`, `subcategory`, `status`, `label`, `total_amount`, `tax`, `mrc_date`, `last_date` FROM `account_invoice_closing` WHERE `idinvoice`='" + last_invoice + "' AND status = '0'";
        obj01.prepare();
        obj01.execute((__error: any, resInv: any) => {
            if (resInv.length > 0) {
                callback(0, { data: resInv, status: 200 })
            }
            else {
                callback(0, { message: 'something went wrong.', status: 502 })
            }
        });
    }
    sendInvoicePdf(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let value = appealEvidence.closeAccountFile + req.file.filename;
                let path = req.file.path;
                path = req.file.path.replace(/\\/g, '/');
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sessdata.email + sessdata.password
                }, secret);
                let tmpData = '<p>Click the link below:</p> <a href=' + path + '>' + path + '</a>';
                tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `account_invoice` SET `invoice_pdf`= '" + req.file.filename + "',`path`= '" + value + "' WHERE idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((__ers: any, data: any) => {
                    console.log("invoice update successfully");
                })
                let objem = new ModelRawQuery(req, res);
                objem.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type` = 'close_account'";
                objem.prepare();
                objem.execute((____errorem: any, _resultem: any) => {
                    if (____errorem == 1 && _resultem.length > 0) {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT firstname , lastname, email FROM `user_profile` WHERE iduser = '" + sessdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((____errorup: any, _resultup: any) => {
                            if (____errorup == 1) {
                                const formattedTemplate = _resultem[0].template
                                    .replace('{FIRST_NAME}', _resultup[0].firstname)
                                    .replace('{LAST_NAME}', _resultup[0].lastname)
                                // var smtpTransport = nodemailer.createTransport({
                                //     service: "gmail",
                                //     host: "smtp.gmail.com",
                                //     port: 587,
                                //     secure: true,
                                //     auth: {
                                //         user: "mailto:donotreply@nglcommunications.com",
                                //         pass: "yr%5V9GB"
                                //     }
                                // });
                                var pdfAttachment = {
                                    filename: req.file.filename,
                                    path: path.replace(/\\/g, '/'),
                                    contentType: 'application/pdf'
                                };
                                // var mailOptions = {
                                //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                //     to: _resultup[0].email,
                                //     email: _resultup[0].email,
                                //     subject: _resultem[0].subject,
                                //     html: formattedTemplate,
                                //     // html: `${tmpData}`,
                                //     attachments: [pdfAttachment]
                                // }
                                // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                //     if (_emailError) {
                                //         console.log("Opps Email Not Sent!");
                                //     } else {
                                //         console.log("Email Sent Succesfully!");
                                //     }
                                // });

                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`html`,`type`,`status`,`file`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + _resultup[0].email + "', '" + parseBody(_resultem[0].subject) + "','" + parseBody(formattedTemplate) + "','Invoice PDF sent','18','" + pdfAttachment + "')";
                                obj1.prepare();
                                obj1.execute((_err: any, __result: any) => {
                                    if (_err == 1) {
                                        console.log("Email Sent Succesfully!");
                                    }
                                    else {
                                        console.log("Opps Email Not Sent!");
                                    }
                                });
                            }
                            else {
                                console.log('Account Profile Not Found at the Time Closing Invoice');
                            }
                        });
                    }
                    else {
                        console.log('Live Payment Email Template Not Found at the Time Closing Invoice');
                    }
                });
            }
            else {
                console.log("Session Error :: ", session);
            }
        });
    }
    public closeCustomerAccount(req: Request, res: Response, last_invoice: any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                if (error == 1) {
                    let con: any = "";
                    con = "`pending_deleted_date`=NOW()";
                    if (sessdata.type == 2) {
                        let obj7 = new ModelRawNonQuery(req, res);
                        obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                        obj7.prepare();
                        obj7.execute((__error: any, delSessRes: any) => {
                            console.log("All Session Removed");
                            let obj00 = new ModelRawQuery(req, res);
                            obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sessdata.idaccount + "'";
                            obj00.prepare();
                            obj00.execute((____error: any, resultIdEnPoint: any) => {
                                let endPointId: any = [];
                                for (let i of resultIdEnPoint) {
                                    endPointId.push(i.idendpoint)
                                }
                                let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                let obj01 = new ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj01.prepare();
                                obj01.execute((_____error: any, resInbound: any) => {
                                    console.log("Inbound Removed");
                                })
                                let obj02 = new ModelRawNonQuery(req, res);
                                obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj02.prepare();
                                obj02.execute((_____error: any, resOutbound: any) => {
                                    console.log("Outbound Removed");
                                })
                                let obj03 = new ModelRawNonQuery(req, res);
                                obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj03.prepare();
                                obj03.execute((_____error: any, resIp: any) => {
                                    console.log("IP Address Removed");
                                })
                                let obj04 = new ModelRawNonQuery(req, res);
                                obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj04.prepare();
                                obj04.execute((_____error: any, resRoute: any) => {
                                    console.log("Routing Removed");
                                })
                                let obj05 = new ModelRawNonQuery(req, res);
                                obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj05.prepare();
                                obj05.execute((_____error: any, resHook: any) => {
                                    console.log("Hooksetting Removed");
                                })
                            });
                            let obj8 = new ModelRawNonQuery(req, res);
                            obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                            obj8.prepare();
                            obj8.execute((___error: any, delApiRes: any) => {
                                console.log("Api Details Removed");
                                let obj9 = new ModelRawNonQuery(req, res);
                                obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                obj9.prepare();
                                obj9.execute((____error: any, result: any) => {
                                    console.log("All Connection Removed");
                                })
                            })
                        });

                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `account_service` SET `as_status` = '0' where idaccount ='" + sessdata.idaccount + "'";
                        obj.prepare();
                        obj.execute((_error1: any, result: any) => {
                            console.log("service suspended successfuly");
                            let obj10 = new ModelRawNonQuery(req, res);
                            obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '1', " + con + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                            obj10.prepare();
                            obj10.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    resolve({ message: 'Account And Other Data Deleted!', status: 200 });
                                }
                                else {
                                    resolve({ message: 'Something Went Wrong With Delete Customer!', status: 502 });
                                }
                            });
                        });
                        let obj009 = new ModelRawNonQuery(req, res);
                        obj009.nonqrysql = "UPDATE `account_invoice_closing` SET `status` = '1' WHERE `idinvoice` = '" + last_invoice + "'";
                        obj009.prepare();
                        obj009.execute((_____error: any, resInbound: any) => {
                            console.log("Update closing invoice status");
                        })
                        let obj010 = new ModelRawNonQuery(req, res);
                        obj010.nonqrysql = "UPDATE `account_invoice` SET `ai_status` = '1' WHERE `idinvoice` = '" + last_invoice + "'";
                        obj010.prepare();
                        obj010.execute((_____error: any, resInbound: any) => {
                            console.log("Update Account invoice status");
                        })
                    }
                    else {
                        console.log("You have not access to Delete Account!");
                    }
                }
                else {
                    console.log("Session", session);
                }
            });
        });
    }

    public deleteCusAccount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let objS = new ModelRawQuery(req, res);
                req.query = {};
                objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`='" + sessdata.idaccount + "'";
                objS.prepare();
                objS.execute((errKey: any, delKey: any) => {
                    if (errKey == 1) {
                        if (delKey.length > 0) {
                            for (let x of delKey) {
                                sessiondata.delete(x.authKey);
                            }
                        }
                        let objv = new RawView(res);
                        objv.prepare({ message: "Your Acoount Deleted Successfully!", status: 200 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }

    adminCloseCustomerAccount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let localToken: any
                    let invoNumber: any
                    if (sdata.checkvalue) {
                        var options = {
                            'method': 'POST',
                            'url': urlLogin,
                            'headers': {
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                "apiusername": apiusername,
                                "apipassword": apipassword
                            })

                        };
                        request(options, function (err: any, response: any) {
                            if (response.body) {
                                let data1: any = JSON.parse(response.body);
                                localToken = data1.result.token;
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "SELECT idaccount, invoice_number, idinvoice FROM `account_invoice` WHERE idaccount ='" + sdata.sesidaccount + "' AND ai_status ='1' ORDER BY idinvoice DESC LIMIT 1";
                                obj.prepare();
                                obj.execute((_error: any, invoceRes: any) => {
                                    if (_error == 1) {
                                        if (invoceRes.length > 0) {
                                            invoNumber = invoceRes[0].invoice_number;
                                            /** To Check tax comit*/
                                            let pstFld: any;
                                            pstFld = JSON.stringify({
                                                "billingtype": "billed",
                                                "document": "doc_" + invoNumber,
                                                "invoice": "doc_" + invoNumber
                                            })
                                            let options = {
                                                "method": "POST",
                                                "url": urlcommit,
                                                "headers": {
                                                    "content-type": "application/json",
                                                    "Cookie": 'AuthToken=' + localToken
                                                },
                                                body: pstFld
                                            }
                                            request(options, function (___error: any, response: any) {
                                                if (___error == null) {
                                                    console.log("Invoice tax calculation updated and committed successfully for ::" + invoNumber);
                                                    let fun = new AccountDelete();
                                                    fun.DeleteAccount(req, res, sdata, next);
                                                }
                                                else {
                                                    console.log("Invoice tax not committed ::" + invoNumber);
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Invoice tax not committed for!", status: 502 });
                                                    objv.execute();

                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Record Not Found!", status: 501 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something went wrong with Record Found!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                console.log("Not Logged In ::" + invoNumber);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Tax not committed!", status: 502 });
                                objv.execute();
                            }
                        })
                    }
                    else {
                        let fun = new AccountDelete();
                        fun.DeleteAccount(req, res, sdata, next);
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getInvoicePdfForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idinvoice`,`idaccount`,`path`,`invoice_pdf` FROM `account_invoice`";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invoice Fetched Successfully", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Getting Invoice!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    DeleteAccount(req: Request, res: Response, sdata: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let allDID: any = [];
                let allDIDId: any = [];
                let allBrandId: any = [];
                let allCampaign: any = [];
                let allIdUsers: any = [];
                // Delete DID
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='1'";
                obj0.prepare();
                obj0.execute((_errorDID: any, resultDID: any) => {
                    if (_errorDID == 1) {
                        for (let d of resultDID) {
                            allDIDId.push(d.iddid);
                            allDID.push(d.did);
                        }
                        if (allDIDId.length > 0) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '2' WHERE `iddid` IN(" + allDIDId + ")";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    console.log("All DID Removed", allDIDId);
                                }
                            });
                        }
                    }
                });

                let obju = new ModelRawQuery(req, res);
                obju.qrysql = "SELECT `iduser` from user WHERE `idaccount`=" + sdata.sesidaccount + "";
                obju.prepare();
                obju.execute((_uerror: any, iduserRes: any) => {
                    if (iduserRes.length > 0) {
                        for (let u of iduserRes) {
                            allIdUsers.push(u.iduser)
                        }
                        if (allIdUsers.length > 0) {
                            // Delete Campaign
                            let objc = new ModelRawQuery(req, res);
                            objc.qrysql = "SELECT `id_campaign` from campaign WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objc.prepare();
                            objc.execute((_cerror: any, campaignRes: any) => {
                                if (campaignRes.length > 0) {
                                    for (let c of campaignRes) {
                                        allCampaign.push(c.id_campaign)
                                    }
                                    let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '2' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                    obj1.prepare();
                                    obj1.execute((_errorCamp: any, resultCamp: any) => {
                                        if (resultCamp.length > 0) {
                                            console.log("All Campaign Removed", allCampaign);
                                        }
                                    });
                                }
                            });
                            // Delete Brand
                            let objb = new ModelRawQuery(req, res);
                            objb.qrysql = "SELECT `idbrand` from brand WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objb.prepare();
                            objb.execute((_errB: any, brandRe: any) => {
                                if (brandRe.length > 0) {
                                    for (let b of brandRe) {
                                        allBrandId.push(b.idbrand)
                                    }
                                    let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '2' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                    obj2.prepare();
                                    obj2.execute((_errorBrand: any, resultBrand: any) => {
                                        if (resultBrand.length > 0) {
                                            console.log("All Brand Removed", allBrandId);
                                        }
                                    });
                                }
                            })
                        }
                    }
                })
                // add here delete feature for session,api and connection.
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `session` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                obj.prepare();
                obj.execute((__error: any, delSessRes: any) => {
                    console.log("All Session Remove");
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                    obj0.prepare();
                    obj0.execute((___error: any, delApiRes: any) => {
                        console.log("Api Details Remove");
                        // let obj1 = new ModelRawNonQuery(req, res);
                        // obj1.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                        // obj1.prepare();
                        // obj1.execute((____error: any, result: any) => {
                        //     console.log("All Connection Remove");
                        // })
                    })
                })

                // closed here
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + sdata.isDeleted + "', `deleted_date`=NOW() WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj2.prepare();
                obj2.execute((_errorDEL: any, resultDEL: any) => {
                    if (_errorDEL == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: [], message: "Account Successfully Deleted!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Release DID From Account Delete Process!", status: 502 });
                        objv.execute();
                    }
                });

                let obj00 = new ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj00.prepare();
                obj00.execute((____error: any, resultIdEnPoint: any) => {
                    let endPointId: any = [];
                    for (let i of resultIdEnPoint) {
                        endPointId.push(i.idendpoint)
                    }
                    let endPointIds = endPointId.length > 0 ? endPointId : "''";
                    let obj01 = new ModelRawNonQuery(req, res);
                    obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj01.prepare();
                    obj01.execute((_____error: any, resInbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Inbound Restored");
                        }
                        else {
                            console.log("Inbound Removed");
                        }
                    })
                    let obj02 = new ModelRawNonQuery(req, res);
                    obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj02.prepare();
                    obj02.execute((_____error: any, resOutbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Outbound Restored");
                        }
                        else {
                            console.log("OutBound Removed");
                        }
                    })

                    let obj03 = new ModelRawNonQuery(req, res);
                    obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj03.prepare();
                    obj03.execute((_____error: any, resIp: any) => {
                        console.log("IP Address Removed");
                    })
                    let obj04 = new ModelRawNonQuery(req, res);
                    obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj04.prepare();
                    obj04.execute((_____error: any, resRoute: any) => {
                        console.log("Routing Removed");
                    })
                    let obj05 = new ModelRawNonQuery(req, res);
                    obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj05.prepare();
                    obj05.execute((_____error: any, resHook: any) => {
                        console.log("Hooksetting Removed");
                    })
                })
                let obj03 = new ModelRawNonQuery(req, res);
                obj03.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj03.prepare();
                obj03.execute((____error: any, result: any) => {

                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}