import { Request, Response, NextFunction } from "express";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { Res406 } from "../lib/view/406";
import { SMTPDetails, ShortCodeCampaign } from "../config/setting.config";
import { parseBody } from "./markError";
import { APIBase } from "./APIBase";
const SCampaign = new ShortCodeCampaign();
const SMTP = new SMTPDetails();



export class ShortCodeNumber extends AppRoute {
    constructor() {
        super();
    }


    GetContentType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "Select `display_name`,`value` From `sc_content_type`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Content Type Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    GetMessageType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "Select `display_name`,`value` From `sc_message_type`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Message Type Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    GetSubscriptiomType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "Select `display_name`,`value` From `sc_subscription_type`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Message Type Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    SaveShortCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let sdata = JSON.parse(req.body.data);
                    let campname = sdata.previosFile ? (sdata.data.campaignInfo + '-copy').trim() : sdata.data.campaignInfo.trim();
                    // let randomNum = Math.floor(10000000 + Math.random() * 90000000);
                    // let scId = 'SC' + String(randomNum).padStart(8, '0');
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    const numeric = '0123456789';
                    const alphabetLength = alphabet.length;
                    const numericLength = numeric.length;
                    const length = 8;
                    let scId = 'SC';

                    for (let i = 0; i < length; i++) {
                        const isAlphabetic = Math.random() < 0.5; // Randomly choose alphabetic or numeric
                        const randomIndex = isAlphabetic ? Math.floor(Math.random() * alphabetLength) : Math.floor(Math.random() * numericLength);
                        const charToAdd = isAlphabetic ? alphabet[randomIndex] : numeric[randomIndex];
                        scId += charToAdd;
                    }
                    // const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);

                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        let FullName = result[0].firstname + ' ' + result[0].lastname;
                        if (_error == 1) {
                            // main table
                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "INSERT INTO `sc_campaign_profile` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status`,`customer_name`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + scId + "','" + parseBody(campname) + "','" + sdata.data.migrated + "','" + parseBody(sdata.data.campaignview.trim()) + "','" + parseBody(sdata.data.optout.trim()) + "','" + parseBody(sdata.data.optoutmt.trim()) + "','" + parseBody(sdata.data.helpmt.trim()) + "','" + parseBody(sdata.data.email.trim()) + "','" + parseBody(sdata.data.weburl.trim()) + "','" + sdata.data.phone + "','" + parseBody(sdata.data.tcurl.trim()) + "','" + parseBody(sdata.data.tctxt.trim()) + "','" + parseBody(sdata.data.contact) + "','" + parseBody(sdata.data.comemail) + "','" + parseBody(sdata.data.notes.trim()) + "','1','" + parseBody(FullName) + "')"
                            obj2.prepare();
                            obj2.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "Select `id_profile` From `sc_campaign_profile` WHERE `sc_campaign_unique_id` = '" + scId + "'";
                                    obj.prepare();
                                    obj.execute((error: any, result: any) => {
                                        if (error == 1) {
                                            // content definiton
                                            if (sdata.Content.length === 0) {
                                                console.log('No data found for content data')

                                            } else {
                                                let obj3 = new ModelRawNonQuery(req, res);
                                                let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                                for (let i = 0; i < sdata.Content.length; i++) {
                                                    const data = sdata.Content[i];
                                                    qry2 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + parseBody(data.call_to_action.trim()) + "','" + parseBody(data.opt_in_message.trim()) + "','" + parseBody(data.example_message.trim()) + "'),"
                                                }
                                                obj3.nonqrysql = qry2.slice(0, -1)
                                                obj3.prepare();
                                                obj3.execute((error: any, result: any) => { })
                                            }

                                            // carrier coverage
                                            // if (sdata.Carrier.length === 0) {
                                            //     console.log("No carrier coverage found")
                                            // } else {
                                            //     let obj4 = new ModelRawNonQuery(req, res);
                                            //     let qry3 = "INSERT INTO `sc_campaign_carrier_coverage` (`iduser`,`idaccount`,`profile_id`,`sc_carrier_coverage`,`rate`) VALUES ";
                                            //     for (let i = 0; i < sdata.Carrier.length; i++) {
                                            //         const data = sdata.Carrier[i];
                                            //         qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + data.display_name + "','" + data.rate + "'),"
                                            //     }
                                            //     obj4.nonqrysql = qry3.slice(0, -1)
                                            //     obj4.prepare();
                                            //     obj4.execute((error: any, result: any) => { })
                                            // }

                                            // Files
                                            if (!sdata.previosFile || sdata.previosFile.length === 0) {
                                                console.log('no data found')
                                            } else {
                                                let obj0 = new ModelRawNonQuery(req, res);
                                                let qry0 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                                for (let i = 0; i < sdata.previosFile.length; i++) {
                                                    const file = sdata.previosFile[i];
                                                    qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + file.name + "','" + file.file_path + "'),"
                                                }
                                                obj0.nonqrysql = qry0.slice(0, -1)
                                                obj0.prepare();
                                                obj0.execute((_error: any, result: any) => {
                                                    console.log("Data Inserted Successfully!");
                                                })
                                            }
                                            if (req.files.length === 0) {
                                                console.log('No Files found')
                                            } else {
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                let qry1 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                                for (const file of (Array.isArray(req.files) ? req.files : Object.values(req.files)) as any[]) {
                                                    const filePath = SCampaign.shortcode + file.filename;
                                                    qry1 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + file.filename + "','" + filePath + "'),"
                                                }
                                                obj1.nonqrysql = qry1.slice(0, -1)
                                                obj1.prepare();
                                                obj1.execute((_error: any, result: any) => {
                                                    console.log("Data Inserted Successfully!");
                                                });
                                            }

                                            // log
                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','1','REQUEST_CREATED','ShortCode Campaign Request Created Successfully', '" + result[0].id_profile + "')";
                                            obj0.prepare();
                                            obj0.execute((error: any, result: any) => {
                                                if (error == 1) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "ShortCode Campaign Created Successfully", status: 201 });
                                                    objv.execute();
                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "ShortCode Campaign Not Created!", status: 502 });
                                                    objv.execute();
                                                }
                                            })
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong", status: 502 });
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong", status: 502 });
                                    objv.execute();
                                }
                            })
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    GetCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let condition: any = '';
                if (sessdata.type == 1)
                    condition += ''
                if (sessdata.type == 2)
                    condition += "WHERE idaccount='" + sessdata.idaccount + "'"

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select `id_profile`,`idaccount`,`iduser`,`sc_campaign_unique_id`,`campaign_name`,`shortcode_number`,`created_at`,`status`,`customer_name`,`approved_date`,`reject_date`,`number_mapped_date`,`process_started_date`,`process_rejected_date`,`process_approved_date` From `sc_campaign_profile` " + condition + "";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "ShortCode Campaign Fetched Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    GetSCData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error === 1) {
                if (sessdata.type === 2 || sessdata.type === 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount`,`iduser`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status` FROM `sc_campaign_profile` WHERE `id_profile` = '" + req.query.type + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error === 1) {
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT `message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message` FROM `sc_content_defination` WHERE `profile_id` = '" + req.query.type + "'";
                            obj1.prepare();
                            obj1.execute((_err: any, res1: any) => {
                                if (_err === 1) {
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = "SELECT `filename`,`file_path` FROM `sc_campaign_files` WHERE `profile_id` = '" + req.query.type + "' ";
                                    obj2.prepare();
                                    obj2.execute((_errr: any, result2: any) => {
                                        if (_errr === 1) {
                                            let obj3 = new ModelRawQuery(req, res);
                                            obj3.qrysql = "SELECT `event_desc`,`description`,`event_type`,`created_at`,`profile_id` FROM `sc_campaign_profile_log` WHERE `profile_id` = '" + req.query.type + "' ";
                                            obj3.prepare();
                                            obj3.execute((_errr: any, resul: any) => {
                                                if (_errr === 1) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ data: result, data1: res1, data2: result2, data3: resul, message: "Short Code Campaign Details Fetched Successfully!", status: 201 });
                                                    objv.execute();

                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                    objv.execute();
                                                }
                                            })
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    CopySc_ID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj0.prepare();
                    obj0.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let FullName = result[0].firstname + ' ' + result[0].lastname;
                            // let randomNum = Math.floor(10000000 + Math.random() * 90000000);
                            // let scId = 'SC' + String(randomNum).padStart(8, '0');
                            const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                            const numeric = '0123456789';
                            const alphabetLength = alphabet.length;
                            const numericLength = numeric.length;
                            const length = 8;
                            let scId = 'SC';

                            for (let i = 0; i < length; i++) {
                                const isAlphabetic = Math.random() < 0.5;
                                const randomIndex = isAlphabetic ? Math.floor(Math.random() * alphabetLength) : Math.floor(Math.random() * numericLength);
                                const charToAdd = isAlphabetic ? alphabet[randomIndex] : numeric[randomIndex];
                                scId += charToAdd;
                            }
                            let obj = new ModelRawQuery(req, res);
                            let key = req.body.data;

                            // Campaign Profile
                            obj.qrysql = "SELECT `campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status` FROM `sc_campaign_profile` WHERE `id_profile` = '" + key + "'";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (error == 1) {
                                    let obj0 = new ModelRawNonQuery(req, res);
                                    obj0.nonqrysql = "INSERT INTO `sc_campaign_profile` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status`,`customer_name`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + scId + "','" + parseBody(result[0].campaign_name + '-copy') + "','" + result[0].migrated_campaign + "','" + parseBody(result[0].campaign_overview) + "','" + parseBody(result[0].opt_out_keyword) + "','" + parseBody(result[0].opt_out_mt) + "','" + parseBody(result[0].help_mt) + "','" + parseBody(result[0].email) + "','" + parseBody(result[0].web_url) + "','" + parseBody(result[0].phone_number) + "','" + parseBody(result[0]['t&c_web_url']) + "','" + parseBody(result[0]['t&c_text']) + "','" + parseBody(result[0].contacts) + "','" + parseBody(result[0].compliance_poc_email) + "','" + parseBody(result[0].notes) + "','1','" + parseBody(FullName) + "')";
                                    obj0.prepare();
                                    obj0.execute((_err: any, result: any) => {
                                        let obj = new ModelRawQuery(req, res);
                                        obj.qrysql = "Select `id_profile` From `sc_campaign_profile` WHERE `sc_campaign_unique_id` = '" + scId + "'";
                                        obj.prepare();
                                        obj.execute((error: any, result: any) => {
                                            if (error == 1) {
                                                // Log
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','1','REQUEST_CREATED','ShortCode Campaign Request Created Successfully', '" + result[0].id_profile + "')";
                                                obj1.prepare();
                                                obj1.execute((error: any, result: any) => { })

                                                // Content Definition
                                                let obj2 = new ModelRawQuery(req, res);
                                                obj2.qrysql = "SELECT `message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message` FROM `sc_content_defination` WHERE `profile_id` = '" + key + "'";
                                                obj2.prepare();
                                                obj2.execute((err: any, res1: any) => {
                                                    if (err == 1) {
                                                        if (res1.length == 0) {
                                                            console.log("No Data Found")
                                                        } else {
                                                            let obj2 = new ModelRawNonQuery(req, res);
                                                            let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                                            res1.forEach((data: any) => {
                                                                qry2 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + parseBody(data.call_to_action) + "','" + parseBody(data.opt_in_message) + "','" + parseBody(data.example_message) + "'), ";
                                                            });
                                                            obj2.nonqrysql = qry2.slice(0, -2);
                                                            obj2.prepare();
                                                            obj2.execute((error1: any, res1: any) => { })
                                                        }
                                                    } else {
                                                        console.log("Issue in getting the data from content definition")
                                                    }
                                                })

                                                // files 
                                                let obj3 = new ModelRawQuery(req, res);
                                                obj3.qrysql = "SELECT `filename` ,`file_path` FROM `sc_campaign_files` WHERE `profile_id` = '" + key + "' ";
                                                obj3.prepare();
                                                obj3.execute((_errr: any, result2: any) => {
                                                    if (_errr == 1) {

                                                        if (result2.length === 0) {
                                                            console.log("No Data Found")
                                                        } else {
                                                            let obj4 = new ModelRawNonQuery(req, res);
                                                            let qry0 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`, `filename`, `file_path`) VALUES";
                                                            result2.forEach((ele: any) => {
                                                                qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + ele.filename + "','" + ele.file_path + "'),";
                                                            });

                                                            obj4.nonqrysql = qry0.slice(0, -1);
                                                            obj4.prepare();
                                                            obj4.execute((__error: any, result: any) => {
                                                                if (__error == 1) {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "ShortCode Campaign Copied Successfully", status: 201 });
                                                                    objv.execute();
                                                                } else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "ShortCode Campaign Not Created!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            })
                                                        }
                                                    } else {
                                                        console.log("Issue in getting the data from files")

                                                    }
                                                })

                                                // carrier coverage
                                                // let obj5 = new ModelRawQuery(req, res);
                                                // obj5.qrysql = "SELECT `sc_carrier_coverage`,`rate` FROM `sc_campaign_carrier_coverage` WHERE `profile_id` = '" + key + "' ";
                                                // obj5.prepare();
                                                // obj5.execute((_errr: any, result2: any) => {
                                                //     if (_errr == 1) {

                                                //         if (result2.length === 0) {
                                                //             console.log("No Data Found")
                                                //         } else {
                                                //             let obj6 = new ModelRawNonQuery(req, res);
                                                //             let qry0 = "INSERT INTO `sc_campaign_carrier_coverage` (`iduser`, `idaccount`, `profile_id`, `rate`, `sc_carrier_coverage`) VALUES";
                                                //             result2.forEach((ele: any) => {
                                                //                 qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + ele.rate + "','" + ele.sc_carrier_coverage + "'),";
                                                //             });

                                                //             obj6.nonqrysql = qry0.slice(0, -1);
                                                //             obj6.prepare();
                                                //             obj6.execute((__error: any, result: any) => {
                                                //                 if (__error == 1) {
                                                //                     let objv = new RawView(res);
                                                //                     objv.prepare({ message: "ShortCode Campaign Copied Successfully", status: 201 });
                                                //                     objv.execute();
                                                //                 } else {
                                                //                     let objv = new RawView(res);
                                                //                     objv.prepare({ message: "ShortCode Campaign Not Created!", status: 502 });
                                                //                     objv.execute();
                                                //                 }
                                                //             })
                                                //         }
                                                //     } else {
                                                //         console.log("Issue in getting the data from carrier")

                                                //     }
                                                // })
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong", status: 502 });
                                                objv.execute();
                                            }
                                        })

                                    })

                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong", status: 502 });
                                    objv.execute();
                                }
                            })
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    UpdateCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let sdata = JSON.parse(req.body.data);
                    //const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);

                    // For Files 
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `sc_campaign_files` WHERE `profile_id` = '" + sdata.id + "'";
                    obj0.prepare();
                    obj0.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            if (!sdata.previosFile || sdata.previosFile.length === 0) {
                                console.log('no data found')
                            } else {
                                let obj1 = new ModelRawNonQuery(req, res);
                                let qry0 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                for (let i = 0; i < sdata.previosFile.length; i++) {
                                    const file = sdata.previosFile[i];
                                    qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + file.name + "','" + file.file_path + "'),"
                                }
                                obj1.nonqrysql = qry0.slice(0, -1)
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    console.log("Data Inserted Successfully!");
                                })
                            }
                            if (req.files.length === 0) {
                                console.log('No Files found')
                            } else {
                                let obj2 = new ModelRawNonQuery(req, res);
                                let qry1 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                for (const file of (Array.isArray(req.files) ? req.files : Object.values(req.files)) as any[]) {
                                    const filePath = SCampaign.shortcode + file.filename;
                                    qry1 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + file.filename + "','" + filePath + "'),"
                                }
                                obj2.nonqrysql = qry1.slice(0, -1)
                                obj2.prepare();
                                obj2.execute((_error: any, result: any) => { })
                            }
                        } else {
                            console.log("Issue in deletion of the files")
                        }
                    })

                    // For content definition
                    let obj3 = new ModelRawNonQuery(req, res);
                    obj3.nonqrysql = "DELETE FROM `sc_content_defination` WHERE `profile_id` = '" + sdata.id + "'";
                    obj3.prepare();
                    obj3.execute((error: any, result: any) => {
                        if (error == 1) {
                            if (sdata.Content.length === 0) {
                                console.log('No data found for content data')
                            } else {
                                let obj4 = new ModelRawNonQuery(req, res);
                                let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                for (let i = 0; i < sdata.Content.length; i++) {
                                    const data = sdata.Content[i];
                                    qry2 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + parseBody(data.call_to_action.trim()) + "','" + parseBody(data.opt_in_message.trim()) + "','" + parseBody(data.example_message.trim()) + "'),"
                                }
                                obj4.nonqrysql = qry2.slice(0, -1)
                                obj4.prepare();
                                obj4.execute((error: any, result: any) => { })
                            }

                        } else {
                            console.log("Issue in deletion of the content definition")
                        }
                    })

                    // carrier Coverage
                    // let obj4 = new ModelRawNonQuery(req, res);
                    // obj4.nonqrysql = "DELETE FROM `sc_campaign_carrier_coverage` WHERE `profile_id` = '" + sdata.id + "'";
                    // obj4.prepare();
                    // obj4.execute((error: any, result: any) => {
                    //     if (error == 1) {
                    //         if (sdata.Carrier.length === 0) {
                    //             console.log("No carrier coverage found")
                    //         } else {
                    //             let obj5 = new ModelRawNonQuery(req, res);
                    //             let qry3 = "INSERT INTO `sc_campaign_carrier_coverage` (`iduser`,`idaccount`,`profile_id`,`sc_carrier_coverage`,`rate`) VALUES ";
                    //             for (let i = 0; i < sdata.Carrier.length; i++) {
                    //                 const data = sdata.Carrier[i];
                    //                 qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + data.display_name + "','" + data.rate + "'),"
                    //             }
                    //             obj5.nonqrysql = qry3.slice(0, -1)
                    //             obj5.prepare();
                    //             obj5.execute((error: any, result: any) => { })
                    //         }
                    //     } else {
                    //         console.log("Issue in deletion of the carrier coverage")
                    //     }
                    // })

                    // update main table
                    let obj6 = new ModelRawNonQuery(req, res);
                    obj6.nonqrysql = "UPDATE sc_campaign_profile SET `campaign_name` = '" + parseBody(sdata.data.campaignInfo.trim()) + "', `migrated_campaign` = '" + sdata.data.migrated + "', `campaign_overview` = '" + parseBody(sdata.data.campaignview.trim()) + "', `opt_out_keyword` = '" + parseBody(sdata.data.optout.trim()) + "', `opt_out_mt` = '" + parseBody(sdata.data.optoutmt.trim()) + "', `help_mt` = '" + parseBody(sdata.data.helpmt.trim()) + "', `email` = '" + parseBody(sdata.data.email.trim()) + "', `web_url` = '" + parseBody(sdata.data.weburl.trim()) + "', `phone_number` = '" + parseBody(sdata.data.phone) + "', `t&c_web_url` = '" + parseBody(sdata.data.tcurl.trim()) + "', `t&c_text` = '" + parseBody(sdata.data.tctxt.trim()) + "', `contacts` = '" + parseBody(sdata.data.contact) + "', `compliance_poc_email` = '" + parseBody(sdata.data.comemail) + "', `notes` = '" + parseBody(sdata.data.notes.trim()) + "', `status` = '1',`updated_at`=NOW()  WHERE `id_profile` = '" + sdata.id + "'";
                    obj6.prepare();
                    obj6.execute((error: any, result: any) => { })

                    // log 
                    let obj7 = new ModelRawNonQuery(req, res);
                    obj7.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','8','REQUEST_UPDATED','ShortCode Campaign Request Updated Successfully', '" + sdata.id + "')";
                    obj7.prepare();
                    obj7.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, message: "ShortCode Campaign Updated Successfully!" });
                            objv.execute();

                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something Went Wrong While updating ShortCode Campaign!" });
                            objv.execute();

                        }
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    RejectCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '2',`reject_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.id + "'";
                    obj1.prepare();
                    obj1.execute((errors: any, result: any) => {
                        if (errors == 1) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `email` FROM `user_profile` WHERE `iduser`='" + sdata.iduser + "'";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES ('" + sdata.iduser + "','" + sdata.idaccount + "','" + SMTP.from + "','" + result[0].email + "', '" + parseBody(SMTP.RejectSubject) + "','" + parseBody(sdata.reject_text.trim()) + "','ShortCode Campaign Request Rejected','21','" + parseBody(sdata.reject_text.trim()) + "')";
                                    obj1.prepare();
                                    obj1.execute((_err: any, __result: any) => {
                                        if (_err == 1) {
                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','2','REQUEST_REJECTED','" + parseBody(sdata.reject_text.trim()) + "', '" + sdata.id + "')";
                                            obj0.prepare();
                                            obj0.execute((error: any, result: any) => {
                                                if (error == 1) {
                                                    let objv0 = new RawView(res);
                                                    objv0.prepare({ status: 201, message: "ShortCode Campaign Rejected  Successfully." });
                                                    objv0.execute();
                                                }
                                                else {
                                                    let objv0 = new RawView(res);
                                                    objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                                    objv0.execute();
                                                }
                                            });
                                        } else {
                                            let objvs = new RawView(res);
                                            objvs.prepare({ message: "Something Went Wrong While Inserting Data !", status: 503 });
                                            objvs.execute();
                                        }
                                    })
                                } else {
                                    let objvs = new RawView(res);
                                    objvs.prepare({ message: "Something Went Wrong!", status: 503 });
                                    objvs.execute();
                                }
                            })
                        } else {
                            let objvs = new RawView(res);
                            objvs.prepare({ message: "Something Went Wrong!", status: 503 });
                            objvs.execute();
                        }
                    })
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    ApproveCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    // let obj0 = new ModelRawQuery(req, res);
                    // obj0.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sdata.idaccount + "' AND `balance` + `credit_limit` >= '" + sdata.rates + "'"
                    // obj0.prepare();
                    // obj0.execute((walletError: any, wallet: any) => {
                    //if (walletError == 1 && wallet.length > 0) {
                    //let rate = new APIBase();
                    //rate.checkBalance(req, res, sdata.idaccount, sdata.rates, (walletError, wallet) => {
                    //if (walletError == 1) {
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '3',`approved_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.id + "'";
                    obj1.prepare();
                    obj1.execute((errors: any, result: any) => {
                        if (errors == 1) {
                            // To update the wallet amount
                            // let objv1 = new ModelRawNonQuery(req, res);
                            // objv1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + sdata.rates + " WHERE `idaccount`='" + sdata.idaccount + "'"
                            // objv1.prepare();
                            // objv1.execute((wallet_error, wallet_success) => {
                            //     // To update the wallet transaction log
                            //     let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                            //     iQry += "`idaccount`=" + sdata.idaccount + ", "
                            //     iQry += "`amount`='-" + sdata.rates + "', "
                            //     iQry += "`purpose`='Wallet amount successfully updated for shortcode', "
                            //     iQry += "`status`=1;"

                            //     let objWL = new ModelRawNonQuery(req, res);
                            //     objWL.nonqrysql = iQry
                            //     objWL.prepare()
                            //     objWL.execute((error: any, result: any) => {
                            //         console.log("Wallet Updated Successfully!");
                            //     });
                            // });
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','3','REQUEST_APPROVED','ShortCode Campaign Request Approved Successfully', '" + sdata.id + "')";
                            obj0.prepare();
                            obj0.execute((error: any, result: any) => {
                                if (error == 1) {
                                    let objv0 = new RawView(res);
                                    objv0.prepare({ status: 201, message: "ShortCode Campaign Approved  Successfully." });
                                    objv0.execute();
                                }
                                else {
                                    let objv0 = new RawView(res);
                                    objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                    objv0.execute();
                                }
                            });

                        } else {
                            let objvs = new RawView(res);
                            objvs.prepare({ message: "Something Went Wrong!", status: 503 });
                            objvs.execute();
                        }
                    })
                    // } else {
                    //     let objv = new RawView(res);
                    //     objv.prepare({ error_code: 0, error: walletError, message: "Insufficient Balance.", status: 503 });
                    //     objv.execute();
                    // }
                    // });
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    ShortCodeFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let obj = new ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== undefined ? " AND `idaccount`='" + data.idaccount + "'" : '';
                }

                if (sessdata.type == 2)
                    conditionU += "`idaccount`=" + sessdata.idaccount + "";


                if (data.requestid) {
                    condition += '`sc_campaign_unique_id` LIKE "%' + parseBody(data.requestid) + '%" AND ';
                }
                if (data.user) {
                    condition += '`customer_name` LIKE "%' + parseBody(data.user) + '%" AND ';
                }
                if (data.campaignname) {
                    condition += '`campaign_name` LIKE "%' + parseBody(data.campaignname) + '%" AND ';
                }

                if (data.status) {
                    condition += '`status` LIKE "%' + parseBody(data.status) + '%" AND ';
                }

                if (data.from && data.to) {
                    condition += '`created_at` BETWEEN "' + data.from + ' 00:00:00" AND "' + data.to + ' 23:59:59" AND ';
                }

                if (data.filter_type == "Pending Review")
                    condition += '`status`="1" AND ';

                if (data.filter_type == "Rejected")
                    condition += '`status`="2" AND ';

                if (data.filter_type == "Approved")
                    condition += '`status`="3" AND ';

                if (data.filter_type == "Number Mapped")
                    condition += '`status`="4" AND ';

                if (data.filter_type == "SC Campaign Profile Process Started")
                    condition += '`status`="5" AND ';

                if (data.filter_type == "SC Campaign Profile Approved")
                    condition += '`status`="6" AND ';

                if (data.filter_type == "SC Campaign Profile Rejected")
                    condition += '`status`="7" AND ';

                if (data.status == "0")
                    condition += '`status`="0" AND ';

                if (data.status == "1")
                    condition += '`status`="1" AND ';

                if (data.status == "2")
                    condition += '`status`="2" AND ';

                if (data.status == "3")
                    condition += '`status`="3" AND ';

                if (data.status == "4")
                    condition += '`status`="4" AND ';

                if (data.status == "5")
                    condition += '`status`="5" AND ';

                if (data.status == "6")
                    condition += '`status`="6" AND ';

                if (data.status == "7")
                    condition += '`status`="7" AND ';

                if (!data.status || data.filter_type == " ")
                    condition += '';

                obj.qrysql = "Select `idaccount`,`iduser`,`sc_campaign_unique_id`,`campaign_name`,`id_profile`,`shortcode_number`,`created_at`,`status`,`customer_name`,`approved_date`,`reject_date`,`number_mapped_date`,`process_started_date`,`process_rejected_date`,`process_approved_date` From `sc_campaign_profile` WHERE " + condition + " " + conditionU;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "ShortCode Campaign List Fetched Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetched ShortCode Campaign   List!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    CarrierCoverage(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `display_name`,`rate` FROM `sc_carrier_coverage`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!" });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    get_scbatchId(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT bid.`batch_id_unique`,bid.`created_at`,bid.`filepath`, sbr.`id_batch`, sbr.`sc_campaign_unique_id` FROM `sc_batch_id` bid LEFT JOIN `sc_batchid_request` sbr ON bid.id_batch = sbr.id_batch ORDER BY bid.`id_batch` DESC";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "ShortCode List Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    sc_numberList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let conditionU = '';
                if (sessData.type == 1)
                    conditionU += '';

                if (sessData.type == 2)
                    conditionU += "scp.`idaccount`=" + sessData.idaccount + "";

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT DISTINCT scp.`iduser`,scp.`idaccount`,scp.`sc_campaign_unique_id`,scp.`shortcode_number`,scp.`customer_name`, scp.`status`, scp.`process_rejected_date`, scp.`process_approved_date`,sr.`sc_type`,sr.`connection`, sbr.`sc_campaign_unique_id`, sbr.`batch_id_unique` FROM `sc_campaign_profile` scp LEFT JOIN `sc_request` sr ON scp.id_profile = sr.profile_id LEFT JOIN `sc_batchid_request` sbr ON scp.`sc_campaign_unique_id` = sbr.`sc_campaign_unique_id` WHERE scp.status IN ('6', '7') AND " + conditionU + "";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'ShortCode Number Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                })

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }

    csvForNumberMap(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    const requestID = "'" + sdata.requestId.join("','") + "'";
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT scp.sc_campaign_unique_id AS SC_Request_ID, scp.campaign_name AS Campaign_Name, scp.shortcode_number AS ShortCode_Number, CASE WHEN scp.migrated_campaign='1' THEN 'Standard rate' WHEN scp.migrated_campaign='2' THEN 'Free-to-end-user' END AS Migrated_Campaign, scp.campaign_overview AS Campaign_Overview, scp.opt_out_keyword AS Opt_Out_Keyword, scp.opt_out_mt AS Opt_Out_MT, scp.help_mt AS Help_MT, scp.email AS Email, scp.web_url AS Web_URL, scp.phone_number AS Phone_Number, scp.`t&c_web_url` AS `T&C_Web_Url`, scp.`t&c_text` AS `T&C_Text`, scp.customer_name AS Customer_Name, scp.notes AS Notes, GROUP_CONCAT(DISTINCT scf.filename) AS Filenames, GROUP_CONCAT(DISTINCT scf.file_path) AS Filepaths, GROUP_CONCAT(DISTINCT CASE WHEN scd.message_type='1' THEN 'SMS' WHEN scd.message_type='2' THEN 'MMS-Audio' WHEN scd.message_type='3' THEN 'MMS-Image' WHEN scd.message_type='4' THEN 'MMS-Video' END ) AS Message_Types, GROUP_CONCAT(DISTINCT CASE WHEN scd.content_type='1' THEN 'Chat' WHEN scd.content_type='2' THEN 'Coupons' WHEN scd.content_type='3' THEN 'Entertainment Alerts' WHEN scd.content_type='4' THEN 'Information Alert' WHEN scd.content_type='5' THEN 'Sweepstakes' WHEN scd.content_type='6' THEN 'Trivia' WHEN scd.content_type='7' THEN 'Two-factor Authentication' WHEN scd.content_type='8' THEN 'Voting/Polling' END ) AS Content_Types, GROUP_CONCAT(DISTINCT CASE WHEN scd.subscription_type='1' THEN 'One Time' WHEN scd.subscription_type='2' THEN 'Subscription' END ) AS Subscription_Types, scd.call_to_Action AS Call_To_Action, scd.opt_in_message AS Opt_In_Message, scd.example_message AS Example_message FROM `sc_campaign_profile` scp LEFT JOIN `sc_campaign_files` scf ON scp.id_profile = scf.profile_id LEFT JOIN `sc_content_defination` scd ON scp.id_profile = scd.profile_id WHERE scp.status='4' AND scp.sc_campaign_unique_id IN (" + requestID + ") GROUP BY scp.sc_campaign_unique_id;"
                    obj1.prepare();
                    obj1.execute((errors: any, result1: any) => {
                        if (errors == 1) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT id_request FROM sc_request WHERE sc_campaign_unique_id IN (" + requestID + ")";
                            obj.prepare()
                            obj.execute((_errors: any, result: any) => {
                                if (_errors == 1) {
                                    const idRequests = result.map((row: any) => row.id_request).join(",");

                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT id_request, GROUP_CONCAT(sc_carrier_coverage) AS sc_carrier_coverage FROM sc_request_carrier_coverage WHERE id_request IN (" + idRequests + ") GROUP BY id_request";
                                    ;
                                    obj.prepare()
                                    obj.execute((_errors: any, result2: any) => {
                                        if (_errors == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ data: result1, data1: result2, message: "ShortCode List Fetched Successfully!", status: 200 });
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                                            objv.execute();
                                        }
                                    })

                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                                    objv.execute();
                                }
                            })
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                            objv.execute();
                        }

                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }


    sc_sendMail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    try {
                        let sdata = JSON.parse(req.body.data);
                        const requestID = "'" + sdata.requestId.join("','") + "'";
                        let objv = new ModelRawQuery(req, res);
                        objv.qrysql = "SELECT `iduser`,`idaccount`,`sc_campaign_unique_id`,`shortcode_number`,`id_profile` from `sc_campaign_profile` WHERE `sc_campaign_unique_id` IN (" + requestID + ") ";
                        objv.prepare();
                        objv.execute((errors: any, result: any) => {
                            const Number = result[0].shortcode_number;
                            const profileId = result[0].id_profile;
                            if (errors == 1) {
                                let data: any = req.files;
                                const idusers = result.map((row: { iduser: any; }) => row.iduser);
                                const idaccounts = result.map((row: { idaccount: any; }) => row.idaccount);
                                let batchID = 'SCBID' + Math.floor(1000 + Math.random() * 100000000);
                                let filename = data[0].filename;
                                let value = SCampaign.shortcode + filename;


                                let obj00 = new ModelRawNonQuery(req, res);
                                obj00.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`,`subject`,`text`,`type`,`status`,`file`,`html`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + SMTP.from + "','" + SMTP.to + "', 'Mail Send For SC Number Mapping','Mapped ShortCode Campaign','Mail sent to ShortCode Mapping','20', '" + value + "','" + parseBody(SMTP.text) + "')";
                                obj00.prepare();
                                obj00.execute((_err: any, __result: any) => {
                                    if (_err == 1) {
                                        let obj0 = new ModelRawNonQuery(req, res);
                                        obj0.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '5',`process_started_date`=NOW() WHERE `idaccount` IN (" + idaccounts + ") AND `iduser` IN (" + idusers + ") AND `sc_campaign_unique_id` IN (" + requestID + ")";
                                        obj0.prepare();
                                        obj0.execute((errors: any, result: any) => { });

                                        let qry = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES";
                                        result.forEach((ele: any) => {
                                            qry += "('" + ele.iduser + "', '" + ele.idaccount + "', '5', 'CAMPAIGN_PROFILE_PROCESS_STARTED', 'ShortCode Campaign Profile Process Started', '" + ele.id_profile + "'),";
                                        });

                                        /*did log maintain*/

                                        let obj21 = new ModelRawNonQuery(req, res);
                                        obj21.nonqrysql = "UPDATE did_buy SET sinch_status = '2', updated_at=NOW() WHERE `iduser`='" + idusers + "' AND `did`='" + Number + "'";
                                        obj21.prepare();
                                        obj21.execute((error: any, data: any) => { });

                                        let obj22 = new ModelRawNonQuery(req, res);
                                        obj22.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + idaccounts + "','" + idusers + "',NOW(),'41','Number Mapped For Shortcode','" + Number + "')";
                                        obj22.prepare();
                                        obj22.execute((_error: any, result: any) => {
                                            console.log("Data Inserted Successfully!");
                                        });


                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = qry.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((_error: any, result: any) => {
                                            console.log("Email Sent Successfully!");
                                        });

                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT INTO `sc_batch_id` (`iduser`,`idaccount`,`batch_id_unique`,`filename`,`filepath`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + batchID + "','" + filename + "','" + value + "')";
                                        obj2.prepare();
                                        obj2.execute((errors: any, result: any) => {
                                            if (errors == 1) {

                                                let obj = new ModelRawQuery(req, res);
                                                obj.qrysql = "SELECT `id_batch`,`batch_id_unique` from `sc_batch_id` WHERE `batch_id_unique`='" + batchID + "'";
                                                obj.prepare();
                                                obj.execute((_error: any, result1: any) => {
                                                    const BatchData = result1[0].batch_id_unique;
                                                    const BatchID = result1[0].id_batch;
                                                    let qry0 = "INSERT INTO `sc_batchid_request`(`idaccount`, `iduser`, `batch_id_unique`,`id_batch`,`sc_campaign_unique_id`) VALUES ";
                                                    for (let i = 0; i < sdata.requestId.length; i++) {
                                                        let requestData = sdata.requestId[i];
                                                        qry0 += "('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + BatchData + "' ,'" + BatchID + "','" + requestData + "'),"
                                                    }

                                                    let objj1 = new ModelRawNonQuery(req, res);
                                                    objj1.nonqrysql = qry0.slice(0, -1);
                                                    objj1.prepare();
                                                    objj1.execute((_error: any, resultIdreq: any) => {
                                                        console.log("Batch ID Inserted Successfully!")
                                                    });

                                                });
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Email Sent Successfully!", status: 200 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 401, message: "Email is not Sent!" });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 401, message: "Invalid Details!" });
                                objv.execute();
                            }
                        });
                    } catch (e) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    approveSCStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;
                if (sessdata.type == 1) {
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '6',`process_approved_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.id_profile + "'";
                    obj1.prepare();
                    obj1.execute((errors: any, result: any) => {
                        if (errors == 1) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '6', 'CAMPAIGN_PROFILE_PROCESS_APPROVED','ShortCode Campaign Profile Process Approved','" + sdata.id_profile + "')";
                            obj0.prepare();
                            obj0.execute((_error: any, result: any) => { });

                            let objv0 = new RawView(res);
                            objv0.prepare({ status: 201, message: "SC Campaign Profile Approved Successfully." });
                            objv0.execute();

                            let obj12 = new ModelRawNonQuery(req, res);
                            obj12.nonqrysql = "UPDATE sc_request SET status = '4' WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.id_profile + "'";
                            obj12.prepare();
                            obj12.execute((error: any, data: any) => { });

                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE did_buy SET sinch_status = '1', updated_at=NOW() WHERE `iduser`='" + sdata.iduser + "' AND `did`='" + sdata.number + "'";
                            obj2.prepare();
                            obj2.execute((error: any, data: any) => { });

                            let obj10 = new ModelRawNonQuery(req, res);
                            obj10.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'42','SMS fully provisioned For Shortcode','" + sdata.number + "')";
                            obj10.prepare();
                            obj10.execute((_error: any, result: any) => {
                                console.log("Data Inserted Successfully!");
                            });
                        } else {
                            let objv0 = new RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                            objv0.execute();
                        }
                    });
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    rejectSCStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;
                if (sessdata.type == 1) {
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '7',`process_rejected_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.idProfile + "'";
                    obj1.prepare();
                    obj1.execute((errors: any, result: any) => {
                        if (errors == 1) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '7', 'CAMPAIGN_PROFILE_PROCESS_REJECTED','ShortCode Campaign Profile Process Rejected','" + sdata.idProfile + "')";
                            obj0.prepare();
                            obj0.execute((_error: any, result: any) => { });

                            let objv0 = new RawView(res);
                            objv0.prepare({ status: 201, message: "SC Campaign Profile Rejected Successfully." });
                            objv0.execute();

                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE did_buy SET sinch_status = '0', updated_at=NOW() WHERE `iduser`='" + sdata.iduser + "' AND `did`='" + sdata.number + "'";
                            obj2.prepare();
                            obj2.execute((error: any, data: any) => { });
                            let obj10 = new ModelRawNonQuery(req, res);
                            obj10.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'43','Shortcode Number Rejected','" + sdata.number + "')";
                            obj10.prepare();
                            obj10.execute((_error: any, result: any) => {
                                console.log("Data Inserted Successfully!");
                            });
                        } else {
                            let objv0 = new RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                            objv0.execute();
                        }
                    });
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    sendshortcoderequest(req: Request, res: Response, next: NextFunction) {
        var sdata: any = JSON.parse(req.body.data);
        let userID: any = sdata.data.selectedRequesID.split('-')
        let campaignID: any = userID[0]
        let ProfileID: any = userID[1]
        var sdata1: any = req.files;
        const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {

                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        let files: Express.Multer.File[] = req.files as Express.Multer.File[];
                        let filename: any;
                        let filename1: any;
                        let filepath: any;
                        let filepath1: any;
                        files.forEach((file: Express.Multer.File) => {
                            if (file.mimetype === 'text/csv') {
                                filename = file.filename;
                                filepath = SCampaign.shortcode + file.filename;
                            } else {
                                filename1 = file.filename;
                                filepath1 = SCampaign.shortcode + file.filename;
                            }
                        });
                        let FullName = result[0].firstname + ' ' + result[0].lastname;
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `sc_request` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`sc_type`,`sender_id`,`migrated_file_path`,`migrated_filename`,`sc_proof_doc_filepath`,`sc_proof_filename`,`status`,`customer_name`, `shortocde_number`,`profile_id`,`connection`,`carrier_cost`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + campaignID + "', '" + sdata.data.shortcodetype + "', '" + parseBody(sdata.data.SenderID) + "' ,'" + filepath + "','" + filename + "','" + filepath1 + "','" + filename1 + "','1','" + FullName + "','" + sdata.didnumber + "','" + ProfileID + "','" + (sdata.data.connectionName).trim() + "','" + rated + "')";
                        obj1.prepare();
                        obj1.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let obj0 = new ModelRawNonQuery(req, res);
                                obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','1','SHORTCODE_REQUEST_CREATED','ShortCode Request Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "')";
                                obj0.prepare();
                                obj0.execute((_error: any, result: any) => {
                                    console.log("Data Inserted Successfully!");
                                });

                                let obj01 = new ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '0' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `id_profile`= '" + ProfileID + "'";
                                obj01.prepare();
                                obj01.execute((_error: any, result: any) => {
                                    console.log("Status Updated Successfully!");
                                });

                                // Carrier coverage rates
                                if (sdata.Carrier.length === 0) {
                                    console.log("No carrier coverage found")
                                } else {
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `id_request` from `sc_request` WHERE `profile_id`='" + ProfileID + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        if (_error == 1) {
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            let qry3 = "INSERT INTO `sc_request_carrier_coverage` (`iduser`,`idaccount`,`id_request`,`sc_carrier_coverage`,`rate`) VALUES ";
                                            for (let i = 0; i < sdata.Carrier.length; i++) {
                                                const data = sdata.Carrier[i];
                                                qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_request + "','" + data.display_name + "','" + data.rate + "'),"
                                            }
                                            obj4.nonqrysql = qry3.slice(0, -1)
                                            obj4.prepare();
                                            obj4.execute((error: any, result: any) => { })
                                        }
                                    })
                                }

                                let objb = new ModelRawNonQuery(req, res);
                                objb.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','6','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES','ShortCode Request Carrier Coverage Rates Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "','" + rated + "')";
                                objb.prepare();
                                objb.execute((_error: any, result: any) => {
                                    console.log("Log Inserted Successfully!");
                                });

                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Shortcode Request Inserted Successfully", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Shortcode Request Details!", status: 502, error: result
                                });
                                objv.execute();
                            }
                        })
                    });
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }


    updateSCsender(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let sdata: any = JSON.parse(req.body.data);
                    var sdata1: any = req.files;
                    let previousFile: any = [];
                    const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);
                    const numberDID = sdata.data.shortcodetype == '1' ? sdata.didnumber : '';
                    if(sdata.data.shortcodetype == '1' ){
                        previousFile.push(...sdata.previosFile);
                        var filename: any;
                        var filename1: any;
                        var filepath: any;
                        var filepath1: any;
    
                        if (req.files.length === 0 || !req.files) {
                            previousFile.forEach((fileObj: { file: string, name?: string }) => {
                                if (fileObj.name) {
                                    const { file, name } = fileObj;
                                    const extension = name.split('.').pop();
                                    if (extension === 'csv') {
                                        filename = name;
                                        filepath = file;
                                    } else {
                                        filename1 = name;
                                        filepath1 = file;
                                    }
                                }
                            });
                        } else {
                            let files: Express.Multer.File[] = req.files as Express.Multer.File[];
                            files.forEach((file: Express.Multer.File) => {
                                if (file.mimetype === 'text/csv') {
                                    filename = file.filename;
                                    filepath = SCampaign.shortcode + file.filename;
                                } else {
                                    filename1 = file.filename;
                                    filepath1 = SCampaign.shortcode + file.filename;
                                }
                            });
                        }
    
                        }else{
                             filename = ''
                             filename1 = ''
                             filepath = ''
                             filepath1 = ''
                        }

                    let objj11 = new ModelRawNonQuery(req, res);
                    objj11.nonqrysql = "UPDATE sc_request SET `sc_campaign_unique_id`='" + sdata.data.selectedRequesID + "',`sc_type`='" + sdata.data.shortcodetype + "',`sender_id`='" + parseBody(sdata.data.SenderID) + "',`migrated_file_path`='" + filepath + "',`migrated_filename`='" + filename + "',`sc_proof_doc_filepath`='" + filepath1 + "',`sc_proof_filename`='" + filename1 + "',`status`= '1',`shortocde_number`='" + numberDID + "',`connection`='" + (sdata.data.connectionName).trim() + "',`updated_at`=NOW(),`carrier_cost`='" + rated + "' WHERE `profile_id` = '" + sdata.idprofile + "'";
                    objj11.prepare();
                    objj11.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sdata.data.selectedRequesID + "','2','SHORTCODE_REQUEST_UPDATED','ShortCode Request Updated Successfully','" + sdata.data.shortcodetype + "','" + sdata.idprofile + "')";
                            obj0.prepare();
                            obj0.execute((_error: any, result: any) => {
                                console.log("Log Inserted Successfully!");
                            });

                            let obj4 = new ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "DELETE FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + sdata.idrequest + "'";
                            obj4.prepare();
                            obj4.execute((error: any, result: any) => {
                                if (error == 1) {
                                    if (sdata.Carrier.length === 0) {
                                        console.log("No carrier coverage found")
                                    } else {
                                        let obj5 = new ModelRawNonQuery(req, res);
                                        let qry3 = "INSERT INTO `sc_request_carrier_coverage` (`iduser`,`idaccount`,`id_request`,`sc_carrier_coverage`,`rate`) VALUES ";
                                        for (let i = 0; i < sdata.Carrier.length; i++) {
                                            const data = sdata.Carrier[i];
                                            qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.idrequest + "','" + data.display_name + "','" + data.rate + "'),"
                                        }
                                        obj5.nonqrysql = qry3.slice(0, -1)
                                        obj5.prepare();
                                        obj5.execute((error: any, result: any) => { })
                                    }
                                } else {
                                    console.log("Issue in deletion of the carrier coverage")
                                }
                            })

                            let objb = new ModelRawNonQuery(req, res);
                            objb.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sdata.data.selectedRequesID + "','7','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES_UPDATED','ShortCode Request Carrier Coverage Rates Updated Successfully','" + sdata.data.shortcodetype + "','" + sdata.idprofile + "','" + rated + "')";
                            objb.prepare();
                            objb.execute((_error: any, result: any) => {
                                console.log("Log Inserted Successfully!");
                            });


                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "SC Request Updated Successfully", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Something Went Wrong With SC Request Details!",
                                status: 502,
                                error: result
                            });
                            objv.execute();
                        }
                    });
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getsingleSCDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query as { type: string };
                let sdata1 = JSON.parse(sdata.type);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idaccount,iduser,sc_campaign_unique_id,sc_type,sender_id,migrated_file_path,migrated_filename,sc_proof_doc_filepath,sc_proof_filename,status,shortocde_number,did_provider,rates,description,filename,file_path,profile_id,id_request,connection FROM sc_request WHERE profile_id = '" + sdata1.idprofile + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `idtariff` FROM `user` WHERE `iduser` = '" + sdata1.iduser + "'";
                        obj1.prepare();
                        obj1.execute((error: any, result2: any) => {
                            if (_error == 1) {
                                let obj4 = new ModelRawQuery(req, res)
                                obj4.qrysql = "SELECT `sc_carrier_coverage`,`rate` FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + sdata1.idrequest + "' ";
                                obj4.prepare();
                                obj4.execute((_errror: any, result3: any) => {
                                    if (error == 1) {

                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, data1: result2, data3: result3, message: "SC list Fetched Successfully", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: "Something Went Wrong With Rates!",
                                            status: 502,
                                            error: result
                                        });
                                        objv.execute();
                                    }

                                })
                                // let objv = new RawView(res);
                                // objv.prepare({ data: result, data1: result2, message: "SC list Fetched Successfully", status: 200 });
                                // objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Rates!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        })
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });

    }

    getIDRequest(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idaccount`, `iduser`, `sc_campaign_unique_id`, `status`,`id_profile` FROM sc_campaign_profile WHERE `idaccount`='" + sessData.idaccount + "' AND `status`='3' ORDER BY `created_at` DESC";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Request Id Fetched Successfully', data: result, status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Request Id!", status: 503 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }

    getSCRequest(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let condition: any = '';
                if (sessdata.type == 1)
                    condition += ''
                if (sessdata.type == 2)
                    condition += "WHERE idaccount='" + sessdata.idaccount + "'"

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`,`id_request`, `idaccount`, `sc_campaign_unique_id`, `status`, `sc_type`, `created_at` , `customer_name`,`shortocde_number`,`profile_id`,`id_request`,`connection`,`carrier_cost` FROM sc_request " + condition + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "SC Request List Fetched Successfully",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With SC Request List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    approveSCrStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;
                if (sessdata.type == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT `rate` FROM `voice_rates` where `idtariff` = '" + sdata.idtaiff + "' AND `subtype` = 'message_activation' AND `category`='migrated_short_code'";
                    obj.prepare();
                    obj.execute((err: any, result: any) => {
                        let rates = result[0].rate;
                        // To get the proration status
                        let objv0 = new ModelRawNonQuery(req, res);
                        objv0.nonqrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + sdata.iduser + "'";
                        objv0.prepare();
                        objv0.execute((proration_error, proration_success) => {
                            if (proration_error == 1) {
                                let dateObj = new Date();
                                let day = dateObj.getUTCDate();
                                let nDate: any = new Date()
                                let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                let totalDays = (lDate - day) + 1;
                                let prorate: any;
                                if (proration_success[0].proration == "true")
                                    prorate = (totalDays * rates) / lDate + parseInt(sdata.total);
                                else
                                    prorate = parseInt(rates) + parseInt(sdata.total);

                                prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0

                                let rate = new APIBase();
                                rate.checkBalance(req, res, sdata.idaccount, sdata.total, (walletError, wallet) => {
                                    if (walletError == 1) {
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `sc_request` SET `status`= '2',`rates`='" + rates + "',`carrier_cost`='" + sdata.total + "',`approved_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.idprofile + "'";
                                        obj1.prepare();
                                        obj1.execute((errors: any, result: any) => {
                                            if (errors == 1) {
                                                let obj0 = new ModelRawNonQuery(req, res);
                                                obj0.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4',`shortcode_number`='" + sdata.SC_Number + "',`number_mapped_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.idprofile + "'";
                                                obj0.prepare();
                                                obj0.execute((_error: any, result: any) => {
                                                    console.log("Number Mapped Successfully!");
                                                });

                                                // To update the wallet amount
                                                let objv1 = new ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate * 1 + " WHERE `idaccount`='" + sdata.idaccount + "'"
                                                objv1.prepare();
                                                objv1.execute((wallet_error, wallet_success) => {
                                                    // To update the wallet transaction log
                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                    iQry += "`idaccount`=" + sdata.idaccount + ", "
                                                    iQry += "`amount`='-" + prorate * 1 + "', "
                                                    iQry += "`purpose`='Wallet amount successfully updated for shortcode', "
                                                    iQry += "`status`=1;"

                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {
                                                        console.log("Wallet Updated Successfully!");
                                                    });
                                                });

                                                let objj0 = new ModelRawNonQuery(req, res);
                                                objj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','3','SHORTCODE_REQUEST_PROCESS_APPROVED','ShortCode Request Process Approved','" + sdata.sc_type + "','" + sdata.idprofile + "','" + rates + "')";
                                                objj0.prepare();
                                                objj0.execute((_error: any, result: any) => {
                                                    console.log("Log Inserted Successfully!");
                                                });

                                                let objj = new ModelRawNonQuery(req, res);
                                                objj.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','8','SHORTCODE_REQUEST_Carrier_COVERAGE_RATES_DEDUCTED','ShortCode Request Carrier Coverage Rates Deducted Successfully','" + sdata.sc_type + "','" + sdata.idprofile + "','" + sdata.total + "')";
                                                objj.prepare();
                                                objj.execute((_error: any, result: any) => {
                                                    console.log("Log Inserted Successfully!");
                                                });

                                                let obj2 = new ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "INSERT INTO `did_buy` (`iduser`,`account_id`,`did`,`connection_key`,`sms_provider`,`provider`,`type`,`rates`,`sinch_status`,`did_sub_type`,`camp_registry`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.SC_Number + "','" + sdata.connection + "','sinch','shortcode','SC','" + rates + "','0','2','" + sdata.idcamp + "')";

                                                obj2.prepare();
                                                obj2.execute((_error: any, result: any) => {
                                                    console.log("DID Inserted Successfully!");
                                                });

                                                let objv0 = new RawView(res);
                                                objv0.prepare({ status: 201, message: "SC Request Approved Successfully" });
                                                objv0.execute();
                                            }
                                            else {
                                                let objv0 = new RawView(res);
                                                objv0.prepare({ status: 502, message: "Something Went Wrong With SC Request!" });
                                                objv0.execute();
                                            }
                                        })

                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({ error_code: 0, error: walletError, message: "Insufficient Balance.", status: 503 });
                                        objv.execute();
                                    }
                                })
                            } else {
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with get proration!" });
                                obj.execute();
                            }
                        })
                    })
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    rejectstatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_request` SET `status`= '3',`reject_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.idprofile + "'";
                    obj1.prepare();
                    obj1.execute((errors: any, result: any) => {
                        console.log("Status Updated Successfully!");
                        if (errors == 1) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','4','SHORTCODE_REQUEST_PROCESS_REJECTED','ShortCode Request Process Rejected','" + sdata.sc_type + "','" + sdata.idprofile + "')";
                            obj0.prepare();
                            obj0.execute((_error: any, result: any) => {
                                console.log("Log Inserted Successfully!");
                            });

                            let objv0 = new RawView(res);
                            objv0.prepare({ status: 201, message: "SC Request Rejected Successfully" });
                            objv0.execute();
                        }
                        else {
                            let objv0 = new RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong With Reject Details!" });
                            objv0.execute();
                        }
                    })
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    public GetRates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "SELECT `rate`,`category`,`priority` FROM `voice_rates` where `idtariff` = '" + sdata.type + "' AND `subtype` = 'message_activation'";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Rates Fetched Successfully", status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Get Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    Saverandomvanity(req: Request, res: Response, next: NextFunction) {
        var sdata: any = JSON.parse(req.body.data);
        let did_sub_type = sdata.data.SCtype === '3' ? 1 : 0;

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // To get the proration status
                let objv0 = new ModelRawNonQuery(req, res);
                objv0.nonqrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + sdata.iduser + "'";
                objv0.prepare();
                objv0.execute((proration_error, proration_success) => {
                    if (proration_error == 1) {
                        let dateObj = new Date();
                        let day = dateObj.getUTCDate();
                        let nDate: any = new Date()
                        let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                        let totalDays = (lDate - day) + 1;
                        let prorate: any;
                        if (proration_success[0].proration == "true")
                            prorate = (totalDays * sdata.data.rates) / lDate + parseInt(sdata.total);
                        else
                            prorate = parseInt(sdata.data.rates) + parseInt(sdata.total);

                        prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0

                        // let obj1 = new ModelRawQuery(req, res);
                        // obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sdata.idaccount + "' AND `balance` + `credit_limit` >= '" + prorate * 1 + "'"
                        // obj1.prepare();
                        // obj1.execute((walletError: any, wallet: any) => {
                        //     if (walletError == 1 && wallet.length > 0) {

                        let rate = new APIBase();
                        rate.checkBalance(req, res, sdata.idaccount, prorate, (walletError, wallet) => {
                            if (walletError == 1) {
                                var filepath: any;
                                var filename: any;
                                let files: Express.Multer.File[] = req.files as Express.Multer.File[];
                                files.forEach((file: Express.Multer.File) => {
                                    if (file.mimetype === 'text/csv') {
                                        filename = file.filename;
                                        filepath = SCampaign.shortcode + file.filename;
                                    }
                                });

                                let obj11 = new ModelRawNonQuery(req, res);
                                obj11.nonqrysql = "UPDATE sc_request SET `sc_campaign_unique_id`='" + sdata.data.SCReqID + "',`sc_type`='" + sdata.data.SCtype + "',`did_provider`='" + sdata.data.DIDprovider + "',`file_path`='" + filepath + "',`filename`='" + filename + "',`status`= '2',`shortocde_number`='" + sdata.didnumber + "',`rates`='" + sdata.data.rates + "',`connection`='" + (sdata.connectionname).trim() + "',`description`='" + parseBody(sdata.data.description) + "' WHERE `profile_id` = '" + sdata.idprofile + "'";
                                obj11.prepare();
                                obj11.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let obj0 = new ModelRawNonQuery(req, res);
                                        obj0.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4',`shortcode_number`='" + sdata.didnumber + "',`number_mapped_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.idprofile + "'";
                                        obj0.prepare();
                                        obj0.execute((_error: any, result: any) => {
                                            console.log("Number Mapped Successfully!");
                                        });

                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT INTO `did_buy` (`iduser`,`account_id`,`did`,`connection_key`,`sms_provider`,`provider`,`type`,`rates`,`sinch_status`,`did_sub_type`,`camp_registry`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.didnumber + "','" + (sdata.connectionname).trim() + "','sinch','shortcode','SC','" + sdata.data.rates + "','0','" + did_sub_type + "','" + sdata.data.SCReqID + "')";

                                        obj2.prepare();
                                        obj2.execute((_error: any, result: any) => {
                                            console.log("DID Inserted Successfully!");
                                        });

                                        let objj0 = new ModelRawNonQuery(req, res);
                                        objj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`rates`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.data.SCReqID + "','5','SHORTCODE_REQUEST_PROCESS_APPROVED','ShortCode Request Process Approved','" + sdata.data.SCtype + "','" + sdata.data.rates + "','" + sdata.idprofile + "')";
                                        objj0.prepare();
                                        objj0.execute((_error: any, result: any) => {
                                            console.log("Log Inserted Successfully!");
                                        });

                                        let objj = new ModelRawNonQuery(req, res);
                                        objj.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`rates`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.data.SCReqID + "','8','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES_DEDCUTED','ShortCode Request Carrier Coverage Rates Deducted Successfully','" + sdata.data.SCtype + "','" + sdata.total + "','" + sdata.idprofile + "')";
                                        objj.prepare();
                                        objj.execute((_error: any, result: any) => {
                                            console.log("Log Inserted Successfully!");
                                        });

                                        // To update the wallet amount
                                        let objv1 = new ModelRawNonQuery(req, res);
                                        objv1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate * 1 + " WHERE `idaccount`='" + sdata.idaccount + "'"
                                        objv1.prepare();
                                        objv1.execute((wallet_error, wallet_success) => {
                                            // To update the wallet transaction log
                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                            iQry += "`idaccount`=" + sdata.idaccount + ", "
                                            iQry += "`amount`='-" + prorate * 1 + "', "
                                            iQry += "`purpose`='Wallet amount successfully updated for shortcode', "
                                            iQry += "`status`=1;"

                                            let objWL = new ModelRawNonQuery(req, res);
                                            objWL.nonqrysql = iQry
                                            objWL.prepare()
                                            objWL.execute((error: any, result: any) => {
                                                console.log("Wallet Updated Successfully!");
                                            });
                                        });

                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, message: "SC Request Inserted Successfully", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With SC Request!", status: 502, error: result });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ error_code: 0, error: walletError, message: "Please add funds to your account or contact support.", status: 503 });
                                objv.execute();
                            }
                        });
                    } else {
                        let obj = new RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with get proration!" });
                        obj.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    Connnections(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = JSON.parse(req.query.type as string);
                let obj = new ModelRawQuery(req, res);

                obj.qrysql = "SELECT iduser,idaccount,name, connection_key,isDefault FROM endpoint WHERE `idaccount`= '" + data.idaccount + "' AND `iduser`='" + data.iduser + "' ORDER BY `idendpoint` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    AllConnnections(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);

                obj.qrysql = "SELECT name, connection_key FROM endpoint ORDER BY `idendpoint` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

}