import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
const request = require("request");
import { ipAddressAndBrowser, parseBody, setToZero } from "./markError";
import axios from 'axios';
import {

} from "./markError";

export class customerGroup extends AppRoute {
    constructor() {
        super();
    }

    public saveCustomerGroup(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata: any = req.body.data;
                    if (sdata.group_name && /^\s/.test(sdata.group_name)) {
                        sdata.group_name = sdata.group_name.trimLeft();
                    }
                    if (sdata.description && /^\s/.test(sdata.description)) {
                        sdata.description = sdata.description.trimLeft();
                    }
                    let objS = new ModelRawQuery(req, res);
                    objS.qrysql = "SELECT `group_name` , `cgid` , `description` , `groupid`  FROM `customer_group` WHERE `group_name` = '" + parseBody(sdata.group_name) + "' AND `status` = '0'";
                    objS.prepare();
                    objS.execute((err: any, result: any) => {
                        if (err == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Group name already exists!", status: 400 });
                                objv.execute();
                            } else {
                                let group_id: any = "";
                                const alphabet = '0123456789';
                                const alphabetLength = alphabet.length;
                                const length = 7;
                                group_id = 'CG';
                                for (let i = 0; i < length; i++) {
                                    const randomIndex = Math.floor(Math.random() * alphabetLength);
                                    const isDigit = randomIndex >= 52;
                                    group_id += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                                }
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `customer_group`(`groupid`,`iduser`,`idaccount`,`group_name`,`description`) VALUES ('" + group_id + "'," + sessdata.iduser + "," + sessdata.idaccount + ",'" + parseBody(sdata.group_name) + "','" + parseBody(sdata.description) + "')";
                                obj.prepare();
                                obj.execute((err: any, result: any) => {
                                    if (err == 1) {
                                        let insertedGroupId = group_id;
                                        let obj = new ModelRawQuery(req, res);
                                        obj.qrysql = "SELECT `cgid` FROM `customer_group` WHERE `groupid` = '" + insertedGroupId + "'";
                                        obj.prepare();
                                        obj.execute((err: any, result: any) => {
                                            if (err == 1 && result.length > 0) {
                                                let insertedData = result[0];
                                                let objGroupUpdate = new ModelRawQuery(req, res);
                                                objGroupUpdate.qrysql = "UPDATE `customer_group` SET `updated_date` = NOW() WHERE `cgid` = " + insertedData.cgid + "";
                                                objGroupUpdate.prepare();
                                                objGroupUpdate.execute((error: any, resGroupUpdate: any) => {});

                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Customer Group Saved Successfully!", data: insertedData.cgid, status: 200 });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Failed to retrieve inserted customer group data!", status: 500 });
                                                objv.execute();
                                            }
                                        });
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something went wrong With Customer Group Details!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Failed to check for duplicate group name!", status: 500 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public updateCustomerGroup(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata: any = req.body.data.data;
                    let cgID: any = req.body.data.cgID;
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "UPDATE `customer_group` SET `group_name`='" + parseBody(sdata.group_name) +"' , `description` = '"+ parseBody(sdata.description) +"',`updated_date` = NOW() WHERE `cgid`= "+ cgID +"";
                    obj0.prepare();
                    obj0.execute((error: any, resUser: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Customer Group Updated Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }
    
    public saveCustomerMapping(req: Request, res: Response, next: NextFunction) {
      let session = new SessionManagment(req, res, next);
      session.GetSession((error: any, sessdata: any) => {
          if (error == 1) {
              if (sessdata.type == 1) {
                  let sdata: any = req.body.data;
                  let obj = new ModelRawNonQuery(req, res);
                  let qry = "INSERT INTO `customer_group_mapping`(`cgid`,`master_iduser`,`master_idaccount`,`slave_idaccount` ,`slave_iduser`) VALUES";
                  sdata.slaveaccount.forEach((slaveAccount : any , index : number) => {
                      let slaveIdUser = sdata.slave_iduser[index];
                      qry += "(" + sdata.cgid + ","+ sdata.master_iduser +"," + sdata.masteraccount + "," + slaveAccount + ","+ slaveIdUser +"),";
                  });
                  obj.nonqrysql = qry.slice(0, -1)
                  obj.prepare();
                  obj.execute((err: any, result: any) => {
                    if (err === 1) {
                      let objv = new RawView(res);
                      objv.prepare({ message: "Customer Mapping Saved Successfully!", status: 200 });
                      objv.execute();
                    } else {
                      let objv = new RawView(res);
                      objv.prepare({ message: "Something went wrong With Customer Mapping Details!", status: 502 });
                      objv.execute();
                    }
                  });
              }
              else {
                  let objv = new RawView(res);
                  objv.prepare({ message: "Service Not Available!", status: 503 });
                  objv.execute();
              }
          }
          else {
              let objv = new Res406(res);
              objv.prepare(session);
              objv.execute();
          }
      });
  }
   
  public updateCustomerMapping(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
        if (error == 1) {
            if (sessdata.type == 1) {
                let sdata: any = req.body.data;
                let cgID: any = req.body.data.cgID;
                let condition: any = '';
                if (sdata.masterIdUser) {
                    condition += ",`master_iduser` = " + sdata.masterIdUser + "";
                }
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `cmid`, `slave_idaccount` FROM `customer_group_mapping` WHERE `cgid` = " + cgID + "";
                obj0.prepare();
                obj0.execute((error: any, resCM: any) => {
                  if (resCM.length > 0) {  
                    let objGroupUpdate = new ModelRawQuery(req, res);
                    objGroupUpdate.qrysql = "UPDATE `customer_group` SET `updated_date` = NOW() WHERE `cgid` = " + cgID;
                    objGroupUpdate.prepare();
                    objGroupUpdate.execute((error: any, resGroupUpdate: any) => {});
                    let objQuery = new ModelRawQuery(req, res);
                    let deleteQuery = `DELETE FROM customer_group_mapping WHERE cgid = ${cgID}`;
                    objQuery.qrysql = deleteQuery;
                    objQuery.prepare();
                    objQuery.execute((deleteError: any, deleteResult: any) => {
                      if (deleteError !== 1) {
                          let objv = new RawView(res);
                          objv.prepare({ message: "Something went Wrong!", status: 502 });
                          objv.execute();
                          return;
                      }
                      let masterId = Array.isArray(sdata.masterId) && sdata.masterId[0]?.idField ? sdata.masterId[0].idField : sdata.masterId;
                      let obj = new ModelRawNonQuery(req, res);
                      let qry = "INSERT INTO `customer_group_mapping`(`cgid`,`master_idaccount`,`master_iduser`,`slave_idaccount` ,`slave_iduser`) VALUES";
                      sdata.slaveIds.forEach((slaveId : any , index : number) => {
                          let slaveIdUser = sdata.slaveUsers[index];
                          if (typeof slaveId === 'object' && slaveId.idField2) {
                            slaveId = slaveId.idField2;
                        }
                          qry += "(" + cgID + ","+ masterId +"," + sdata.masterIdUser + "," + slaveId + ","+ slaveIdUser +"),";
                      });
                      obj.nonqrysql = qry.slice(0, -1)
                      obj.prepare();

                      obj.execute((insertError: any, insertResult: any) => {
                          if (insertError == 1) {
                              let objv = new RawView(res);
                              objv.prepare({ message: "Customer Mapping Updated Successfully!", status: 200 });
                              objv.execute();
                          } else {
                              let objv = new RawView(res);
                              objv.prepare({ message: "Something went Wrong!", status: 502 });
                              objv.execute();
                          }
                      });
                    });
                  } else {
                    // If no existing records, insert all
                    let masterId: any;
                    if (typeof sdata.masterId[0] === 'object' && sdata.masterId[0].hasOwnProperty('idField')) {
                        masterId = sdata.masterId[0].idField;
                    } else {
                        masterId = sdata.masterId;
                    }
                    let objGroupUpdate = new ModelRawQuery(req, res);
                    objGroupUpdate.qrysql = "UPDATE `customer_group` SET `updated_date` = NOW() WHERE `cgid` = " + cgID;
                    objGroupUpdate.prepare();
                    objGroupUpdate.execute((error: any, resGroupUpdate: any) => {});

                    let insertValues = sdata.slaveIds.map((slaveId: any, index: number) => {
                        let slaveUser: any;
                        if (typeof slaveId === 'object' && slaveId.hasOwnProperty('idField2')) {
                            slaveId = slaveId.idField2;
                            slaveUser = sdata.slaveUsers[index];
                        } else {
                            slaveUser = sdata.slaveUsers[index];
                        }
                        return `(${cgID}, ${slaveId}, ${slaveUser}, ${masterId}, ${sdata.masterIdUser})`;
                    }).join(", ");

                    let insertQuery = `INSERT INTO customer_group_mapping (cgid, slave_idaccount, slave_iduser, master_idaccount, master_iduser) 
                                       VALUES ${insertValues}`;
                    let objInsert = new ModelRawQuery(req, res);
                    objInsert.qrysql = insertQuery;
                    objInsert.prepare();
                    objInsert.execute((error: any, resInsert: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Customer Mapping Updated Successfully!", status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                  }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Service Not Available!", status: 503 });
                objv.execute();
            }
        } else {
            let objv = new Res406(res);
            objv.prepare(session);
            objv.execute();
        }
    });
  }
  
    public updateUserList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata: any = req.body.data;
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "UPDATE `user` SET `group_status`='" + sdata.group_status + "' WHERE `idaccount`=" + sdata.idaccount + "";
                    obj0.prepare();
                    obj0.execute((error: any, resUser: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Update Customer List Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }

    public getCustomerGroups(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT DISTINCT cg.`cgid`,cg.`groupid`, cg.`group_name`, cg.`description`,cg.`created_date`,cg.`updated_date`, cm.`master_idaccount` FROM `customer_group` cg LEFT JOIN `customer_group_mapping` cm ON cg.`cgid` = cm.`cgid` WHERE cg.`status` = 0;";
                    obj.prepare();
                    obj.execute((err: any, result: any) => {
                        if (err == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Customer Group Data Fetched Successfully!", data:result,status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }

    public applyGroupFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let obj = new ModelRawQuery(req, res);
                if (data.groupid)
                    condition += 'cg.`groupid` LIKE "%' + parseBody(data.groupid) + '%" AND ';

                if (data.groupname)
                    condition += 'cg.`group_name` LIKE "%' + parseBody(data.groupname) + '%" AND ';


                if (data.master)
                    condition += 'cm.`master_idaccount` LIKE "%' + data.master + '%" AND ';

                if (data.from_date && data.to_date) {
                    condition += ' cg.`created_date` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59" AND';
                }

                obj.qrysql = "SELECT DISTINCT cg.`cgid`,cg.`groupid`,cg.`group_name`,cg.`description`,cm.`master_idaccount`,cg.`created_date` FROM  `customer_group` cg LEFT JOIN  `customer_group_mapping` cm ON cg.`cgid` = cm.`cgid` WHERE  " + condition + " cg.`status`=0"
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Groups Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCustomerGroup(req: Request, res: Response, next: NextFunction) {
        let cgID: any = req.query.cgID;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT cg.`cgid`,cg.`groupid`, cg.`group_name`, cg.`description`, cm.`master_idaccount` , cm.`master_iduser` FROM `customer_group` cg LEFT JOIN `customer_group_mapping` cm ON cg.`cgid` = cm.`cgid` WHERE cg.`cgid`='"+cgID +"' AND cg.`status` = 0;";
                    obj.prepare();
                    obj.execute((err: any, result: any) => {
                        if (err == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Customer Group Data Fetched Successfully!", data:result,status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }

    public getSlaveAccount(req: Request, res: Response, next: NextFunction) {
        let masterID: any = req.query.masterID;
        let cgID: any = req.query.cgID;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT DISTINCT `slave_idaccount` FROM `customer_group_mapping`  WHERE `cgid`='"+ cgID + "' ";
                    obj.prepare();
                    obj.execute((err: any, result: any) => {
                        if (err == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Slave Account Data Fetched Successfully!", data:result,status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }

    public deleteCustomerGroup(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
          if (error == 1) {
            let sdata: any = req.body.data;
            if (sessdata.type == 1) {
              let obj = new ModelRawNonQuery(req, res);
              obj.nonqrysql =
                "SELECT `slave_idaccount`,`master_idaccount` FROM `customer_group_mapping` WHERE `cgid`='" +
                sdata.cgID +
                "' AND `cm_status`= 0 ";
              obj.prepare();
              obj.execute((err: any, result: any) => {
                if (err == 1) {
                  if ( result && result.length > 0 && typeof result[0].master_idaccount !== "undefined") {
                    let slaveIds = result.map((row: any) => row.slave_idaccount);
                    let masterId = result[0].master_idaccount;
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql =
                      "SELECT DISTINCT  `slave_idaccount`, `master_idaccount`,`cgid` FROM `customer_group_mapping` WHERE `cgid`!='" +
                      sdata.cgID +
                      "' AND `cm_status`= 0 ";
                    obj1.execute((err: any, res: any) => {
                      let groupedMasterIds = res.reduce((acc: any, row: any) => {
                        let existingGroup = acc.find(
                          (group: any) => group.cgid === row.cgid
                        );
                        if (existingGroup) {
                          let existingMaster = existingGroup.data.find(
                            (master: any) =>
                              master.master_idaccount === row.master_idaccount
                          );
                          if (existingMaster) {
                            existingMaster.slave_idaccounts.push(
                              row.slave_idaccount
                            );
                          } else {
                            existingGroup.data.push({
                              master_idaccount: row.master_idaccount,
                              slave_idaccounts: [row.slave_idaccount],
                            });
                          }
                        } else {
                          acc.push({
                            cgid: row.cgid,
                            data: [
                              {
                                master_idaccount: row.master_idaccount,
                                slave_idaccounts: [row.slave_idaccount],
                              },
                            ],
                          });
                        }
                        return acc;
                      }, []);
    
                      // groupedMasterIds.forEach((group: any) => {
                      //     console.log(`cgid: ${group.cgid}`);
                      //     group.data.forEach((obj: any) => {
                      //         console.log(obj);
                      //     });
                      // });
    
                      let matchingGroup = groupedMasterIds.filter((group: any) => {
                        return group.data.some(
                          (master: any) => master.master_idaccount === masterId
                        );
                      });
    
                      if (matchingGroup.length > 0) {
                        let allSlaveIds: any = [];
                        matchingGroup.forEach((group: any) => {
                          group.data.forEach((obj: any) => {
                            obj.slave_idaccounts.forEach((slaveId: any) => {
                              if (!allSlaveIds.includes(slaveId)) {
                                allSlaveIds.push(slaveId);
                              }
                            });
                          });
                        });
                        let notFoundSlaveIds: any = [];
    
                        slaveIds.forEach((slaveId: any) => {
                          if (!allSlaveIds.includes(slaveId)) {
                            notFoundSlaveIds.push(slaveId);
                          }
                        });
                        // let allDids: any=[];
                        if (notFoundSlaveIds.length > 0) {
                          let obj2 = new ModelRawNonQuery(req, res);
                          obj2.nonqrysql =
                            "SELECT `campaign_key` FROM `campaign` WHERE `idaccount` IN ('" +
                            notFoundSlaveIds.join("', '") +
                            "') AND `provisioning_status` = 3";
                          obj2.prepare();
                          obj2.execute((error: any, allcamp: any) => {
    
                            let campaignKeys = allcamp.map(
                              (row: any) => row.campaign_key
                            );
                            if (campaignKeys.length > 0) {
                              campaignKeys.forEach((element: any) => {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql =
                                  "SELECT `did` from `did_buy` WHERE `camp_registry`='" +
                                  element +
                                  "'";
                                obj3.prepare();
                                obj3.execute((err: any, dids: any) => {
                                  if(dids.length>0)
                                    {
                                    let allDids = dids.map((row: any) => row.did);
                                    allDids.forEach((did: any) => {
                                        let obj4 = new ModelRawNonQuery(req, res);
                                        obj4.nonqrysql =
                                          "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_status`=0 WHERE `did`='" +
                                          did +
                                          "' ";
                                        obj4.prepare();
                                        obj4.execute((err: any, result: any) => {
                                          let obj5 = new ModelRawNonQuery(req, res);
                                          obj5.nonqrysql =
                                            "UPDATE  `campaign` SET `did_count` = `did_count`-1 WHERE  `campaign_key` = '" +
                                            element +
                                            "' ";
                                          obj5.prepare();
                                          obj5.execute((err: any, ress: any) => {
                                            let obj6 = new ModelRawNonQuery(req, res);
                                            obj6.nonqrysql =
                                              "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                              sdata.cgID +
                                              "' ";
                                            obj6.prepare();
                                            obj6.execute((err:any,result:any) => {});
                                            let obj7 = new ModelRawNonQuery(req, res);
                                            obj7.nonqrysql =
                                              "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                              sdata.cgID +
                                              "' ";
                                            obj7.prepare();
                                            obj7.execute((err:any,result:any) => {});
                                          });
                                        });
                                      });
                                  }
                                  else{
                                    let obj6 = new ModelRawNonQuery(req, res);
                                obj6.nonqrysql =
                                  "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                  sdata.cgID +
                                  "' ";
                                obj6.prepare();
                                obj6.execute((err:any,result:any) => {});
                                let obj7 = new ModelRawNonQuery(req, res);
                                obj7.nonqrysql =
                                  "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                  sdata.cgID +
                                  "' ";
                                obj7.prepare();
                                obj7.execute((err:any,result:any) => {});
                                  }
                                  
                                });
                              });
                            } 
                            else {
                                let obj6 = new ModelRawNonQuery(req, res);
                                obj6.nonqrysql =
                                  "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                  sdata.cgID +
                                  "' ";
                                obj6.prepare();
                                obj6.execute(() => {});
                                let obj7 = new ModelRawNonQuery(req, res);
                                obj7.nonqrysql =
                                  "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                  sdata.cgID +
                                  "' ";
                                obj7.prepare();
                                obj7.execute((err:any,result:any) => {});
                            }
                          });
                        }
                        else{
                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql =
                              "SELECT `campaign_key` FROM `campaign` WHERE `idaccount` IN ('" +
                              slaveIds.join("', '") +
                              "') AND `provisioning_status` = 3";
                            obj2.prepare();
                            obj2.execute((error: any, allcamp: any) => {
                              let campaignKeys = allcamp.map(
                                (row: any) => row.campaign_key
                              );
                              if (campaignKeys.length > 0) {
                                campaignKeys.forEach((element: any) => {
                                  let obj3 = new ModelRawNonQuery(req, res);
                                  obj3.nonqrysql =
                                    "SELECT `did` from `did_buy` WHERE `camp_registry`='" +
                                    element +
                                    "'";
                                  obj3.prepare();
                                  obj3.execute((err: any, dids: any) => {
                                if(dids.length>0){
                                    let allDids = dids.map((row: any) => row.did);
                                      allDids.forEach((did: any) => {
                                          let obj4 = new ModelRawNonQuery(req, res);
                                          obj4.nonqrysql =
                                            "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_status`=0 WHERE `did`='" +
                                            did +
                                            "' ";
                                          obj4.prepare();
                                          obj4.execute((err: any, result: any) => {
                                            let obj5 = new ModelRawNonQuery(req, res);
                                            obj5.nonqrysql =
                                              "UPDATE  `campaign` SET `did_count` = `did_count`-1 WHERE  `campaign_key` = '" +
                                              element +
                                              "' ";
                                            obj5.prepare();
                                            obj5.execute((err: any, ress: any) => {
                                              let obj6 = new ModelRawNonQuery(req, res);
                                              obj6.nonqrysql =
                                                "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                sdata.cgID +
                                                "' ";
                                              obj6.prepare();
                                              obj6.execute(() => {});
                                              let obj7 = new ModelRawNonQuery(req, res);
                                            obj7.nonqrysql =
                                              "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                              sdata.cgID +
                                              "' ";
                                            obj7.prepare();
                                            obj7.execute((err:any,result:any) => {});
                                            });
                                          });
                                        });
                                    }
                                else{  
                                  let obj6 = new ModelRawNonQuery(req, res);
                                  obj6.nonqrysql =
                                    "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                    sdata.cgID +
                                    "' ";
                                  obj6.prepare();
                                  obj6.execute((err:any,ress:any) => {});
                                  let obj7 = new ModelRawNonQuery(req, res);
                                  obj7.nonqrysql =
                                    "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                    sdata.cgID +
                                    "' ";
                                  obj7.prepare();
                                  obj7.execute((err:any,result:any) => {});
                                    }
                                             
                                  });
                                });
                              } 
                              else {
                                
                                  let obj6 = new ModelRawNonQuery(req, res);
                                  obj6.nonqrysql =
                                    "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                    sdata.cgID +
                                    "' ";
                                  obj6.prepare();
                                  obj6.execute((err:any,ress:any) => { });
                                  let obj7 = new ModelRawNonQuery(req, res);
                                  obj7.nonqrysql =
                                    "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                    sdata.cgID +
                                    "' ";
                                  obj7.prepare();
                                  obj7.execute((err:any,result:any) => {});
                              }
                            });
                        }
                      }
                      
                      else{
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql =
                          "SELECT `campaign_key` FROM `campaign` WHERE `idaccount` IN ('" +
                          slaveIds.join("', '") +
                          "') AND `provisioning_status` = 3";
                        obj2.prepare();
                        obj2.execute((error: any, allcamp: any) => {
    
                          let campaignKeys = allcamp.map(
                            (row: any) => row.campaign_key
                          );
                          if (campaignKeys.length > 0) {
                            campaignKeys.forEach((element: any) => {
                              let obj3 = new ModelRawNonQuery(req, res);
                              obj3.nonqrysql =
                                "SELECT `did` from `did_buy` WHERE `camp_registry`='" +
                                element +
                                "'";
                              obj3.prepare();
                              obj3.execute((err: any, dids: any) => {
                            if(dids.length>0){                             
                                let allDids = dids.map((row: any) => row.did);
                                  allDids.forEach((did: any) => {
                                      let obj4 = new ModelRawNonQuery(req, res);
                                      obj4.nonqrysql =
                                        "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_status`=0 WHERE `did`='" +
                                        did +
                                        "' ";
                                      obj4.prepare();
                                      obj4.execute((err: any, result: any) => {
                                        let obj5 = new ModelRawNonQuery(req, res);
                                        obj5.nonqrysql =
                                          "UPDATE  `campaign` SET `did_count` = `did_count`-1 WHERE  `campaign_key` = '" +
                                          element +
                                          "' ";
                                        obj5.prepare();
                                        obj5.execute((err: any, ress: any) => {
                                          let obj6 = new ModelRawNonQuery(req, res);
                                          obj6.nonqrysql =
                                            "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                            sdata.cgID +
                                            "' ";
                                          obj6.prepare();
                                          obj6.execute(() => {});
                                          let obj7 = new ModelRawNonQuery(req, res);
                                            obj7.nonqrysql =
                                              "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                              sdata.cgID +
                                              "' ";
                                            obj7.prepare();
                                            obj7.execute((err:any,result:any) => {});
                                        });
                                      });
                                    });
                                }
                            else
                            {
                              let obj6 = new ModelRawNonQuery(req, res);
                              obj6.nonqrysql =
                                "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                sdata.cgID +
                                "' ";
                              obj6.prepare();
                              obj6.execute((err:any,ress:any) => {
                              });
                              let obj7 = new ModelRawNonQuery(req, res);
                              obj7.nonqrysql =
                                "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                sdata.cgID +
                                "' ";
                              obj7.prepare();
                              obj7.execute((err:any,result:any) => {});
                                }
                                         
                              });
                            });
                          } 
                          else {
                              let obj6 = new ModelRawNonQuery(req, res);
                              obj6.nonqrysql =
                                "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                sdata.cgID +
                                "' ";
                              obj6.prepare();
                              obj6.execute((err:any,ress:any) => {});
                              let obj7 = new ModelRawNonQuery(req, res);
                              obj7.nonqrysql =
                                "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                sdata.cgID +
                                "' ";
                              obj7.prepare();
                              obj7.execute((err:any,result:any) => {});
                          }
                        });
                    }
                      
                    });
                    let objv1 = new RawView(res);
                      objv1.prepare({
                        message: "Customer Group Deleted Successfully",
                        status: 200,
                      });
                      objv1.execute();
                } 
                else 
                {
                    let obj6 = new ModelRawNonQuery(req, res);
                    obj6.nonqrysql =
                      "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                      sdata.cgID +
                      "' ";
                    obj6.prepare();
                    obj6.execute(() => {
                      let obj7 = new ModelRawNonQuery(req, res);
                      obj7.nonqrysql =
                        "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                        sdata.cgID +
                        "' ";
                      obj7.prepare();
                      obj7.execute((err:any,result:any) => {});
                      let objv1 = new RawView(res);
                      objv1.prepare({
                        message: "Customer Group Deleted Successfully",
                        status: 200,
                      });
                      objv1.execute();
                    });
                  }
                } else {
                  let objv = new RawView(res);
                  objv.prepare({ message: "Something went wrong!", status: 502 });
                  objv.execute();
                }
              });
            } else {
              let objv = new RawView(res);
              objv.prepare({ message: "Service Not Available!", status: 503 });
              objv.execute();
            }
          } else {
            let objv = new Res406(res);
            objv.prepare(session);
            objv.execute();
          }
        });
    }
}