import { Request, Response, NextFunction, response } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { SinchSMS } from "./SinchSMS";
import { TeleSMS } from "./TeleApiSMS";
import { SMS } from "./APISMSBase";
import { InteliquentSMS } from "./InteliquentSMS";
import { LergApi } from "./lrnApi";
var request = require("request");
var key = "30b32113d0eb4ec9984d9042a49171c6";
import { sessiondata } from '../server';
import { APIBase } from "./APIBase";
import { UploadDirectory } from "../config/setting.config";

export class Sms extends AppRoute {
  constructor() {
    super();
  }

  messages(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let checkService = new APIBase();
        checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
          if (resp.status == 200) {
            var data: any = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
            if (data.FROM !== undefined && data.TO !== undefined) {

              if (req.file && req.file != null && req.file != undefined) {
                let mms = new Sms();
                mms.SendMms(req, res, next);
              }
              else {
                let sms = new Sms();
                sms.SendSms(req, res, next);
              }

            }
            else {
              let objv = new RawView(res);
              objv.prepare({ message: 'All Fields are Required,FROM ,TO' });
              objv.execute();
            }
          } else {
            let objv = new RawView(res);
            objv.prepare({
              error_code: err,
              status: resp.status,
              message: resp.message.replace(/::SN::/g, "SMS")
            });
            objv.execute();
          }
        })

      }
      else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public SendSms(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let data = req.body;
        if (data.FROM !== undefined && data.FROM !== null && data.FROM !== '' && data.TO !== undefined && data.TO !== null && data.TO !== '' && data.BODY) {
          data.FROM = data.FROM.replace(/\D/g, '')
          data.TO = data.TO.replace(/\D/g, '')
          let did = data.FROM ? data.FROM.trim() : '';
          let len = did.length - 10;
          let npa = did.slice(len, len + 3);
          // console.log("Number Type is NN");
          let checkService = new APIBase();
          checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
            if (resp.status == 200) {
              // To check the LRN details
              let PayLoad: any = {
                TO: data.TO
              }
              let lerg = new LergApi("", "");
              lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : data.TO
                checkService.checkNumberType(did, (errorr, resp) => {
                  if (resp.data == 'TF') { // Toll Free
                    let objV1 = new ModelRawQuery(req, res);
                    objV1.qrysql = "CALL Send2SMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "','TollFree');"
                    objV1.prepare();
                    objV1.execute((Error: any, Result: any) => {
                      if (Error == 1) {
                        let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
                        let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
                        let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""
                        // To check the account balance
                        if (dWallet && dWallet.TotalBalance > 0) {
                          // To check the DID
                          if (dDID) {
                            // To check the lerg info data
                            if (dLergDt) {
                              let pLoad: any = {
                                SmsProvider: dDID.SmsProvider,
                                DIDProvider: dDID.DIDProvider,
                                campaignId: dDID.campaignId,
                                dLergDt: dLergDt
                              }
                              let smsTF: SMS;
                              smsTF = new InteliquentSMS();
                              smsTF.SendTFSms(req, res, next, sessdata, pLoad, (err, respp) => { });
                            }
                            else {
                              let objv = new RawView(res);
                              objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                              objv.execute();
                            }
                          }
                          else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                            objv.execute();
                          }
                        }
                        else {
                          let objv = new RawView(res);
                          objv.prepare({
                            error: "",
                            message: "Please add funds to your account or contact support.",
                            status: 503
                          });
                          objv.execute();
                        }
                      }
                      else {
                        let objv = new RawView(res);
                        objv.prepare({
                          error: Error,
                          message: "Something Went Wrong to Fetch Account Data!",
                          status: 404
                        });
                        objv.execute();
                      }
                    })
                  }
                  else if (resp.data == 'SC') {
                    console.log("Number Type is Short-Code", did);
                    // To get the overall data for sms
                    let objV1 = new ModelRawQuery(req, res);
                    objV1.qrysql = "CALL Send2SMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "','ShortCode');"
                    objV1.prepare();
                    objV1.execute((Error: any, Result: any) => {
                      if (Error == 1) {
                        let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
                        let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
                        let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""
                        // To check the account balance
                        if (dWallet && dWallet.TotalBalance > 0) {
                          // To check the DID
                          if (dDID) {
                            // To check the lerg info data
                            if (dLergDt) {
                              if (dDID.SmsProvider == 'sinch') {
                                let smsSC: SMS;
                                let Data: any = {
                                  sessdata: sessdata,
                                  lergData: [dLergDt]
                                };                                
                                smsSC = new SinchSMS();
                                smsSC.SendSms(req, res, next, Data, dDID, (error, resp) => { })
                              } else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 501, message: "Provider is invalid!" });
                                objv.execute();
                              }

                            }
                            else {
                              let objv = new RawView(res);
                              objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                              objv.execute();
                            }

                          }
                          else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                            objv.execute();
                          }

                        }
                        else {
                          let objv = new RawView(res);
                          objv.prepare({
                            error: "",
                            message: "Please add funds to your account or contact support.",
                            status: 503
                          });
                          objv.execute();
                        }

                      }
                      else {
                        let objv = new RawView(res);
                        objv.prepare({
                          error: Error,
                          message: "Something Went Wrong to Fetch Account Data!",
                          status: 404
                        });
                        objv.execute();
                      }

                    });

                  }
                  else {
                    // To get the overall data for sms
                    let objV1 = new ModelRawQuery(req, res);
                    objV1.qrysql = "CALL Send2SMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "','10DLC');"
                    objV1.prepare();
                    objV1.execute((Error: any, Result: any) => {
                      if (Error == 1) {
                        let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
                        let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
                        let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""
                        // To check the account balance
                        if (dWallet && dWallet.TotalBalance > 0) {
                          // To check the DID
                          if (dDID) {
                            // To check the lerg info data
                            if (dLergDt) {
                              let sms: SMS;
                              let Data: any = {
                                sessdata: sessdata,
                                lergData: [dLergDt]
                              };
                              // Local Number
                              switch (dDID.SmsProvider) {
                                // TeleAPI sms provider
                                case 'teleapi':
                                  sms = new TeleSMS();
                                  sms.SendSms(req, res, next, Data, dDID, (error, resp) => { })
                                  break;

                                // Sinch sms provider
                                case 'sinch':
                                  sms = new SinchSMS();
                                  sms.SendSms(req, res, next, Data, dDID, (error, resp) => { })
                                  break;

                                // Inteliquent sms provider
                                case 'Inteliquent':
                                  sms = new InteliquentSMS();
                                  sms.SendSms(req, res, next, Data, dDID, (error, resp) => { });
                                  break;

                                // Syneverse sms provider
                                case 'syniv':
                                  dDID.SmsProvider = "synverse4";
                                  sms = new SinchSMS();
                                  sms.SendSms(req, res, next, Data, dDID, (error, resp) => { })
                                  /* let cSess: any = new CSESSION()
                                  cSess.GetSynv((error: any, result: any) => {
                                    if (error == 1) {
                                      let ID: string = "synverse" + result
                                      console.log("SMSID::", ID)
                                      cSess.SetSynv({
                                        id: result
                                      })
                                      dDID.SmsProvider = ID;
                                      sms = new SinchSMS();
                                      sms.SendSms(req, res, next, Data, dDID, (error, resp) => { })
                                    }
                                  }) */
                                  break;

                                default:
                                  console.log("CASE::Default")
                                  let objv = new RawView(res);
                                  objv.prepare({ message: "Invalid Account Setting", status: 502 });
                                  objv.execute();
                                  break;
                              }
                            }
                            else {
                              let objv = new RawView(res);
                              objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                              objv.execute();
                            }
                          }
                          else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                            objv.execute();
                          }
                        }
                        else {
                          let objv = new RawView(res);
                          objv.prepare({
                            error: "",
                            message: "Please add funds to your account or contact support.",
                            status: 503
                          });
                          objv.execute();
                        }
                      }
                      else {
                        let objv = new RawView(res);
                        objv.prepare({
                          error: Error,
                          message: "Something Went Wrong to Fetch Account Data!",
                          status: 404
                        });
                        objv.execute();
                      }
                    })
                  }
                });
              })
            }
            else {
              let objv = new RawView(res);
              objv.prepare({
                error_code: err,
                status: resp.status,
                message: resp.message.replace(/::SN::/g, "SMS")
              });
              objv.execute();
            }
          });
        }
        else {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message: 'All Fields are Required, FROM, TO, BODY' });
          objv.execute();
        }
      }
      else {
        let objv = new RawView(res);
        objv.prepare({ status: 401, message: 'Invalid authorization!' });
        objv.execute();
      }
    });
  }

  public SendMms(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((sessErr: any, sessdata: any) => {
      if (sessErr == 1) {
        var sdata: any = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
        if (sdata.FROM !== undefined && sdata.TO !== undefined && req.file != null && req.file != undefined) {
          let dir = new UploadDirectory();
          let file: any = (req.file != null && req.file != undefined) ? dir.MMSMEDIAFILE + req.file.filename : "";
          let file_path: any = (req.file != null && req.file != undefined) ? dir.MMSUPLOADS + '/' + req.file.filename : "";
          let text: any = (sdata.BODY != null && sdata.BODY != undefined) ? sdata.BODY : "";
          let extension = req.file.filename.split('.').pop();
          let checkService = new APIBase();
          checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
            if (resp.status == 200) {
              let payLoad = {
                file: file,
                extension: extension,
                text: text,
                file_path: file_path,
                file_size: req.file.size
              }
              let mms = new Sms();
              mms.mmsBody(req, res, payLoad, sdata, sessdata, next);
            }
            else {
              let objv = new RawView(res);
              objv.prepare({
                error_code: err,
                status: resp.status,
                message: resp.message.replace(/::SN::/g, "SMS")
              });
              objv.execute();
            }
          });
        }
        else {
          let objv = new RawView(res);
          objv.prepare({ status: 404, message: 'All Fields are Required, FROM, TO and ATTACHMENT' });
          objv.execute();
        }
      }
      else {
        let objv = new RawView(res);
        objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
        objv.execute();
      }
    });
  }

  messagesbymedia(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        var data: any = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
        if (data.FROM !== undefined && data.TO !== undefined) {

          if (data.mediaID && data.mediaID != null && data.mediaID != undefined) {
            let mms = new Sms();
            mms.mmsbymedia(req, res, next);
          }
          else {
            let sms = new Sms();
            sms.SendSms(req, res, next);
          }
        }
        else {
          let objv = new RawView(res);
          objv.prepare({ message: 'All Fields are Required,FROM ,TO' });
          objv.execute();
        }
      }
      else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public mmsbymedia(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((sessErr: any, sessdata: any) => {
      if (sessErr == 1) {
        var sdata: any = req.body.data !== undefined && req.body.data ? JSON.parse(req.body.data) : req.body;
        if (sdata.FROM !== undefined && sdata.TO !== undefined && sdata.mediaID != null && sdata.mediaID != undefined) {
          let text: any = (sdata.BODY != null && sdata.BODY != undefined) ? sdata.BODY : "";
          let obj0 = new ModelRawQuery(req, res);
          obj0.qrysql = "SELECT `audio_play`, `file_path`, `ext`, `file_size` FROM `upload_media` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "' AND `media_id` = '" + sdata.mediaID + "'";
          obj0.prepare();
          obj0.execute((error: any, result: any) => {
            if (error == 1 && result.length > 0) {
              let payLoad = {
                file: result[0].audio_play,
                extension: result[0].ext,
                text: text,
                file_path: result[0].file_path,
                file_size: result[0].file_size
              }
              let mms = new Sms();
              mms.mmsBody(req, res, payLoad, sdata, sessdata, next);

            }
            else {
              let objv = new RawView(res);
              objv.prepare({ message: "Invalid Media ID!", status: 502 });
              objv.execute();
            }
          });
        }
        else {
          let objv = new RawView(res);
          objv.prepare({ status: 404, message: 'All Fields are Required, FROM, TO and Media ID' });
          objv.execute();
        }
      }
      else {
        let objv = new RawView(res);
        objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
        objv.execute();
      }
    });
  }

   mmsBody(req: Request, res: Response, payLoad: any, sdata: any, sessdata: any, next: NextFunction) {
    let TO = sdata.TO.replace(/\D/g, '').slice(-10);
    let FROM = sdata.FROM.replace(/\D/g, '').slice(-10);  
    // To check the LRN details
    let PayLoad: any = {
      TO: TO
    }
    let lerg = new LergApi("", "");
    lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
      let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : TO;
      let checkService = new APIBase();
      checkService.checkNumberType(FROM, (errorr, resp) => {
        if (resp.data == 'TF') { // Toll Free
          let objV1 = new ModelRawQuery(req, res);
          objV1.qrysql = "CALL Send2MMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + FROM + "', '" + ToNumber + "','TollFree');";
          objV1.prepare();
          objV1.execute((Error: any, Result: any) => {
            if (Error == 1) {
              let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
              let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
              let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""
              // To check the account balance
              if (dWallet && dWallet.TotalBalance > 0) {
                // To check the DID
                if (dDID) {
                  // To check the lerg info data
                  if (dLergDt) {
                    let pLoad: any = {
                      SmsProvider: dDID.SmsProvider,
                      DIDProvider: dDID.DIDProvider,
                      campaignId: dDID.campaignId,
                      fileUrl: payLoad.file,
                      dLergDt: dLergDt
                    }
                    let smsTF: SMS;
                    smsTF = new InteliquentSMS();
                    smsTF.SendTFMms(req, res, next, sessdata, pLoad, (err, respp) => { });
                  }
                  else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 402, message: "Lerg Info Not Found" });
                    objv.execute();
                  }
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                  objv.execute();
                }
              }
              else {
                let objv = new RawView(res);
                objv.prepare({
                  error: "",
                  message: "Please add funds to your account or contact support.",
                  status: 503
                });
                objv.execute();
              }
            }
            else {
              let objv = new RawView(res);
              objv.prepare({
                error: Error,
                message: "Something Went Wrong to Fetch Account Data!",
                status: 502
              });
              objv.execute();
            }
          });
        }
        else if (resp.data == 'SC') {
          console.log("Number Type is Short-Code", FROM);
          // To get the overall data for sms
          let objV1 = new ModelRawQuery(req, res);
          objV1.qrysql = "CALL Send2MMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + FROM + "', '" + ToNumber + "','ShortCode');"
          objV1.prepare();
          objV1.execute((Error: any, Result: any) => {
            if (Error == 1) {
              let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
              let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
              let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""
              // To check the account balance
              if (dWallet && dWallet.TotalBalance > 0) {
                // To check the DID
                if (dDID) {
                  // To check the lerg info data
                  if (dLergDt) {
                    let payloadData = this.fileChecker(res, payLoad, dDID.SmsProvider);
                    if (payloadData.error !== undefined && payloadData.error) {
                      let objv = new RawView(res);
                      objv.prepare({ message: payloadData.error, status: payloadData.status });
                      objv.execute();
                    }
                    else {
                      if (dDID.SmsProvider == 'sinch') {
                        let smsSC: SMS;
                        let Data: any = {
                          sessdata: sessdata,
                          DIDdata: dDID,
                          lergData: [dLergDt],
                          fileType: payloadData.fType,
                          file: payLoad.file,
                          file_path: payLoad.file_path
                        };
                        smsSC = new SinchSMS();
                        smsSC.SendMms(req, res, next, Data, dDID, (error, resp) => { })
                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 501, message: "Provider is invalid!" });
                        objv.execute();
                      }
                    }

                  }
                  else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                    objv.execute();
                  }

                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                  objv.execute();
                }

              }
              else {
                let objv = new RawView(res);
                objv.prepare({
                  error: "",
                  message: "Please add funds to your account or contact support.",
                  status: 503
                });
                objv.execute();
              }

            }
            else {
              let objv = new RawView(res);
              objv.prepare({
                error: Error,
                message: "Something Went Wrong to Fetch Account Data!",
                status: 404
              });
              objv.execute();
            }

          });

        }
        else {
          // To get the overall data for MMS
          let objV1 = new ModelRawQuery(req, res);
          objV1.qrysql = "CALL Send2MMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + FROM + "', '" + ToNumber + "','10DLC');";
          objV1.prepare();
          objV1.execute((Error: any, Result: any) => {
            if (Error == 1) {
              let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
              let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
              let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""
              // To check the account balance
              if (dWallet && dWallet.TotalBalance > 0) {
                // To check the DID
                if (dDID) {
                  // To check the lerg info data
                  if (dLergDt) {
                    let sms: SMS;
                    let payloadData = this.fileChecker(res, payLoad, dDID.SmsProvider);
                    console.log(dDID.SmsProvider, "File Checker::", payloadData);

                    if (payloadData.error !== undefined && payloadData.error) {
                      let objv = new RawView(res);
                      objv.prepare({ message: payloadData.error, status: payloadData.status });
                      objv.execute();
                    }
                    else {
                      let Data: any = {
                        sessdata: sessdata,
                        DIDdata: dDID,
                        lergData: [dLergDt],
                        fileType: payloadData.fType,
                        file: payLoad.file,
                        file_path: payLoad.file_path
                      };
                      // Proceed with sending the MMS using the Data object
                      switch (dDID.SmsProvider) {
                        // Sinch mms provider
                        case 'sinch':
                          sms = new SinchSMS();
                          sms.SendMms(req, res, next, Data, "sinch", (error, resp) => { })
                          break;

                        case 'syniv':
                          let ID: string = "synverse4";
                          sms = new SinchSMS();
                          sms.SendSynivMms(req, res, next, Data, ID, (error, resp) => { })
                          /* let cSess: any = new CSESSION()
                          cSess.GetSynv((error: any, result: any) => {
                            if (error == 1) {
                              let ID: string = "synverse" + result
                              console.log("SMSID::", ID)

                              cSess.SetSynv({
                                id: result
                              })
                              
                              sms = new SinchSMS();
                              sms.SendSynivMms(req, res, next, Data, ID, (error, resp) => { })
                            }
                          }) */
                          break;

                        default:
                          console.log("CASE::Default")
                          let objv = new RawView(res);
                          objv.prepare({ message: "Invalid Account Setting", status: 502 });
                          objv.execute();
                          break;
                      }
                    }
                  }
                  else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 402, message: "Lerg Info Not Found" });
                    objv.execute();
                  }
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                  objv.execute();
                }
              }
              else {
                let objv = new RawView(res);
                objv.prepare({
                  error: "",
                  message: "Please add funds to your account or contact support.",
                  status: 503
                });
                objv.execute();
              }
            }
            else {
              let objv = new RawView(res);
              objv.prepare({
                error: Error,
                message: "Something Went Wrong to Fetch Account Data!",
                status: 502
              });
              objv.execute();
            }
          });
        }
      });

    });
  }

  fileChecker(res: Response, payLoad: any, provider: string): any {
    let fType: any = [];
    let maxSize: number;
    let allowedTypes: string[];
    let message: string;
    if (provider === 'sinch') {
      message = "File too Big, please select a file less than 1MB!";
      maxSize = 1 * 1024 * 1024;
      allowedTypes = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'pdf', 'mp4', 'mp3', 'mov', 'vcf'];
      switch (payLoad.extension) {
        case 'jpg':
        case 'jpeg':
        case 'png':
        case 'gif':
        case 'webp':
          fType = [{ image: { "url": payLoad.file }, 'message-text': payLoad.text }];
          break;

        case 'pdf':
          fType = [{ pdf: { url: payLoad.file }, 'message-text': payLoad.text }];
          break;

        case 'mp4':
          fType = [{ video: { url: payLoad.file }, 'message-text': payLoad.text }];
          break;

        case 'mp3':
          fType = [{ audio: { url: payLoad.file }, 'message-text': payLoad.text }];
          break;

        case 'vcf':
          fType = [{ contact: { url: payLoad.file }, 'message-text': payLoad.text }];
          break;

        default:
          fType = [{ image: { "url": payLoad.file }, 'message-text': payLoad.text }];
          break;
      }
    }
    else {
      message = "File too Big, please select a file less than 5MB!";
      maxSize = 5 * 1024 * 1024;
      allowedTypes = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'qcelp', 'qcp', 'xwav', 'midi', 'mid', 'amr', 'aac', 'aacp', 'vcf', 'h263', 'h264', 'jpgv', '3gp', '3g2', 'gz', 'rtf', 'mov', 'webp', 'mp4', 'mp3'];
      fType = [];
    }
    if (payLoad.file_size > maxSize) {
      return {
        error: message,
        status: 502
      };
    }
    if (!allowedTypes.includes(payLoad.extension)) {
      return {
        error: "File type is not allowed!",
        status: 502
      };
    }
    return {
      fType: fType
    };
  }

  public mdrsearch(req: Request, res: Response, next: NextFunction) {
    console.log("Req==>" + JSON.stringify(req.body));
    var sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        var options = {
          'method': 'GET',
          'url': 'https://sms.api.sinch.com/xms/v1/IPLink_gw111/batches/' + `${sdata.Batch_Id}` + '/delivery_report/' + `${sdata.Recipient_id}`,
          'headers': {
            'Authorization': "Bearer " + key,
            'Content-Type': 'application/json'
          }
        };
        request(options, function (error: any, response: any) {
          if (error) {
            let obj = new RawView(res);
            obj.prepare({ "message": error })
            obj.execute();
          } else {
            try {
              console.log("Body==>", response.body);
              var smsdetails = JSON.parse(response.body);
              let obj = new ModelRawNonQuery(req, res);
              obj.nonqrysql = "UPDATE `mdr` SET `status`='" + smsdetails.status + "' , `deliver_at`='" + smsdetails.at + "' , `operator_status_at`='" + smsdetails.operator_status_at + "' WHERE `batch_id`='" + sdata.Batch_Id + "' AND `idaccount`='" + sessdata.idaccount + "'";
              obj.prepare();
              obj.execute((error, responce) => {
                if (responce) {
                  let obj = new ModelRawQuery(req, res);
                  obj.qrysql = "SELECT * FROM `mdr` WHERE `batch_id`='" + sdata.Batch_Id + "' AND `idaccount`='" + sessdata.idaccount + "'";
                  obj.prepare();
                  obj.execute((err, resp) => {
                    let obj1 = new RawView(res);
                    obj1.prepare({ "message": "Sms Details", "result": resp });
                    obj1.execute();
                  })
                } else {
                  let obj = new RawView(res);
                  obj.prepare({ "message": error })
                  obj.execute();
                }
              })
            }
            catch (e) {
              console.log("Error :: smsApi->mdrsearch::", e);
              let objv = new RawView(res);
              objv.prepare({ status: 502, message: "Something went wrong!" });
              objv.execute();
            }
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    })
  }


  /**
   * @un-used APIs
   */
  public SendSms_Old(req: Request, res: Response, next: NextFunction) {
    let data = req.body;
    if (data.FROM !== undefined && data.TO !== undefined && data.BODY) {
      let sdata: any = [];
      let session = new SessionManagment(req, res, next);
      session.GetSession((error: any, sessdata: any) => {
        if (error == 1) {
          let obj5 = new ModelRawQuery(req, res);
          obj5.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 0"
          obj5.prepare();
          obj5.execute((walletError: any, wallet: any) => {
            if (walletError == 1) {
              if (wallet.length > 0) {
                let lergLogin = new LergApi("", "");
                lergLogin.signIn(req, res, (auth_err, auth_details) => {
                  if (auth_details !== undefined) {
                    let auth_token = auth_details.auth_token
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `sms_provider` FROM `did_buy` WHERE iduser='" + sessdata.iduser + "' AND `did`='" + data.FROM + "'";
                    obj1.prepare();
                    obj1.execute((error, responce) => {
                      if (responce.length > 0) {
                        let sms: SMS;

                        switch (responce[0].sms_provider) {
                          case 'teleapi':
                            sms = new TeleSMS();
                            sms.SendSms(req, res, next, auth_token, "teleapi", (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Sent Successfully", "result": resp, status: 201 });
                                obj1.execute();
                              } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                obj.execute();
                              }
                            })
                            break;

                          case 'sinch':
                            sms = new SinchSMS();
                            sms.SendSms(req, res, next, auth_token, "sinch", (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Sent Successfully", "result": resp, status: 201 });
                                obj1.execute();
                              } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                obj.execute();
                              }
                            })
                            break;

                          case 'Inteliquent':
                            sms = new InteliquentSMS();
                            sms.SendSms(req, res, next, auth_token, "inteliquent", (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Sent Successfully", "result": resp, status: 201 });
                                obj1.execute();
                              } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                obj.execute();
                              }
                            });
                            break;

                          case 'syniv':
                            let ID: string = "synverse4";
                            sms = new SinchSMS();
                            sms.SendSynivMms(req, res, next, auth_token, ID, (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Sent Successfully", result: resp, status: 201 });
                                obj1.execute();
                              }
                              else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", result: error, status: 502 })
                                obj.execute();
                              }
                            })
                            /* let cSess: any = new CSESSION()
                            cSess.GetSynv((error: any, result: any) => {
                              if (error == 1) {
                                let ID: string = "synverse" + result
                                console.log("SMSID::", ID)

                                cSess.SetSynv({
                                  id: result
                                })

                                sms = new SinchSMS();
                                sms.SendSynivMms(req, res, next, auth_token, ID, (error, resp) => {
                                  if (resp) {
                                    let obj1 = new RawView(res);
                                    obj1.prepare({ message: "SMS Sent Successfully", result: resp, status: 201 });
                                    obj1.execute();
                                  }
                                  else {
                                    let obj = new RawView(res);
                                    obj.prepare({ message: "Somthing went Wrong", result: error, status: 502 })
                                    obj.execute();
                                  }
                                })
                              }
                            }) */
                            break;

                          default:
                            console.log("CASE::Default")
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Account Setting", status: 502 });
                            objv.execute();
                            break;
                        }
                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Invalid Account Setting", status: 502 });
                        objv.execute();
                      }
                    });
                  }
                });
              }
              else {
                let objv = new RawView(res);
                objv.prepare({ error: wallet, message: "Please add funds to your account or contact support.", status: 503 });
                objv.execute();
              }
            }
            else {
              let objv = new RawView(res);
              objv.prepare({ error: wallet, message: "Something Went Wrong to Fetch Account Balance!", status: 502 });
              objv.execute();
            }
          });
        }
        else {
          let objv = new Res406(res);
          objv.prepare("No session data there");
          objv.execute();
        }
      });
    }
    else {
      let objv = new RawView(res);
      objv.prepare({ message: 'All Fields are Required,FROM ,TO, BODY' });
      objv.execute();
    }
  }

}

export class CSESSION {
  constructor() { }

  public GetSynv(callback: (error: any, data: any) => void) {
    callback(1, sessiondata.get("smscID"))
  }

  public SetSynv(data: any) {
    switch (data.id) {
      case 4: {
        sessiondata.set("smscID", 5)
        break
      }

      case 5: {
        sessiondata.set("smscID", 7) // 6 
        break
      }

      /* case 6: {
        sessiondata.set("smscID", 7)
        break
      } */

      case 7: {
        sessiondata.set("smscID", 4)
        break
      }

      default: {
        sessiondata.set("smscID", 4)
      }
    }
  }


}