import e, { Request, Response, NextFunction } from "express";
import { SessionManagment } from "../lib/model/Session";
import { AppRoute } from "../lib/AppRoute";
import { Res406 } from "../lib/view/406";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import {parseBody,setToZero} from "./markError";

const fs = require('fs');
const path = require('path');

export class TemplateSetting extends AppRoute {
	constructor() {
		super();
	}

	emailTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				if ((sdata.subject !== undefined && sdata.subject !== 'null') && (sdata.type !== undefined && sdata.type !== 'null') && (sdata.template !== undefined && sdata.template !== 'null')) {
					// let temp: any = typeof sdata.template != 'undefined' ? sdata.template : ""

					// temp = String(temp).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/©/g, '&copy;')
					// temp = temp.replace(/'/g, "\\'")

					let obj = new ModelRawNonQuery(req, res);
					obj.nonqrysql = "INSERT INTO `email_template`(`idaccount`,`subject`,`type`,`template`) VALUES ( '" + sessData.idaccount + "', '" + parseBody(sdata.subject) + "','" + parseBody(sdata.type) + "','" + parseBody(sdata.template) + "')";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Email Template Saved Successfully ", data: result, status: 201 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With connection!", status: 502 });
							objv.execute();
						}
					})
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "You can't send null value or something went wrong with email template!", status: 502 });
					objv.execute();
				}

			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	updateStatus(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "UPDATE email_template SET status = '" + req.body.status + "' WHERE idemail_template = '" + req.body.id + "'";
				obj.prepare();
				obj.execute((error: any, lastid: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Status Update Successfully", data: lastid[0], status: 201 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Status Update Successfully.", data: lastid, status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare("No Session data there");
				objv.execute();
			}
		})
	}

	getEmailTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM email_template WHERE `idemail_template` = '" + sdata.idemail_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: 'Email Template Fatched', data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 503 });
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	getEmailTemplates(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM email_template WHERE idaccount='" + sessData.idaccount + "' ORDER BY `idemail_template` ASC";
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: 'Email Template Fatched', data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				})
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}

	updateEmailTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any) => {
			if (error == 1) {
				if ((sdata.idemail_template !== undefined && sdata.idemail_template !== null) && (sdata.subject !== undefined && sdata.subject !== 'null') && (sdata.type !== undefined && sdata.type !== 'null') && (sdata.template !== undefined && sdata.template !== 'null')) {
					// let temp: any = typeof sdata.template != 'undefined' ? sdata.template : ""

					// temp = String(temp).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/©/g, '&copy;')
					// temp = temp.replace(/'/g, "\\'")

					let obj = new ModelRawNonQuery(req, res);
					obj.nonqrysql = "UPDATE `email_template` SET `subject`= '" + parseBody(sdata.subject) + "', `type`='" + parseBody(sdata.type) + "', `template` ='" + parseBody(sdata.template) + "' WHERE idemail_template= '" + sdata.idemail_template + "'";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Email Template Updated Successfully!", data: result, status: 201 });
							objv.execute();
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
							objv.execute();
						}
					})
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "You can't send null value or something went wrong with email template!", status: 502 });
					objv.execute();
				}
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	deleteEmailTempalte(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any) => {
			if (err == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "DELETE FROM `email_template` WHERE `idemail_template`='" + sdata.idemail_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Email Tempalate Deleted!", data: result, status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Database!", status: 502 });
						objv.execute();
					}
				});
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	smsTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "INSERT INTO `sms_template`(`idaccount`, `name`, `type`, `body`) VALUES ('" + sessData.idaccount + "', '" + sdata.name + "','" + sdata.type + "','" + sdata.body + "')";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "SMS Template Saved Successfull", data: result, status: 201 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Somthing Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
				objv.execute();
			}
		})
	}

	updateStatusSMS(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "UPDATE sms_template SET status ='" + req.body.status + "' WHERE idsms_template= '" + req.body.id + "'";
				obj.prepare();
				obj.execute((error: any, lastid: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Status Updated Successfully", data: lastid[0], status: 201 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Status Updated Successfully", data: lastid, status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare("No Session data there");
				objv.execute();
			}
		})
	}

	getSmsTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM sms_template WHERE `idsms_template` = '" + sdata.idsms_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "SMS Template Fatch", data: result, status: 200 })
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Somthing Went Wrong With Connection", status: 503 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	getSmsTemplates(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM sms_template WHERE idaccount = '" + sessData.idaccount + "'";
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "SMS Template Fatched", data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong with Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}

	updateSmsTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessData: any) => {
			if (error == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "UPDATE `sms_template` SET `name`='" + sdata.name + "' , `type`='" + sdata.type + "', `body`='" + sdata.body + "' WHERE idsms_template = '" + sdata.idsms_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "SMS Template Updated Successfully!", data: result, status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection", status: 502, error: result });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	twofaTemaplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessdata: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawNonQuery(req, res);
				let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
				let temp_key = '';
				let charactersLength = characters.length;
				for (let i = 0; i < 25; i++) {
					temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
				}
				obj.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`, `type`, `body`, `tmp_type`,`template_key`) VALUES ('" + sessdata.iduser + "','" + sdata.otp_digit + "','" + setToZero(sdata.type) + "','" + parseBody(sdata.body) + "', '" + sdata.tmpType + "','" + temp_key + "')";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "2FA Template Saved Successfully", data: result, status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		})
	}

	get2FATemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM 2fa_template WHERE `id2fa_template`= '" + sdata.id2fa_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "2FA Template Fetched", data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	get2FATemplates(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM 2fa_template WHERE iduser = '" + sessData.iduser + "' AND tmp_type='" + req.query.type + "'";
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: '2FA Template Fetched', data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		})
	}

	update2FATemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any) => {
			if (error == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "UPDATE `2fa_template` SET `otp_digit`= '" + sdata.otp_digit + "',`type`= '" + setToZero(sdata.type) + "',`body`= '" + parseBody(sdata.body) + "' WHERE id2fa_template= '" + sdata.id2fa_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "2FA Template Update Successfully", data: result, status: 201 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	delete2FATemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any) => {
			if (err == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "DELETE FROM `2fa_template` WHERE `id2fa_template`='" + sdata.id2fa_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: " 2FA Template Deleted!", data: result, status: 201 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: " Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	mmsTemplate(req: Request, res: Response, next: NextFunction) {
		var sdata: any = JSON.parse(req.body.data);
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			let file_path = req.file.filename
			let extension = file_path.split('.').pop();
			let fsize: any;
			let mesg: any;
			if (extension == 'jpg' || extension == 'jpeg' || extension == 'png' || extension == 'gif' || extension == 'webp') {
				fsize = 1024 * 740;
				mesg = 'File too Big, please select a file less than 740KB!'
			} else if (extension == 'mp4') {
				fsize = 1024 * 1024;
				mesg = 'File too Big, please select a file less than 1MB!'
			}
			else if (extension == 'mp3') {
				fsize = 1024 * 740;
				mesg = 'File too Big, please select a file less than 740KB!'
			} else {
				fsize = 1024 * 740;
				mesg = 'File too Big, please select a file less than 740KB!'
			}

			if (req.file.size <= fsize) {
				let text: any;
				let file: any;
				text = sdata.body;
				if (req.file) {
					const fileName = req.file.filename;
					//file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;	
					file = 'https://mms.signalmash.com/content/' + fileName;
				}
				if (sessErr == 1) {
					let obj = new ModelRawNonQuery(req, res);
					obj.nonqrysql = "INSERT INTO `mms_template`(`idaccount`,`iduser`,`name`,`content_type`, `body`,`file_path`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + sdata.name + "','" + sdata.content_type + "','" + text + "','" + file + "')";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "MMS Template Saved Successfully", data: result, status: 200 });
							objv.execute();
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
							objv.execute();
						}
					})
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
					objv.execute();
				}
			} else {
				let objv = new RawView(res);
				objv.prepare({ status: 400, message: mesg });
				objv.execute()
			}
		})
	}

	updateMmsTemplate(req: Request, res: Response, next: NextFunction) {
		var sdata: any = JSON.parse(req.body.data)
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessData: any) => {
			let file_path = req.file.filename
			let extension = file_path.split('.').pop();
			let fsize: any;
			let mesg: any;
			if (extension == 'jpg' || extension == 'jpeg' || extension == 'png' || extension == 'gif' || extension == 'webp') {
				fsize = 1024 * 740;
				mesg = 'File too Big, please select a file less than 740KB!'
			} else if (extension == 'mp4') {
				fsize = 1024 * 1024;
				mesg = 'File too Big, please select a file less than 1MB!'
			}
			else if (extension == 'mp3') {
				fsize = 1024 * 740;
				mesg = 'File too Big, please select a file less than 740KB!'
			} else {
				fsize = 1024 * 740;
				mesg = 'File too Big, please select a file less than 740KB!'
			}
			if (req.file.size <= fsize) {
				let text: any;
				let file: any;
				text = sdata.body;
				if (req.file) {
					const fileName = req.file.filename;
					//file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
					file = 'https://mms.signalmash.com/content/' + fileName;
				}
				if (error == 1) {
					let obj = new ModelRawNonQuery(req, res);
					obj.nonqrysql = "UPDATE `mms_template` SET `name`='" + sdata.name + "',`content_type`='" + sdata.content_type + "' , `body`='" + text + "', `file_path`= '" + file + "' WHERE idmms_template = '" + sdata.idmms_template + "'";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "MMS Template Updated Successfully!", data: result, status: 201 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection", status: 502, error: result });
							objv.execute();
						}
					})
				} else {
					let objv = new Res406(res);
					objv.prepare(session);
					objv.execute();
				}
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ status: 400, message: mesg });
				objv.execute()
			}
		})
	}

	getMmsTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM mms_template WHERE `idmms_template` = '" + sdata.idmms_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "MMS Template Fetched", data: result, status: 200 })
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection", status: 503 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	getMmsTemplates(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM mms_template WHERE `iduser` = '" + sessData.iduser + "'";
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "MMS Template Fetched", data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong with Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}

	deleteMMSTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any) => {
			if (err == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "DELETE FROM `mms_template` WHERE `idmms_template`='" + sdata.idmms_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "MMS Template Deleted!", data: result, status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	setDfaultTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body.data;
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata: any) => {
			if (err == 1) {
				let obj1 = new ModelRawNonQuery(req, res);
				obj1.nonqrysql = "UPDATE `2fa_template` SET `default`= '0' WHERE iduser='" + sessdata.iduser + "'";
				obj1.prepare();
				obj1.execute((___err: any, result: any) => {
					if (___err == 1) {
						let obj1 = new ModelRawNonQuery(req, res);
						obj1.nonqrysql = "UPDATE `2fa_template` SET `default`= '1' WHERE iduser='" + sessdata.iduser + "' AND id2fa_template='" + sdata + "'";
						obj1.prepare();
						obj1.execute((__err: any, result1: any) => {
							if (__err == 1) {
								let objv = new RawView(res);
								objv.prepare({ message: "Default Template Changed Successfully!", status: 201, data: result1 });
								objv.execute();
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ message: "Something Went Wrong With Default Template!", status: 502, error: result1 });
								objv.execute();
							}
						});
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection1!", status: 502, error: result });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Something Went Wrong With Connection2!", status: 502 });
				objv.execute();
			}
		});

	}

	refactorTemplate(req: Request, res: Response, next: NextFunction) {
		let sdata = req.query;
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM email_template WHERE `idemail_template` = '" + sdata.idemail_template + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						console.log("resulttttttttttt", result);
						let message = result[0].template;
						// message = message.replace('&lt;', '<').replace('&gt;','>').replace('&quot;','"').replace('&apos;',/'/g).replace('&amp;','&');
						message = message.replace(/&lt;/gi, '<').replace(/&gt;/gi, '>').replace(/&quot;/gi, '"').replace(/&apos;/gi, "'").replace(/&amp;/gi, '&')
						console.log("messageeeeee", message);
						let objv = new RawView(res);
						objv.prepare({ message: 'Email Template Fatched', data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 503 });
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}


}


