import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { APIBase } from "./APIBase";
import { SMTPDetails, TollFreeCSV } from "../config/setting.config";
import { log } from "console";
import { InteliquentAPI } from "./Inteliquent";
import { parseBody } from "./markError";
var nodemailer = require("nodemailer");
var request = require('request');
const Str = require('@supercharge/strings');
const tollfreeSMS = new TollFreeCSV();
const SMTP = new SMTPDetails();

export class TollFree extends AppRoute {
	constructor() {
		super();
	}

	public EnableTFsms(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				const sdata = JSON.parse(req.body.data);
				if (sdata.DID) {
					let tollfreeSMS = new APIBase();
					tollfreeSMS.checkNumberType(sdata.DID.trim(), (__errorr, __resp) => {
						if (__errorr == 0) {
							let intel = new InteliquentAPI("", sessdata, '');
							intel.EnableTFSMS(req, res, (error, responce) => {
								let objv = new RawView(res);
								objv.prepare({ status: responce.status, message: responce.message });
								objv.execute();
							});
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ status: 503, message: "Service Unavailable!" });
							objv.execute();
						}
					});
				}
				else {
					let objv = new RawView(res);
					objv.prepare({ status: 507, message: "DID is required" });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare("No session data there");
				objv.execute();
			}
		});
	}

	public disableTFsms(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				const sdata = JSON.parse(req.body.data);
				if (sdata.DID) {
					let tollfreeSMS = new APIBase();
					tollfreeSMS.checkNumberType(sdata.DID.trim(), (__errorr, __resp) => {
						if (__errorr == 0) { // 0 is TF
							console.log("Number Type is Toll-free");
							let intel = new InteliquentAPI("", sessdata, '');
							intel.disableTFSMS(req, res, (error, responce) => {
								let objv = new RawView(res);
								objv.prepare({ status: responce.status, message: responce.message });
								objv.execute();
							});
						} else {
							let objv = new RawView(res);
							objv.prepare({ status: 503, message: "Service Unavailable!" });
							objv.execute();
						}
					});
				}
				else {
					let objv = new RawView(res);
					objv.prepare({ status: 500, message: "DID is required" });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare("No session data there");
				objv.execute();
			}
		});
	}

	did_number(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				if (sessData.type == 2) {
					let obj = new ModelRawQuery(req, res);
					//obj.qrysql = "SELECT DISTINCT db.`did`, db.`account_id`, db.`sinch_status`, db.`created_at`, tan.`requestId` FROM did_buy db LEFT JOIN tollfree_assigned_number tan ON db.`did` = tan.`did` WHERE db.`type` = 'TF' AND db.`account_id` = '" + sessData.idaccount + "'";
					obj.qrysql = "SELECT DISTINCT db.`did`, db.`account_id`, db.`sinch_status`, db.`created_at`, tan.`requestId` FROM did_buy db LEFT JOIN tollfree_assigned_number tan ON REPLACE(db.`did`, '\r', '') = tan.`did` WHERE db.`type` = 'TF' AND db.`account_id` = '" + sessData.idaccount + "'";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: 'DID Fetched Successfully!', data: result, status: 200 });
							objv.execute();
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
							objv.execute();
						}
					})
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	saveVerfiySender(req: Request, res: Response, next: NextFunction) {
		let sdata = JSON.parse(req.body.data);
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			let uniqueId = 'RI' + Math.floor(1000 + Math.random() * 100000000);
			let key = Math.random().toString(36).slice(2);
			if (error == 1) {
				if (sessdata.type == 2) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (!sdata.previosFile) {
							console.log('no data found')
						} else {
							for (let i = 0; i < sdata.previosFile.length; i++) {
								const file = sdata.previosFile[i];
								let obj3 = new ModelRawNonQuery(req, res);
								obj3.nonqrysql = "INSERT INTO `verified_sender_file` (`iduser`, `idaccount`, `unique_request_id`,`file_upload_key` ,`file_path`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + uniqueId + "',  '" + key + "','" + file.file + "')";
								obj3.prepare();
								obj3.execute((_error: any, result: any) => {
									console.log("Data Inserted Successfully!");
								})
							}
						}
						let files: any = [];
						files = req.files;
						let FullName = result[0].firstname + ' ' + result[0].lastname;
						let obj1 = new ModelRawNonQuery(req, res);
						obj1.nonqrysql = "INSERT INTO `verified_sender` (`iduser`,`idaccount`,`messaging_provide`,`dba_name`,`business_name`,`address1`,`address2`,`city`,`state`,`zip`,`first_name`,`last_name`,`business_email`,`business_phone`,`corporate_website_url`,`summarize_usecase`,`sample_message`,`number_published`,`fortune_company`,`call_to_action_url`,`call_to_action_numbers`,`message_volume_per_month`,`use_case_category`,`opt_in_workflow_description`,`additional_supporting_documentation`,`unique_request_id`,`text_message_type`,`traffic_previously_msg_service`,`traffic_expected`,`status`,`username`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.data.messagingprovider + "', '" + parseBody(sdata.data.dbaname) + "', '" + parseBody(sdata.data.businessname) + "', '" + parseBody(sdata.data.address) + "', '" + parseBody(sdata.data.address1) + "', '" + parseBody(sdata.data.city) + "', '" + parseBody(sdata.data.state) + "', '" + parseBody(sdata.data.zip) + "', '" + parseBody(sdata.data.firstname) + "', '" + parseBody(sdata.data.lastname) + "', '" + parseBody(sdata.data.email) + "', '" + sdata.data.phonenumber + "', '" + parseBody(sdata.data.websiteurl) + "','" + parseBody(sdata.data.usecase) + "', '" + parseBody(sdata.data.contentcampaign.trim()) + "', '" + parseBody(sdata.data.published) + "', '" + parseBody(sdata.data.company) + "', '" + parseBody(sdata.data.url) + "', '" + sdata.data.numbers + "', '" + sdata.data.messagevolume + "', '" + parseBody(sdata.data.usecasecategory) + "', '" + parseBody(sdata.data.workdescription) + "','" + parseBody(sdata.data.supportdocs) + "','" + uniqueId + "','" + sdata.data.text_msg_type + "','" + sdata.data.traffic_previous_msg_service + "','" + sdata.data.traffic_expected + "','1','" + FullName + "')";
						obj1.prepare();
						obj1.execute((_error: any, result: any) => {
							if (_error == 1) {
								let obj0 = new ModelRawNonQuery(req, res);
								obj0.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '1', 'REQUEST_CREATED', 'Request created Successfully', '" + uniqueId + "')";
								obj0.prepare();
								obj0.execute((_error: any, result: any) => { });

								if (!sdata.url || sdata.url.length === 0) {
									console.log("URLS not Found")
								}
								else {
									let obj1 = new ModelRawNonQuery(req, res);
									let qry0 = "INSERT INTO `verified_sender_urls`(`iduser`, `idaccount`,`requestID`,`url`) VALUES ";

									for (let i = 0; i < sdata.url.length; i++) {
										let url = sdata.url[i];
										qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + uniqueId + "','" + url + "'),"
									}
									obj1.nonqrysql = qry0.slice(0, -1)
									obj1.prepare();
									obj1.execute((er: any, result: any) => {
										console.log("URL Inserted Successfully!");
									});
								}

								for (const file of (Array.isArray(req.files) ? req.files : Object.values(req.files)) as any[]) {
									const filePath = tollfreeSMS.tollfreecsv + file.filename;
									let obj11 = new ModelRawNonQuery(req, res);
									obj11.nonqrysql = "INSERT INTO `verified_sender_file` (`iduser`, `idaccount`, `unique_request_id`,`file_upload_key` ,`file_path`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + uniqueId + "',  '" + key + "','" + filePath + "')";
									obj11.prepare();
									obj11.execute((_error: any, result: any) => {
									});
								}
								let objv = new RawView(res);
								objv.prepare({ data: result, message: "Verified Sender Inserted Successfully", status: 200 });
								objv.execute();
							}
							else {
								let objv = new RawView(res);
								objv.prepare({
									message: "Something Went Wrong With Verified Sender Details!", status: 502, error: result
								});
								objv.execute();
							}
						})
					});
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getVerified_Sender(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let condition: any = '';
				if (sessdata.type == 1)
					condition += ''
				if (sessdata.type == 2)
					condition += "WHERE idaccount='" + sessdata.idaccount + "'"
				// if (sessdata.type == 22)
				// 	condition += "WHERE `iduser`='" + sessdata.iduser + "'"

				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `idaccount`, `iduser`, `first_name`,`last_name`,`business_name`, `unique_request_id`, `created_at`, `status`,`username`,`reject_date`,`awaiting_downstream_date`,`review_date`,`submission_reject_date`,`submission_approve_date` FROM verified_sender " + condition + "";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Verified Sender List Fetched Successfully!",
							status: 200
						});
						objv.execute();

					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Verified Sender List!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});

	}

	getsingleSenderDetails(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.query as { type: string };
				let sdata1 = JSON.parse(sdata.type);
				let obj = new ModelRawQuery(req, res);
				//obj.qrysql = "SELECT `vsl`.`idaccount`, `vsl`.`iduser`, `vsl`.`event_type`, `vsl`.`event_desc`, `vsl`.`unique_request_id`, `vsl`.`created_at`, `vsl`.`description`, `vs`.`iduser` AS `vs_iduser`, `vs`.`idaccount` AS `vs_idaccount`, `vs`.`messaging_provide`, `vs`.`dba_name`, `vs`.`business_name`, `vs`.`address1`, `vs`.`address2`, `vs`.`city`, `vs`.`state`, `vs`.`zip`, `vs`.`first_name`, `vs`.`last_name`, `vs`.`business_email`, `vs`.`business_phone`, `vs`.`corporate_website_url`, `vs`.`summarize_usecase`, `vs`.`sample_message`, `vs`.`number_published`, `vs`.`fortune_company`, `vs`.`call_to_action_url`, `vs`.`call_to_action_numbers`, `vs`.`message_volume_per_month`, `vs`.`use_case_category`, `vs`.`opt_in_workflow_description`,`vs`.`additional_supporting_documentation`, `vs`.`text_message_type`, `vs`.`traffic_previously_msg_service`, `vs`.`traffic_expected`, `vs`.`status`, GROUP_CONCAT(`vsf`.`file_path` SEPARATOR ', ') AS `file_paths`, MIN(`vsf`.`file_upload_key`) AS `file_upload_key` FROM `verified_sender_log` AS `vsl` INNER JOIN `verified_sender` AS `vs` ON `vsl`.`unique_request_id` = `vs`.`unique_request_id` LEFT JOIN `verified_sender_file` AS `vsf` ON `vsl`.`unique_request_id` = `vsf`.`unique_request_id` WHERE `vsl`.`unique_request_id` = '" + sdata1.id + "' GROUP BY `vsl`.`idaccount`, `vsl`.`iduser`, `vsl`.`event_type`, `vsl`.`event_desc`, `vsl`.`unique_request_id`, `vsl`.`created_at`, `vsl`.`description`, `vs`.`iduser`, `vs`.`idaccount`, `vs`.`messaging_provide`, `vs`.`dba_name`, `vs`.`business_name`, `vs`.`address1`, `vs`.`address2`, `vs`.`city`, `vs`.`state`, `vs`.`zip`, `vs`.`first_name`, `vs`.`last_name`, `vs`.`business_email`, `vs`.`business_phone`, `vs`.`corporate_website_url`, `vs`.`summarize_usecase`, `vs`.`sample_message`, `vs`.`number_published`, `vs`.`fortune_company`, `vs`.`call_to_action_url`, `vs`.`call_to_action_numbers`, `vs`.`message_volume_per_month`, `vs`.`use_case_category`, `vs`.`opt_in_workflow_description`, `vs`.`additional_supporting_documentation`,`vs`.`text_message_type`, `vs`.`traffic_previously_msg_service`, `vs`.`traffic_expected`, `vs`.`status`";

				obj.qrysql = "SELECT vsl.idaccount, vsl.iduser, vsl.event_type, vsl.event_desc, vsl.unique_request_id, vsl.created_at, vsl.description, vs.iduser AS vs_iduser, vs.idaccount AS vs_idaccount, vs.messaging_provide,vs.dba_name, vs.business_name, vs.address1, vs.address2, vs.city, vs.state, vs.zip, vs.first_name, vs.last_name, vs.business_email, vs.business_phone, vs.corporate_website_url, vs.summarize_usecase,vs.sample_message, vs.number_published, vs.fortune_company, vs.call_to_action_url, vs.call_to_action_numbers, vs.message_volume_per_month, vs.use_case_category, vs.opt_in_workflow_description, vs.additional_supporting_documentation, vs.text_message_type, vs.traffic_previously_msg_service, vs.traffic_expected, vs.status, vf.file_paths, vf.file_upload_key FROM verified_sender_log AS vsl INNER JOIN verified_sender AS vs ON vsl.unique_request_id = vs.unique_request_id LEFT JOIN (SELECT unique_request_id, GROUP_CONCAT(file_path SEPARATOR ', ') AS file_paths, MIN(file_upload_key) AS file_upload_key FROM verified_sender_file GROUP BY unique_request_id) AS vf ON vsl.unique_request_id = vf.unique_request_id WHERE vsl.unique_request_id = '" + sdata1.id + "'";

				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let obj1 = new ModelRawQuery(req, res);
						obj1.qrysql = "SELECT `url` FROM `verified_sender_urls` WHERE requestID = '" + sdata1.id + "'";
						obj1.prepare();
						obj1.execute((error: any, result2: any) => {
							if (_error == 1) {
								let objv = new RawView(res);
								objv.prepare({ data: result, data1: result2, message: "Url Fetched Successfully!", status: 200 });
								objv.execute();
							}
							else {
								let objv = new RawView(res);
								objv.prepare({
									message: "Something Went Wrong With Verified Sender Url!",
									status: 502,
									error: result
								});
								objv.execute();
							}
						})
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Verified Sender List!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});

	}

	/* For approve and reject sender status*/
	approveSenderStatus(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.body.data;
				if (sessdata.type == 1) {
					let obj1 = new ModelRawNonQuery(req, res);
					obj1.nonqrysql = "UPDATE `verified_sender` SET `status`= '7',`awaiting_downstream_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `unique_request_id`= '" + sdata.id + "'";
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						if (errors == 1) {
							/* log query*/
							let obj0 = new ModelRawNonQuery(req, res);
							obj0.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '7', 'REQUEST_APPROVED', 'Request Approved Successfully', '" + sdata.id + "')";
							obj0.prepare();
							obj0.execute((_error: any, result: any) => { });

							let objv0 = new RawView(res);
							objv0.prepare({ status: 201, message: "Verify Sender Approved Successfully." });
							objv0.execute();
						}
						else {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 502, message: "Something Went Wrong!" });
							objv0.execute();
						}
					})
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			} else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	rejectSenderstatus(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let sdata = req.body.data;
					let obj1 = new ModelRawNonQuery(req, res);
					obj1.nonqrysql = "UPDATE `verified_sender` SET `status`= '2',`reject_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `unique_request_id`= '" + sdata.id + "'";
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						console.log("Status Updated Successfully!");
					})
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `email` FROM `user_profile` WHERE `iduser`='" + sdata.iduser + "'";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							// var smtpTransport = nodemailer.createTransport({
							// 	service: SMTP.service,
							// 	host: SMTP.host,
							// 	port: SMTP.port,
							// 	secure: false,
							// 	auth: {
							// 		user: SMTP.user,
							// 		pass: SMTP.pass
							// 	}
							// });
							// var mailOptions = {
							// 	from: SMTP.from,
							// 	to: result[0].email,
							// 	// username: result[0].email,
							// 	email: result[0].email,
							// 	subject: SMTP.RejectSubject,
							// 	text: sdata.reject_text,
							// }
							// smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
							// 	console.log("Email Send Successfully");
							// });
							let obj1 = new ModelRawNonQuery(req, res);
							obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES ('" + sdata.iduser + "','" + sdata.idaccount + "','" + SMTP.from + "','" + result[0].email + "', '" + parseBody(SMTP.RejectSubject) + "','" + parseBody(sdata.reject_text.trim()) + "','Sender Request Rejected','11','" + parseBody(sdata.reject_text.trim()) + "')";
							obj1.prepare();
							obj1.execute((_err: any, __result: any) => {
								if (_err == 1) {
									console.log("Mail Sent Successfully!")
								}
								else {
									console.log("Something went wrong!");
								}
							});

							let obj0 = new ModelRawNonQuery(req, res);
							obj0.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','2','REQUEST_REJECTED','" + parseBody(sdata.reject_text) + "', '" + sdata.id + "')";
							obj0.prepare();
							obj0.execute((_error: any, result: any) => {
							});
							let objv0 = new RawView(res);
							objv0.prepare({ status: 201, message: "Verify Sender Rejected  Successfully." });
							objv0.execute();
						}
						else {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 502, message: "Something Went Wrong!" });
							objv0.execute();
						}
					})
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	/* For approve and reject review status*/
	approveReviewStatus(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.body.data;
				if (sessdata.type == 1) {
					let obj1 = new ModelRawNonQuery(req, res);
					obj1.nonqrysql = "UPDATE `verified_sender` SET `status`= '6',`submission_approve_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `unique_request_id`= '" + sdata.id + "'";
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						if (errors == 1) {
							let obj0 = new ModelRawNonQuery(req, res);
							obj0.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '6', 'SUBMISSION_APPROVED','Verified Sender Submission Approved','" + sdata.id + "')";
							obj0.prepare();
							obj0.execute((_error: any, result: any) => { });

							let objv0 = new RawView(res);
							objv0.prepare({ status: 201, message: "Verify Sender Approved Successfully." });
							objv0.execute();
						}
						else {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 502, message: "Something Went Wrong!" });
							objv0.execute();
						}
					})
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	rejectReviewStatus(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.body.data;
				if (sessdata.type == 1) {
					let obj1 = new ModelRawNonQuery(req, res);
					obj1.nonqrysql = "UPDATE `verified_sender` SET `status`= '5',`submission_reject_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `unique_request_id`= '" + sdata.id + "'";
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						if (errors == 1) {
							let obj0 = new ModelRawNonQuery(req, res);
							obj0.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '5', 'SUBMISSION_REJECTED','Verified Sender Submission Rejected', '" + sdata.id + "')";
							obj0.prepare();
							obj0.execute((_error: any, result: any) => {
								console.log("verified_sender log inserted");
							});
							let objv0 = new RawView(res);
							objv0.prepare({ status: 201, message: "Verify Sender Rejected  Successfully." });
							objv0.execute();
						}
						else {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 502, message: "Something Went Wrong!" });
							objv0.execute();
						}
					})
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}


	csvForIntq(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let sdata = req.body.data;
					const requestID = "'" + sdata.requestId.join("','") + "'";
					let obj1 = new ModelRawQuery(req, res);
					obj1.qrysql = "SELECT  v.unique_request_id AS REquest_ID,v.business_name AS Business_Name, v.corporate_website_url AS Corporate_Website, v.address1 AS Business_Addr1, v.address2 AS Business_Addr2, v.city AS City, v.state AS State, v.zip AS Zip, v.first_name AS Business_Contact_First_Name, v.last_name AS Business_Contact_Last_Name, v.business_email AS Business_Contact_Email, v.business_phone AS Business_Contact_Phone_Number, v.message_volume_per_month AS Message_Volume_Per_Month,t.did AS Phone_Numbers, v.use_case_category AS Use_Case_Category, v.summarize_usecase AS Use_Case_Summary, v.sample_message AS Message_Content, v.opt_in_workflow_description AS Opt_In_Workflow_Description,vf.file_path AS Additional_Opt_In_Information,v.additional_supporting_documentation AS Additional_Supporting_Documentation,v.internal_ticket_number AS Internal_Ticket_Number, v.isv_reseller AS `ISV/Reseller` FROM verified_sender v JOIN tollfree_assigned_number t ON v.unique_request_id = t.requestId JOIN verified_sender_file vf ON v.unique_request_id = vf.unique_request_id WHERE v.status = '3' AND v.unique_request_id IN(" + requestID + ")";
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						if (errors == 1) {
							let objv = new RawView(res);
							objv.prepare({ data: result, message: "Verified Sender List Fetched Successfully!", status: 200 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Verified Sender List!", status: 502 });
							objv.execute();
						}

					});
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	sentMailtoIntq(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					try {
						let sdata = JSON.parse(req.body.data);
						const requestID = "'" + sdata.requestId.join("','") + "'";
						let objv = new ModelRawQuery(req, res);
						objv.qrysql = "SELECT `iduser`,`idaccount`,`unique_request_id` from `verified_sender` WHERE `unique_request_id` IN (" + requestID + ") ";
						objv.prepare();
						objv.execute((errors: any, result: any) => {
							if (errors == 1) {
								let data: any = req.files;
								const idusers = result.map((row: { iduser: any; }) => row.iduser);
								const idaccounts = result.map((row: { idaccount: any; }) => row.idaccount);
								let batchID = 'BID' + Math.floor(1000 + Math.random() * 100000000);
								let filename = data[0].filename;
								let value = tollfreeSMS.tollfreecsv + filename;
								// var smtpTransport = nodemailer.createTransport({
								// 	service: SMTP.service,
								// 	host: SMTP.host,
								// 	port: SMTP.port,
								// 	secure: false,
								// 	auth: {
								// 		user: SMTP.user,
								// 		pass: SMTP.pass
								// 	}
								// });
								// var mailOptions = {
								// 	from: SMTP.from,
								// 	to: SMTP.to,
								// 	// username: SMTP.username,
								// 	// email: SMTP.email,
								// 	subject: SMTP.subject,
								// 	text: SMTP.text,
								// 	attachments: [
								// 		{
								// 			filename: filename,
								// 			path: value,
								// 		},
								// 	],
								// }

								// smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
								// 	if (emailRes) {
								// 		let obj0 = new ModelRawNonQuery(req, res);
								// 		obj0.nonqrysql = "UPDATE `verified_sender` SET `status`= '4',`review_date`=NOW() WHERE `idaccount` IN (" + idaccounts + ") AND `iduser` IN (" + idusers + ") AND `unique_request_id` IN (" + requestID + ")";
								// 		obj0.prepare();
								// 		obj0.execute((errors: any, result: any) => { });

								// 		let qry = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES";
								// 		result.forEach((ele: any) => {
								// 			qry += "('" + ele.iduser + "', '" + ele.idaccount + "', '4', 'REVIEW_PROCESS_STARTED', 'Verified Sender Review Process Started ', '" + ele.unique_request_id + "'),";
								// 		});

								// 		let obj1 = new ModelRawNonQuery(req, res);
								// 		obj1.nonqrysql = qry.slice(0, -1);
								// 		obj1.prepare();
								// 		obj1.execute((_error: any, result: any) => {
								// 			console.log("Email Sent Successfully!");
								// 		});

								// 		let obj2 = new ModelRawNonQuery(req, res);
								// 		obj2.nonqrysql = "INSERT INTO `verified_sender_email_batch` (`batch_id`,`verified_sender_id`,`filename`,`filepath`) VALUES ('" + batchID + "','" + sdata.requestId + "','" + filename + "','" + value + "')";
								// 		obj2.prepare();
								// 		obj2.execute((errors: any, result: any) => {
								// 			if (errors == 1) {
								// 				let objv = new RawView(res);
								// 				objv.prepare({ message: "Email Sent Successfully!", status: 200 });
								// 				objv.execute();
								// 			}
								// 			else {
								// 				let objv = new RawView(res);
								// 				objv.prepare({ message: "Something Went Wrong!", status: 502 });
								// 				objv.execute();
								// 			}
								// 		});
								// 	}
								// 	else {
								// 		let objv = new RawView(res);
								// 		objv.prepare({ status: 401, message: "Email is not Sent!", error: _emailError });
								// 		objv.execute();
								// 	}
								// });

								let obj00 = new ModelRawNonQuery(req, res);
								obj00.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`,`subject`,`text`,`type`,`status`,`file`,`html`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + SMTP.from + "','" + SMTP.to + "', '" + parseBody(SMTP.subject) + "','" + parseBody(SMTP.text) + "','Mail sent to Intelliquent','12', '" + value + "','" + parseBody(SMTP.text) + "')";
								obj00.prepare();
								obj00.execute((_err: any, __result: any) => {
									if (_err == 1) {
										let obj0 = new ModelRawNonQuery(req, res);
										obj0.nonqrysql = "UPDATE `verified_sender` SET `status`= '4',`review_date`=NOW() WHERE `idaccount` IN (" + idaccounts + ") AND `iduser` IN (" + idusers + ") AND `unique_request_id` IN (" + requestID + ")";
										obj0.prepare();
										obj0.execute((errors: any, result: any) => { });

										let qry = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES";
										result.forEach((ele: any) => {
											qry += "('" + ele.iduser + "', '" + ele.idaccount + "', '4', 'REVIEW_PROCESS_STARTED', 'Verified Sender Review Process Started ', '" + ele.unique_request_id + "'),";
										});

										let obj1 = new ModelRawNonQuery(req, res);
										obj1.nonqrysql = qry.slice(0, -1);
										obj1.prepare();
										obj1.execute((_error: any, result: any) => {
											console.log("Email Sent Successfully!");
										});

										let obj2 = new ModelRawNonQuery(req, res);
										obj2.nonqrysql = "INSERT INTO `verified_sender_email_batch` (`batch_id`,`verified_sender_id`,`filename`,`filepath`) VALUES ('" + batchID + "','" + sdata.requestId + "','" + filename + "','" + value + "')";
										obj2.prepare();
										obj2.execute((errors: any, result: any) => {
											if (errors == 1) {
												let objv = new RawView(res);
												objv.prepare({ message: "Email Sent Successfully!", status: 200 });
												objv.execute();
											}
											else {
												let objv = new RawView(res);
												objv.prepare({ message: "Something Went Wrong!", status: 502 });
												objv.execute();
											}
										});
									}
									else {
										let objv = new RawView(res);
										objv.prepare({ status: 401, message: "Email is not Sent!" });
										objv.execute();
									}
								});
							} else {
								let objv = new RawView(res);
								objv.prepare({ status: 401, message: "Invalid Details!" });
								objv.execute();
							}
						});
					} catch (e) {
						console.log("Error :: tollfreeSms->sentMailtoIntq::", e);
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong!", status: 502 });
						objv.execute();
					}
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	getbatchId(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `batch_id`,`created_at`,`filepath`,`verified_sender_id` FROM `verified_sender_email_batch`";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({ data: result, message: "Verified Sender List Fetched Successfully!", status: 200 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Verified Sender List!", status: 502 });
							objv.execute();
						}
					});
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getrequestID(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let sdata = req.query;
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT verified_sender_id from `verified_sender_email_batch` WHERE `batch_id`='" + sdata.type + "'";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							const unqID = result[0].verified_sender_id.split(',');
							const requestID = "'" + unqID.join("','") + "'";
							let obj = new ModelRawQuery(req, res);
							obj.qrysql = "SELECT `idaccount`,`unique_request_id`,`created_at`,`status`,`username` FROM `verified_sender` WHERE `unique_request_id` IN (" + requestID + ")";
							obj.prepare();
							obj.execute((_err: any, result: any) => {
								if (_err == 1) {
									let objv = new RawView(res);
									objv.prepare({ data: result, message: "Verified Sender List Fetched Successfully!", status: 200 });
									objv.execute();
								} else {
									let objv = new RawView(res);
									objv.prepare({ message: "Something Went Wrong With Verified Sender List!", status: 502, error: result });
									objv.execute();
								}
							});
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Verified Sender List!", status: 502, error: result });
							objv.execute();
						}
					});
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});

	}

	downloadCSV(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let sdata = req.query;
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT filepath from `verified_sender_email_batch` WHERE `batch_id`='" + sdata.type + "'";
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({ data: result, message: "Verified Sender List Fetched Successfully!", status: 200 });
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Verified Sender List!", status: 502, error: result });
							objv.execute();
						}
					});
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	/* to update the verify sender form*/
	updateverifysender(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 2) {
					let sdata = JSON.parse(req.body.data);
					let files: any = [];
					files = req.files;
					let requestid = sdata.id
					let obj2 = new ModelRawNonQuery(req, res);
					obj2.nonqrysql = "DELETE FROM `verified_sender_file` WHERE `file_upload_key` = '" + sdata.key + "'";
					obj2.prepare();
					obj2.execute((_error: any, result: any) => {
						console.log("Data Deleted Successfully!");
						for (const file of (Array.isArray(req.files) ? req.files : Object.values(req.files)) as any[]) {
							const filePath = tollfreeSMS.tollfreecsv + file.filename;
							let obj11 = new ModelRawNonQuery(req, res);
							obj11.nonqrysql = "INSERT INTO `verified_sender_file` (`iduser`, `idaccount`, `unique_request_id`,`file_upload_key` ,`file_path`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.id + "',  '" + sdata.key + "','" + filePath + "')";
							obj11.prepare();
							obj11.execute((_error: any, result: any) => {
								console.log("File saved in DB")
							});
						}
						let objj11 = new ModelRawNonQuery(req, res);
						objj11.nonqrysql = "UPDATE verified_sender  SET `status`= '1',`messaging_provide`='" + sdata.data.messagingprovider + "',`dba_name`='" + parseBody(sdata.data.dbaname) + "',`business_name`='" + parseBody(sdata.data.businessname) + "',`address1`='" + parseBody(sdata.data.address) + "',`address2`='" + parseBody(sdata.data.address1) + "',`city`='" + parseBody(sdata.data.city) + "',`state`='" + parseBody(sdata.data.state) + "',`zip`='" + parseBody(sdata.data.zip) + "',`first_name`='" + parseBody(sdata.data.firstname) + "',`last_name`='" + parseBody(sdata.data.lastname) + "',`business_email`='" + parseBody(sdata.data.email) + "',`business_phone`='" + sdata.data.phonenumber + "',`corporate_website_url`='" + parseBody(sdata.data.websiteurl) + "',`summarize_usecase`='" + parseBody(sdata.data.usecase) + "',`sample_message`='" + parseBody(sdata.data.contentcampaign.trim()) + "',`number_published`='" + parseBody(sdata.data.published) + "',`fortune_company`='" + parseBody(sdata.data.company) + "',`call_to_action_url`='" + parseBody(sdata.data.url) + "',`call_to_action_numbers`='" + sdata.data.numbers + "',`message_volume_per_month`='" + sdata.data.messagevolume + "',`use_case_category`='" + parseBody(sdata.data.usecasecategory) + "',`opt_in_workflow_description`='" + parseBody(sdata.data.workdescription) + "',`additional_supporting_documentation`='" + parseBody(sdata.data.supportdocs) + "',`text_message_type`='" + sdata.data.text_msg_type + "',`traffic_previously_msg_service`='" + sdata.data.traffic_previous_msg_service + "',`traffic_expected`='" + sdata.data.traffic_expected + "' WHERE `unique_request_id` = '" + sdata.id + "'";
						objj11.prepare();
						objj11.execute((_error: any, result: any) => {
							if (_error == 1) {
								let obj1 = new ModelRawNonQuery(req, res);
								obj1.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '7', 'REQUEST_UPDATED', 'Request Updated Successfully', '" + sdata.id + "')";
								obj1.prepare();
								obj1.execute((_error: any, result: any) => {
									console.log("Data Inserted Successfully!");
								});
								if (!sdata.previosFile) {
									console.log('no data found')
								} else {
									for (let i = 0; i < sdata.previosFile.length; i++) {
										const file = sdata.previosFile[i];
										let obj3 = new ModelRawNonQuery(req, res);
										obj3.nonqrysql = "INSERT INTO `verified_sender_file` (`iduser`, `idaccount`, `unique_request_id`,`file_upload_key` ,`file_path`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.id + "',  '" + sdata.key + "','" + file.file + "')";
										obj3.prepare();
										obj3.execute((_error: any, result: any) => {
											console.log("Data Inserted Successfully!");
										})
									}
								}
								if (!sdata.url || sdata.url.length === 0) {
									console.log("URLS not Found")
								}
								else {
									let obj3 = new ModelRawNonQuery(req, res);
									obj3.nonqrysql = "DELETE FROM `verified_sender_urls` WHERE `requestID` = '" + sdata.id + "'";
									obj3.prepare();
									obj3.execute((_err: any, result: any) => {
										if (_err == 1) {
											let obj1 = new ModelRawNonQuery(req, res);
											let qry0 = "INSERT INTO `verified_sender_urls`(`iduser`, `idaccount`,`requestID`,`url`) VALUES ";
											for (let i = 0; i < sdata.url.length; i++) {
												let url = sdata.url[i];
												qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + requestid + "','" + url + "'),"
											}
											obj1.nonqrysql = qry0.slice(0, -1)
											obj1.prepare();
											obj1.execute((_error: any, result: any) => {
												console.log("URL Inserted Successfully!");
											});
										} else {
											let objv = new RawView(res);
											objv.prepare({ message: "Something Went Wrong With Verified sender!", status: 502 });
											objv.execute();
										}
									})
								}
								let objv = new RawView(res);
								objv.prepare({ data: result, message: "Verified Sender Updated Successfully!", status: 200 });
								objv.execute();
							}
							else {
								let objv = new RawView(res);
								objv.prepare({
									message: "Something Went Wrong With Verified sender !",
									status: 502,
									error: result
								});
								objv.execute();
							}
						});
					});
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	ResentMailtoIntq(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					try {
						let sdata = req.body.data;
						let objv = new ModelRawQuery(req, res);
						objv.qrysql = "SELECT `filename`,`filepath` from `verified_sender_email_batch` WHERE `batch_id` = '" + sdata + "'";
						objv.prepare();
						objv.execute((errors: any, result: any) => {
							if (errors == 1) {
								// var smtpTransport = nodemailer.createTransport({
								// 	service: SMTP.service,
								// 	host: SMTP.host,
								// 	port: SMTP.port,
								// 	secure: false,
								// 	auth: {
								// 		user: SMTP.user,
								// 		pass: SMTP.pass
								// 	}
								// });
								// var mailOptions = {
								// 	from: SMTP.from,
								// 	to: SMTP.to,
								// 	// username: SMTP.username,
								// 	// email: SMTP.email,
								// 	subject: SMTP.subject,
								// 	text: SMTP.text,
								// 	attachments: [
								// 		{
								// 			filename: result[0].filename,
								// 			path: result[0].filepath,
								// 		},
								// 	],
								// }
								// smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
								// 	if (emailRes) {
								// 		if (errors == 1) {
								// 			let objv = new RawView(res);
								// 			objv.prepare({ message: "Email Resend Successfully!", status: 200 });
								// 			objv.execute();
								// 		} else {
								// 			let objv = new RawView(res);
								// 			objv.prepare({ message: "Something Went Wrong!", status: 502 });
								// 			objv.execute();
								// 		}
								// 	} else {
								// 		let objv = new RawView(res);
								// 		objv.prepare({ status: 401, message: "Email is not Sent!", error: _emailError });
								// 		objv.execute();
								// 	}
								// });

								let obj1 = new ModelRawNonQuery(req, res);
								obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`,`subject`,`text`,`type`,`status`,`file`,`html`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + SMTP.from + "','" + SMTP.to + "', '" + parseBody(SMTP.subject) + "','" + parseBody(SMTP.text) + "','Mail Re-send to Intelliquent','13', '" + result[0].filepath + "','" + parseBody(SMTP.text) + "')";
								obj1.prepare();
								obj1.execute((err: any, result: any) => {
									if (err == 1) {
										let objv = new RawView(res);
										objv.prepare({ message: "Email Resend Successfully!", status: 200 });
										objv.execute();
									} else {
										let objv = new RawView(res);
										objv.prepare({ message: "Something Went Wrong!", status: 502 });
										objv.execute();
									}
								})
							} else {
								let objv = new RawView(res);
								objv.prepare({ status: 401, message: "Invalid Details!" });
								objv.execute();
							}
						});
					} catch (error) { // Catch the specific error
						console.log("Error :: tollfreeSms->ResentMailtoIntq::", error);
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong!", status: 502 });
						objv.execute();
					}
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			} else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}


	TollFreeFilter(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {

			if (error == 1) {
				let data = req.body.data;
				let condition: any = "";

				let obj = new ModelRawQuery(req, res);
				let conditionU = '';
				if (sessdata.type == 1) {
					conditionU += data.idaccount !== undefined ? " AND `idaccount`='" + data.idaccount + "'" : '';
				}

				if (sessdata.type == 2)
					conditionU += "`idaccount`=" + sessdata.idaccount + "";

				// if (sessdata.type == 22)
				// 	conditionU += " AND `iduser`='" + sessdata.iduser + "'";

				if (data.Request_Id) {
					condition += '`unique_request_id` LIKE "%' + parseBody(data.Request_Id) + '%" AND ';
				}
				if (data.username) {
					condition += '`username` LIKE "%' + parseBody(data.username) + '%" AND ';
				}

				if (data.statusResponse) {
					condition += '`status` LIKE "%' + parseBody(data.statusResponse) + '%" AND ';
				}

				if (data.from_date && data.to_date) {
					condition += '`created_at` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59" AND ';
				}

				if (data.filter_type == "Pending Review")
					condition += '`status`="1" AND ';

				if (data.filter_type == "Rejected")
					condition += '`status`="2" AND ';

				if (data.filter_type == "Awaiting Downstream Processing")
					condition += '`status`="3" AND ';

				if (data.filter_type == "Verified Sender Review Process Started")
					condition += '`status`="4" AND ';

				if (data.filter_type == "Verified Sender Submission Rejected")
					condition += '`status`="5" AND ';

				if (data.filter_type == "Verified Sender Submission Approved")
					condition += '`status`="6" AND ';

				if (data.status == "1")
					condition += '`status`="1" AND ';

				if (data.status == "1")
					condition += '`status`="2" AND ';

				if (data.status == "3")
					condition += '`status`="3" AND ';

				if (data.status == "4")
					condition += '`status`="4" AND ';

				if (data.status == "5")
					condition += '`status`="5" AND ';

				if (data.status == "6")
					condition += '`status`="6" AND ';

				if (data.status == "7")
					condition += '`status`="7" AND ';

				if (!data.status || data.filter_type == " ")
					condition += '';

				obj.qrysql = "SELECT `idaccount`, `iduser`, `first_name`, `last_name`,`business_name` ,`unique_request_id`, `created_at`, `status`,`username`,`reject_date`,`awaiting_downstream_date`,`review_date`,`submission_reject_date`,`submission_approve_date` FROM `verified_sender` WHERE " + condition + " " + conditionU;
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "TollFree  List Fetched Successfully!",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Fetched Toll Free List!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	EMailTollFreeFilter(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let data = req.body.data;
					let obj = new ModelRawQuery(req, res);
					let condition = '';
					if (data.batchid && !(data.from_date && data.to_date)) {
						condition += 'WHERE `batch_id` LIKE "%' + parseBody(data.batchid) + '%"';
					}
					if (data.from_date && data.to_date && !(parseBody(data.batchid))) {
						condition += 'WHERE `created_at` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59"';
					}
					if (data.batchid && data.from_date && data.to_date) {
						condition += 'WHERE `batch_id`="' + parseBody(data.batchid) + '" AND `created_at` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59"';
					}
					obj.qrysql = "SELECT `batch_id`, `created_at` FROM `verified_sender_email_batch` " + condition;
					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({ data: result, message: "TollFree List Fetched Successfully!", status: 200 });
							objv.execute();
						} else {
							let objh = new RawView(res);
							objh.prepare({ message: "Something Went Wrong With Fetched Toll Free List!", status: 502, error: result });
							objh.execute();
						}
					});
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	did_change(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let sdata = req.body.data;
					const number = sdata.number.length;
					let obj1 = new ModelRawNonQuery(req, res);
					obj1.nonqrysql = `UPDATE did_buy SET sinch_status = '1',camp_registry = '${sdata.request_id}',updated_at=NOW() WHERE did IN ('${sdata.number.join("','")}')  AND iduser = ${sdata.iduser}`;
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						if (errors == 1) {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 201, message: "SMS facility enabled on this DID" });
							objv0.execute();
						}
						else {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 502, message: "Something Went Wrong!" });
							objv0.execute();
						}
					})
					let obj0 = new ModelRawNonQuery(req, res);
					let qry0 = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`) VALUES";
					for (let i = 0; i < number; i++) {
						let entry1 = sdata.number[i];
						qry0 += "('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'34','Tollfree Number Submission Approved','" + entry1.trim() + "','1'),"
					}
					obj0.nonqrysql = qry0.slice(0, -1)
					obj0.prepare();
					obj0.execute((_error: any, result: any) => {
						console.log("Data Inserted Successfully!");
					});
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session you are trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	did_reject(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 1) {
					let sdata = req.body.data;
					const number = sdata.number.length;
					let obj1 = new ModelRawNonQuery(req, res);
					obj1.nonqrysql = `UPDATE did_buy SET sinch_status = '16',updated_at=NOW() WHERE did IN ('${sdata.number.join("','")}')  AND iduser = ${sdata.iduser}`;
					obj1.prepare();
					obj1.execute((errors: any, result: any) => {
						if (errors == 1) {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 201, message: "DID Rejected Successfully." });
							objv0.execute();
						}
						else {
							let objv0 = new RawView(res);
							objv0.prepare({ status: 502, message: "Something Went Wrong!" });
							objv0.execute();
						}
					})

					let obj0 = new ModelRawNonQuery(req, res);
					let qry0 = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`) VALUES";
					for (let i = 0; i < number; i++) {
						let entry1 = sdata.number[i];
						qry0 += "('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'35','Tollfree Number Submission Rejected','" + entry1.trim() + "','16'),"
					}
					obj0.nonqrysql = qry0.slice(0, -1)
					obj0.prepare();
					obj0.execute((_error: any, result: any) => {
						console.log("Data Inserted Successfully!");
					});
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	get_status(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				if (sessData.type == 1) {
					let sdata = req.query;
					if (sdata.type !== undefined) {
						const typeArray = Array.isArray(sdata.type) ? sdata.type : [sdata.type];
						const did = typeArray.join(",");
						let obj = new ModelRawQuery(req, res);
						obj.qrysql = "SELECT did, sinch_status FROM did_buy WHERE did IN (" + did + ") AND type = 'TF'";
						obj.prepare();
						obj.execute((error: any, result: any) => {
							if (error == 1) {
								let objv = new RawView(res);
								objv.prepare({ message: "DID Status Fetched Successfully", data: result, status: 200 });
								objv.execute();
							} else {
								let objv = new RawView(res);
								objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
								objv.execute();
							}
						});
					} else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Invalid Details in the request",
							status: 400,
						});
						objv.execute();
					}
				} else {
					let objvs = new RawView(res);
					objvs.prepare({ message: "Service Unavailable!", status: 503 });
					objvs.execute();
				}
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	// to get request id on idaccount
	get_requesID(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `unique_request_id`,`business_email`,`status` FROM verified_sender WHERE  `idaccount`='" + sessData.idaccount + "' ORDER BY `created_at` DESC";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: ' Request_ID  Fetched Successfully!', data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 503 });
						objv.execute();
					}
				})
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	getAssignNumber(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let condition: any = '';


				if (sessdata.type == 1)
					condition += ''
				if (sessdata.type == 2)
					condition += "WHERE idaccount='" + sessdata.idaccount + "'"
				// if (sessdata.type == 22)
				// 	condition += "WHERE `iduser`='" + sessdata.iduser + "'"
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `idaccount`, `iduser`, `did`,`requestId` FROM `tollfree_assigned_number`" + condition + "";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Assign Toll free List Get Successfully!",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Assign Toll free List!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}
	TollFreeAssignFilter(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				if (sessdata.type == 2) {
					let data = req.body.data;
					let condition: any = "";
					let obj = new ModelRawQuery(req, res);

					if (data.Request_Id) {
						condition += '`tan`.`requestId` LIKE "%' + parseBody(data.Request_Id) + '%" AND ';
					}

					if (data.statusResponse === '0') {
						condition += '`db`.`sinch_status` IN (0, 16) AND ';
					}
					else if (data.statusResponse) {
						condition += '`db`.`sinch_status` = "' + data.statusResponse + '" AND ';
					}

					if (data.from_date && data.to_date) {
						condition += '`db`.`created_at` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59" AND ';
					}

					obj.qrysql = "SELECT DISTINCT `db`.`did`, `db`.`account_id`, `db`.`sinch_status`, `db`.`created_at`, `tan`.`requestId` FROM `did_buy` AS `db` LEFT JOIN `tollfree_assigned_number` AS `tan` ON REPLACE(`db`.`did`, '\r', '') = `tan`.`did` WHERE " + condition + " `db`.`type` = 'TF' AND `db`.`account_id`='" + sessdata.idaccount + "' GROUP BY `db`.`did`";

					obj.prepare();
					obj.execute((_error: any, result: any) => {
						if (_error == 1) {
							let objv = new RawView(res);
							objv.prepare({
								data: result,
								message: "Assign TollFree List Fetched Successfully!",
								status: 200
							});
							objv.execute();
						}
						else {
							let objv = new RawView(res);
							objv.prepare({
								message: "Something Went Wrong With Assign Toll Free List!",
								status: 502,
								error: result
							});
							objv.execute();
						}
					});
				} else {
					let objv = new RawView(res);
					objv.prepare({ message: "Service Unavailable!", status: 503 });
					objv.execute();
				}
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}
}
