'use strict';
import { AppRoute } from "../lib/AppRoute";
import { Campaign } from "../include/campaign.class";
import { NewCampaign } from "../include/newcampaign.class";
import { TierManagement } from '../include/tiermanagement.class';
import { UserManagement } from "../include/usermanagement.class";
import { Sms } from "../include/smsApi"
import { Number } from "../include/numberApi";
import { Connection } from "../include/connections";
import { StripeApi } from '../include/stripeApi';
import { Reports } from "../include/reports.class";
import { Call } from "../include/callApi";
import { SwaggerLogin } from "../lib/SwaggerLogin";
import { AgentClass } from "../include/agents";
import { CommonClass } from "../include/common.class";
import { TwoFactorAuth } from "../include/TwoFactorAuth";
import { SignUPLogin } from "../lib/SignUPLogin";
import { CnamApi } from '../include/cnam'
import { TemplateSetting } from "../include/template-setting";
import { Postback } from "../include/postbackUrl";
import { OsrApi } from "../include/Osr";
import { HookUrls } from "../include/hookUrls";
import { Webhook } from "../include/webhook.class";
import { Reseller } from "../include/Reseller";
import { Kyc } from "../include/kyc.class";
import { Volt } from "../include/volt"
import { Importnumber } from "../include/Importnumber";
import { TollFree } from "../include/tollfreeSms"
import { AccountDelete } from "../include/AccountDelete";
import { NotificationSystem } from "../include/notificationSystem";
import { SwaggerApi } from "../include/swaggerApi";


var multer = require('multer');

const extMMS = require("../include/multerlib");
const uploadMMS = require("../include/uploadMulter");
const appeal = require("../include/appealmulter");
const tollfreemulter = require("../include/tollfreemulter");

const uploadCARD = require("../include/uploadCardMulter");
const uploadFEDERAL = require("../include/uploadFederalMulter");
const uploadKYC = require("../include/uploadKycMulter");
const campaignMulter = require("../include/campaignMulter");
const invoicePdf = require("../include/InvoiceMulter");


const extractImage = require("../include/multerImage");
var upload = multer({ dest: process.cwd() + "/uploads/" });
export const type = upload.single('filename');


module.exports = function (app: any) {

  var tier = new TierManagement();
  app.get("/getTariffs", tier.getTraiffs);
  app.get("/type_tariffs", tier.getTypesTraiffs);
  app.get("/getTariff", tier.getTraiff);
  app.post("/saveTariff", tier.saveTariff);
  app.post("/copyTariff", tier.copyTariff);
  app.put("/updateTariff", tier.updateTariff);
  app.delete("/deleteTariff", tier.deleteTariff);
  app.put("/updatetariffday", tier.updateTariffDay);
  app.put("/updateproratesetting", tier.updateProRate);

  app.post("/tier/save_rate", tier.SaveRate);
  app.put("/tier/update_rate", tier.updateData);
  app.post("/uploads/rate_csv", type, tier.UploadCSV);
  app.get("/tier/get_feature", tier.getTierFeature);
  app.get("/tier/get_ratename", tier.getBillingRatename);
  app.get("/tier/billing_rate", tier.getBillingRate);

  // Unregistered Routes
  app.post("/addvoicerates", tier.addvoiceRates);
  // app.post("/ivoiceapirates", tier.addiVoiceApiRates);
  // app.post("/numberrate", tier.addNumberRates);
  // app.post("/depthvoicerate", tier.addDepthVoiceRates);
  // app.post("/siprate", tier.onSipRates);
  // app.post("/sipdepthvoicerate", tier.onDepthVoiceRates);
  // app.post("/sipnumberprice", tier.sipNumberPrice);
  // app.post("/numberactivationrates", tier.numberActivationRates)

  // Customer Rates
  // app.get("/customerrates", tier.subCustomerRates);

  app.get("/unregisteredrates", tier.voiceApiRates);
  app.get("/lookupRates", tier.lookupRates);
  app.put("/updateunregisteredrates", tier.unregisteredRates);
  app.put("/updatelookupRate", tier.updatelookupRate);
  app.put("/updateCampaignReviewRate", tier.updateCampaignReviewRate);
  app.get("/CampaignReviewRates", tier.CampaignReviewRates);
  app.put("/updateactivatemessage", tier.updateActivatemessage);
  app.get("/getactivate_msg", tier.get_activatemsg);

  // Add Registered Rates
  app.post("/sms_rates", tier.onSmsRates);
  app.post("/add10dlca2p", tier.Add10DLCA2P);
  app.post("/tollfreerates", tier.TollFreeA2p);
  app.post("/addshortcode", tier.ShortCodeRate);
  app.post("/addvoicerate", tier.VoiceRates);


  // Get Registered Rates
  app.get("/usa_sms_rates", tier.GetUSA_SMS_Rates);
  app.get("/get10dlca2p", tier.Get10DLCA2P);
  app.get("/gettollfreerate", tier.GetTollFreeA2p);
  app.get("/getshortcode", tier.GetShortCodeRate);
  app.get("/getvoicerate", tier.GetVoiceRates);
  app.get("/getcampaign_rate", tier.GetCampaignSur_Rates);
  app.get("/getCoverage_rate", tier.GetCoverage_Rates);


  // Update Registered Rates
  app.put("/update10DLCRate", tier.update10DLCRate);
  app.put("/updateTollFreeRate", tier.updateTollFreeRate);
  app.put("/updateSMSRate", tier.updateSMSRate);
  app.put("/updateShortCodeRate", tier.updateShortCodeRate);
  app.put("/updateVoiceRate", tier.updateVoiceRate);

  // Surcharge
  app.post("/savesurcharge", tier.saveSurcharge);
  app.put("/edit_Surcharge", tier.updateSurcharge);
  app.get("/surcharge", tier.getSurcharges);
  app.put("/editSurcharge", tier.editSurcharge);
  app.delete("/deletesurcharge", tier.deleteSurcharge);

  // Preference
  app.post("/preferenceservice", tier.saveServiceProfile);
  app.post("/preference", tier.savePreference);
  app.get("/preference", tier.getPreference);
  app.get("/service", tier.getServiceProfiles);
  app.get("/singleservice", tier.getServiceProfile);
  app.put("/updatepreference", tier.updatePreference);
  app.put("/updateservicepreference", tier.updatePreferenceService);
  app.delete("/deleteservice", tier.deletePreferenceService);
  app.put("/default_service", tier.setDefaultService);

  app.get("/getsurcharge", tier.getSurcharge);

  app.get("/tarifflist", tier.getTariffList);
  app.get("/getteriff", tier.getSingleTraiff);

  var user = new UserManagement();

  /**
   * To authenticate user with TimeZone
   */
  app.post("/login", user.getLogin);
  app.post("/update_sys_tz", user.SaveSysTZ);

  app.post("/admin", user.AdminSave);
  app.post("/user", extractImage, user.SaveUser);
  app.put("/custom/changepassword/", user.ChangePassword);
  app.put("/custom/changepass/", user.ChangePassword);
  app.put("/resetPass", user.resetPassword);
  app.get("/user", user.UserList);
  app.get("/users", user.ListUsers);
  app.get("/subcustomers", user.subCustomerList);
  app.get("/getAllUsers", user.getAllUsers);
  app.get("/suppliers", user.getSupplier);
  app.get("/supplier", user.getSuppliers);
  /*added new path for dropdown customers list */
  app.get("/customerList", user.customerList);
  app.get("/singleuser", user.singleUser);
  app.get("/getSingleUsersForAdmin", user.getSingleUsersForAdmin);
  app.post("/uploads/document_upload", type, user.UploadDocuments);
  app.delete("/deleteUser", user.deleteUser);
  // delete customer own account
  app.put("/deleteAccount", user.DeleteCustomerAccount);
  app.get("/checkBalance", user.checkBalance);
  app.put("/final_delete_account", user.DeleteAccount);

  app.post("/tax_calculation", user.TaxCalculation);
  // app.post("/details_cdr", user.detailsCDR);
  app.post("/add_billing_address", user.addBillingAddress);
  app.post("/signup_confirmation", user.sendOnboardingComplateMail);
  app.post("/get_geo_code", user.getGeoCode);
  app.get("/get_billing_address", user.getBillingAddress);
  app.get("/getInvoice", user.getInvoice);
  app.put("/update_billing_address", user.updateBillingAddress);
  // deleteUserSingleData
  app.delete("/deleteUserSingleData", user.deleteUserSingleData);
  app.post("/saveTheme", user.saveTheme);
  app.put("/updatetheme", extractImage, user.updateTheme);
  app.get("/theme", user.getTheme);
  app.get("/themes", user.getThemes);
  app.post("/signup", user.signUp);
  app.put("/onBoardingVerification", user.onBoardingVerification);

  //forgot password start
  app.put("/update-password", user.updatePassword);
  app.get("/forgot-mail", user.sendMailForForgetPass);
  app.get("/verify-token", user.VerifyToken);
  app.get("/verify-url", user.VerifyUrl);
  //forgot password end

  app.post("/company", user.updateCompanyProfile);
  app.get("/company", user.getCompanyProfile);

  app.put("/update-tariff", user.updateTariff);
  app.put("/profile-pic", extractImage, user.updateProfilePic);
  app.put("/removeProfile-pic", extractImage, user.removeProfilePic);

  // app.post("/googleLogin", user.googleLogin);

  app.post("/apiToken", user.apiToken);
  app.get("/apiToken", user.getApiToken);
  app.delete("/apiToken", user.deleteApiToken);

  // Resend Email
  app.post("/resendemail", user.resendEmail);

  // otp
  app.post("/saveotp", user.saveOtp);
  app.post("/signup_verifyOtp", user.verifyOtp);

  /**
   * Other Routes
   */
  app.get("/get_timezones", user.GetTimeZones);
  app.get("/get_user_timezone", user.GetUserTimeZone);
  app.post("/user_timezone", user.UpdateUserTimeZone);
  app.get("/user_filter", user.userFilter);

  // Morphing Session 
  app.get("/morphing-session", user.getMorphingSession);

  //Billing Enable or Disable
  app.put("/billingEnable", user.billingEnableOrDisable);
  app.put("/kycVerification", user.kycUpdateStatus);

  /** ROUTE FOR DOMAIN BLOCK*/
  app.post("/domainBlock", user.domainBlock);
  app.get("/getDomainBlk", user.getDomainBlk);
  app.put("/updateDomainBlock", user.updateDomainBlock);
  app.delete("/deleteDomainBlock", user.deleteDomainBlock);


  //app.get("/compairePassword", user.compairePassword);

  app.get("/getResellerUsers", user.getResellerUsers);
  app.get("/getResellerTariff", user.getResellerTariff);
  app.get("/getUserStatus", user.getUserStatus);
  app.get("/kycHeader", user.kycVerifyHeader);
  app.get("/getfeatureService", user.getfeatureService);
  app.get("/getSuspendedService", user.getSuspendedService);
  app.get("/getfeatureServiceStatus", user.getfeatureServiceStatus);
  app.put("/updateSuspendedService", user.updateSuspendedService);
  app.get("/getfeatureServiceById", user.getfeatureServiceById);

  // to update payment status
  app.put("/paymentstatus", user.Payment_status);
  // to get the payment status
  app.get("/trust_Score", user.trust_score);


  const accountDelete = new AccountDelete();
  app.get("/getInvoiceDetails", accountDelete.closingInvoice);
  app.post("/sendInvoicePdf", invoicePdf, accountDelete.sendInvoicePdf);
  app.delete("/closeCustomerAccount", accountDelete.closeCustomerAccount);
  app.delete("/deleteCusAccount", accountDelete.deleteCusAccount);
  app.put("/adminCloseCustomerAccount", accountDelete.adminCloseCustomerAccount);
  app.get("/getInvoicePdfForAdmin", accountDelete.getInvoicePdfForAdmin);


  /**
   * Routes for Panel + Swagger
   */
  const campaign = new Campaign();
  //--------------------- brand start--------------------------------------------------------------
  //app.post("/addbrand", campaign.addBrand);
  //app.post('/sendOTPforBrand', campaign.sendOTPforBrand);

  //app.get("/brand", campaign.getBrand);  // Completed in new with getBrandsDetail  swgr(brand)
  //app.get('/getbrands', campaign.getBrands); //: Completed in new with getbrands
  // app.get("/brandCampaign", campaign.getCampaigns); // Completed in new with brandCampaign
  // app.get('/getBrandsDetail', campaign.getBrandsDetail); //: Completed in new with getBrandsDetail
  //app.post("/registerbrand", campaign.brandRegister); // Completed in new with registerbrand
  // app.put('/updatebrand', campaign.updateBrand); // Completed in new with updateBrand

  //app.get("/brandRelationship", campaign.brandRelationship); // Completed in new with brandRelationship
  //app.get("/brandVertical", campaign.brandVertical);  // Completed in new with brandVertical
  //app.get("/brandEntity", campaign.brandEntityType); // Completed in new with brandEntity
  // app.put('/updateBrandIdentity', campaign.brandIdentityStatusUp); // Completed in new with brandEntity

  // app.get("/brandVettingClass", campaign.brandVettingClass); // Completed in new with brandVettingClass
  // app.get("/brandVettingProvider", campaign.brandVettingProvider); // Completed in new with brandVettingProvider
  // app.get("/brandDCA", campaign.brandDCA); // Completed in new with brandDCA
  // app.get("/altBusinessIdType", campaign.altBusinessIdType); // Completed in new with altBusinessIdType

  // app.post("/applyVetting", campaign.applyVetting); // Completed in new with applyVetting
  // app.put("/importVetting", campaign.importVetting);  // Completed in new with importVetting
  // app.get("/externalVettingList", campaign.externalVettingList); // Completed in new with externalVettingList
  // app.get("/getBrandVettingList", campaign.getBrandVettingList); // Completed in new with (not in use)
  // app.get("/getVettingClass", campaign.getVettingClass); // Completed in new with getVettingClass
  // app.get("/getVettingPartner", campaign.getVettingPartner); // Completed in new with getVettingPartner
  // app.put("/updateVettingForStatus", campaign.externalVettingBulkUpdate); // Completed in new with updateVettingForStatus

  //app.post("/brand_register", campaign.BrandRegister);
  // app.delete('/delete_brand', campaign.DeleteBrand); // Completed in new with deleteBrand

  // -------------------------- brand end--------------------------------------------------

  //----------------------------start campaign---------------------------------------------
  //app.post("/addcampaign", campaign.addCampaign);
  //app.post("/campaign_register", campaign.CampaignRegister);

  //app.get("/campaignCases", campaign.getCampaignCases); // Completed in new with campaignCases

  // app.put('/updateCSPID', campaign.updateCSPID); // Completed in new with updateCSPID
  // app.get('/getCSP', campaign.getCspId);  // Completed in new with getCSP
  // app.get("/cnpCampaign", campaign.getCNPCampaign); // Completed in new with cnpCampaign
  // app.get("/campaigns", campaign.getCampaign); //  Completed in new with campaigns
  // app.post("/registercampaign", campaign.registerCampaign) // Completed in new with registercampaign   
  // app.delete("/deletecampaign", campaign.deleteCampaign); // Completed in new with deletecampaign
  // app.get("/campcases", campaign.CampaignCases); 
  // app.get("/getCampaignDIDCount", campaign.getCampaignDIDCount); // Completed in new with getCampaignDIDCount
  // app.get("/getCampaignDID", campaign.getCampaignDID); // Completed in new with getCampaignDID
  // app.get("/campaignData", campaign.getCampaignForAdmin); // Completed in new with campaignData

  /** Other APIs */
  //------------------------End campaign----------------------------------------------------------

  /**
  * Routes for Panel + Swagger --for Duplicate New Campaign Routes.. 
  */

  const newCampaign = new NewCampaign();
  // Start campaign routing
  app.get("/campaignCases", newCampaign.getCampaignCases); // swagger
  app.get("/campaignCasesPanel", newCampaign.campaignCases); // panel
  app.get("/getMnoList", newCampaign.getMNOList);
  app.get("/brandCampaign", newCampaign.getCampaignByBrandId);
  app.get("/campaigns", newCampaign.getSwaggerCampaign); // swagger
  app.get("/campaignsList", newCampaign.getCampaign); // panel
  app.get("/getCampaignForReview", newCampaign.getCampaignForReview); // panel

  app.post("/addcampaign", newCampaign.addCampaign);
  app.post("/registercampaign", campaignMulter, newCampaign.registerCampaign);
  app.post("/campaign_register", campaignMulter, newCampaign.registerCampaign);

  //app.post("/campaign_register", campaign.CampaignRegister);
  app.post("/campaignMultimediaFileUpload", campaignMulter, newCampaign.campaignMultimediaFileUpload);
  app.post("/campaignPanelFileUploader", campaignMulter, newCampaign.campaignPanelFileUploader);

  app.get("/getCampaignsFileById", newCampaign.getCampaignsFileById); // panel
  app.get("/campaignMultimediaFileGet", newCampaign.getCampFile);
  app.delete("/campaignMultimediaFileDelete", newCampaign.deleteCampFile);
  app.delete("/deleteAddCampFile", newCampaign.deleteAddCampFile); // panel

  app.put("/updateCampaign", newCampaign.updateCamapign);
  app.put("/finalUpdateForCampaign", newCampaign.finalUpdateForCampaign);

  app.put("/autoRenewal", newCampaign.updateAutoRenualCampaign);
  app.get("/campaignDetails", newCampaign.getCampDetails);
  app.get("/mnoMetaData", newCampaign.mnoMetaData); // this will be fetch from campaign and campaign update page
  app.delete("/deletecampaign", newCampaign.deleteCampaign);
  app.get("/mnoDetails", newCampaign.mnoIddetails); // not in use
  app.put("/resubmitCampaign", newCampaign.resubmitCampaign);

  app.get("/connPartnersDetails", newCampaign.getConnPartnersDetails); // not in use but connected with anguler 
  app.get("/getResellerDetails", newCampaign.getResellerDetails); // not in use but connected with anguler
  app.get("/qualifyBrandByUsecas", newCampaign.getMnoMetaDataForRegister); // this will be fetch from campaign table
  app.get("/mnoMetaDataDetails", newCampaign.getMnoMetaDataDetails); // this will be fetch from campaign and campaign update page
  // app.get("/getCampaignDetails", newCampaign.campaignDetails); // wrong code
  app.post("/campaignFilter", newCampaign.campaignFilter);
  app.get("/getCampaignDID", newCampaign.getCampaignDID);
  app.get("/getCampaignDIDCount", newCampaign.getCampaignDIDCount);
  app.get("/campaignData", newCampaign.getCampaignForAdmin);
  app.put('/updateCSPID', newCampaign.updateCSPID);
  app.get('/getCSP', newCampaign.getCspId);
  app.get("/cnpCampaign", newCampaign.getCNPCampaign);
  app.post("/CNPcampaignFilter", newCampaign.CNPcampaignFilter);
  app.post("/rejectFormByAdmin", newCampaign.rejectFormByAdmin);
  app.post("/failedFormByAdmin", newCampaign.failedFormByAdmin);
  app.post("/failedCnpFormByAdmin", newCampaign.failedCnpFormByAdmin);
  app.post("/RequestEdit", newCampaign.RequestEdit);
  app.get("/getCampaignsDetailId", newCampaign.getCampDetailById); // panel
  app.get("/getPlan", newCampaign.getSubscriptionPlan);
  app.get("/brandQualifyByAllUseCases", newCampaign.brandQualifyAllUseCases); // this will be fetch from campaign table
  app.get("/checkNonProfitBrand", newCampaign.checkNonProfitBrand); 
  app.post("/createCampaignFile", newCampaign.createCampaignFile);
  app.get("/campMnoMetaDataDetails", newCampaign.getCampMnoMetaDataDetails);
  app.get("/getCampaignEvents", newCampaign.getCampaignEvents);
  app.put("/dcaSubmit", newCampaign.dcaSubmit);
  // End campaign routing

  // start brand and vetting routes
  app.get("/brandRelationship", newCampaign.brandRelationship);
  app.get("/brandVertical", newCampaign.brandVertical);
  app.get("/brandEntity", newCampaign.brandEntityType);
  app.get("/brandIdentityStatus", newCampaign.brandIdentityStatus); // swagger
  app.get("/altBusinessIdType", newCampaign.altBusinessIdType);
  app.get("/stockExchange", newCampaign.stockExchange);
  app.get("/brandDCA", newCampaign.brandDCA);
  app.get('/brandOtpStatus', newCampaign.getOTPStatusForBrand);
  // app.put('/verifyBrandOTP', newCampaign.verifyBrandOTP);
  app.post('/brandSmsOtp', newCampaign.sendOTPforBrand);

  app.post("/addbrand", newCampaign.addBrand);
  app.post("/registerbrand", newCampaign.brandRegisterNonBlocking);
  app.post("/brand_register", newCampaign.brandRegisterNonBlocking);

  app.get("/getBrandFeedback", newCampaign.getBrandFeedback);
  app.get('/brand', newCampaign.getBrandsDetail);
  app.get('/getbrands', newCampaign.getAllBrands);
  app.get('/getBrandCnpList', newCampaign.getBrandCnpList);

  app.put("/updateBrand", newCampaign.updateBrand);
  app.put('/updateBrandIdentity', newCampaign.brandRvtForIdenSttsUp); // panel
  app.put("/revet", newCampaign.revetBrand); // swagger
  app.post("/brandFilter", newCampaign.brandFilter);
  app.post("/cnpBrandFilter", newCampaign.cnpBrandFilter);

  app.post("/campaignFilterForBrand", newCampaign.campaignFilterForBrand);
  app.delete("/deleteBrand", newCampaign.deleteBrand);

  app.get("/vettingClass", newCampaign.brandVettingClass);
  app.get("/extVettingProvider", newCampaign.brandVettingProvider);
  app.get("/vettingStatus", newCampaign.brandVettingStatus);
  app.post("/applyVetting", newCampaign.applyVetting);
  app.put("/enhancedVettingReport", newCampaign.enhancedVettingReportDownload);
  app.put("/importVetting", newCampaign.importVetting);
  app.get("/externalVettingList", newCampaign.externalVettingList);
  app.get("/getBrandsVettingList", newCampaign.getBrandsVettingList);
  app.get("/getVettingClass", newCampaign.getVettingClassByEtype);
  app.get("/getVettingPartner", newCampaign.getVettingPartner);
  app.put("/updateVettingForStatus", newCampaign.externalVettingBulkUpdate);
  //app.post("/createMockCvToken", newCampaign.createMockCvToken);
  //app.get("/getSummeryCDRList", newCampaign.getSummeryCDRList);
  app.post("/appealRequest", appeal, newCampaign.appealRequest);
  app.post("/appealVettingRequest", appeal, newCampaign.appealVettingRequest);
  app.get("/getBranAppeal", newCampaign.getBranAppeal);
  app.get("/getBranAppealFiles", newCampaign.getBranAppealFiles);
  app.get("/getVettingAppealDetails", newCampaign.getVettingAppealDetails);
  // End brand and vetting routes

  /* Start reseller  routing */
  const reseller = new Reseller();
  app.post("/saveReseller", reseller.saveReseller);
  app.get("/getReseller", reseller.getReseller);
  //app.get("/getsingleReseller", reseller.getsingleReseller);
  app.get("/getResellerPlan_tariff", reseller.getResellerPlan);
  app.put("/updateResellerbyID", reseller.updateResellerbyID);
  app.delete("/deleteReseller", reseller.deleteReseller);
  app.get("/resellerFilter", reseller.resellerListFilter);
  app.put("/PayTransactionAmount", reseller.updateTransAmount);
  /** ROUTE FOR Reseller Commission Details*/
  app.get("/commDetailsFilter", reseller.commDetailsFilter);
  /** ROUTE FOR Reseller Commission Plan*/
  app.post("/saveCommissionPlan", reseller.saveCommissionPlan);
  app.get("/getCommissionPlan", reseller.getCommissionPlan);
  //app.get("/singleGetCommissionPlan", reseller.singleGetCommissionPlan);
  app.put("/updateCommissionPlan", reseller.updateCommissionPlan);
  app.delete("/deleteCommissionPlan", reseller.deleteCommissionPlan);
  app.get("/commissionTerm", reseller.commissionTerm);
  app.put("/default_plan", reseller.setDefaultplan);


  // app.get("/commissionFilter", reseller.commissionFilter);

  /*Route for customer details*/
  app.get("/customerDetailsFilter", reseller.customerDFilter);

  /** ROUTE FOR Reseller Commission Tier with commission plan*/
  app.post("/saveCommissionTier", reseller.saveCommissionTier);
  app.get("/getCommissionTier", reseller.getCommissionTier);
  app.put("/updateCommissionTier", reseller.updateCommissionTier);
  app.delete("/deleteCommissionTier", reseller.deleteCommissionTier);


  const notify = new NotificationSystem();
  //Email Notification
  app.get("/getStatusList", notify.Statuslist)
  app.get("/getcategoryList", notify.CategorieslistAdmin)
  app.get("/getcategoryListCust", notify.CategorieslistCust)
  app.post("/savenotifyemail", tollfreemulter, notify.SaveNotifyEmail)
  app.get("/get_EmailNotification", notify.get_emailNotification)
  app.get("/get_singleEmailNotify", notify.get_singlemailNotify)
  app.get("/NotifyCustomerList", notify.NotifyCustomerList)
  app.post("/saveCustMail", notify.SaveCustomerMail)
  app.get("/emailsubscriber", notify.ToEmailList)
  app.put("/updatestatus_view", notify.UpdateStatusViewEmail)
  app.get("/get_Emailsubscription", notify.get_emailsubscription)
  app.put("/UpdateCustMail", notify.UpdateCustomerMail);
  app.get("/NotificationCountList", notify.NotificationCountList)
  app.get("/CustomerEmailSubscrip", notify.EmailSubscriptionMail)

  //System Notification 
  app.get("/getSystemNotificationStatus", notify.getSystemNotificationStatus);
  app.post('/sendNotification', notify.sendNotification);
  // app.get("/getNotificationData", notify.getNotificationData);
  app.get("/viewNotification", notify.viewNotification);
  app.get("/displayNotificationForCustomer", notify.displayNotificationForCustomer);
  app.get("/NotificationCountForCustomer", notify.NotificationCountForCustomer);
  app.put("/UpdateViewNotificationStatus", notify.UpdateViewNotificationStatus);
  


  const stripe = new StripeApi();
  app.post("/recharge", stripe.RechargeByAdmin);
  app.get("/getbalance", stripe.getBalance);
  app.post("/addbalance", stripe.addBalance);
  app.put("/updatebalance", stripe.updateBalance);
  app.put("/updatepaymentsetting", stripe.updatePaymentSetting);
  app.get("/paymenthistory", stripe.paymentHistory);
  app.get("/stripe-card", stripe.stripeCard);
  app.post("/create-card", stripe.createCustomerCard);
  app.get("/stripe-cards", stripe.stripeCards);
  app.get("/stripe-cards-default", stripe.stripeCardForAddBalance);
  app.put("/set-default-card", stripe.setDfaultCard);
  app.delete("/delete-card", stripe.deleteCard);
  app.get("/getcustbalance", stripe.getcustBalance);

  app.post("/onBoardcreateCard", stripe.onBoardcreateCard);
  app.delete("/deleteOnBoardCard", stripe.deleteOnBoardCard);
  app.get("/onBoardstripecards", stripe.onBoardstripecards);
  app.post("/saveCardForm", stripe.saveCardForm);
  app.post("/uploads/card_pdf", uploadCARD, stripe.saveCardPdf);
  app.get("/getCardPdfForAdmin", stripe.getCardPdfForAdmin);

  app.post("/card_delete", stripe.deleteCustomerCard)
  app.get("/get_card_data", stripe.CustomercardData)
  app.get("/get_stripe_data", stripe.CustomerStripecardData)

  /** route for kyc */

  const kyc = new Kyc();
  app.get("/getQuestion", kyc.getQuestion);
  app.post("/addkyc", kyc.addKyc);
  app.post("/kyc_upload", uploadKYC, kyc.saveKycpdf);
  app.get("/getkycpdf_questions", kyc.getKycPdf_ques);
  app.get("/getallData", kyc.getallData);
  app.get("/checkKycRoute", kyc.checkKycRoute);
  app.get("/downloadPdfForAdmin", kyc.downloadPdfForAdmin);
  app.get("/CustomerProfileInformation", kyc.CustomerProfileInformation);
  app.get("/getkycstatus", kyc.getkycstatus);
  app.put("/rejectKycStatus", kyc.rejectKycStatus);
  app.get("/getFederalPdfForAdmin", kyc.getFederalPdfForAdmin);
  app.put("/cancelKycStatus", kyc.cancelKycStatus);
  app.get("/getKycPdfLog", kyc.getKycPdfLog);
  //app.post("/sendNotification",kyc.sendNotification)


  /** Federal DNC */
  app.get("/getfedQuestion", kyc.getFedrlQuestion);
  app.post("/save_federal", kyc.saveFederal);
  app.post("/savefederalpdf", uploadFEDERAL, kyc.savefederalpdf);
  app.get("/get_FederalPdf", kyc.getFederalPdf);
  app.put("/verifyfederalStatus", kyc.verifyfederalStatus);
  app.put("/rejectfederalStatus", kyc.rejectfederalStatus);
  app.get("/getAccSettingStatus", kyc.getAccSettingStatus);
  app.get("/getFederalPDFAccount", kyc.getFederalPDFAccount);
  app.put("/cancelFederalStatus", kyc.cancelFederalStatus);



  /**
   * Routes for Panel + Swagger
   */
  var sms = new Sms();
  app.post("/messages", extMMS, sms.messages);
  app.post("/sms", sms.SendSms);
  app.post("/mms", extMMS, sms.SendMms);
  app.post("/mdrsearch", sms.mdrsearch);
  app.post("/mmsbymedia", sms.mmsbymedia);
  app.post("/messagesbymedia", sms.messagesbymedia);

  /**
   * Routes for Panel + Swagger
   */
  var call = new Call();
  app.post("/reptest", call.repTest);
  app.post("/originate", call.MakeOutboundCallToNumber);
  app.post("/senddtmf", call.sendDtmf);
  app.post("/barge", call.Barge);
  app.post("/hangup", call.Hangup);
  app.post("/record", call.Recording);
  app.post("/hold", call.Hold);
  app.post("/transfer", call.CallTransfer);
  app.post("/3waycall", call.ThreeWayCall);
  app.post("/makecall", call.MakeCall);
  app.post("/makeCallViaMedia", call.MakeCallviaMedia);
  app.post("/receiveddtmf", call.recvDtmf)
  //app.post("/blindtansfer",call.blindTransfer);
  app.get("/getcall", call.getChannelList);

  var SignupLog = new SignUPLogin();
  app.post("/emailverify", SignupLog.SignUPLogin);


  /**
   * Routes for Panel + Swagger
   */
  var cnam = new CnamApi("", "");
  app.post("/cnamadd", cnam.addCnam);

  var SwaggerLog = new SwaggerLogin();
  app.post("/apiLogin", SwaggerLog.UserLogin);
  //app.post("/apilogin", SwaggerLog.UserLogin);


  /**
   * Routes for Panel + Swagger
   */
  var osrpi = new OsrApi("", "");
  app.put("/osrupdate", osrpi.updateNumber)

  var importNum = new Importnumber("");
  app.post("/importNumber", importNum.importNumber);

  var swaggerApi = new SwaggerApi();
  app.post("/BuyTollfree", swaggerApi.BuyTollfree);

  var numberApi = new Number();
  app.get("/searchtollfree", numberApi.SearchTolefree)
  app.get("/searchbyrate", numberApi.SearchByRate);
  app.get("/searchbynpa", numberApi.SearchByNpxNaa);
  app.get("/getnumberdetails", numberApi.NetworkOperators);
  app.post("/buy", numberApi.PurchaseDid);
  app.post("/enablesms", numberApi.EnableSMS);
  app.post("/re-provisioning-sms", numberApi.reProvisioningSMS);
  app.get("/enablesmsstatus", numberApi.RetrievOsr);
  app.get("/enablesmsnotifications", numberApi.RetrievOsrNotification);
  app.delete("/disablesms", numberApi.DeleteNumber);
  app.delete("/disablesinchsms", numberApi.DeleteSinchNumber);
  app.post("/disconnect", numberApi.DisconnectDid);
  app.put("/didienable", numberApi.didEnableDisable);
  app.post("/addtocart", numberApi.onAddToCart);
  app.post("/addAllToCart", numberApi.addAllToCart);
  app.get("/carts", numberApi.getCart);
  // app.get("/autoRenewalDetails", numberApi.autoRenewalDetails);
  app.delete("/deletecart", numberApi.deleteCart);
  app.post("/deletecartItems", numberApi.deleteItems);
  app.delete("/clearcart", numberApi.clearCart);
  app.get("/dids", numberApi.onGetDIDs);
  app.get("/smsdids", numberApi.getSMSTextDid);
  app.post("/exportdid", numberApi.onExportDID);
  app.post("/exportorderdid", numberApi.onExportOrderDID);
  app.get('/didlocationinfo', numberApi.DidLocationInfo);
  app.put("/updatedid", numberApi.updateDid);
  app.put("/selected_dids", numberApi.updateSelectedDid);
  app.get("/getstate", numberApi.GetState);
  app.get("/getratecenter", numberApi.GetRateCenter);
  app.get("/getnpa", numberApi.GetNPA);
  app.get("/getnxx", numberApi.GetNXX);
  // app.get("/getnxx", numberApi.getDisconnectedDid);
  // app.post("/addcart", numberApi.AddCart);
  app.get("/getmdr", numberApi.GetMdr);
  app.get("/getcdr", numberApi.GetCdr);
  app.put("/disconnect-dids", numberApi.disconnectSelectedDid);
  app.get("/getStates", numberApi.getStates);
  app.put("/setConnection", numberApi.updateConnectionOnDid);
  app.post("/buy_dids", numberApi.PurchaseAllDIDs);
  app.post("/create_group_order", numberApi.CreateGroupOrder);
  app.get("/get_orders_history", numberApi.GetOrdersHistory);
  app.get("/view_order_history", numberApi.ViewOrderHistory);
  app.get("/smsProvider", numberApi.getSmsProvider);
  app.get("/getDisconnectedDid", numberApi.getDisconnectedDid);
  app.put("/restoreDisconnectDid", numberApi.restoreDisconnectDid);
  app.get("/custdidscount", numberApi.customerDidsCount);
  app.post("/tfRequest", numberApi.tfRequest);
  app.get("/get_did", numberApi.getDID);
  app.get("/get_did_details", numberApi.getDIDdetail);
  app.get("/get_did_all", numberApi.getDIDall);
  app.post("/getMultiSearch", extractImage, numberApi.getMultiSearch); 
  app.post("/orderhistoryfilter", numberApi.Orderhistoryfilter);
  app.get("/getscode", numberApi.getshortcode);
  app.post("/onExportSCode", numberApi.onExportSCode);
 

  /**
   * Routes for Panel + Swagger
   */
  var connection = new Connection();
  app.get('/historyDid', connection.getDidHistory);
  // app.get('/historyDid_details', connection.getDidHistoryDetails);
  app.get('/customerHistory_details', connection.getDidHistoryDetails);
  app.get('/campaignHistory_details', connection.getCampaignHistoryDetails);
  app.get("/getconnection", connection.getConnections);
  app.get("/get_inbound", connection.getInbound);
  app.get("/get_outbound", connection.getOutbound);
  app.get("/get_routing", connection.getConnectionData);
  app.get("/get_setting", connection.getExpertSetting);
  app.get("/get_url", connection.getUrlData);
  app.get("/get_urls", connection.getUrlData);
  app.post("/set_url", connection.insertUrlsData);
  app.put("/set_pass", connection.updatePassword);
  app.get("/getIP", connection.getIP);
  app.post("/saveconnectionIP", connection.saveConnectionIP);//panel
  app.post("/saveconnection", connection.saveConnection);//swagger
  app.delete("/deleteconnection", connection.deleteConnection);
  app.get("/getDid", connection.getDid);
  app.get("/listconnectionUI", connection.listConnectionsPanel); // panel
  app.get("/listconnection", connection.listConnectionsSwagger); // swagger
  app.get("/singledefconn", connection.UserDefaultConnection);
  app.get("/get_all_Key", connection.AllKeyByConnKey);
  app.post("/addcredential", connection.AddCredential)
  app.post("/addip", connection.AddIP);
  app.put("/update_ip", connection.UpdateIP);
  app.put("/updatefqdn", connection.UpdataFqdn);
  app.post("/addforwardall", connection.AddForwardAll);
  app.put("/updatehookUrls", connection.UpdateHookUrl);
  app.post("/addhookUrls", connection.AddHookUrl);

  app.post("/saveip", connection.saveIP);
  app.put("/updateip", connection.updateIP);
  app.delete("/deleteip", connection.deleteIP);

  app.post("/saveurls", connection.saveUrls);
  app.post("/save_smsinbound", connection.save_smsInbound);
  app.post("/save_smsoutbound", connection.save_smsOutbound);

  app.put("/updateconntechpre", connection.updateConnTeckPre);
  app.put("/updateconnuserpass", connection.updateConnUserPass);
  app.put("/updateconninboundcall", connection.updateConnInboundCall);
  app.put("/updateconnection", connection.updateConnection);
  app.put("/updateconnectionname", connection.updateConnectionName);

  app.put("/updatestatus", connection.updateStatus);
  app.put("/update_fqdn", connection.updateFQDN);
  app.put("/update_urls", connection.updateUrls);
  app.put("/update_expertsetting", connection.updateExpertSetting);
  app.put("/update_inbound", connection.updateInbound);
  app.put("/update_outbound", connection.updateOutbound);
  app.put("/default-connection", connection.setDefaultConnection);



  /**
   * Routes for Panel + Swagger
   */
  const agent = new AgentClass();
  app.get("/getsingleagent", agent.getSingleAgent);
  app.get("/getagents", agent.getAgents);
  app.get("/getagent", agent.getAgent);
  app.post("/addagent", agent.addAgent);
  app.patch("/updateagent", agent.updateAgent);
  app.get("/getallagent", agent.getAllAgent);
  app.put("/agentstatus", agent.updateAgentStatus);
  app.delete("/deleteagent", agent.deleteAgent);
  app.get("/getsinglegroup", agent.getSingleGroup);
  app.get("/getgroup", agent.getGroup);
  app.post("/addgroup", agent.addGroup);
  app.patch("/updategroup", agent.updateGroup);
  app.delete("/deletegroup", agent.deleteGroup);
  app.get("/getgroups", agent.getGroups);

  // app.post("/addtiermapping", agent.addMapping);
  // app.get("/getmapping", agent.getMapping);
  // app.put("/updatemapping", agent.updateMapping);
  // app.post("/addmapping", agent.addAgentMapping);
  app.post("/agentlogin", agent.agentLogin);
  app.post("/agentstatus", agent.changeStatus);
  app.get("/agentlogout", agent.agentLogout);


  app.post("/channel-request", agent.saveChannelRequest);
  app.get("/channel-request-list", agent.channelRequestList);
  app.put("/approve-and-reject-channel-limit", agent.changeChanelStatus);


  let mdbreport = new Reports();
  app.get("/reports/mixed", mdbreport.MixedGraph);
  app.get("/reports/circular", mdbreport.CircularGraph);
  app.get("/reports/data", mdbreport.DataReport);
  app.get("/custom/chartdata", mdbreport.BasicReports);

  var common = new CommonClass();
  app.get("/details_cdr", common.getCdrFilter);
  app.get("/SummeryCdrForm", common.summeryCdrForm);
  app.get("/getmdrfilter", common.getMDRFilter);
  app.get("/summerysmsmdrfilter", common.summeryMDRFilter);
  app.get("/getmmsmdrfilter", common.getMMSMDR);
  app.get("/summerymmsmdrfilter", common.summeryMMSMDR);

  app.get("/monthly-invoice", common.montholyInvoice);
  app.get("/invoice", common.billingInvoice);
  app.get("/get_invoice_tax", common.getInvoiceTax);
  app.get("/operators", common.searchOperators);
  app.post("/upload_lerg", extractImage, common.uploadLergInfo);
  app.post("/upload_zone", extractImage, common.uploadZone);
  app.get("/lerg_category", common.categoryFromLergInfo);
  app.get("/lerg_operators", common.operatorFromLergInfo);
  app.post("/operator-mapping", common.setOperatorMapping);
  app.get("/lerg_info", common.Lerg_Info);
  app.get("/operator-mapping", common.getOperatorMapping);
  app.delete("/delete-mapping", common.deleteMapping);
  app.post('/generate-invoice', common.ganarateInvoice);
  app.get("/invoice-address", common.invoiceBillingAddress);
  app.get("/tmobile-list", common.tMobileReportList);
  app.get("/tmobile-report", common.tMobileReport);
  app.get("/zones", common.getZones);
  app.get("/csvinvoice", common.CsvInvoice);
  app.get("/demo", common.demo);
  app.post("/uploadDid", extractImage, common.uploadDID);
  app.get("/getCampaign", common.getCampaign);
  app.get("/get_connections", common.GetConnections);
  app.get("/get_connections_by_account", common.GetConnectionsByAccount);
  app.get("/listMedia", common.getMediaFiles);
  app.get("/getMediaFile", common.getMediaFile);
  app.post("/uploadMedia", uploadMMS, common.upload_media);
  app.post("/updateMediaFile", uploadMMS, common.updateMediaFile);
  app.delete("/deleteMedia", common.deleteMedia);
  app.post("/save-country", common.saveCountry);
  app.get("/get-country", common.getCountry);

  app.get("/listmmsmedia", common.listMmsMedia);
  app.get("/getmmsmediafile", common.getMmsMediaFileDetail);
  app.delete("/deletemmsmedia", common.deleteMMSMedia);
  app.post("/uploadmmsmedia", uploadMMS, common.uploadMmsMedia);
  app.get("/listallmmsmedia", common.listAllMMSmedia);
  app.get("/getrates", common.GetRates);


  var volt = new Volt();
  app.put("/logintoVolt", volt.logintoVolt);
  app.post("/voltauth", volt.signalmashAuthentication);

  var tmpSetting = new TemplateSetting();
  app.post("/email-template", tmpSetting.emailTemplate);
  app.delete("/email-template", tmpSetting.deleteEmailTempalte);
  app.get("/email-template", tmpSetting.getEmailTemplate);
  app.get("/email-templates", tmpSetting.getEmailTemplates);
  app.put("/email-template", tmpSetting.updateEmailTemplate);
  app.put("/email-template-status", tmpSetting.updateStatus);
  app.post("/sms-template", tmpSetting.smsTemplate);
  app.put("/sms-template", tmpSetting.updateSmsTemplate);
  app.put("/sms-template-status", tmpSetting.updateStatusSMS);
  app.get("/sms-template", tmpSetting.getSmsTemplate);
  app.get("/sms-templates", tmpSetting.getSmsTemplates);
  app.post("/2fa-template", tmpSetting.twofaTemaplate);
  app.get("/2fa-template", tmpSetting.get2FATemplate);
  app.get("/2fa-templates", tmpSetting.get2FATemplates);
  app.put("/2fa-template", tmpSetting.update2FATemplate);
  app.put("/2fa-defaultTemplate", tmpSetting.setDfaultTemplate);
  app.delete("/2fa-template", tmpSetting.delete2FATemplate);
  app.post("/post_mms", extMMS, tmpSetting.mmsTemplate);
  app.get("/getmms_id", tmpSetting.getMmsTemplate);
  app.get("/getmms", tmpSetting.getMmsTemplates);
  app.put("/update_mms", extMMS, tmpSetting.updateMmsTemplate);
  app.delete("/delete_mms", tmpSetting.deleteMMSTemplate);
  app.get("/refactorTemplate", tmpSetting.refactorTemplate);

  const webhook = new Webhook();
  app.get("/webhookCategory", webhook.Webhookcategory);
  app.get("/getEventtype", webhook.geteventType);
  app.post("/addWebhook", webhook.addWebhook);
  app.get("/getWebhook", webhook.getWebhook);
  app.delete("/deleteWebhook", webhook.deleteWebhook);
  app.put("/updateWebhook", webhook.updateWebhook);
  app.put("/webhookSubscription", webhook.addWebhookForSwagger);

  var tollfree = new TollFree();
  app.post("/EnableTFsms", tollfree.EnableTFsms);
  app.post("/disableTFsms", tollfree.disableTFsms);
  app.post("/saveVefiySender", tollfreemulter, tollfree.saveVerfiySender);
  app.get("/getVerified_Sender", tollfree.getVerified_Sender);
  app.get("/did_number", tollfree.did_number);
  app.get("/getsingleSenderDetails", tollfree.getsingleSenderDetails);
  app.put("/approveSenderStatus", tollfree.approveSenderStatus);
  app.put("/rejectSenderstatus", tollfree.rejectSenderstatus);
  app.put("/approveReviewStatus", tollfree.approveReviewStatus);
  app.put("/rejectReviewStatus", tollfree.rejectReviewStatus);
  app.put("/csvForIntq", tollfree.csvForIntq);
  app.post('/sentMailtoIntq', tollfreemulter, tollfree.sentMailtoIntq);
  app.get('/getbatchId', tollfree.getbatchId);
  app.get('/getrequestID', tollfree.getrequestID);
  app.get('/downloadCSVemail', tollfree.downloadCSV);
  app.post('/resendEmailtoIntq', tollfree.ResentMailtoIntq);
  app.post("/updateVerifySender", tollfreemulter, tollfree.updateverifysender);
  app.get("/getAssign_number", tollfree.getAssignNumber);
  app.post("/tollfreefilter", tollfree.TollFreeFilter);
  app.post("/emailtollfreefilter", tollfree.EMailTollFreeFilter);
  app.put("/did_change", tollfree.did_change);
  app.put("/did_reject", tollfree.did_reject);
  app.get('/get_status', tollfree.get_status);
  app.get("/get_RequestID", tollfree.get_requesID)
  app.post("/tollfreeAssignfilter", tollfree.TollFreeAssignFilter);


  var postback = new Postback();
  app.post("/callbackmms/v1/sinch_mms", postback.postbackMMS);
  app.post("/callbackdlr/v1/sinch_dlr", postback.postbackDLR);

  var hookrate = new HookUrls();
  app.get("/getkamrate", hookrate.getRate);


  /**
   * Routes for Panel + Swagger
   */
  const twoFactAuth = new TwoFactorAuth();
  app.post("/sendotpbysms", twoFactAuth.SendOtpBySMS);
  app.post("/sendotpbycall", twoFactAuth.SendOtpByCall);
  app.post("/verifyotp", twoFactAuth.VerifyOtp);
  app.post('/verify-call-otp', twoFactAuth.verifyCallOtp);
  app.post('/sendMMSTemplate', extMMS, twoFactAuth.sendMMSTemplate);
  app.post('/sendotpCall', twoFactAuth.SendOtpByCallOnboarding);

  var obj = new AppRoute();
  app.get("/[a-z]{1,20}/[a-z]{1,20}", obj.getMethod);
  app.get("/[a-z]{1,20}", obj.getMethod);
  app.post("/[a-z]{1,20}", obj.postMethod);
  app.put("/[a-z]{1,20}", obj.putMethod);
  app.delete("/[a-z]{1,20}", obj.deleteMethod);
  app.patch("/[a-z]{1,20}", obj.patchMethod);

}