import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { Number } from "./numberApi";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { OsrApi } from "./Osr";
import { SinchApi } from "./SinchSubmitNumber";
import { parseBody } from "./markError";
var request = require('request');
const crypto = require('crypto');

export class InteliquentAPI extends APIBase {
    private key: string;
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey: string;
    private URL: string;
    private privateKey: string;
    private sendSMSKey: string;
    private sendTFSMSUrl: string;

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        // Production key
        /* this.key = "eFluR1hOVERZZGY3dHc5Tno4dzFaemhtbFpnQzpEendnQjZCMVVKc2JwaUZxRXBieW9MODY0dFR3";
        this.URL = 'https://services.inteliquent.com/Services/1.0.0'
        this.privateKey = 'xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC' 
        this.sendTFSMSUrl ='https://messagebroker.inteliquent.com/msgbroker/rest'
        this.sendSMSKey = 'hfnm95ALNW3MjCcJHM7MwmfnzCKEJNcH'
        */

        //SandBox key
        this.key = "ZVFzdGdKaHZsa3UwMldLMDBzRnhDN3ZNVHdLTjo2ZllFSDlISklqVTFRWkJTODU3cXlVNXVaQldQ";
        this.URL = 'https://services-sandbox.inteliquent.com/Services/1.0.0'
        this.privateKey = 'eQstgJhvlku02WK00sFxC7vMTwKN'
        this.sendTFSMSUrl = 'https://messagebroker.inteliquent.com/msgbroker/rest'
        this.sendSMSKey = 'hfnm95ALNW3MjCcJHM7MwmfnzCKEJNcH'

        this.timekey = timekey,
            this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }

    public rpad(name: any, size: number) {
        let ret = name;
        for (let i = name.length; i < size; i++)
            ret += "x";
        return ret;
    }

    public getNpaNxx(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    let tnMask: any;
                    if (sdata.NXX == "null" || sdata.NXX == undefined) {
                        tnMask = this.rpad(sdata.NPA, 10);
                    }
                    if (sdata.NXX !== undefined && sdata.NXX !== 'null') {
                        tnMask = this.rpad(sdata.NPA + "" + sdata.NXX, 10);
                    }
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tnInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': this.privateKey,
                            "tnMask": tnMask,
                            "quantity": sdata.Qty
                        }),
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let ddata = JSON.parse(response.body);
                                if (ddata.statusCode == 200) {
                                    if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                        let str = ddata.tnResult;
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                        str.forEach((ele: any) => {
                                            qrystr += "('', '" + ele.telephoneNumber + "', '" + ele.lata + "', '', '" + ele.rateCenter + "', '" + parseBody(ele.province) + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + parseBody(ele.city) + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.rateCenterTier + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    } else {
                                        callback('', ddata);
                                    }
                                } else {
                                    callback('', ddata);
                                }
                            } catch (e) {
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '')
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tnInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': this.privateKey,
                            "tnMask": "**********",
                            "tnWildcard": "***********",
                            "rateCenter": sdata.RateCenter,
                            "province": sdata.State,
                            "quantity": sdata.Qty
                        }),
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let ddata = JSON.parse(response.body);
                                if (ddata.statusCode == 200) {
                                    if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                        let str = ddata.tnResult;
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                        str.forEach((ele: any) => {
                                            qrystr += "('', '" + ele.telephoneNumber + "', '" + ele.lata + "', '', '" + ele.rateCenter + "', '" + parseBody(ele.province) + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + parseBody(ele.city) + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.rateCenterTier + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    } else {
                                        callback('', ddata);
                                    }
                                } else {
                                    callback('', ddata);
                                }
                            } catch (e) {
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "VN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    let data1: any = req.query;
                    let cbody: any = '';
                    if (data1.quantity != '' && data1.tnMask1 != 'null') {
                        cbody = JSON.stringify({
                            "privateKey": this.privateKey,
                            "tnMask": data1.tnMask1 + data1.tnMask2 + data1.tnMask3,
                            "sequential": data1.sequential,
                            "quantity": data1.quantity
                        })
                    }
                    if (data1.wildcard != '' && data1.quantity != '') {
                        cbody = JSON.stringify({
                            "privateKey": this.privateKey,
                            "tnWildcard": data1.wildcard,
                            "sequential": data1.sequential,
                            "quantity": data1.quantity
                        });
                    }
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tfInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key,
                        },
                        body: cbody
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let ddata = JSON.parse(response.body);
                                if (ddata.statusCode == 200) {
                                    if (ddata.tfList.tfItem != undefined && ddata.tfList.tfItem.length > 0) {
                                        let str = ddata.tfList.tfItem;
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                        str.forEach((ele: any) => {
                                            qrystr += "('', '" + ele.tn + "', '', '', '', '', '', '', '', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','" + "TF" + "','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    } else {
                                        callback('', ddata);
                                    }
                                } else {
                                    callback('', ddata);
                                }
                            } catch (e) {
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public tfRequest(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.body.data;
        this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
            // To get the proration status
            let objv0 = new ModelRawNonQuery(req, res);
            objv0.nonqrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let dateObj = new Date();
                    let day = dateObj.getUTCDate();
                    let nDate: any = new Date()
                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                    let totalDays = (lDate - day) + 1;
                    let prorate: any;
                    if (proration_success[0].proration == "true")
                        prorate = (totalDays * voice_rate[0].rate) / lDate;
                    else
                        prorate = voice_rate[0].rate;

                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0

                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + this.sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + prorate * sdata.cdata.Qty + "'"
                    obj1.prepare();
                    obj1.execute((walletError: any, wallet: any) => {
                        if (walletError == 1 && wallet.length > 0) {
                            let privateKey = this.privateKey;
                            let customerOrderReference = "b1f86e6a5e0d";
                            let respOrgId = "LQX01";
                            let routingLabel = "NTDAL-4927-8XX-950";
                            const formattedDate = new Date(new Date().getTime() + (4 * 24 * 60 * 60 * 1000)).toISOString().split('T')[0];
                            var options = {
                                'method': 'POST',
                                'url': this.URL + '/tfRequest',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + this.key,
                                },
                                body: JSON.stringify({
                                    "privateKey": privateKey,
                                    "customerOrderReference": customerOrderReference,
                                    "desiredDueDate": formattedDate,
                                    "quantity": sdata.cdata.Qty,
                                    "respOrgId": respOrgId,
                                    "routingLabel": routingLabel
                                })
                            };
                            request(options, (error: any, response: any) => {
                                if (!error) {
                                    try {
                                        let sdata1 = JSON.parse(response.body);
                                        if (sdata1.statusCode == 200 && sdata1.status == 'Success') {

                                            let objv6 = new ModelRawNonQuery(req, res);
                                            objv6.nonqrysql = "INSERT INTO `tollfree_request` (`iduser`, `idaccount`, `privateKey`, `customerOrderReference`,`desiredDueDate`,`respOrgId`,`routingLabel`,`status`,`statusCode`,`orderId`,`quantity`,`order_status`,`rates`,`pro_rates`,`type`,`id_grouporder`) VALUE('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + privateKey + "','" + customerOrderReference + "','','" + respOrgId + "','routingLabel','" + sdata1.status + "','" + sdata1.statusCode + "','" + sdata1.orderId + "','" + sdata.cdata.Qty + "','0','" + voice_rate[0].rate + "','" + prorate + "','TF','" + sdata.groupId + "')";
                                            objv6.prepare();
                                            objv6.execute((tol_error, tf_req) => {
                                                if (tol_error == 1) {
                                                    // To update the wallet amount
                                                    let objv = new ModelRawNonQuery(req, res);

                                                    objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate * sdata.cdata.Qty + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                    objv.prepare();
                                                    objv.execute((wallet_error, wallet_success) => {
                                                        // To update the wallet transaction log
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                        iQry += "`amount`='-" + prorate * sdata.cdata.Qty + "', "
                                                        iQry += "`purpose`='Wallet amount successfully updated for new DIDs', "
                                                        iQry += "`status`=1;"

                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                            if (error == 1) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 200, message: "Your Order will take 3 to 4 Business Days.Your Order ID is: (" + sdata1.orderId + ")", data: result });
                                                                objv.execute();
                                                            } else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 404, message: "Order is not Placed!" });
                                                                objv.execute();
                                                            }
                                                        });
                                                    });
                                                }
                                                else {
                                                    let obj = new RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with connection!" });
                                                    obj.execute()
                                                }
                                            });
                                        }
                                    } catch (e) {
                                        let obj = new RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong DID Buy!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong DID Buy!" });
                                    obj.execute()
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error_code: 0,
                                error: wallet,
                                message: "Please add funds to your account or contact support.",
                                status: 503
                            });
                            objv.execute();
                        }
                    });
                } else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let id_grouporder: number = other_data.id_grouporder;

        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''

            // To get the proration status
            let objv0 = new ModelRawQuery(req, res);
            objv0.qrysql = "SELECT t.`proration`,t.`day_num` FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let proration_status = proration_success[0].proration;
                    let did_dis_days = proration_success[0].day_num > 0 ? proration_success[0].day_num : 0;
                    // To purchase the toll free number
                    if (did_details[0].type == "TF") {
                        var options = {
                            'method': 'POST',
                            'url': this.URL + '/tfOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "privateKey": this.privateKey,
                                "productAbbr": "8XXAVAIL",
                                "tfOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "resporgId": "LQX01",
                                                "routingLabel": "NTDAL-4927-8XX-950",
                                                "trunkGroup": "CHCGIL24IPL_4649"
                                            }
                                        ]
                                    }
                                }
                            })
                        }
                        request(options, (error: any, response: any) => {
                            if (!error) {
                                try {
                                    let sdata1 = JSON.parse(response.body);
                                    //If order success
                                    if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                        let dateObj = new Date();
                                        let day = dateObj.getUTCDate();

                                        let nDate: any = new Date()
                                        let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                        let totalDays = (lDate - day) + 1;

                                        let prorate: any;
                                        if (proration_status == "true") {
                                            prorate = (totalDays * did_details[0].rates) / lDate;
                                        }
                                        else {
                                            prorate = did_details[0].rates;
                                        }

                                        prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0

                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "','" + prorate + "','" + did_dis_days + "','" + did_details[0].rates + "')";
                                        obj.prepare();
                                        obj.execute((err, data) => {
                                            if (err == 1) {
                                                // update end subscription date
                                                let obj0 = new ModelRawQuery(req, res);
                                                obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                                obj0.prepare();
                                                obj0.execute((dids_err, didRes) => {
                                                    let dates = didRes[0].subscription_end_date;
                                                    let isoDate = new Date(dates);
                                                    let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                    let obj01 = new ModelRawNonQuery(req, res);
                                                    obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                    obj01.prepare();
                                                    obj01.execute((error, result) => { })
                                                })


                                                // To update the wallet amount
                                                let objv = new ModelRawNonQuery(req, res);
                                                objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                objv.prepare();
                                                objv.execute((wallet_error, wallet_success) => {

                                                    // To update the wallet transaction log
                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                    iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                    iQry += "`amount`='-" + prorate + "', "
                                                    iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                    iQry += "`status`=1;"

                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {
                                                        console.log("Transaction response::", result)
                                                    })

                                                    // To create the DID log
                                                    let objv1 = new ModelRawNonQuery(req, res);
                                                    objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "','1','DID Buy')"
                                                    objv1.prepare();
                                                    objv1.execute((log_error, did_log) => { });

                                                    // To delete the DID from cart
                                                    let obj5 = new ModelRawNonQuery(req, res);
                                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                    obj5.prepare();
                                                    obj5.execute((walletError: any, wallet: any) => { });

                                                    // To update the process count of group order
                                                    let objk = new ModelRawNonQuery(req, res)
                                                    objk.nonqrysql = "UPDATE `did_group_order` SET `process_dids`=`process_dids`+ 1 WHERE `id_grouporder`=" + id_grouporder + ";"
                                                    objk.prepare()
                                                    objk.execute((error, result) => {
                                                        console.log("GroupOrder process count::\n", result)
                                                    })

                                                    // To create the did_order
                                                    let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        // To update the other data on current order
                                                        if (did_err == 1) {
                                                            let id_order: number = did_data.insertId
                                                            let orderID: string = "SORD" + id_order.toString()

                                                            let log_error: string = ""
                                                            let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                            let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                            obj.prepare();
                                                            obj.execute((error, result) => { })
                                                        }
                                                    });
                                                    // Leave the successfull output
                                                    let objV = new RawView(res);
                                                    objV.prepare({ error_code: 1, status: 201, message: "DID buy successfully.", result: [{ "did": sdata.DID.trim() }] });
                                                    objV.execute()

                                                });
                                            }
                                            else {
                                                let obj = new RawView(res);
                                                obj.prepare({
                                                    error_code: 0,
                                                    status: 502,
                                                    message: "Something went wrong with connection!"
                                                });
                                                obj.execute()
                                            }
                                        });
                                    }

                                    // If order failed
                                    else {
                                        // To delete the DID from cart
                                        let obj5 = new ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                        obj5.prepare();
                                        obj5.execute((walletError: any, wallet: any) => { });

                                        let I1: any = sdata1.status.indexOf("Waiting on internal port")
                                        let I2: any = sdata1.status.indexOf("TN is on a pending order")
                                        let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                        let obj = new ModelRawNonQuery(req, res);

                                        // It will check, if order goes into pending
                                        if (I1 > -1 || I2 > -1) {
                                            obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`, `ordConf`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "', '0')";
                                        }
                                        else {
                                            obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                        }

                                        obj.prepare();
                                        obj.execute((did_err, did_data) => {
                                            // To update the other data on current order
                                            if (did_err == 1) {
                                                let id_order: number = did_data.insertId
                                                let orderID: string = "SORD" + id_order.toString()

                                                let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                let log_result: string = ""

                                                obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                obj.prepare();
                                                obj.execute((error, result) => { })
                                            }
                                        });

                                        let objV = new RawView(res);
                                        objV.prepare({
                                            error_code: 0,
                                            status: sdata1.statusCode,
                                            message: sdata1.status
                                        });
                                        objV.execute()
                                    }
                                }
                                catch (e) {
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong DID Buy!" });
                                    obj.execute();
                                }

                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({ status: 400, error: error });
                                obj.execute()
                            }
                        });
                    }

                    // To purchase the local number
                    else {
                        var options = {
                            'method': 'POST',
                            'url': this.URL + '/tnOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "privateKey": this.privateKey,
                                "tnOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "trunkGroup": "CHCGIL24IPL_4648"
                                            }
                                        ]
                                    }
                                }
                            })
                        }
                        request(options, (error: any, response: any) => {
                            if (!error) {
                                try {
                                    let sdata1 = JSON.parse(response.body);
                                    // If order success
                                    if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                        let dateObj = new Date();
                                        let day = dateObj.getUTCDate();

                                        let nDate: any = new Date()
                                        let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                        let totalDays = (lDate - day) + 1;

                                        let prorate: any;
                                        if (proration_status == "true") {
                                            prorate = (totalDays * did_details[0].rates) / lDate;
                                        }
                                        else {
                                            prorate = did_details[0].rates;
                                        }
                                        prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "','" + prorate + "','" + did_dis_days + "','" + did_details[0].rates + "')";
                                        obj.prepare();
                                        obj.execute((err, data) => {
                                            if (err == 1) {
                                                // update end subscription date
                                                let obj0 = new ModelRawQuery(req, res);
                                                obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                                obj0.prepare();
                                                obj0.execute((dids_err, didRes) => {
                                                    let dates = didRes[0].subscription_end_date;
                                                    let isoDate = new Date(dates);
                                                    let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                    let obj01 = new ModelRawNonQuery(req, res);
                                                    obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                    obj01.prepare();
                                                    obj01.execute((error, result) => { })
                                                })

                                                // To update the wallet amount
                                                let objv = new ModelRawNonQuery(req, res);
                                                objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                objv.prepare();
                                                objv.execute((wallet_error, wallet_success) => {

                                                    // To update the wallet transaction log
                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                    iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                    iQry += "`amount`='-" + prorate + "', "
                                                    iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                    iQry += "`status`=1;"

                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {
                                                        console.log("Transaction response::", result)
                                                    })

                                                    // To create the DID log
                                                    let objv1 = new ModelRawNonQuery(req, res);
                                                    objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "','1','DID Buy')"
                                                    objv1.prepare();
                                                    objv1.execute((log_error, did_log) => { });

                                                    // To delete the DID from cart
                                                    let obj5 = new ModelRawNonQuery(req, res);
                                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                    obj5.prepare();
                                                    obj5.execute((walletError: any, wallet: any) => { });

                                                    // To update the process count of group order
                                                    let objk = new ModelRawNonQuery(req, res)
                                                    objk.nonqrysql = "UPDATE `did_group_order` SET `process_dids`=`process_dids`+ 1 WHERE `id_grouporder`=" + id_grouporder + ";"
                                                    objk.prepare()
                                                    objk.execute((error, result) => {
                                                        console.log("GroupOrder process count::\n", result)
                                                    })

                                                    // To create the did_order
                                                    let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        // To update the other data on current order
                                                        if (did_err == 1) {
                                                            let id_order: number = did_data.insertId
                                                            let orderID: string = "SORD" + id_order.toString()

                                                            let log_error: string = ""
                                                            let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                            let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                            obj.prepare();
                                                            obj.execute((error, result) => { })
                                                        }
                                                    });

                                                    // To submit the number on OSR
                                                    if (sdata.CampaignId) {
                                                        let osr = new OsrApi(this.priority, this.sessdata)
                                                        osr.updateNumber(req, res, data.insertId, (error, responce) => { })
                                                    }
                                                    else {
                                                        let obj = new RawView(res);
                                                        obj.prepare({
                                                            error_code: 1,
                                                            status: 201,
                                                            message: "DID buy successfully.",
                                                            result: [
                                                                {
                                                                    "did": sdata.DID.trim()
                                                                }
                                                            ]
                                                        });
                                                        obj.execute()
                                                    }
                                                });
                                            }
                                            else {
                                                let obj = new RawView(res);
                                                obj.prepare({
                                                    error_code: 0,
                                                    status: 502,
                                                    message: "Something went wrong with connection!"
                                                });
                                                obj.execute()
                                            }
                                        });
                                    }

                                    // If order failed
                                    else {
                                        // To delete the DID from cart
                                        let obj5 = new ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                        obj5.prepare();
                                        obj5.execute((walletError: any, wallet: any) => { });

                                        let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                        obj.prepare();
                                        obj.execute((did_err, did_data) => {
                                            // To update the other data on current order
                                            if (did_err == 1) {
                                                let id_order: number = did_data.insertId
                                                let orderID: string = "SORD" + id_order.toString()

                                                let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                let log_result: string = ""

                                                obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                obj.prepare();
                                                obj.execute((error, result) => { })
                                            }
                                        });

                                        let objV = new RawView(res);
                                        objV.prepare({
                                            error_code: 0,
                                            status: sdata1.statusCode,
                                            message: sdata1.status
                                        });
                                        objV.execute()
                                    }
                                }
                                catch (e) {
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }

                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 400,
                                    error: error
                                });
                                obj.execute()
                            }
                        });
                    }
                }
                else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }

    disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let iduser: number = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let obj2 = new ModelRawQuery(req, res);
        obj2.qrysql = "SELECT `type` from `did_buy` WHERE `iduser`='" + iduser + "' AND `did`='" + sdata.DID.trim() + "'";
        obj2.prepare();
        obj2.execute((err: any, resu: any) => {
            if (resu.length > 0) {
                // To release the toll-free number
                if (resu[0].type == "TF") {
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tfDisconnect',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            "privateKey": this.privateKey,
                            "tnList": {
                                "tnItem": [
                                    {
                                        "tn": sdata.DID.trim()
                                    }
                                ]
                            }
                        })
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                if (data.status == 'Success') {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                    obj.prepare();
                                    obj.execute((error: any, resp: any) => {
                                        if (error == 1) {
                                            // To  update updated_at date in did log
                                            let obj = new ModelRawNonQuery(req, res);
                                            //obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                            obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "')"
                                            obj.prepare();
                                            obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                            // To delete the number from OSR

                                            let payLoad: any = {
                                                DID: sdata.DID.trim()
                                            }
                                            let osr = new OsrApi(this.priority, this.sessdata)
                                            osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                if (error == 1) {
                                                    // To delete the number from Sinch
                                                    let osr = new SinchApi(this.priority, this.sessdata)
                                                    osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                    })
                                                }
                                            })

                                            // To release the final output
                                            let objv = new RawView(res)
                                            objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                            objv.execute();
                                        }
                                    })
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: data.statusCode, message: data.status });
                                    objv.execute()
                                }
                            }
                            catch (e) {
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }

                        }
                        else {
                            console.log("Inteliquent :::::::::::::::::::");
                            let objv = new RawView(res);
                            objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                            objv.execute()
                        }
                    });
                }

                // To release the local number
                else {
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tnDisconnect',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            "privateKey": this.privateKey,
                            "tnList": {
                                "tnItem": [
                                    {
                                        "tn": sdata.DID.trim()
                                    }
                                ]
                            }
                        })
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                if (data.status == 'Success' || data.statusCode == '425') {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                    obj.prepare();
                                    obj.execute((error: any, resp: any) => {
                                        if (error == 1) {
                                            // To  update updated_at date in did log
                                            let obj = new ModelRawNonQuery(req, res);
                                            //obj.nonqrysql = "UPDATE `did_log` SET `event_type`='5',`description`='DID Disconnected Successfully from Intelliquent',`updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                            obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','DID Disconnected Successfully','" + sdata.DID.trim() + "')"
                                            obj.prepare();
                                            obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                            // To delete the number from OSR
                                            let payLoad: any = {
                                                DID: sdata.DID.trim()
                                            }
                                            let osr = new OsrApi(this.priority, this.sessdata)
                                            osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                if (error == 1) {
                                                    // To delete the number from Sinch
                                                    let osr = new SinchApi(this.priority, this.sessdata)
                                                    osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                    })
                                                }
                                            })

                                            // To release the final output
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                            objv.execute()
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong" });
                                            objv.execute();
                                        }
                                    })
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: data.statusCode, message: data.status });
                                    objv.execute()
                                }
                            }
                            catch (e) {
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 400, error: error });
                            objv.execute()
                        }
                    });
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                objv.execute()
            }
        });
    }

    public EnableTFSMS(req: Request, res: Response, callback: (err: any, data: any) => void) {
        console.log("Toll-Free Number Enable SMS Process");
        const sdata = JSON.parse(req.body.data);
        let iduser: any = this.sessdata.type == 1 ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = this.sessdata.type == 1 ? sdata.idaccount : this.sessdata.idaccount;
        if (sdata.sinch_status === '0') {
            let rate = new APIBase();
            rate.getMessageRate(req, res, this.sessdata.idtariff, "message_activation", "TF", (err, message_rate) => {
                if (err == 1) {
                    let nrcMsgRate: any = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0,
                        mrcMsgRate: any = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;

                    rate.checkBalance(req, res, idaccount, nrcMsgRate, (errorR, resR) => {
                        if (errorR == 1) {
                            var options = {
                                'method': 'POST',
                                'url': this.URL + '/tfFeatureOrder',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + this.key,
                                    'Cookie': '__cf_bm=kLWM48QBIMVsXKCwoYpoO0Yx9yDUc5rz4pH2d..0vrg-1699441378-0-AZQ5AnHYIYAr4fcquQ3l3/aapkg+bqmn4hHGlCuS8LnswSB8xiwldZdXsfCQOio177BNIpUV8PAKmYKVeKc4JV0='
                                },
                                body: JSON.stringify({
                                    "privateKey": this.privateKey,
                                    "tfFeatureOrder": {
                                        "customerOrderReference": "b1f86e6a5e0d",
                                        "tnList": {
                                            "tnItem": [
                                                {
                                                    "tn": sdata.DID.trim(),
                                                    "tnFeature": {
                                                        "messaging": {
                                                            "messageClass": "A2P8XX",
                                                            "messageType": "SMSMMS_ALT",
                                                            "removeTnFeature": "N"
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                })
                            };
                            request(options, (error: any, response: any) => {
                                if (!error) {
                                    try {
                                        if (response) {
                                            let data = JSON.parse(response.body);
                                            if (data.statusCode == 200) {

                                                // To Set Webhook URL on Toll Free Number
                                                let intel = new InteliquentAPI("", this.sessdata, '');
                                                intel.setWebhookUrlOnTF(req, res, (errorr, resp) => { });

                                                if (nrcMsgRate > 0) {
                                                    // To deduct SMS Enable charges
                                                    let obj0 = new ModelRawNonQuery(req, res);
                                                    obj0.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + nrcMsgRate + " WHERE `idaccount`='" + idaccount + "'"
                                                    obj0.prepare();
                                                    obj0.execute((wallet_error, wallet_success) => {
                                                        if (wallet_error == 1) {
                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount successfully updated for TF EnableSMS', `status`=1"
                                                            objWL.prepare()
                                                            objWL.execute((error: any, result: any) => {
                                                                console.log("Wallet amount successfully updated for TF EnableSMS :: ", nrcMsgRate);
                                                            });
                                                        }
                                                        else {
                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount not updated for TF  EnableSMS', `status`=2"
                                                            objWL.prepare()
                                                            objWL.execute((error: any, result: any) => {
                                                                console.log("Wallet amount not updated for TF EnableSMS :: ", nrcMsgRate);
                                                            });
                                                        }
                                                    });

                                                    // To Insert nrc
                                                    let obj4 = new ModelRawNonQuery(req, res);
                                                    obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + iduser + "','" + idaccount + "','" + sdata.DID.trim() + "','" + nrcMsgRate + "')";
                                                    obj4.prepare();
                                                    obj4.execute((osr_err, resp) => {
                                                        console.log("TF EnableSMS Charges Log Inserted :: ", nrcMsgRate);
                                                    });
                                                }

                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'28','DID provisioned to INTELLIQUENT','" + sdata.DID.trim() + "','','15','" + response.body + "')";
                                                obj1.prepare();
                                                obj1.execute((err1, resp1) => {
                                                    console.log("DID log inserted for TF EnableSMS");
                                                });

                                                let obj2 = new ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='15', `sms_mrc`='" + mrcMsgRate + "' WHERE iduser = '" + iduser + "' AND `did`=" + sdata.DID.trim() + "";
                                                obj2.prepare();
                                                obj2.execute((err2, resp2) => {
                                                    console.log("DID buy updated for TF EnableSMS");
                                                });

                                                let obj0 = new ModelRawNonQuery(req, res);
                                                obj0.nonqrysql = "UPDATE verified_sender SET status = '3', awaiting_downstream_date = NOW() WHERE iduser = '" + iduser + "' AND unique_request_id = '" + sdata.request_id + "'";
                                                obj0.prepare();
                                                obj0.execute((err1, resp1) => {
                                                    console.log("Update the status");
                                                });

                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `tollfree_assigned_number` (`idaccount`,`iduser`,`did`,`tf_status`,`statusCode`,`orderId`,`requestId`) VALUES('" + idaccount + "','" + iduser + "','" + sdata.DID.trim() + "','" + data.request_id + "','" + data.statusCode + "','" + data.orderId + "','" + sdata.request_id + "')";
                                                obj3.prepare();
                                                obj3.execute((err3, resp3) => {
                                                    console.log("tollfree_sms_response for TF EnableSMS successfully inserted!");
                                                });

                                                let obj4 = new ModelRawNonQuery(req, res);
                                                obj4.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + iduser + "', '" + idaccount + "', '3', 'AWATING_DOWNSTREAM_PROCESS', 'Awaiting Downstream Process', '" + sdata.request_id + "')";
                                                obj4.prepare();
                                                obj4.execute((err4: any, resp4: any) => { });

                                                callback(1, { status: 200, message: "SMS enabled successfully!" });
                                            }
                                            else {
                                                console.log("Response ::==>> ", data);
                                                let obj4 = new ModelRawNonQuery(req, res);
                                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'29','DID provisioning failed to INTELLIQUENT','" + sdata.DID.trim() + "','','0','" + response.body + "')";
                                                obj4.prepare();
                                                obj4.execute((err4, resp4) => { });

                                                callback(0, { status: 502, message: "SMS is not enabled!" });
                                            }
                                        }
                                        else {
                                            callback(0, { message: "SMS is not enabled!", status: 507 });
                                        }
                                    } catch (e) {
                                        callback(0, { message: "Something Went Wrong with the server!", status: 508 });
                                    }
                                }
                                else {
                                    callback(0, { status: 506, message: "Something went wrong with service!" });
                                }
                            });
                        }
                        else {
                            callback(0, { message: "Please add funds to your account or contact support.", status: 504 });
                        }
                    });
                }
                else {
                    callback(0, { status: 505, message: "Rates not Found!" });
                }
            });
        }
        else if (sdata.sinch_status === '16') {
            let obj1 = new ModelRawNonQuery(req, res);
            obj1.nonqrysql = "UPDATE did_buy SET sinch_status = '15' WHERE did = " + sdata.DID + " AND iduser = '" + iduser + "'";
            obj1.prepare();
            obj1.execute((err1, resp1) => {
            });
            let obj0 = new ModelRawNonQuery(req, res);
            obj0.nonqrysql = "UPDATE verified_sender SET status = '3', awaiting_downstream_date = NOW() WHERE iduser = '" + iduser + "' AND unique_request_id = '" + sdata.request_id + "'";
            obj0.prepare();
            obj0.execute((err1, resp1) => {
                console.log("Update the status");
            });
            let obj2 = new ModelRawNonQuery(req, res);
            obj2.nonqrysql = "UPDATE tollfree_assigned_number SET requestId = '" + sdata.request_id + "' WHERE did = " + sdata.DID + " AND iduser = '" + iduser + "'";
            obj2.prepare();
            obj2.execute((err2, resp2) => {
            });
            let obj3 = new ModelRawNonQuery(req, res);
            obj3.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + iduser + "', '" + idaccount + "', '3', 'AWATING_DOWNSTREAM_PROCESS', 'Awaiting Downstream Process', '" + sdata.request_id + "')";
            obj3.prepare();
            obj3.execute((_error: any, result: any) => { });

            callback(1, { status: 200, message: "SMS enabled successfully!" });
        } else {
            callback(0, { status: 503, message: "SMS enabling Service not available!" });
        }
    }
    public setWebhookUrlOnTF(req: Request, res: Response, callback: (err: any, data: any) => void) {
        console.log("Set Toll-Free Webhook URL");
        const sdata = JSON.parse(req.body.data);
        let iduser: any = this.sessdata.type == 1 ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = this.sessdata.type == 1 ? sdata.idaccount : this.sessdata.idaccount;
        var options = {
            'method': 'POST',
            'url': this.sendTFSMSUrl + '/publishMessages',
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + this.sendSMSKey,
            },
            body: JSON.stringify({
                "authorizations": [
                    {
                        "inboundAuth": true,
                        "webhookUrl": "https://api.signalmash.com/intelequent_tollfreewebhook",
                        "tn": "1" + sdata.DID.trim().slice(-10)
                    }
                ]
            })
        };
        request(options, function (error: any, response: any) {
            if (!error) {
                try {
                    if (response) {
                        let data = JSON.parse(response.body)
                        let event_type: any = '', description: any = '';
                        if (data.success == true) {
                            event_type = '32';
                            description = 'Toll Free Webhook Url Set Successfully';
                            console.log("Toll Free webhook URL set successfully");
                        }
                        else {
                            event_type = '33';
                            description = 'Toll Free Webhook Url Not Set'
                            console.log("Toll-Free webhook URL not set!");
                        }
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'" + event_type + "','" + description + "','" + sdata.DID.trim() + "','','','" + response.body + "')";
                        obj1.prepare();
                        obj1.execute((err1, resp1) => {
                            console.log("DID Log Inserted for Set Toll-Free Webhook URL");
                        });
                    }
                    else {
                        console.log("Toll-free webhook URL not set successfully!");
                    }

                } catch (e) {
                    console.log("Something Went Wrong with the server!");
                }
            }
            else {
                console.log("Something went wrong!");
            }
        });
    }

    public disableTFSMS(req: Request, res: Response, callback: (err: any, data: any) => void) {
        console.log("Toll-Free Number Disable SMS Process");
        const sdata = JSON.parse(req.body.data);
        let iduser: any = this.sessdata.type == 1 ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = this.sessdata.type == 1 ? sdata.idaccount : this.sessdata.idaccount;
        var options = {
            'method': 'POST',
            'url': this.URL + '/tfFeatureOrder',
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + this.key,
                'Cookie': '__cf_bm=kLWM48QBIMVsXKCwoYpoO0Yx9yDUc5rz4pH2d..0vrg-1699441378-0-AZQ5AnHYIYAr4fcquQ3l3/aapkg+bqmn4hHGlCuS8LnswSB8xiwldZdXsfCQOio177BNIpUV8PAKmYKVeKc4JV0='
            },
            body: JSON.stringify({
                "privateKey": this.privateKey,
                "tfFeatureOrder": {
                    "customerOrderReference": "b1f86e6a5e0d",
                    "tnList": {
                        "tnItem": [
                            {
                                "tn": sdata.DID.trim(),
                                "tnFeature": {
                                    "messaging": {
                                        "messageClass": "A2P8XX",
                                        "messageType": "SMSMMS_ALT",
                                        "removeTnFeature": "Y"
                                    }
                                }
                            }
                        ]
                    }
                }
            })
        };
        request(options, function (error: any, response: any) {
            if (!error) {
                try {
                    if (response) {
                        let data = JSON.parse(response.body);
                        if (data.statusCode == 200) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUES('" + idaccount + "','" + iduser + "',NOW(),'30','DID provisioning MARK_DELETE to INTELLIQUENT','" + sdata.DID.trim() + "','','0','" + response.body + "')";
                            obj0.prepare();
                            obj0.execute((err4, resp4) => { });

                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0' WHERE  iduser = '" + iduser + "' AND `did`=" + sdata.DID.trim() + "";
                            obj1.prepare();
                            obj1.execute((err1, resp1) => { });

                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "DELETE FROM `tollfree_assigned_number` WHERE iduser = '" + iduser + "' AND requestId = '" + sdata.request_ID + "' AND did = '" + sdata.DID + "'";
                            obj2.prepare();
                            obj2.execute((err2, resp2) => {
                                console.log("SMS Service Disabled successfully!");
                                callback(1, { status: 200, message: "SMS Service Disabled successfully!" });
                            });
                        }
                        else {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUES('" + idaccount + "','" + iduser + "',NOW(),'31','DID provisioning DELETE failed to INTELLIQUENT','" + sdata.DID.trim() + "','','0','" + response.body + "')";
                            obj3.prepare();
                            obj3.execute((err4, resp4) => {
                                callback(0, { status: 501, message: "SMS Service Not Disabled successfully!" });
                            });
                        }
                    }
                    else {
                        callback(0, { status: 503, message: "SMS disabling Service not available!" });
                    }
                } catch (e) {
                    callback(0, { message: "Something Went Wrong with the server!", status: 502 });
                }
            } else {
                callback(0, { message: "Something Went Wrong with the service!", status: 502 });
            }
        });
    }
    getId() {
        return [2, 2, 2, 6].reduce((prev, len) => prev + '-' + crypto.randomBytes(len).toString('hex'), crypto.randomBytes(4).toString('hex'))
    }
    sendTFSMS(req: Request, res: Response, sessData: any, DIDData: any, callback: (err: any, data: any) => void) {
        let uuid: any = this.getId();
        let sdata = req.body;
        let did = sdata.FROM.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let iduser: any = sessData.type == 1 ? sdata.iduser : sessData.iduser;
        let idaccount: any = sessData.type == 1 ? sdata.idaccount : sessData.idaccount;
        let rate = new APIBase();
        rate.getTollfreeSMSRate(req, res, sessData.idtariff, "SMS", "toll_free", (err, message_rate) => {
            if (err == 1 && message_rate.length > 0) {

                let msgcount = Math.ceil((sdata.BODY.length) / 159);
                let cost = msgcount * (message_rate[0].MT_rates + DIDData.dLergDt.rates);
                let MT_rates: any = msgcount * message_rate[0].MT_rates;
                let MT_surcharge: any = msgcount * DIDData.dLergDt.rates;
                let msg_data = sdata.BODY;

                rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        var options = {
                            'method': 'POST',
                            'url': this.sendTFSMSUrl + '/publishMessages',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Bearer ' + this.sendSMSKey,
                            },
                            body: JSON.stringify({
                                "from": '1' + sdata.FROM.trim(),
                                "text": sdata.BODY,
                                "to": ["1" + sdata.TO.trim()]
                            })
                        };
                        request(options, function (error: any, response: any) {
                            if (!error) {
                                try {
                                    if (response) {
                                        let data = JSON.parse(response.body)
                                        if (data.success == true) {
                                            //let msg_data = sdata.BODY.replace(/"/g, '\\"').replace(/'/g, "\\'");
                                            // To update the wallet amount
                                            let objv = new ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + cost + " WHERE `idaccount`='" + idaccount + "'"
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                            });

                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`dlrs`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`is_billable`) VALUES('" + data.result.referenceId + "','" + sdata.TO.trim() + "','" + MT_rates + "','" + sdata.FROM.trim() + "','" + parseBody(msg_data) + "',1,'" + idaccount + "','" + iduser + "','toll_free','1','sucesss','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '"+cost+"', '"+msgcount+"','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + sessData.idapi + "','" + MT_surcharge + "','" + DIDData.dLergDt.idoperator + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',1)";
                                            obj0.prepare();
                                            obj0.execute((error: any, result: any) => {
                                                if(error == 1){
                                                    console.log("Message Send Successfully!");
                                                    callback(1, { status: 201, message: "SMS Submit Successfully", batch_id: data.result.referenceId })
                                                }
                                                else{
                                                    console.log("Message Send Successfully But Something Went Wrong With Insertion!");
                                                    callback(1, { status: 401, message: "Something went wrong!", batch_id: data.result.referenceId })
                                                }                                                
                                            });

                                            let obj1 = new ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`status`,`reason`,`detail`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + data.result.referenceId + "','1','" + data.status + "','" + data.reason + "','" + data.detail + "','" + data.result.referenceId + "','" + sdata.FROM.trim() + "','" + sdata.TO.trim() + "','" + parseBody(msg_data) + "')";
                                            obj1.prepare();
                                            obj1.execute((error: any, result: any) => {
                                                
                                            });
                                            
                                        }
                                        else {
                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`dlrs`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`) VALUES('"+uuid+"','" + sdata.TO.trim() + "','" + MT_rates + "','" + sdata.FROM.trim() + "','" + parseBody(msg_data) + "',2,'" + idaccount + "','" + iduser + "','toll_free','1','sucesss','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '"+cost+"', '"+msgcount+"','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + sessData.idapi + "','" + MT_surcharge + "','" + DIDData.dLergDt.idoperator + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "')";
                                            obj0.prepare();
                                            obj0.execute((error: any, result: any) => {
                                                console.log("Something Went Wrong!");
                                                callback(0, {status: 402, message: "SMS not Sent!" })
                                            });
                                           
                                        }
                                    }
                                    else {
                                        callback(0, { message: "SMS not Sent Successfully!", status: 507 })
                                    }

                                } 
                                catch (e) {
                                    callback(0, { message: "Something Went Wrong with the server!", status: 504 })
                                }
                            }
                            else {
                                callback(0, { message: "Something went wrong!", status: 502 })
                            }
                        });
                    }
                    else {
                        callback(0, { message: "Please add funds to your account or contact support.", status: 503 })
                    }
                });
            }
            else {
                callback(0, { status: 502, message: "MT Rates not Found!" })
            }
        });
    }

}