import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Res405 } from "../lib/view/405";
import { NumberRegistry } from "../include/numberRegistry";
import { SinchApi } from '../include/SinchSubmitNumber';
import { RawView } from "../lib/view/RawView";
import { SinchNumberRegistry } from "./sinchNumberRegistry";
const cron = require('node-cron');
let request = require('request');
const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
const devurl = 'http://osrdev-e1.netnumber.net:84/osr/v2/entries/';
const myip = "iplink";
const nnid = "104141";

export class OsrApi extends NumberRegistry {
    constructor(proirity: string, sessdata: any) {
        super(proirity, sessdata);
    }


    /**
     * To Add entry into OSR :: first method
     */
    public addNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let options = {
            'method': 'PUT',
            'url': produrl + "" + `${number1}`,
            'headers': {
                'Content-Type': 'application/json'
            },
            body: '{id:"' + myip + '", nnid: "' + nnid + '"}'
        };
        console.log("options", options);
        request(options, (error: any, response: any) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register' where `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (resp) {
                                if (sdata.CampaignId !== undefined) {
                                } else {
                                    let obj = new RawView(res);
                                    obj.prepare({ status: 201, message: "DID buy and SMS enabled successfully" });
                                    obj.execute();
                                }
                            }
                            return callback(err, '');
                        })
                    }
                }
                catch (e) {
                    callback(error, "");
                }
            } else {
                callback(error, "");
            }
        });
    }


    /**
     * To Update entry into OSR :: first method
     */
    public updateNumber(req: Request, res: Response, did_id: any, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        if (sdata.CampaignId != null && sdata.CampaignId != '') {
            let obj1 = new ModelRawQuery(req, res);
            obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND `iduser` = '" + this.sessdata.iduser + "' GROUP BY campaign_key";
            obj1.prepare();
            obj1.execute((error: any, camp_res: any) => {
                if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                    if (camp_res[0].did_count >= camp_res[0].did_limit) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 400,
                            message: "DID Buy Successfully but you can enable only [" + camp_res[0].did_limit + "] DID's in this Campaign.",
                            result: [
                                {
                                    "did": number
                                }
                            ]
                        });
                        objv.execute();
                    }
                    else {
                        let objh = new ModelRawQuery(req, res);
                        objh.qrysql = "SELECT did, camp_registry, sms_provider, provider,osr_status,sinch_status,type FROM did_buy WHERE iduser = '" + this.sessdata.iduser + "' AND did = '" + sdata.DID.trim() + "' GROUP BY did";
                        objh.prepare();
                        objh.execute((error: any, responce: any) => {
                            if (error == 1 && responce.length > 0) {
                                let category: any = responce[0].type == 'NN' || responce[0].type == 'INN' ? 'NN' : 'TF';
                                if (category == 'NN') {
                                    console.log("condition >>::::>> if osr_status == 'unregister' and sinch_status == '0'");
                                    let rate = new APIBase();
                                    rate.getMessageRate(req, res, this.sessdata.idtariff, "message_activation", category, (err, message_rate) => {
                                        if (err == 1) {
                                            let nrcMsgRate: any = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0,
                                                mrcMsgRate: any = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;
                                            let obj1 = new ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + this.sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + nrcMsgRate + "'"
                                            obj1.prepare();
                                            obj1.execute((walletError: any, wallet: any) => {
                                                if (walletError == 1 && wallet.length > 0) {
                                                    let obj0 = new ModelRawQuery(req, res);
                                                    obj0.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                                                    obj0.prepare();
                                                    obj0.execute((camperr: any, campres: any) => {
                                                        if (camperr == 1 && campres.length > 0) {
                                                            if (responce[0].provider == "inteliQ" || responce[0].provider == "thinQ" || responce[0].provider == "Peerless" || responce[0].provider == 'Importnumber') {
                                                                let did = sdata.DID;
                                                                let len = did.length - 10;
                                                                let number = did.slice(len, did.length);
                                                                let number1 = "+1" + number;
                                                                let options = {
                                                                    'method': 'PUT',
                                                                    'url': produrl + "" + `${number1}`,
                                                                    'headers': {
                                                                        'Content-Type': 'application/json'
                                                                    },
                                                                    body: '{ id: "' + campres[0].myip + '", nnid:"' + campres[0].nnid + '" , "context": "A2P", "campaign_id": "' + sdata.CampaignId + '" }'
                                                                };
                                                                request(options, (error: any, response: any) => {
                                                                    if (!error) {
                                                                        try {
                                                                            let data = JSON.parse(response.body);
                                                                            let __tn: any = typeof data.tn != 'undefined' ? data.tn : ''
                                                                            let __message: any = typeof data.message != 'undefined' ? data.message : ''
                                                                            let __campaign_id: any = typeof data.campaign_id != 'undefined' ? data.campaign_id : ''
                                                                            let rDt: any = {
                                                                                tn: __tn,
                                                                                message: __message,
                                                                                campaign_id: __campaign_id
                                                                            }
                                                                            if (data.message == "Success") {
                                                                                if (nrcMsgRate > 0) {
                                                                                    // To deduct SMS Enable charges
                                                                                    let objv = new ModelRawNonQuery(req, res);
                                                                                    objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + nrcMsgRate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                                                    objv.prepare();
                                                                                    objv.execute((wallet_error, wallet_success) => {
                                                                                        if (wallet_error == 1) {
                                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                                            objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + this.sessdata.idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount successfully updated for EnableSMS', `status`=1"
                                                                                            objWL.prepare()
                                                                                            objWL.execute((error: any, result: any) => {
                                                                                                console.log("Wallet amount successfully updated for EnableSMS :: ", nrcMsgRate);
                                                                                            });
                                                                                        }
                                                                                        else {
                                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                                            objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + this.sessdata.idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount not updated for EnableSMS', `status`=2"
                                                                                            objWL.prepare()
                                                                                            objWL.execute((error: any, result: any) => {
                                                                                                console.log("Wallet amount not updated for EnableSMS :: ", nrcMsgRate);
                                                                                            });
                                                                                        }
                                                                                    });

                                                                                    // To Insert nrc
                                                                                    let obj4 = new ModelRawNonQuery(req, res);
                                                                                    obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + number + "','" + nrcMsgRate + "')";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((osr_err, resp) => {
                                                                                        console.log("SMS Enabled Charges Log Inserted :: ", nrcMsgRate);
                                                                                    });
                                                                                }

                                                                                let obj2 = new ModelRawNonQuery(req, res);
                                                                                obj2.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` + 1  WHERE `iduser` = '" + this.sessdata.iduser + "' AND `campaign_key` = '" + sdata.CampaignId + "'";
                                                                                obj2.prepare();
                                                                                obj2.execute((osr_errrr, resppp) => {
                                                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                                                    obj3.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "', `sms_mrc`='" + mrcMsgRate + "' WHERE `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                                                                                    obj3.prepare();
                                                                                    obj3.execute((osr_err, resp) => {
                                                                                        if (osr_err == 1) {
                                                                                            if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                let sinch = new SinchApi('', this.sessdata);
                                                                                                sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                                                    if (errorr == 1) {
                                                                                                        let objv = new RawView(res);
                                                                                                        objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                        objv.execute();
                                                                                                    }
                                                                                                    else {
                                                                                                        let objv = new RawView(res);
                                                                                                        objv.prepare({
                                                                                                            status: 400,
                                                                                                            message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                            result: [
                                                                                                                {
                                                                                                                    "did": number
                                                                                                                }
                                                                                                            ],
                                                                                                            error: "DID not submitted to SINCH!"
                                                                                                        });
                                                                                                        objv.execute();
                                                                                                    }
                                                                                                });
                                                                                            }
                                                                                            else {
                                                                                                let sinch = new SinchApi('', this.sessdata);
                                                                                                sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                                                    if (errorr == 1) {
                                                                                                        let objv = new RawView(res);
                                                                                                        objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                        objv.execute();
                                                                                                    }
                                                                                                    else {
                                                                                                        let objv = new RawView(res);
                                                                                                        objv.prepare({
                                                                                                            status: 400,
                                                                                                            message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                            result: [
                                                                                                                {
                                                                                                                    "did": number
                                                                                                                }
                                                                                                            ],
                                                                                                            error: "DID not submitted to SYNIVERSE!"
                                                                                                        });
                                                                                                        objv.execute();
                                                                                                    }
                                                                                                });
                                                                                            }
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView(res);
                                                                                            objv.prepare({
                                                                                                status: 400,
                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                result: [
                                                                                                    {
                                                                                                        "did": number
                                                                                                    }
                                                                                                ],
                                                                                                error: "Something went wrong with updation!"
                                                                                            });
                                                                                            objv.execute();
                                                                                        }
                                                                                        let obj6 = new ModelRawNonQuery(req, res);
                                                                                        obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'6','DID provisioned to OSR','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                        obj6.prepare();
                                                                                        obj6.execute((er, ins_result) => {
                                                                                            console.log("DID Log Inserted.");
                                                                                        });
                                                                                    });
                                                                                });
                                                                            }
                                                                            else {
                                                                                console.log("condition >>::::>> if osr_status == 'unregister' and need to enable from sinch");
                                                                                let obj8 = new ModelRawNonQuery(req, res);
                                                                                obj8.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "' WHERE `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                                                                                obj8.prepare();
                                                                                obj8.execute((osr_failed, resp) => {
                                                                                    if (osr_failed == 1) {
                                                                                        if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                            let sinch = new SinchApi('', this.sessdata);
                                                                                            sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                                                if (errorr == 1) {
                                                                                                    let objv = new RawView(res);
                                                                                                    objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                    objv.execute();
                                                                                                }
                                                                                                else {
                                                                                                    let objv = new RawView(res);
                                                                                                    objv.prepare({
                                                                                                        status: 400, message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                        result: [
                                                                                                            {
                                                                                                                "did": number
                                                                                                            }
                                                                                                        ],
                                                                                                        error: "DID not submitted to SINCH!"
                                                                                                    });
                                                                                                    objv.execute();
                                                                                                }
                                                                                            });
                                                                                        }
                                                                                        else {
                                                                                            let sinch = new SinchApi('', this.sessdata);
                                                                                            sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                                                if (errorr == 1) {
                                                                                                    let objv = new RawView(res);
                                                                                                    objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                    objv.execute();
                                                                                                }
                                                                                                else {
                                                                                                    let objv = new RawView(res);
                                                                                                    objv.prepare({
                                                                                                        status: 400,
                                                                                                        message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                        result: [
                                                                                                            {
                                                                                                                "did": number
                                                                                                            }
                                                                                                        ],
                                                                                                        error: "DID not submitted to SYNIVERSE!"
                                                                                                    });
                                                                                                    objv.execute();
                                                                                                }
                                                                                            });
                                                                                        }
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({
                                                                                            status: 400,
                                                                                            message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                            result: [
                                                                                                {
                                                                                                    "did": number
                                                                                                }
                                                                                            ],
                                                                                            error: "Something went wrong with updation!"
                                                                                        });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                                let obj7 = new ModelRawNonQuery(req, res);
                                                                                obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'12','OSR provisioning failed','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                obj7.prepare();
                                                                                obj7.execute((er, ins_result) => {
                                                                                    console.log("DID Log Inserted.");
                                                                                });
                                                                            }
                                                                        }
                                                                        catch (e) {
                                                                            let obj = new RawView(res);
                                                                            obj.prepare({
                                                                                error_code: 0, status: 502,
                                                                                message: "DID Buy Successfully but Something went wrong!",
                                                                                result: [
                                                                                    {
                                                                                        "did": number
                                                                                    }
                                                                                ],
                                                                                error: "Something went wrong!"
                                                                            });
                                                                            obj.execute();
                                                                        }
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({
                                                                            status: 400,
                                                                            message: "DID buy successfully but SMS enabled Failed",
                                                                            result: [
                                                                                {
                                                                                    "did": number
                                                                                }
                                                                            ],
                                                                            error: "DID not submission failed to OSR!"
                                                                        });
                                                                        objv.execute()
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    status: 404,
                                                                    message: "DID Buy Successfully but SMS enabled Failed",
                                                                    result: [
                                                                        {
                                                                            "did": number
                                                                        }
                                                                    ],
                                                                    error: "Provider not found!"
                                                                });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({
                                                                status: 404,
                                                                message: "DID buy successfully but SMS enabled Failed",
                                                                result: [
                                                                    {
                                                                        "did": number
                                                                    }
                                                                ],
                                                                error: "SMS provider not found!"
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        status: 404,
                                                        message: "DID buy successfully but SMS enabled Failed",
                                                        result: [
                                                            {
                                                                "did": number
                                                            }
                                                        ],
                                                        error: "Amount is not enough!"
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                status: 400,
                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                result: [
                                                    {
                                                        "did": number
                                                    }
                                                ],
                                                error: "Rates Setting Invalid!"
                                            });
                                            objv.execute();
                                        }
                                    });

                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 400,
                                        message: "DID Buy Successfully but SMS enabled Failed!",
                                        result: [
                                            {
                                                "did": number
                                            }
                                        ],
                                        error: "Service not available!"
                                    });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 404,
                                    message: "DID Buy Successfully but This Campaign is not approved yet.Please try with another one!",
                                    result: [
                                        {
                                            "did": number
                                        }
                                    ],
                                    error: "DID Not Found for enable SMS"
                                });
                                objv.execute();
                            }
                        });
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({
                        status: 404,
                        message: "DID Buy Successfully but This Campaign is not approved yet.Please try with another one!",
                        result: [
                            {
                                "did": number
                            }
                        ],
                        error: "Campaign is not available or not approved!"
                    });
                    objv.execute();
                }
            });
        }
        else {
            let obj = new RawView(res);
            obj.prepare({
                error_code: 1,
                status: 400,
                message: "DID Buy Successfully but SMS enabled Failed!",
                result: [
                    {
                        "did": number
                    }
                ],
                error: "Campaign Not found!"
            });
            obj.execute()
        }
    }


    /**
     * To Update entry with toll-free provisioning into OSR :: first method
     */
    public updateNumberWithTollfree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let options = {
            'method': 'PUT',
            'url': 'https://208.254.45.98/osr/v2/entries/1800551212',
            'headers': {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ "id": "mypid", "nnid": "123456", "context": "A2P", "ownertspid": "3434" })
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                try {
                    let ddata = JSON.parse(response.body);
                    if (ddata.rows.length > 0) {
                    } else {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.prepare();
                        obj.execute((err, data) => {
                            callback(err, data);
                        });
                    }
                }
                catch (e) {
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            } else {
                let obj = new ModelRawNonQuery(req, res);
                obj.prepare();
                obj.execute((err, data) => {
                    callback(err, data);
                });
            }
        });
    }


    /**
     * To Delete entry from OSR And Then SINCH :: first method
     */
    public deleteNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.query;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let iduser: any = '';
        if (sdata.iduser) {
            iduser = sdata.iduser;
        } else {
            iduser = this.sessdata.iduser;
        }
        let obj0 = new ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `iduser` = '" + iduser + "'";
        obj0.prepare();
        obj0.execute((err: any, result_did: any) => {
            if (err == 1 && result_did.length > 0) {
                let obj00 = new ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name,upstreamCnpId FROM `campaign` WHERE `iduser`='" + iduser + "' AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
                obj00.prepare();
                obj00.execute((err: any, result_camp: any) => {
                    if (err == 1 && result_camp.length > 0) {
                        /* let obj00 = new ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT `iddidlog` FROM did_log WHERE `did`= '" + sdata.DID.trim() + "' AND `iduser` = '" + iduser + "' ORDER BY `iddidlog` DESC";
                        obj00.prepare();
                        obj00.execute((log_error: any, log_res: any) => {
                            if (log_error == 1 && log_res.length > 0) { */
                        let objk = new ModelRawQuery(req, res);
                        objk.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + result_camp[0].upstreamCnpId + "'";
                        objk.prepare();
                        objk.execute((camperr: any, campres: any) => {
                            if (camperr == 1 && campres.length > 0) {
                                let options = {
                                    'method': 'DELETE',
                                    'url': produrl + "" + `${number1}`,
                                    'headers': {
                                        'Content-Type': 'application/json'
                                    },
                                    body: '{id:"' + campres[0].myip + '", nnid: "' + campres[0].nnid + '"}'
                                };
                                request(options, (error: any, response: any) => {
                                    if (!error) {
                                        try {
                                            let data = JSON.parse(response.body);
                                            if (data.message == "Success") {
                                                //Counting Decrease (-1) and status update
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` - 1 WHERE `iduser` = '" + iduser + "' AND campaign_key = '" + result_camp[0].campaign_key + "'";
                                                obj1.prepare();
                                                obj1.execute((err, updt_didby) => {

                                                    let obj2 = new ModelRawNonQuery(req, res);
                                                    obj2.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0 WHERE `iduser` = '" + iduser + "' AND `did`='" + number + "'";
                                                    obj2.prepare();
                                                    obj2.execute((uperr, updt_stts) => {

                                                        // here in this query we are using session iduser and id account for the understanding who is performed this action.
                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'10','DID disconnect From OSR','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                        obj4.prepare();
                                                        obj4.execute((er, ins_result) => {
                                                            console.log("SMS Disabled Successfully From OSR");
                                                        });
                                                        /* let obj3 = new ModelRawNonQuery(req, res);
                                                        obj3.nonqrysql = "INSERT INTO `campaign_history`(`iduser`,`idaccount`,`did`,`campaign_key`,`campaign_name`,`in_use`,`iddidlog`) VALUES ('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + number + "','" + result_camp[0].campaign_key + "','" + result_camp[0].campaign_name + "', '1','" + log_res[0].iddidlog + "')";
                                                        obj3.prepare();
                                                        obj3.execute((err, ins_res) => {
                                                            if (err == 1) { */
                                                        if (result_camp[0].upstreamCnpId == 'SINCH') {
                                                            // Delete from sinch
                                                            let sinch = new SinchApi('', this.sessdata);
                                                            sinch.deleteNumber(req, res, result_camp, (errorr, resp) => {
                                                                if (!errorr) {
                                                                    let obj5 = new RawView(res);
                                                                    obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled.", result: resp });
                                                                    obj5.execute();
                                                                }
                                                                else {
                                                                    let obj = new RawView(res);
                                                                    obj.prepare({ status: 400, message: "SMS Disabled failed.please try again." });
                                                                    obj.execute()
                                                                }
                                                            });
                                                        } else {
                                                            //  Delete from syniverse
                                                            let sinch = new SinchApi('', this.sessdata);
                                                            sinch.deleteNumberfromSyniverse(req, res, result_camp, (errorr, resp) => {
                                                                if (errorr == 1) {
                                                                    let obj5 = new RawView(res);
                                                                    obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled." });
                                                                    obj5.execute();
                                                                }
                                                                else {
                                                                    let obj = new RawView(res);
                                                                    obj.prepare({ status: resp.message, message: resp.message });
                                                                    obj.execute()
                                                                }
                                                            });
                                                        }
                                                        /* } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: 'Data Not Updated Successfully!' });
                                                            objv.execute();
                                                        }
                                                    }); */
                                                    });
                                                });
                                            } else {
                                                let obj6 = new ModelRawNonQuery(req, res);
                                                obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnect failed from OSR','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                obj6.prepare();
                                                obj6.execute((er, ins_result) => {
                                                    console.log("SMS in not Disabled From OSR");
                                                });
                                                let obj = new RawView(res);
                                                obj.prepare({ status: data.response_code, message: data.message, result: data });
                                                obj.execute()
                                            }
                                        }
                                        catch (e) {
                                            let obj = new RawView(res);
                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                            obj.execute();
                                        }

                                    } else {
                                        let obj = new RawView(res);
                                        obj.prepare({ status: 400, error: error });
                                        obj.execute()
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                objv.execute();
                            }
                        });
                        /* }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: `ID DID not found on this DID!` });
                            objv.execute();
                        }
                    }); */
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 404, message: 'Cannot find ImportedNumber' });
                        objv.execute()
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: 'DID Not Available!' });
                objv.execute()
            }

        });
    }

    /**
     * To retrieve entry from OSR :: first method
     */
    public retrieveOsrEntry(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.query;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "1" + number;
        let options = {
            'method': 'GET',
            'url': produrl + "" + number1 + "?id=" + myip,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        console.log("options", options);
        request(options, (error: any, response: any) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {
                        let obj = new RawView(res);
                        obj.prepare({ status: 200, message: "OSR Details Find Successfully", result: data });
                        obj.execute();
                    } else {
                        let obj = new RawView(res);
                        obj.prepare({ status: data.response_code, message: data.message, result: data });
                        obj.execute();
                    }
                }
                catch (e) {
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            } else {
                let obj = new RawView(res);
                obj.prepare({ status: 400, result: error });
                obj.execute()
            }
        });
    }


    /**
     * To retrieve notification from OSR :: first method
     */
    public retrieveOsrNotifications(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.query;
        let options = {
            'method': 'GET',
            'url': "http://65.214.42.91:84/osr/v2/notifications?id=" + myip + "&tid=" + sdata.TID,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        console.log("options", options);
        request(options, (error: any, response: any) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    console.log("Data", data);
                    let obj = new RawView(res);
                    obj.prepare({ status: 200, message: "OSR Details Find Successfully", result: data });
                    obj.execute()
                }
                catch (e) {
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }

            } else {
                let obj = new RawView(res);
                obj.prepare({ status: 400, result: error });
                obj.execute()
            }
        });
    }


    /**
     * To Delete entry from OSR :: second method
     */
    public deleteNumberM2(req: Request, res: Response, payLoad: any, callback: (err: any, data: any) => void) {
        let did = payLoad.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let options = {
            'method': 'DELETE',
            'url': produrl + "" + `${number1}`,
            'headers': {
                'Content-Type': 'application/json'
            },
            body: '{id:"' + myip + '", nnid: "' + nnid + '"}'
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {

                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `iduser` = '" + this.sessdata.iduser + "'";
                        obj0.prepare();
                        obj0.execute((_err: any, result_did: any) => {
                            if (_err == 1 && result_did.length > 0) {
                                let obj00 = new ModelRawQuery(req, res);
                                obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name FROM `campaign` WHERE `iduser`='" + this.sessdata.iduser + "' AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
                                obj00.prepare();
                                obj00.execute((__err: any, result_camp: any) => {
                                    if (__err == 1 && result_camp.length > 0) {
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `campaign` SET did_count=`did_count` - 1 WHERE `iduser` = '" + this.sessdata.iduser + "' AND campaign_key = '" + result_camp[0].campaign_key + "'";
                                        obj1.prepare();
                                        obj1.execute((___err, updt_didby) => {
                                            if (___err == 1) {
                                                console.log("Counting Not Updated!");
                                            }
                                            else {
                                                console.log("Counting Updated.");
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Campaign Data Not Found.");
                                    }
                                });
                            }
                            else {
                                console.log("Campaign Registry Not Found.");
                            }
                        });

                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `osr_status`='unregister', `disconnect_did_status`='4', `sms_provider` = '', `camp_registry` = '' WHERE `iduser`='" + this.sessdata.iduser + "' AND `did`='" + number + "';";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (err == 1) {
                                callback(1, resp)
                            }
                            else {
                                callback(0, err)
                            }
                        })
                    }
                    else {
                        callback(0, data)
                    }
                }
                catch (e) {
                    callback(0, error)
                }
            }
            else {
                callback(0, error)
            }
        });
    }

}