import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Number } from "./numberApi";
import { RawView } from "../lib/view/RawView";
var request = require('request');

export class TeleAPI extends APIBase {
    private key: string;
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey : string

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        this.key = "48de6c84-7726-4879-bc08-f7a5dcf63f1c";
        this.timekey=timekey,
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }

    public getNpaNxx(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            callback('','');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                            var options = {
                                'method': 'POST',
                                'url': 'https://apiv1.teleapi.net/dids/list?token=' + this.key + '&npa=' + `${sdata.NPA}` + '&limit=' + `${sdata.Qty}`,
                                'headers': {
                                    'Content-Type': 'application/json'
                                }
                            };
                            request(options, (error: any, response: any) => {
                                if (!error ) {
                                    try{
                                        let ddata = JSON.parse(response.body);
                                        if (ddata.code == 200) {
                                            if (ddata.data.dids != undefined && ddata.data.dids.length > 0) {
                                                let str = ddata.data.dids;
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE";
                                                str.forEach((ele: any) => {
                                                    qrystr += "('','" + ele.number + "', '', '', '" + ele.ratecenter + "', '" + ele.state + "', '', '','', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.tier + "','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','"+this.sessdata.idapi+"','"+this.timekey+"'),";
                                                });
                                                obj1.nonqrysql = qrystr.slice(0, -1);
                                                obj1.prepare();
                                                obj1.execute((err, data) => {
                                                    callback(err, data);
                                                });
                                            } else {
                                                let obj = new RawView(res);
                                                obj.prepare({message:"No DID's found on ["+sdata.NPA+"]"});
                                                obj.execute();
                                            }
                                        } else {
                                            callback('', ddata);
                                        }
                                    }
                                    catch(e){
                                        callback(error, '');
                                    }
                                   
                                } else {
                                    callback(error, '');
                                }
                            });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('','');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    var options = {
                        'method': 'POST',
                        'url': 'https://apiv1.teleapi.net/dids/list?token=' + this.key + '&state=' + `${sdata.State}` + '&ratecenter=' + `${sdata.RateCenter}` + '&limit=' + `${sdata.Qty}`,
                        'headers': {
                            'Content-Type': 'application/json'
                        }
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                let ddata = JSON.parse(response.body);
                                console.log("ddata", JSON.stringify(ddata));
                                if (ddata.code == 200) {
                                    if (ddata.data.dids != undefined && ddata.data.dids.length > 0) {
                                        let str = ddata.data.dids;
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE";
                                        str.forEach((ele: any) => {
                                            qrystr += "('','" + ele.number + "', '', '', '" + ele.ratecenter + "', '" + ele.state + "', '', '','', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.tier + "','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','"+this.sessdata.idapi+"','"+this.timekey+"'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    } else {
                                        callback('', ddata);
                                    }
                                } else {
                                    callback('', ddata);
                                }
                            }
                            catch(e){
                                callback(error, '');
                            }
                          
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('','');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'POST',
                        'url': 'https://apiv1.teleapi.net/dids/list?token=' + this.key + '&type=tollfree&limit=' + `${sdata.Qty}`,
                        'headers': {
                            'Content-Type': 'application/json'
                        }
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                let ddata = JSON.parse(response.body);
                                console.log("ddata", ddata);
                                console.log(ddata.code);
                                if (ddata.code == 200) {
                                    if (ddata.data.dids != undefined && ddata.data.dids.length > 0) {
                                        let str = ddata.data.dids;
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`path`,`idapi`,`key`) VALUE";
                                        str.forEach((ele: any) => {
                                            qrystr += "('','" + ele.number + "', '', '', '', '', '', '','', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','TF','','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + voice_rate[0].rate + "','" + this.sessdata.path + "','"+this.sessdata.idapi+"','"+this.timekey+"'),";
                                        });
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    } else {
                                        callback('', ddata);
                                    }
                                } else {
                                    callback('', ddata);
                                }
                            }
                            catch(e){
                                callback(error, '');
                            }
                            
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let types: any;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let id_grouporder: number = other_data.id_grouporder;

        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''

            // To get the proration status
            let objv0 = new ModelRawQuery(req, res);
            objv0.qrysql = "SELECT t.`proration`,t.`day_num` FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let proration_status = proration_success[0].proration;
                    let did_dis_days = proration_success[0].day_num > 0 ? proration_success[0].day_num : 0;
                    types = did_details[0].type == 'TF' ? 'TF' : 'NN';
                    var options = {
                        'method': 'POST',
                        'url': 'https://apiv1.teleapi.net/dids/order?token=' + this.key + '&number=' + `${sdata.DID.trim()}`,
                        'headers': {
                            'Content-Type': 'application/json'
                        }
                    }
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                console.log("TeleAPI::", response.body)
                                let sdata1 = JSON.parse(response.body);
                                // If order successfully placed
                                if (sdata1.code == 200 && sdata1.status == 'success') {
                                    let providerOrderId: any = typeof sdata1.data.id != 'undefined' && sdata1.data.id ? sdata1.data.id : ''
    
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`npa`,`nxx`,`ratecenter`,`state`,`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`sms_provider`,`did_disconnect_days`,`nrc_rates`) VALUE('" + npa + "','" + nxx + "','" + ratecenter + "','" + state + "','" + this.sessdata.idaccount + "','" + sdata1.data.user_id + "','completed','" + sdata1.data.number + "','teleapi','" + sdata1.data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "','teleapi','"+did_dis_days+"','"+ did_details[0].rates +"')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
    
                                             // update end subscription date
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql  ="SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='"+data.insertId+"' AND disconnect_did_status = '1'";
                                            obj0.prepare();
                                            obj0.execute((dids_err, didRes) => {
                                               let dates=didRes[0].subscription_end_date;
                                               let isoDate = new Date(dates);
                                               let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                               let obj01 = new ModelRawNonQuery(req, res);
                                               obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" +subscriptionEndDate+ "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                               obj01.prepare();
                                               obj01.execute((error, result) => { })
                                            })
                                            
                                            let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
    
                                            let nDate: any = new Date()
                                            let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                            let totalDays = (lDate - day) + 1;
    
                                            let prorate: any;
                                            if (proration_status == "true") {
                                                prorate = (totalDays * did_details[0].rates) / lDate;
                                            }
                                            else {
                                                prorate = did_details[0].rates;
                                            }
    
                                            console.log(prorate);
                                            let objv = new ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
    
                                                // To update the wallet transaction log
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                iQry += "`amount`='-" + prorate + "', "
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                iQry += "`status`=1;"
    
                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    console.log("Transaction response::", result)
                                                })
    
                                                // To create the DID log
                                                let objv1 = new ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata1.data.number + "','teleapi','" + sdata1.data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "','1','DID Buy')"
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });
    
                                                // To delete the DID from cart
                                                let obj5 = new ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                obj5.prepare();
                                                obj5.execute((walletError: any, wallet: any) => { });
    
                                                // To update the process count of group order
                                                let objk = new ModelRawNonQuery(req, res)
                                                objk.nonqrysql = "UPDATE `did_group_order` SET `process_dids`=`process_dids`+ 1 WHERE `id_grouporder`=" + id_grouporder + ";"
                                                objk.prepare()
                                                objk.execute((error, result) => {
                                                    console.log("GroupOrder process count::\n", result)
                                                })
    
                                                // To create the did_order
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201','" + sdata.DID + "', '2', '" + types + "', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order: number = did_data.insertId
                                                        let orderID: string = "SORD" + id_order.toString()
    
                                                        let log_error: string = ""
                                                        let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                        let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
    
                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='teleapi', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                                        obj.prepare();
                                                        obj.execute((error, result) => { })
                                                    }
    
                                                    let objV = new RawView(res);
                                                    objV.prepare({
                                                        error_code: 1,
                                                        status: 201,
                                                        message: "DID buy successfully.",
                                                        result: [
                                                            {
                                                                "did": sdata.DID
                                                            }
                                                        ]
                                                    });
                                                    objV.execute()
                                                });
                                            });
                                        }
                                        else {
                                            let obj = new RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection"
                                            });
                                            obj.execute()
                                        }
                                    });
                                }
    
                                // If order failed
                                else {
                                    let providerOrderId: any = typeof sdata1.data.id != 'undefined' && sdata1.data.id ? sdata1.data.id : ''
    
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', '" + types + "', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order: number = did_data.insertId
                                            let orderID: string = "SORD" + id_order.toString()
    
                                            let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_message: string = sdata1.data.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_result: string = ""
    
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='teleapi', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                            obj.prepare();
                                            obj.execute((error, result) => { })
                                        }
    
                                        let objV = new RawView(res);
                                        objV.prepare({
                                            error_code: 0,
                                            status: sdata1.code,
                                            message: sdata1.data,
                                            error: sdata1
                                        });
                                        objV.execute()
                                    });
                                }
                            }
                            catch(e){
                                let obj = new RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 400,
                                    error: error
                                });
                                obj.execute()
                            }                       
                        }
                        else {
                            let obj = new RawView(res);
                            obj.prepare({
                                error_code: 0,
                                status: 400,
                                error: error
                            });
                            obj.execute()
                        }
                    });

                }
                else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }

    disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let iduser: number = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let obj5 = new ModelRawQuery(req, res);
        obj5.qrysql = "SELECT `type` from `did_buy` WHERE `iduser`='" + iduser + "' AND `did`='" + sdata.DID.trim() + "'";
        obj5.prepare();
        obj5.execute((err: any, ress: any) => {
            if (err == 1 && ress.length > 0) {
                var options = {
                    'url': 'https://apiv1.teleapi.net/user/dids/remove?token=' + this.key + '&number=' + `${sdata.DID.trim()}`,
                    'headers': {
                        'Content-Type': 'application/json'
                    }
                };
                request(options, (error: any, response: any) => {
                    console.log("TeleAPI Err::", error)
                    if (!error) {
                        try{
                            console.log("TeleAPI Res::", response.body)
                            let data = JSON.parse(response.body);
                            if (data.code == 200) {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                obj.prepare();
                                obj.execute((error: any, resp: any) => {
                                    if (error == 1) {
                                        // To  update updated_at date in did log
                                        let obj = new ModelRawQuery(req, res);
                                        // obj.qrysql = "UPDATE `did_log` SET `updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                        obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`disconnect_did_status`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "','3')"
                                        obj.prepare();
                                        obj.execute((errorDiDLg: any, resDiDLg: any) => {});
                                        
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: data.code, message: data.status, error: data.data });
                                objv.execute();
                            }
                        }
                        catch(e){
                            let objv = new RawView(res);
                            objv.prepare({ status: 400, error: error, message : "DID not Disconnected!" });
                            objv.execute();
                        } 
                    }
                    else {
                        console.log("TeleApi :::::::::::::::::::");
                        let objv = new RawView(res);
                        objv.prepare({ status: 400, error: error, message : "DID not Disconnected!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                objv.execute();
            }
        });             
    }

}