import { SMS } from "./APISMSBase";
import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { Number } from "./numberApi";
import { Res406 } from "../lib/view/406";
import { LergApi } from "./lrnApi";
import { APIBase } from "./APIBase";
import { InteliquentAPI } from "./Inteliquent";

export class TeleSMS extends SMS {

    constructor() {
        super();
        this.key = "48de6c84-7726-4879-bc08-f7a5dcf63f1c";
        this.account = "";
    }

    public SendSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let lergData: any = Data.lergData       
        // To set the data for final SMS
        this.saveSMS(req, res, next, sessdata, lergData, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }
    // Not in Use. it may be changed as per requirement
    public SendTFSms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id});
            objv.execute();
        });
    }

    public SendMms(req: Request, res: Response, next: NextFunction, token: string,sms_provider: string, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let number = new Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    } else {
                        let PayLoad: any = {
                            TO: TO
                        }
                        let lerg = new LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                if (lerg_info.length > 0) {
                                    this.saveSMS(req, res, next, sessdata, lerg_info,sms_provider, (sms_err, sms_result) => {
                                        if (sms_result != undefined) {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_result);
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_err);
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({message:"Lerg Info Not Found"});
                                    objv.execute();
                                }
                            })
                        })

                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public SendSynivMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let lergData: any = Data.lergData
        let didData: any = Data.DIDdata
        let fType: any = Data.fileType
        let file: any = Data.file
        let file_path: any = Data.file_path
        this.saveSynivMMS(req, res, next, sessdata, lergData, sms_provider, didData, fType, file, file_path, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }
    
    public SendSms_Old(req: Request, res: Response, next: NextFunction, token: string,sms_provider: string, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        var TO = "" + sdata.TO + "";
        console.log("To",TO);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let number = new Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    } else {
                        let lerg = new LergApi("", "");
                        lerg.lrnDetails(req, res,token, (lrn_err, lrn_detail) => {
                            console.log("lrn_detail",lrn_detail);
                            if ( lrn_detail.hasOwnProperty('errors')) {
                                if(lrn_detail.errors[0] == "LRN Not Found.")
                                console.log("To===>",TO);
                                this.getLrnDetails(req,res,TO, (lerg_err, lerg_info) => {
                                    console.log("lerg_info",lerg_info);
                                    if (lerg_info.data.length > 0) {
                                        this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider,(sms_err, sms_result) => {
                                            if (sms_result != undefined) {
                                                let objv = new RawView(res);
                                                objv.prepare(sms_result);
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare(sms_err);
                                                objv.execute();
                                            }
                                        })
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({message:"Lerg Info Not Found"});
                                        objv.execute();
                                    }
                                })
                            } else {
                                this.getLrnDetails(req,res,lrn_detail.lnp, (lerg_err, lerg_info) => {
                                    if (lerg_info.data.length > 0) {
                                        this.saveSMS(req, res, next, sessdata, lerg_info.data,sms_provider, (sms_err, sms_result) => {
                                            if (sms_result != undefined) {
                                                let objv = new RawView(res);
                                                objv.prepare(sms_result);
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare(sms_err);
                                                objv.execute();
                                            }
                                        })
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({message:"Lerg Info Not Found"});
                                        objv.execute();
                                    }
                                })
                            }
                        });
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}