import e, { Request, Response, NextFunction, response } from "express";
import { APIBase } from "./APIBase";
import { SessionManagment } from "../lib/model/Session";
import { AppRoute } from "../lib/AppRoute";
import { Res406 } from "../lib/view/406";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelCsvUpload } from "../lib/model/ModelCsvUpload";
import { UploadDirectory,LinkVerify } from "./../config/setting.config";
import { Res405 } from "../lib/view/405";
import { parseBody } from "./markError";
import { error } from "console";
let URLlink = new LinkVerify();

const fs = require('fs');
const path = require('path');

export class CommonClass extends AppRoute {
	constructor() {
		super();
	}

	/**
	 * To filter the CDR report
	 */
	getCdrFilter(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let qdata: any = req.query.type;
				var sdata = JSON.parse(qdata);

				// let idaccount: number = typeof sdata.iduser != 'undefined' ? sdata.iduser : 0
				
				let idact: string = typeof sdata.iduser != 'undefined' && sdata.iduser ? sdata.iduser : '0';
				let idaccount = idact ? idact.split('-')[0] : '';

				let iQry: string = "",
					iQN1: number = 0,
					iQN: number = 0,
					cond: string = ""
				// iQry = "SELECT san,cost, dialed_number, caller_id_number, direction, duration, billsec, hangup_cause, progress_mediamsec, CONVERT_TZ(start_stamp, '" + sessdata.server_time + "', '" + sessdata.client_time + "') start_stamp, CONVERT_TZ(answer_stamp, '" + sessdata.server_time + "', '" + sessdata.client_time + "') answer_stamp, CONVERT_TZ(end_stamp, '" + sessdata.server_time + "', '" + sessdata.client_time + "') end_stamp, CONVERT_TZ(progress_media_stamp, '" + sessdata.server_time + "', '" + sessdata.client_time + "') progress_media_stamp FROM `cdr` \n"
				iQry = "SELECT san,cost, dialed_number, caller_id_number, direction, duration, billsec, hangup_cause, progress_mediamsec, start_stamp, answer_stamp, end_stamp, progress_media_stamp FROM `cdr` \n"
				if (sessdata.type == 1) {
					if (idaccount) {
						iQry += "WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount=(SELECT idaccount FROM `user` WHERE iduser='" + idaccount + "')) "
						iQN1++
					}
				}
				else if (sessdata.type == 2) {
					iQry += "WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount=(SELECT idaccount FROM `user` WHERE iduser='" + sessdata.iduser + "'))"
					iQN1++
				}
				else if (sessdata.type == 22) {
					iQry += "WHERE iduser=" + sessdata.iduser + " "
					iQN1++
				}

				/**
				 * Other parameters
				 */
				if (sdata.from_date != undefined && sdata.from_date && !sdata.to_date) {
					// cond += "AND start_stamp>=CONVERT_TZ('" + sdata.from_date + " 00:00:00', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND DATE_FORMAT(start_stamp, '%Y-%m-%d')>='" + sdata.from_date + "' "
					iQN++
				}


				if (sdata.to_date != undefined && sdata.to_date && !sdata.from_date) {
					// cond += "AND start_stamp<=CONVERT_TZ('" + sdata.to_date + " 23:59:59', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND DATE_FORMAT(start_stamp, '%Y-%m-%d')<='" + sdata.to_date + "' "
					iQN++
				}

				if (sdata.from_date && sdata.to_date) {
					// cond += "AND start_stamp>=CONVERT_TZ('" + sdata.from_date + " 00:00:00', '" + sessdata.client_time + "', '" + sessdata.server_time + "') AND start_stamp<=CONVERT_TZ('" + sdata.to_date + " 23:59:59', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND DATE_FORMAT(start_stamp, '%Y-%m-%d')>='" + sdata.from_date + "' AND DATE_FORMAT(start_stamp, '%Y-%m-%d')<='" + sdata.to_date + "' "

					iQN++
				}

				if (sdata.from_number != undefined && sdata.from_number) {
					cond += "AND caller_id_number LIKE '%" + sdata.from_number + "' ";
					iQN++;
				}
				if (sdata.to_number != undefined && sdata.to_number) {
					cond += "AND dialed_number LIKE '%" + sdata.to_number + "' ";
					iQN++
				}

				if (sdata.direction != undefined && sdata.direction) {
					cond += "AND direction='" + sdata.direction + "' "
					iQN++
				}
				if (iQN1 > 0) {
					if (iQN > 0) {
						iQry += cond
					}
					iQry = iQry.slice(0, -1) + "\n"
				}
				else {
					if (iQN > 0) {
						iQry += "WHERE " + cond.substr(4, cond.length)
						iQry = iQry.slice(0, -1) + "\n"
					}
				}
				iQry += " AND idcdr  > '250000000' "
				if (!sdata.fType)
					iQry += "ORDER BY `start_stamp` DESC LIMIT 2000;"

				if (sdata.fType && sdata.fType == "filter")
					iQry += "ORDER BY `start_stamp` DESC LIMIT 10000;"

				let obj = new ModelRawQuery(req, res);
				obj.qrysql = iQry
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "CDR Fetched Successfully.",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Something Went Wrong, Try Again!",
							status: 502
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare("No session data there");
				objv.execute();
			}
		});
	}

	summeryCdrForm(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata: any = req.query;
				let data = JSON.parse(sdata.type);
				let condition: any = "";
				let con1: any = "";
				let Type: any = "";
				let obj2 = new ModelRawQuery(req, res);
				if (sessdata.type == 1) {
					Type = "";
				}
				else {
					Type = " AND `iduser`='" + sessdata.iduser + "'"
				}
				if (data.directionSummery == "Inbound" || data.directionSummery == "Outbound") {
					condition += "direction='" + data.directionSummery.toLowerCase() + "' AND ";
				}
				if (data.from_date && data.to_date) {
					condition += "DATE_FORMAT(start_stamp,'%Y-%m-%d') BETWEEN '" + data.from_date + "' AND '" + data.to_date + "'" + Type + "";
				}
				condition += " AND idcdr  > '250000000' ";
				if (!data.fType) {
					con1 += " LIMIT 2000"
				}
				if (data.fType && data.fType == "filter") {
					con1 += " LIMIT 10000"
				}

				let Qry: any;
				Qry = "SELECT DATE_FORMAT(start_stamp, '%Y-%m-%d') AS `date`,  direction,  COUNT(*) AS `Total_calls`,SUM(CASE WHEN hangup_cause='NORMAL_CLEARING' THEN 1 ELSE 0 END) AS `success`, SUM(CASE WHEN hangup_cause!='NORMAL_CLEARING' THEN 1 ELSE 0 END) AS `failed`, SUM(cost) AS `total_cost`, SUM(duration) AS `duration` FROM cdr WHERE " + condition + " GROUP BY direction,`date` ORDER BY `start_stamp` DESC " + con1 + " "

				obj2.qrysql = Qry
				obj2.prepare();
				obj2.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Data Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
				objv.execute();
			}
		})
	}


	/**
	 * To filter the SMS MDR report
	 */
	getMDRFilter(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let qdata: any = req.query.type;
				var sdata = JSON.parse(qdata);

				//let idaccount: number = typeof sdata.iduser != 'undefined' ? sdata.iduser : 0
				
				let idact: string = typeof sdata.iduser != 'undefined' && sdata.iduser ? sdata.iduser : '0';
				let idaccount = idact ? idact.split('-')[1] : '';
				
				let iQry: string = "",
					iQN1: number = 0,
					iQN: number = 0,
					cond: string = ""
				iQry = "SELECT `idmdr`, direction, msg_count, from_number, to_number, MT_rates, MO_rates, MT_surcharge, `status`, message_delivered_to_operator, message_accepted_by_signalmash, delivery_receipt_received_by_singnalmash, delivery_receipt_delivered, mobility";

				if (sessdata.type == 1) {
					iQry += ",messsage_body";
				}
				// iQry += ", ocn, lata, CONVERT_TZ(created_at, '" + sessdata.server_time + "', '" + sessdata.client_time + "') created_at, (\n"
				iQry += ", ocn, lata, created_at, (\n"
				iQry += "\tmsg_count*IFNULL(MO_rates,0)+msg_count*IFNULL(MT_rates,0)+msg_count*IFNULL(MT_surcharge,0)+msg_count*IFNULL(MO_surcharge,0)\n"
				iQry += ")`cost` FROM `mdr`\n"
				if (sessdata.type == 1) {
					if (idaccount) {
						iQry += "WHERE idaccount=" + idaccount + " "
						iQN1++
					}
				}
				else if (sessdata.type == 2) {
					iQry += "WHERE idaccount=" + sessdata.idaccount + " "
					iQN1++
				}
				else if (sessdata.type == 22) {
					iQry += "WHERE iduser=" + sessdata.iduser + " "
					iQN1++
				}

				/**
				 * Other parameters
				 */
				if (sdata.from_date != undefined && sdata.from_date) {
					// cond += "AND created_at>=CONVERT_TZ('" + sdata.from_date + " 00:00:00', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND DATE_FORMAT(created_at, '%Y-%m-%d')>='" + sdata.from_date + "' "
					iQN++
				}

				if (sdata.to_date != undefined && sdata.to_date) {
					// cond += "AND created_at<=CONVERT_TZ('" + sdata.to_date + " 23:59:59', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND DATE_FORMAT(created_at, '%Y-%m-%d')<='" + sdata.to_date + "' "
					iQN++
				}

				if (sdata.from_number != undefined && sdata.from_number) {
					cond += "AND from_number='" + sdata.from_number + "' "
					iQN++
				}

				if (sdata.to_number != undefined && sdata.to_number) {
					cond += "AND to_number='" + sdata.to_number + "' "
					iQN++
				}

				if (sdata.direction != undefined && sdata.direction) {
					cond += "AND direction='" + sdata.direction + "' "
					iQN++
				}

				if (iQN1 > 0) {
					if (iQN > 0) {
						iQry += cond
					}
					iQry = iQry.slice(0, -1) + "\n"
				}
				else {
					if (iQN > 0) {
						iQry += "WHERE " + cond.substr(4, cond.length)
						iQry = iQry.slice(0, -1) + "\n"
					}
				}
				//iQry += "ORDER BY `created_at` DESC;"
				if (!sdata.fType)
					iQry += "ORDER BY `created_at` DESC LIMIT 2000"

				if (sdata.fType && sdata.fType == "filter")
					iQry += "ORDER BY `created_at` DESC LIMIT 10000"

				let obj = new ModelRawQuery(req, res);
				obj.qrysql = iQry

				// let condition: any = "";
				// if (sdata.from_date && sdata.to_date) {
				// 	condition += '`created_at` BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59" ';
				// }
				// if (sdata.direction) {
				// 	condition += 'AND `direction`="' + sdata.direction + '" ';
				// }
				// if (sdata.to_number) {
				// 	condition += 'AND `to_number`="' + sdata.to_number + '" ';
				// }
				// if (sdata.from_number) {
				// 	condition += ' AND `from_number`="' + sdata.from_number + '"';
				// }
				// console.log(condition);
				// if (sessdata.type == 1) {
				// 	if (idaccount) {
				// 		obj.nonqrysql = "SELECT *, (msg_count*IFNULL(MO_rates,0)+msg_count*IFNULL(MT_rates,0)+msg_count*IFNULL(MT_surcharge,0)+msg_count*IFNULL(MO_surcharge,0)) `cost` FROM `mdr` WHERE `idaccount`='" + idaccount + "' AND " + condition + " ORDER BY STR_TO_DATE(`created_at`,'%Y-%m-%d') DESC";
				// 	}
				// 	else {
				// 		obj.nonqrysql = "SELECT *, (msg_count*IFNULL(MO_rates,0)+msg_count*IFNULL(MT_rates,0)+msg_count*IFNULL(MT_surcharge,0)+msg_count*IFNULL(MO_surcharge,0)) `cost` FROM `mdr` WHERE " + condition + " ORDER BY STR_TO_DATE(`created_at`,'%Y-%m-%d') DESC LIMIT 20";
				// 	}
				// }
				// else if (sessdata.type == 2) {
				// 	obj.nonqrysql = "SELECT *, (msg_count*IFNULL(MO_rates,0)+msg_count*IFNULL(MT_rates,0)+msg_count*IFNULL(MT_surcharge,0)+msg_count*IFNULL(MO_surcharge,0)) `cost` FROM `mdr` WHERE `idaccount`='" + sessdata.idaccount + "' AND " + condition + " ORDER BY STR_TO_DATE(`created_at`,'%Y-%m-%d') DESC";
				// }
				// else if (sessdata.type == 22) {
				// 	obj.nonqrysql = "SELECT *, (msg_count*IFNULL(MO_rates,0)+msg_count*IFNULL(MT_rates,0)+msg_count*IFNULL(MT_surcharge,0)+msg_count*IFNULL(MO_surcharge,0)) `cost` FROM `mdr` WHERE `iduser`='" + sessdata.iduser + "' AND " + condition + " ORDER BY STR_TO_DATE(`created_at`,'%Y-%m-%d') DESC";
				// }
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "MDR Fetched Successfully.",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Something Went Wrong, Try Again!",
							status: 502
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}
	summeryMDRFilter(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata: any = req.query;
				let data = JSON.parse(sdata.type);
				let condition: any = "";
				let Type: any = "";
				// let obj2 = new ModelRawQuery(req, res);
				if (sessdata.type == 1) {
					Type = "";
				}
				else {
					Type = "AND `iduser`='" + sessdata.iduser + "'"
				}

				if (data.from_date && data.to_date) {
					condition += "DATE_FORMAT(created_at,'%Y-%m-%d') BETWEEN '" + data.from_date + "' AND '" + data.to_date + "' " + Type + " ";
				}

				if (data.directionSummery == "Inbound") {
					condition += "AND direction='inbound' "
				}
				if (data.directionSummery == "Outbound") {
					condition += "AND direction='Outbound' "
				}
				if (data.directionSummery == "Both") {
					condition += ""
				}

				let Qry: any;

				Qry = "SELECT DATE_FORMAT(created_at,'%Y-%m-%d')`date`, direction , CASE WHEN direction='inbound' THEN COUNT(messsage_body) WHEN direction='outbound' THEN COUNT(messsage_body)ELSE 0 END`total_message` ,CASE direction WHEN'outbound' THEN SUM(MT_rates) WHEN 'inbound' THEN SUM(MT_rates) END `total_cost`,`STATUS` FROM mdr WHERE " + condition + " GROUP BY direction,DATE_FORMAT(created_at,'%Y-%m-%d')"

				if (!data.fType)
					Qry += "ORDER BY `created_at` DESC LIMIT 2000"

				if (data.fType && data.fType == "filter")
					Qry += "ORDER BY `created_at` DESC LIMIT 10000"

				let obj2 = new ModelRawQuery(req, res);
				obj2.qrysql = Qry;

				obj2.prepare();
				obj2.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Data Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
				objv.execute();
			}
		});
	}

	CsvInvoice(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata: any) => {
			if (err == 1) {
				let sdata: any = req.query;
				let obj = new ModelRawQuery(req, res);
				if (sdata.selectedUser != 'null' && sdata.selectedUser) {
					obj.qrysql = "Call admin_label ('','" + sdata.selectedUser + "', '" + sdata.fromDate + "', '" + sdata.toDate + "')";
				} else {
					obj.qrysql = "Call admin_label ('1','1', '" + sdata.fromDate + "', '" + sdata.toDate + "')";
				}
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Invoice Fetched!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	billingInvoice(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata: any) => {
			if (err == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT *,TRUNCATE(tax,4) AS tax, TRUNCATE(total_amount,4) AS total_amount,TRUNCATE((`total_amount`+tax),4)AS grand_total, DATE_FORMAT(created_at, '%m-%d-%Y') FROM `invoice_monthly` WHERE idinvoice='" + req.query.idinvoice + "' ORDER BY created_at ASC";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Invoice Fetched!", data: result, status: 200 });
						objv.execute();

					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	invoiceBillingAddress(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let qdata = req.query;
				let obj = new ModelRawQuery(req, res);
				//obj.qrysql = "SELECT san,customer_name, address1, address2, city, state,postal_code, country, phone, email FROM invoice WHERE idaccount='" + qdata.idaccount + "'";
				obj.qrysql = "SELECT san,customer_name, address1, address2, city, state,postal_code, country, phone, email FROM invoice WHERE idinvoice='" + qdata.idinvoice + "'";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Billing Address Fetched!", data: result, status: 200 });
						objv.execute();

					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	// montholyInvoice(req: Request, res: Response, next: NextFunction) {
	// 	let sdata = req.query;
	// 	console.log(sdata);
	// 	let condition: any = "";
	// 	let session = new SessionManagment(req, res, next);
	// 	session.GetSession((sessError: any, sessdata) => {
	// 		if (sessError == 1) {
	// 			let obj = new ModelRawQuery(req, res);
	// 			if (sessdata.type == 1) {
	// 				if (sdata.selectedUser || (sdata.toDate && sdata.fromDate)) {
	// 					if (sdata.fromDate && sdata.toDate && !sdata.selectedUser) {
	// 						condition += 'ins.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
	// 					}
	// 					if (sdata.selectedUser && !(sdata.toDate && sdata.fromDate)) {
	// 						condition += 'ins.`idaccount`="' + sdata.selectedUser + '"';
	// 					}
	// 					if (sdata.selectedUser && sdata.fromDate && sdata.toDate) {
	// 						condition += 'ins.created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ins.`idaccount`="' + sdata.selectedUser + '"';
	// 					}
	// 					obj.qrysql = "SELECT `ins`.`san`,`ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`, ins.customer_name, DATE_FORMAT(`ins`.`created_at`, '%m-%d-%Y')`created_at`, `inm`.`total_amount` FROM `invoice` `ins` INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice`  WHERE " + condition + " GROUP BY `ins`.`idinvoice` ORDER BY DATE_FORMAT(`ins`.`created_at`, '%Y-%m') ASC";
	// 				}
	// 				else {
	// 					obj.qrysql = "SELECT `ins`.`san`, `ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`,  ins.customer_name,DATE_FORMAT(`ins`.`created_at`, '%m-%d-%Y')`created_at`, `inm`.`total_amount` FROM `invoice` `ins`INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice`GROUP BY `ins`.`idinvoice` ORDER BY DATE_FORMAT(`ins`.`created_at`, '%Y-%m') ASC";
	// 				}
	// 			}
	// 			else {
	// 				obj.qrysql = "SELECT `ins`.`san`, `ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`,  ins.customer_name, DATE_FORMAT(`ins`.`created_at`, '%m-%d-%Y')`created_at`, `inm`.`total_amount` FROM `invoice` `ins` INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice` WHERE `ins`.`idaccount`='" + sessdata.idaccount + "' GROUP BY `ins`.`idinvoice` ORDER BY DATE_FORMAT(`ins`.`created_at`, '%Y-%m') ASC"
	// 			}
	// 			obj.prepare();
	// 			obj.execute((err: any, result: any) => {
	// 				if (err == 1) {
	// 					let objv = new RawView(res);
	// 					objv.prepare({ message: "Invoice Fetched Successfully!", status: 200, data: result });
	// 					objv.execute();
	// 				}
	// 				else {
	// 					let objv = new RawView(res);
	// 					objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
	// 					objv.execute();
	// 				}
	// 			});
	// 		}
	// 		else {
	// 			let objv = new RawView(res);
	// 			objv.prepare({ message: "Invalid Authorization!", status: 401 });
	// 			objv.execute();
	// 		}
	// 	});
	// }

	montholyInvoice(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessError: any, sessdata) => {
			if (sessError == 1) {
				let sdata = req.query;
				let condition: any = "";
				let obj = new ModelRawQuery(req, res);
				if (sessdata.type == 1) {
					if (sdata.selectedUser || (sdata.toDate && sdata.fromDate)) {
						if (sdata.fromDate && sdata.toDate && !sdata.selectedUser) {
							condition += 'ins.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
						}
						if (sdata.selectedUser && !(sdata.toDate && sdata.fromDate)) {
							condition += 'ins.`idaccount`="' + sdata.selectedUser + '"';
						}
						if (sdata.selectedUser && sdata.fromDate && sdata.toDate) {
							condition += 'ins.created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ins.`idaccount`="' + sdata.selectedUser + '"';
						}
						// obj.qrysql = "SELECT `ins`.`san`,`ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`, ins.customer_name, DATE_FORMAT(`ins`.`created_at`, '%Y-%m-%d')`created_at`, `inm`.`total_amount`,`inm`.`tax` FROM `invoice` `ins` INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice`  WHERE " + condition + " GROUP BY `ins`.`idinvoice` ORDER BY DATE_FORMAT(`ins`.`created_at`, '%Y-%m') DESC";
						obj.qrysql = "SELECT `ins`.`san`,`ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`, ins.customer_name, DATE_FORMAT(`ins`.`created_at`, '%Y-%m-%d')`created_at`, `inm`.`total_amount`,`inm`.`tax` FROM `invoice` `ins` INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice`  WHERE " + condition + " GROUP BY `ins`.`idinvoice` ORDER BY `ins`.`created_at` DESC";
					}
					else {
						// obj.qrysql = "SELECT `ins`.`san`, `ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`,  ins.customer_name,DATE_FORMAT(`ins`.`created_at`, '%Y-%m-%d')`created_at`, `inm`.`total_amount`,`inm`.`tax` FROM `invoice` `ins`INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice`GROUP BY `ins`.`idinvoice` ORDER BY DATE_FORMAT(`ins`.`created_at`, '%Y-%m') DESC";
						obj.qrysql = "SELECT `ins`.`san`, `ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`,  ins.customer_name,DATE_FORMAT(`ins`.`created_at`, '%Y-%m-%d')`created_at`, `inm`.`total_amount`,`inm`.`tax` FROM `invoice` `ins`INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice`GROUP BY `ins`.`idinvoice` ORDER BY `ins`.`created_at` DESC";
					}
				}
				else {
					// obj.qrysql = "SELECT `ins`.`san`, `ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`,  ins.customer_name, DATE_FORMAT(`ins`.`created_at`, '%Y-%m-%d')`created_at`, `inm`.`total_amount`, `inm`.`tax` FROM `invoice` `ins` INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice` WHERE `ins`.`idaccount`='" + sessdata.idaccount + "' GROUP BY `ins`.`idinvoice` ORDER BY DATE_FORMAT(`ins`.`created_at`, '%Y-%m') DESC"
					obj.qrysql = "SELECT `ins`.`san`, `ins`.`idinvoice`,`ins`.`idaccount`, `ins`.`invoice_number`,  ins.customer_name, DATE_FORMAT(`ins`.`created_at`, '%Y-%m-%d')`created_at`, `inm`.`total_amount`, `inm`.`tax` FROM `invoice` `ins` INNER JOIN `invoice_monthly` `inm` ON `ins`.`idinvoice`=`inm`.`idinvoice` WHERE `ins`.`idaccount`='" + sessdata.idaccount + "' GROUP BY `ins`.`idinvoice` ORDER BY `ins`.`created_at` DESC";
				}
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Invoice Fetched Successfully!", status: 200, data: result });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}

	searchOperators(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata: any) => {
			if (err == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT id, name FROM `operator`";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Data Filtered!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 200 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	operatorFromLergInfo(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata) => {
			if (err == 1) {
				let obj = new ModelRawQuery(req, res);
				//  REPLACE(REPLACE(co_name_spec_c,'-',' '),'_',' ') co_name_spec_c
				obj.qrysql = "SELECT `idlerg_operator`, `operator` FROM `lerg_operator` WHERE `category`='" + req.query.category + "';";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Operators Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	categoryFromLergInfo(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata) => {
			if (err == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `idlerg_operator`,`category` FROM `lerg_operator` GROUP BY `category`";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Operators Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}


	Lerg_Info(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata) => {
			if (err == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM `lerg_info` GROUP BY `co_name_spec_c`";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Operators Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	uploadLergInfo(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((errsess: any, sessdata) => {
			if (errsess == 1) {
				if (!req.file) {
					let objv = new RawView(res);
					objv.prepare({ message: "File is required!", status: 502 });
					objv.execute();
				}
				else {
					let Upload: any = new ModelCsvUpload(req, res)
					let udata: any = Upload.fileUpload()
					var currentdate = new Date();
					var datetime = currentdate.getDate() + "" + (currentdate.getMonth() + 1) + "" + currentdate.getFullYear() + "" + currentdate.getHours() + "" + currentdate.getMinutes() + "" + currentdate.getSeconds();
					// copy table
					let obj0 = new ModelRawNonQuery(req, res);
					obj0.nonqrysql = "CREATE TABLE lerg_info_" + datetime + "( SELECT * FROM lerg_info)";
					obj0.prepare();
					obj0.execute((errcopy: any, respcopy: any) => {
						if (errcopy == 1) {
							let obj1 = new ModelRawNonQuery(req, res);
							obj1.nonqrysql = "TRUNCATE TABLE `lerg_info`;";
							obj1.prepare();
							obj1.execute((err: any, resp: any) => {
								if (err == 1) {
									let obj = new ModelRawNonQuery(req, res);
									obj.nonqrysql = "LOAD DATA LOCAL INFILE '" + udata[1] + udata[0] + "' INTO TABLE `lerg_info` FIELDS TERMINATED BY ',' LINES TERMINATED BY '\r\n' IGNORE 1 LINES (@col1, @col2, @col3, @col4, @col5, @col6, @col7, @col8, @col9,@col10, @col11, @col12) SET `npa`=@col1, `nxx`=@col2, `block`=@col3, `ocn`=@col4, `lata`=@col5, `state`=@col6, `co_name_spec_c`=@col7, `category`=@col8, `lergdate`=@col9, `region`=@col10, `lata_name`=@col11, `country`=@col12";
									obj.prepare();
									obj.execute((_error: any, result: any) => {
										if (_error == 1) {
											let obj0 = new ModelRawNonQuery(req, res);
											obj0.nonqrysql = "UPDATE `lerg_info` SET co_name_spec_c=REPLACE(co_name_spec_c,',','-')";
											obj0.prepare();
											obj0.execute((errcopy: any, respcopy: any) => {
												if (errcopy == 1) {
													let obj0 = new ModelRawNonQuery(req, res);
													obj0.nonqrysql = "UPDATE `lerg_info` SET co_name_spec_c=REPLACE(co_name_spec_c,' ','_')";
													obj0.prepare();
													obj0.execute((errcopyy: any, respcopy: any) => {
														if (errcopyy == 1) {
															let obj1 = new ModelRawNonQuery(req, res);
															obj1.nonqrysql = "INSERT INTO upload (`idaccount`,`filename`, `destination_path`, `filetype`, `type`) VALUES ('" + sessdata.idaccount + "', '" + req.file.filename + "', '" + udata[1] + udata[0] + "', '" + req.file.mimetype + "', 'Lerg Info')";
															obj1.prepare();
															obj1.execute((___error: any, _result: any) => {
																if (___error == 1) {
																	let objv = new RawView(res);
																	objv.prepare({ message: "Lerg Info Upload Successfully!", data: result, status: 201 });
																	objv.execute();
																}
																else {
																	let objv = new RawView(res);
																	objv.prepare({ message: "Something Went Wrong With File!", status: 502 });
																	objv.execute();
																}
															});
														}
														else {
															let objv = new RawView(res);
															objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
															objv.execute();
														}
													});
												}
												else {
													let objv = new RawView(res);
													objv.prepare({ message: "Table not Updated!", status: 502 });
													objv.execute();
												}
											});
										}
										else {
											let objv = new RawView(res);
											objv.prepare({ message: "Table not Updated!", status: 502 });
											objv.execute();
										}
									});
								}
								else {
									let objv = new RawView(res);
									objv.prepare({ message: "Table Not Truncated!", status: 502 });
									objv.execute();
								}
							});
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Table Not Created! ", status: 502 });
							objv.execute();
						}
					});

				}
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session!", status: 402 });
				objv.execute();
			}
		});
	}

	setOperatorMapping(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			let operator1 = req.body.operator1;
			let data: any = req.body.operator2;
			let category = req.body.category[0];
			if (error == 1) {
				let tmpqurty = '';
				tmpqurty = "";
				let obj = new ModelRawNonQuery(req, res);
				data.forEach((element: any) => {
					obj.nonqrysql = "INSERT INTO `operator_mapping` (`idoperator`,`idlerg_operator`, `category`,`key`) VALUES ('" + operator1.id + "', '" + element.idlerg_operator + "', '" + category.category + "','" + sessdata.idaccount + '-' + operator1.id + '-' + element.idlerg_operator + "') ON DUPLICATE KEY UPDATE `idoperator`='" + operator1.id + "', `idlerg_operator`='" + element.idlerg_operator + "', `category`='" + category.category + "',`key`='" + sessdata.idaccount + "-" + operator1.id + "-" + element.idlerg_operator + "'";
					obj.prepare();
					obj.execute((error: any, result: any) => {
					});
				});
				// var ne :any= tmpqurty.slice(0, -1);
				// console.log(ne);
				// obj.nonqrysql =tmpqurty.slice(0, -1);
				// 
				// obj.prepare();
				// obj.execute((error: any, result: any) => {
				// if(error == 1){
				let objv = new RawView(res);
				objv.prepare({ message: "Operator Mapping Successfully!" });
				objv.execute();
				// }
				// else{
				// 	let objv = new RawView(res);
				// 	objv.prepare({ message: "Somthing Went Wrong!" });
				// 	objv.execute();	
				// }
				// });	
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});

	}

	getOperatorMapping(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata: any) => {
			if (err == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT CONCAT('\"name\":\"',`name`, '\",\"data\": [',IFNULL(`data`,''),']') `name` FROM (SELECT GROUP_CONCAT(CONCAT('{\"lerg\":\"',lo.operator,'\",\"type\":\"',om.category,'\", \"id\":\"',om.id_operator,'\"}')) `data`, o.name FROM `lerg_operator` lo JOIN `operator_mapping` om ON lo.idlerg_operator=om.idlerg_operator RIGHT JOIN operator o ON o.id=om.idoperator GROUP BY idoperator, o.id) tbl";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Operator Mapping Fetched!", status: 200, data: result });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong with DB!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	deleteMapping(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata: any) => {
			if (err == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "DELETE FROM `operator_mapping` WHERE `id_operator`='" + req.query.operator + "'";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Operator Mapping Deleted!", data: result, status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With DB!", status: 503 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	uploadZone(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata) => {
			if (err == 1) {
				let filePath: any = URLlink.SIGNALHOST;
				if (req.file) {
					const fileName = req.file.filename;
					filePath = filePath + '/uploads/' + fileName;
					//   filePath = "https://signalmash.crmdialer.us:4263"+'/uploads/' + fileName;
				}
				let obj1 = new ModelRawNonQuery(req, res);
				obj1.nonqrysql = "TRUNCATE TABLE `zones`;";
				obj1.prepare();
				obj1.execute((err: any, ress: any) => {
					if (err == 1) {
						let obj = new ModelRawNonQuery(req, res);
						obj.nonqrysql = "LOAD DATA LOCAL INFILE '" + req.file.path + "' INTO TABLE `zones` FIELDS TERMINATED BY ',' LINES TERMINATED BY '\r\n' IGNORE 1 LINES (@col1, @col2) SET `npanxx`=@col1, `zone`=@col2";
						obj.prepare();
						obj.execute((_error: any, result: any) => {
							if (_error == 1) {
								let obj1 = new ModelRawNonQuery(req, res);
								obj1.nonqrysql = "INSERT INTO upload (`idaccount`,`filename`, `destination_path`, `filetype`, `type`) VALUES ('" + sessdata.idaccount + "', '" + req.file.filename + "', '" + req.file.path + "', '" + req.file.mimetype + "', 'Zone CSV')";
								obj1.prepare();
								obj1.execute((__error: any, _result: any) => {
									if (__error == 1) {
										let objv = new RawView(res);
										objv.prepare({ message: "ZONE Data Upload Successfully!", data: result, status: 201 });
										objv.execute();
									}
									else {
										let objv = new RawView(res);
										objv.prepare({ message: "Something Went Wrong With File!", status: 502 });
										objv.execute();
									}
								});
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ message: "Something Went Wrong With File!", status: 502 });
								objv.execute();
							}
						});
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "its DB error!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	getZones(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM zones";
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Zone Fetched Successfully!", status: 200, data: result });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something went wrong With Connection", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	ganarateInvoice(req: Request, res: Response, next: NextFunction) {
		let sdata = req.body;
		let session = new SessionManagment(req, res, next);
		session.GetSession((err: any, sessdata) => {
			if (err == 1) {
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "iNSERT INTO `invoice` (`idaccount`, `invoice_number`) VALUES ('" + sessdata.idaccount + "', '" + sdata.invoiceNumber + "')";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Inovoice Generate Successfully!", data: result, status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		});
		// });
	}

	tMobileReportList(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT type , DATE_FORMAT(`date`, '%Y-%m-%d %H:%i:%s')`date`,`month` FROM `tmobile` WHERE `idaccount` = '" + sessData.idaccount + "'";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "T_Mobile List Fetch Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	tMobileReport(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let qData = req.query;
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "CALL tmobile_monthly_report(" + qData.month + ")";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "T_Mobile List Fetch Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access", status: 401 });
				objv.execute();
			}
		});
	}

	demo(req: Request, res: Response, next: NextFunction) {
		let array = [0, 1, 2, 3, 4];
		array.forEach(ele => {
			res.write("go");
		})
		let obj = new RawView(res);
		obj.prepare({ respone: "hello", status: "working" });
		obj.execute();
	}


	/**
	* To import the DIDs using csv
	*/
	public uploadDID(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				var sdata: any = JSON.parse(req.body.uploadDid)
				let user: any = sdata.user.split('-')
				let iduser: any = user[0]
				let idaccount: any = user[1]
				let objfile = new ModelCsvUpload(req, res);
				let fdata = objfile.fileUpload();

				let firstrow1 = fs.readFileSync(req.file.path).toString().split('\n');

				let firstrow = firstrow1[0].split('\r');
				let str: string = "";
				if (!firstrow[0].match(/[a-z]/)) {
					console.log("LETTER FOUND");
					str = '';
				} else {
					console.log("LETTER NOT FOUND");
					str = 'IGNORE 1 LINES';
				}
				let str_array: Array<String> = [];
				str_array = firstrow[0].split(',');
				for (var i = 0; i < str_array.length; i++) {
					// Trim the excess whitespace.
					str_array[i] = str_array[i].replace(/^\s*/, "").replace(/\s*$/, "").replace(/\"/g, "").trim();
				}
				//remove uploaded temp file from disk.
				/* fs.unlink(fdata[2], (err: any) => {
					if (err) throw err;
				}); */
				let rate = new APIBase;
				rate.getRate(req, res, sdata.idtariff, "message", sdata.numbertype, (err, voice_rate) => {
					let did_rates: any = Array.isArray(voice_rate) && voice_rate.length > 0 ? voice_rate[0].rate : 0;
					if (err == 1 && did_rates > 0) {
						let obj = new ModelRawNonQuery(req, res);
						let filelname = req.file.originalname.replace(/"/g, '\\"').replace(/'/g, "\\'");
						fdata[0] = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'");
						obj.nonqrysql = "INSERT INTO `upload_did` (`uploaded_file`, `did_count`, `iduser`, `idaccount`, `description`, `campaign`, `connection`, `provider`) VALUES ('" + fdata[0] + "', '0', '" + iduser + "', '" + idaccount + "','" + sdata.description + "', '" + sdata.campaign + "', '" + sdata.connection + "', '" + sdata.provider + "')";
						obj.prepare();
						obj.execute((error: any, result: any) => {
							if (error == 1) {
								let lastid = result.insertId;

								let iQry: string = "LOAD DATA LOCAL INFILE'" + fdata[1] + fdata[0] + "' IGNORE INTO TABLE `did_buy` CHARACTER SET UTF8\n"
								//iQry += 'OPTIONALLY ENCLOSED BY '+'"'+'\n'
								//iQry += "OPTIONALLY ENCLOSED BY " + "'" + '"' + "'"+"\n"
								iQry += "FIELDS TERMINATED BY ','\n"
								iQry += "ENCLOSED BY ' '\n"
								iQry += "ESCAPED BY ' '\n",
									iQry += "LINES TERMINATED BY '\n' IGNORE 1 LINES\n"
								iQry += "(@col1)\n"
								iQry += "SET `did`=@col1, `iduser`='" + iduser + "', `account_id`='" + idaccount + "', `provider`='" + sdata.provider + "', `sms_provider`='" + sdata.sms_provider + "',`sinch_status`='0', `camp_registry`='" + sdata.campaign + "', `connection_key`='" + sdata.connection + "', `inbound_key`='" + sdata.inbound + "', `outbound_key`='" + sdata.outbound + "', `rates`='" + did_rates + "', `nrc_rates`='" + did_rates + "',`created_at`=NOW(), `type`='" + sdata.numbertype + "', `npa`=SUBSTRING(SUBSTR(REPLACE(REPLACE((@col1),' ',''),'\r',''),-10),1,3), `nxx`=SUBSTRING(REPLACE(REPLACE((@col1),' ',''),'\r',''),-7,3), `disconnect_did_status`='1', `id_upload`='" + lastid + "', `status`='completed', `osr_status`='';"

								let obj = new ModelRawNonQuery(req, res);
								obj.nonqrysql = iQry;
								obj.prepare();
								obj.execute((error: any, result: any) => {
									if (error == 1) {
										let objlc = new ModelRawQuery(req, res);
										objlc.qrysql = "SELECT COUNT(*) `did` FROM `did_buy` WHERE id_upload='" + lastid + "'";
										objlc.prepare();
										objlc.execute((errorC: any, listcount: any) => {
											if (errorC == 1) {
												let objlc2 = new ModelRawNonQuery(req, res);
												objlc2.nonqrysql = "UPDATE `upload_did` SET `did_count`='" + listcount[0].did + "' WHERE `idupload`='" + lastid + "'";
												objlc2.prepare()
												objlc2.execute((errU: any, result9: any) => {
													if (errU == 1) {
														let objp = new ModelRawQuery(req, res);
														objp.qrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + iduser + "'";
														objp.prepare();
														objp.execute((proration_error, proration_success) => {
															if (proration_error == 1) {
																let proration_status = proration_success[0].proration;

																let dateObj = new Date();
																let day = dateObj.getUTCDate();
																let nDate: any = new Date()
																// lDate //Total days of month
																let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
																let totalDays = (lDate - day) + 1;
																let ProrateSingle: any = proration_status == "true" ? (totalDays * did_rates) / lDate : did_rates;
																let prorate: any = ProrateSingle * listcount[0].did;

																console.log("Prorate::", prorate);

																// update end subscription date
																let obj0 = new ModelRawQuery(req, res);
																obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.`id_upload`='" + lastid + "' AND disconnect_did_status = '1'";
																obj0.prepare();
																obj0.execute((dids_err, didRes) => {
																	let dates = didRes[0].subscription_end_date;
																	let isoDate = new Date(dates);
																	let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
																	let obj01 = new ModelRawNonQuery(req, res);
																	obj01.nonqrysql = "UPDATE `did_buy` SET `pro_rates`='" + ProrateSingle + "',`subscription_end_date`='" + subscriptionEndDate + "' WHERE `id_upload`=" + lastid + ";"
																	obj01.prepare();
																	obj01.execute((error, result) => { })
																});

																if (prorate > 0) {
																	let objlc2 = new ModelRawNonQuery(req, res);
																	objlc2.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-'" + prorate + "' WHERE idaccount='" + idaccount + "'";
																	objlc2.prepare();
																	objlc2.execute((errUy: any, result9: any) => {

																		let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

																		iQry += "`idaccount`=" + idaccount + ", "

																		iQry += "`amount`='-" + prorate + "', "

																		iQry += "`purpose`='Wallet amount successfully updated for bulk DID import', "

																		iQry += "`status`=1;"

																		let objWL = new ModelRawNonQuery(req, res);
																		objWL.nonqrysql = iQry
																		objWL.prepare()
																		objWL.execute((error: any, result: any) => {
																			console.log("Transaction response::", result)
																		})

																		let objlc2 = new ModelRawQuery(req, res);
																		objlc2.qrysql = "SELECT `did`, `order_id`, `npa`, `nxx`, `state`, `ratecenter` FROM `did_buy` WHERE id_upload=" + lastid + ";";
																		objlc2.prepare()
																		objlc2.execute((error: any, result: any) => {
																			let DIDRecords: any = Array.isArray(result) && result.length > 0 ? result : []

																			let DI: number = 0
																			iQry = ""
																			for (let x of DIDRecords) {
																				iQry += "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`, `provider`, `order_id`, `iduser`, `disconnect_did_status`, `npa`, `nxx`, `state`, `ratecenter`, `rates`, `idapi`, `pro_rates`, `type`,`event_type`,`description`) VALUES(" + idaccount + ", " + iduser + ", 'completed','" + x.did + "', '" + sdata.provider + "', '" + x.order_id + "','" + iduser + "', '1', '" + x.npa + "', '" + x.nxx + "', '" + x.state + "', '" + x.ratecenter + "', '" + voice_rate[0].rate + "', '" + sessdata.idapi + "', '" + ProrateSingle + "', '" + sdata.numbertype + "','2','Import DID');\n"
																				DI++
																			}

																			if (DI > 0) {
																				let objlc2 = new ModelRawNonQuery(req, res);
																				objlc2.nonqrysql = iQry
																				objlc2.prepare();
																				objlc2.execute((error, result) => {
																					let objv = new RawView(res);
																					objv.prepare({
																						message: "DID Uploaded Successfully!",
																						status: 201
																					});
																					objv.execute();
																				})
																			}
																			else {
																				let objv = new RawView(res);
																				objv.prepare({
																					message: "DID did not uploaded something went wrong!",
																					status: 502
																				});
																				objv.execute();
																			}
																		})
																	});
																}
																else {
																	let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

																	iQry += "`idaccount`=" + idaccount + ", "

																	iQry += "`amount`='-" + prorate + "', "

																	iQry += "`purpose`='Billing prorate can't be 0 or less then 0 during DID upload', "

																	iQry += "`status`=2;"

																	let objWL = new ModelRawNonQuery(req, res);
																	objWL.nonqrysql = iQry
																	objWL.prepare()
																	objWL.execute((error: any, result: any) => {
																		console.log("Transaction response::", result)
																	})

																	let objv = new RawView(res);
																	objv.prepare({
																		message: "Billing prorate can't be 0 or less then 0!",
																		status: 502
																	});
																	objv.execute();
																}
															}
															else {
																let obj = new RawView(res);
																obj.prepare({
																	error_code: 0,
																	status: 502,
																	message: "Something went wrong with get proration!"
																});
																obj.execute();
															}
														});
													} else {
														let objv = new RawView(res);
														objv.prepare({
															message: "Data Not Found From Type!",
															status: 502,
															error: result9
														});
														objv.execute();
													}
												});
											} else {
												let objv = new RawView(res);
												objv.prepare({
													message: "Data Not Found From Type!",
													status: 502,
													error: listcount
												});
												objv.execute();
											}
										});
									} else {
										let objv = new RawView(res);
										objv.prepare({
											message: "Data Not Found From Type!",
											status: 502,
											error: error
										});
										objv.execute();
									}
								});
							}
							else {
								let objv = new RawView(res);
								objv.prepare({
									message: "Something Went Wrong With Connection!",
									status: 502,
									error: result
								});
								objv.execute();
							}
						});
					} else {
						let objv = new RawView(res);
						objv.prepare({
							message: "DID rates did not found!",
							status: 502,
						});
						objv.execute();
					}
				});

			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}


	/**
	 * To get the customer's campaigns
	 */
	public getCampaign(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.query;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM `campaign` where `iduser` = '" + sdata.type + "' AND `deleted`=0 GROUP BY campaign_key";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Campaign Fetched Successfully!",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Get Campaign List!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}


	/**
	 * To get the customer's connections by iduser
	 */
	public GetConnections(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.query;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT idendpoint, connection_key, name connection FROM `endpoint` WHERE `iduser` = '" + sdata.type + "' GROUP BY connection_key;";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Campaign Fetched Successfully!",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Connection!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}
	/**
	 * To get the customer's connections by account
	 */
	public GetConnectionsByAccount(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.query;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT idendpoint, connection_key, name connection FROM `endpoint` WHERE `idaccount` = '" + sdata.type + "' GROUP BY connection_key;";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Campaign Fetched Successfully!",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Connection!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	public getInvoiceTax(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata = req.query;
				let idaccount:any = sessdata.type==1 ? sdata.idaccount : sessdata.idaccount;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT * FROM `invoice_tax` WHERE `idaccount` =  '" + idaccount + "' AND `idinvoice` = '" + sdata.idinvoice + "'";

				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Campaign Fetched Successfully!",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							message: "Something Went Wrong With Connection!",
							status: 502,
							error: result
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}

	getMMSMDR(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let qdata: any = req.query.type;
				var sdata = JSON.parse(qdata);
				//let idaccount: number = typeof sdata.iduser != 'undefined' ? sdata.iduser : 0
				let idact: string = typeof sdata.iduser != 'undefined' && sdata.iduser ? sdata.iduser : '0';
				let idaccount = idact ? idact.split('-')[1] : '';
				
				let iQry: string = "",
					iQN1: number = 0,
					iQN: number = 0,
					cond: string = ""
				iQry = "SELECT `idmdr`,direction, msg_count, from_number, to_number, MT_rates, MO_rates, MT_surcharge, `status`, message_delivered_to_operator, message_accepted_by_signalmash, delivery_receipt_received_by_singnalmash, delivery_receipt_delivered, mobility";
				if (sessdata.type == 1) {
					iQry += ",messsage_body";
				}
				// iQry += ", ocn, lata, cost, CONVERT_TZ(created_at, '" + sessdata.server_time + "', '" + sessdata.client_time + "') created_at FROM `mms_mdr`\n"
				iQry += ", ocn, lata, cost, created_at FROM `mms_mdr`\n"
				if (sessdata.type == 1) {
					if (idaccount) {
						iQry += "WHERE idaccount=" + idaccount + " "
						iQN1++
					}
				}
				else if (sessdata.type == 2) {
					iQry += "WHERE idaccount=" + sessdata.idaccount + " "
					iQN1++
				}
				else if (sessdata.type == 22) {
					iQry += "WHERE iduser=" + sessdata.iduser + " "
					iQN1++
				}

				/**
				 * Other parameters
				 */
				if (sdata.from_date != undefined && sdata.from_date) {
					// cond += "AND created_at>=CONVERT_TZ('" + sdata.from_date + " 00:00:00', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND created_at>='" + sdata.from_date + "' "
					iQN++
				}

				if (sdata.to_date != undefined && sdata.to_date) {
					// cond += "AND created_at<=CONVERT_TZ('" + sdata.to_date + " 23:59:59', '" + sessdata.client_time + "', '" + sessdata.server_time + "') "
					cond += "AND created_at<='" + sdata.to_date + "' "
					iQN++
				}

				if (sdata.from_number != undefined && sdata.from_number) {
					cond += "AND from_number='" + sdata.from_number + "' "
					iQN++
				}

				if (sdata.to_number != undefined && sdata.to_number) {
					cond += "AND to_number='" + sdata.to_number + "' "
					iQN++
				}

				if (sdata.direction != undefined && sdata.direction) {
					cond += "AND direction='" + sdata.direction + "' "
					iQN++
				}

				if (iQN1 > 0) {
					if (iQN > 0) {
						iQry += cond
					}
					iQry = iQry.slice(0, -1) + "\n"
				}
				else {
					if (iQN > 0) {
						iQry += "WHERE " + cond.substr(4, cond.length)
						iQry = iQry.slice(0, -1) + "\n"
					}
				}
				// iQry += "ORDER BY `created_at` DESC;"

				if (!sdata.fType)
					iQry += "ORDER BY `created_at` DESC LIMIT 2000"

				if (sdata.fType && sdata.fType == "filter")
					iQry += "ORDER BY `created_at` DESC LIMIT 10000"

				let obj = new ModelRawQuery(req, res);
				obj.qrysql = iQry

				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "MMS MDR Fetched Successfully.",
							status: 200
						});
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({
							data: result,
							message: "Something Went Wrong, Try Again!",
							status: 502
						});
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		});
	}
	summeryMMSMDR(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((error: any, sessdata: any) => {
			if (error == 1) {
				let sdata: any = req.query;
				let data = JSON.parse(sdata.type);
				let condition: any = "";
				let Type: any = "";
				let obj2 = new ModelRawQuery(req, res);
				if (sessdata.type == 1) {
					Type = "";
				}
				else {
					Type = "AND `iduser`='" + sessdata.iduser + "'"
				}

				if (data.from_date && data.to_date) {
					condition += "DATE_FORMAT(created_at,'%Y-%m-%d') BETWEEN '" + data.from_date + "' AND '" + data.to_date + "' " + Type + " ";
				}

				if (data.directionSummery == "Inbound") {
					condition += "AND direction='inbound' "
				}
				if (data.directionSummery == "Outbound") {
					condition += "AND direction='Outbound' "
				}
				if (data.directionSummery == "Both") {
					condition += ""
				}

				let Qry: any;

				Qry = "SELECT `idmdr`, DATE_FORMAT(created_at,'%Y-%m-%d')`date`, direction , CASE WHEN direction='inbound' THEN COUNT(messsage_body) WHEN direction='outbound' THEN COUNT(messsage_body)ELSE 0 END`total_message` ,CASE direction WHEN'outbound' THEN SUM(MT_rates) WHEN 'inbound'	THEN SUM(MT_rates) END `total_cost`,`STATUS` FROM mms_mdr  WHERE " + condition + " GROUP BY direction,DATE_FORMAT(created_at,'%Y-%m-%d')"

				if (!data.fType)
					Qry += "ORDER BY `created_at` DESC LIMIT 2000"

				if (data.fType && data.fType == "filter")
					Qry += "ORDER BY `created_at` DESC LIMIT 10000"

				obj2.qrysql = Qry;
				obj2.prepare();
				obj2.execute((_error: any, result: any) => {
					if (_error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Data Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
				objv.execute();
			}
		});
	}

	public upload_media(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let sdata: any = req.body.data ? JSON.parse(req.body.data) : req.body;
				let mesg: any='';
				let fsize: any;
				if (!sdata.name) {
					mesg = 'Name is Required!';
				}
				if (!req.file) {
					mesg = 'File is Required!';
				}
				if (req.file) {
					let file_path = req.file.filename;
					let ext: any = file_path.split('.').pop();
					let extension: any = ext.toLowerCase();
					if (extension == 'mp3' || extension == 'wav' || extension == 'weba') {
						fsize = 1024 * 1024 * 10;
						mesg = 'File too Big, please select a file less than 10MB!'
					} else {
						mesg = 'Media File Type is Invalid. Please Choose Correct Audio File!'
					}
				}
				if (req.file.size <= fsize) {
					let file: any;
					let filePath: any = '';
					let dir = new UploadDirectory();
					const fileName = req.file.filename;
					filePath = dir.PLAYMEDIA + fileName;
					file = fileName;
					let mediaID: any = Math.random().toString(36).substring(2, 12);
					let obj = new ModelRawNonQuery(req, res);
					obj.nonqrysql = "INSERT INTO `upload_media`(`idaccount`,`iduser`,`uploaded_file`,`media_id`,`name`,`audio_play`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + file + "','" + mediaID + "','" + parseBody(sdata.name) + "','" + filePath + "')";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Media File Saved Successfully", data: { name: sdata.name, mediafileID: mediaID }, status: 200 });
							objv.execute();
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
							objv.execute();
						}
					});
				}
				else {
					let objv = new RawView(res);
					objv.prepare({ status: 400, message: mesg });
					objv.execute()
				}
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
				objv.execute();
			}
		})
	}

	public updateMediaFile(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessError: any, sessData: any) => {
			if (sessError == 1) {
				var sdata: any = JSON.parse(req.body.data);
				let file_path = req.file.filename
				let extension = file_path.split('.').pop();
				let fsize: any;
				let mesg: any;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `id_upload`,`idaccount`,`iduser`,`uploaded_file`,`media_id` FROM `upload_media` WHERE `id_upload` = '" + sdata.id_upload + "' AND `media_id`='" + sdata.media_id + "'";
				obj.prepare();
				obj.execute((errorq: any, result: any) => {
					if (errorq == 1) {
						if (result.length > 0) {
							if (extension == 'mp3' || extension == 'wav' || extension == 'weba') {
								fsize = 1024 * 740;
								mesg = 'File too Big, please select a file less than 740KB!'
							} else {
								mesg = 'Media File Type is Invalid. Please Choose Correct Audio File!'
							}
							if (req.file.size <= fsize) {
								let text: any;
								let file: any;
								text = sdata.body;
								if (req.file) {
									const fileName = req.file.filename;
									//file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
									file = 'https://mms.signalmash.com/content/' + fileName;
								}

								let obj = new ModelRawNonQuery(req, res);
								obj.nonqrysql = "UPDATE `upload_media` SET `uploaded_file`='" + file + "',`media_id`='" + result[0].media_id + "' , `updated_at`=NOW(), `file_path`= '" + file + "',`name`= '" + sdata.name + "' WHERE id_upload = '" + sdata.id_upload + "'";
								obj.prepare();
								obj.execute((error: any, result: any) => {
									if (error == 1) {
										let objv = new RawView(res);
										objv.prepare({ message: "Media File Updated Successfully!", data: result, status: 201 });
										objv.execute();
									}
									else {
										let objv = new RawView(res);
										objv.prepare({ message: "Something Went Wrong With Connection", status: 502, error: result });
										objv.execute();
									}
								})
							}
							else {
								let objv = new RawView(res);
								objv.prepare({ status: 400, message: mesg });
								objv.execute()
							}
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Media File is not Found!", status: 502, error: result });
							objv.execute();
						}
					}
					else {
						let objv = new Res406(res);
						objv.prepare(session);
						objv.execute();
					}
				});
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
				objv.execute();
			}
		})
	}

	public getMediaFile(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let sdata = req.query;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `id_upload`,`idaccount`,`name`,`iduser`,`uploaded_file`,`media_id`,`created_at`,`updated_at` FROM `upload_media` WHERE `id_upload` = '" + sdata.id_upload + "' AND `iduser`='" + sessData.iduser + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Media File Fetched", data: result, status: 200 })
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection", status: 503 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	public getMediaFiles(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `name`,`audio_play` as `audio`,`media_id` as `mediaID`,`created_at` as `created` FROM `upload_media` WHERE `iduser` = '" + sessData.iduser + "' AND `type`='0'";
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Media File Fetched", data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong with Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}


	public deleteMedia(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let sdata = req.query;
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "DELETE FROM `upload_media` WHERE `media_id`='" + sdata.mediaID + "' AND `iduser`='" + sessData.iduser + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Media File has been Deleted!", status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}
	
	public uploadMmsMedia(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let sdata: any = req.body.data ? JSON.parse(req.body.data) : req.body;
				let mesg: any = '', fsize: any;
				if (!sdata.name) {
					mesg = 'Name is Required!';
				}
				if (!req.file) {
					mesg = 'File is Required!';
				}
				if(mesg){
					let objv = new RawView(res);
					objv.prepare({ status: 400, message: mesg });
					objv.execute()
					return;
				}
				
				let ext : any ='', f:any;
				if (req.file) {
					f = req.file;					
					let file_path = req.file.filename;
					ext = file_path.split('.').pop();
					let extension: any = ext.toLowerCase();
					if (extension == 'mp3' || extension == 'wav' || extension == 'weba' || extension == 'mp4' || extension == 'mpeg' || extension == 'webm' || extension == 'pdf' || extension == 'gif' || extension == 'webp' || extension == 'jpeg' || extension == 'jpg' || extension == 'png') {
						fsize = 1024 * 1024;
						mesg = 'File too Big, please select a file less than 1MB!'
					} else {
						mesg = 'Media File Type is Invalid. Please Choose Correct Audio File!'
					}
				}
				if (f.size <= fsize) {
					let file: any;
					let dir = new UploadDirectory();
					let fileP: any = '';
					let filePath: any = '';
					const fileName = req.file.filename;
					fileP = dir.MMSMEDIAFILE + fileName ;
					filePath = dir.MMSUPLOADS + '/' +fileName ;
					file = fileName;
					let mediaID: any = Math.random().toString(36).substring(2, 12);
					let obj = new ModelRawNonQuery(req, res);
					obj.nonqrysql = "INSERT INTO `upload_media`(`idaccount`,`iduser`,`uploaded_file`,`file_path`,`media_id`,`name`,`audio_play`,`ext`,`type`,`file_size`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + file + "','" + filePath + "','" + mediaID + "','" + parseBody(sdata.name) + "','" + fileP + "','" + ext +"','1','"+ f.size +"')";
					obj.prepare();
					obj.execute((error: any, result: any) => {
						if (error == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Media File Uploaded Successfully", data: { name: sdata.name, mediafileID: mediaID }, status: 200 });
							objv.execute();
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Media File Not Uploaded Successfully!", status: 502 });
							objv.execute();
						}
					});
				}
				else {
					let objv = new RawView(res);
					objv.prepare({ status: 400, message: mesg });
					objv.execute()
				}
			}
			else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
				objv.execute();
			}
		})
	}
	
	public listMmsMedia(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let obj = new ModelRawQuery(req, res);						
				obj.qrysql = "SELECT `name`,`audio_play` as `file`,`ext` as `file_ext`,`media_id` as `mediaID`,`created_at` as `created` FROM `upload_media` WHERE `type`='1' AND `idaccount`='" + sessData.idaccount + "'";		
				obj.prepare();
				obj.execute((err: any, result: any) => {
					if (err == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Media File Fetched", data: result, status: 200 });
						objv.execute();
					} else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong with Connection!", status: 502 });
						objv.execute();
					}
				})
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}

	public listAllMMSmedia(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				if (sessData.type == 1) {
					let obj = new ModelRawQuery(req, res);
					obj.qrysql = "SELECT `idaccount`,`name`,`audio_play` as `file`,`ext` as `file_ext`,`media_id` as `mediaID`,`created_at` as `created` FROM `upload_media` WHERE `type` = '1'";
					obj.prepare();
					obj.execute((err: any, result: any) => {
						if (err == 1) {
							let objv = new RawView(res);
							objv.prepare({ message: "Media File Fetched", data: result, status: 200 });
							objv.execute();
						} else {
							let objv = new RawView(res);
							objv.prepare({ message: "Something Went Wrong with Connection!", status: 502 });
							objv.execute();
						}
					})
				} else {
					let objvb = new RawView(res);
					objvb.prepare({ message: "Service Unavailable!", status: 503 });
					objvb.execute();
				}
			} else {
				let objv = new RawView(res);
				objv.prepare({ message: "Invalid Authorization!", status: 401 });
				objv.execute();
			}
		});
	}

	public getMmsMediaFileDetail(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let sdata = req.query;
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `name`,`audio_play` as `file`,`ext` as `file_ext`,`media_id` as `mediaID`,`created_at` as `created` FROM `upload_media` WHERE `media_id` = '" + sdata.mediaID + "' AND `idaccount`='" + sessData.idaccount + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						if(result.length > 0){
							let objv = new RawView(res);
							objv.prepare({ message: "Media File Fetched.", data: result, status: 200 })
							objv.execute();
						}
						else{
							let objv = new RawView(res);
							objv.prepare({ message: "No Media File Available.", data: result, status: 502 })
							objv.execute();
						}						
					} 
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection", status: 503 });
						objv.execute();
					}
				})
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	
	public deleteMMSMedia(req: Request, res: Response, next: NextFunction) {
		let session = new SessionManagment(req, res, next);
		session.GetSession((sessErr: any, sessData: any) => {
			if (sessErr == 1) {
				let sdata = req.query;
				let obj = new ModelRawNonQuery(req, res);
				obj.nonqrysql = "DELETE FROM `upload_media` WHERE `media_id`='" + sdata.mediaID + "' AND `iduser`='" + sessData.iduser + "'";
				obj.prepare();
				obj.execute((error: any, result: any) => {
					if (error == 1) {
						let objv = new RawView(res);
						objv.prepare({ message: "Media File has been Deleted!", status: 201 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
						objv.execute();
					}
				});
			} else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}

	saveCountry(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var pdata: any = [];
                pdata = req.body;
				let iQry:any = "INSERT INTO tbl_country_list (`name`, `code`) VALUES";
                pdata.forEach((element: any) => {
                    iQry += "('" + parseBody(element.name) + "', '" + (element.code) + "'),";                    
                });
				let obj2 = new ModelRawNonQuery(req, res);
				obj2.nonqrysql = iQry.slice(0, -1);
				obj2.prepare();
				obj2.execute((_error: any, _result: any) => {
					let objv = new RawView(res);
					objv.prepare({status: 200, message: "Country Saved Successfully!"});
					objv.execute();
				});                
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
	getCountry(req: Request, res: Response, next: NextFunction){
		let session = new SessionManagment(req, res, next);
		session.GetSession((error:any, sessdata:any)=>{
			if (error == 1) {
				let obj = new ModelRawQuery(req, res);
				obj.qrysql = "SELECT `name`,`code`,`corporation_or_limited_liability_company_only_us`,`sole_proprietor_or_individual`,`international_business_none_us`,`none_profit_501c` FROM `tbl_country_list` WHERE visible_status='1' ORDER BY country_id ASC";
				obj.prepare();
				obj.execute((_error: any, result: any) => {
					if (_error == 1 && result.length > 0) {
						let objv = new RawView(res);
						objv.prepare({ message: "Country List Fetched Successfully!", data: result, status: 200 });
						objv.execute();
					}
					else {
						let objv = new RawView(res);
						objv.prepare({ message: "Country List Not Fetched!", status: 502 });
						objv.execute();
					}
				});
			}
			else {
				let objv = new Res406(res);
				objv.prepare(session);
				objv.execute();
			}
		})
	}
}