const Str = require('@supercharge/strings');
const jwt = require('jsonwebtoken');
const { networkInterfaces } = require('os');
// const checkDesc = (desc: any) => {
//     let result: any = '';
//     if (desc) {
//         result = desc.replace(/"/g, '\\"').replace(/'/g, "\\'");
//         return result;
//     } else {
//         result = '';
//         return result;
//     }
// }
const parseBody = (desc: any): string => {
    let result = '';
    if (desc) {
        result = desc
            .replace(/\\/g, '\\\\')
            .replace(/"/g, '\\"')
            .replace(/'/g, "\\'");
    }
    return result;
};
const isNumber = (num: any) => {
    let result: any = '';
    let number: any = num ? num : 0;
    if (isNaN(number) == false && typeof parseInt(number) == "number") {
        result = number
        console.log("result :: ", result);
        return result;
    }
    else {
        result = 'NaN';
        console.log("result :: ", result);
        return result;
    }
}
const ipAddressAndBrowser = (req: any) => {
    /* login history Create  Token */
    let secret = Str.random(15);
    let Token = jwt.sign({
        exp: Math.floor(Date.now() / 1000),
    }, secret);

    //To Get ipaddress
    const nets = networkInterfaces();
    const ipAddress: any = [];
    for (const name of Object.keys(nets)) {
        for (const net of nets[name]) {
            const familyV4Value = typeof net.family === 'string' ? 'IPv4' : 4
            if (net.family === familyV4Value && !net.internal) {
                ipAddress.push(net.address);
            }
        }
    }
    /*To Get Browser Name */
    const userAgentString = req.headers['user-agent']
    const userAgent: any = userAgentString;
    let browserName = 'unknown';

    if (userAgent?.includes('Safari')) {
        browserName = 'Safari'
    }
    if (userAgent?.includes('Chrome')) {
        browserName = 'Google Chrome'
    }
    if (userAgent?.includes('Edg')) {
        browserName = 'Microsoft Edge'
    }
    if (userAgent?.includes('OPR')) {
        browserName = 'Opera'
    }
    if (userAgent?.includes('msie')) {
        browserName = 'Internet Explorer'
    }
    if (userAgent?.includes('Firefox')) {
        browserName = 'Firefox'
    }
    let sysInfo = {
        ipAddress: [req.headers['x-forwarded-for'] || req.socket.remoteAddress],
        browserName: browserName, uniqueToken: Token
    }
    return sysInfo;

}

//export default checkDesc
export default parseBody
export {isNumber, ipAddressAndBrowser, parseBody };

