
import { Request, Response, NextFunction, response } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { ThinQAPI } from "./ThinQ";
import { InteliquentAPI } from "./Inteliquent";
import { CoreTelAPI } from "./CoreTel";
import { OsrApi } from "./Osr";
import { TeleAPI } from "./TeleApi";
import { Res404 } from "../lib/view/404";
import md5 from "md5";
import { PeerlessAPI } from "./Peerless";
import { SinchApi } from "./SinchSubmitNumber";
import { LergApi } from "./lrnApi";
import { isNumber } from "./markError";
import { APIBase } from "./APIBase";
import { Importnumber } from "./Importnumber";

let request = require('request');
const fs = require('fs');
const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
/* const devurl = 'http://osrdev-e1.netnumber.net:84/osr/v2/entries/';
const myip = "iplink";
const nnid = "104141";
let email = "noc@nglcom.com"
let password = "xUxCyLwd" */
let getrate = new APIBase();

export class Number extends AppRoute {
    constructor() {
        super();
    }

    public SearchByNpxNaa(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let sdata = req.query;
                    /* let npa:any = sdata.NPA,nxx:any = sdata.NXX,qty:any = sdata.Qty
                    if(isNaN(npa)===true || (nxx && isNaN(nxx)===true) || isNaN(qty)===true){
                        let objv = new RawView(res);
                        objv.prepare({ status: 504, message: "Please enter a valid number. The number format is not correct!" });
                        objv.execute();
                        return;
                    } */
                    if (sdata.NPA && sdata.Qty) {
                        let key = md5(sessdata.authkey + (new Date()));
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority`, u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            console.log("responce :: ", responce);
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                    responce.forEach((ele: any) => {
                                        if (ele.username == "thinq")
                                            index_thinq = ele.priority;
                                        if (ele.username == "inteliquent")
                                            index_intel = ele.priority;
                                        if (ele.username == "teleapi")
                                            index_teleapi = ele.priority;
                                        if (ele.username == "Coretel")
                                            index_coretel = ele.priority;
                                        if (ele.username == "Peerless")
                                            index_peerless = ele.priority;
                                    });
                                    console.log({
                                        "index_thinq": index_thinq,
                                        "index_intel": index_intel,
                                        "index_teleapi": index_teleapi,
                                        "index_coretel": index_coretel,
                                        "index_peerless": index_peerless
                                    })
                                    let thinq = new ThinQAPI(index_thinq, sessdata, key);
                                    thinq.getNpaNxx(req, res, (err1, res1) => {
                                        let intel = new InteliquentAPI(index_intel, sessdata, key);
                                        intel.getNpaNxx(req, res, (err2, res2) => {
                                            let tele = new TeleAPI(index_teleapi, sessdata, key);
                                            tele.getNpaNxx(req, res, (err3, res3) => {
                                                let peer = new PeerlessAPI(index_peerless, sessdata, key);
                                                peer.getNpaNxx(req, res, (err4, res4) => {
                                                    let obj2 = new ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT `phone_number`, `rate_center`, `state`,`supplier_tier` FROM `did_search` where `iduser`='" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number` LIMIT " + sdata.Qty;
                                                    obj2.prepare();
                                                    obj2.execute((err_result, res_result) => {
                                                        if (err_result == 1) {
                                                            if (res_result.length > 0) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 404, message: "No DID's found on [" + sdata.NPA + "]" });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                })
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new Res404(res);
                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new Res404(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 500, message: "All field are required,NPA,Qty" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public SearchByRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let sdata = req.query;
                    if (sdata.RateCenter && sdata.State && sdata.Qty) {
                        const str1 = req.query.NPA;
                        const str2 = req.query.NXX;
                        var sdata1 = str1 + "" + str2;
                        let key = md5(sessdata.authkey + (new Date()));
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            console.log("responce", responce);
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                    responce.forEach((ele: any) => {
                                        console.log("ele", ele);
                                        if (ele.username == "thinq")
                                            index_thinq = ele.priority;
                                        if (ele.username == "inteliquent")
                                            index_intel = ele.priority;
                                        if (ele.username == "teleapi")
                                            index_teleapi = ele.priority;
                                        if (ele.username == "Coretel")
                                            index_coretel = ele.priority;
                                        if (ele.username == "Peerless")
                                            index_peerless = ele.priority;
                                    });
                                    console.log({
                                        "index_thinq": index_thinq,
                                        "index_intel": index_intel,
                                        "index_teleapi": index_teleapi,
                                        "index_coretel": index_coretel,
                                        "index_peerless": index_peerless
                                    })
                                    let thinq = new ThinQAPI(index_thinq, sessdata, key);
                                    thinq.getByRate(req, res, (err1, res1) => {
                                        let intel = new InteliquentAPI(index_intel, sessdata, key);
                                        intel.getByRate(req, res, (err2, res2) => {
                                            let tele = new TeleAPI(index_teleapi, sessdata, key);
                                            tele.getByRate(req, res, (err2, res2) => {
                                                let peer = new PeerlessAPI(index_peerless, sessdata, key);
                                                peer.getByRate(req, res, (err4, res4) => {
                                                    let obj2 = new ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT  `phone_number`, `rate_center`, `state`, `supplier_tier` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number` LIMIT " + sdata.Qty;
                                                    obj2.prepare();
                                                    obj2.execute((err_result, res_result) => {
                                                        if (err_result == 1) {
                                                            if (res_result.length > 0) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 404, message: "No DID's found on [" + sdata.RateCenter + "]" });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: " Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new Res404(res);
                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: " Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 500, message: "All field are required,RateCenter,State,Qty" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public SearchTolefree(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let sdata = req.query;
                    //sdata.TF_PREFIX 
                    let msg = ''
                    if (!sdata.quantity) {
                        msg = "Quantity is Required";
                    }
                    if (!sdata.tnMask1 && !sdata.wildcard) {
                        msg = "TF Number is Required";
                    }
                    if ((sdata.tnMask1 || sdata.wildcard) && sdata.quantity) {
                        let key = md5(sessdata.authkey + (new Date()));
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                        obj1.prepare();
                        obj1.execute((error, responce) => {
                            console.log(responce);
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                    responce.forEach((ele: any) => {
                                        if (ele.username == "thinq")
                                            index_thinq = ele.priority;
                                        if (ele.username == "inteliquent")
                                            index_intel = ele.priority;
                                        if (ele.username == "teleapi")
                                            index_teleapi = ele.priority;
                                        if (ele.username == "Coretel")
                                            index_coretel = ele.priority;
                                        if (ele.username == "Peerless")
                                            index_peerless = ele.priority;
                                    });
                                    console.log({
                                        "index_thinq": index_thinq,
                                        "index_intel": index_intel,
                                        "index_teleapi": index_teleapi,
                                        "index_coretel": index_coretel,
                                        "index_peerless": index_peerless
                                    })
                                    let thinq = new ThinQAPI(index_thinq, sessdata, key);
                                    thinq.getTollFree(req, res, (err1, res1) => {
                                        let intel = new InteliquentAPI(index_intel, sessdata, key);
                                        intel.getTollFree(req, res, (err2, res2) => {
                                            let tele = new TeleAPI(index_teleapi, sessdata, key);
                                            tele.getTollFree(req, res, (err2, res2) => {
                                                let peer = new PeerlessAPI(index_peerless, sessdata, key);
                                                peer.getTollFree(req, res, (err3, res3) => {
                                                    let obj2 = new ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT  `phone_number`, `provider` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                    obj2.prepare();
                                                    obj2.execute((err_result, res_result) => {
                                                        if (err_result == 1) {
                                                            if (res_result.length > 0) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 404, message: "No DID's found!" });
                                                                objv.execute();
                                                            }
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                })
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new Res404(res);
                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 500, message: msg });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session data there");
                objv.execute();
            }
        });
    }

    public tfRequest(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;
                let checkService = new APIBase();
                checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                    if (resp.status == 200) {
                        //sdata.TF_PREFIX 
                        if (sdata.cdata.Qty) {
                            if (sessdata.type == 2 || sessdata.type == 22) {
                                let key = md5(sessdata.authkey + (new Date()));
                                let obj1 = new ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                                obj1.prepare();
                                obj1.execute((error, responce) => {
                                    if (error == 1) {
                                        if (responce.length > 0) {
                                            let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                            responce.forEach((ele: any) => {
                                                if (ele.username == "thinq")
                                                    index_thinq = ele.priority;
                                                if (ele.username == "inteliquent")
                                                    index_intel = ele.priority;
                                                if (ele.username == "teleapi")
                                                    index_teleapi = ele.priority;
                                                if (ele.username == "Coretel")
                                                    index_coretel = ele.priority;
                                                if (ele.username == "Peerless")
                                                    index_peerless = ele.priority;
                                            });
                                            console.log({
                                                "index_thinq": index_thinq,
                                                "index_intel": index_intel,
                                                "index_teleapi": index_teleapi,
                                                "index_coretel": index_coretel,
                                                "index_peerless": index_peerless
                                            })
                                            // let thinq = new ThinQAPI(index_thinq, sessdata, key);
                                            // thinq.tfRequest(req, res, (err1, res1) => {
                                            let intel = new InteliquentAPI(index_intel, sessdata, key);
                                            intel.tfRequest(req, res, (err2, res2) => {
                                                // let tele = new TeleAPI(index_teleapi, sessdata, key);
                                                // tele.tfRequest(req, res, (err2, res2) => {
                                                // let peer = new PeerlessAPI(index_peerless, sessdata, key);
                                                // peer.tfRequest(req, res, (err3, res3) => {
                                                let obj2 = new ModelRawQuery(req, res);
                                                obj2.qrysql = "SELECT  `phone_number`, `provider` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                obj2.prepare();
                                                obj2.execute((err_result, res_result) => {
                                                    if (err_result == 1) {
                                                        if (res_result.length > 0) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                            objv.execute();
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 404, message: "No DID's found!" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                        objv.execute();
                                                    }
                                                });
                                                // })
                                                //});
                                            });
                                            //});
                                        }
                                        else {
                                            let objv = new Res404(res);
                                            objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 404, message: "Not Permitted" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 500, message: "Quantity is Required!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error_code: err,
                            status: resp.status,
                            message: resp.message.replace(/::SN::/g, "DID Buy")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session data there");
                objv.execute();
            }
        });
    }

    public PurchaseDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let checkService = new APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                        if (resp.status == 200) {
                            const sdata = req.body;
                            let via_panel: number = (typeof sdata.via_panel != 'undefined' && sdata.via_panel > 0) ? sdata.via_panel : 0;
                            if (sdata.DID) {
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "SELECT `provider`, `rates`, `type` FROM `did_search` WHERE `iduser`='" + sessdata.iduser + "' AND `phone_number`='" + sdata.DID.trim() + "'";
                                obj.prepare();
                                obj.execute((error: any, responce: any) => {
                                    if (error == 1) {
                                        if (responce.length > 0) {
                                            let obj5 = new ModelRawQuery(req, res);
                                            obj5.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + responce[0].rates + "'";
                                            obj5.prepare();
                                            obj5.execute((walletError: any, wallet: any) => {
                                                if (walletError == 1) {
                                                    if (wallet.length > 0) {

                                                        // To create the group_order for external customers
                                                        let DIDM: any = new DIDManager()

                                                        // Payload of group order
                                                        let payLoad: any = {
                                                            via_panel: via_panel,
                                                            numbers: sdata.DID.toString(),
                                                            routing: sdata.Connection,
                                                            in_routing: sdata.InboundVoice,
                                                            out_routing: sdata.OutboundVoice,
                                                            campaign: sdata.CampaignId
                                                        }

                                                        DIDM.CreateGroupOrder(req, res, sessdata, payLoad, (error: any, result: any) => {
                                                            if (error == 1) {
                                                                let id_grouporder: number = result.id_grouporder

                                                                // To update the process count of group order
                                                                let obj = new ModelRawNonQuery(req, res)
                                                                obj.nonqrysql = "UPDATE `did_group_order` SET `is_process`=1 WHERE `id_grouporder`=" + id_grouporder + ";"
                                                                obj.prepare()
                                                                obj.execute((error, result) => {
                                                                    console.log("GroupOrder process count::\n", result)
                                                                })

                                                                let other_data: any = {
                                                                    id_grouporder: id_grouporder
                                                                }

                                                                // Thinq provider
                                                                if (responce[0].provider == "thinQ") {
                                                                    console.log("Going to :::: thinQ");
                                                                    let thinq = new ThinQAPI("", sessdata, '');
                                                                    thinq.buyDID(req, res, responce, other_data, (err, resp) => { });
                                                                }

                                                                // Intelliquent provider
                                                                else if (responce[0].provider == "inteliQ") {
                                                                    console.log("Going to :::: inteliQ");
                                                                    let intel = new InteliquentAPI("", sessdata, '');
                                                                    intel.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                                }

                                                                // TeleAPI provider
                                                                else if (responce[0].provider == "teleapi") {
                                                                    console.log("Going to :::: teleapi");
                                                                    let tele = new TeleAPI("", sessdata, '');
                                                                    tele.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                                }

                                                                // Peerless provider
                                                                else if (responce[0].provider == "Peerless") {
                                                                    console.log("Going to :::: Peerless");
                                                                    let peer = new PeerlessAPI("", sessdata, '');
                                                                    peer.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                                }

                                                                // CoreTelAPI provider
                                                                else {
                                                                    console.log("Going to :::: CoreTelAPI");
                                                                    let coretel = new CoreTelAPI("", sessdata);
                                                                    coretel.buyDID(req, res, responce, other_data, (error, responce) => {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({
                                                                            error_code: 0,
                                                                            status: 404,
                                                                            message: "Invalid DID provider!"
                                                                        });
                                                                        objv.execute();
                                                                    })
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    error_code: 0,
                                                                    error: result,
                                                                    message: "Something Went Wrong With Connection!",
                                                                    status: 502
                                                                });
                                                                objv.execute();
                                                            }
                                                        })
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            error_code: 0,
                                                            error: wallet,
                                                            message: "Please add funds to your account or contact support.",
                                                            status: 503
                                                        });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        error_code: 0,
                                                        error: wallet,
                                                        message: "Something Went Wrong to Fetch Account Balance!",
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                error_code: 0,
                                                status: 404,
                                                message: "Did Not Available"
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            error_code: 0,
                                            status: 502,
                                            message: "Something went wrong with connection!"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    error_code: 0,
                                    status: 500,
                                    message: "DID are required!"
                                });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({
                        error_code: 0,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public EnableSMS(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.body;
                if (sdata.DID && sdata.CampaignId) {
                    let iduser: any = sdata.iduser ? sdata.iduser : sessdata.iduser;
                    let idaccount: any = sdata.idaccount ? sdata.idaccount : sessdata.idaccount;
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND `iduser` = '" + iduser + "' GROUP BY campaign_key";
                    obj1.prepare();
                    obj1.execute((error: any, camp_res: any) => {
                        if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                            if (camp_res[0].did_count >= camp_res[0].did_limit) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "You can enable only [" + camp_res[0].did_limit + "] DID's in this Campaign" });
                                objv.execute();
                            }
                            else {
                                let objh = new ModelRawQuery(req, res);
                                objh.qrysql = "SELECT did, camp_registry, sms_provider, provider,osr_status,sinch_status,type FROM did_buy WHERE iduser = '" + iduser + "' AND did = '" + sdata.DID.trim() + "' GROUP BY did";
                                objh.prepare();
                                objh.execute((error: any, responce: any) => {
                                    if (error == 1 && responce.length > 0) {
                                        let category: any = responce[0].type == 'NN' || responce[0].type == 'INN' ? 'NN' : 'TF';
                                        if (category == 'NN') {
                                            // if osr_status='register' and sinch_status='0'
                                            if (responce[0].osr_status == 'register' && responce[0].osr_status !== '' && (responce[0].sinch_status == '0' || responce[0].sinch_status == '' || responce[0].sinch_status == null || responce[0].sinch_status == undefined || responce[0].sinch_status == 'null' || responce[0].sinch_status == 'undefined')) {
                                                console.log("condition >>::::>> if sinch_status='0' and osr_status='register'");
                                                if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                let sinch = new SinchApi('', sessdata);
                                                sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                    if (errorr == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 200, message: resp.message });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: resp.message });
                                                        objv.execute();
                                                    }
                                                });
                                                } else {
                                                    let sinch = new SinchApi('', sessdata);
                                                    sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                        if (errorr == 1) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 200, message: resp.message });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: resp.message });
                                                            objv.execute();
                                                        }
                                                    });
                                                }


                                            } 
                                            // if osr_status == 'unregister' and responce[0].sinch_status == '0'
                                            else if ((responce[0].osr_status == 'unregister' || responce[0].osr_status == '' || responce[0].osr_status == null || responce[0].osr_status == 'null' || responce[0].osr_status == undefined || responce[0].osr_status == 'undefined') && (responce[0].sinch_status == '0' || responce[0].sinch_status == '' || responce[0].sinch_status == null || responce[0].sinch_status == undefined || responce[0].sinch_status == 'null' || responce[0].sinch_status == 'undefined')) {
                                                console.log("condition >>::::>> if osr_status == 'unregister' and sinch_status == '0'");
                                                let rate = new APIBase();
                                                rate.getMessageRate(req, res, sessdata.idtariff, "message_activation", category, (err, message_rate) => {
                                                    if (err == 1) {

                                                        let nrcMsgRate:any = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0, 
                                                        mrcMsgRate:any = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;

                                                        let obj1 = new ModelRawQuery(req, res);
                                                        obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + idaccount + "' AND `balance` + `credit_limit` >= '" + nrcMsgRate + "'"
                                                        obj1.prepare();
                                                        obj1.execute((walletError: any, wallet: any) => {
                                                            if (walletError == 1 && wallet.length > 0) {

                                                                let obj0 = new ModelRawQuery(req, res);
                                                                obj0.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                                                                obj0.prepare();
                                                                obj0.execute((camperr: any, campres: any) => {

                                                                    if (camperr == 1 && campres.length > 0) {

                                                                        if (camp_res[0].did_limit > camp_res[0].did_count) {
                                                                            if (responce[0].provider == "inteliQ" || responce[0].provider == "thinQ" || responce[0].provider == "Peerless" || responce[0].provider == 'Importnumber') {
                                                                                let did = sdata.DID;
                                                                                let len = did.length - 10;
                                                                                let number = did.slice(len, did.length);
                                                                                let number1 = "+1" + number;
                                                                                let options = {
                                                                                    'method': 'PUT',
                                                                                    'url': produrl + "" + `${number1}`,
                                                                                    'headers': {
                                                                                        'Content-Type': 'application/json'
                                                                                    },
                                                                                    body: '{ id: "' + campres[0].myip + '", nnid:"' + campres[0].nnid + '" , "context": "A2P", "campaign_id": "' + sdata.CampaignId + '" }'
                                                                                };
                                                                                request(options, (error: any, response: any) => {
                                                                                    if (!error) {
                                                                                        try{
                                                                                            let data = JSON.parse(response.body);
                                                                                            let __tn: any = typeof data.tn != 'undefined' ? data.tn : ''
                                                                                            let __message: any = typeof data.message != 'undefined' ? data.message : ''
                                                                                            let __campaign_id: any = typeof data.campaign_id != 'undefined' ? data.campaign_id : ''
                                                                                            let rDt: any = {
                                                                                                tn: __tn,
                                                                                                message: __message,
                                                                                                campaign_id: __campaign_id
                                                                                            }
                                                                                            if (data.message == "Success") {
                                                                                                if(nrcMsgRate > 0){
                                                                                                    // To deduct SMS Enable charges
                                                                                                    let objv = new ModelRawNonQuery(req, res);
                                                                                                    objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + nrcMsgRate + " WHERE `idaccount`='" + idaccount + "'"
                                                                                                    objv.prepare();
                                                                                                    objv.execute((wallet_error, wallet_success) => {
                                                                                                        if (wallet_error == 1) {
                                                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                                                            objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount successfully updated for EnableSMS', `status`=1"
                                                                                                            objWL.prepare()
                                                                                                            objWL.execute((error: any, result: any) => {
                                                                                                                console.log("Wallet amount successfully updated for EnableSMS :: ",nrcMsgRate);
                                                                                                            });
                                                                                                        }
                                                                                                        else {
                                                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                                                            objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount not updated for EnableSMS', `status`=2"
                                                                                                            objWL.prepare()
                                                                                                            objWL.execute((error: any, result: any) => { 
                                                                                                                console.log("Wallet amount not updated for EnableSMS :: ",nrcMsgRate);
                                                                                                            });
                                                                                                        }
                                                                                                    });

                                                                                                    // To Insert nrc
                                                                                                    let obj4 = new ModelRawNonQuery(req, res);
                                                                                                    obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + iduser + "','" + idaccount + "','" + number + "','"+nrcMsgRate+"')";
                                                                                                    obj4.prepare();
                                                                                                    obj4.execute((osr_err, resp) => {
                                                                                                        console.log("SMS Enabled Charges Log Inserted :: ", nrcMsgRate);
                                                                                                    });
                                                                                                }

                                                                                                let obj2 = new ModelRawNonQuery(req, res);
                                                                                                obj2.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` + 1  WHERE `iduser` = '" + iduser + "' AND `campaign_key` = '" + sdata.CampaignId + "'";
                                                                                                obj2.prepare();
                                                                                                obj2.execute((osr_errrr, resppp) => {
                                                                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                                                                    obj3.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "', `sms_mrc`='"+mrcMsgRate+"' WHERE `iduser` = '" + iduser + "' AND `did`='" + number + "'";
                                                                                                    obj3.prepare();
                                                                                                    obj3.execute((osr_err, resp) => {
                                                                                                        if (osr_err == 1) {
                                                                                                            if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                                let sinch = new SinchApi('', sessdata);
                                                                                                                sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                                                                    if (errorr == 1) {
                                                                                                                        let objv = new RawView(res);
                                                                                                                        objv.prepare({ status: 200, message: resp.message });
                                                                                                                        objv.execute();
                                                                                                                    }
                                                                                                                    else {
                                                                                                                        let objv = new RawView(res);
                                                                                                                        objv.prepare({ status: 502, message: resp.message });
                                                                                                                        objv.execute();
                                                                                                                    }
                                                                                                                });
                                                                                                            }
                                                                                                            else {
                                                                                                                let sinch = new SinchApi('', sessdata);
                                                                                                                sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                                                                    if (errorr == 1) {
                                                                                                                        let objv = new RawView(res);
                                                                                                                        objv.prepare({ status: 200, message: resp.message });
                                                                                                                        objv.execute();
                                                                                                                    }
                                                                                                                    else {
                                                                                                                        let objv = new RawView(res);
                                                                                                                        objv.prepare({ status: 502, message: resp.message });
                                                                                                                        objv.execute();
                                                                                                                    }
                                                                                                                });
                                                                                                            }
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView(res);
                                                                                                            objv.prepare({ status: 502, message: "SMS is not enabled!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        let obj6 = new ModelRawNonQuery(req, res);
                                                                                                        obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'6','DID provisioned to OSR','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                                        obj6.prepare();
                                                                                                        obj6.execute((er, ins_result) => {
                                                                                                            console.log("DID Log Inserted.");
                                                                                                        });
                                                                                                    });
                                                                                                });
                                                                                            }
                                                                                            else {
                                                                                                console.log("condition >>::::>> if osr_status == 'unregister' and need to enable from sinch");
                                                                                                let obj8 = new ModelRawNonQuery(req, res);
                                                                                                obj8.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "' WHERE `iduser` = '" + iduser + "' AND `did`='" + number + "'";
                                                                                                obj8.prepare();
                                                                                                obj8.execute((osr_failed, resp) => {
                                                                                                    if (osr_failed == 1) {
                                                                                                        if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                            let sinch = new SinchApi('', sessdata);
                                                                                                            sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                                                                if (errorr == 1) {
                                                                                                                    let objv = new RawView(res);
                                                                                                                    objv.prepare({ status: 200, message: resp.message });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                                else {
                                                                                                                    let objv = new RawView(res);
                                                                                                                    objv.prepare({ status: 502, message: resp.message });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                            });
                                                                                                        }
                                                                                                        else {
                                                                                                            let sinch = new SinchApi('', sessdata);
                                                                                                            sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                                                                if (errorr == 1) {
                                                                                                                    let objv = new RawView(res);
                                                                                                                    objv.prepare({ status: 200, message: resp.message });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                                else {
                                                                                                                    let objv = new RawView(res);
                                                                                                                    objv.prepare({ status: 502, message: resp.message });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                            });
                                                                                                        }
                                                                                                    }
                                                                                                    else {
                                                                                                        let objv = new RawView(res);
                                                                                                        objv.prepare({ status: 502, message: "SMS is not enabled!" });
                                                                                                        objv.execute();
                                                                                                    }
                                                                                                });

                                                                                                let obj7 = new ModelRawNonQuery(req, res);
                                                                                                obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'12','OSR provisioning failed','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                                obj7.prepare();
                                                                                                obj7.execute((er, ins_result) => {
                                                                                                    console.log("DID Log Inserted.");
                                                                                                });
                                                                                            }
                                                                                        }
                                                                                        catch(e){
                                                                                            let obj = new RawView(res);
                                                                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                                            obj.execute();
                                                                                        }
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ status: 400, error: error, message: "Something went wrong with Enable SMS!" });
                                                                                        objv.execute()
                                                                                    }
                                                                                });
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ status: 404, message: "Invalid Provider!" });
                                                                                objv.execute();
                                                                            }
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ status: 404, message: "Maximum DID limit completed. You have already " + camp_res[0].did_count + " DID enabled in this campaign!" });
                                                                            objv.execute();
                                                                        }
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                                                        objv.execute();
                                                                    }
                                                                });

                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    error_code: 0,
                                                                    error: wallet,
                                                                    message: "Please add funds to your account or contact support.",
                                                                    status: 503
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    } 
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Rates Setting Invalid!" });
                                                        objv.execute();
                                                    }
                                                });                                            

                                            }
                                            else {
                                                console.log("condition >>::::>> if osr_status == 'register' and sinch_status == '1'");
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 208, message: "SMS Service [" + responce[0].camp_registry + "] is Already Enabled on this DID [" + responce[0].did + "]!" });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Service Unavailable!" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 404, message: "DID Not Found!" });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: "This Campaign is not approved yet.Please try with another one!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "All fields are required, DID, CampaignId" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public reProvisioningSMS(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.body;
                if (sdata.DID && sdata.CampaignId) {
                    let iduser: any = sdata.iduser ? sdata.iduser : sessdata.iduser;
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND `iduser` = '" + iduser + "' GROUP BY campaign_key";
                    obj1.prepare();
                    obj1.execute((error: any, camp_res: any) => {
                        if (error == 1 && camp_res.length > 0) {
                            let objh = new ModelRawQuery(req, res);
                            objh.qrysql = "SELECT did, camp_registry, sms_provider, provider FROM did_buy WHERE iduser = '" + iduser + "' AND did = '" + sdata.DID.trim() + "' GROUP BY did";
                            objh.prepare();
                            objh.execute((error: any, responce: any) => {
                                if (error == 1 && responce.length > 0) {
                                    if (camp_res[0].upstreamCnpId == 'SINCH') {
                                        let sinch = new SinchApi('', sessdata);
                                        sinch.reProvisioningToSinch(req, res, (errorr, resp) => {
                                        });
                                    } else {
                                        let sinch = new SinchApi('', sessdata);
                                        sinch.reEnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                            if (errorr == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 200, message: resp.message });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 502, message: resp.message });
                                                objv.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 404, message: "DID Not Found!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: "Campaign Expired!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "All fields are required, DID, CampaignId" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();

            }
        });
    }

    public DisconnectDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22) {
                    const sdata = req.body;
                    if (sdata.DID) {
                        let iduser: number = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : sessdata.iduser;
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT provider, did_disconnect_days, DATEDIFF(NOW(), `created_at`) AS remaining_days FROM `did_buy` WHERE `did`='" + sdata.DID + "' AND `iduser`='" + iduser + "'"
                        obj.prepare();
                        obj.execute((error: any, responce: any) => {
                            if (error == 1) {
                                if (responce.length > 0) {
                                    if (responce[0].remaining_days >= responce[0].did_disconnect_days) {
                                        // Thinq provider
                                        if (responce[0].provider == "thinQ") {
                                            console.log("Going to :::: thinQ");
                                            let thinq = new ThinQAPI("", sessdata, '');
                                            thinq.disconnectDID(req, res, (error, responce) => { });
                                        }

                                        // Intelliquent provider
                                        else if (responce[0].provider == "inteliQ") {
                                            console.log("Going to :::: inteliQ");
                                            let intel = new InteliquentAPI("", sessdata, '');
                                            intel.disconnectDID(req, res, (error, responce) => { });
                                        }

                                        // TeleAPI provider
                                        else if (responce[0].provider == "teleapi") {
                                            console.log("Going to :::: teleapi");
                                            let tele = new TeleAPI("", sessdata, '');
                                            tele.disconnectDID(req, res, (error, responce) => { });
                                        }

                                        // Peerless provider
                                        else if (responce[0].provider == "Peerless") {
                                            console.log("Going to :::: Peerless");
                                            let peer = new PeerlessAPI("", sessdata, '');
                                            peer.disconnectDID(req, res, (error, responce) => { });
                                        }

                                        // Imported number provider
                                        else if (responce[0].provider == "Importnumber") {
                                            console.log("Going to :::: Import NUmber");
                                            let impNum = new Importnumber(sessdata);
                                            impNum.disconnectDID(req, res, (error, responce) => { });
                                        }

                                        // CoreTelAPI provider
                                        else {
                                            console.log("Going to :::: CoreTelAPI");
                                            let coretel = new CoreTelAPI("", sessdata);
                                            coretel.disconnectDID(req, res, (error, responce) => { })
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 417, message: responce[0].remaining_days + " days left for this DID So you can not disconnect Did from this Account" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 404, message: "DID Not Available" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 500, message: "DID are required" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted " });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    disconnectSelectedDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            var disDID: any = [];
            disDID.length = 0;
            disDID.splice(0, disDID.length);

            var disDIDid: any = [];
            disDIDid.length = 0;
            disDIDid.splice(0, disDIDid.length);

            var notdisDID: any = [];
            notdisDID.length = 0;
            notdisDID.splice(0, notdisDID.length);

            var notdisDIDid: any = [];
            notdisDIDid.length = 0;
            notdisDIDid.splice(0, notdisDIDid.length);
            let arrStr: any = '';
            let TotalDays: any;

            if (err == 1) {
                let sdata: any = req.body.data;
                let inc = 0;
                let DIDIds: any = [];
                let DIDIM: any = [];
                for (let x of sdata) {
                    if (x.type == 'INN' || x.type == 'ITF') {
                        DIDIM.push(x.iddid)
                    } else {
                        DIDIds.push(x.iddid)
                    }

                }
                if (DIDIds.length > 0) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT t.day_num,d.iddid,d.created_at,d.did FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid IN(" + DIDIds + ")";

                    obj1.prepare();
                    obj1.execute((errday: any, resday: any) => {
                        if (errday == 1 && resday.length > 0) {

                            for (let y of resday) {
                                let did_buy_date = y.created_at;
                                let today_date: any = new Date();
                                const oneDay = 1000 * 60 * 60 * 24;
                                const diffInTime = today_date.getTime() - did_buy_date.getTime();
                                TotalDays = Math.round(diffInTime / oneDay);
                                if (TotalDays) {
                                    if (TotalDays > y.day_num) {
                                        disDID.push(y.did);
                                        arrStr = disDIDid.push(y.iddid);
                                    } else {
                                        notdisDID.push(y.did);
                                        notdisDIDid.push(y.iddid);
                                    }
                                }
                            }
                            if (disDIDid.length > 0) {
                                let tmpqurty = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES ";
                                disDID.forEach((element: any) => {
                                    tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element + "','31','Bulk DID Delete Initiated',NOW()),";
                                });
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = tmpqurty.slice(0, -1);
                                obj5.prepare();
                                obj5.execute((error: any, result: any) => { });

                                arrStr = disDIDid;
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid` IN(" + arrStr + ")";
                                obj2.prepare();
                                obj2.execute((errorin: any, data: any) => {
                                    console.log("DID Updated Successfully!");

                                });

                            }
                            else {
                                // let objv = new RawView(res);
                                // objv.prepare({ status: 502, error: 0, message: "DID Not Disconnected Successfully!", disdata: '', notdisDID: '' })
                                // objv.execute();
                                console.log("DID Not Disconnected Successfully!");

                            }
                        }
                    });
                }
                if (DIDIM.length > 0) {
                    let tmpqurty = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES ";
                    disDID.forEach((element: any) => {
                        tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element + "','5','Disconnect DID from provider',NOW()),";
                    });
                    let obj5 = new ModelRawNonQuery(req, res);
                    obj5.nonqrysql = tmpqurty.slice(0, -1);
                    obj5.prepare();
                    obj5.execute((error: any, result: any) => { });

                    arrStr = DIDIM;
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid` IN(" + arrStr + ")";
                    obj2.prepare();
                    obj2.execute((errorin: any, data: any) => {
                        console.log("DID Updated Successfully!");

                    });
                }
                let objv = new RawView(res);
                objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully!", disdata: disDID, notdisDID: notdisDID })
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    //disconnectSelectedDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((err: any, sessdata: any) => {
    //         var disconnectedDID: any = [];
    //         disconnectedDID.length = 0;
    //         disconnectedDID.splice(0, disconnectedDID.length);
    //         let disLen: any = '';
    //         var notDisconnectedDID: any = [];
    //         notDisconnectedDID.length = 0;
    //         notDisconnectedDID.splice(0, notDisconnectedDID.length);
    //         let notdisLen: any = '';
    //         if (err == 1) {
    //             let sdata: any = req.body.data;
    //             let dislength = "";
    //             let i = 0;
    //             let j = 0;
    //             //var promise = new Promise((resolve: any, reject: any) => {
    //                 sdata.forEach((el: any, idx: any, dids: any) => {
    //                     i++;
    //                     console.log('idxidxidxidx',idx, 'iiiiiiiiiiiiiiiii', i , 'dids.length',dids.length-1, 'sdata.length', sdata.length);
    //                     let obj1 = new ModelRawQuery(req, res);
    //                     obj1.qrysql = "SELECT t.day_num,d.iddid FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid='" + el.iddid + "'";
    //                     obj1.prepare();
    //                     obj1.execute((errday: any, resday: any) => {
    //                         if (errday == 1 && resday.length > 0) {
    //                             let number = new Number();
    //                             number.countDays(req, res, el.did.trim(), (err: any, countdays: any) => {
    //                                 if (countdays) {
    //                                     if (countdays > resday[0].day_num) {

    //                                         let obj2 = new ModelRawQuery(req, res);
    //                                         obj2.qrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid`= '" + el.iddid + "'";
    //                                         obj2.prepare();
    //                                         obj2.execute((error: any, data: any) => {
    //                                             j++;
    //                                             disconnectedDID.push(el.did);
    //                                             disLen = disconnectedDID.length;
    //                                             console.log('disLen top',disLen);


    //                                         });
    //                                     } else {
    //                                         notDisconnectedDID.push(el.did);
    //                                         notdisLen = notDisconnectedDID.length;
    //                                     }
    //                                     console.log('disLen mid',disLen);
    //                                     console.log('notdisLen mid',notdisLen);
    //                                     console.log('disLen out ',disLen);
    //                                     console.log('notdisLen out',notdisLen);
    //                                     console.log('iiiiiiiiiiiiiiii',i);
    //                                     console.log('sdata.length',sdata.length);



    //                                 }
    //                             });
    //                         }
    //                     });
    //                 });
    //             //})
    //             // let objv = new RawView(res);
    //             // //objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully! Disconnect Did : " + disLen + " Not Disconnect Did : " + notdisLen })
    //             // objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully!" })
    //             // objv.execute();
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }

    public RetrievOsr(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.query;
                if (sdata.DID) {
                    console.log("sdata==>" + sdata);
                    let osr = new OsrApi('', sessdata);
                    osr.retrieveOsrEntry(req, res, (error, resp) => {
                        if (resp) {
                            let obj1 = new RawView(res);
                            obj1.prepare({ status: 200, message: "OSR Details Find Successfully", result: resp });
                            obj1.execute();
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 404, message: "OSR Details Not Found", result: error })
                            obj.execute();
                        }
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "DID are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public RetrievOsrNotification(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.query;
                console.log("sdata==>" + sdata);
                let osr = new OsrApi('', sessdata);
                osr.retrieveOsrNotifications(req, res, (error, resp) => {
                    if (resp) {
                        let obj1 = new RawView(res);
                        obj1.prepare({ status: 200, message: "OSR Details Find Successfully", result: resp });
                        obj1.execute();
                    } else {
                        let obj = new RawView(res);
                        obj.prepare({ status: 404, message: "OSR Details Not Found", result: error })
                        obj.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public DeleteNumber(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                const sdata = req.query;
                if (sdata.DID) {
                    let osr = new OsrApi('', sessdata);
                    osr.deleteNumber(req, res, (error, resp) => {
                        if (!error) {
                            delete resp.nnid
                            let obj1 = new RawView(res);
                            obj1.prepare({ status: 200, message: "SMS facility has been successfully disabled.", result: resp });
                            obj1.execute();
                        }
                        else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 400, error: error });
                            obj.execute()
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "DID are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public DeleteSinchNumber(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.query;
                const campaign_key: any = ''
                console.log("sdata==>" + sdata);
                if (sdata.DID) {
                    let osr = new SinchApi('', sessdata);
                    osr.deleteNumber(req, res, campaign_key, (error, resp) => {
                        if (resp) {
                            let obj1 = new RawView(res);
                            obj1.prepare({ status: 201, message: "DID Delete From SInch successfully", result: resp });
                            obj1.execute();
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 502, message: "Somthing went Wrong", result: error })
                            obj.execute();
                        }
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "DID are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /*  public NetworkOperators(req: Request, res: Response, next: NextFunction) {
         const sdata = req.query;
         if (sdata.DID) {
             let number: any = sdata.DID;
             console.log("sdata==>" + sdata);
             let session = new SessionManagment(req, res, next);
             session.GetSession((error: any, sessdata: any) => {
                 if (error == 1) {
                     var headers = {
                         'accept': 'application/json'
                     };
                     var options = {
                         url: 'https://api-iplink.peeredge.com/api/v1/users/sign_in?user[email]=' + email + '&user[password]=' + password,
                         method: 'POST',
                         headers: headers
                     };
                     request(options, (error: any, responce: any) => {
                         if (!error) {
                             let data = JSON.parse(responce.body);
                             let auth_token = data.auth_token;
                             var headers = {
                                 'accept': 'application/json',
                                 'Token': auth_token
                             };
                             var options = {
                                 url: 'https://api-iplink.peeredge.com/api/v1/reportings/get_lrn?lrn=' + number,
                                 method: 'GET',
                                 headers: headers
                             };
                             console.log("options", options);
                             request(options, (error: any, responce: any) => {
                                 if (!error) {
                                     let lrn_detail = JSON.parse(responce.body);
                                     console.log("lrn_detail", lrn_detail);
                                     if (lrn_detail.hasOwnProperty('errors')) {
                                         if (lrn_detail.errors[0] == "LRN Not Found.") {
                                             let did: any = "" + number + "";
                                             let len: any = did.length - 10;
                                             let number1 = did.slice(len, did.length);
                                             let npa = number1.slice(0, 3);
                                             let nxx = number1.slice(3, 6);
                                             let obj1 = new ModelRawQuery(req, res);
                                             obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`,   `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                                             obj1.prepare()
                                             obj1.execute((lrn_err, lrn_details) => {
                                                 if (lrn_err == 1) {
                                                     if (lrn_details.length > 0) {
                                                         let objv = new RawView(res);
                                                         objv.prepare({ status: 200, message: lrn_details });
                                                         objv.execute();
                                                     } else {
                                                         let objv = new RawView(res);
                                                         objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                         objv.execute();
                                                     }
                                                 } else {
                                                     let objv = new RawView(res);
                                                     objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                     objv.execute();
                                                 }
                                             });
                                         }
                                     } else {
                                         let did: any = "" + lrn_detail.lnp + "";
                                         let len: any = did.length - 10;
                                         let number1 = did.slice(len, did.length);
                                         let npa = number1.slice(0, 3);
                                         let nxx = number1.slice(3, 6);
                                         let obj1 = new ModelRawQuery(req, res);
                                         obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`,   `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                                         obj1.prepare()
                                         obj1.execute((lrn_err, lrn_details) => {
                                             if (lrn_err == 1) {
                                                 if (lrn_details.length > 0) {
                                                     let objv = new RawView(res);
                                                     objv.prepare({ status: 200, message: lrn_details });
                                                     objv.execute();
                                                 } else {
                                                     let objv = new RawView(res);
                                                     objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                     objv.execute();
                                                 }
                                             } else {
                                                 let objv = new RawView(res);
                                                 objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                 objv.execute();
                                             }
                                         });
                                     }
                                 } else {
                                     let Error = JSON.parse(error);
                                     let objv = new RawView(res);
                                     objv.prepare({ status: 502, message: "Something went wrong!", error: Error });
                                     objv.execute();
                                 }
                             });
                         } else {
                             let objv = new RawView(res);
                             objv.prepare({ status: 502, message: "Something went wrong!", error: error });
                             objv.execute();
                         }
                     });
                 }
                 else {
                     let objv = new Res406(res);
                     objv.prepare("No session data there");
                     objv.execute();
                 }
             });
         } else {
             let objv = new RawView(res);
             objv.prepare({ status: 500, message: "DID are required" });
             objv.execute();
         }
     } */

    public NetworkOperators(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.query;
                if (sdata.DID) {
                    let number: any = sdata.DID;
                    console.log("Number::", number)
                    if (isNumber(number) >= 0 && number.length >= 10) {

                        let numberData = new APIBase();
                        numberData.checkNumberType(number, (__errorr, __resp) => {
                            if (__errorr == 1) { // 1 is NN

                                numberData.getLRNRate(req, res, sessdata.idtariff, "lookup", "lrn", (__errorl, __resl) => {
                                    if (__errorl == 1) {

                                        numberData.checkBalance(req, res, sessdata.idaccount, __resl[0].rate, (__errorR, __resR) => {
                                            if (__errorR == 1) {
                                                // To check the LRN details
                                                let PayLoad: any = {
                                                    TO: number
                                                }
                                                let lerg = new LergApi("", "");
                                                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                    let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : number
                                                    let num = ToNumber;
                                                    let did = "" + num + "";
                                                    let len = did.length - 10;
                                                    let number1 = did.slice(len, did.length);
                                                    let npa = number1.slice(0, 3);
                                                    let nxx = number1.slice(3, 6);
                                                    let obj1 = new ModelRawQuery(req, res);
                                                    obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`,   `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                                                    obj1.prepare()
                                                    obj1.execute((lrn_err, lrn_details) => {
                                                        if (lrn_err == 1) {
                                                            if (lrn_details.length > 0) {
                                                                /*let lrn_details2: any = {}
                                                                for (const item of Object.entries(lrn_details[0])) {
                                                                    item[1] = item[0].replace("\r", "").replace("\n", "")
                                                                    lrn_details2[item[0]] = item[1]
                                                                }
                                                                lrn_details = [lrn_details2]*/
                                                                let lrn_result = Object.assign({ telephoneNumber: number, lrn: ToNumber }, lrn_details[0]);
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 200, message: [lrn_result] });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            objv.execute();
                                                        }
                                                    });

                                                    if (__resl[0].rate > 0) {
                                                        // To wallet deduct
                                                        let obj0 = new ModelRawNonQuery(req, res);
                                                        obj0.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + __resl[0].rate + " WHERE `idaccount`='" + sessdata.idaccount + "'"
                                                        obj0.prepare();
                                                        obj0.execute((wallet_error, wallet_success) => {
                                                            if (wallet_error == 1) {
                                                                console.log("Wallet amount deducted for /getnumberdetails :: ", __resl[0].rate, number);
                                                            }
                                                            else {
                                                                console.log("Wallet amount not deducted for /getnumberdetails :: ", __resl[0].rate, number);
                                                            }
                                                        });

                                                        // To manage log
                                                        let obj00 = new ModelRawNonQuery(req, res);
                                                        obj00.nonqrysql = "INSERT INTO `api_charges_log` (`iduser`, `idaccount`, `cost`,`req_param`,`endpoint`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + __resl[0].rate + "','" + number + "','/getnumberdetails')";
                                                        obj00.prepare();
                                                        obj00.execute((error: any, result: any) => {
                                                            console.log("api_charges_log Inserted Successfully!");
                                                        });
                                                    }
                                                    else {
                                                        console.log("Wallet amount is 0 for /getnumberdetails :: ", number);
                                                    }
                                                })
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 504, message: "Somting went wrong with balance!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 505, message: "Rate not found" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 503, message: "Number information not available!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 400, message: "Invalid Number! Number should be 10 digit!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "DID are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public GetMdr(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata: any = req.query;
                let message: any = "";
                if (!sdata.SessionId)
                    message = "SessionId is required!";
                if (sdata.Limit && (sdata.Limit < 1 || sdata.Limit > 1000))
                    message = "Min Limit 1 and Max Limit is 1000";
                if (!sdata.Limit || sdata.Limit == null || sdata.Limit == undefined)
                    message = "Please Enter a Valid Limit!";

                if (message) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `to_number`,`from_number`,`messsage_body`, `npa`,`state`,`direction`, IF(`direction`='inbound',Mo_rates,MT_rates)`rates`, IF(`direction`='inbound',Mo_surcharge,MT_surcharge) `surcharge`, `ocn`,`lata`,`category`, DATE_FORMAT(`created_at`,'%Y-%m-%d %H:%i:%s') `date`, DATE_FORMAT(`message_accepted_by_signalmash`,'%Y-%m-%d %H:%i:%s') `message_accepted_by_signalmash`, DATE_FORMAT(`message_delivered_to_operator`,'%Y-%m-%d %H:%i:%s') `message_delivered_to_operator`, DATE_FORMAT(`delivery_receipt_delivered`,'%Y-%m-%d %H:%i:%s') `delivery_receipt_delivered`, IF(`status`=1,'Success','Failed') `status` FROM mdr WHERE `iduser` = '" + sessdata.iduser + "' AND `batch_id`='" + sdata.SessionId + "' ORDER BY `created_at` LIMIT " + sdata.Limit + "";
                    obj.prepare();
                    obj.execute((mdr_error: any, result: any) => {
                        if (mdr_error == 1 && result.length > 0) {
                            console.log("result :: ", result);
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "MDR fatched successfully!", data: result });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: "No record found!", data: result });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public GetCdr(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const sdata = req.query;
                console.log("sdata==>" + sdata);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `caller_id_number`, `dialed_number`,  `direction` ,`hangup_cause`, `start_stamp`, `answer_stamp`, `end_stamp`, `duration`,`billsec`,`npa`,`state`,`invite_failure_phrase`,`ocn`,`lata`,`category` FROM cdr WHERE `iduser` = '" + sessdata.iduser + "' ORDER BY `idcdr` LIMIT 1000";
                obj.prepare();
                obj.execute((cdr_error: any, result: any) => {
                    if (cdr_error == 1) {
                        console.log(result);
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "CDR Find successfully!", result: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!", result: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public onAddToCart(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                let rdata: any = [];
                rdata = req.body.data;
                obj2.filter = null;
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "INSERT into did_cart (`idaccount`, `iduser`, `did`, `provider`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + rdata.phone_number + "', '" + rdata.provider + "')";
                obj3.execute((cart_error: any, result: any) => {
                    if (cart_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, error: cart_error, message: result.sqlMessage });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    addAllToCart(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into did_cart (`idaccount`,`iduser`, `did`, `provider`) VALUES ";
                rdata.forEach((element: any) => {
                    tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element.phone_number + "', '" + element.provider + "'),";
                });
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = tmpqurty.slice(0, -1);
                obj3.execute((cart_error: any, result: any) => {
                    if (cart_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, error: cart_error, message: result.sqlMessage });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public getCart(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM did_cart where iduser = '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((cart_error: any, result: any) => {
                    if (cart_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: msg });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deleteCart(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                console.log(req.query);
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE id_cart = '" + req.query.id + "'";
                obj.prepare();
                obj.execute((cart_error: any, lastid: any) => {
                    if (cart_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, message: "DID removed Successfully!", data: lastid[0] });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    deleteItems(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let qData: any = req.body;
                qData.forEach((el: any, idx: any, dids: any) => {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM did_cart WHERE did = '" + el.did + "'";
                    obj.prepare();
                    obj.execute((error: any, lastid: any) => {
                        if (idx == (dids.length - 1)) {
                            let objv = new RawView(res)
                            obj.prepare();
                            objv.prepare({
                                status: 201, message: "Cart Items Removed!", data: lastid
                            })
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public clearCart(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((error1: any, lastid: any) => {
                    if (lastid) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, message: "Cart Cleared!", data: lastid[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, error: error1, message: "Something went wrong" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public verifyDid(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let session = new SessionManagment(req, res, () => { });
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body;
                let didNumber = sdata.FROM;
                if (sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                    callback('', 1);
                }
                else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `iddid` FROM `did_buy` WHERE `did`='" + didNumber + "' AND `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((err, data) => {
                        if (data.length > 0) {
                            callback('', 1);
                        } else {
                            callback('', -1);
                        }
                    })
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public countDays(req: Request, res: Response, did: string, callback: (err: any, data: any) => void) {
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `created_at` FROM `did_buy` WHERE `did` LIKE '" + did + "%'";
        obj.prepare();
        obj.execute((err, did_days) => {
            let TotalDays: any;
            if (did_days.length > 0) {
                let did_buy_date = did_days[0].created_at;
                let today_date: any = new Date();
                const oneDay = 1000 * 60 * 60 * 24;
                const diffInTime = today_date.getTime() - did_buy_date.getTime();
                TotalDays = Math.round(diffInTime / oneDay);
                console.log("Remaining days::", TotalDays);
                callback('', TotalDays)
            }
            else {
                callback("Data Not Found", 0)
            }
        })
    }

    // To Get DIDs for panel
    onGetDIDs(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = [];
                sdata = req.query;
                let iduser = sdata.selectedUser.split("-")[0];
                let idaccount = sdata.selectedUser.split("-")[1];
                let condition: any = "";
                // For Customer account
                if (sessdata.type == 2)
                    condition += "d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";

                // For Customer account
                if (sessdata.type == 22)
                    condition += 'd.`iduser`="' + sessdata.iduser + '" AND ';

                if (sdata.selectedUser)
                    condition += 'd.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';

                if (sdata.selectSMS == 'enabled')
                    condition += "d.`sinch_status`='1' AND ";

                if (sdata.selectSMS == 'disabled')
                    condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";

                if (sdata.didnpa)
                    condition += 'd.`npa`="' + sdata.didnpa + '" AND ';

                if (sdata.didnumber)
                    condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';

                if (sdata.selectState)
                    condition += 'd.`state`="' + sdata.selectState + '" AND ';

                if (sdata.connectionKey)
                    condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';

                if (sdata.campaignKey)
                    condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';

                if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                    let atr: any = sdata.autoRenew == 'Enabled' ? true : false;
                    condition += 'd.`subscription_auto_renew`="' + atr + '" AND ';
                }

                if (sdata.fromDate && sdata.toDate)
                    condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';

                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s') `created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' GROUP BY d.did ORDER BY d.iddid DESC LIMIT 1000";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    /* onGetDIDs(req: Request, res: Response, next: NextFunction) {
        let sdata: any = [];
        sdata = req.query;
        let iduser = sdata.selectedUser.split("-")[0];
        let idaccount = sdata.selectedUser.split("-")[1];
        let condition: any = "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                // for Admin account
                if (sessdata.type == 1) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS || sdata.selectedUser || sdata.connectionKey || sdata.campaignKey || sdata.autoRenew || (sdata.fromDate && sdata.toDate)) {
                        if (sdata.selectedUser) {
                            condition += 'd.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                        }
                        if (sdata.selectSMS == 'enabled') {
                            //condition += "(d.`osr_status`='register' AND d.`sinch_status`=1 AND (d.`camp_registry`!='' AND d.`camp_registry` != 'undefined')) AND ";
                            condition += "d.`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            //condition += "(d.`osr_status`!='register' AND d.`sinch_status`!=1 AND (d.`camp_registry`='' OR d.`camp_registry` = 'undefined')) AND ";
                            condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                        }
                        if (sdata.didnpa) {
                            condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        if (sdata.selectState) {
                            condition += 'd.`state`="' + sdata.selectState + '" AND ';
                        }
                        if (sdata.connectionKey) {
                            condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                        }
                        if (sdata.campaignKey) {
                            condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                        }
                        if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                            let isEnable: any = sdata.autoRenew == 'Enabled' ? true : false;
                            condition += 'd.`subscription_auto_renew`="' + isEnable + '" AND ';
                        }
                        if (sdata.fromDate && sdata.toDate) {
                            condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                        }

                        obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,d.subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                    else {
                        obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,d.subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName,DATE_FORMAT(d.`created_at`, '%d %b,%Y %h:%i %p') `created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                }
                //for sub customer account
                else if (sessdata.type == 22) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS || sdata.connectionKey || sdata.campaignKey || sdata.autoRenew || (sdata.fromDate && sdata.toDate)) {
                        if (sdata.selectSMS == 'enabled') {
                            //condition += "(d.`osr_status`='register' AND d.`sinch_status`=1 AND (d.`camp_registry`!='' AND d.`camp_registry` != 'undefined')) AND ";
                            condition += "d.`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            //condition += "(d.`osr_status`!='register' AND d.`sinch_status`!=1 AND (d.`camp_registry`='' OR d.`camp_registry` = 'undefined')) AND ";
                            condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                        }
                        if (sdata.didnpa) {
                            condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        //if (sdata.selectState && !(sdata.didnumber && sdata.didnpa)) {
                        if (sdata.selectState) {
                            condition += 'd.`state`="' + sdata.selectState + '" AND ';
                        }
                        if (sdata.connectionKey) {
                            condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                        }
                        if (sdata.campaignKey) {
                            condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                        }
                        if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                            let isEnable: any = sdata.autoRenew == 'Enabled' ? true : false;
                            condition += 'd.`subscription_auto_renew`="' + isEnable + '" AND ';
                        }
                        if (sdata.fromDate && sdata.toDate) {
                            condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                        }
                        condition += 'd.`iduser`="' + sessdata.iduser + '" AND ';
                        obj2.qrysql = "SELECT d.iddid,d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,d.subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000"
                    }
                    else {
                        obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,d.subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName,DATE_FORMAT(d.`created_at`, '%d %b,%Y %h:%i %p') `created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE disconnect_did_status = '1' AND d.iduser = '" + sessdata.iduser + "' ORDER BY d.iddid DESC LIMIT 1000";
                    }
                }
                // for customer account
                else {
                    if (sdata.selectSMS == 'enabled') {
                        // condition += "d.`osr_status`='register' AND d.`sinch_status`=1 AND d.`camp_registry`!='' AND d.`camp_registry` != 'undefined' AND ";
                        condition += "d.`sinch_status`='1' AND ";
                    }
                    if (sdata.selectSMS == 'disabled') {
                        //condition += "d.`osr_status`!='register' AND d.`sinch_status`!=1 AND d.`camp_registry`='' OR d.`camp_registry` = 'undefined' AND ";
                        condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                    }
                    if (sdata.didnpa) {
                        condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                    }
                    if (sdata.didnumber) {
                        condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                    }
                    if (sdata.selectState) {
                        condition += 'd.`state`="' + sdata.selectState + '" AND ';
                    }
                    if (sdata.connectionKey) {
                        condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                    }
                    if (sdata.campaignKey) {
                        condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                    }
                    if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                        let isEnable: any = sdata.autoRenew == 'Enabled' ? true : false;
                        condition += 'd.`subscription_auto_renew`="' + isEnable + '" AND ';
                    }
                    if (sdata.fromDate && sdata.toDate) {
                        condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                    }
                    obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,d.subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND disconnect_did_status = '1' ORDER BY d.iddid DESC LIMIT 1000;"
                }
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    } */

    onExportDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.body.data;
                let condition: any = "";
                let idaccount: any;;
                if (sdata.selectedUser) {
                    idaccount = sdata.selectedUser.split("-")[1];
                }
                // For Customer account
                if (sessdata.type == 2)
                    condition += "db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";

                // For Customer account
                if (sessdata.type == 22)
                    condition += 'db.`iduser`="' + sessdata.iduser + '" AND ';

                if (sdata.selectedUser)
                    condition += 'db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';

                if (sdata.selectSMS == 'enabled')
                    condition += "db.`sinch_status`='1' AND ";

                if (sdata.selectSMS == 'disabled')
                    condition += "(db.`sinch_status` !='1' OR db.`sinch_status` IS NULL OR db.`sinch_status`='' OR db.`sinch_status` ='0') AND ";

                if (sdata.didnpa)
                    condition += 'db.`npa`="' + sdata.didnpa + '" AND ';

                if (sdata.didnumber)
                    condition += 'db.`did` LIKE "%' + sdata.didnumber + '%" AND ';

                if (sdata.selectState)
                    condition += 'db.`state`="' + sdata.selectState + '" AND ';

                if (sdata.connectionKey)
                    condition += 'db.`connection_key`="' + sdata.connectionKey + '" AND ';

                if (sdata.campaignKey)
                    condition += 'db.`camp_registry`="' + sdata.campaignKey + '" AND ';

                if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                    let atr: any = sdata.autoRenew == 'Enabled' ? true : false;
                    condition += 'db.`subscription_auto_renew`="' + atr + '" AND ';
                }

                if (sdata.fromDate && sdata.toDate)
                    condition += 'db.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';

                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, db.npa AS NPA, db.nxx AS NXX, db.state AS State, db.ratecenter AS `Rate Center`,ep.connection_key AS `Connection Key`,ep.name AS `Connection Name`,DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS `Start Subscription`,DATE_FORMAT(LAST_DAY(NOW()), '%Y-%m-%d %H:%i:%s') AS `End Subscription`,db.subscription_auto_renew AS `Auto Renewal`,db.camp_registry AS `SMS Campaign`, db.`did_disconnect_days` AS DisconnectDays FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " db.disconnect_did_status = '1' GROUP BY db.did ORDER BY db.iddid DESC";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Expoting!", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    /* onExportDID(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        let condition: any = "";
        let idaccount = sdata.selectedUser.split("-")[1];
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                // for Admin account
                if (sessdata.type == 1) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS || sdata.selectedUser) {
                        if (sdata.selectedUser) {
                            condition += 'db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                        }
                        if (sdata.selectSMS == 'enabled') {
                            //condition += "`osr_status`='register' AND `sinch_status`=1 AND `camp_registry`!='' AND `camp_registry` != 'undefined' AND ";
                            condition += "`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            //condition += "`osr_status`!='register' AND `sinch_status`!=1 AND (`camp_registry`='' OR `camp_registry` = 'undefined') AND ";
                            condition += "(`sinch_status` !='1' OR `sinch_status` IS NULL OR `sinch_status`='' OR `sinch_status` ='0') AND ";
                        }

                        if (sdata.didnpa) {
                            condition += '`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += 'db.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        if (sdata.selectState) {
                            condition += '`state`="' + sdata.selectState + '" AND ';
                        }
                        obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, db.npa AS NPA, db.nxx AS NXX, db.state AS State, db.ratecenter AS `Rate Center`,ep.connection_key AS `Connection Key`,ep.name AS `Connection Name`,DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS `Start Subscription`,DATE_FORMAT(LAST_DAY(NOW()), '%Y-%m-%d %H:%i:%s') AS `End Subscription`,db.subscription_auto_renew AS `Auto Renewal`,db.camp_registry AS `SMS Campaign` FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " db.disconnect_did_status = '1' GROUP BY db.did";
                    }
                    else {
                        obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, db.npa AS NPA, db.nxx AS NXX, db.state AS State,db.ratecenter AS `Rate Center`,ep.connection_key AS `Connection Key`,ep.name AS `Connection Name`,DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS `Start Subscription`,DATE_FORMAT(LAST_DAY(NOW()),'%Y-%m-%d %H:%i:%s') AS `End Subscription`,db.subscription_auto_renew AS `Auto Renewal`,db.camp_registry AS `SMS Campaign` FROM `did_buy`db LEFT JOIN `endpoint`ep ON db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE disconnect_did_status = '1' ORDER BY db.iddid DESC";
                    }
                } else if (sessdata.type == 22) {
                    if (sdata.didnpa || sdata.didnumber || sdata.selectState || sdata.selectSMS) {
                        if (sdata.selectSMS == 'enabled') {
                            condition += "`sinch_status`='1' AND ";
                        }
                        if (sdata.selectSMS == 'disabled') {
                            condition += "(`sinch_status` !='1' OR `sinch_status` IS NULL OR `sinch_status`='' OR `sinch_status` ='0') AND ";
                        }

                        if (sdata.didnpa) {
                            condition += '`npa`="' + sdata.didnpa + '" AND ';
                        }
                        if (sdata.didnumber) {
                            condition += 'db.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                        }
                        if (sdata.selectState) {
                            condition += '`state`="' + sdata.selectState + '" AND ';
                        }
                        condition += 'db.`iduser`="' + sessdata.iduser + '" AND ';
                        obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, db.npa AS NPA, db.nxx AS NXX, db.state AS State,db.ratecenter AS `Rate Center`,ep.connection_key AS `Connection Key`,ep.name AS `Connection Name`,DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s')AS `Start Subscription`,DATE_FORMAT(LAST_DAY(NOW()), '%Y-%m-%d %H:%i:%s') AS `End Subscription`,db.subscription_auto_renew AS `Auto Renewal`,db.camp_registry AS `SMS Campaign` FROM `did_buy` db LEFT JOIN `endpoint` ep ON   db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE db.disconnect_did_status = '1' AND " + condition + " db.disconnect_did_status = '1' GROUP BY db.did";
                    }
                    else {
                        obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, db.npa AS NPA, db.nxx AS NXX, db.state AS State, db.ratecenter AS `Rate Center`,ep.connection_key AS `Connection Key`,ep.name AS `Connection Name`, DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS `Start Subscription`, DATE_FORMAT(LAST_DAY(NOW()),'%Y-%m-%d %H:%i:%s') AS `End Subscription`,db.subscription_auto_renew AS `Auto Renewal`,db.camp_registry AS `SMS Campaign` FROM `did_buy` db LEFT JOIN `endpoint` ep  ON  db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE db.disconnect_did_status = '1' AND db.iduser = '" + sessdata.iduser + "' GROUP BY db.did";
                    }
                }
                else {

                    if (sdata.selectSMS == 'enabled') {
                        //condition += "`osr_status`='register' AND `sinch_status`=1 AND `camp_registry`!='' AND `camp_registry` != 'undefined' AND ";
                        condition += "`sinch_status`='1' AND ";
                    }
                    if (sdata.selectSMS == 'disabled') {
                        //condition += "`osr_status`!='register' AND `sinch_status`!=1 AND `camp_registry`='' OR `camp_registry` = 'undefined' AND ";
                        condition += "(`sinch_status` !='1' OR `sinch_status` IS NULL OR `sinch_status`='' OR `sinch_status` ='0') AND ";
                    }
                    if (sdata.didnpa) {
                        condition += '`npa`="' + sdata.didnpa + '" AND ';
                    }
                    if (sdata.didnumber) {
                        condition += '`did` LIKE "%' + sdata.didnumber + '%" AND ';
                    }
                    if (sdata.selectState) {
                        condition += '`state`="' + sdata.selectState + '" AND ';
                    }
                    obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, db.npa AS NPA, db.nxx AS NXX, db.state AS State, db.ratecenter AS `Rate Center`,ep.connection_key AS `Connection Key`,ep.name AS `Connection Name`,DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS `Start Subscription`, DATE_FORMAT(LAST_DAY(NOW()),'%Y-%m-%d %H:%i:%s') AS `End Subscription`,db.subscription_auto_renew AS `Auto Renewal`,db.camp_registry AS `SMS Campaign` FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND disconnect_did_status = '1' ORDER BY db.iddid DESC";
                }
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);

                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Expoting!", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    } */

    onExportOrderDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.body.data;
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT DISTINCT REPLACE(REPLACE(dd.did, CHAR(10),''), CHAR(13),'') AS did,SUBSTRING(dd.did,'1','3')`npa`,SUBSTRING(dd.did,'4','3')`nxx`,IFNULL(d.state,'')`state`,IFNULL(d.ratecenter,'')`ratecenter`, DATE_FORMAT(dg.`date`, '%Y-%m-%d') date,IF(IFNULL(d.did,'')='','Failed','Success')AS OrderStatus, d.`did_disconnect_days` AS DisconnectDays FROM `did_group_order` dg INNER JOIN `did_order` dd ON dg.id_grouporder=dd.id_grouporder LEFT JOIN `did_buy` d ON dd.did=d.did WHERE  dg.id_grouporder='" + sdata.group_id + "' AND dg.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "')";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "DID Exported Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Export!", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    customerDidsCount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = [];
                sdata = req.query;
                let iduser = sdata.selectedUser.split("-")[0];
                let idaccount = sdata.selectedUser.split("-")[1];
                let obj2 = new ModelRawQuery(req, res);
                // for customer account
                obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + idaccount + "') AND d.disconnect_did_status = '1' GROUP BY d.did"

                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    DidLocationInfo(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `npa`, `nxx`, `ocn`, `lata`, `local_state` FROM `did_location_info`";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, data: result, message: "Did Location fatched successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    // updateDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj2 = new ModelRawQuery(req, res);
    //             let rdata = [];
    //             rdata = req.body.data;
    //             obj2.filter = null;
    //             var cols = "";
    //             if (rdata.connection_key != "" || rdata.outboundKey != undefined) {
    //                 cols += "`connection_key`='" + rdata.connection_key + "',";
    //             }
    //             if (rdata.inboundKey != "" || rdata.outboundKey != undefined) {
    //                 cols += "`inbound_key`='" + rdata.inboundKey + "',";
    //             }
    //             if (rdata.outboundKey != "" || rdata.outboundKey != undefined) {
    //                 cols += "`outbound_key`='" + rdata.outboundKey + "',";
    //             }
    //             if (rdata.campaign != "" || rdata.outboundKey != undefined) {
    //                 cols += "`camp_registry`='" + rdata.campaign + "',";
    //             }

    //             cols = cols.substring(0, cols.length - 1);
    //             obj2.qrysql = "UPDATE `did_buy` SET " + cols + " WHERE `iddid`= '" + rdata.iddid + "'";
    //             obj2.prepare();
    //             obj2.execute((error: any, data: any) => {
    //                 let objv = new RawView(res)
    //                 obj2.prepare();
    //                 objv.prepare({
    //                     status: 201,
    //                     error: 0,
    //                     data: data,
    //                     message: "DID Updated Successfully!"
    //                 })
    //                 objv.execute();
    //             });
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }

    updateDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                let rdata = req.body.data;
                let connection_key: any;
                let inboundKey: any;
                let outboundKey: any;

                if (rdata.connection_key) { connection_key = rdata.connection_key; } else { connection_key = ''; }
                if (rdata.inboundKey) { inboundKey = rdata.inboundKey; } else { inboundKey = ''; }
                if (rdata.outboundKey) { outboundKey = rdata.outboundKey; } else { outboundKey = ''; }

                obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `iddid`= '" + rdata.iddid + "'";
                obj2.qrysql = "";
                obj2.prepare();
                obj2.execute((error: any, data: any) => {
                    let objk = new ModelRawNonQuery(req, res);
                    objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enable','" + rdata.did.trim() + "')";
                    objk.execute((cart_error: any, result: any) => {
                        let objv = new RawView(res)
                        obj2.prepare();
                        objv.prepare({ status: 201, error: 0, data: data, message: "DID Updated Successfully!" })
                        objv.execute();
                    });
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    didEnableDisable(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = req.body.data, type: any = '', desc: any = '';
                let isEnable: any = rdata.isEnable == 'Enabled' ? true : false;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `did_buy` SET `subscription_auto_renew`='" + isEnable + "' WHERE `iddid`= '" + rdata.iddid + "'";
                obj2.prepare();
                obj2.execute((error1: any, data: any) => {
                    if (error1 == 1) {
                        if (rdata.isEnable == 'Enabled') {
                            type = '3';
                            desc = 'Auto Renewal Enable'
                        }
                        if (rdata.isEnable == 'Disabled') {
                            type = '8';
                            desc = 'Auto Renewal Disable'
                        }
                        let objk = new ModelRawNonQuery(req, res);
                        objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'" + type + "','" + desc + "','" + rdata.did.trim() + "')";
                        objk.execute((log_error: any, result: any) => {
                            log_error == 1 ? console.log("DID Log Inserted Successfully ::=>", rdata.isEnable) : console.log("DID Log Not Inserted ::=>", rdata.isEnable);
                        });
                        let objv = new RawView(res)
                        obj2.prepare();
                        objv.prepare({ status: 201, message: "DID Successfully " + rdata.isEnable + "!" })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong with auto renewal!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data available!");
                objv.execute();
            }
        });
    }
    /* didEnableDisable(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = req.body.data;
                let payLoad:any = { rdata, sessdata };
                let autoRenewCheckObj = new Number();
                autoRenewCheckObj.didAutoRenewalCheck(req, res, payLoad, (errorR: any, resultR: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ status: resultR.status, message: resultR.message })
                    objv.execute();
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 500, message: "No session data available!" });
                objv.execute();
            }
        });
    }

    didAutoRenewalCheck(req: Request, res: Response, payLoad:any, callback: (err: any, data: any) => void): any {
        // let payLoad:any = { rdata, sessdata };
        if (payLoad.rdata.isEnable == 'Enabled') {
            let obj1 = new ModelRawQuery(req, res);
            obj1.qrysql = "SELECT t.day_num FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.did LIKE '"+payLoad.rdata.did.trim()+"%'";
            obj1.prepare();
            obj1.execute((errday: any, resday: any) => {
                if (errday == 1 && resday.length > 0) {
                    let number = new Number();
                    number.countDays(req, res, payLoad.rdata.did.trim(), (errC: any, countdaysC: any) => {
                        if(errC==''){
                            if (countdaysC && (countdaysC > resday[0].day_num)) {
                                callback(1, { status: 503, message: "Sorry You can not Enable Auto Renewal.because of Subscription ended of this DID" });
                            }
                            else {
                                let autoRenewObj = new Number();
                                autoRenewObj.autoRenewalDID(req, res, payLoad, (errorR: any, resultR: any) => {
                                    callback(errorR, { status: resultR.status, message: resultR.message });
                                });                                    
                            }
                        }
                        else{
                            callback(0, { status: 504, message: errC });
                        }                  
                    })
                }
                else {
                    callback(0, { status: 404, message: "Days Not Found!" });
                }
            })
        }
        else {
            let autoRenewObj = new Number();
            autoRenewObj.autoRenewalDID(req, res, payLoad, (errorR: any, resultR: any) => {
                callback(errorR, { status: resultR.status, message: resultR.message });
            });
        }           
    }

    autoRenewalDID(req:Request, res:Response, payLoad:any, callback: (err: any, data: any) => void): any {
        // let payLoad:any = { rdata, sessdata };
        let isEnable: any = payLoad.rdata.isEnable == 'Enabled' ? true : false;
        let type: any = payLoad.rdata.isEnable == 'Enabled' ? '3' : '8';
        let desc: any = payLoad.rdata.isEnable == 'Enabled' ? 'Auto Renewal Enable' : 'Auto Renewal Disable';

        let objL = new ModelRawNonQuery(req, res);
        objL.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + payLoad.sessdata.idaccount + "','" + payLoad.sessdata.iduser + "',NOW(),'" + type + "','" + desc + "','" + payLoad.rdata.did.trim() + "')";
        objL.prepare();
        objL.execute((auto_error: any, result: any) => {
            auto_error == 1 ? 
            console.log("DID Log Inserted For Auto Renewal", payLoad.rdata.isEnable)
            : 
            console.log("DID Log Not Inserted For Auto Renewal", payLoad.rdata.isEnable); 
        });
        let objU = new ModelRawNonQuery(req, res);
        objU.nonqrysql = "UPDATE `did_buy` SET `subscription_auto_renew`='" + isEnable + "' WHERE `iddid`= '" + payLoad.rdata.iddid + "'";
        objU.prepare();
        objU.execute((error: any, data: any) => {
            error == 1 ?
            callback(1, { status: 201, message: "DID Successfully " + payLoad.rdata.isEnable + "!" }) 
            :
            callback(0, { status: 502, message: "Something went wrong with Auto Renewal update!" });
        });
    } */

    /* autoRenewalDetails(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let did = sdata.type;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`,`idaccount`,`did`,`action_type`,`autoRenewal_type`,`created_date` FROM `autoRenewal_history` WHERE `did`='" + did + "'ORDER BY did DESC";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, data: result, message: "Auto Renewal Details fatched successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    } */

    updateSelectedDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((el: any, idx: any, dids: any) => {
                    let obj2 = new ModelRawNonQuery(req, res);

                    let connection_key: any;
                    let inboundKey: any;
                    let outboundKey: any;

                    if (el.connection_key) { connection_key = el.connection_key; } else { connection_key = ''; }
                    if (el.inboundKey) { inboundKey = el.inboundKey; } else { inboundKey = ''; }
                    if (el.outboundKey) { outboundKey = el.outboundKey; } else { outboundKey = ''; }

                    obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `iddid`= '" + el.iddid + "'";
                    obj2.prepare();
                    obj2.execute((error: any, data: any) => {
                        let objk = new ModelRawNonQuery(req, res);
                        objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enable','" + el.did.trim() + "')";
                        objk.execute((cart_error: any, result: any) => {
                            if (idx == (dids.length - 1)) {
                                let objv = new RawView(res)
                                obj2.prepare();
                                objv.prepare({ status: 201, error: 0, data: "update", message: "DID Updated Successfully!" })
                                objv.execute();
                            }
                        });
                    });
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    // updateSelectedDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((err: any, sessdata: any) => {
    //         if (err == 1) {
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             rdata.forEach((el: any, idx: any, dids: any) => {
    //                 let obj2 = new ModelRawQuery(req, res);
    //                 var cols = "";
    //                 if (el.connection_key) {
    //                     cols += "`connection_key`='" + el.connection_key + "',";
    //                 }
    //                 if (el.inboundKey) {
    //                     cols += "`inbound_key`='" + el.inboundKey + "',";
    //                 }
    //                 if (el.outboundKey) {
    //                     cols += "`outbound_key`='" + el.outboundKey + "',";
    //                 }
    //                 if (el.campaign) {
    //                     cols += "`camp_registry`='" + el.campaign + "',";
    //                 }
    //                 cols = cols.substring(0, cols.length - 1);
    //                 obj2.qrysql = "UPDATE `did_buy` SET " + cols + " WHERE `iddid`= '" + el.iddid + "'";
    //                 obj2.prepare();
    //                 obj2.execute((error: any, data: any) => {
    //                     if (idx == (dids.length - 1)) {
    //                         let objv = new RawView(res)
    //                         obj2.prepare();
    //                         objv.prepare({
    //                             status: 201,
    //                             error: 0,
    //                             data: "update",
    //                             message: "DID Updated Successfully!"
    //                         })
    //                         objv.execute();
    //                     }
    //                 });
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }

    GetState(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT DISTINCT loc_state FROM did_location_info";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, data: result, message: "State Find successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    GetRateCenter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                if (sdata.State) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  rc_abbre FROM did_location_info WHERE `loc_state` = '" + req.query.State + "' ORDER BY rc_abbre ASC";
                    obj.prepare();
                    obj.execute((err: any, result: any) => {
                        if (err == 1) {
                            if (result.length > 0) {
                                // console.log(result);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, data: result, message: "Rate center found successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 404, data: result, message: "Rate center not found!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });

                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "State are required" });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    GetNPA(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                if (sdata.State) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  npa FROM did_location_info WHERE `loc_state` = '" + req.query.State + "'";
                    obj.prepare();
                    obj.execute((errorr: any, result: any) => {
                        if (errorr == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, data: result, message: "NPA Find successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 404, data: result, message: "NPA are not available!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 500, message: "State are required!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there!");
                objv.execute();
            }
        })
    }

    GetNXX(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        if (sdata.NPA) {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                if (error == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  nxx FROM did_location_info WHERE `npa` = '" + req.query.NPA + "'";
                    obj.prepare();
                    obj.execute((errorr: any, result: any) => {
                        if (errorr == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, data: result, message: "NXX Find successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 404, data: result, message: "NXX are not available!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            })
        }
        else {
            let objv = new RawView(res);
            objv.prepare({ status: 500, message: "NPA are required" });
            objv.execute();
        }
    }

    // To Get All DID List For Swagger Side
    getDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2){
                    let sdata: any = req.query;
                    let con: any = '';
                    let pg: any = '';
                    let page: any = sdata.page;
                    let recordsPerPage: any = sdata.recordsPerPage;
                    if (isNumber(page) >= 0 && isNumber(recordsPerPage) >= 0 && isNumber(sdata.NPA) >= 0 && isNumber(sdata.NXX) >= 0) {
                        let message: any = '';
                        if (!page)
                            page = 1;

                        if (page < 1)
                            message = "Page Minimum Limit 1";

                        if (page > 500)
                            message = "Page Maximum Limit 500";

                        if (!recordsPerPage)
                            recordsPerPage = 500;

                        if (recordsPerPage > 500)
                            message = "recordsPerPage Maximum Limit 500";

                        if (recordsPerPage < 1)
                            message = "recordsPerPage Minimum Limit 1";

                        if (recordsPerPage <= 500 && recordsPerPage >= 1 && page >= 1) {

                            if (sdata.campaignKey)
                                con += " AND `camp_registry` = '" + sdata.campaignKey + "'";
                            if (sdata.NPA)
                                con += " AND `npa` LIKE '%" + sdata.NPA + "%'";
                            if (sdata.NXX)
                                con += " AND `nxx` LIKE '%" + sdata.NXX + "%'";
                            if (sdata.rateCenter)
                                con += " AND `ratecenter` LIKE '%" + sdata.rateCenter + "%'";
                            if (sdata.state)
                                con += " AND `state` LIKE '%" + sdata.state + "%'";
                            if (sdata.start_date)
                                con += " AND DATE_FORMAT(`created_at`,'%Y-%m-%d') >= '" + sdata.start_date + "'";
                            if (sdata.end_date)
                                con += " AND DATE_FORMAT(`created_at`,'%Y-%m-%d') <= '" + sdata.end_date + "'";

                            if (page && recordsPerPage) {
                                let perPage = (page - 1) * recordsPerPage;
                                pg = " LIMIT " + recordsPerPage + " OFFSET " + perPage + ""
                            }

                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `did` FROM `did_buy` WHERE `disconnect_did_status` = '1' " + con + " AND `account_id`='" + sessdata.idaccount + "' GROUP BY did ORDER BY `iddid` ASC " + pg + "";
                            obj.prepare();
                            obj.execute((errorr: any, result: any) => {
                                if (errorr == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 200, data: result, message: "DIDs Fetched Successfully" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 200, data: [], message: "No DIDs Available!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 502, message: "Something went wrong!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 503, message: message });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 505, message: "Not a Correct Number!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    // To Get All DID List For Swagger Side in behalf of campaign_key and connection_key
    getDIDall(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2){
                    let sdata = req.query;
                    let con: any = '';
                    if (sdata.connectionKey)
                        con += " AND db.`connection_key`='" + sdata.connectionKey + "'"

                    if (sdata.campaignKey)
                        con += " AND db.`camp_registry`='" + sdata.campaignKey + "'"
                
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS did, db.npa, db.nxx, db.state, db.ratecenter, ep.name AS connection_name, db.connection_key, DATE_FORMAT(db.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS start_subscription, CASE db.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'auto_renewal', db.camp_registry AS sms_campaign, CASE WHEN db.sinch_status = '' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '0' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '1' THEN 'SMS Fully Provisioned' WHEN db.sinch_status = '2' THEN 'Provisioning Waiting' WHEN db.sinch_status = '3' THEN 'Provisioning Inprogress' WHEN db.sinch_status = '4' THEN 'Provisioning Already Exist' WHEN db.sinch_status = '5' THEN 'Provisioned Failed' WHEN db.sinch_status = '6' THEN 'Retrying after 4 hours' WHEN db.sinch_status = '7' THEN 'You are not eligible to retry after failed' WHEN db.sinch_status = '8' THEN 'Time-out after 4 hour retry' WHEN db.sinch_status = '9' THEN 'Failed after failed retry' END AS sms_service, db.`did_disconnect_days` FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key=ep.connection_key WHERE db.disconnect_did_status = '1' " + con + " AND db.`account_id`='" + sessdata.idaccount + "' AND db.disconnect_did_status = '1' GROUP BY db.`did` ORDER BY db.`iddid` ASC";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, data: result, message: "DIDs Fetched Successfully" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, data: [], message: "No DIDs Available!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
                            
        })
    }

    // To Get DID's Detail For Swagger Side
    getDIDdetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let con: any = '';
                if (sessdata.type == 2){
                    let obj = new ModelRawQuery(req, res);
                    if (isNaN(sdata.DID) == false && typeof parseInt(sdata.DID) == "number" && sdata.DID.length >= 10) {    
                        obj.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS did, db.npa, db.nxx, db.state, db.ratecenter, ep.name AS connection_name, db.connection_key,DATE_FORMAT(db.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS start_subscription, CASE db.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'auto_renewal', db.camp_registry AS sms_campaign, CASE WHEN db.sinch_status = '' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '0' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '1' THEN 'SMS Fully Provisioned' WHEN db.sinch_status = '2' THEN 'Provisioning Waiting' WHEN db.sinch_status = '3' THEN 'Provisioning Inprogress' WHEN db.sinch_status = '4' THEN 'Provisioning Already Exist' WHEN db.sinch_status = '5' THEN 'Provisioned Failed' WHEN db.sinch_status = '6' THEN 'Retrying after 4 hours' WHEN db.sinch_status = '7' THEN 'You are not eligible to retry after failed' WHEN db.sinch_status = '8' THEN 'Time-out after 4 hour retry' WHEN db.sinch_status = '9' THEN 'Failed after failed retry' END AS sms_service, db.`did_disconnect_days` FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key=ep.connection_key WHERE db.did LIKE '%" + sdata.DID + "%' " + con + " AND db.`account_id`='" + sessdata.idaccount + "' AND db.disconnect_did_status = '1' GROUP BY db.did";
    
                        obj.prepare();
                        obj.execute((error: any, result: any) => {
                            if (error == 1) {
                                if (result.length > 0) {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 200, data: result, message: "Record Fetched Successfully" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 402, message: "Record not found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "DID is not Correct" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    public AddCart(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "INSERT into did_cart (`idaccount`, `phone_number`, `provider`) VALUES('" + sessdata.idaccount + "', '" + rdata.phone_number + "', '" + rdata.provider + "')";
                obj3.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, error: error, message: "Something went wrong" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    getStates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id`, `name`, `abbrev` FROM `states` ORDER BY abbrev ASC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "States Fetched!", data: result, status: 200 });
                        objv.execute();

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    updateConnectionOnDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let condition: any = "";
                if (sessdata.type == 1)
                    condition = ""
                if (sessdata.type == 2)
                    condition = " AND `account_id`='" + sessdata.idaccount + "'";
                if (sessdata.type == 22)
                    condition = " AND `iduser`='" + sessdata.iduser + "'";

                let obj2 = new ModelRawNonQuery(req, res);
                let rdata: any = [];
                rdata = req.body;
                obj2.nonqrysql = "UPDATE `did_buy` SET connection_key='" + rdata.ConnectionKey + "' WHERE `did`= '" + rdata.DID.trim() + "' " + condition + "";
                obj2.prepare();
                obj2.execute((error1: any, data: any) => {
                    if (error1 == 1 && data.affectedRows > 0) {

                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enabled Successfully','" + rdata.DID.trim() + "')";
                        obj1.prepare();
                        obj1.execute((errLog, resLog) => {
                            console.log("Connection Enabled Successfully.");
                        });

                        let objv = new RawView(res)
                        objv.prepare({ status: 201, data: rdata, message: "Connection Updated Successfully!" })
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, error: error1, message: "Connection not updated Successfully!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ message: "No session data there" });
                objv.execute();
            }
        });
    }

    /**
     * Other modules
     */
    public PurchaseAllDIDs(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (sessdata.type == 2 || sessdata.type == 22) {
                if (error == 1) {
                    let checkService = new APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                        if (resp.status == 200) {
                            const sdata = req.body
                            const formattedDIDs = sdata.DID.map((number: any) => `'${number}'`).join(',');
                            let obj0 = new ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT SUM(`rates`) AS overall_total_rates FROM (SELECT DISTINCT `phone_number`, `type`, `rates` FROM `did_search` WHERE `phone_number` IN (" + formattedDIDs + ") AND `iduser` = '" + sessdata.iduser + "') AS subquery";
                            obj0.prepare();
                            obj0.execute((_error1, success) => {
                                if (_error1 == 1) {
                                    // To get the proration status
                                    let obj1 = new ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + sessdata.iduser + "'";
                                    obj1.prepare();
                                    obj1.execute((proration_error, proration_success) => {
                                        if (proration_error == 1) {
                                            let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate: any = new Date()
                                            let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                            let totalDays = (lDate - day) + 1;
                                            let prorate: any;
                                            if (proration_success[0].proration == "true")
                                                prorate = (totalDays * success[0].overall_total_rates) / lDate;
                                            else
                                                prorate = success[0].overall_total_rates;
                                            prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0
                                            let obj2 = new ModelRawQuery(req, res);
                                            obj2.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + prorate + "'"
                                            obj2.prepare();
                                            obj2.execute((walletError: any, wallet: any) => {
                                                if (walletError == 1 && wallet.length > 0) {
                                                    let PI: number = 0
                                                    let iQry: string = ""

                                                    let objN = new ModelRawNonQuery(req, res)
                                                    // Iterate DID numbers to create the pending orders
                                                    if (Array.isArray(sdata.DID) && sdata.DID.length > 0) {
                                                        sdata.DID.forEach((ele: any) => {
                                                            iQry += "INSERT INTO `did_order` SET `iduser`=" + sessdata.iduser + ", `idaccount`=" + sessdata.idaccount + ", `did`='" + ele + "', `id_grouporder`=" + sdata.id_grouporder + ", status='102';\n"
                                                            PI++
                                                        })
                                                    }
                                                    if (PI > 0) {
                                                        objN.nonqrysql = iQry
                                                        objN.prepare()
                                                        objN.execute((error: any, result: any) => {
                                                            if (error == 1) {
                                                                // To delete the selected DID from cart
                                                                iQry = "DELETE FROM `did_cart` WHERE did IN (" + sdata.DID + ");"
                                                                objN.nonqrysql = iQry
                                                                objN.prepare()
                                                                objN.execute((error: any, result: any) => {
                                                                    let objv = new RawView(res)
                                                                    objv.prepare({
                                                                        error: 0,
                                                                        status: 200,
                                                                        message: "DIDs successfully processed for bulk order purchase."
                                                                    })
                                                                    objv.execute()
                                                                })
                                                            }
                                                            else {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    error: 1,
                                                                    status: 400,
                                                                    message: "DIDs did not processed for bulk order purchase!"
                                                                })
                                                                objv.execute()
                                                            }
                                                        })
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            error: 1,
                                                            status: 500,
                                                            message: "There are no DIDs in cart!"
                                                        });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        error_code: 0,
                                                        error: wallet,
                                                        message: "Please add funds to your account or contact support.",
                                                        status: 503
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        } else {
                                            let obj = new RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with get proration!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ error: 1, status: 404, message: "Rates not found!" })
                                    objv.execute()
                                }

                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 404, message: "Not Permitted" });
                objv.execute();
            }
        });
    }

    /**
     * To create the group of did orders
     */
    public CreateGroupOrder(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let checkService = new APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                        if (resp.status == 200) {
                            const sdata = req.body.data
                            let obj = new ModelRawNonQuery(req, res);
                            let process_dids: number;
                            if (sdata.number)
                                process_dids = sdata.total_dids <= 10 ? sdata.total_dids : 0
                            else
                                process_dids = 0

                            obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + sdata.name + "', total_dids=" + sdata.total_dids + ", process_dids=" + process_dids + ", numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "', campaign='" + sdata.campaign + "';"

                            obj.prepare();
                            obj.execute((error: any, result: any) => {
                                let objv = new RawView(res);
                                if (error == 1) {
                                    objv.prepare({
                                        error: 0,
                                        status: 200,
                                        message: "Group successfully created.",
                                        data: {
                                            id_grouporder: result.insertId
                                        }
                                    });
                                    objv.execute();
                                }
                                else {
                                    objv.prepare({
                                        error: 1,
                                        status: 502,
                                        message: "Something went wrong with connection!"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 1, // because of front side using 0 for success
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /**
     * To get the customer's DID list for sms test
     */
    getSMSTextDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `did` FROM `did_buy` WHERE `iduser` = '" + sessData.iduser + "' AND `sinch_status` = '1' AND `disconnect_did_status` = '1'";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'DID Fatched', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }


    /**
     * To get the orders history
     */
    GetOrdersHistory(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                let objv = new RawView(res);

                obj2.qrysql = "SELECT `id_grouporder`, `name`, total_dids, process_dids, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `date` FROM `did_group_order` WHERE iduser=" + sessdata.iduser + " ORDER BY id_grouporder DESC;"
                obj2.prepare()
                obj2.execute((error: any, result: any) => {
                    if (error == 1) {
                        let Result: any = result ? result : []

                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: Result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "No data found!",
                            data: []
                        });
                        objv.execute();
                    }
                })
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }


    /**
     * To view the order history
     */
    ViewOrderHistory(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let sdata: any = [];
                sdata = req.query;
                console.log("QRY::", sdata)
                let obj2 = new ModelRawQuery(req, res);
                let objv = new RawView(res);

                let iQry: string = "SELECT `did`,`provider`,`providerOrderId`,`status`,`type`,`cost`,`description`,`log_status`,`log_statusCode`,`log_message`,`log_result`,`log_error`,`order_no`, CASE WHEN is_process=0 THEN 'In Process' WHEN error_code=2 THEN 'Completed' WHEN error_code=4 THEN 'Failed' ELSE 'N/A' END order_status, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `created_date` FROM `did_order`\n"
                iQry += "WHERE iduser=" + sessdata.iduser + " AND id_grouporder=" + sdata.id_grouporder + " ORDER BY id_order DESC;"

                obj2.qrysql = iQry
                obj2.prepare()
                obj2.execute((error: any, result: any) => {
                    if (error == 1) {
                        let Result: any = result ? result : []

                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: Result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "No data found!",
                            data: []
                        });
                        objv.execute();
                    }
                })
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    getDisconnectedDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessdata: any) => {
            if (sessErr == 1) {
                let obj2 = new ModelRawQuery(req, res);
                let con = '';
                if (sessdata.type == 1) // for Admin account
                    con = '';
                else if (sessdata.type == 22) //for sub customer account
                    con = " AND d.iduser = '" + sessdata.iduser + "'";
                else // for customer account
                    con = " AND d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "')";

                obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key WHERE  disconnect_did_status = '2' " + con + ""
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Disconnected DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    // getDisconnectedDid(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "SELECT * FROM `did_buy` WHERE `iduser` = '" + sessData.iduser + "' AND `disconnect_did_status` = '2'";
    //             obj.prepare();
    //             obj.execute((err: any, result: any) => {
    //                 if (err == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: 'DID Fatched', data: result, status: 200 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
    //                     objv.execute();
    //                 }
    //             })
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Authorization!", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

    restoreDisconnectDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessdata: any) => {
            if (sessErr == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let sdata: any = req.body.data;
                    let count: number = 0;
                    sdata.forEach((el: any, idx: any, dids: any) => {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE  `did_buy` SET disconnect_did_status='1' WHERE disconnect_did_status='2' AND `did`=" + el.did + " AND `iddid`=" + el.iddid + "";
                        obj.prepare();
                        obj.execute((err: any, result: any) => {
                            if (err == 1) {
                                count++;
                                console.log("Count ::" + count);
                                if (count == sdata.length) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: 'DID Restored Successfully!', status: 200 });
                                    objv.execute();
                                }
                            }
                        });

                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    public getSmsProvider(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT p.`priority`, u.`username` as `sms_provider` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sdata.type + "') AND p.type='sms'";
                obj1.prepare();
                obj1.execute((error, responce) => {
                    if (error == 1) {
                        if (responce.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "Provider fetched successfully", data: responce });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: "No provider found" });
                            objv.execute();
                        }
                    } else {
                        let objv = new Res404(res);
                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public getMultiSearch(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = JSON.parse(req.body.data);
                var allData: any = [];
                var forNotFound: any = [];
                var roughDID: any = [];

                var didWithLk: any = '';
                var condition: any = "";
                var eMsg = "";

                if (sessdata.type == 1)
                    condition = ""
                if (sessdata.type == 2)
                    condition = " d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";
                if (sessdata.type == 22)
                    condition = " d.`iduser`='" + sessdata.iduser + "' AND ";

                if (sdata.num && sdata.num.length > 0) {
                    var temp: any;
                    var allData: any = [];
                    var forNotFound: any = [];
                    var roughDID: any = [];
                    Object.keys(sdata.num).forEach((ele: any) => {
                        temp = sdata.num[ele].replace(/^\s*/, "").replace(/\s*$/, "").trim();
                        if (temp.length >= 10 && temp.length <= 12 && temp !== undefined) {
                            // allData.push('"' + temp + '"');
                            allData.push(temp);
                            forNotFound.push(temp);
                            didWithLk += " d.`did` LIKE '" + (temp.replace(/"/g, '')).slice(-10) + "%' OR";
                        }
                        else {
                            if (temp.length > 0)
                                roughDID.push(temp);
                        }
                    });
                }

                if (req.file) {
                    let firstrow1 = fs.readFileSync(req.file.path).toString().split('\n');
                    let firstrow = firstrow1[0].split('\r');
                    let str: string = "";
                    if (!firstrow[0].match(/[a-z]/)) {
                        console.log("LETTER FOUND");
                        str = '';
                    } else {
                        console.log("LETTER NOT FOUND");
                        str = 'IGNORE 1 LINES';
                    }
                    var str_array: Array<String> = [];
                    str_array = firstrow[0].split(',');
                    var allData: any = [];
                    var forNotFound: any = [];
                    var roughDID: any = [];
                    for (var i = 1; i < firstrow1.length; i++) {
                        let num: any = firstrow1[i].replace(/^\s*/, "").replace(/\s*$/, "").trim();
                        if (num && num.length >= 10 && num.length <= 12 && num !== undefined) {
                            // allData.push('"' + num + '"');
                            allData.push(num);
                            forNotFound.push(num);
                            didWithLk += " d.`did` LIKE '" + (num.replace(/"/g, '')).slice(-10) + "%' OR";
                        }
                        else {
                            if (num.length > 0)
                                roughDID.push(num);
                        }
                    }
                }

                let DIDL: any = didWithLk !== '' && didWithLk !== undefined ? didWithLk.slice(0, -2) : '';

                if (!sdata.option || sdata.option == 'no') eMsg = "Please select Action Type";
                if (allData.length <= 0) eMsg = "Please send at least one 10 digit's DID";

                if (eMsg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: eMsg, roughDID: roughDID, findDID: [], notFindDID: [] });
                    objv.execute();
                }
                else {
                    let event_type: any = "", descMsg: any = "", errMsg: any = "", keyVal: any = "", event_desc: any = "";
                    switch (sdata.option) {
                        case "connection":
                            event_type = "9"; event_desc = "Connection Disable";
                            descMsg = "Connection Disabled Successfully";
                            errMsg = "Something went wrong with Connection Disabled!";
                            keyVal = " connection_key = '', inbound_key='', outbound_key='', updated_at=NOW() ";
                            break;
                        case "set_connection":
                            event_type = "14"; event_desc = "Connection Updated";
                            descMsg = "Connection Updated Successfully";
                            errMsg = "Something went wrong with Connection Disabled!";
                            keyVal = " connection_key = '" + sdata.connectionValue + "', inbound_key='" + sdata.inboundValue + "', outbound_key='" + sdata.outboundValue + "',updated_at=NOW() ";
                            break;
                        case "auto_enable":
                            event_type = "3"; event_desc = "Auto Renewal Enable";
                            descMsg = "Auto Renewal Enable Successfully";
                            errMsg = "Something went wrong with Auto Renewal Enable!";
                            keyVal = " subscription_auto_renew = 'true', updated_at=NOW() ";
                            break;
                        case "auto_disable":
                            event_type = "8"; event_desc = "Auto Renewal Disable";
                            descMsg = "Auto Renewal Disabled Successfully";
                            errMsg = "Something went wrong with Auto Renewal Disabled!";
                            keyVal = " subscription_auto_renew = 'false', updated_at=NOW() ";
                            break;
                        case "disconnect":
                            event_type = "31"; event_desc = "Bulk DID Delete Initiated";
                            descMsg = "DID Disconnected Successfully";
                            errMsg = "Something went wrong with DID Disconnected!";
                            keyVal = " disconnect_did_status = '2', updated_at=NOW() ";
                            break;
                    }
                    if (sdata.option == "search") {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " (" + DIDL + ") AND d.`disconnect_did_status` = '1' GROUP BY d.`did` ORDER BY d.`iddid` DESC LIMIT 10000";
                        obj1.prepare();
                        obj1.execute((error1, responce) => {
                            if (error1 == 1 && responce.length > 0) {

                                let allFindDID: any = [];
                                responce.forEach((element: any) => {
                                    // allFindDID.push('"' + element.did + '"');
                                    allFindDID.push(element.did);
                                });
                                for (let i of allFindDID) {

                                    const index = forNotFound.indexOf(i);
                                    if (index > -1) { // when item is found
                                        forNotFound.splice(index, 1); // means remove one item only
                                    }
                                }
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Result Fetched Successfully!", data: responce, roughDID: roughDID, findDID: allFindDID, notFindDID: forNotFound });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "DID not found!", roughDID: roughDID, findDID: [], notFindDID: [] });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        // DIDL = d.`did` IN (" + allData + ")
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT d.iddid, d.did, d.iduser, d.account_id, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " (" + DIDL + ") AND d.`disconnect_did_status` = '1' GROUP BY d.`did` ORDER BY d.`iddid` DESC LIMIT 1000";
                        obj1.prepare();
                        obj1.execute((error1, resDD) => {
                            if (error1 == 1 && resDD.length > 0) {

                                var allData1: any = [];
                                var didWithLk1: any = '';
                                let temp: any;
                                resDD.forEach((element: any) => {
                                    temp = element.did.replace(/^\s*/, "").replace(/\s*$/, "").trim();
                                    // allData1.push('"' + element.did + '"');
                                    allData1.push(temp);
                                    didWithLk1 += " d.`did` LIKE '" + (temp.replace(/"/g, '')).slice(-10) + "%' OR";
                                });

                                for (let i of allData1) {
                                    const index = forNotFound.indexOf(i);
                                    if (index > -1) { // when item is found
                                        forNotFound.splice(index, 1); // means remove one item only
                                    }
                                }

                                let DIDL1: any = didWithLk1 !== '' && didWithLk1 !== undefined ? didWithLk1.slice(0, -2) : '';

                                if (DIDL1 !== '') {
                                    // DIDL1 = d.`did` IN (" + allData1 + ")
                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE did_buy d SET " + keyVal + " WHERE " + condition + " " + DIDL1 + ";"
                                    obj2.prepare();
                                    obj2.execute((error, resp) => {
                                        if (error == 1) {
                                            let iQry = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE";
                                            for (let did of allData1) {
                                                iQry += "('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'" + event_type + "','" + event_desc + "','" + did + "'),";
                                            }
                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = iQry.slice(0, -1);
                                            obj0.prepare();
                                            obj0.execute((errLog, resLog) => {
                                                console.log(descMsg);
                                            });
                                            let obj1 = new ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`,d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " (" + DIDL1 + ") AND d.`disconnect_did_status` = '1' GROUP BY d.`did` ORDER BY d.`iddid` DESC LIMIT 1000";
                                            obj1.prepare();
                                            obj1.execute((errDID, resDID) => {
                                                if (errDID == 1) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 200, message: descMsg, data: resDID, roughDID: roughDID, findDID: allData1, notFindDID: forNotFound });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 502, message: errMsg, roughDID: roughDID, findDID: [], notFindDID: [] });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: errMsg, roughDID: roughDID, findDID: [], notFindDID: [] });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 502, message: "DID not found!", roughDID: roughDID, findDID: [], notFindDID: [] });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "DID not found!", roughDID: roughDID, findDID: [], notFindDID: [] });
                                objv.execute();
                            }
                        });
                    }
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}

/**
 * Other class
 */
export class DIDManager {
    constructor() { }
    /**
     * To create the group order for single DID
     */
    public CreateGroupOrder(req: Request, res: Response, sessdata: any, data: any, callback: (err: any, data: any) => void): any {
        const sdata = data;
        if (sdata.via_panel == 0) {
            let oname: any = "SOD" + String(new Date().getTime())
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + oname + "', total_dids=1, process_dids=1, numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "', campaign='" + sdata.campaign + "';"
            obj.prepare();
            obj.execute((error: any, result: any) => {
                if (error == 1) {
                    callback(1, {
                        id_grouporder: result.insertId
                    })
                }
                else {
                    callback(1, {
                        id_grouporder: 0
                    })
                }
            });
        }
        else {
            let id_grouporder: number = (typeof req.body.id_grouporder != 'undefined' && req.body.id_grouporder > 0) ? req.body.id_grouporder : 0;

            callback(1, {
                id_grouporder: id_grouporder
            })
        }
    }

}