"use strict";
const multer1 = require('multer');
import { UploadDirectory } from '../config/setting.config';
let upload = new UploadDirectory();
const MIME_TYPE_MAP1: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx',
    'application/zip': 'zip'
};
const MIME_TYPE_MAP2: any = {
    'text/csv': 'csv',
    'audio/3gpp': '3ga',
    'video/3gpp': '3gp',
    'text/plain': 'txt',
    'audio/amr': 'amr',
    'video/x-msvideo': 'avi',
    'image/bmp': 'bmp',
    'audio/wav': 'wav',
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'text/css': 'css',
    'image/dib': 'dib',
    'image/avif': 'avif',
    'audio/flac': 'flac',
    'video/x-flv': 'flv',
    'image/gif': 'gif',
    'application/x-gzip': 'gz',
    'image/x-icon': 'ico',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'application/javascript': 'js',
    'application/json': 'json',
    'audio/mpeg': 'mp3',
    'video/m1v': 'm1v',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-mp3': 'mp3',
    'video/mp4': 'mp4',
    'audio/x-ms-wma': 'mpa',
    'video/mpeg': 'mpeg',
    'video/mpg': 'mpg',
    'application/pdf': 'pdf',
    'image/pjpeg': 'pjpeg',
    'image/png': 'png',
    'video/quicktime': 'qt',
    'text/rtf': 'rtf',
    'audio/x-wav': 'wav',
    'text/html':'html',
    'video/webm': 'webm',
    'image/webp': 'webp',
    'image/svg+xml': 'svg',
    'video/x-ms-wmv': 'wmv',
    'application/xml': 'xml',
    'application/zip': 'zip',
    'application/x-zip-compressed': 'zip',
    'application/x-msdownload' : 'exe',
    'application/vnd.ms-excel': 'xls',
    'text/javascript': 'js',
    'application/octet-stream': 'rar',
    'application/vnd.ms-powerpoint': 'ppt',
    'application/msword': 'doc',
    'application/x-freearc': 'arc',
    'application/java-archive': 'jar',
    'application/vnd.openxmlformats-officedocument.presentationml.presentation': 'pptx',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx',
};

const storage1 = multer1.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let store: any;
        if (req.route.path == "/savenotifyemail") {
            store = upload.EMAILNOTIFICATION;            
            const isValid = MIME_TYPE_MAP2[file.mimetype];
            let error: any = "";
            if (!isValid) {
                error = new Error("Invalid file type");
            }
            cb(error, store);
        } else {
            store = upload.TOLLFREEUPLOADS;
            const isValid = MIME_TYPE_MAP1[file.mimetype];
            let error: any = "";
            if (!isValid) {
                error = new Error("Invalid file type");
            }
            cb(error, store);
        }
    },
    filename: (req: any, file: any, cb: any) => {
        const name = file.originalname.toLowerCase().split(' ').join('_');
        let ext: any;
        if (req.route.path == "/savenotifyemail") {
            ext = MIME_TYPE_MAP2[file.mimetype];
        } else {
            ext = MIME_TYPE_MAP1[file.mimetype];
        }
        cb(null, Date.now() + '.' + ext);
    }
});



//module.exports = multer1({ storage: storage1 }).single('ATTACHMENT');
module.exports = [multer1({ storage: storage1 }).array('ATTACHMENTS')];
