"use strict";
const multer1 = require('multer');
import { UploadDirectory } from '../config/setting.config';

const MIME_TYPE_MAP1: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'application/pdf': 'pdf',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4'
};

const storage1 = multer1.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let mmsdir = new UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let error: any = "";
        let store : any;
        if (req.route.path  === "/uploadmmsmedia") {
            store = mmsdir.MMSUPLOADS;
        }else{
            store = mmsdir.MEDIAUPLOAD; 
        }
        cb(error, store);
    },
    filename: (req: any, file: any, cb: any) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName: any = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, fileName);
    }
});


module.exports = multer1({ storage: storage1 }).single('UPLOAD');
