import e, { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelPdfUpload } from "../lib/model/ModelPdfUpload";
import { ModelRawQuery } from "../lib/model/RawQuery";
const Str = require('@supercharge/strings');
var nodemailer = require("nodemailer");
const jwt = require('jsonwebtoken');
const request = require("request");
import { sessiondata, login_logout } from '../server';
import md5 from "md5";
import { Connection } from './connections'
import * as bcrypt from 'bcrypt'
import { EmailSettingForSupport, LinkVerify, Profile, SMTPDetails, TemplateURl } from "../config/setting.config";
import { parseBody, ipAddressAndBrowser } from "./markError";
let URLlink = new LinkVerify();
let profile_pic = new Profile();
const emailSetting = new EmailSettingForSupport();
const supportEmail = emailSetting.EMAIL;
const templateURL = new TemplateURl();
const FromSmtpMail = new SMTPDetails();
const FromEmail = FromSmtpMail.from;
const makeNumber = (length: number) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}
const makeChar = (length: number) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const makeRanChar = (length: number) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const generatePassword = () => {
    let result: any = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
}

export class UserManagement extends AppRoute {
    constructor() {
        super();
    }

    /**
     * To authenticate user with TimeZone
     */

    getMorphingSession(req: Request, res: Response, next: NextFunction) {
        let pData: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey` = '" + pData.key + "'";
                obj.prepare();
                obj.execute((error: any, resSession: any) => {
                    let data: any = resSession[0];
                    let objup = new ModelRawQuery(req, res);
                    objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + resSession[0].iduser + "'";
                    objup.prepare();
                    objup.execute((__errorE: any, emailE: any) => {
                        let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                        let emType = JSON.parse(tmp);
                        let result: any = Object.assign(data, emType);
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Session Data Fetch Successfully!", status: 200, data: [result] });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong to Fetch Session", status: 502, result: result });
                            objv.execute();
                        }

                    })
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getLogin(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        //let pass: string = md5(sdata.password)
        let email: string = sdata.username
        let pass1: any = sdata.password
        let obj: any = new ModelRawQuery(req, res)
        let iQry: string = "SELECT us.iduser, us.idaccount, us.username, us.password, us.type, us.default, us.idtariff, us.isEmailVerify, us.isMobileVerify, us.isPlan, us.isAddress,us.isCard,us.newUser_status, '-08:00' client_time, IF(us.is_deleted = 0, 9, us.is_deleted) acc_status, us.kyc_verify_status, us.resetPassword FROM user us\n"
        iQry += "WHERE us.`username`='" + parseBody(sdata.username) + "';"
        obj.qrysql = iQry;
        if (obj.prepare()) {
            obj.execute((error: any, result: any) => {

                if (result.length > 0) {
                    let objup = new ModelRawQuery(req, res);
                    objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + result[0].iduser + "'";
                    objup.prepare();
                    objup.execute((__errorE: any, emailE: any) => {
                        /* result[0].server_time = result[0].server_time.slice(0, -3)
                        if (result[0].server_time.indexOf("+") < 0 && result[0].server_time.indexOf("-") < 0) {
                            result[0].server_time = "+" + result[0].server_time
                        } */

                        //if (pass == md5(result[0].password)) {
                        if ((bcrypt.compareSync(pass1, result[0].password) || (pass1 == result[0].password))) {
                            if (result[0].type == 1 || result[0].type == 2 || result[0].type == 22) {
                                let data: any = result[0];
                                let tmp: string = "{\"sessionType\": \"" + sdata.sessionType + "\"}";
                                let loginType = JSON.parse(tmp);
                                let Result: any = Object.assign(data, loginType);
                                if ((data.acc_status == 9) || (sdata.typeCheck && sdata.typeCheck == "admin_checking")) {
                                    delete data.acc_status
                                    let session = new SessionManagment(req, res, next);
                                    session.SetSession(Result, (error: any, sessdata: any) => {
                                        // To set User Login Activity
                                        let sysInfo = ipAddressAndBrowser(req);
                                        let objh = new ModelRawNonQuery(req, res);
                                        objh.nonqrysql = "INSERT INTO `user_login_history`(`iduser`, `idaccount`, `type`, `token`, `ipaddress`, `browser`, `login_time`, `login_type`) VALUES ('" + result[0].iduser + "','" + result[0].idaccount + "','" + result[0].type + "', '" + Result.authkey + "', '" + sysInfo.ipAddress[0] + "', '" + sysInfo.browserName + "', NOW(),'login')";
                                        objh.prepare();
                                        objh.execute((error: any, data: any) => {

                                        });
                                        // To Merge
                                        let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                                        let emType = JSON.parse(tmp);
                                        let data1: any = Object.assign(data, emType);

                                        let objv = new RawView(res);
                                        objv.prepare(data1);
                                        objv.execute();
                                    });

                                }
                                else {
                                    let errMsg: string = data.acc_status == 1 ? "Your account deletion in under process!" : "Your account has been deleted, If you want to restore kindly contact with customer support!"
                                    let errCode = data.acc_status == 1 ? "DelInProcess" : "Deleted";
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: errMsg, error: errCode
                                    });
                                    objv.execute();
                                }



                                /**
                                 * It will create default timezone of user if doesn't exist
                                 */
                                // if (data.client_time == null || !data.client_time) {
                                //     let obj2 = new ModelRawNonQuery(req, res);
                                //     obj2.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(192, " + data.iduser + ");"
                                //     obj2.prepare()
                                //     obj2.execute((error: any, result: any) => {
                                //         if (error == 1) {
                                //             /**
                                //              * Update the TimeZone in user's session data
                                //              */
                                //             obj2.nonqrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=192;"
                                //             obj2.prepare()
                                //             obj2.execute((error: any, result: any) => {
                                //                 if (error == 1 && result.length > 0) {
                                //                     data.client_time = result[0].client_time
                                //                 }
                                //                 session.SetSession(data, (error: any, sessdata: any) => {
                                //                     let objv = new RawView(res);
                                //                     objv.prepare(data);
                                //                     objv.execute();
                                //                 });
                                //             })
                                //         }
                                //         else {
                                //             session.SetSession(data, (error: any, sessdata: any) => {
                                //                 let objv = new RawView(res);
                                //                 objv.prepare(data);
                                //                 objv.execute();
                                //             });
                                //         }
                                //     })
                                // }

                                /**
                                 * If user's timezone exist it will continue
                                 */
                                // else {
                                //     session.SetSession(data, (error: any, sessdata: any) => {
                                //         let objv = new RawView(res);
                                //         objv.prepare(data);
                                //         objv.execute();
                                //     });
                                // }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "You are not Authorized for this Panel!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Invalid Username/Password, Kindly check again!"
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Invalid Username/Password, Kindly check again!" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView(res);
            objv.prepare({
                message: "Few parameter are missing in request!"
            });
            objv.execute();
        }
    }


    /**
     * To save the system timezone into user's profile
     */
    SaveSysTZ(req: Request, res: Response, next: NextFunction) {
        let sdata: any = null
        try {
            sdata = JSON.parse(req.body.data);
        } catch (e) {
            sdata = req.body.data;
        }

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj: any = new ModelRawNonQuery(req, res)
                let objr: any = new ModelRawQuery(req, res)
                let objv: any = new RawView(res)

                objr.qrysql = "SELECT id FROM `tbl_timezones` WHERE utc='" + sdata.utc + "' AND tzCode='" + sdata.tzCode + "';"
                objr.prepare()
                objr.execute((error: any, result: any) => {
                    if (error == 1) {
                        let id_tz: number = result.length > 0 ? result[0].id : 0
                        obj.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(" + id_tz + ", " + sessdata.iduser + ");"
                        obj.prepare()
                        obj.execute((error: any, result: any) => {
                            if (error == 1) {
                                /**
                                 * It will update the current user's
                                 * session table + session data
                                 */
                                obj.nonqrysql = "UPDATE `session` SET `client_time`='" + sdata.utc + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                obj.prepare()
                                obj.execute((error: any, result2: any) => {
                                    sessdata.client_time = sdata.utc
                                    sessiondata.set(sessdata.authkey, sessdata)
                                })
                            }
                            else {
                                objv.prepare({
                                    error: 1,
                                    message: "Something went wrong!"
                                })
                                objv.execute()
                            }
                        })
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something went wrong!"
                        })
                        objv.execute()
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    VerifyUrl(req: Request, res: Response, next: NextFunction) {
        let gquery = req.query;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `url`  FROM `signup_referral_link` WHERE `url` = '" + gquery.type + "'";
        obj.prepare();
        obj.execute((_error: any, getUrl: any) => {
            if (_error == 1) {
                if (getUrl.length > 0) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "URL Matched Successfully!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "This Link has been expired!", status: 404 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Somthing went wrong with verifying url!", status: 502 });
                objv.execute();
            }

        });
    }

    signUp(req: Request, res: Response, next: NextFunction) {
        // const ipAddress = req.socket.remoteAddress;
        let sysInfo = ipAddressAndBrowser(req);
        let sdata = req.body.data;
        let data = req.query;
        let reseller_id: any;
        let signup_link_id: any;
        let url: any = data.type;
        let signUpLinkUrl: any = '';
        let filePath: any = URLlink.SIGNALHOST;
        let url1 = url.split('/signup')[1];
        let url2 = url1.split('url=')[1];
        if (url2 == undefined) {
            reseller_id = null;
            signup_link_id = null;
        }
        else {
            let url4 = url.split(filePath + '/#/signup?url=')[1];
            let decodeUrl = Buffer.from(url4, "base64").toString("utf8").replace('_', '=').replace('_', '=');
            let user_id = decodeUrl.split('iduser=')[1];
            reseller_id = user_id.split('&idtariff')[0]
            signup_link_id = decodeUrl.split('&ukey=')[1];
            signUpLinkUrl = signup_link_id.replace(/[^A-Za-z:0-9]/g, "");
        }

        let secret = Str.random(15);
        let validationKey = jwt.sign({
            exp: Math.floor(Date.now() / 1000) + (60 * 60),
            data: sdata.email + ":" + sdata.password
        }, secret);
        var isPlan: Boolean;
        var tariff: any;
        if (sdata.tariff1 == -1 || sdata.tariff1 == 0) {
            isPlan = false;
            tariff = '-1';
        }
        else {
            isPlan = true;
            tariff = sdata.tariff1;
        } if (sdata.imgUrl) {
            sdata.imgUrl = sdata.imgUrl;
        }
        else {
            sdata.imgUrl = "https://portal.signalmash.com/assets/img/icon.png";
        }

        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `email` = '" + sdata.email + "' OR `first_name` = '" + parseBody(sdata.firstName) + "' OR `last_name` = '" + parseBody(sdata.lastName) + "' OR `domain_name` = '" + sdata.email.split('@')[1] + "'";
        obj.prepare();
        obj.execute((_errDomainBlk: any, getDomainBlock: any) => {
            if (_errDomainBlk == 1 && getDomainBlock.length > 0) {

                let errMsg = '';
                if (getDomainBlock[0].email == sdata.email)
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].domain_name == sdata.email.split('@')[1])
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].first_name == sdata.firstName)
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].last_name == sdata.lastName)
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].ipAddress == sdata.ipAddress)
                    errMsg = "Invalid Account Registration!";
                else
                    errMsg = "You Can't Register With Invalid Details!";

                let objv = new RawView(res);
                objv.prepare({
                    message: errMsg,
                    status: 501
                });
                objv.execute();
            }
            else {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE email = '" + sdata.email + "' OR username = '" + sdata.email + "'";
                obj.prepare();
                obj.execute((_error: any, getEmail: any) => {
                    if (_error == 1) {
                        if (getEmail.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Email Or Username Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let objp = new ModelRawQuery(req, res);
                            let Qry: any = '';
                            if (reseller_id) {
                                Qry = "SELECT `idservice` FROM `reseller` WHERE iduser='" + reseller_id + "'";
                            }
                            else {
                                Qry = "SELECT `idservice` FROM `service` WHERE iduser='1' AND `is_default`='true'";
                            }
                            objp.qrysql = Qry;
                            objp.prepare();
                            objp.execute((errservp: any, _resp: any) => {
                                let service_id = _resp[0].idservice ? _resp[0].idservice : 0;
                                //hash password 
                                let password1 = bcrypt.hashSync(sdata.password, 10)
                                let obj2 = new ModelRawNonQuery(req, res);

                                obj2.nonqrysql = "CALL AddUser(-1, -1, '" + sdata.email + "','" + parseBody(password1) + "','2','" + parseBody(sdata.firstName) + "','" + parseBody(sdata.lastName) + "','" + sdata.email + "',' ','" + sdata.imgUrl + "','1', '" + tariff + "', '" + sdata.tariff2 + "', '" + sdata.status + "', '" + service_id + "', '0')";
                                obj2.prepare();
                                obj2.execute((__error: any, __res: any) => {
                                    let iduser = __res[0];

                                    if (__error == 1) {

                                        // To Update User
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `user` SET `trust_score`='1',`validationKey`='" + validationKey + "', `secret`='" + secret + "', `isPlan`='" + isPlan + "', `idtariff`='" + tariff + "',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`ext_name`='" + parseBody(sdata.password) + "',`resetPassword`='1',`reseller_iduser`='" + reseller_id + "',`signup_link_id`='" + signUpLinkUrl + "',`newUser_status`='1',`email_verification_date`=NOW() WHERE `iduser`='" + iduser[0].userid + "'";
                                        obj3.prepare();
                                        obj3.execute((_err: any, __result: any) => {
                                            if (_err == 1) {
                                                console.log("User Updated Successfully!");
                                            }
                                            else {
                                                console.log("Error With Update User!");
                                            }
                                        });
                                        // To Update Account
                                        let objA = new ModelRawNonQuery(req, res);
                                        objA.nonqrysql = "UPDATE `account` SET `san`=(100000000 + '" + iduser[0].account + "') WHERE `idaccount`='" + iduser[0].account + "'";
                                        objA.prepare();
                                        objA.execute((_errAccount: any, __resultAccount: any) => {
                                            if (_errAccount == 1) {
                                                console.log("San Number Updated.");
                                            }
                                            else {
                                                console.log("Error With SAN Number!");
                                            }
                                        });

                                        // To Insert Account Services 
                                        const accService = new UserManagement();
                                        accService.accountServices(req, res, iduser[0].account, (errorr, resp) => {
                                            if (resp.status == 200) {
                                                console.log("Services Inserted Successfully.");
                                            }
                                            else {
                                                console.log("Something went wrong in account service insertion!");
                                            }
                                        });

                                        // To Create Connection
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = sdata.firstName + val1;
                                        obj2.qrysql = "CALL addconnection('" + iduser[0].account + "', '" + iduser[0].userid + "', '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Registered Successfully! But Default Connection Not Created!");
                                            }
                                        });

                                        // To Update Timezone
                                        let objTime = new ModelRawNonQuery(req, res);
                                        objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user='" + iduser[0].userid + "'";
                                        objTime.prepare();
                                        objTime.execute((errTime: any, sTime: any) => {
                                            if (errTime == 1) {
                                                console.log("Time Zone Updated!");
                                            }
                                            else {
                                                console.log("Registered Successfully! But Default Time Zone has error!");
                                            }
                                        });
                                        // To Send Mail To Support
                                        let objsup = new ModelRawQuery(req, res);
                                        objsup.qrysql = "SELECT `subject`,`template` FROM `email_template` WHERE type='signup_notification_to_support'";
                                        objsup.prepare();
                                        objsup.execute((emlErr: any, emlRes: any) => {
                                            if (emlErr == 1) {
                                                if (emlRes.length > 0) {
                                                    // To Send mail to support
                                                    let tmpDataSup = emlRes[0].template;
                                                    let san = Math.floor(Math.floor(100000000) + Math.floor(iduser[0].account));
                                                    tmpDataSup = tmpDataSup.replace(/{SAN_NUMBER}/g, san);
                                                    tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, sdata.firstName);
                                                    tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, sdata.lastName);
                                                    tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, sdata.email);

                                                    // var smtpTransport = nodemailer.createTransport({
                                                    //     service: "gmail",
                                                    //     host: "smtp-relay.gmail.com",
                                                    //     port: 587,
                                                    //     secure: true,
                                                    //     auth: {
                                                    //         user: "donotreply@nglcommunications.com",
                                                    //         pass: "yr%5V9GB"
                                                    //     }
                                                    // });                                               

                                                    // var mailOptionsSupport = {
                                                    //     from: 'Signalmash <donotreply@signalmash.com>',
                                                    //     to: supportEmail,
                                                    //     usernmae: supportEmail,
                                                    //     email: supportEmail,
                                                    //     subject: `${emlRes[0].subject}`,
                                                    //     text: "New User Signup",
                                                    //     html: `${tmpDataSup}`
                                                    // }
                                                    // smtpTransport.sendMail(mailOptionsSupport, (_emailSupError: any, emailSupRes: any) => {
                                                    //     if (emailSupRes) {
                                                    //         console.log("Mail successfully sent to support.");
                                                    //     }
                                                    //     else {
                                                    //         console.log("Mail not sent to support.");
                                                    //     }
                                                    // });

                                                    let obj10 = new ModelRawNonQuery(req, res);
                                                    // obj10.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + iduser[0].userid + "','" + iduser[0].account + "','" + FromEmail + "','" + supportEmail + "', '" + parseBody(emlRes[0].subject) + "','New User Signup', '" + parseBody(tmpDataSup) + "','New User Signup','1')";

                                                    const Spmail = supportEmail.split(",");
                                                    let qry = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES";
                                                    for (let i = 0; i < Spmail.length; i++) {
                                                        let entry = Spmail[i];
                                                        qry += "('" + iduser[0].userid + "','" + iduser[0].account + "','" + FromEmail + "','" + entry + "', '" + parseBody(emlRes[0].subject) + "','New User Signup', '" + parseBody(tmpDataSup) + "','New User Signup','1'),";
                                                    }
                                                    obj10.nonqrysql = qry.slice(0, -1)

                                                    obj10.prepare();
                                                    obj10.execute((_err: any, __result: any) => {
                                                        if (_err == 1) {
                                                            console.log("Mail successfully sent to support.")
                                                        }
                                                        else {
                                                            console.log("Mail not sent to support.");
                                                        }
                                                    });

                                                }
                                                else {
                                                    console.log("No Email Template Available For Support Notification.");
                                                }
                                            }
                                            else {
                                                console.log("Something Went Wrong With Get Email Template.");
                                            }
                                        });

                                        let obj4 = new ModelRawQuery(req, res);
                                        obj4.qrysql = "SELECT body, otp_digit, tmp_type  FROM `2fa_template` WHERE iduser='1' AND tmp_type='sms' AND `default`='1'";
                                        obj4.prepare();
                                        obj4.execute((errOtp: any, _res: any) => {
                                            let message = "";
                                            let otp_digit = "";
                                            let temp_type = "";
                                            let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
                                            let temp_key = '';
                                            let charactersLength = characters.length;
                                            for (let i = 0; i < 25; i++) {
                                                temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
                                            }
                                            if (_res.length > 0) {
                                                message = _res[0].body;
                                                otp_digit = _res[0].otp_digit;
                                                temp_type = _res[0].tmp_type;
                                            }
                                            else {
                                                message = "Your One time Password is {OTP}";
                                                otp_digit = "5";
                                                temp_type = "sms";
                                            }
                                            let objTime = new ModelRawNonQuery(req, res);
                                            objTime.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`,`body`, `tmp_type`,`template_key`,`default`) VALUES ('" + iduser[0].userid + "','" + otp_digit + "','" + message + "', '" + temp_type + "','" + temp_key + "','1')";
                                            objTime.prepare();
                                            objTime.execute((err: any, sTime: any) => {
                                                if (err == 1) {
                                                    let obj4 = new ModelRawQuery(req, res);
                                                    obj4.qrysql = "SELECT `subject`,`template` FROM `email_template` WHERE type='email_verification'";
                                                    obj4.prepare();
                                                    obj4.execute((emlErr: any, emlRes: any) => {
                                                        if (emlErr == 1) {
                                                            if (emlRes.length > 0) {
                                                                let tmpData = emlRes[0].template;
                                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.firstName);
                                                                tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.lastName);
                                                                tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);

                                                                // var smtpTransport = nodemailer.createTransport({
                                                                //     service: "gmail",
                                                                //     host: "smtp-relay.gmail.com",
                                                                //     port: 587,
                                                                //     secure: true,
                                                                //     auth: {
                                                                //         user: "donotreply@nglcommunications.com",
                                                                //         pass: "yr%5V9GB"
                                                                //     }
                                                                // });
                                                                // var mailOptions = {
                                                                //     from: 'Signalmash <donotreply@signalmash.com>',
                                                                //     to: sdata.email,
                                                                //     usernmae: sdata.email,
                                                                //     email: sdata.email,
                                                                //     subject: `${emlRes[0].subject}`,
                                                                //     text: "Thank You For Registration",
                                                                //     html: `${tmpData}`
                                                                // }
                                                                // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                                //     if (emailRes) {
                                                                //         delete sdata.password;
                                                                //         let objv = new RawView(res);
                                                                //         objv.prepare({ result: sdata, key: validationKey, iduser: iduser[0].userid, status: 201, data: emailRes, message: "Congratulations on your well-deserved success. Account Successfully Created And Email Sent To Your " + sdata.email });
                                                                //         objv.execute();
                                                                //     }
                                                                //     else {
                                                                //         let objv = new RawView(res);
                                                                //         objv.prepare({ status: 401, message: "Registered Successfully But verification Email Not Send. Kindly Contact With Support!", error: _emailError });
                                                                //         objv.execute();
                                                                //     }
                                                                // });

                                                                let obj11 = new ModelRawNonQuery(req, res);
                                                                obj11.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + iduser[0].userid + "','" + iduser[0].account + "','" + FromEmail + "','" + sdata.email + "', '" + parseBody(emlRes[0].subject) + "','Thank You For Registration', '" + parseBody(tmpData) + "','Thank You For Registration','2')";
                                                                obj11.prepare();
                                                                obj11.execute((_err: any, __result: any) => {
                                                                    if (_err == 1) {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ result: sdata, key: validationKey, iduser: iduser[0].userid, status: 201, message: "Congratulations on your well-deserved success. Account Successfully Created And Email Sent To Your " + sdata.email });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 401, message: "Registered Successfully But verification Email Not Send. Kindly Contact With Support!" });
                                                                        objv.execute();
                                                                        console.log("Error In Updating Password!");
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Registered Successfully. Email Template Not Available!", status: 502 });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Registered But Error With Fetching Email Data!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Template not Inserted Successfully!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong with Signup!", status: 502 });
                                        objv.execute();
                                    }
                                });

                            });


                            // res.status(200).json({data: result, message: "Signup Successfully!"});
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went with Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
        });
    }

    accountServices(req: Request, res: Response, idaccount: any, callback: (err: any, data: any) => void) {
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `fs_id`,`fs_name` FROM `feature_service`";
        obj.prepare();
        obj.execute((_error: any, result: any) => {

            let qry = "INSERT INTO `account_service` (`idaccount`,`fs_id`,`as_status`) VALUES";
            result.forEach((ele: any) => {
                qry += "('" + idaccount + "','" + ele.fs_id + "','1'),";
            });

            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = qry.slice(0, -1);
            obj.prepare();
            obj.execute((_err: any, data: any) => {
                if (_err == 1) {
                    callback(1, { message: "Account services inserted successfully!", status: 200 })
                }
                else {
                    callback(0, { message: "Something went wrong!", status: 502 })
                }
            });
        });
    }


    makeNumber(len: any) {
        var result = '';
        var characters = '09876543212346543098765123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }
    makeChar(len: any) {
        var result = '';
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }

    makeRanChar(len: any) {
        var result = '';
        var characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }


    public AdminSave(req: Request, res: Response, next: NextFunction) {
        // const ipAddress = req.socket.remoteAddress;
        let sysInfo = ipAddressAndBrowser(req);
        let sdata: any;
        let filePath: any = "https://portal.signalmash.com/assets/img/icon.png";
        try {
            sdata = JSON.parse(req.body.data);
        } catch (e) {
            sdata = JSON.parse(req.body.data);
        };
        if (req.file) {
            const fileName = req.file.filename;
            filePath = 'https://api.signalmash.com' + '/uploads/' + fileName;
        }
        if (sdata.profile_pic) {
            filePath = sdata.profile_pic
        }
        let session = new SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sdata.idaccount == -1) {
                    /**
                     * To add/save customer from admin side
                     */
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + parseBody(sdata.user_name) + "' OR email = '" + sdata.email + "'";
                    obj.prepare();
                    obj.execute((_error: any, getUser: any) => {
                        if (_error == 1) {
                            if (getUser.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Username or Email Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                let planVerify: any = sdata.tariff1 ? 'true' : 'false';
                                let obj1 = new ModelRawNonQuery(req, res);
                                let password1 = bcrypt.hashSync(sdata.password, 10);
                                obj1.nonqrysql = "CALL AddUser(-1, -1, '" + parseBody(sdata.user_name) + "','" + parseBody(password1) + "','" + sdata.type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','1', '" + sdata.tariff1 + "', '" + sdata.tariff2 + "', '" + sdata.status + "', '" + sdata.service + "', '" + sdata.credit_limit + "')";
                                if (sdata.type == 2) {
                                    msg = "Customer Added Successfully.";
                                }
                                if (sdata.type == 3) {
                                    msg = "Supplier Added Successfully.";
                                }
                                obj1.prepare();
                                obj1.execute((__error: any, result: any) => {
                                    if (__error == 1) {
                                        let newRes = result[0];
                                        // To Create Customer
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = parseBody(sdata.first_name) + val1;
                                        obj2.qrysql = "CALL addconnection('" + newRes[0].account + "', '" + newRes[0].userid + "', '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Connection Not Created!");
                                            }
                                        });

                                        // To Update Billing Address
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`,`customerType`, `businessName`, `ein`, `website`, `title`, `groupExmpt_number`) VALUES ('" + newRes[0].account + "', '" + parseBody(sdata.first_name) + "', '" + parseBody(sdata.last_name) + "', '" + sdata.contact_number + "', '" + sdata.email + "', '" + parseBody(sdata.address1) + "', '" + parseBody(sdata.address2) + "', '" + parseBody(sdata.city) + "', '" + parseBody(sdata.state) + "', '" + parseBody(sdata.postal_code) + "', '" + sdata.country + "', '" + sdata.customerType + "', '" + sdata.businessName + "', '" + sdata.ein + "', '" + sdata.website + "', '" + sdata.title + "', '" + sdata.groupExmpt_number + "')";
                                        obj.prepare();
                                        obj.execute((_error: any, data: any) => {
                                            if (__error == 1) {
                                                console.log("Billing Address Added Successfully.");
                                            }
                                            else {
                                                console.log("Billing Address Not Added!");
                                            }
                                        });

                                        // To Update User
                                        let obj11 = new ModelRawNonQuery(req, res);
                                        obj11.nonqrysql = "UPDATE `user` SET `trust_score`='1',`isEmailVerify`='" + sdata.isEmailVerify + "',`isMobileVerify`='" + sdata.isMobileVerify + "', `isPlan`= '" + planVerify + "', `isAddress`='" + sdata.isAddress + "', `ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`ext_name`='" + parseBody(sdata.password) + "',`isCard`='false',`newUser_status`='1',`resetPassword`='1',`reseller_iduser`='" + sdata.reseller_id + "' WHERE `idaccount`='" + newRes[0].account + "'";
                                        obj11.prepare();
                                        obj11.execute((_errorrr: any, resultt: any) => {
                                            if (_errorrr == 1) {
                                                console.log("User Updated Successfully.");
                                            }
                                            else {
                                                console.log("User Not Updated!");
                                            }
                                        });
                                        let obj15 = new UserManagement();
                                        obj15.sendEmailVerify(req, res, sdata, newRes, next);
                                        // To Update Account
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `account` SET `san`=(100000000 + '" + newRes[0].account + "') WHERE `idaccount`='" + newRes[0].account + "'";
                                        obj3.prepare();
                                        obj3.execute((_uperr: any, __result: any) => {
                                            if (_uperr == 1) {
                                                console.log("Account Updated Successfully.");
                                            }
                                            else {
                                                console.log("Account Not Updated!");
                                            }
                                        });

                                        // To Insert Account Services 
                                        const accService = new UserManagement();
                                        accService.accountServices(req, res, newRes[0].account, (errorr, resp) => {
                                            if (resp.status == 200) {
                                                console.log("Services Inserted Successfully.");
                                            }
                                            else {
                                                console.log("Something went wrong in account service insertion!");
                                            }
                                        });

                                        // To Insert Timezone Config
                                        let objTime = new ModelRawNonQuery(req, res);
                                        objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user='" + newRes[0].userid + "'";
                                        objTime.prepare();
                                        objTime.execute((errTime: any, sTime) => {
                                            if (errTime == 1) {
                                                console.log("Time Zone Inserted Successfully.");
                                            }
                                            else {
                                                console.log("Time Zone Not Inserted!");
                                            }
                                        });

                                        let obj4 = new ModelRawQuery(req, res);
                                        obj4.qrysql = "SELECT body, otp_digit, tmp_type  FROM `2fa_template` WHERE iduser='1' AND tmp_type='sms' AND `default`='1'";
                                        obj4.prepare();
                                        obj4.execute((sessdata: any, _res: any) => {
                                            let message = "";
                                            let otp_digit = "";
                                            let temp_type = "";
                                            let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
                                            let temp_key = '';
                                            let charactersLength = characters.length;
                                            for (let i = 0; i < 25; i++) {
                                                temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
                                            }
                                            if (_res.length > 0) {
                                                message = _res[0].body;
                                                otp_digit = _res[0].otp_digit;
                                                temp_type = _res[0].tmp_type;
                                            } else {
                                                message = "Your One time Password is {OTP}";
                                                otp_digit = "5";
                                                temp_type = "sms";
                                            }
                                            let objTime = new ModelRawNonQuery(req, res);
                                            objTime.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`,`body`, `tmp_type`,`template_key`,`default`) VALUES ('" + newRes[0].userid + "','" + otp_digit + "','" + message + "', '" + temp_type + "','" + temp_key + "','1')";
                                            objTime.prepare();
                                            objTime.execute((err: any, sTime: any) => {
                                                if (err == 1) {
                                                    console.log("Default Template Created.");
                                                }
                                                else {
                                                    console.log("Template Not Created!");
                                                }
                                            });
                                        });
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result[0], message: "Customer Created Successfully!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result[0], message: "Customer Not Created!", status: 502 });
                                        objv.execute();
                                    }
                                });

                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    /**
                     * To add/save subcustomer of customer from admin side
                     */
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + parseBody(sdata.user_name) + "' OR email = '" + sdata.email + "'";
                    obj.prepare();
                    obj.execute((_error: any, getUser: any) => {
                        if (_error == 1) {
                            if (getUser.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Username or Email Already Exists!", status: 404 });
                                objv.execute();
                            } else {
                                let obj1 = new ModelRawNonQuery(req, res);
                                let password1 = bcrypt.hashSync(sdata.password, 10);
                                obj1.nonqrysql = "CALL AddUser('" + sdata.idaccount + "', -1, '" + parseBody(sdata.user_name) + "','" + parseBody(password1) + "','" + sdata.type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','0', '" + sdata.tariff1 + "','" + sdata.tariff2 + "', '" + sdata.status + "', '" + sdata.service + "', '" + sdata.credit_limit + "')";
                                if (sdata.type == 2) {
                                    msg = "Customer Updated Successfully";
                                }
                                if (sdata.type == 3) {
                                    msg = "Supplier Updated Successfully";
                                }
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let newRes = result[0];
                                        // To Create Customer
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = parseBody(sdata.first_name) + val1;
                                        obj2.qrysql = "CALL addconnection('" + newRes[0].account + "', '" + newRes[0].userid + "', '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Connection Not Created!");
                                            }
                                        });

                                        if (sdata.type == 22) {
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = '" + sdata.idaccount + "'";
                                            obj0.prepare();
                                            obj0.execute((_errorser: any, getSer: any) => {
                                                if (_errorser == 1) {
                                                    let service = getSer[0].idservice;
                                                    let idtariff = getSer[0].idtariff;
                                                    let obj11 = new ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "UPDATE `user` SET `idtariff`='" + idtariff + "',`idservice`='" + service + "',`isAddress`='true',`isCard`='true',`newUser_status`='" + sdata.newUser_status + "',`resetPassword`='1', `ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "', `ext_name`='" + parseBody(sdata.password) + "' WHERE `iduser`='" + newRes[0].userid + "'";
                                                    obj11.prepare();
                                                    obj11.execute((_errorrr: any, resultt: any) => {
                                                        if (_errorrr == 1) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ data: resultt[0], message: "Customer Created Successfully!", status: 201 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ data: resultt, message: "Something Went Wrong With Connection!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Tarif And Service!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ data: result[0], message: "Profile Updated Successfully!", status: 201 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public SaveUser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sysInfo = ipAddressAndBrowser(req);
                let sdata: any;
                let filePath: any = "https://portal.signalmash.com/assets/img/icon.png";
                try {
                    sdata = JSON.parse(req.body.data);
                } catch (e) {
                    sdata = req.body.data;
                }
                if (req.file) {
                    const fileName = req.file.filename;
                    // var filePath = req.protocol + '://' + req.get("host") + "/uploads/" + fileName;
                    filePath = 'https://api.signalmash.com' + '/uploads/' + fileName;
                }
                if (sdata.profile_pic != null || sdata.profile_pic != undefined) {
                    filePath = sdata.profile_pic
                }
                let obj = new ModelRawNonQuery(req, res);
                let message = "";
                if (sdata.iduser == -1) {
                    /**
                     * To save/add subcustomer of customer from customer side
                     */
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + parseBody(sdata.user_name) + "' OR email = '" + sdata.email + "'";
                    obj1.prepare();
                    obj1.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Username or Email Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                let password1 = bcrypt.hashSync(sdata.password, 10);
                                obj.nonqrysql = "CALL AddUser('" + sessdata.idaccount + "', -1, '" + parseBody(sdata.user_name) + "','" + parseBody(password1) + "','" + sdata.type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','0', '" + sdata.tariff1 + "', '" + sdata.tariff2 + "', '" + sdata.status + "', '" + sdata.service + "', '" + sdata.credit_limit + "')";
                                if (sdata.type == 2) {
                                    message = "Customer Added Successfully";
                                }
                                if (sdata.type == 3) {
                                    message = "Supplier Added Successfully";
                                }
                                obj.prepare();
                                obj.execute((__error: any, result: any) => {
                                    if (__error == 1) {
                                        // To Create Connection
                                        let newRes = result[0];
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = sdata.first_name + val1;
                                        obj2.qrysql = "CALL addconnection('" + newRes[0].account + "', '" + newRes[0].userid + "', '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Connection Not Created!");
                                            }
                                        });
                                        // To Update Account
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `account` SET `san`=(100000000 + '" + newRes[0].account + "') WHERE `idaccount`='" + newRes[0].account + "'";
                                        obj3.prepare();
                                        obj3.execute((_uperr: any, __result: any) => {
                                            if (_uperr == 1) {
                                                console.log("Account Updated Successfully.");
                                            }
                                            else {
                                                console.log("Account Not Updated!");
                                            }
                                        });
                                        // To Insert Time Zone
                                        let objTime = new ModelRawNonQuery(req, res);
                                        objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user='" + newRes[0].userid + "'";
                                        objTime.prepare();
                                        objTime.execute((errTime: any, sTime) => {
                                            if (errTime == 1) {
                                                console.log("Time Zone Config Inserted Successfully.");

                                            }
                                            else {
                                                console.log("Time Zone Config Not Inserted!");
                                            }
                                        });

                                        if (sdata.type == 22) {
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = '" + sdata.idaccount + "'";
                                            obj0.prepare();
                                            obj0.execute((_errorser: any, getSer: any) => {
                                                if (_errorser == 1) {
                                                    let service = getSer[0].idservice;
                                                    let idtariff = getSer[0].idtariff;
                                                    let obj11 = new ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "UPDATE `user` SET `idtariff`='" + idtariff + "',`idservice`='" + service + "',`isAddress`='true',`isCard`='true',`newUser_status`='1',`resetPassword`='1',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`ext_name`='" + parseBody(sdata.password) + "' WHERE `iduser`='" + newRes[0].userid + "'";
                                                    obj11.prepare();
                                                    obj11.execute((_errorrr: any, resultt: any) => {
                                                        if (_errorrr == 1) {
                                                            console.log("Tariff And Service Updated Successfully.");
                                                        }
                                                        else {
                                                            console.log("Tariff And Service Not Updated!");
                                                        }
                                                    });
                                                }
                                                else {
                                                    console.log("Something Went Wrong With Get Tariff And Update User.");
                                                }
                                            });
                                        }
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result[0], message: "Customer Created Successfully!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result[0], message: "Customer Not Created!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result[0], message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    /**
                     * To update subcustomer and customer from customer side and admin side
                     */
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE (u.username = '" + parseBody(sdata.user_name) + "' OR up.email = '" + sdata.email + "') AND u.iduser != '" + sdata.iduser + "'";
                    obj1.prepare();
                    obj1.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Username or Email Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            } else {

                                let password1 = bcrypt.hashSync(sdata.password, 10);
                                obj.nonqrysql = "CALL AddUser('" + sdata.idaccount + "', " + sdata.iduser + ", '" + parseBody(sdata.user_name) + "','" + parseBody(password1) + "','" + sdata.type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','0', '" + sdata.tariff1 + "','" + sdata.tariff2 + "', '" + sdata.status + "', '" + sdata.service + "', '" + sdata.credit_limit + "')";
                                if (sdata.type == 2) {
                                    message = "Customer Updated Successfully";
                                }
                                if (sdata.type == 3) {
                                    message = "Supplier Updated Successfully";
                                }
                                obj.prepare();
                                obj.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        if (sdata.type == 2) {
                                            let newRes = result[0];
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = '" + sdata.idaccount + "'";
                                            obj0.prepare();
                                            obj0.execute((_errorser: any, getSer: any) => {
                                                if (_errorser == 1) {
                                                    let obj11 = new ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "UPDATE `billing_address` SET `first_name`='" + parseBody(sdata.first_name) + "',`last_name`='" + parseBody(sdata.last_name) + "', `contact`='" + sdata.contact_number + "',`email`='" + sdata.email + "', `address1`='" + parseBody(sdata.address1) + "', `address2`='" + parseBody(sdata.address2) + "', `city`='" + parseBody(sdata.city) + "', `state`='" + parseBody(sdata.state) + "', `postal_code`='" + parseBody(sdata.postal_code) + "', `country`='" + sdata.country + "',`customerType`='" + sdata.customerType + "', `businessName`='" + parseBody(sdata.businessName) + "', `ein`='" + parseBody(sdata.ein) + "', `website`='" + parseBody(sdata.website) + "', `title`='" + parseBody(sdata.title) + "', `groupExmpt_number`='" + sdata.groupExmpt_number + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                                                    obj11.prepare();
                                                    obj11.execute((_errBil: any, resultBil: any) => {
                                                        if (_errBil == 1) {
                                                            console.log("Biilling Address Updated Successfully.");
                                                        }
                                                        else {
                                                            console.log("Biilling Address Not Updated!");
                                                        }
                                                    });
                                                    let service = getSer[0].idservice;
                                                    let idtariff = getSer[0].idtariff;
                                                    let planVerify: any = idtariff ? 'true' : 'false';

                                                    // To send the mail
                                                    let obj15 = new UserManagement();
                                                    obj15.sendEmailVerify(req, res, sdata, newRes, next);

                                                    // To Update User table
                                                    let obj12 = new ModelRawNonQuery(req, res);
                                                    obj12.nonqrysql = "UPDATE `user` SET  `isEmailVerify`='" + sdata.isEmailVerify + "',`isMobileVerify`='" + sdata.isMobileVerify + "', `isPlan`= '" + planVerify + "', `isAddress`='" + sdata.isAddress + "',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`idtariff`='" + idtariff + "',`idservice`='" + service + "',`reseller_iduser`='" + sdata.reseller_id + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                                                    obj12.prepare();
                                                    obj12.execute((_errorrr: any, resultt: any) => {
                                                        if (_errorrr == 1) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ data: resultt[0], message: "Customer Updated Successfully!", status: 201 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ data: resultt, message: "Something Went Wrong With Customer Update!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });

                                                    // To Update Session table
                                                    let obj13 = new ModelRawNonQuery(req, res);
                                                    obj13.nonqrysql = "UPDATE `session` SET `idtariff`='" + idtariff + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                                                    obj13.prepare();
                                                    obj13.execute((_errorS: any, resultS: any) => {
                                                        if (_errorS == 1) {
                                                            // let P=0;
                                                            // To update Has table
                                                            let objS = new ModelRawQuery(req, res);
                                                            objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`='" + sdata.idaccount + "'";
                                                            objS.prepare();
                                                            objS.execute((errKey: any, delKey: any) => {
                                                                if (errKey == 1) {
                                                                    if (delKey.length > 0) {
                                                                        for (let x of delKey) {
                                                                            let currSess = sessiondata.get(x.authKey);
                                                                            currSess.idtariff = idtariff;
                                                                            sessiondata.set(x.authKey, currSess);
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                            console.log("idtariff updated successfully in session! :: ", idtariff);
                                                        }
                                                        else {
                                                            console.log("idtariff not updated in session! :: ", idtariff);
                                                        }
                                                    });

                                                    // To Update API table
                                                    let obj14 = new ModelRawNonQuery(req, res);
                                                    obj14.nonqrysql = "UPDATE `api` SET `idtariff`='" + idtariff + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                                                    obj14.prepare();
                                                    obj14.execute((_errorA: any, resultA: any) => {
                                                        if (_errorA == 1) {
                                                            console.log("idtariff updated successfully in API! :: ", idtariff);
                                                        }
                                                        else {
                                                            console.log("idtariff not updated in API table :: ", idtariff);
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Tariff And Service!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ data: result[0], message: "Account Updated Successfully!", status: 201 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    sendEmailVerify(req: Request, res: Response, sdata: any, newRes: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sdata.email + sdata.password
                }, secret);
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "', `secret`='" + secret + "', `email_verification_date`=NOW() WHERE `iduser`='" + newRes[0].userid + "' AND  `is_deleted`=0";
                obj3.prepare();
                obj3.execute((_err: any, __result: any) => {
                    if (_err == 1) {
                        if (__result.affectedRows > 0) {
                            let tempType: any;
                            if (sdata.isEmailVerify == 'true' || sdata.isEmailVerify == true) {
                                tempType = "welcome";
                            }
                            if (sdata.isEmailVerify == 'false' || sdata.isEmailVerify == false) {
                                tempType = "email_verification";
                            }
                            let obj5 = new ModelRawQuery(req, res);
                            obj5.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='" + tempType + "'";
                            obj5.prepare();
                            obj5.execute((emlErr: any, emlRes: any) => {

                                if (emlErr == 1) {
                                    if (emlRes.length > 0) {
                                        let tmpData = emlRes[0].template;
                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.first_name);
                                        tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.last_name);
                                        tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);

                                        // var smtpTransport = nodemailer.createTransport({
                                        //     service: "gmail",
                                        //     host: "smtp.gmail.com",
                                        //     port: 587,
                                        //     secure: true,
                                        //     auth: {
                                        //         user: "mailto:donotreply@nglcommunications.com",
                                        //         pass: "yr%5V9GB"
                                        //     }
                                        // });
                                        // var mailOptions = {
                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                        //     to: sdata.email,
                                        //     usernmae: sdata.user_name,
                                        //     email: sdata.email,
                                        //     subject: `${emlRes[0].subject}`,
                                        //     text: "Thank You For Registration",
                                        //     html: `${tmpData}`
                                        // }
                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                        //     if (_emailError) {
                                        //         console.log("Opps Email Not Sent!");
                                        //     } else {
                                        //         console.log("Email Send  Successfully!");
                                        //     }
                                        // });

                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + newRes[0].userid + "','" + newRes[0].account + "','" + FromEmail + "','" + sdata.email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Email Verification.', '" + parseBody(tmpData) + "','Mail Send for Email Verification.','3')";
                                        obj1.prepare();
                                        obj1.execute((_err: any, __result: any) => {
                                            if (_err == 1) {
                                                console.log("Email Send  Successfully!")
                                            }
                                            else {
                                                console.log("Opps Email Not Sent!");
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Template Data Not Found!");
                                    }
                                }
                                else {
                                    console.log("Something Went Wrong with DB!");
                                }
                            });
                        }
                        else {
                            console.log("Invalid Key/Invalid Account!");
                        }
                    }
                    else {
                        console.log("Something Went Wrong with DB!");
                    }
                });
            }
            else {
                console.log(session);
            }
        });
    }

    UserList(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                if (sdata.type == "main") {
                    obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", -1)";
                }
                // profile = details of account
                else if (sdata.type == "profile") {
                    obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", 1)";
                }
                // detail = profile of user
                else if (sdata.type == "detail") {
                    obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", 2)";
                }
                else if (sdata.type == "edit") {
                    obj.nonqrysql = "CALL ListUser(" + sdata.idaccount + ", " + sdata.iduser + ", 3)";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    // for (const item of result[0]) {
                    //     delete item.password;
                    // }
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    ListUsers(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                if (sdata.type == "profile") {
                    obj.nonqrysql = "CALL ListUser(" + sdata.idaccount + ", " + sdata.iduser + ", 1)";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            for (const item of result[0]) {
                                delete item.password;
                            }
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Profile Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    singleUser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser = req.query.type;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT u.iduser, u.idaccount, u.idtariff, u.idservice, u.type, u.created, u.isEmailVerify, u.isMobileVerify, u.isAddress, u.isCard, u.isPlan, u.is_deleted, u.newUser_status, u.restore_date, u.kyc_verify_status, u.volt_status, u.federal_status ,uf.firstname,uf.lastname,uf.email,u.resetPassword FROM `user`u inner join `user_profile`uf on u.iduser=uf.iduser WHERE u.`iduser`='" + sessdata.iduser + "'";
                obj1.prepare();
                obj1.execute((_error1: any, result1: any) => {
                    if (_error1 == 1 && result1.length > 0) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT b.idaccount, b.address1, b.address2, b.city, b.state, b.contact, b.postal_code, b.country, b.customerType, b.title, b.ein, b.website, b.groupExmpt_number, b.businessName, w.balance, w.credit_limit FROM `billing_address` b JOIN `wallet` w ON w.idaccount = b.idaccount WHERE `b`.idaccount='" + result1[0].idaccount + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, data1: result1, message: "Profile Fetched Successfully!", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong List User", status: 502, error: _error });
                                objv.execute();
                            }
                        });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With User", status: 502, error: _error1 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getSingleUsersForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser = req.query.type;
                if (sessdata.type == 1) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT u.iduser, u.idaccount, u.idtariff, u.idservice, u.type, u.created, u.isEmailVerify, u.isMobileVerify, u.isAddress, u.isCard, u.isPlan, u.is_deleted, u.newUser_status, u.restore_date, u.kyc_verify_status, u.volt_status, u.federal_status ,uf.firstname,uf.lastname,uf.email FROM `user`u inner join `user_profile`uf on u.iduser=uf.iduser WHERE u.`iduser`='" + iduser + "'";
                    obj1.prepare();
                    obj1.execute((_error1: any, result1: any) => {
                        if (_error1 == 1 && result1.length > 0) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT b.idaccount, b.address1, b.address2, b.city, b.state, b.contact, b.postal_code, b.country, b.customerType, b.title, b.ein, b.website, b.groupExmpt_number, b.businessName, w.balance, w.credit_limit FROM `billing_address` b JOIN `wallet` w ON w.idaccount = b.idaccount WHERE `b`.idaccount='" + result1[0].idaccount + "'";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, data1: result1, message: "Profile Fetched Successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong List User", status: 502, error: _error });
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User", status: 502, error: _error1 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not Authorized!", status: 403 });
                    objv.execute();
                }

            } else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    subCustomerList(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,idaccount,username,idtariff,status FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "' AND `is_deleted`='0'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Sub Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getAllUsers(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let Qry: any = '';
                let obj = new ModelRawQuery(req, res);
                Qry += "SET SESSION group_concat_max_len = 1000000;\n"
                Qry += `SELECT c.idaccount, c.iduser, c.idtariff, c.type, ac.san, CONCAT(up.firstname,' ',up.lastname) name, CONCAT( '[',( SELECT GROUP_CONCAT( CONCAT( '{"idaccount":"', s.idaccount, '","iduser":"', s.iduser, '","idtariff":"', s.idtariff, '","type":"', s.type, '","name":"', REPLACE(REPLACE(REPLACE(REPLACE(CONCAT(uu.firstname, ' ', uu.lastname), '"', '\\"'), "'", "\\'"), '\n', '\\n'), "\\'", "\\'"), '"', '}' ) SEPARATOR ',') FROM user s LEFT JOIN user_profile uu ON uu.iduser = s.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.idaccount = c.idaccount ), ']') AS customer_data FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted=0 GROUP BY c.idaccount;`
                obj.qrysql = Qry;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Sub Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    updateProfilePic(req: Request, res: Response, next: NextFunction) {
        let filePath: any;
        if (req.file) {
            const fileName = req.file.filename;
            //filePath = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
            filePath = profile_pic.profile_pic + '/uploads/' + fileName;
        }
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj6 = new ModelRawNonQuery(req, res);
                obj6.nonqrysql = "UPDATE `user_profile` SET `profile_pic`='" + filePath + "' WHERE `iduser`='" + sessdata.iduser + "'";
                obj6.prepare();
                obj6.execute((_error: any, result: any) => {

                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Profile Picture Update Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    removeProfilePic(req: Request, res: Response, next: NextFunction) {
        let filePath: any = req.protocol + '://' + req.get('host') + '/uploads/default.jpg';

        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj6 = new ModelRawQuery(req, res);
                obj6.qrysql = "UPDATE `user_profile` SET `profile_pic`='" + filePath + "' WHERE `iduser`='" + sessdata.iduser + "'";
                obj6.prepare();
                obj6.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Profile Picture Remove Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getGeoCode(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata: any = req.body.data;
            let options = {
                'method': 'POST',
                'url': 'https://communicationsua.avalara.net/api/v2/geo/geocode',
                'headers': {
                    'client_id': '2221',
                    'Authorization': 'Basic dmlrYXNAZ3ZlbnR1cmUubmV0OmshR3BBdDNKNU5GTUt3UA==',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify([
                    {
                        "ref": "Address Request",
                        "cass": true,
                        "addr": sdata.address1,
                        "city": sdata.city,
                        "st": sdata.state,
                        "zip": sdata.postal_code
                    }
                ])
            };
            request(options, function (error: any, response: any) {
                if (!error) {
                    try {
                        let Data: any = JSON.parse(response.body);
                        if (Data[0].err == undefined && Data[0].pcd !== undefined && Data[0].pcd > 0) {
                            let objv = new RawView(res);
                            // objv.prepare({ message: "Geocode Fetched Successfully!", data: { "giocode": Data[0].pcd }, status: 200 });
                            objv.prepare({ data: { "giocode": Data[0].pcd }, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: 'Please Enter a Validate Address', status: 502 });
                            objv.execute();
                        }
                    }
                    catch (e) {
                        let obj = new RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: 'Please Enter a Validate Address', status: 502 });
                    objv.execute();
                }
            });
        });
    }

    addBillingAddress(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `first_name`,`last_name`,`idaccount` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((_erro: any, datachk: any) => {
                    let sdata = req.body.data
                    if (datachk.length > 0) {
                        let obj00 = new ModelRawNonQuery(req, res);
                        obj00.nonqrysql = "UPDATE `billing_address` SET `address1`='" + parseBody(sdata.address1) + "',`address2`='" + parseBody(sdata.address2) + "',`city`='" + parseBody(sdata.city) + "',`state`='" + parseBody(sdata.state) + "',`postal_code`='" + parseBody(sdata.postal_code) + "',`country`='" + parseBody(sdata.country) + "', `first_name`='" + parseBody(sdata.first_name) + "', `last_name`='" + parseBody(sdata.last_name) + "', `email`='" + parseBody(sdata.email) + "', `title`='" + parseBody(sdata.title) + "',`ein`='" + parseBody(sdata.ein) + "',`website`='" + parseBody(sdata.website) + "',`groupExmpt_number`='" + sdata.groupExmpt_number + "',`customerType`='" + sdata.customerType + "',`businessName`='" + parseBody(sdata.businessName) + "' WHERE `idaccount`='" + sessdata.idaccount + "'";
                        obj00.prepare();
                        obj00.execute((_uerro: any, updateBa: any) => {
                            if (_uerro == 1) {
                                let umc = new UserManagement();
                                umc.inBillingAdd(req, res, updateBa, next);
                            }
                        })
                    }
                    else {
                        let rdata: any = req.body.data;
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`,`groupExmpt_number`,`businessName`,`customerType`) VALUES ('" + sessdata.idaccount + "', '" + parseBody(rdata.first_name) + "', '" + parseBody(rdata.last_name) + "', '" + rdata.email + "', '" + parseBody(rdata.address1) + "', '" + parseBody(rdata.address2) + "', '" + parseBody(rdata.city) + "', '" + parseBody(rdata.state) + "', '" + parseBody(rdata.postal_code) + "', '" + rdata.country + "','" + parseBody(rdata.title) + "','" + parseBody(rdata.ein) + "','" + parseBody(rdata.website) + "','" + parseBody(rdata.groupExmpt_number) + "','" + parseBody(rdata.businessName) + "','" + parseBody(rdata.customerType) + "')";
                        obj.prepare();
                        obj.execute((_error: any, data: any) => {
                            if (_error == 1) {
                                let umc = new UserManagement();
                                umc.inBillingAdd(req, res, data, next);
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    inBillingAdd(req: Request, res: Response, data: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj4 = new ModelRawNonQuery(req, res);
                obj4.nonqrysql = "UPDATE `user` SET `isAddress`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                obj4.prepare();
                obj4.execute((_error: any, user: any) => {
                    if (_error == 1) {
                        console.log("User's isAddress Updated Successfully!");
                    }
                    else {
                        console.log("User's isAddress Not Updated!");
                    }

                });
                let obj5 = new ModelRawNonQuery(req, res);
                obj5.nonqrysql = "UPDATE `session` SET `isAddress`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                obj5.prepare();
                obj5.execute((_err: any, user: any) => {
                    if (_err == 1) {
                        console.log("Session Updated Successfully!");
                    }
                    else {
                        console.log("Session Not Updated!");
                    }
                    let obj6 = new ModelRawQuery(req, res);
                    obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`idtariff` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                    obj6.prepare();
                    obj6.execute((_sessError: any, sessData: any) => {
                        if (_sessError == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ session: sessData, data: data, iduser: sessdata.iduser, message: "Address Saved Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                            objv.execute();
                        }
                    });
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /* * * * * * * * * * * *
     * To send mail to support and customer
     */
    sendOnboardingComplateMail(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj7 = new ModelRawQuery(req, res);
                obj7.qrysql = "SELECT `username`,`idtariff` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "' AND `isEmailVerify`='true' AND `isMobileVerify`='true' AND `isAddress`='true' AND `isPlan`='true' AND `is_deleted`=0";
                obj7.prepare();
                obj7.execute((userErr: any, userRes: any) => {
                    let userResData = userRes[0];
                    if (userErr == 1 && userRes.length > 0) {
                        let objT = new ModelRawQuery(req, res);
                        objT.qrysql = "SELECT `name` FROM `tariff` WHERE `idtariff`='" + userResData.idtariff + "'";
                        objT.prepare();
                        objT.execute((trfErr: any, terRes: any) => {
                            let trfName = trfErr == 1 && terRes.length > 0 && terRes[0].name ? terRes[0].name : 'CUSTOM PLAN';
                            let obj7 = new ModelRawQuery(req, res);
                            obj7.qrysql = "SELECT `san` FROM `account` WHERE `idaccount`='" + sessdata.idaccount + "'";
                            obj7.prepare();
                            obj7.execute((accErr: any, accRes: any) => {
                                let accResData = accRes[0];
                                // var smtpTransport = nodemailer.createTransport({
                                //     service: "gmail",
                                //     host: "smtp.gmail.com",
                                //     port: 587,
                                //     secure: true,
                                //     auth: {
                                //         user: "donotreply@nglcommunications.com",
                                //         pass: "yr%5V9GB"
                                //     }
                                // });
                                if (accErr == 1 && accRes.length > 0) {
                                    let obj7 = new ModelRawQuery(req, res);
                                    obj7.qrysql = "SELECT `firstname`,`lastname`,`phone`,`email` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj7.prepare();
                                    obj7.execute((bErr: any, billingRes: any) => {
                                        let getUser = billingRes[0];
                                        if (bErr == 1 && billingRes.length > 0) {
                                            // To send mail to customer
                                            let obj9 = new ModelRawQuery(req, res);
                                            obj9.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='onboarding_complete_notification_to_customer'";
                                            obj9.prepare();
                                            obj9.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        // var mailOptions = {
                                                        //     from: 'Signalmash <donotreply@signalmash.com>',
                                                        //     to: `${getUser.email}`,
                                                        //     usernmae: userResData.username,
                                                        //     email: getUser.email,
                                                        //     subject: `${emlRes[0].subject}`,
                                                        //     text: "Thank You For Complete Registration",
                                                        //     html: `${tmpData}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                        //     if (_emailError) {
                                                        //         console.log("Email Not Sent!");
                                                        //     }
                                                        //     else {
                                                        //         console.log("Email Send Succesfully!");
                                                        //     }
                                                        // });

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Thank You For Complete Registration Send Mail to Customer', '" + parseBody(tmpData) + "','Thank You For Complete Onboarding Process','4')";
                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            if (_err == 1) {
                                                                console.log("Email Send Succesfully!")
                                                            }
                                                            else {
                                                                console.log("Email Not Sent!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Data!");
                                                }
                                            });
                                            // To send mail to support
                                            let obj8 = new ModelRawQuery(req, res);
                                            obj8.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='onboarding_complete_notification_to_support'";
                                            obj8.prepare();
                                            obj8.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        // To send mail to support
                                                        let tmpDataSup = emlRes[0].template;
                                                        tmpDataSup = tmpDataSup.replace(/{SAN_NUMBER}/g, accResData.san);
                                                        tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, getUser.email);
                                                        tmpDataSup = tmpDataSup.replace(/{PHONE}/g, getUser.phone);
                                                        tmpDataSup = tmpDataSup.replace(/{TARIFF}/g, trfName);
                                                        // var mailOptionsSup = {
                                                        //     from: 'Signalmash <donotreply@signalmash.com>',
                                                        //     to: `${supportEmail}`,
                                                        //     usernmae: supportEmail,
                                                        //     email: supportEmail,
                                                        //     subject: `New Signalmash Customer`,
                                                        //     text: "Thank You For Complete Registration",
                                                        //     html: `${tmpDataSup}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptionsSup, (_emailErrorSup: any, emailRes: any) => {
                                                        //     if (_emailErrorSup) {
                                                        //         console.log("Email Not Sent!");
                                                        //     } else {
                                                        //         console.log("Email Send Succesfully!");
                                                        //     }
                                                        // });

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        // obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + supportEmail + "', 'New Signalmash Customer','Thank You For Complete Registration Send Mail to Support', '" + parseBody(tmpDataSup) + "','Thank You For Complete Onboarding Process','4')";

                                                        const Spmail = supportEmail.split(",");
                                                        let qry = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES";
                                                        for (let i = 0; i < Spmail.length; i++) {
                                                            let entry = Spmail[i];
                                                            qry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + entry + "', 'New Signalmash Customer','Thank You For Complete Registration Send Mail to Support', '" + parseBody(tmpDataSup) + "','Thank You For Complete Onboarding Process','4'),";
                                                        }
                                                        obj1.nonqrysql = qry.slice(0, -1)
                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            if (_err == 1) {
                                                                console.log("Email Send Succesfully!")
                                                            }
                                                            else {
                                                                console.log("Email Not Sent!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Data!");
                                                }
                                            });

                                            // To send welcome email to customer 
                                            let obj7 = new ModelRawQuery(req, res);
                                            obj7.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='welcome_email'";
                                            obj7.prepare();
                                            obj7.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        // var mailOptions = {
                                                        //     from: 'Signalmash <donotreply@signalmash.com>',
                                                        //     to: `${getUser.email}`,
                                                        //     usernmae: userResData.username,
                                                        //     email: getUser.email,
                                                        //     subject: `${emlRes[0].subject}`,
                                                        //     text: "Welcome Email",
                                                        //     html: `${tmpData}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                        //     if (_emailError) {
                                                        //         console.log("Welcome Email Not Sent!");
                                                        //     }
                                                        //     else {
                                                        //         console.log("Welcome Email Send Succesfully!");
                                                        //     }
                                                        // });

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Welcome Email', '" + parseBody(tmpData) + "','Welcome Email','16')";
                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            if (_err == 1) {
                                                                console.log("Welcome Email Send Succesfully!")
                                                            }
                                                            else {
                                                                console.log("Welcome Email Not Sent");
                                                            }
                                                        });


                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Welcome Email Data!");
                                                }
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Welcome Mail Sent Successfully!", status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            console.log("User Information Not Avalilable!");
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "User Information Not Avalilable!", status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    console.log("Account Data Not Available!");
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Account Data Not Available!", status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        });
                    }
                    else {
                        console.log("Onboarding Not Complete or Account Not Available/Invalid Account!");
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Onboarding Not Complete or Account Not Available/Invalid Account!", status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                console.log("Session Not Available!");
                let objv = new RawView(res);
                objv.prepare({
                    message: "Session Not Available!", status: 502
                });
                objv.execute();
            }
        });
    }

    public getBillingAddress(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.idaccount= (SELECT idaccount from user where iduser='" + sessdata.iduser + "') WHERE up.`iduser` = '" + sessdata.iduser + "'";
                obj.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, ba.ein, ba.website, ba.groupExmpt_number, ba.businessName, ba.customerType, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.idaccount= (SELECT idaccount from user where iduser='" + sessdata.iduser + "') WHERE up.`iduser` = '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getInvoice(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            let sdata = req.query;
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idinvoice`,`idaccount`,`invoice_number`,`created_at`,`san`,`first_name`,`last_name`,`address1`,`address2`,`city`,`state`,`postal_code`,`country`,`email`,`phone`,`customer_name`,`mrc_cost`,`commission_amount` FROM invoice";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public updateBillingAddress(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                let sdata = [];
                sdata = req.body.data;
                let rdata = [];
                rdata = req.body.data;
                obj2.nonqrysql = "UPDATE `billing_address` SET `address1`='" + parseBody(rdata.address1) + "', `address2`='" + parseBody(rdata.address2) + "', `city`='" + parseBody(rdata.city) + "', `state`='" + parseBody(rdata.state) + "', `postal_code`='" + rdata.postal_code + "', `country`='" + rdata.country + "' WHERE `idbilling_address` = '" + rdata.idbilling_address + "'";
                obj2.prepare();
                obj2.execute((error: any, allcamp: any) => {
                    if (error == 1) {
                        let obj4 = new ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "UPDATE `user` SET `isAddress`='true' WHERE `iduser`='" + _sessdata.iduser + "'";
                        obj4.prepare();
                        obj4.execute((_error: any, user: any) => {
                            if (_error == 1) {
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `session` SET `isAddress`='true' WHERE `iduser`='" + _sessdata.iduser + "'";
                                obj5.prepare();
                                obj5.execute((_err: any, user: any) => {
                                    if (_err == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Address Updated Successfully!", data: allcamp, session: _sessdata, status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Address Updated Successfully Error With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Address Updated Successfully Error With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: error,
                            message: "Something went wrong with Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public getSupplier(req: Request, res: Response, next: NextFunction) {

        let sdata = req.query;
        if (sdata.type == "detail") {
            super.getMethod(req, res, next);
        }
        else {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                let msg = "";
                if (error == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "CALL getSupplier(" + sessdata.iduser + ")";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: msg, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }

                    });
                }
                else {
                    let objv = new Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
    }

    public getSuppliers(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        if (sdata.type == "detail") {
            super.getMethod(req, res, next);
        }
        else {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, _sessdata: any) => {
                let msg = "";
                if (error == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount` as `key`, `username`, `selected`,`did`, `sms`, `voice` FROM `user` WHERE `type`=3";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            /* for (const item of result) {
                                delete item.value;
                            } */
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Supplier Fatched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ error: _error, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
    }


    // Upload File
    public UploadDocuments(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let objfile = new ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new ModelRawNonQuery(req, res);
                let fileName = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'");
                const filePath = req.protocol + '://' + req.get("host") + "/uploads/" + fileName;
                obj.nonqrysql = "INSERT INTO `upload` (`filename`,`destination_path`,`filetype`,`UserID`)VALUES ('" + fileName + "', '" + filePath + "', '" + req.file.mimetype + "','" + sessdata.iduser + "')";

                obj.prepare();
                obj.execute((_error: any, lastid: any) => {
                    let objv = new RawView(res);
                    let filepath = req.file.filename + fileName;
                    objv.prepare({ message: "File Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**
     * 
     * 
     * api
     */

    getCompanyProfile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idcompany`,`idaccount`,`company_name`,`ein`,`address`,`city`,`state`,`postal_code`,`website`,`country`,`email`,`phone` FROM `company` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Company Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Profile Details!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    updateCompanyProfile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                if (rdata.idcompany != "") {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `company` SET `company_name`='" + parseBody(rdata.company_name) + "', `ein`='" + rdata.ein + "', `address`='" + parseBody(rdata.address) + "', `city`='" + parseBody(rdata.city) + "', `state`='" + parseBody(rdata.state) + "', `postal_code`='" + rdata.postal_code + "', `website`='" + parseBody(rdata.website) + "', `country`='" + rdata.country + "', `email`='" + rdata.email + "', `phone`='" + rdata.phone + "' WHERE `idcompany` = '" + rdata.idcompany + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                        if (error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({
                                data: allcamp,
                                message: "Company Profile Updated Successfully!",
                                status: 201
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: error,
                                message: "Something went wrong With Company Profile Details!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `company` (`idaccount`, `company_name`, `ein`, `phone`, `email`, `address`, `city`, `state`, `country`, `postal_code`, `website`) VALUES ('" + sessdata.idaccount + "', '" + parseBody(rdata.company_name) + "', '" + rdata.ein + "', '" + rdata.phone + "', '" + rdata.email + "', '" + parseBody(rdata.address) + "', '" + parseBody(rdata.city) + "', '" + parseBody(rdata.state) + "', '" + rdata.country + "', '" + rdata.postal_code + "', '" + parseBody(rdata.website) + "')";
                    obj.prepare();
                    obj.execute((_error: any, data: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Company Profile Saved Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong With Company Profile Details!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public ChangePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = JSON.parse(req.body.data);
                if (sdata.old_password == 'undefined' || sdata.old_password == null) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Password Not Found.", "error": 0 });
                    objv.execute();
                }
                let obj0 = new ModelRawQuery(req, res);
                //obj0.qrysql = "SELECT `password` FROM `user` WHERE `iduser`='" + sessdata.iduser + "' AND `password`='" + sdata.old_password + "'";
                obj0.qrysql = "SELECT `password` FROM `user` WHERE `iduser`='" + sessdata.iduser + "'";
                obj0.prepare();
                obj0.execute((_error: any, result: any) => {
                    let pass1: any = sdata.old_password
                    if (result[0] !== undefined && bcrypt.compareSync(pass1, result[0].password)) {
                        let password1 = bcrypt.hashSync(sdata.confirm_password, 10);
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "CALL ChangePassword(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + result[0].password + "','" + password1 + "')";
                        obj.prepare();
                        obj.execute((__error: any, result: any) => {
                            if (__error == 1) {
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "UPDATE `user` SET `ext_name`='" + parseBody(sdata.confirm_password) + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj4.prepare();
                                obj4.execute((__error: any, user: any) => {
                                    let obj1 = new ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT up.firstname, up.lastname, up.email,u.username FROM `user` u JOIN user_profile up ON u.iduser = up.iduser WHERE u.iduser = '" + sessdata.iduser + "'";
                                    obj1.prepare();
                                    obj1.execute((Err: any, Res: any) => {
                                        if (Err == 1) {
                                            let obj5 = new ModelRawQuery(req, res);
                                            obj5.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='reset_password'";
                                            obj5.prepare();
                                            obj5.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                        // var smtpTransport = nodemailer.createTransport({
                                                        //     service: "gmail",
                                                        //     host: "smtp.gmail.com",
                                                        //     port: 587,
                                                        //     secure: true,
                                                        //     auth: {
                                                        //         user: "mailto:donotreply@nglcommunications.com",
                                                        //         pass: "yr%5V9GB"
                                                        //     }
                                                        // });
                                                        // var mailOptions = {
                                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                                        //     to: Res[0].email,
                                                        //     usernmae: Res[0].username,
                                                        //     email: Res[0].email,
                                                        //     subject: `${emlRes[0].subject}`,
                                                        //     text: "Thank You For Registration",
                                                        //     html: `${tmpData}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                        //     if (_emailError) {
                                                        //         console.log("Opps Email Not Sent!", _emailError);
                                                        //     } else {
                                                        //         console.log("Email Send  Successfully!");
                                                        //         let objv = new RawView(res);
                                                        //         objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                        //         objv.execute();
                                                        //     }
                                                        // });

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + Res[0].email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Change Password', '" + parseBody(tmpData) + "','Your Password Changed Successfully','5')";
                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            console.log("Email Send  Successfully!")
                                                            if (_err == 1) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                console.log("Oops Email Not Sent!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Template Data Not Found!");
                                                        let objv0 = new RawView(res);
                                                        objv0.prepare({ status: 402, msg: "Template Data Not Found!" });
                                                        objv0.execute();
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with DB!");
                                                    let objv0 = new RawView(res);
                                                    objv0.prepare({ status: 403, msg: "Something Went Wrong with DB!" });
                                                    objv0.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv0 = new RawView(res);
                                            objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                            objv0.execute();
                                        }
                                    });
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    _error: _error,
                                    message: "Something Went Wrong With Connection!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "The old password you have entered is incorrect!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deleteUserSingleData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from user WHERE iduser = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                if (_error == 1) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "User Deleted Successfully!", data: lastid[0], status: 201 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Connection!", error: _error, status: 502 });
                    objv.execute();
                }
            });
        });
    }

    public deleteUser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query.id;
                let dData = JSON.parse(sdata);
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteUser('" + dData.idaccount + "', '" + dData.iduser + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Delete User Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Admin Side Delete and Restore
    DeleteCustomerAccount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata: any = req.body.data ? req.body.data : req.body;
            let isDeleted: any = req.body.data && req.body.data !== undefined ? sdata.isDeleted : '1';
            let type: any = req.body.data && req.body.data !== undefined ? 'panel' : 'swagger';
            let sesidaccount: any = req.body.data && req.body.data !== undefined ? sdata.sesidaccount : sessdata.idaccount;
            var disDID: any = []; disDID.length = 0; disDID.splice(0, disDID.length);
            var disDIDid: any = []; disDIDid.length = 0; disDIDid.splice(0, disDIDid.length);
            var notdisDID: any = []; notdisDID.length = 0; notdisDID.splice(0, notdisDID.length);
            var notdisDIDid: any = []; notdisDIDid.length = 0; notdisDIDid.splice(0, notdisDIDid.length);
            let arrStr: any = '';
            let TotalDays: any;
            if (error == 1) {
                let con: any = "";
                if (isDeleted == 0) // restore
                    con = "`restore_date`=NOW()";
                if (isDeleted == 1) // delete
                    con = "`pending_deleted_date`=NOW()";

                // from panel side hit -> restore account
                if (isDeleted == 0) {
                    let allDID: any = [];
                    let allDIDId: any = [];
                    let allBrandId: any = [];
                    let allCampaign: any = [];
                    let allIdUsers: any = [];
                    // Delete DID
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='2'";
                    obj0.prepare();
                    obj0.execute((_errorDID: any, resultDID: any) => {
                        if (_errorDID == 1) {
                            for (let d of resultDID) {
                                allDIDId.push(d.iddid);
                                allDID.push(d.did);
                            }
                            if (allDIDId.length > 0) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '0' WHERE `iddid` IN(" + allDIDId + ")";
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        console.log("All DID Removed", allDIDId);
                                    }
                                });
                            }
                        }
                    });

                    let obju = new ModelRawQuery(req, res);
                    obju.qrysql = "SELECT `iduser` from user WHERE `idaccount`='" + sdata.sesidaccount + "'";
                    obju.prepare();
                    obju.execute((_uerror: any, iduserRes: any) => {
                        if (iduserRes.length > 0) {
                            for (let u of iduserRes) {
                                allIdUsers.push(u.iduser)
                            }

                            if (allIdUsers.length > 0) {
                                // Delete Campaign
                                let objc = new ModelRawQuery(req, res);
                                objc.qrysql = "SELECT `id_campaign` from campaign WHERE `deleted`= 2 AND `iduser` IN(" + allIdUsers + ")";
                                objc.prepare();
                                objc.execute((_cerror: any, campaignRes: any) => {
                                    if (campaignRes.length > 0) {
                                        for (let c of campaignRes) {
                                            allCampaign.push(c.id_campaign)
                                        }
                                        let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '0' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                        obj1.prepare();
                                        obj1.execute((_errorCamp: any, resultCamp: any) => {
                                            if (resultCamp.length > 0) {
                                                console.log("All Campaign Removed", allCampaign);
                                            }
                                        });
                                    }
                                });
                                // Delete Brand
                                let objb = new ModelRawQuery(req, res);
                                objb.qrysql = "SELECT `idbrand` from brand WHERE `deleted`= 2 AND `iduser` IN(" + allIdUsers + ")";
                                objb.prepare();
                                objb.execute((_errB: any, brandRe: any) => {
                                    if (brandRe.length > 0) {
                                        for (let b of brandRe) {
                                            allBrandId.push(b.idbrand)
                                        }
                                        let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '0' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                        obj2.prepare();
                                        obj2.execute((_errorBrand: any, resultBrand: any) => {
                                            if (resultBrand.length > 0) {
                                                console.log("All Brand Removed", allBrandId);
                                            }
                                        });
                                    }
                                })
                            }
                        }
                    })

                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `session` SET `isDeleted` = '0' WHERE `idaccount` = '" + sesidaccount + "'";
                    obj.prepare();
                    obj.execute((__error: any, delSessRes: any) => {
                        console.log("All Session Restored");
                        let obj00 = new ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sesidaccount + "'";
                        obj00.prepare();
                        obj00.execute((____error: any, resultIdEnPoints: any) => {

                            let endPointId: any = [];
                            for (let i of resultIdEnPoints) {
                                endPointId.push(i.idendpoint)
                            }
                            let endPointIds = endPointId.length > 0 ? endPointId : "''";
                            let obj01 = new ModelRawNonQuery(req, res);
                            obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj01.prepare();
                            obj01.execute((_____error: any, resInbound: any) => {
                                console.log("Inbound Restored");
                            })
                            let obj02 = new ModelRawNonQuery(req, res);
                            obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj02.prepare();
                            obj02.execute((_____error: any, resOutbound: any) => {
                                console.log("Outbound Restored");
                            })
                            let obj03 = new ModelRawNonQuery(req, res);
                            obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj03.prepare();
                            obj03.execute((_____error: any, resIp: any) => {
                                console.log("IP Address Removed");
                            })
                            let obj04 = new ModelRawNonQuery(req, res);
                            obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj04.prepare();
                            obj04.execute((_____error: any, resRoute: any) => {
                                console.log("Routing Removed");
                            })
                            let obj05 = new ModelRawNonQuery(req, res);
                            obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj05.prepare();
                            obj05.execute((_____error: any, resHook: any) => {
                                console.log("Hooksetting Removed");
                            })
                        })
                        let obj0 = new ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "UPDATE `api` SET `isDeleted` = '0' WHERE `idaccount` = '" + sesidaccount + "'";
                        obj0.prepare();
                        obj0.execute((___error: any, delApiRes: any) => {
                            console.log("Api Details Restored");
                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '0' WHERE `idaccount` = '" + sesidaccount + "'";
                            obj2.prepare();
                            obj2.execute((____error: any, result: any) => {
                                console.log("All Connection Restored");
                                // updation for both side (panel hit and swagger hit)
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = '" + sesidaccount + "'";
                                obj3.prepare();
                                obj3.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            })
                        })
                    })
                }
                else {
                    // from swagger and panel side hit delete account
                    let objS = new ModelRawQuery(req, res);
                    objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`='" + sesidaccount + "'";
                    objS.prepare();
                    objS.execute((errKey: any, delKey: any) => {
                        if (errKey == 1) {
                            if (delKey.length > 0) {
                                for (let x of delKey) {
                                    sessiondata.delete(x.authKey)
                                }
                            }
                        }
                    });
                    if (sessdata.type == 1) {
                        let obj7 = new ModelRawNonQuery(req, res);
                        obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = '" + sesidaccount + "'";
                        obj7.prepare();
                        obj7.execute((__error: any, delSessRes: any) => {
                            console.log("All Session Removed");
                            let obj00 = new ModelRawQuery(req, res);
                            obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sesidaccount + "'";
                            obj00.prepare();
                            obj00.execute((____error: any, resultIdEnPoint: any) => {
                                let endPointId: any = [];
                                for (let i of resultIdEnPoint) {
                                    endPointId.push(i.idendpoint)
                                }
                                let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                let obj01 = new ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj01.prepare();
                                obj01.execute((_____error: any, resInbound: any) => {
                                    console.log("Inbound Removed");
                                })
                                let obj02 = new ModelRawNonQuery(req, res);
                                obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj02.prepare();
                                obj02.execute((_____error: any, resOutbound: any) => {
                                    console.log("Outbound Removed");
                                })

                                let obj03 = new ModelRawNonQuery(req, res);
                                obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj03.prepare();
                                obj03.execute((_____error: any, resIp: any) => {
                                    console.log("IP Address Removed");
                                })
                                let obj04 = new ModelRawNonQuery(req, res);
                                obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj04.prepare();
                                obj04.execute((_____error: any, resRoute: any) => {
                                    console.log("Routing Removed");
                                })
                                let obj05 = new ModelRawNonQuery(req, res);
                                obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj05.prepare();
                                obj05.execute((_____error: any, resHook: any) => {
                                    console.log("Hooksetting Removed");
                                })
                            })

                            let obj8 = new ModelRawNonQuery(req, res);
                            obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = '" + sesidaccount + "'";
                            obj8.prepare();
                            obj8.execute((___error: any, delApiRes: any) => {
                                console.log("Api Details Removed");
                                let obj9 = new ModelRawNonQuery(req, res);
                                obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = '" + sesidaccount + "'";
                                obj9.prepare();
                                obj9.execute((____error: any, result: any) => {
                                    console.log("All Connection Removed");
                                })
                            })
                        })
                        //updation for both side (panel hit and swagger hit)
                        let obj10 = new ModelRawNonQuery(req, res);
                        obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = '" + sesidaccount + "'";
                        obj10.prepare();
                        obj10.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else if (sessdata.type == 2) {
                        let Obj4 = new ModelRawQuery(req, res);
                        Obj4.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount`='" + sesidaccount + "' AND (`balance` + `credit_limit`) >= 0";
                        Obj4.prepare();
                        Obj4.execute((crErr: any, crRes) => {
                            if (crErr == 1 && crRes.length > 0) {
                                let obj5 = new ModelRawQuery(req, res);
                                obj5.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sesidaccount + "' AND `disconnect_did_status`='1'";
                                obj5.prepare();
                                obj5.execute((_errorDID: any, resultDID: any) => {
                                    let DIDIds: any = [];
                                    for (let x of resultDID) {
                                        DIDIds.push(x.iddid)
                                    }
                                    let didid = DIDIds.length > 0 ? DIDIds : "''";
                                    let obj6 = new ModelRawQuery(req, res);
                                    obj6.qrysql = "SELECT t.day_num,d.iddid,d.created_at,d.did,d.did_disconnect_days, DATEDIFF(NOW(), d.`created_at`) AS remaining_days FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid IN(" + didid + ")";
                                    obj6.prepare();
                                    obj6.execute((errday: any, resday: any) => {
                                        if (errday == 1) {
                                            if (resday.length > 0) {
                                                for (let y of resday) {
                                                    /* let did_buy_date = y.created_at;
                                                    let today_date: any = new Date();
                                                    const oneDay = 1000 * 60 * 60 * 24;
                                                    const diffInTime = today_date.getTime() - did_buy_date.getTime();
                                                    TotalDays = Math.round(diffInTime / oneDay);
                                                    if (TotalDays) {
                                                        if (TotalDays > y.day_num) {
                                                            disDID.push(y.did);
                                                            disDIDid.push(y.iddid);
                                                        } else {
                                                            notdisDID.push(y.did);
                                                            notdisDIDid.push(y.iddid);
                                                        }
                                                    } */
                                                    if (y.remaining_days >= y.did_disconnect_days) {
                                                        disDID.push(y.did);
                                                        disDIDid.push(y.iddid);
                                                    } else {
                                                        notdisDID.push(y.did);
                                                        notdisDIDid.push(y.iddid);
                                                    }
                                                }
                                                if (notdisDIDid.length > 0) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        status: 502, message: "This account cannot be deleted because [" + notdisDID.length + "] DIDs Are Active and [" + disDIDid.length + "] DIDs are inActive.",
                                                        data: { notDisconnectDid: { message: "Not Disconnected DIDs Data", didCount: notdisDID.length, did: notdisDID }, disconnectDid: { message: "Disconnected DIDs Data", didCount: disDID.length, did: disDID } }
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let obj7 = new ModelRawNonQuery(req, res);
                                                obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = '" + sesidaccount + "'";
                                                obj7.prepare();
                                                obj7.execute((__error: any, delSessRes: any) => {
                                                    console.log("All Session Removed");
                                                    let obj00 = new ModelRawQuery(req, res);
                                                    obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sesidaccount + "'";
                                                    obj00.prepare();
                                                    obj00.execute((____error: any, resultIdEnPoint: any) => {
                                                        let endPointId: any = [];
                                                        for (let i of resultIdEnPoint) {
                                                            endPointId.push(i.idendpoint)
                                                        }
                                                        let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                                        let obj01 = new ModelRawNonQuery(req, res);
                                                        obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj01.prepare();
                                                        obj01.execute((_____error: any, resInbound: any) => {
                                                            console.log("Inbound Removed");
                                                        })
                                                        let obj02 = new ModelRawNonQuery(req, res);
                                                        obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj02.prepare();
                                                        obj02.execute((_____error: any, resOutbound: any) => {
                                                            console.log("Outbound Removed");
                                                        })
                                                        let obj03 = new ModelRawNonQuery(req, res);
                                                        obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj03.prepare();
                                                        obj03.execute((_____error: any, resIp: any) => {
                                                            console.log("IP Address Removed");
                                                        })
                                                        let obj04 = new ModelRawNonQuery(req, res);
                                                        obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj04.prepare();
                                                        obj04.execute((_____error: any, resRoute: any) => {
                                                            console.log("Routing Removed");
                                                        })
                                                        let obj05 = new ModelRawNonQuery(req, res);
                                                        obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj05.prepare();
                                                        obj05.execute((_____error: any, resHook: any) => {
                                                            console.log("Hooksetting Removed");
                                                        })
                                                    })

                                                    let obj8 = new ModelRawNonQuery(req, res);
                                                    obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = '" + sesidaccount + "'";
                                                    obj8.prepare();
                                                    obj8.execute((___error: any, delApiRes: any) => {
                                                        console.log("Api Details Removed");
                                                        let obj9 = new ModelRawNonQuery(req, res);
                                                        obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = '" + sesidaccount + "'";
                                                        obj9.prepare();
                                                        obj9.execute((____error: any, result: any) => {
                                                            console.log("All Connection Removed");
                                                        })
                                                    })
                                                })
                                                //updation for both side (panel hit and swagger hit)
                                                let obj10 = new ModelRawNonQuery(req, res);
                                                obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = '" + sesidaccount + "'";
                                                obj10.prepare();
                                                obj10.execute((_error: any, result: any) => {
                                                    if (_error == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "DID Not Fetched!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                });

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Account Balance is Low!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "You have not access to Delete Account!", status: 502 });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    DeleteAccount(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let allDID: any = [];
                let allDIDId: any = [];
                let allBrandId: any = [];
                let allCampaign: any = [];
                let allIdUsers: any = [];

                // Delete DID
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='1'";
                obj0.prepare();
                obj0.execute((_errorDID: any, resultDID: any) => {
                    if (_errorDID == 1) {
                        for (let d of resultDID) {
                            allDIDId.push(d.iddid);
                            allDID.push(d.did);
                        }
                        if (allDIDId.length > 0) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '2' WHERE `iddid` IN(" + allDIDId + ")";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    console.log("All DID Removed", allDIDId);
                                }
                            });
                        }
                    }
                });


                let obju = new ModelRawQuery(req, res);
                obju.qrysql = "SELECT `iduser` from user WHERE `idaccount`='" + sdata.sesidaccount + "'";
                obju.prepare();
                obju.execute((_uerror: any, iduserRes: any) => {
                    if (iduserRes.length > 0) {
                        for (let u of iduserRes) {
                            allIdUsers.push(u.iduser)
                        }

                        if (allIdUsers.length > 0) {
                            // Delete Campaign
                            let objc = new ModelRawQuery(req, res);
                            objc.qrysql = "SELECT `id_campaign` from campaign WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objc.prepare();
                            objc.execute((_cerror: any, campaignRes: any) => {
                                if (campaignRes.length > 0) {
                                    for (let c of campaignRes) {
                                        allCampaign.push(c.id_campaign)
                                    }
                                    let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '2' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                    obj1.prepare();
                                    obj1.execute((_errorCamp: any, resultCamp: any) => {
                                        if (resultCamp.length > 0) {
                                            console.log("All Campaign Removed", allCampaign);
                                        }
                                    });
                                }
                            });
                            // Delete Brand
                            let objb = new ModelRawQuery(req, res);
                            objb.qrysql = "SELECT `idbrand` from brand WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objb.prepare();
                            objb.execute((_errB: any, brandRe: any) => {
                                if (brandRe.length > 0) {
                                    for (let b of brandRe) {
                                        allBrandId.push(b.idbrand)
                                    }
                                    let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '2' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                    obj2.prepare();
                                    obj2.execute((_errorBrand: any, resultBrand: any) => {
                                        if (resultBrand.length > 0) {
                                            console.log("All Brand Removed", allBrandId);
                                        }
                                    });
                                }
                            })
                        }
                    }
                })


                // add here delete feature for session,api and connection.
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `session` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                obj.prepare();
                obj.execute((__error: any, delSessRes: any) => {
                    console.log("All Session Remove");
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                    obj0.prepare();
                    obj0.execute((___error: any, delApiRes: any) => {
                        console.log("Api Details Remove");
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                        obj1.prepare();
                        obj1.execute((____error: any, result: any) => {
                            console.log("All Connection Remove");
                        })
                    })
                })

                // closed here
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + sdata.isDeleted + "', `deleted_date`=NOW() WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                obj2.prepare();
                obj2.execute((_errorDEL: any, resultDEL: any) => {
                    if (_errorDEL == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: allDID, message: "Account Successfully Deleted!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Release DID From Account Delete Process!", status: 502 });
                        objv.execute();
                    }
                });

                let obj00 = new ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                obj00.prepare();
                obj00.execute((____error: any, resultIdEnPoint: any) => {
                    let endPointId: any = [];
                    for (let i of resultIdEnPoint) {
                        endPointId.push(i.idendpoint)
                    }
                    let endPointIds = endPointId.length > 0 ? endPointId : "''";
                    let obj01 = new ModelRawNonQuery(req, res);
                    obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj01.prepare();
                    obj01.execute((_____error: any, resInbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Inbound Restored");
                        }
                        else {
                            console.log("Inbound Removed");
                        }
                    })
                    let obj02 = new ModelRawNonQuery(req, res);
                    obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj02.prepare();
                    obj02.execute((_____error: any, resOutbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Outbound Restored");
                        }
                        else {
                            console.log("OutBound Removed");
                        }
                    })
                })
                let obj03 = new ModelRawNonQuery(req, res);
                obj03.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                obj03.prepare();
                obj03.execute((____error: any, result: any) => {

                })



            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /* * * * * * * * * *
     * To check balance 
     */
    checkBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((errorSes: any, sessData: any) => {
            if (errorSes == 1) {
                let data: any = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idaccount` FROM `api` WHERE `key`= '" + data.apiKey + "'";
                obj.prepare();
                obj.execute((_error: any, apiData: any) => {
                    if (_error == 1 && apiData.length > 0) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `balance` FROM `wallet` WHERE idaccount='" + apiData[0].idaccount + "'";
                        obj.prepare();
                        obj.execute((__error: any, balanceData: any) => {
                            if (__error == 1 && balanceData.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Available Balance", data: { balance: balanceData[0].balance }, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Balance not found!", status: 403 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "apiKey not found!", status: 404 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }

    // public TaxAuthentication(req: Request, res: Response, next: NextFunction) {
    //     console.log(req.body.data);
    //     let sdata = req.body.data
    //     var request = require('request');
    //     var options = {
    //         'method': 'POST',
    //         'url': sdata.url,
    //         'headers': {
    //             'Content-Type': 'application/json'
    //         },
    //         body: JSON.stringify(sdata.data)
    //     };
    //     request(options, function (error: any, response: any) {
    //         console.log(response.body)
    //         let objv = new RawView(res);
    //         objv.prepare(response.body);
    //         objv.execute();
    //     });
    // }

    public TaxCalculation(req: Request, res: Response, _next: NextFunction) {
        let sdata = req.body.data
        var request = require('request');
        var options = {
            'method': 'POST',
            'url': 'http://localhost/avatax/php/trunk/charges/cal_taxaxtion',
            'headers': {
                'Content-Type': 'application/json',
                'Cookie': 'AuthToken=' + sdata.data.token
            },
            body: JSON.stringify(sdata.data)
        };
        request(options, function (_error: any, response: any) {
            if (!_error) {
                try {
                    let objv = new RawView(res);
                    objv.prepare(response.body);
                    objv.execute();
                }
                catch (e) {
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawView(res);
                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                obj.execute();
            }
        });
    }

    /* public detailsCDR(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT * FROM cdr WHERE date1 = '" + sdata.from_date + "' AND date2= '" + sdata.to_date + "' AND ani= '" + sdata.from_ani + "' AND did= '" + sdata.to_did + "' AND callid= '" + sdata.call_id + "' ";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                let objv = new RawView(res);
                objv.prepare({ message: "Fetched Data Successfully!", data: lastid[0] });
                objv.execute();
            });
        });
    } */

    public apiToken(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const key = Str.random(30);
                var rdata: any = req.body.data;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `name`,`key` FROM `api` where `name` = '" + parseBody(rdata.name) + "' AND `iduser` = '" + rdata.user + "'";
                obj1.prepare();
                obj1.execute((_error: any, getConn: any) => {
                    if (getConn[0]) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Token Already Exists at This Account!",
                            status: 404
                        });
                        objv.execute();
                    }
                    else {
                        let iduser: any = sessdata.type == 2 ? rdata.user : sessdata.iduser;
                        let idaccount: any = sessdata.type == 2 ? rdata.account : sessdata.idaccount;
                        let idtariff: any = sessdata.type == 2 && rdata.idtariff !== undefined && rdata.idtariff !== null ? rdata.idtariff : sessdata.idtariff;
                        if (idtariff < 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "There is no tariff selected in this account. please contact to administration.", status: 501
                            });
                            objv.execute();
                            return;
                        }
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `password`, `type`, `default`, `idtariff`, `isEmailVerify`, `isMobileVerify`, `isAddress`, `isPlan` FROM `user` WHERE `iduser` = '" + iduser + "'";
                        obj.prepare();
                        obj.execute((__error: any, getUser: any) => {
                            if (__error == 1 && getUser.length > 0) {
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "INSERT INTO `session` (`iduser`, `idaccount`, `username`,`password`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `tz_diff`, `server_time`, `client_time`, `sessionType`) VALUES('" + iduser + "', '" + idaccount + "', '" + getUser[0].username + "', '" + getUser[0].password + "', '" + getUser[0].type + "', '" + getUser[0].default + "', '" + idtariff + "', '" + key + "', '" + sessdata.status + "', '" + getUser[0].isEmailVerify + "', '" + getUser[0].isMobileVerify + "', '" + sessdata.idapi + "', '" + getUser[0].isAddress + "', '" + getUser[0].isPlan + "', '" + sessdata.tz_diff + "', '" + sessdata.server_time + "', '" + sessdata.client_time + "', 'API')";
                                obj2.prepare();
                                obj2.execute((___error: any, resultSess: any) => {
                                    if (___error == 1) {
                                        let obj5 = new ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "INSERT INTO `api` (`idaccount`, `iduser`, `idtariff`, `name`, `key`, `path`) VALUES('" + idaccount + "', '" + iduser + "', '" + idtariff + "' ,'" + parseBody(rdata.name) + "', '" + key + "', '" + rdata.status + "')";
                                        obj5.prepare();
                                        obj5.execute((_error: any, result: any) => {
                                            if (_error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    data: result,
                                                    message: "Token Saved Successfully!",
                                                    status: 201
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    data: result,
                                                    message: "Something Went Wrong With API Token!",
                                                    status: 502
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }

                                });
                            }
                        });
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public getApiToken(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj5 = new ModelRawQuery(req, res);

                let con: any = '';
                if (sessdata.type == 22)
                    con += "`iduser`='" + sessdata.iduser + "' AND ";
                if (sessdata.type == 2)
                    con += "`idaccount`='" + sessdata.idaccount + "' AND ";
                if (sessdata.type == 1)
                    con = '';

                obj5.qrysql = "SELECT `idapi`,`name`,`key`,`created` FROM `api` WHERE " + con + " isDeleted='0'";
                obj5.prepare();
                obj5.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Token Fetched Successfully!",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "No Data Found!",
                                status: 404
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public deleteApiToken(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessData: any) => {
            if (error == 1) {
                let data: any = req.query.id;
                sessiondata.delete(data.split('@')[1]); // deleting key from sessiondata
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "delete from `session` where `authKey` = (select `key` from `api` where `idapi`='" + data.split('@')[0] + "')";
                obj1.prepare();
                obj1.execute((_errorKey: any, resultKey: any) => {
                    if (_errorKey) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "delete from `api` WHERE `idapi` = '" + data.split('@')[0] + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Api Key Deleted Successfully!", data: result, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Data not deleted!", data: result, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Data not deleted from session", status: 502 });
                        objv.execute();
                    }

                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    saveTheme(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "INSERT into `theme` (`idaccount`, `brandName`, `domain`, `customLogo`, `email`, `phone`, `support_url`, `header_color`, `navbar_color`, `sidebar_color`, `ssl_certificate`, `ssl_key`) VALUES('" + sessdata.idaccount + "', '" + rdata.brandName + "', '" + rdata.domain + "', '" + rdata.custom_logo + "', '" + rdata.email + "', '" + rdata.phone + "', '" + rdata.support_url + "', '" + rdata.header_color + "', '" + rdata.navbar_color + "', '" + rdata.sidebar_color + "', '" + rdata.ssl_certificate + "', '" + rdata.ssl_key + "')";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Theme Saved Successfully!" });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Successfully!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    updateTheme(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let filePath: any;
                let rdata: any = [];
                rdata = JSON.parse(req.body.data);
                if (req.file) {
                    const fileName = req.file.filename;
                    filePath = "https://api.signalmash.com/uploads/" + fileName;
                }
                else if (rdata.logo == undefined || rdata.logo == null) {
                    filePath = "./assets/img/logo.png";
                }
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `theme` SET `brandName`='" + rdata.brandName + "', `domain`='" + rdata.domain + "', `customLogo`='" + filePath + "', `email`='" + rdata.email + "', `phone`='" + rdata.phone + "', `support_url`='" + rdata.support_url + "', `header_color`='" + rdata.header_color + "', `navbar_color`='" + rdata.navbar_color + "', `sidebar_color`='" + rdata.sidebar_color + "', `ssl_certificate`='" + rdata.ssl_certificate + "', `ssl_key`='" + rdata.ssl_key + "' WHERE `id_theme`='" + rdata.id_theme + "'";
                obj2.prepare();
                obj2.execute((error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        error: 0,
                        data: allcamp,
                        message: "Theme Updated Successfully"
                    })
                    objv.execute();
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    getThemes(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT `id_theme`,`idaccount`,`brandName`,`domain`,`customLogo`,`email`,`phone`,`support_url`,`header_color`,`navbar_color`,`navbar_color`,`sidebar_color`,`ssl_certificate`,`ssl_key` FROM `theme` WHERE `idaccount` = '" + sessdata.idaccount + "'";
            obj.prepare();
            obj.execute((_error: any, result: any) => {
                if (result.length > 0) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Theme data Fetched!", data: result });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "NO Data Found!" });
                    objv.execute();
                }
            });
        });
    }

    getTheme(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "select `id_theme`,`idaccount`,`brandName`,`domain`,`customLogo`,`email`,`phone`,`support_url`,`header_color`,`navbar_color`,`navbar_color`,`sidebar_color`,`ssl_certificate`,`ssl_key` from theme where id_theme='" + req.query.type + "' AND idaccount = '" + sessdata.idaccount + "'";
            obj.prepare();
            obj.execute((_error: any, result: any) => {
                if (_error == 1) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Theme data Fetched!", data: result });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong!" });
                    objv.execute();
                }
            });
        });
    }

    deleteTheme(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from `theme` WHERE `id_theme` = '" + req.query.id + "' AND idaccount = '" + sessdata.idaccount + "'";
            obj.prepare();
            obj.execute((_error: any, result: any) => {
                let objv = new RawView(res);
                objv.prepare({ message: "Theme Deleted Successfully!", data: result });
                objv.execute();
            });
        });
    }

    saveOtp(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata = req.body;
            let otp = Math.floor(100000 + Math.random() * 900000);
            sdata.otp = otp;
            // sdata.BODY = sdata.BODY + otp;
            if (error == 1) {
                // const ipAddress = req.socket.remoteAddress;
                let sysInfo = ipAddressAndBrowser(req);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `ip_address`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `contact` = '" + sdata.TO.trim() + "'";
                obj.prepare();
                obj.execute((_errDomainBlk: any, getDomainBlock: any) => {
                    if (_errDomainBlk == 1 && getDomainBlock.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Invalid Account Registration!",
                            status: 501
                        });
                        objv.execute();
                    }
                    else {
                        let obj4 = new ModelRawQuery(req, res);
                        obj4.qrysql = "SELECT `firstname`,`lastname` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                        obj4.prepare();
                        obj4.execute((_error: any, user: any) => {
                            let getUser = user[0];
                            if (error == 1) {
                                let obj5 = new ModelRawQuery(req, res);
                                obj5.qrysql = "SELECT `body` FROM `sms_template` WHERE type='mobile_verification'";
                                obj5.prepare();
                                obj5.execute((emlErr: any, emlRes: any) => {
                                    if (emlErr == 1 && emlRes.length > 0) {
                                        let BODY = emlRes[0].body;
                                        BODY = BODY.replace(/{FIRST_NAME}/g, getUser.firstname);
                                        BODY = BODY.replace(/{LAST_NAME}/g, getUser.lastname);
                                        BODY = BODY.replace(/{OTP}/g, sdata.otp);
                                        var headers = {
                                            'accept': '*/*',
                                            'Content-Type': 'application/x-www-form-urlencoded'
                                        };

                                        var dataString = 'Username=Gventure_test&Password=qzcLAGsUh-V8J57xNrFOJiBpZQCHEz';

                                        var options = {
                                            url: 'https://api.signalmash.com/apilogin',
                                            method: 'POST',
                                            headers: headers,
                                            body: dataString
                                        };

                                        request(options, (login_error: any, login_resp: any) => {
                                            let auth_key: any;
                                            let key = Str.random(30);
                                            if (login_resp !== undefined) {
                                                let data = JSON.parse(login_resp.body);
                                                auth_key = data.session;
                                                var headers = {
                                                    'accept': '*/*',
                                                    'Authorization': auth_key,
                                                    'Content-Type': 'application/x-www-form-urlencoded'
                                                };
                                                var dataString = 'FROM=' + sdata.FROM.trim() + '&TO=' + sdata.TO.trim() + '&BODY=' + BODY + '&Connection=&OutboundSMS=';
                                                var options = {
                                                    url: 'https://api.signalmash.com/sms',
                                                    method: 'POST',
                                                    headers: headers,
                                                    body: dataString
                                                }
                                                // url: 'https://api.signalmash.com/sms',
                                                request(options, (sms_err: any, sms_responce: any) => {
                                                    let sms_resp = JSON.parse(sms_responce.body);
                                                    if (sms_resp.status == 201) {
                                                        let obj = new ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `two_factor_auth` (`iduser`, `otp`, `from`, `to`, `session_id`) VALUES('" + sessdata.iduser + "', '" + sdata.otp + "', '" + sdata.FROM + "', '" + sdata.TO + "', '" + key + "')";
                                                        obj.prepare();
                                                        obj.execute((mdr_err: any, mdr_resp: any) => {
                                                            if (mdr_err == 1) {
                                                                let obj = new RawView(res);
                                                                obj.prepare({ result: "Success", data: mdr_resp, message: "OTP Sent Successfully", status: 201 });
                                                                obj.execute();
                                                            }
                                                            else {
                                                                let obj = new RawView(res);
                                                                obj.prepare({ result: "Failed", message: "Something Went Wrong with Connection!", status: 502 });
                                                                obj.execute();
                                                            }
                                                        })
                                                    }
                                                    else {
                                                        let obj = new RawView(res);
                                                        obj.prepare({ message: sms_resp.message, status: 503 });
                                                        obj.execute();
                                                    }
                                                })
                                            } else {
                                                let obj = new RawView(res);
                                                obj.prepare({ message: login_error, status: 502 });
                                                obj.execute();
                                            }
                                        });
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare("SMS Template not Fateched Successfully!");
                                        objv.execute();
                                    }
                                })
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare("User not Fateched Successfully!");
                                objv.execute();
                            }
                        })
                    }
                });

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }


        });
    }

    verifyOtp(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            //obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = '" + sessdata.iduser + "' AND `otp`='" + sdata.otp + "' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300";
            obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = '" + sessdata.iduser + "' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300 ORDER BY id DESC LIMIT 1";
            obj.prepare();
            obj.execute((error: any, getEmail: any) => {
                if (error == 1) {
                    if (getEmail.length > 0 && getEmail[0].otp == sdata.otp) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`= 'true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((_error: any, success: any) => {
                            if (_error == 1) {
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj5.prepare();
                                obj5.execute((_sessErr: any, sessRes: any) => {
                                    if (_sessErr == 1) {
                                        let obj6 = new ModelRawNonQuery(req, res);
                                        obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                        obj6.prepare();
                                        obj6.execute((_sessError: any, sessData: any) => {
                                            let objup = new ModelRawQuery(req, res);
                                            objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                            objup.prepare();
                                            objup.execute((__errorE: any, emailE: any) => {
                                                if (_sessError == 1) {
                                                    let obj7 = new ModelRawQuery(req, res);
                                                    obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                    obj7.prepare();
                                                    obj7.execute((sError: any, sData: any) => {
                                                        if (sError == 1) {
                                                            let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                                                            let emType = JSON.parse(tmp);
                                                            let sData1: any = Object.assign(sData, emType);
                                                            let objv = new RawView(res);
                                                            objv.prepare({
                                                                message: "OTP Verified Successfully!",
                                                                status: 200,
                                                                session: sData1
                                                            });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({
                                                                message: "OTP verified error with connection!",
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        message: "Mobile number not verified!",
                                                        status: 500
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            errMessage: "Mobile number not verified!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Mobile number not verified!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "You have enter wrong OTP!",
                            status: 502
                        });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({
                        message: "Something went wrong with connection!",
                        status: 502
                    });
                    objv.execute();
                }
            });
        });
    }

    resendEmail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sessdata.email + sessdata.password
                }, secret);
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "', `secret`='" + secret + "', `email_verification_date`=NOW() WHERE `iduser`='" + sessdata.iduser + "' AND  `is_deleted`=0";
                obj3.prepare();
                obj3.execute((_err: any, __result: any) => {
                    if (_err == 1) {
                        if (__result.affectedRows > 0) {
                            let obj4 = new ModelRawQuery(req, res);
                            obj4.qrysql = "SELECT `firstname`,`lastname`,`email` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";

                            obj4.prepare();
                            obj4.execute((_error: any, user: any) => {
                                let getUser = user[0];
                                if (_err == 1) {
                                    let obj5 = new ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE type='email_verification'";
                                    obj5.prepare();
                                    obj5.execute((emlErr: any, emlRes: any) => {
                                        if (emlErr == 1) {
                                            if (emlRes.length > 0) {
                                                let tmpData = emlRes[0].template;
                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                                                // var smtpTransport = nodemailer.createTransport({
                                                //     service: "gmail",
                                                //     host: "smtp.gmail.com",
                                                //     port: 587,
                                                //     secure: true,
                                                //     auth: {
                                                //         user: "donotreply@nglcommunications.com",
                                                //         pass: "yr%5V9GB"
                                                //     }
                                                // });
                                                // var mailOptions = {
                                                //     from: 'Signalmash <donotreply@signalmash.com>',
                                                //     to: getUser.email,
                                                //     usernmae: getUser.email,
                                                //     email: getUser.email,
                                                //     subject: `${emlRes[0].subject}`,
                                                //     text: "Thank You For Registration",
                                                //     html: `${tmpData}`
                                                // }
                                                // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                //     if (_emailError) {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                                //         objv.execute();
                                                //     } else {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ iduser: sessdata.iduser, status: 201, data: emailRes, message: "Email Send Succesfully!" });
                                                //         objv.execute();
                                                //     }
                                                // });
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Resend Mail Send for Not Getting Mail Previously', '" + parseBody(tmpData) + "','Resend Mail Send successfully','6')";

                                                obj1.prepare();
                                                obj1.execute((_err: any, __result: any) => {
                                                    console.log("Email Send Succesfully!")
                                                    if (_err == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ iduser: sessdata.iduser, status: 201, message: "Email Send Succesfully!" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        console.log("Error In Updating Password!");
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 401, errMessage: "Templating Data Not Found!" });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ errMessage: "Invalid Key/Invalid Account!", status: 401 });
                            objv.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    updateTariff(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj4 = new ModelRawNonQuery(req, res);
                //obj4.nonqrysql = "UPDATE `user` LEFT JOIN `account` ON `user`.`idaccount`=`account`.`idaccount` SET `idtariff`='" + sdata.tariff1 + "', `idtariff1`='" + sdata.tariff1 + "', `isPlan`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                obj4.nonqrysql = "UPDATE `user` LEFT JOIN `account` ON `user`.`idaccount`=`account`.`idaccount` SET `idtariff`='" + sdata.tariff1 + "', `idtariff1`='" + sdata.tariff1 + "', `isPlan`='true' WHERE `user`.`idaccount`='" + sessdata.idaccount + "'";
                obj4.prepare();
                obj4.execute((_error: any, user: any) => {
                    if (_error == 1) {
                        let obj5 = new ModelRawNonQuery(req, res);
                        //obj5.nonqrysql = "UPDATE `session` SET `isPlan`='true', `idtariff`='" + sdata.tariff1 + "' WHERE `iduser`='" + sessdata.iduser + "'";
                        obj5.nonqrysql = "UPDATE `session` SET `isPlan`='true', `idtariff`='" + sdata.tariff1 + "' WHERE `idaccount`='" + sessdata.idaccount + "'";
                        obj5.prepare();
                        obj5.execute((_err: any, user: any) => {
                            if (_err == 1) {

                                let objup = new ModelRawQuery(req, res);
                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                objup.prepare();
                                objup.execute((__errorE: any, emailE: any) => {

                                    let currSess = sessiondata.get(req.headers.authorization);
                                    currSess.idtariff = sdata.tariff1;
                                    currSess.isPlan = "true";
                                    sessiondata.set(req.headers.authorization, currSess);
                                    let obj6 = new ModelRawQuery(req, res);
                                    obj6.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                    obj6.prepare();
                                    obj6.execute((seserr: any, sessionData: any) => {
                                        if (seserr == 1) {
                                            let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                                            let emType = JSON.parse(tmp);
                                            let sessionData1: any = Object.assign(sessionData, emType);

                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Tariff Updated Successfully!", status: 201, session: sessionData1 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Tariff Updated Error With Connection!", status: 502, error: sessionData });
                                            objv.execute();
                                        }
                                    });

                                });

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Tariff Updated Error With Connection! ", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    currentSession(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + req.query.authkey + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Session Fetched Successfully!", status: 200, session: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Session Not Fetched DB Error!", status: 502, error: sessdata });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }


    /**
     * To get the list of TimeZones
     */
    GetTimeZones(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let objv = new RawView(res);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT id, label utc FROM `tbl_timezones`;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (error == 1) {
                        result = result || []
                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something Went Wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }


    /**
     * To get the user's TimeZone
     */
    GetUserTimeZone(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser: any = sessdata.iduser
                let iQry: string = "SELECT a.id, a.id_timezone, b.label utc FROM `tbl_timezone_config` a\n"
                iQry += "INNER JOIN `tbl_timezones` b ON b.id=a.id_timezone\n"
                iQry += "WHERE a.id_user=" + iduser + ";"

                let objv = new RawView(res);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = iQry;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (error == 1) {
                        result = Array.isArray(result) && result.length > 0 ? result[0] : null
                        objv.prepare({
                            error: 0,
                            message: "Record fetched successfully.",
                            data: result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something Went Wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }


    /**
     * To update the user's TimeZone
     */
    UpdateUserTimeZone(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = req.body.data

                let objv = new RawView(res);
                if (typeof rdata.timezone != 'undefined' && rdata.timezone) {
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(" + rdata.timezone + ", " + sessdata.iduser + ");"
                    obj1.prepare()
                    obj1.execute((error: any, result: any) => {
                        if (error == 1) {
                            /**
                             * Update the TimeZone in user's session data
                             */
                            /* let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT `iduser`, `password`,ext_name FROM `user` WHERE iduser>0 AND iduser<=200";
                            obj2.prepare();
                            obj2.execute((error, result) => {
                                if (error == 1 && Array.isArray(result) && result.length > 0) {
                                    result.forEach(ele => {                                       
                                        let pwt12 = bcrypt.hashSync(ele.ext_name, 10);
                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `user` SET `password`='" + pwt12 + "' WHERE `iduser`='" + ele.iduser + "';";
                                        obj3.prepare();
                                        obj3.execute((error, result2) => {console.log("Users:: "+pwt12+" :: ", ele)});
                                    });                                    
                                }
                            }); */

                            /* let obj2 = new ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=" + rdata.timezone + ";"
                            obj2.prepare()
                            obj2.execute((error: any, result: any) => {
                                if (error == 1 && Array.isArray(result) && result.length > 0) {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "UPDATE `session` SET `client_time`='" + result[0].client_time + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                    obj3.prepare()
                                    obj3.execute((error: any, result2: any) => {
                                        sessdata.client_time = result[0].client_time
                                        sessiondata.set(sessdata.authkey, sessdata)
                                    })
                                }
                            }) */

                            objv.prepare({
                                error: 0,
                                message: "Successfully saved."
                            });
                            objv.execute();
                        }
                        else {
                            objv.prepare({
                                error: 1,
                                message: "Something Went Wrong!"
                            });
                            objv.execute();
                        }
                    })
                }
                else {
                    objv.prepare({
                        error: 1,
                        message: "Invalid data!"
                    });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    /**************************
    *  Forgot Password start  *
    **************************/
    public sendMailForForgetPass(req: Request, res: Response, next: NextFunction) {
        let email = req.query.type;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT us.email, us.firstname, us.lastname, u.username FROM user_profile us JOIN `user` u ON us.iduser=u.iduser WHERE us.`email`='" + email + "' AND u.`is_deleted`=0";
        obj.prepare();
        obj.execute((_error: any, user: any) => {
            if (_error == 1) {
                if (user.length > 0) {
                    let getUser = user[0];
                    let obj4 = new ModelRawQuery(req, res);
                    obj4.qrysql = "SELECT template, subject FROM `email_template` WHERE type='forgot_password'";
                    obj4.prepare();
                    obj4.execute((emlErr: any, emlRes: any) => {
                        if (emlErr == 1) {
                            if (emlRes.length > 0) {
                                let secret = Str.random(15);
                                let validationKey = jwt.sign({
                                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                                    data: email
                                }, secret);

                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "',`isResetPassword` = 'true'  WHERE `username`='" + getUser.username + "' AND `is_deleted`=0";
                                obj3.prepare();
                                obj3.execute((_uperr: any, __result: any) => {
                                    if (_uperr == 1) {
                                        let tmpData = emlRes[0].template;
                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                        tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                                        tmpData = tmpData.replace(/{TYPE}/g, 'Signalmash');
                                        tmpData = tmpData.replace(/{URL}/g, templateURL.URL);

                                        // var smtpTransport = nodemailer.createTransport({
                                        //     service: "gmail",
                                        //     host: "smtp.gmail.com",
                                        //     port: 587,
                                        //     secure: true,
                                        //     auth: {
                                        //         user: "donotreply@nglcommunications.com",
                                        //         pass: "yr%5V9GB"
                                        //     }
                                        // });
                                        // var mailOptions = {
                                        //     from: 'Signalmash <donotreply@signalmash.com>',
                                        //     to: getUser.email,
                                        //     usernmae: getUser.username,
                                        //     email: getUser.email,
                                        //     subject: `${emlRes[0].subject}`,
                                        //     text: "Thank You For Registration",
                                        //     html: `${tmpData}`
                                        // }
                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                        //     if (_emailError) {
                                        //         let objv = new RawView(res);
                                        //         objv.prepare({ status: 401, message: "Opps Email Not Sent!", error: _emailError });
                                        //         objv.execute();
                                        //     } else {
                                        //         let objv = new RawView(res);
                                        //         objv.prepare({ status: 201, message: "Email Send Succesfully! Please Check Your Mail And Verify It.", emailRes });
                                        //         objv.execute();
                                        //     }
                                        // });
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + getUser.iduser + "','" + getUser.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Forget Password  ', '" + parseBody(tmpData) + "','Mail Send for Forget Password','7')"; obj1.prepare();
                                        obj1.execute((_err: any, __result: any) => {
                                            console.log("Data Inserted In DB!")
                                            if (_err == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 201, message: "Email Send Succesfully! Please Check Your Mail And Verify It." });
                                                objv.execute();
                                            }
                                            else {
                                                console.log("Error In Updating Password!");
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 401, message: "Opps Email Not Sent!" });
                                                objv.execute();
                                            }
                                        });
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something went Wrong!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Verification Email not Send!", status: 502 });
                                objv.execute();
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Error With Fetching Email Data!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Email Not Found/Invalid Account!" });
                    objv.execute();
                }
            } else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong to Fetch Email!" });
                objv.execute();
            }
        });
    }

    public VerifyToken(req: Request, res: Response, next: NextFunction) {
        let key = req.query.type;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `isResetPassword` FROM `user` WHERE validationKey='" + key + "' AND `is_deleted`=0";
        obj.prepare();
        obj.execute((error: any, result: any) => {
            if (result.length > 0) {
                if (result[0].isResetPassword == 'true') {
                    if (error == 1 && result.length > 0) {
                        let obj4 = new ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "UPDATE `user` SET `isResetPassword`='false' WHERE validationKey='" + key + "' AND `is_deleted`=0";
                        obj4.prepare();
                        obj4.execute((emlErr: any, emlRes: any) => {
                            if (emlErr == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ error: 0, status: 201, message: "Successfull Verified Please Enter Your New Password!", data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ error: 0, status: 502, message: "Successfull Verified Status Not Changed!", data: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv.execute();
                    }
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ error: 1, status: 502, message: "The Link You Followed Has Expired!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ error: 1, status: 404, message: "Invalid Account!" });
                objv.execute();
            }
        });
    }

    public updatePassword(req: Request, res: Response, next: NextFunction) {
        let alldata = req.body.data;
        let password1 = bcrypt.hashSync(alldata.password, 10)
        let obj0 = new ModelRawNonQuery(req, res);
        obj0.nonqrysql = "UPDATE `user` SET `password`='" + password1 + "',`ext_name`='" + parseBody(alldata.password) + "', `isResetPassword`='true' WHERE `validationKey`= '" + alldata.key + "' AND `is_deleted`=0";
        obj0.prepare();
        obj0.execute((error: any, result: any) => {
            if (result.affectedRows > 0) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT up.firstname, up.lastname, up.email, u.username FROM `user` u JOIN `user_profile` up ON u.iduser = up.iduser WHERE u.validationKey = '" + alldata.key + "';";
                obj1.prepare();
                obj1.execute((Err: any, Res: any) => {
                    if (Err == 1) {
                        let obj5 = new ModelRawQuery(req, res);
                        obj5.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='reset_password'";
                        obj5.prepare();
                        obj5.execute((emlErr: any, emlRes: any) => {
                            if (emlErr == 1) {
                                if (emlRes.length > 0) {
                                    let tmpData = emlRes[0].template;
                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                    tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                    // var smtpTransport = nodemailer.createTransport({
                                    //     service: "gmail",
                                    //     host: "smtp.gmail.com",
                                    //     port: 587,
                                    //     secure: true,
                                    //     auth: {
                                    //         user: "mailto:donotreply@nglcommunications.com",
                                    //         pass: "yr%5V9GB"
                                    //     }
                                    // });
                                    // var mailOptions = {
                                    //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                    //     to: Res[0].email,
                                    //     usernmae: Res[0].username,
                                    //     email: Res[0].email,
                                    //     subject: `${emlRes[0].subject}`,
                                    //     text: "Thank You For Registration",
                                    //     html: `${tmpData}`
                                    // }
                                    // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                    //     if (_emailError) {
                                    //         let objv = new RawView(res);
                                    //         objv.prepare({ message: "Opps Email Not Sent!", status: 502 });
                                    //         objv.execute();
                                    //     } else {
                                    //         let objv = new RawView(res);
                                    //         objv.prepare({ message: "Password Reset Successfully!", status: 201 });
                                    //         objv.execute();
                                    //     }
                                    // });
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + Res[0].iduser + "','" + Res[0].idaccount + "','" + FromEmail + "','" + Res[0].email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send to Update Password.', '" + parseBody(tmpData) + "','Thank You for Updating Your Password. ','8')"; obj1.prepare();
                                    obj1.execute((_err: any, __result: any) => {
                                        if (_err == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 201, message: "Password Updated Successfully!" });
                                            objv.execute();
                                        }
                                        else {
                                            console.log("Error In Updating Password!");
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 401, message: "Opps Email Not Sent!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    console.log("Template Data Not Found!");
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something went wrong with find temlate!", status: 503 });
                                    objv.execute();
                                }
                            }
                            else {
                                console.log("Something Went Wrong with DB!");
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went wrong with find temlate.", status: 504 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 505, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Password Verification Key has expired/Invalid Account!", status: 401 });
                objv.execute();
            }
        });
    }
    /************************
    *  Forgot Password end  *
    ************************/

    /* added here query for usersCustomer list for dropdown */
    customerList(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                //obj.qrysql = "SELECT a.san,u.username,u.iduser FROM `user`u INNER JOIN account a ON a.idaccount=u.idaccount WHERE a.`idaccount`= '" + sessdata.idaccount + "'";
                obj.qrysql = "SELECT a.san,u.username,u.iduser, up.firstname, up.lastname FROM `user`u LEFT JOIN account a ON a.idaccount=u.idaccount RIGHT JOIN user_profile up ON u.iduser=up.iduser WHERE u.`is_deleted`= 0 AND a.`idaccount`= '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    billingEnableOrDisable(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `account` SET `is_billing`='" + sdata.bVal + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 0, status: 201, message: "Successfully Updated." });
                        objv0.execute();
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    kycUpdateStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;
                const today_date = new Date();
                let today_day = today_date.getDate();
                let today_month = today_date.getMonth() + 1;
                let today_year = today_date.getFullYear();
                let today_time = today_date.toLocaleTimeString('en-US')
                let approve_date = today_year + '-' + today_month + '-' + today_day + ' ' + today_time;
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `user` SET `kyc_verify_status`='1' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `know_your_customer` SET `approve_date`='" + approve_date + "' WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((errors: any, result: any) => {
                            if (errors == 1) {
                                let objv0 = new RawView(res);
                                objv0.prepare({ error: 0, status: 201, message: "KYC  Successfully Verified." });
                                objv0.execute();
                            }
                            else {
                                let objv0 = new RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        })
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }


    /** start onBoardingVerification */
    onBoardingVerification(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = JSON.parse(req.body.data);
                let arrData: any;
                if (rdata.email) {
                    arrData = '`isEmailVerify`=' + rdata.email;
                }
                if (rdata.phone) {
                    arrData = '`isMobileVerify`=' + rdata.phone;
                }
                if (rdata.isAddress) {
                    arrData = '`isAddress`=' + rdata.isAddress;
                }
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.filter = null;
                obj0.nonqrysql = "UPDATE `user` SET '" + arrData + "'  WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((_error: any, bvRes: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "onBoarding Verification Updated Successfully",
                            status: 200
                        })
                        objv.execute();
                    }

                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Brand Update!", status: 502 });
                        objv.execute();
                    }


                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    /**Inset query for Domain Block */
    domainBlock(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var rdata: any = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "INSERT INTO `domain_block` (`ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact`) VALUES('" + rdata.ip + "', '" + rdata.email + "', '" + rdata.specific_domain + "', '" + rdata.first_name + "', '" + rdata.last_name + "', '" + rdata.contact + "')";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "Domain Block Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Domain Blocke Not Created Successfully!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /**GET query for Domain Block */
    getDomainBlk(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `domain_block_id`,`ip_address`,`email`,`domain_name`,`first_name`,`last_name`,`contact`, `created_at` FROM `domain_block` ORDER BY `domain_block_id` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Domain Block Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Domain Block List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**PUT query for Domain Block */
    updateDomainBlock(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.body.data;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `domain_block` SET `ip_address`='" + sdata.ip + "', `email`='" + sdata.email + "', `domain_name`='" + sdata.specific_domain + "', `first_name`='" + sdata.first_name + "', `last_name`='" + sdata.last_name + "', `contact`='" + sdata.contact + "'  WHERE `domain_block_id`='" + sdata.domen_id + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Domain Block Updated Successfully!", data: result, status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /*DELETE query for Domain block*/
    deleteDomainBlock(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `domain_block` WHERE `domain_block_id`='" + req.query.domain_block_id + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Domain Block Deleted Successfully!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    /* public compairePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let nullPassword: any = [];
                let matchedPassword: any = [];
                let notmatchedPassword: any = [];
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `password`, `ext_name`, `username`,`idaccount`,`iduser` FROM `user`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        for (let i of result) {

                            if (i.ext_name && i.password) {
                                let ext = bcrypt.compareSync(i.ext_name, i.password);
                                if (ext) {
                                    matchedPassword.push({ status: ext, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                                }
                                else {
                                    notmatchedPassword.push({ status: ext, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                                }
                            }
                            else {
                                nullPassword.push({ status: null, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                            }
                        }
                        if (matchedPassword.length > 0 || notmatchedPassword.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Fetched Successfully!", status: 200, data: { matchedPassword: matchedPassword, notmatchedPassword: notmatchedPassword, nullPassword: nullPassword } });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Not Fetched!", status: 502, data: { matchedPassword: [], notmatchedPassword: [], nullExtPassword: [] } });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    } */

    getResellerUsers(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `reseller_iduser`,`signup_link_id`,`validationKey` from `user` where `iduser`= '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Reseller Users Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Reseller Users List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getResellerTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                if (data.iduser != '0' && data.iduser != null && data.key != null) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `url`,`key`,`name` as iname FROM `signup_referral_link` WHERE `key`='" + data.key + "' AND `iduser` ='" + data.iduser + "' ";
                    obj.prepare();
                    obj.execute((_error: any, result1: any) => {
                        if (_error == 1) {
                            if (result1.length > 0) {
                                let url = result1[0].url;
                                let url1 = url.split('/#/signup?url=')[1];
                                let decodeUrl = Buffer.from(url1, "base64").toString("utf8");
                                let idtariff = decodeUrl.split('idtariff=')[1];
                                let idtarifff = idtariff.split('&ukey=')[0];
                                let obj1 = new ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT `idtariff`,`idaccount`,`name`,`description`,`type`,`day_num`,`proration` FROM `tariff` WHERE idtariff IN (" + idtarifff + ")";
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, data1: result1, message: "Tariff Fetched Successfully!", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "No Url Found!", status: 503 });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objh = new RawView(res);
                    objh.prepare({ message: "No Data found for this Account!", status: 502 });
                    objh.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    public getUserStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query.type;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `newUser_status` FROM `user` WHERE `iduser` ='" + sdata + "'";
                obj.prepare();
                obj.execute((__error, result) => {
                    if (__error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetch User Status Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went wrong!", status: 501 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**GET data by id */
    kycVerifyHeader(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `iduser`,`idaccount`,`kyc_verify_status` FROM `user` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Kyc Details Fatched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With KYC Verification!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public resetPassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body;
                if (sdata.old_password == 'undefined' || sdata.old_password == null) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Password Not Found.", error: 0 });
                    objv.execute();
                }
                else {
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `password` FROM `user` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj0.prepare();
                    obj0.execute((_error: any, result: any) => {
                        let pass1: any = sdata.old_password
                        if (result[0] && result[0] !== undefined && (bcrypt.compareSync(pass1, result[0].password))) {
                            let password1 = bcrypt.hashSync(sdata.confirm_password, 10);
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "CALL ChangePassword(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + result[0].password + "','" + password1 + "')";
                            obj.prepare();
                            obj.execute((__error: any, result: any) => {
                                if (__error == 1) {
                                    let obj4 = new ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "UPDATE `user` SET `ext_name`='" + parseBody(sdata.confirm_password) + "',`resetPassword`='1' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj4.prepare();
                                    obj4.execute((__error: any, user: any) => {
                                        let obj1 = new ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT up.firstname, up.lastname, up.email,u.username FROM `user` u JOIN user_profile up ON u.iduser = up.iduser WHERE u.iduser = '" + sessdata.iduser + "'";
                                        obj1.prepare();
                                        obj1.execute((Err: any, Res: any) => {
                                            if (Err == 1) {
                                                let obj5 = new ModelRawQuery(req, res);
                                                obj5.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='reset_password'";
                                                obj5.prepare();
                                                obj5.execute((emlErr: any, emlRes: any) => {
                                                    if (emlErr == 1) {
                                                        if (emlRes.length > 0) {
                                                            let tmpData = emlRes[0].template;
                                                            tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                            tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                            // var smtpTransport = nodemailer.createTransport({
                                                            //     service: "gmail",
                                                            //     host: "smtp.gmail.com",
                                                            //     port: 587,
                                                            //     secure: true,
                                                            //     auth: {
                                                            //         user: "mailto:donotreply@nglcommunications.com",
                                                            //         pass: "yr%5V9GB"
                                                            //     }
                                                            // });
                                                            // var mailOptions = {
                                                            //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                                            //     to: Res[0].email,
                                                            //     usernmae: Res[0].username,
                                                            //     email: Res[0].email,
                                                            //     subject: `${emlRes[0].subject}`,
                                                            //     text: "Thank You For Registration",
                                                            //     html: `${tmpData}`
                                                            // }
                                                            // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                            //     if (_emailError) {
                                                            //         console.log("Opps Email Not Sent!", _emailError);
                                                            //     } else {
                                                            //         console.log("Email Send  Successfully!");
                                                            //         let objv = new RawView(res);
                                                            //         objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                            //         objv.execute();
                                                            //     }
                                                            // });

                                                            let obj1 = new ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + Res[0].email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Reset Password', '" + parseBody(tmpData) + "','Mail Send for Reset Password','9')";
                                                            obj1.prepare();
                                                            obj1.execute((_err: any, __result: any) => {
                                                                console.log("Email Send  Successfully!")
                                                                if (_err == 1) {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    console.log("Error In Updating Password!");
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            console.log("Template Data Not Found!");
                                                        }
                                                    }
                                                    else {
                                                        console.log("Something Went Wrong with DB!");
                                                    }
                                                });
                                            }
                                            else {
                                                let objv0 = new RawView(res);
                                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                                objv0.execute();
                                            }
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        _error: _error,
                                        message: "Something Went Wrong With Connection!",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objw = new RawView(res);
                            objw.prepare({
                                message: "The old password you have entered is incorrect!",
                                status: 504
                            });
                            objw.execute();
                        }
                    });
                }

            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 505 });
                objv.execute();
            }
        });
    }

    getfeatureService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT fs_id, fs_name_code, fs_name FROM feature_service";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Feature Details Fatched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data not Available!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }

    getSuspendedService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount` FROM `account_service` WHERE `as_status`='0' GROUP BY idaccount";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Details Fatched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }

    getfeatureServiceById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let idaccount: any = req.query.type;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT fs_id, idaccount, as_status From account_service where idaccount ='" + idaccount + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Feature Details Fatched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", data: result, status: 500, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 501 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 502 });
                objv.execute();
            }
        });
    }

    getfeatureServiceStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `fs_id`,`as_status` FROM `account_service` WHERE `idaccount`='" + sessdata.idaccount + "' AND `as_status` = '1'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Details Fatched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 503 });
                objv.execute();
            }
        });
    }

    updateSuspendedService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let rdata: any = [];
                    rdata = req.body.data;
                    rdata.forEach((element: any, index: any) => {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `account_service` SET `as_status`='" + element.as_status + "' WHERE `idaccount`='" + element.idaccount + "' AND `fs_id`='" + element.fs_id + "'";
                        obj2.prepare();
                        obj2.execute((error: any, result: any) => {
                            if (error == 1) {
                                if (result.affectedRows > 0) {
                                    console.log("data updated Successfully for ", element.fs_id);
                                }
                                else {
                                    console.log("data Not updated Successfully", element.fs_id);
                                }
                            }
                            else {
                                console.log("Something went wrong with update");
                            }
                        });
                    });
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service updated Successfully!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 501 });
                    objv.execute();
                }

            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 502 });
                objv.execute();
            }
        });
    }

    Payment_status(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (sessData.type == 1) {
                    let sdata = JSON.parse(req.body.data);
                    let objj1 = new ModelRawNonQuery(req, res);
                    objj1.nonqrysql = "UPDATE `user` set `trust_score`='" + sdata.trustscore + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                    objj1.prepare();
                    objj1.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv2 = new RawView(res);
                            objv2.prepare({ message: 'Payment Status Update Successfully!', data: result, status: 200 });
                            objv2.execute();
                        } else {
                            let objv2 = new RawView(res);
                            objv2.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv2.execute();
                        }
                    })
                } else {
                    let objvv = new RawView(res);
                    objvv.prepare({ message: "Service Unavailable!", status: 503 });
                    objvv.execute();
                }
            }
            else {
                let objv2 = new Res406(res);
                objv2.prepare(session);
                objv2.execute();
            }
        })
    }

    trust_score(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (sessData.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT score , description FROM `stripe_trust_score`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: 'Trust Score Fetch Successfully!', data: result, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    })
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }

}

export class TZ {
    /**
     * To create the default TimeZone of user
     */
    CreateTZ(req: Request, res: Response, next: NextFunction, callback: (error: any, data: any) => void) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(192, " + sessdata.iduser + ");"
                obj1.prepare()
                obj1.execute((error: any, result: any) => {
                    if (error == 1) {
                        /**
                         * Update the TimeZone in user's session data
                         */
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=192;"
                        obj2.prepare()
                        obj2.execute((error: any, result: any) => {
                            if (error == 1 && Array.isArray(result) && result.length > 0) {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `session` SET `client_time`='" + result[0].client_time + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                obj3.prepare()
                                obj3.execute((error: any, result2: any) => {
                                    sessdata.client_time = result[0].client_time
                                    sessiondata.set(sessdata.authkey, sessdata)
                                    callback(error, result)
                                })
                            }
                            else {
                                callback(error, result)
                            }
                        })
                    }
                    else {
                        callback(error, result)
                    }
                })
            }
            else {
                callback(error, "No session data there")
            }
        });
    }
}