import { Request, Response, NextFunction } from "express";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Socket } from "net";
import { VoiceServer, UploadDirectory, Setting } from "../config/setting.config";
import { RawView } from "../lib/view/RawView";
import { VoiceRates } from "./common.lib";
var request = require('request');
const vs_server = new VoiceServer();
const prefix = vs_server.Prefix;

export class APIBase {
  constructor() {
  }

  public getLRN(lrn_detail: any): boolean {
    if (lrn_detail.hasOwnProperty('errors')) {
      if (lrn_detail.errors[0] == "LRN Not Found.") {
        return true;
      }
      else
        return false;
    }
    else
      return false;
  }

  public getRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    let cat:any;
    if (category == 'TF' || category == 'NN') {
      cat = category == 'TF' ? "toll_free_number" : "local_number";
    }
    if (category == 'VN') {
      cat = category == 'VN' ? "vanity_number" : "";
    }
    if (category == '') {
      return false;
    }
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `rate` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
      callback(err, rates)
    });
  }

  public getRateCenter(req: Request, res: Response, npa: any, nxx: any, callback: (err: any, data: any) => void) {
    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT   `rc_abbre`, `loc_state` FROM `did_location_info` WHERE `npa`='" + npa + "'  AND `nxx`='" + nxx + "'";
    obj.prepare();
    obj.execute((err, ratecenter_state) => {
      if (ratecenter_state.length > 0) {
        callback('', ratecenter_state)
      } else {
        callback(err, '')
      }
    });
  }

  public verifyBrand(req: Request, res: Response, npa: any, callback: (err: any, data: any) => void) {
    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT   `brand_name` FROM `brand` WHERE `idaccount`=''";
    obj.prepare();
    obj.execute((err, ratecenter_state) => {
      if (ratecenter_state.length > 0) {
        callback('', ratecenter_state)
      } else {
        callback(err, '')
      }
    });
  }

  public verifyCampagin(req: Request, res: Response, npa: any, nxx: any, callback: (err: any, data: any) => void) {
    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT   `idbrand` FROM `campaign` WHERE `npa`='" + npa + "'";
    obj.prepare();
    obj.execute((err, ratecenter_state) => {
      if (ratecenter_state.length > 0) {
        callback('', ratecenter_state)
      } else {
        callback(err, '')
      }
    });
  }

  public getLrnDetails(req: Request, res: Response, did: any, callback: (err: any, data: any) => void) {
    did = "" + did + "";
    let len = did.length - 10;
    let number = did.slice(len, did.length);
    let npa = number.slice(0, 3);
    let nxx = number.slice(3, 6);
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT *  FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
    obj1.prepare()
    obj1.execute((err, lrn_details) => {
      if (lrn_details.length > 0) {
        let lrn_result = Object.assign({ lrn: number }, lrn_details[0]);
        callback('', [lrn_result])
      } else {
        callback(err, '')
      }
    });
  }

  public DialCall(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {

    let socketData = '{caller_id_number=' + req.body.CALLER.trim() + ',dialed_number=' + req.body.CALLEE.trim() + ',effective_caller_id_name=' + req.body.CALLER.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + sessdata.idapi + ',accountcode=' + sessdata.idaccount + ',leg_to=' + vrate.getCallRate(req.body.CALLER) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',ctype=4,ocn=' + lerg_data[0].ocn + ',category=' + lerg_data[0].category + ',mobility=' + lerg_data[0].co_name_spec_c + ',effective_caller_id_number=' + req.body.CALLER.trim() + ',origination_caller_id_name=' + req.body.CALLER.trim() + ',origination_caller_id_number=' + req.body.CALLER.trim() + '}sofia/gateway/iplink/' + prefix + req.body.CALLER.trim() + ' &bridge({caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.CALLEE.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',effective_caller_id_number=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + sessdata.idapi + ',accountcode=' + sessdata.iduser + ',leg_from=' + vrate.getCallRate(req.body.CALLER) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',ctype=4,rec_rate=' + vrate.RecordRate(req.body.Recording) + ',lata=' + lerg_data[0].lata + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}sofia/gateway/iplink/' + prefix + req.body.CALLEE.trim() + ')'

    let client = new Socket();
    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
      client.write('auth ' + vs_server.PASS + '\n\n');;
      client.write('api originate ' + socketData + '\n\n');
      client.on("data", (respon) => {
        let tmp = respon.toString().split("\n");
        tmp.forEach((elem: any) => {
          if (elem != undefined) {
            if (elem.length > 0) {
              let t1 = elem.split("OK");
              if (t1.length == 2) {
                if (t1[0] == "+") {
                  res.send({ status: 201, message: "Call connected successfully", uuid: t1[1].trim() });
                }
              }
              let t2 = elem.split("ERR");
              if (t2.length == 2) {
                res.send({ status: 404, message: t2[1].trim() });
                client.end();
              }
            }
          }
        });
      });

      client.on("error", (e) => {
      })
      client.on("end", (err: any) => {
      })
    });
  }


  public makeCall(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    let socketData = '{caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.TO.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',effective_caller_id_number=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + sessdata.idapi + ',accountcode=' + sessdata.idaccount + ',leg_from=' + vrate.getCallRate(req.body.Extension) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}user/' + req.body.Extension.trim() + ' &bridge({caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.TO.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + sessdata.idapi + ',accountcode=' + sessdata.iduser + ',leg_to=' + vrate.getCallRate(req.body.TO) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',ocn=' + lerg_data[0].ocn + ',category=' + lerg_data[0].category + ',mobility=' + lerg_data[0].co_name_spec_c + ',effective_caller_id_number=' + req.body.FROM.trim() + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}sofia/gateway/iplink/' + prefix + req.body.TO.trim() + ')';
    let client = new Socket();
    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
      console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
      client.write('auth ' + vs_server.PASS + '\n\n');
      console.log("Password : " + vs_server.PASS);
      console.log(socketData);
      client.write('api originate ' + socketData + '\n\n');
      client.on("data", (respon) => {
        let tmp = respon.toString().split("\n");
        tmp.forEach((elem: any) => {
          if (elem != undefined) {
            if (elem.length > 0) {
              console.log(elem);
              let t1 = elem.split("OK");
              if (t1.length == 2) {
                console.log(t1);
                if (t1[0] == "+") {
                  res.status(200).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });

                }
              }
            }
          }
        });
      });

      client.on("error", (e) => {
        console.log(e);
      })

      client.on("end", () => {

      })
    });
  }

  public makeCallviaMedia(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    let sdata: any = req.body;

    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT `uploaded_file`,`iduser` FROM `upload_media` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "' AND `media_id`='" + sdata.mediaID + "'";
    obj.prepare();
    obj.execute((err, result) => {
      if (result.length > 0) {
        let dir = new UploadDirectory();
        let mediapath: any = dir.FREESWITCHUPLOAD + result[0].uploaded_file;
        let vz = new VoiceRates();
        vz.getZone(req, res, lerg_data[0].lrn, (errr: any, zone: any) => {
          let socketData = '{caller_id_number=' + req.body.FROM + ',dialed_number=' + req.body.TO + ',effective_caller_id_name=' + req.body.FROM + ',effective_caller_id_number=' + req.body.FROM + ',iduser=' + sessdata.iduser + ',idapi=' + sessdata.idapi + ',accountcode=' + sessdata.iduser + ',leg_from=' + vrate.getCallRates(lerg_data[0].lrn, zone) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',ctype=4,rec_rate=' + vrate.RecordRate(req.body.Recording) + ',lata=' + lerg_data[0].lata + ',origination_caller_id_name=' + req.body.FROM + ',origination_caller_id_number=' + req.body.FROM + '}sofia/gateway/iplink/' + prefix + req.body.TO + ' &playback(' + mediapath + ')';
          let client = new Socket();
          client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
            client.write('auth ' + vs_server.PASS + '\n\n');
            console.log("Password : " + vs_server.PASS);
            console.log(socketData);
            client.write('api originate ' + socketData + '\n\n');
            client.on("data", (respon) => {
              let tmp = respon.toString().split("\n");
              tmp.forEach((elem: any) => {
                if (elem != undefined) {
                  if (elem.length > 0) {
                    console.log(elem);
                    let t1 = elem.split("OK");
                    if (t1.length == 2) {
                      console.log(t1);
                      if (t1[0] == "+") {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "Call Connected Successfully!", uuid: t1[1].trim() });
                        objv.execute();
                      }
                    }
                  }
                }
              });
            });
            client.on("error", (e) => {
              console.log(e);
            })

            client.on("end", () => {

            })
          });
        })
      } else {
        let objv = new RawView(res);
        objv.prepare({ status: 404, message: "MediaID is Invalid Please Provide Correct MediaID!" });
        objv.execute();
      }
    });
  }

  public ThreeWayCall(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    let digit: any;
    digit = req.body.TONE;
    let client = new Socket();
    client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
      console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
      client.write('auth ' + vs_server.PASS + '\n\n');
      console.log("Password : " + vs_server.PASS);
      client.write("api originate {effective_caller_id_name=+14233016767,effective_caller_id_number=+14233016767,origination_caller_id_name=+14233016767,origination_caller_id_number=+14233016767,ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + ",idapi=' + sessdata.idapi + ',leg_other=" + vrate.getCallRate(req.body.Number) + "}sofia/gateway/iplink/" + prefix + req.body.Number + " XML default");
      console.log("api originate {effective_caller_id_name=+14233016767,effective_caller_id_number=+14233016767,origination_caller_id_name=+14233016767,origination_caller_id_number=+14233016767,ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + ",idapi=' + sessdata.idapi + ',leg_other=" + vrate.getCallRate(req.body.Number) + "}sofia/gateway/iplink/" + prefix + req.body.Number + " XML default");
      client.on("data", (respon) => {
        console.log("respon", respon.toString);
        let tmp = respon.toString().split("\n");
        console.log("tmp", tmp);
        tmp.forEach((elem: any) => {
          console.log("elem", elem);
          if (elem != undefined) {
            if (elem.length > 0) {
              console.log(elem);
              let t1 = elem.split("OK");
              console.log("t1", t1);
              if (t1.length == 2) {
                console.log(t1);
                if (t1[0] == "+") {
                  res.status(200).send(t1[1].trim());
                  console.log("uuid_bridge" + req.body.UUID + " " + t1[1].trim());
                  client.write("uuid_bridge" + req.body.UUID + " " + t1[1].trim());
                  client.destroy();
                }
              }
            }
          }
        });
      });

      client.on("error", (e) => {
        console.log(e);
      })

      client.on("end", () => {

      })
    });

  }

  public Barge(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    req.body.FROM = "4233016767";
    let cmd = "api originate {effective_caller_id_name=" + req.body.FROM.trim() + ",effective_caller_id_number=" + req.body.FROM.trim() + ",origination_caller_id_name=" + req.body.FROM.trim() + ",origination_caller_id_number=" + req.body.FROM.trim() + ",leg_other=" + vrate.getCallRate(req.body.Number) + ",idapi=" + sessdata.idapi + ",ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + "}sofia/gateway/iplink/" + prefix + req.body.Number + " 88" + req.body.Extension + "";
    console.log(cmd);
    let client = new Socket();
    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
      console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
      client.write('auth ' + vs_server.PASS + '\n\n');
      console.log("Password : " + vs_server.PASS);
      client.write(cmd + '\n\n');
      client.on("data", (respon) => {
        let tmp = respon.toString().split("\n");
        tmp.forEach((elem: any) => {
          if (elem != undefined) {
            if (elem.length > 0) {
              console.log(elem);
              let t1 = elem.split("OK");
              if (t1.length == 2) {
                console.log(t1);
                if (t1[0] == "+") {
                  res.status(200).send(t1[1].trim());
                  client.destroy();
                }
              }
            }
          }
        });
      });

      client.on("error", (e) => {
        console.log(e);
      })

      client.on("end", () => {

      })
    });

  }

  public CallTransfer(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    let length = req.body.Number.length;
    if (length == 7) {
      var socketData = req.body.UUID + " -bleg " + req.body.Number + " XML default";
    } else {
      var socketData = req.body.UUID.trim() + " -bleg 88791" + req.body.Number.trim() + " XML default";
    }
    let client = new Socket();
    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
      console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
      client.write('auth ' + vs_server.PASS + '\n\n');
      console.log("Password : " + vs_server.PASS);
      console.log(socketData);
      client.write('api uuid_transfer ' + socketData + '\n\n');
      client.on("data", (respon) => {
        let tmp = respon.toString().split("\n");
        tmp.forEach((elem: any) => {
          if (elem != undefined) {
            if (elem.length > 0) {
              console.log(elem);
              let t1 = elem.split("OK");
              if (t1.length == 2) {
                console.log(t1);
                if (t1[0] == "+") {
                  client.write("api uuid_setvar " + req.body.UUID + " leg_other " + vrate.getCallRate(req.body.Number) + '\n\n');
                  res.status(200).send(t1[1].trim());
                  client.destroy();
                }
              }
            }
          }
        });
      });
      client.on("error", (e) => {
        console.log("Error", e);
      });
      client.on("end", () => {
        console.log("End")
      })
    });
  }

  public login(req: Request, res: Response, callback: (err: any, data: any) => void) {
    var options = {
      'method': 'POST',
      'url': 'https://apicontrol.call48.com/api/v4/login',
      'headers': {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({
        'user_name': 'iplink1',
        "password": "kzwJQV4arc4",
      }),
    };
    request(options, (error: any, response: any) => {
      if (!error) {
        let sdata = JSON.parse(response.body);
        if (sdata.code == 200) {
          let authkey = sdata.data.token
          callback('', authkey);
        } else {
          callback(sdata, '');
        }
      } else {
        callback(error, '');
      }
    })
  }

  // public abstract getByRate(req:Request, res:Response, callback:(err:any, data:any)=>void):void;
  // public abstract getTollFree(req:Request, res:Response, callback:(err:any, data:any)=>void):void;
  // public abstract buyDID(req: Request, res: Response, callback: (err: any, data: any) => void):void;
  // public abstract disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void):void;
  // public abstract MakeCall(req: Request, res: Response, next: NextFunction):void;
  // public abstract MakeOutboundCallToNumber(req: Request, res: Response, next: NextFunction): void;
}