import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
const Str = require('@supercharge/strings');
var request = require("request");
const checkDescription = (desc: any) => {
    let result = '';
    if (desc) {
        result = desc.replace(/"/g, '\"').replace(/'/g, "\'");
        return result;
    } else {
        result = '';
        return result;
    }
}
export abstract class SMS {
    private _key: string;
    private _secret: string;
    private _priority: string;
    private _account: string;
    protected req: any;
    protected res: any;

    constructor() {
        this._key = "";
        this._secret = "";
        this._priority = "";
        this._account = "";
    }

    protected get key(): string {
        return this._key;
    }

    protected set key(val: string) {
        this._key = val;
    }

    protected get secret(): string {
        return this._secret;
    }

    protected set secret(val: string) {
        this._secret = val;
    }

    protected get priority(): string {
        return this._priority;
    }

    protected set priority(val: string) {
        this._priority = val;
    }

    protected get account(): string {
        return this._account;
    }

    protected set account(val: string) {
        this._account = val;
    }

    public getType(did: any) {
        let rate_type = "";
        did = "" + did + "";
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == 800 || digit == 822 || digit == 833 || digit == 844 || digit == 855 || digit == 866 || digit == 877 || digit == 888) && number.length == 10) {
            rate_type = "toll_free";
        }
        else if (number.length == 10) {
            rate_type = "10_dlc";
        }
        else {
            rate_type = "short_code";
        }
        return rate_type;
    }

    public getRate(req: Request, res: Response, tariff: number, type: string, subcategory: string, callback: (err: any, data: any) => void) {
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT IFNULL(`MT_rates`,0) FROM `sms_rate` WHERE `id_tariff`='" + tariff + "'  AND `subcategory`='" + subcategory + "' LIMIT 1";
        obj1.prepare()
        obj1.execute((err, sms_rate) => {
            console.log(err, sms_rate);
            if (sms_rate.length > 0) {
                callback('', sms_rate)
            } else {
                callback(err, '')
            }
        });
    }

    public getLrnDetails(req: Request, res: Response, did: any, callback: (err: any, data: any) => void) {
        console.log("Did", did);
        did = "" + did + "";
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let npa = number.slice(0, 3);
        let nxx = number.slice(3, 6);
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT npa,block, lata, ocn, lata, state, co_name_spec_c, li.category, IFNULL(o.id,0) idoperator, IFNULL(sr.rates,0) rates,IFNULL(o.name,'') `name` FROM (SELECT * FROM `lerg_info` WHERE npa='" + npa + "' AND nxx='" + nxx + "') li LEFT JOIN `lerg_operator` lo  ON lo.operator=li.co_name_spec_c AND lo.category=li.category LEFT JOIN `operator_mapping` om ON om.idlerg_operator=lo.idlerg_operator LEFT JOIN `operator` o ON om.idoperator=o.id LEFT JOIN (SELECT * FROM `surcharge_rates` WHERE direction='outbound' AND subtype='SMS' AND category='none' AND TYPE='10DLC') sr ON sr.idoperator=o.id";
        obj1.prepare()
        obj1.execute((err, lrn_details) => {
            console.log("====", err, lrn_details);
            if (err == 1) {
                callback('', { message: "LRN Found Successfully", status: 200, data: lrn_details })
            } else {
                callback({ message: "Query Error", status: 502 }, '')
            }
        });
    }

    public saveSMS(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        const uuid = Str.random(30);
        let sdata = req.body;
        let TO = "" + sdata.TO.trim() + "";
        let len = TO.length - 10;
        let FROM = "+1" + sdata.FROM.trim();
        let To = "+1" + sdata.TO.trim();
        let number_type = this.getType(sdata.TO);
        let msg_data = sdata.BODY.replace(/"/g, '\\"').replace(/'/g, "\\'");
        this.getRate(req, res, sessdata.idtariff, number_type, "SMS", (error, sms_rate) => {
            // To check MT Rates
            if (sms_rate || sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                console.log("sms_rate::", sms_rate);
                let msgcount=Math.ceil((sdata.BODY.length)/159);
                let cost = msgcount*(sms_rate[0].MT_rates+lerg_data[0].rates);
                let encsms = encodeURI(sdata.BODY);
                encsms = encsms.replace(/"/g, '\\"').replace(/'/g, "\\'");
                let iQry: string = "INSERT INTO `mdrlive` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`connection_key`,`sms_outbound_key`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`msg_count`,`cost`,`direction`) VALUES('" + uuid + "','" + sdata.TO + "','" + sms_rate[0].MT_rates*msgcount + "','" + sdata.FROM + "','" + checkDescription(msg_data) + "','dispatched','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + sessdata.idapi + "','" + lerg_data[0].rates*msgcount + "','" + lerg_data[0].idoperator + "','" + lerg_data[0].name + "','"+msgcount+"','"+cost+"','outbound');\n"

                iQry += "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`,`coding`) VALUES('" + FROM + "','" + To + "','" + checkDescription(encsms) + "',UNIX_TIMESTAMP(),'" + sms_provider + "','11',LAST_INSERT_ID(),'0');"

                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = iQry;
                obj.prepare();
                obj.execute((error: any, responce: any) => {
                    if (error == 1) {
                        let obj = new RawView(res);
                        obj.prepare({ status: 201, message: "SMS Submit Successfully", batch_id: uuid });
                        obj.execute()
                    }
                    else {
                        let obj = new RawView(res);
                        obj.prepare({ status: 502, message: "Something went wrong!" });
                        obj.execute()
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        })
    }

    public saveMMS(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, sms_provider: string, didData: any, fType: any, callback: (err: any, data: any) => void) {
        //let sdata = req.body;
        var sdata: any = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
        let msg_data = "";
        let FROM = "1" + sdata.FROM.trim();
        let TO = "1" + sdata.TO.trim();
        if (sdata.FROM.trim().length >= 11)
            FROM = sdata.FROM.trim();
        if (sdata.TO.trim().length >= 11)
            TO = sdata.TO.trim();
        if (sdata.BODY != null && sdata.BODY != undefined)
            msg_data = sdata.BODY.replace(/"/g, '\\"').replace(/'/g, "\\'");

        let number_type = this.getType(sdata.TO);
        this.getRate(req, res, sessdata.idtariff, number_type, "MMS", (error, mms_rate) => {
            if (mms_rate) {

                var options = {
                    'method': 'POST',
                    'url': 'https://api.ci.mblox.com/ep/v2/',
                    'headers': {
                        'Content-Type': 'application/json',
                        'x-api-key': '4ZFnGzsQnEspkuOsUWxMHY5FSBaqmue0'
                    },
                    body: JSON.stringify({
                        "action": "sendMMS",
                        "service-id": didData.camp_registry,
                        "to": TO,
                        "from": FROM,
                        "from-mask": FROM,
                        "fallback-sms-text": "MMS",
                        "disable-fallback-sms-link": false,
                        "disable-fallback-sms": false,
                        "slide": fType
                    })
                };
                request(options, (error: any, response: any) => {
                    let dStatus: any = JSON.parse(response.body);

                    if (!error && dStatus['status'] == 'success') {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `mms_dlr` (`idaccount`,`iduser`,`origin`,`code`,`sent_as`,`status`,`mms_id`,`from`,`to`,`tracking_id`,`status_details`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "','','','','" + dStatus['status'] + "','','" + sdata.FROM + "','" + sdata.TO + "','" + dStatus['tracking-id'] + "','" + dStatus['status-details'] + "')";
                        obj1.prepare();
                        obj1.execute((errord: any, responced: any) => {
                            console.log("Data Inserted Successfully!");
                        });

                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`from_mask`, `slide`, `status_details`,`service_id`,`error_code`,`direction`) VALUES('" + dStatus['tracking-id'] + "','" + sdata.TO + "','" + mms_rate[0].MT_rates + "','" + sdata.FROM + "','" + checkDescription(msg_data) + "','" + dStatus['status'] + "','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + sessdata.idapi + "','" + lerg_data[0].rates + "','" + lerg_data[0].idoperator + "','" + lerg_data[0].name + "','" + sdata.FROM + "','https://mms.signalmash.com/content/" + req.file.filename + "','" + dStatus['status-details'] + "','" + didData.camp_registry + "',200,'outbound')";
                        obj.prepare();
                        obj.execute((error: any, responce: any) => {
                            if (error == 1) {
                                let obj = new RawView(res);
                                obj.prepare({ status: 201, message: "MMS sent successfully", batch_id: dStatus['tracking-id'] });
                                obj.execute()
                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({ status: 502, message: "Something went wrong!" });
                                obj.execute()
                            }
                        });
                    } else {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`from_mask`, `slide`, `status_details`,`service_id`,`error_code`,`direction`) VALUES('0','" + sdata.TO + "','" + mms_rate[0].MT_rates + "','" + sdata.FROM + "','" + checkDescription(msg_data) + "','" + dStatus['status'] + "','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + sessdata.idapi + "','" + lerg_data[0].rates + "','" + lerg_data[0].idoperator + "','" + lerg_data[0].name + "','" + sdata.FROM + "','https://mms.signalmash.com/content/" + req.file.filename + "','" + dStatus['error-info'] + "','" + didData.camp_registry + "','" + dStatus['error-code'] + "','outbound')";
                        obj.prepare();
                        obj.execute((error: any, responce: any) => {
                            let obj = new RawView(res);
                            obj.prepare({ status: 400, message: "MMS sent failed!", data: dStatus });
                            obj.execute()
                        });
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        })
    }

    public saveSMS_Old(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        const uuid = Str.random(30);
        let sdata = req.body;
        let TO = "" + sdata.TO.trim() + "";
        let len = TO.length - 10;
        let FROM = "+1" + sdata.FROM.trim();
        let To = "+1" + sdata.TO.trim();
        let number_type = this.getType(sdata.TO);
        let msg_data = sdata.BODY.replace(/"/g, '\\"').replace(/'/g, "\\'");
        this.getRate(req, res, sessdata.idtariff, number_type, "SMS", (error, sms_rate) => {
            // To check MT Rates
            if (sms_rate || sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                console.log("sms_rate::", sms_rate);

                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`connection_key`,`sms_outbound_key`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`) VALUES('" + uuid + "','" + sdata.TO + "','" + sms_rate[0].MT_rates + "','" + sdata.FROM + "','" + checkDescription(msg_data) + "','dispatched','" + lerg_data[0].npa + "','" + lerg_data[0].state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "','" + lerg_data[0].ocn + "','" + lerg_data[0].lata + "','" + lerg_data[0].category + "','" + lerg_data[0].co_name_spec_c + "','" + sessdata.idapi + "','" + lerg_data[0].rates + "','" + lerg_data[0].idoperator + "','" + lerg_data[0].name + "')";
                obj.prepare();
                obj.execute((error: any, responce: any) => {
                    let encsms = encodeURI(sdata.BODY);
                    encsms = encsms.replace(/"/g, '\\"').replace(/'/g, "\\'");
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`,`coding`) VALUES('" + FROM + "','" + To + "','" + checkDescription(encsms) + "',UNIX_TIMESTAMP(),'" + sms_provider + "','11','" + responce.insertId + "','0')";
                    obj.prepare();
                    obj.execute((msg_err: any, msg_resp: any) => {
                        if (msg_err == 1 && msg_resp.insertId) {
                            let objv = new ModelRawQuery(req, res);
                            objv.qrysql = "SELECT `batch_id` FROM `mdr` WHERE `idmdr`='" + responce.insertId + "'";
                            objv.prepare();
                            objv.execute((mdr_err: any, mdr_resp: any) => {
                                if (mdr_err == 1 && mdr_resp.length > 0) {
                                    let obj = new RawView(res);
                                    obj.prepare({ status: 201, message: "SMS Submit Successfully", batch_id: mdr_resp[0].batch_id });
                                    obj.execute()
                                }
                                else {
                                    let obj = new RawView(res);
                                    obj.prepare({ status: 502, message: "Something went wrong!" });
                                    obj.execute()
                                }
                            })
                        }
                        else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 502, message: "Something went wrong!" });
                            obj.execute()
                        }
                    })
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        })
    }

    public abstract SendSms(req: Request, res: Response, next: NextFunction, data: any, sms_provider: string, callback: (err: any, data: any) => void): void;
    public abstract SendMms(req: Request, res: Response, next: NextFunction, data: any, sms_provider: string, callback: (err: any, data: any) => void): void;
}
