import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
var request = require('request');
var convert = require('xml-js');

export class CoreTelAPI extends APIBase {
    private key: string;
    private secret: string;
    private priority: string;
    private account: string;

    constructor(proirity: string, account: string) {
        super();
        this.key = "signalmash.com_did";
        this.secret = "092klqoz,s8";
        this.priority = proirity;
        this.account = account;
    }

    public getNpaNxx(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        if (this.priority = "100") {
            return;
        } else {
            const npa = req.query.NPA;
            let nxx: any = "";
            if (req.body.NXX != undefined)
                nxx = req.query.NXX;
            const rate_center = req.query.RateCenter;
            const qty = req.query.Qty;

            let options: any = {
                'method': 'POST',
                'url': 'https://numberdb.coretel.net/cgi-bin/xmlnumberdb.pl',
                'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>VanitySearch</RequestType><Purpose>SIP</Purpose><Quantity>" + qty + "</Quantity><NPA>" + npa + "</NPA><BillingAccount>" + this.key + "</BillingAccount><Password>" + this.secret + "</Password></xml>",
                rejectUnauthorized: false,
                requestCert: true,
                agent: false
            };
            console.log("options", options);
            request(options, (error: any, response: any, body: any) => {
                if (!error) {
                    let tmp: string = body;
                    let valid_xml = tmp.slice(0, -6)
                    console.log(valid_xml);
                    var result1 = convert.xml2json(valid_xml, { compact: true, spaces: 4 });
                    var res1 = JSON.parse(result1);
                    let ddata = res1.xml.SearchResult;
                    console.log("Data==>", ddata);
                    if (ddata !== undefined && ddata.length > 0) {
                        let str: any = ddata;
                        let obj1 = new ModelRawNonQuery(req, res);
                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`) VALUE ";
                        str.forEach((ele: any) => {
                            console.log(ele.Number._text);
                            qrystr += "('','" + ele.Number._text + "', '', '', '" + ele.RateCenter._text + "', '', '', '', '' ,'" + "coreTel" + "', '" + this.account + "', '" + this.priority + "'),";
                        });
                        obj1.nonqrysql = qrystr.slice(0, -1);
                        obj1.prepare();
                        obj1.execute((err, data) => {
                            callback(err, data);
                        });
                    } else {
                        callback('', ddata);
                    }
                } else {
                    callback('', error);
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority = "100") {
            return;
        } else {
            const state = req.query.State
            const rate_center = req.query.RateCenter;
            const qty = req.query.Qty;

            let options: any = {
                'method': 'POST',
                'url': 'https://devapi.coretel.net/cgi-bin/xmlnumberdb.pl',
                'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>VanitySearch</RequestType><Purpose>SIP</Purpose><Quantity>" + qty + "</Quantity><State>" + state + "</State><RateCenter>" + rate_center + "</RateCenter><BillingAccount>" + this.key + "</BillingAccount><Password>" + this.secret + "</Password></xml>",
                rejectUnauthorized: false,
                requestCert: true,
                agent: false
            };

            request(options, (error: any, response: any, body: any) => {
                if (!error) {
                    let tmp: string = body;
                    let valid_xml = tmp.slice(0, -6)
                    console.log(valid_xml);
                    var result1 = convert.xml2json(valid_xml, { compact: true, spaces: 4 });
                    var res1 = JSON.parse(result1);
                    let ddata = res1.xml.SearchResult;
                    console.log("Data==>", ddata);
                    if (ddata !== undefined && ddata.length > 0) {
                        let str: any = ddata;
                        let obj1 = new ModelRawNonQuery(req, res);
                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`) VALUE ";
                        str.forEach((ele: any) => {
                            console.log(ele.Number._text);
                            qrystr += "('','" + ele.Number._text + "', '', '', '" + ele.RateCenter._text + "', '', '', '', '' ,'" + "coreTel" + "', '" + this.account + "', '" + this.priority + "'),";
                        });
                        obj1.nonqrysql = qrystr.slice(0, -1);
                        obj1.prepare();
                        obj1.execute((err, data) => {
                            callback(err, data);
                        });
                    } else {
                        callback('', ddata);
                    }
                } else {
                    callback('', error);
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            return;
        } else {
            const tollfree = req.query.TF_PREFIX
            const qty = req.query.Qty;
            let options: any = {
                'method': 'POST',
                'url': 'https://devapi.coretel.net/cgi-bin/xmlnumberdb.pl',
                'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>VanitySearch</RequestType><Purpose>SIP</Purpose><Quantity>" + qty + "</Quantity><Tollfree>" + tollfree + "</Tollfree><BillingAccount>" + this.key + "</BillingAccount><Password>" + this.secret + "</Password></xml>",
                rejectUnauthorized: false,
                requestCert: true,
                agent: false
            };

            request(options, (error: any, response: any, body: any) => {
                if (!error) {
                    let tmp: string = body;
                    let valid_xml = tmp.slice(0, -6)
                    console.log(valid_xml);
                    var result1 = convert.xml2json(valid_xml, { compact: true, spaces: 4 });
                    var res1 = JSON.parse(result1);
                    let ddata = res1.xml.SearchResult;
                    console.log("Data==>", ddata);
                    if (ddata !== undefined && ddata.length > 0) {
                        let str: any = ddata;
                        let obj1 = new ModelRawNonQuery(req, res);
                        let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`) VALUE ";
                        str.forEach((ele: any) => {
                            console.log(ele.Number._text);
                            qrystr += "('','" + ele.Number._text + "', '', '', '" + ele.RateCenter._text + "', '', '', '', '' ,'" + "coreTel" + "', '" + this.account + "', '" + this.priority + "'),";
                        });
                        obj1.nonqrysql = qrystr.slice(0, -1);
                        obj1.prepare();
                        obj1.execute((err, data) => {
                            callback(err, data);
                        });
                    } else {
                        callback('', ddata);
                    }
                } else {
                    callback('', error);
                }
            });
        }
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        const qty = sdata.Qty;
        const did = sdata.DID;
        let options: any = {
            'method': 'POST',
            'url': 'https://numberdb.coretel.net/cgi-bin/xmlnumberdb.pl',
            'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>BlockRequest</RequestType><Purpose>SIP</Purpose><Quantity>" + qty + "</Quantity><DID>" + did + "</DID><BillingAccount>" + this.key + "</BillingAccount><Password>" + this.secret + "</Password></xml>",
            rejectUnauthorized: false,
            requestCert: true,
            agent: false
        };

        request(options, (error: any, response: any) => {
            if (error) {
                console.log("error", error);
            } else {
                console.log("response", response);
            }
        });
    }

    disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let options: any = {
            'method': 'POST',
            'url': 'https://devapi.coretel.net/cgi-bin/xmlnumberdb.pl',
            'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>BlockRequest</RequestType><Purpose>$xmlpurpose</Purpose><Quantity>$xmlqty</Quantity><Email>$xmlemail</Email><RateCenterAbbrev>$xmlrate_center_abbrev</RateCenterAbbrev><RateCenter>$xmlrate_center</RateCenter><NPA>$xmlnpa</NPA><SIP_MS_IP>$xmlgw_ip</SIP_MS_IP><SIP_Port>$xmlsip_port</SIP_Port><BillingAccount>$xmlaccount</BillingAccount><Password>$xmlpassword</Password><ForwardTo>$xmlfwdto</ForwardTo><RouteToURI>$xmlroute_to_uri</RouteToURI><SIP_URI>$xmlsip_uri</SIP_URI><EUPassword>$xmleupass</EUPassword><AdminPassword>$xmladminpass</AdminPassword><Expires>$xmlexpires</Expires><Duration>$xmlduration</Duration></xml>",
            rejectUnauthorized: false,
            requestCert: true,
            agent: false
        };

        request(options, (error: any, response: any, body: any) => {
            if (!error) {
                let tmp: string = body;
                let valid_xml = tmp.slice(0, -6)
                console.log(valid_xml);
                var result1 = convert.xml2json(valid_xml, { compact: true, spaces: 4 });
                var res1 = JSON.parse(result1);
                let ddata = res1.xml.SearchResult;
                console.log("Data==>", ddata);
                if (ddata !== undefined && ddata.length > 0) {
                    let str: any = ddata;
                    let obj1 = new ModelRawNonQuery(req, res);
                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`) VALUE ";
                    str.forEach((ele: any) => {
                        console.log(ele.Number._text);
                        qrystr += "('','" + ele.Number._text + "', '', '', '" + ele.RateCenter._text + "', '', '', '', '' ,'" + "coreTel" + "', '" + this.account + "', '" + this.priority + "'),";
                    });
                    obj1.nonqrysql = qrystr.slice(0, -1);
                    obj1.prepare();
                    obj1.execute((err, data) => {
                        callback(err, data);
                    });
                } else {
                    callback('', ddata);
                }
            } else {
                callback('', error);
            }
        });
    }

    MakeCall(req: Request, res: Response, next:NextFunction){}

    MakeOutboundCallToNumber(req: Request, res: Response, next:NextFunction){}

}
