import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { Number } from "./numberApi";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { OsrApi } from "./Osr";
import { SinchApi } from "./SinchSubmitNumber";
var request = require('request');

export class InteliquentAPI extends APIBase {
    private key: string;
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey: string;
    private URL: string;
    private privateKey: string;

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        // Production key
        // this.key = "eFluR1hOVERZZGY3dHc5Tno4dzFaemhtbFpnQzpEendnQjZCMVVKc2JwaUZxRXBieW9MODY0dFR3";

        //SandBox key
        this.key = "ZVFzdGdKaHZsa3UwMldLMDBzRnhDN3ZNVHdLTjo2ZllFSDlISklqVTFRWkJTODU3cXlVNXVaQldQ";

        //Production URL
        // this.URL = 'https://services.inteliquent.com/Services/1.0.0'

        //SandBox URL
        this.URL = 'https://services-sandbox.inteliquent.com/Services/1.0.0'

        //Production privateKey
        // this.privateKey = 'xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC'

        //SandBox privateKey
        this.privateKey = 'eQstgJhvlku02WK00sFxC7vMTwKN'


        this.timekey = timekey,
            this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }

    public rpad(name: any, size: number) {
        let ret = name;
        for (let i = name.length; i < size; i++)
            ret += "x";
        return ret;
    }

    public getNpaNxx(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    let obj = new ModelRawQuery(req, res);
                    let tnMask: any;
                    if (sdata.NXX == "null" || sdata.NXX == undefined) {
                        tnMask = this.rpad(sdata.NPA, 10);
                    }
                    if (sdata.NXX !== undefined && sdata.NXX !== 'null') {
                        tnMask = this.rpad(sdata.NPA + "" + sdata.NXX, 10);
                    }
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tnInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': this.privateKey,
                            "tnMask": tnMask,
                            "quantity": sdata.Qty
                        }),
                    };
                    request(options, (error: any, response: any) => {
                        let ddata = JSON.parse(response.body);
                        if (!error) {
                            if (ddata.statusCode == 200) {
                                if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                    let str = ddata.tnResult;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        qrystr += "('', '" + ele.telephoneNumber + "', '" + ele.lata + "', '', '" + ele.rateCenter + "', '" + ele.province + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + ele.city + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.rateCenterTier + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', ddata);
                                }
                            } else {
                                callback('', ddata);
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '')
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tnInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            'privateKey': this.privateKey,
                            "tnMask": "**********",
                            "tnWildcard": "***********",
                            "rateCenter": sdata.RateCenter,
                            "province": sdata.State,
                            "quantity": sdata.Qty
                        }),
                    };
                    request(options, (error: any, response: any) => {
                        let ddata = JSON.parse(response.body);
                        if (!error) {
                            if (ddata.statusCode == 200) {
                                if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                    let str = ddata.tnResult;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        qrystr += "('', '" + ele.telephoneNumber + "', '" + ele.lata + "', '', '" + ele.rateCenter + "', '" + ele.province + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + ele.city + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.rateCenterTier + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', ddata);
                                }
                            } else {
                                callback('', ddata);
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "VN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    let data1: any = req.query;
                    let cbody: any = '';
                    if (data1.quantity != '' && data1.tnMask1 != 'null') {
                        cbody = JSON.stringify({
                            "privateKey": this.privateKey,
                            "tnMask": data1.tnMask1 + data1.tnMask2 + data1.tnMask3,
                            "sequential": data1.sequential,
                            "quantity": data1.quantity
                        })
                    }
                    if (data1.wildcard != '' && data1.quantity != '') {
                        cbody = JSON.stringify({
                            "privateKey": this.privateKey,
                            "tnWildcard": data1.wildcard,
                            "sequential": data1.sequential,
                            "quantity": data1.quantity
                        });
                    }
                    var options = {
                        'method': 'POST',
                        'url': this.URL + '/tfInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key,
                        },
                        body: cbody
                    };
                    request(options, (error: any, response: any) => {
                        let ddata = JSON.parse(response.body);
                        if (!error) {
                            if (ddata.statusCode == 200) {
                                if (ddata.tfList.tfItem != undefined && ddata.tfList.tfItem.length > 0) {
                                    let str = ddata.tfList.tfItem;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        qrystr += "('', '" + ele.tn + "', '', '', '', '', '', '', '', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','" + "TF" + "','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', ddata);
                                }
                            } else {
                                callback('', ddata);
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public tfRequest(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.body.data;
        this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
            // To get the proration status
            let objv0 = new ModelRawNonQuery(req, res);
            objv0.nonqrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let dateObj = new Date();
                    let day = dateObj.getUTCDate();
                    let nDate: any = new Date()
                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                    let totalDays = (lDate - day) + 1;
                    let prorate: any;
                    if (proration_success[0].proration == "true")
                        prorate = (totalDays * voice_rate[0].rate) / lDate;
                    else
                        prorate = voice_rate[0].rate;
                    
                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0

                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + this.sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + prorate * sdata.cdata.Qty + "'"
                    obj1.prepare();
                    obj1.execute((walletError: any, wallet: any) => {
                        if (walletError == 1 && wallet.length > 0) {
                            let privateKey = this.privateKey;
                            let customerOrderReference = "b1f86e6a5e0d";
                            let respOrgId = "LQX01";
                            let routingLabel = "NTDAL-4927-8XX-950";
                            const formattedDate = new Date(new Date().getTime() + (4 * 24 * 60 * 60 * 1000)).toISOString().split('T')[0];
                            var options = {
                                'method': 'POST',
                                'url': this.URL + '/tfRequest',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + this.key,
                                },
                                body: JSON.stringify({
                                    "privateKey": privateKey,
                                    "customerOrderReference": customerOrderReference,
                                    "desiredDueDate": formattedDate,
                                    "quantity": sdata.cdata.Qty,
                                    "respOrgId": respOrgId,
                                    "routingLabel": routingLabel
                                })
                            };
                            request(options, (error: any, response: any) => {
                                let sdata1 = JSON.parse(response.body);
                                if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                    
                                    let objv6 = new ModelRawNonQuery(req, res);
                                    objv6.nonqrysql = "INSERT INTO `tollfree_request` (`iduser`, `idaccount`, `privateKey`, `customerOrderReference`,`desiredDueDate`,`respOrgId`,`routingLabel`,`status`,`statusCode`,`orderId`,`quantity`,`order_status`,`rates`,`pro_rates`,`type`,`id_grouporder`) VALUE('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + privateKey + "','" + customerOrderReference + "','','" + respOrgId + "','routingLabel','" + sdata1.status + "','" + sdata1.statusCode + "','" + sdata1.orderId + "','" + sdata.cdata.Qty + "','0','" + voice_rate[0].rate + "','" + prorate + "','TF','" + sdata.groupId + "')";
                                    objv6.prepare();
                                    objv6.execute((tol_error, tf_req) => {
                                        if (tol_error == 1) {
                                            // To update the wallet amount
                                            let objv = new ModelRawNonQuery(req, res);

                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate * sdata.cdata.Qty + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                                // To update the wallet transaction log
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                iQry += "`amount`='-" + prorate * sdata.cdata.Qty + "', "
                                                iQry += "`purpose`='Wallet amount successfully updated for new DIDs', "
                                                iQry += "`status`=1;"

                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    if (error == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 200, message: "Your Order will take 3 to 4 Business Days.Your Order ID is: (" + sdata1.orderId + ")", data: result });
                                                        objv.execute();
                                                    } else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 404, message: "Order is not Placed!" });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let obj = new RawView(res);
                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with connection!" });
                                            obj.execute()
                                        }
                                    });
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error_code: 0,
                                error: wallet,
                                message: "Please add funds to your account or contact support.",
                                status: 503
                            });
                            objv.execute();
                        }
                    });
                } else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let id_grouporder: number = other_data.id_grouporder;

        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''

            // To get the proration status
            let objv0 = new ModelRawNonQuery(req, res);
            objv0.nonqrysql = "SELECT t.proration FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let proration_status = proration_success[0].proration;
                    // To purchase the toll free number
                    if (did_details[0].type == "TF") {
                        var options = {
                            'method': 'POST',
                            'url': this.URL + '/tfOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "privateKey": this.privateKey,
                                "productAbbr": "8XXAVAIL",
                                "tfOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "resporgId": "ABC45",
                                                "routingLabel": "NTDAL-4927-8XX-950",
                                                "trunkGroup": "CHCGIL24IPL_4649"
                                            }
                                        ]
                                    }
                                }
                            })
                        }
                        request(options, (error: any, response: any) => {
                            let sdata1 = JSON.parse(response.body);
                            if (!error) {
                                //If order success
                                if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                    let dateObj = new Date();
                                    let day = dateObj.getUTCDate();

                                    let nDate: any = new Date()
                                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                    let totalDays = (lDate - day) + 1;

                                    let prorate: any;
                                    if (proration_status == "true") {
                                        prorate = (totalDays * did_details[0].rates) / lDate;
                                    }
                                    else {
                                        prorate = did_details[0].rates;
                                    }

                                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0

                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            // update end subscription date
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                            obj0.prepare();
                                            obj0.execute((dids_err, didRes) => {
                                                let dates = didRes[0].subscription_end_date;
                                                let isoDate = new Date(dates);
                                                let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                let obj01 = new ModelRawNonQuery(req, res);
                                                obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                obj01.prepare();
                                                obj01.execute((error, result) => { })
                                            })


                                            // To update the wallet amount
                                            let objv = new ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {

                                                // To update the wallet transaction log
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                iQry += "`amount`='-" + prorate + "', "
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                iQry += "`status`=1;"

                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    console.log("Transaction response::", result)
                                                })

                                                // To create the DID log
                                                let objv1 = new ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "','1','DID Buy')"
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });

                                                // To delete the DID from cart
                                                let obj5 = new ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                obj5.prepare();
                                                obj5.execute((walletError: any, wallet: any) => { });

                                                // To create the did_order
                                                let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order: number = did_data.insertId
                                                        let orderID: string = "SORD" + id_order.toString()

                                                        let log_error: string = ""
                                                        let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                        let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                        obj.prepare();
                                                        obj.execute((error, result) => { })
                                                    }
                                                });
                                                // Leave the successfull output
                                                let objV = new RawView(res);
                                                objV.prepare({ error_code: 1, status: 201, message: "DID buy successfully.", result: [{ "did": sdata.DID.trim() }] });
                                                objV.execute()

                                            });
                                        }
                                        else {
                                            let obj = new RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute()
                                        }
                                    });
                                }

                                // If order failed
                                else {
                                    // To delete the DID from cart
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                    obj5.prepare();
                                    obj5.execute((walletError: any, wallet: any) => { });

                                    let I1: any = sdata1.status.indexOf("Waiting on internal port")
                                    let I2: any = sdata1.status.indexOf("TN is on a pending order")
                                    let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                    let obj = new ModelRawNonQuery(req, res);

                                    // It will check, if order goes into pending
                                    if (I1 > -1 || I2 > -1) {
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`, `ordConf`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "', '0')";
                                    }
                                    else {
                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                    }

                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order: number = did_data.insertId
                                            let orderID: string = "SORD" + id_order.toString()

                                            let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_result: string = ""

                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                            obj.prepare();
                                            obj.execute((error, result) => { })
                                        }
                                    });

                                    let objV = new RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: sdata1.statusCode,
                                        message: sdata1.status
                                    });
                                    objV.execute()
                                }
                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({ status: 400, error: error });
                                obj.execute()
                            }
                        });
                    }

                    // To purchase the local number
                    else {
                        var options = {
                            'method': 'POST',
                            'url': this.URL + '/tnOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + this.key
                            },
                            body: JSON.stringify({
                                "privateKey": this.privateKey,
                                "tnOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "trunkGroup": "CHCGIL24IPL_4648"
                                            }
                                        ]
                                    }
                                }
                            })
                        }
                        request(options, (error: any, response: any) => {
                            let sdata1 = JSON.parse(response.body);
                            if (!error) {
                                // If order success
                                if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                    let dateObj = new Date();
                                    let day = dateObj.getUTCDate();

                                    let nDate: any = new Date()
                                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                    let totalDays = (lDate - day) + 1;

                                    let prorate: any;
                                    if (proration_status == "true") {
                                        prorate = (totalDays * did_details[0].rates) / lDate;
                                    }
                                    else {
                                        prorate = did_details[0].rates;
                                    }
                                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`pro_rates`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "','" + prorate + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            // update end subscription date
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                            obj0.prepare();
                                            obj0.execute((dids_err, didRes) => {
                                                let dates = didRes[0].subscription_end_date;
                                                let isoDate = new Date(dates);
                                                let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                let obj01 = new ModelRawNonQuery(req, res);
                                                obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                obj01.prepare();
                                                obj01.execute((error, result) => { })
                                            })



                                            // To update the wallet amount
                                            let objv = new ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {

                                                // To update the wallet transaction log
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                iQry += "`amount`='-" + prorate + "', "
                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                iQry += "`status`=1;"

                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    console.log("Transaction response::", result)
                                                })

                                                // To create the DID log
                                                let objv1 = new ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`) VALUE('" + this.sessdata.idaccount + "','','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "','1','DID Buy')"
                                                objv1.prepare();
                                                objv1.execute((log_error, did_log) => { });

                                                // To delete the DID from cart
                                                let obj5 = new ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                obj5.prepare();
                                                obj5.execute((walletError: any, wallet: any) => { });

                                                // To create the did_order
                                                let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order: number = did_data.insertId
                                                        let orderID: string = "SORD" + id_order.toString()

                                                        let log_error: string = ""
                                                        let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                        let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                        obj.prepare();
                                                        obj.execute((error, result) => { })
                                                    }
                                                });

                                                // To submit the number on OSR
                                                if (sdata.CampaignId) {
                                                    let osr = new OsrApi(this.priority, this.sessdata)
                                                    osr.updateNumber(req, res, data.insertId, (error, responce) => { })
                                                }
                                                else {
                                                    let obj = new RawView(res);
                                                    obj.prepare({
                                                        error_code: 1,
                                                        status: 201,
                                                        message: "DID buy successfully.",
                                                        result: [
                                                            {
                                                                "did": sdata.DID.trim()
                                                            }
                                                        ]
                                                    });
                                                    obj.execute()
                                                }
                                            });
                                        }
                                        else {
                                            let obj = new RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute()
                                        }
                                    });
                                }

                                // If order failed
                                else {
                                    // To delete the DID from cart
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                    obj5.prepare();
                                    obj5.execute((walletError: any, wallet: any) => { });

                                    let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '2', 'NN', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order: number = did_data.insertId
                                            let orderID: string = "SORD" + id_order.toString()

                                            let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_result: string = ""

                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                            obj.prepare();
                                            obj.execute((error, result) => { })
                                        }
                                    });

                                    let objV = new RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: sdata1.statusCode,
                                        message: sdata1.status
                                    });
                                    objV.execute()
                                }
                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 400,
                                    error: error
                                });
                                obj.execute()
                            }
                        });
                    }
                }
                else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }

    disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let iduser: number = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `day_num` from `tariff` WHERE `idtariff`='" + this.sessdata.idtariff + "'";
        obj1.prepare();
        obj1.execute((errday: any, resday: any) => {
            if (errday == 1 && resday.length > 0) {
                let number = new Number();
                number.countDays(req, res, sdata.DID.trim(), (err: any, countdays: any) => {
                    if (countdays && countdays > resday[0].day_num) {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `type` from `did_buy` WHERE `iduser`='" + iduser + "' AND `did`='" + sdata.DID.trim() + "'";
                        obj2.prepare();
                        obj2.execute((err: any, resu: any) => {
                            if (resu.length > 0) {
                                // To release the toll-free number
                                if (resu[0].type == "TF") {
                                    var options = {
                                        'method': 'POST',
                                        'url': this.URL + '/tfDisconnect',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + this.key
                                        },
                                        body: JSON.stringify({
                                            "privateKey": this.privateKey,
                                            "tnList": {
                                                "tnItem": [
                                                    {
                                                        "tn": sdata.DID.trim()
                                                    }
                                                ]
                                            }
                                        })
                                    };
                                    request(options, (error: any, response: any) => {
                                        if (!error) {
                                            let data = JSON.parse(response.body);
                                            if (data.status == 'Success') {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                                obj.prepare();
                                                obj.execute((error: any, resp: any) => {
                                                    if (error == 1) {
                                                        // To  update updated_at date in did log
                                                        let obj = new ModelRawNonQuery(req, res);
                                                        //obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                                        obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "')"
                                                        obj.prepare();
                                                        obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                                        // To delete the number from OSR

                                                        let payLoad: any = {
                                                            DID: sdata.DID.trim()
                                                        }
                                                        let osr = new OsrApi(this.priority, this.sessdata)
                                                        osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                            if (error == 1) {
                                                                // To delete the number from Sinch
                                                                let osr = new SinchApi(this.priority, this.sessdata)
                                                                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                                })
                                                            }
                                                        })

                                                        // To release the final output
                                                        let objv = new RawView(res)
                                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                        objv.execute();
                                                    }
                                                })
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: data.statusCode, message: data.status });
                                                objv.execute()
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 400, error: error });
                                            objv.execute()
                                        }
                                    });
                                }

                                // To release the local number
                                else {
                                    var options = {
                                        'method': 'POST',
                                        'url': this.URL + '/tnDisconnect',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + this.key
                                        },
                                        body: JSON.stringify({
                                            "privateKey": this.privateKey,
                                            "tnList": {
                                                "tnItem": [
                                                    {
                                                        "tn": sdata.DID.trim()
                                                    }
                                                ]
                                            }
                                        })
                                    };
                                    request(options, (error: any, response: any) => {
                                        if (!error) {
                                            let data = JSON.parse(response.body);
                                            if (data.status == 'Success' || data.statusCode=='425') {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                                                obj.prepare();
                                                obj.execute((error: any, resp: any) => {
                                                    if (error == 1) {
                                                        // To  update updated_at date in did log
                                                        let obj = new ModelRawNonQuery(req, res);
                                                        //obj.nonqrysql = "UPDATE `did_log` SET `event_type`='5',`description`='DID Disconnected Successfully from Intelliquent',`updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                                        obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','DID Disconnected Successfully','" + sdata.DID.trim() + "')"
                                                        obj.prepare();
                                                        obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                                        // To delete the number from OSR
                                                        let payLoad: any = {
                                                            DID: sdata.DID.trim()
                                                        }
                                                        let osr = new OsrApi(this.priority, this.sessdata)
                                                        osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                            if (error == 1) {
                                                                // To delete the number from Sinch
                                                                let osr = new SinchApi(this.priority, this.sessdata)
                                                                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                                })
                                                            }
                                                        })

                                                        // To release the final output
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                                        objv.execute()
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Something Went Wrong" });
                                                        objv.execute();
                                                    }
                                                })
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: data.statusCode, message: data.status });
                                                objv.execute()
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 400, error: error });
                                            objv.execute()
                                        }
                                    });
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute()
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 417, message: "Days are Less then " + resday[0].day_num + " So you can not disconnect Did from this Account" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Days Not Found!" });
                objv.execute();
            }
        });
    }

}