import { SMS } from "./APISMSBase";
import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { Number } from "./numberApi";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { LergApi } from "./lrnApi";

export class SinchSMS extends SMS {
    constructor() {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5"
    }


    public SendSms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let lergData: any = Data.lergData

        // To set the data for final SMS
        this.saveSMS(req, res, next, sessdata, lergData, sms_provider, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }

    public SendMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let lergData: any = Data.lergData
        let didData: any = Data.DIDdata
        let fType: any = Data.fileType

        // To set the data for final SMS
        this.saveMMS(req, res, next, sessdata, lergData, sms_provider, didData, fType, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }

    /* public SendMms(req: Request, res: Response, next: NextFunction,token: string,sms_provider: string, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let number = new Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ "message": "Invalid DID" });
                        obj.execute();
                    } else {
                        let PayLoad: any = {
                            TO: TO
                        }
                        let lerg = new LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {

                                if (lerg_info.length > 0) {
                                    this.saveMMS(req, res, next, sessdata, lerg_info,sms_provider, (sms_err, sms_result) => {
                                        if (sms_result != undefined) {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_result);
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_err);
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({message:"Lerg Info Not Found"});
                                    objv.execute();
                                }
                            })
                        })
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    } */

    public SendSms_Old(req: Request, res: Response, next: NextFunction, token: string, sms_provider: string, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let number = new Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    } else {
                        let lerg = new LergApi("", "");
                        lerg.lrnDetails(req, res, token, (lrn_err, lrn_detail) => {
                            console.log(lrn_err, lrn_detail);
                            if (lrn_detail.hasOwnProperty('errors')) {
                                if (lrn_detail.errors[0] == "LRN Not Found.")
                                    this.getLrnDetails(req, res, TO, (lerg_err, lerg_info) => {
                                        if (lerg_info.data.length > 0) {
                                            this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider, (sms_err, sms_result) => {
                                                if (sms_result != undefined) {
                                                    let objv = new RawView(res);
                                                    objv.prepare(sms_result);
                                                    objv.execute();
                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare(sms_err);
                                                    objv.execute();
                                                }
                                            })
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Lerg Info Not Found" });
                                            objv.execute();
                                        }
                                    })
                            } else {
                                this.getLrnDetails(req, res, lrn_detail.lnp, (lerg_err, lerg_info) => {
                                    console.log(lerg_err, lerg_info);
                                    if (lerg_info.data.length > 0) {
                                        this.saveSMS(req, res, next, sessdata, lerg_info.data, sms_provider, (sms_err, sms_result) => {
                                            if (sms_result != undefined) {
                                                let objv = new RawView(res);
                                                objv.prepare(sms_result);
                                                objv.execute();
                                            } else {
                                                console.log("lerg not found");
                                                let objv = new RawView(res);
                                                objv.prepare(sms_err);
                                                objv.execute();
                                            }
                                        })
                                    } else {
                                        console.log("lerg not found");
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Lerg Info Not Found" });
                                        objv.execute();
                                    }
                                })
                            }
                        });
                    }
                });
            } else {
                console.log("sesserror");
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}