import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SinchNumberRegistry } from "../include/sinchNumberRegistry";
import { RawView } from "../lib/view/RawView";
import { ModelRawQuery } from "../lib/model/RawQuery";
let request = require('request');
const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
const projectId = "bd6ca3f8-040c-4b40-ba6c-09f8d63be111";
const servicePlanId = "IP_LINK_RA";
const userId = "f0c489dd-2203-4dc9-964a-c59021b9ee74";
const passwd = "Ew6Ynk~ddXD2UqmoHxWywDczB_";
const myip = "iplink";
const nnid = "104141";

export class SinchApi extends SinchNumberRegistry {
    constructor(proirity: string, sessdata: any) {
        super(proirity, sessdata);
    }


    /**
     * To Add entry into Sinch :: first method
     */
    public submitNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        var dataString = '{"phone_number":' + number1 + ', "projectId":' + projectId + ', "region_code":"US", "smsConfiguration":{"servicePlanId":' + servicePlanId + ', "campaignId":' + sdata.CampaignId + '}}';
        var options = {
            url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers',
            method: 'POST',
            headers: headers,
            body: dataString,
            auth: {
                'user': userId,
                'pass': passwd
            }
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                let data = JSON.parse(response.body);
                if (data.status == "WAITING") {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = 'register' where `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                    obj.prepare();
                    obj.execute((err, resp) => {
                        if (resp) {
                            let obj = new RawView(res);
                            obj.prepare({});
                            obj.execute()
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ "error": "Query Error", "err": err });
                            obj.execute()
                        }
                    })
                } else if (data.status == "FAILED") {
                    this.updateNumber(req, res, (err, res) => {
                        if (res) {

                        } else {

                        }
                    })
                }
            } else {
                callback(error, "");
            }
        });
    }


    /**
     * To Update entry into Sinch :: first method
     */
    public updateNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        var dataString = '{"phone_number":"' + number1 + '", "projectId":"' + projectId + '", "region_code":"US", "smsConfiguration":{"servicePlanId":"' + servicePlanId + '", "campaignId":"' + sdata.CampaignId + '"}}';
        var options = {
            url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/' + number1,
            method: 'PATCH',
            headers: headers,
            body: dataString,
            auth: {
                'user': userId,
                'pass': passwd
            }
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                let data = JSON.parse(response.body);
                if (data.status == "WAITING") {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = 'register' where `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                    obj.prepare();
                    obj.execute((err, resp) => {
                        if (resp) {
                            let obj = new RawView(res);
                            obj.prepare({});
                            obj.execute()
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ "error": "Query Error", "err": err });
                            obj.execute()
                        }
                    })
                }
            } else {
                callback(error, "");
            }
        });
    }


    /**
     * To Delete entry from Sinch  :: first method
     */
    public deleteNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.query;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let iduser: any = '';
        if (sdata.iduser) {
            iduser = sdata.iduser;
        } else {
            iduser = this.sessdata.iduser;
        }
        /* let number1 = "1" + number; */
        // let obj0 = new ModelRawQuery(req, res);
        // obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `iduser` = '" + this.sessdata.iduser + "'";
        // obj0.prepare();
        // obj0.execute((err: any, result_did: any) => {
        // if (err == 1 && result_did.length > 0) {
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        var options = {
            /* url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/' + number1, */
            url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/+1' + number,
            method: 'DELETE',
            headers: headers,
            auth: {
                'user': userId,
                'pass': passwd
            }
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                let data = JSON.parse(response.body);
                if (Object.keys(data).length == 0) {

                    // here in this query we are using session iduser and id account for the understanding who is performed this action.
                    let obj4 = new ModelRawNonQuery(req, res);
                    obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'11','DID disconnect From SINCH','" + number.trim() + "')";
                    obj4.prepare();
                    obj4.execute((errLog, resLog) => {
                        console.log("SMS Disabled Successfully From SINCH");
                    });

                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '0' WHERE iduser = '" + iduser + "' AND `did`='" + number + "'";
                    obj1.prepare();
                    obj1.execute((err, resp) => {
                        if (err == 1) {
                            let obj = new RawView(res);
                            obj.prepare({ status: 202, message: "SMS facility has been successfully disabled." });
                            obj.execute();
                        }
                        else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 502, message: "DID Disabled Successfully But Something Went Wrong With Data Update!" });
                            obj.execute()
                        }
                    });
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed from SINCH','" + number.trim() + "')";
                    obj2.prepare();
                    obj2.execute((errLog, resLog) => {
                        console.log("SMS Disabled failed from SINCH");
                        callback('', data);
                    });
                }
            } else {
                callback(error, '');
            }
        });
        //     }
        //     else {
        //         let objv = new RawView(res);
        //         objv.prepare({ status: 502, message: 'DID Not Available!' });
        //         objv.execute()
        //     }
        // });
    }
    // public deleteNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
    //     let sdata: any = req.query;
    //     let did = sdata.DID;
    //     let len = did.length - 10;
    //     let number = did.slice(len, did.length);
    //     let number1 = "1" + number;
    //     let obj0 = new ModelRawQuery(req, res);
    //     obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `iduser` = '" + this.sessdata.iduser + "'";
    //     obj0.prepare();
    //     obj0.execute((err: any, result_did: any) => {
    //         if (err == 1 && result_did.length > 0) {
    //             let obj00 = new ModelRawQuery(req, res);
    //             obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name FROM `campaign` WHERE `iduser`='" + this.sessdata.iduser + "' AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
    //             obj00.prepare();
    //             obj00.execute((err: any, result_camp: any) => {
    //                 if (err == 1 && result_camp.length > 0) {
    //                     let obj00 = new ModelRawQuery(req, res);
    //                     obj00.qrysql = "SELECT `iddidlog` FROM did_log WHERE `did`= '" + sdata.DID.trim() + "' AND `iduser` = '" + this.sessdata.iduser + "' ORDER BY `iddidlog` DESC";
    //                     obj00.prepare();
    //                     obj00.execute((log_error: any, log_res: any) => {
    //                         if (log_error == 1 && log_res.length > 0) {
    //                             var headers = {
    //                                 'accept': '*/*',
    //                                 'Accept': 'application/json'
    //                             };
    //                             var options = {
    //                                 url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/' + number1,
    //                                 method: 'GET',
    //                                 headers: headers,
    //                                 auth: {
    //                                     'user': userId,
    //                                     'pass': passwd
    //                                 }
    //                             };
    //                             request(options, (error: any, response: any) => {
    //                                 if (!error) {
    //                                     let data = JSON.parse(response.body);
    //                                     if (data.status == 200) {
    //                                         let obj1 = new ModelRawNonQuery(req, res);
    //                                         obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '0',`camp_registry` = '' WHERE iduser = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
    //                                         obj1.prepare();
    //                                         obj1.execute((err, resp) => {
    //                                             let obj2 = new ModelRawNonQuery(req, res);
    //                                             obj2.nonqrysql = "INSERT INTO `campaign_history`(`iduser`,`idaccount`,`did`,`campaign_key`,`campaign_name`,`in_use`,`iddidlog`) VALUES ('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + number + "','" + result_camp[0].campaign_key + "','" + result_camp[0].campaign_name + "', '1','" + log_res[0].iddidlog + "')";
    //                                             obj2.prepare();
    //                                             obj2.execute((err, resp) => {
    //                                                 if (err == 1) {
    //                                                     let obj = new RawView(res);
    //                                                     obj.prepare({ status: 202, message: "DID Successfully Disabled." });
    //                                                     obj.execute();
    //                                                 }
    //                                                 else {
    //                                                     let obj = new RawView(res);
    //                                                     obj.prepare({ status: 502, message: "DID Disabled Successfully But Something Went Wrong With Data Update!" });
    //                                                     obj.execute()
    //                                                 }
    //                                             });
    //                                         });
    //                                     } else {
    //                                         callback('', data);
    //                                     }
    //                                 } else {
    //                                     callback(error, '');
    //                                 }
    //                             });
    //                         } else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ status: 404, message: `ID DID not found on this DID!` });
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ status: 502, message: 'Campaign Registry Does not Match!' });
    //                     objv.execute()
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ status: 502, message: 'DID Not Available!' });
    //             objv.execute()
    //         }
    //     });
    // }


    /**
     * To Update entry with toll-free provisioning into Sinch :: first method
     */
    public updateNumberWithTollfree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let options = {
            'method': 'PUT',
            'url': 'https://208.254.45.98/osr/v2/entries/1800551212',
            'headers': {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ "id": "mypid", "nnid": "123456", "context": "A2P", "ownertspid": "3434" })
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                let ddata = JSON.parse(response.body);
                if (ddata.rows.length > 0) {
                } else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.prepare();
                    obj.execute((err, data) => {
                        callback(err, data);
                    });
                }
            } else {
                let obj = new ModelRawNonQuery(req, res);
                obj.prepare();
                obj.execute((err, data) => {
                    callback(err, data);
                });
            }
        });
    }


    /**
     * To retrieve entry from Sinch :: first method
     */
    public retrieveOsrEntry(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.query;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "1" + number;
        let options = {
            'method': 'GET',
            'url': produrl + "" + number1 + "?id=" + myip,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        console.log("options", options);
        request(options, (error: any, response: any) => {
            if (!error) {
                let data = JSON.parse(response.body);
                callback('', data);
            } else {
                callback(error, '');
            }
        });
    }


    /**
     * To Delete entry from Sinch :: second method
     */
    public deleteNumberM2(req: Request, res: Response, payLoad: any, callback: (err: any, data: any) => void) {
        let did = payLoad.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        //let number1 = "1" + number;
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        var options = {
            url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/+1' + number,
            method: 'DELETE',
            headers: headers,
            auth: {
                'user': userId,
                'pass': passwd
            }
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                let data = JSON.parse(response.body);
                if (Object.keys(data).length == 0) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0', `disconnect_did_status`='0' WHERE iduser='" + this.sessdata.iduser + "' AND `did`='" + number + "';";
                    obj.prepare();
                    obj.execute((err, resp) => {
                        if (err == 1) {
                            callback(1, resp)
                        }
                        else {
                            callback(0, err)
                        }
                    })
                }
                else {
                    callback(0, data)
                }
            }
            else {
                callback(0, error)
            }
        });
    }

    public EnableSMSFromSinch(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let iduser: any = sdata.iduser ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = sdata.idaccount ? sdata.idaccount : this.sessdata.idaccount;
        let obj0 = new ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `iduser` = '" + iduser + "'";
        obj0.prepare();
        obj0.execute((err: any, result_did: any) => {
            if (err == 1 && result_did.length > 0) {
                var options = {
                    'method': 'POST',
                    'url': 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ZjBjNDg5ZGQtMjIwMy00ZGM5LTk2NGEtYzU5MDIxYjllZTc0OkV3Nllua35kZFhEMlVxbW9IeFd5d0RjekJf'
                    },
                    body: JSON.stringify({
                        "phone_number": "+1" + number,
                        "projectId": projectId,
                        "region_code": "US",
                        "smsConfiguration": {
                            "servicePlanId": "IP_LINK_RA",
                            "campaignId": result_did[0].camp_registry
                        }
                    })
                };
                request(options, (error: any, response: any) => {
                    if (!error) {
                        let data = JSON.parse(response.body);
                        if (data.smsConfiguration) {
                            if (data.smsConfiguration.scheduledProvisioning == "") {

                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','1')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => { });

                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='1' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                                obj1.prepare();
                                obj1.execute((err1, resp1) => {
                                    console.log("SMS enabled successfully!");
                                    callback(1, { status: 200, message: "SMS enabled successfully!" });
                                });
                            }
                            else {
                                if (data.smsConfiguration.scheduledProvisioning.status == "WAITING") {
                                    let obj4 = new ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','2')";
                                    obj4.prepare();
                                    obj4.execute((err4, resp4) => { });
                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='2' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                                    obj2.prepare();
                                    obj2.execute((err2, resp2) => {
                                        console.log("DID provisioned to SINCH.");
                                        callback(1, { status: 200, message: "DID provisioned to SINCH!" });
                                    });

                                } else {
                                    let obj4 = new ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','3')";
                                    obj4.prepare();
                                    obj4.execute((err4, resp4) => { });
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='3' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                                    obj3.prepare();
                                    obj3.execute((err3, resp3) => {
                                        console.log("DID not provisioned to SINCH!");
                                        callback(1, { status: 200, message: "DID not provisioned to SINCH!" });
                                    });
                                }
                            }

                        } else {
                            if (data.error) {
                                if (data.error.status === "ALREADY_EXISTS") {
                                    let obj6 = new ModelRawNonQuery(req, res);
                                    obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7',' DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','4')";
                                    obj6.prepare();
                                    obj6.execute((err6, resp6) => { });
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='4' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                                    obj5.prepare();
                                    obj5.execute((err5, resp5) => {
                                        console.log("ImportedNumber Already Exists on Sinch.")
                                        callback(0, { status: 200, message: "ImportedNumber Already Exists on Sinch" });
                                    });
                                } else {
                                    let obj8 = new ModelRawNonQuery(req, res);
                                    obj8.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'13','SINCH provisioning failed','" + number.trim() + "','" + sdata.CampaignId + "','5')";
                                    obj8.prepare();
                                    obj8.execute((err8, resp8) => { });
                                    let obj7 = new ModelRawNonQuery(req, res);
                                    obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='5' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                                    obj7.prepare();
                                    obj7.execute((err7, resp7) => {
                                        console.log("Imported Number Does Not Exists on Sinch!");
                                        callback(0, { status: 200, message: "Imported Number Does Not Exists on Sinch!" });
                                    });
                                }
                            }
                        }
                    } else {
                        callback(error, '');
                    }
                });
            }
        })
    }

    public reProvisioningToSinch(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let iduser: any = sdata.iduser ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = sdata.idaccount ? sdata.idaccount : this.sessdata.idaccount;
        let sinchStatus: any = sdata.sinchStatus;

        var options = {
            'method': 'PATCH',
            'url': 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/+1' + number,
            'headers': {
                'Content-Type': 'application/json',
                'projectId': projectId,
                'Authorization': 'Basic ZjBjNDg5ZGQtMjIwMy00ZGM5LTk2NGEtYzU5MDIxYjllZTc0OkV3Nllua35kZFhEMlVxbW9IeFd5d0RjekJf'
            },
            body: JSON.stringify({
                "smsConfiguration": {
                    "servicePlanId": servicePlanId,
                    "campaignId": sdata.CampaignId
                }
            })
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                let data = JSON.parse(response.body);
                if (data.smsConfiguration) {

                    let objj = new ModelRawNonQuery(req, res);
                    objj.nonqrysql = "UPDATE `did_buy` SET `sinch_retry`=`sinch_retry`+1 WHERE `did` ='" + number + "' AND `disconnect_did_status`=1";
                    objj.prepare();
                    objj.execute((err1, resp1) => {
                        console.log("sinch_retry updated");
                    });

                    if (data.smsConfiguration.scheduledProvisioning == "") {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='1' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                        obj1.prepare();
                        obj1.execute((err1, resp1) => {
                            console.log("DID Buy Inserted with Sinch Status =>", 1, sdata.CampaignId);
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "Re-Provisioning successfully!" });
                            objv.execute();
                        });

                        let obj4 = new ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '1')";
                        obj4.prepare();
                        obj4.execute((err4, resp4) => {
                            console.log("DID Log Inserted with Sinch Status =>", 1, sdata.CampaignId);
                        });

                    }
                    else {

                        if (data.smsConfiguration.scheduledProvisioning.status == "WAITING") {
                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`= '2' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                            obj2.prepare();
                            obj2.execute((err2, resp2) => {
                                console.log("DID Buy Inserted with Sinch Status =>", 2, sdata.CampaignId);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Provisioning Waiting!" });
                                objv.execute();
                            });

                            let obj4 = new ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '2')";
                            obj4.prepare();
                            obj4.execute((err4, resp4) => {
                                console.log("DID Log Inserted with Sinch Status =>", 2, sdata.CampaignId);
                            });
                        }
                        else {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='3' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                            obj3.prepare();
                            obj3.execute((err3, resp3) => {
                                console.log("DID Buy Inserted with Sinch Status =>", 3, sdata.CampaignId);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Provisioning Inprogress!" });
                                objv.execute();
                            });

                            let obj4 = new ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '3')";
                            obj4.prepare();
                            obj4.execute((err4, resp4) => {
                                console.log("DID Log Inserted with Sinch Status =>", 3, sdata.CampaignId);
                            });
                        }
                    }
                } else {
                    if (data.error) {

                        let objj = new ModelRawNonQuery(req, res);
                        objj.nonqrysql = "UPDATE `did_buy` SET `sinch_retry`=`sinch_retry`+1 WHERE `did` ='" + number + "' AND `disconnect_did_status`=1";
                        objj.prepare();
                        objj.execute((err1, resp1) => {
                            console.log("sinch_retry updated");
                        });

                        if (data.error.status == "ALREADY_EXISTS") {
                            let obj5 = new ModelRawNonQuery(req, res);
                            obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='4' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                            obj5.prepare();
                            obj5.execute((err5, resp5) => {
                                console.log("DID Buy Inserted with Sinch Status =>", 4, sdata.CampaignId);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Provisioning Already Exist!" });
                                objv.execute();
                            });

                            let obj6 = new ModelRawNonQuery(req, res);
                            obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '" + sinchStatus + "')";
                            obj6.prepare();
                            obj6.execute((err6, resp6) => {
                                console.log("DID Log Inserted with Sinch Status =>", 4, sdata.CampaignId);
                            });

                        }
                        else {
                            let obj7 = new ModelRawNonQuery(req, res);
                            obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='5' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                            obj7.prepare();
                            obj7.execute((err7, resp7) => {
                                console.log("DID Buy Inserted with Sinch Status =>", 5, sdata.CampaignId);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Provisioning Failed!" });
                                objv.execute();
                            });

                            let obj8 = new ModelRawNonQuery(req, res);
                            obj8.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'13','SINCH provisioning failed','" + number.trim() + "','" + sdata.CampaignId + "', '5')";
                            obj8.prepare();
                            obj8.execute((err8, resp8) => {
                                console.log("DID Log Inserted with Sinch Status =>", 5, sdata.CampaignId);
                            });
                        }
                    }
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Provisioning Not Successful!" });
                objv.execute();
            }
        });
    }
}