import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { CSPApiConfig, KYCPDF } from "../config/setting.config";
const request = require("request");
import checkDesc from "./markError";
const cspSetting = new CSPApiConfig();
const kycpdf = new KYCPDF();
const authKey = cspSetting.AUTHKEY;
const apiUrl = cspSetting.APIURL;

export class Kyc extends AppRoute {
    constructor() {
        super();
    }

    public getQuestion(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `id`,`question`,`click_yes`,`yes_to_continue`,`question_description`,`sub_question`,`service_type`,`question_type`,`customer_type` FROM `kyc_question`";
                obj0.prepare();
                obj0.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            status: 200
                        });
                        objv.execute();
                    }
                })
            }
        });
    }
    public addKyc(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let formType: any;
                let QuesId: any = '';
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `kyc_verify_status` FROM `user` WHERE `iduser`='" + sessdata.iduser + "'";
                obj0.prepare();
                obj0.execute((_error: any, result: any) => {
                    if (result[0].kyc_verify_status == '2' || result[0].kyc_verify_status == '3') {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "DELETE FROM `know_your_customer` WHERE `iduser`='" + sessdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((derror: any, allcamp: any) => {
                            if (derror == 1) {
                                let obj = new ModelRawNonQuery(req, res);
                                let Qry: any = "INSERT INTO `know_your_customer`(`iduser`,`idaccount`, `key`,`value`, `form_type`,`user_type`,`question_id`) VALUES ";
                                sdata.forEach((element: any, index: any) => {
                                    if (element.formType) {
                                        formType = element.formType;
                                    }
                                    // console.log("formType",formType);
                                    Object.entries(element).forEach(([key, value]) => {
                                        // console.log(key +":"+ value);
                                        if (key !== 'formType') {
                                            if (formType == 'messageService' || formType == 'voiceService') {
                                                let dataArray = key.split("_");
                                                QuesId = dataArray[dataArray.length - 1];
                                            }
                                            else {
                                                QuesId = '0';
                                            }
                                            Qry += "('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + key + "','" + checkDesc(value) + "','" + formType + "','" + sessdata.type + "','" + QuesId + "'),";
                                        }
                                    });
                                    if (index == sdata.length - 1) {
                                        obj.nonqrysql = Qry.slice(0, -1);
                                        obj.prepare();
                                        obj.execute((_error: any, result: any) => {
                                            if (_error == 1) {
                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "UPDATE `user` SET `kyc_verify_status` = '2' WHERE `iduser`='" + sessdata.iduser + "'";
                                                obj3.prepare()
                                                obj3.execute((error: any, result2: any) => {
                                                    if (error == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "KYC Details Updated Successfully!", status: 200 });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Something went wrong With KYC Details!", status: 502 });
                                                        objv.execute();
                                                    }
                                                })
                                            }
                                        });
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went wrong With KYC Details!", status: 502 });
                                objv.execute();
                            }
                        })
                    }
                    else {
                        let obj = new ModelRawNonQuery(req, res);
                        let Qry: any = "INSERT INTO `know_your_customer`(`iduser`,`idaccount`, `key`,`value`, `form_type`,`user_type`,`question_id`) VALUES ";
                        sdata.forEach((element: any, index: any) => {
                            if (element.formType) {
                                formType = element.formType;
                            }
                            // console.log("formType",formType);
                            Object.entries(element).forEach(([key, value]) => {
                                // console.log(key +":"+ value);
                                if (key !== 'formType') {
                                    if (formType == 'messageService' || formType == 'voiceService') {
                                        let dataArray = key.split("_");
                                        QuesId = dataArray[dataArray.length - 1];
                                    }
                                    else {
                                        QuesId = '0';
                                    }
                                    Qry += "('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + key + "','" + checkDesc(value) + "','" + formType + "','" + sessdata.type + "','" + QuesId + "'),";
                                }
                            });
                            if (index == sdata.length - 1) {
                                obj.nonqrysql = Qry.slice(0, -1);
                                obj.prepare();
                                obj.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `user` SET `kyc_verify_status` = '2' WHERE `iduser`='" + sessdata.iduser + "'";
                                        obj3.prepare()
                                        obj3.execute((error: any, result2: any) => {
                                            if (error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "KYC Details Saved Successfully!", status: 200 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something went wrong With KYC Details!", status: 502 });
                                                objv.execute();
                                            }
                                        })
                                    }
                                });
                            }
                        });
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // function for upload pdf file in the folder..............
    // public saveKycpdf(req: Request, res: Response, next: NextFunction) {
    //     let sdata = JSON.parse(req.body.payload);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             if (req.file) {
    //                 let value: any = '';
    //                 const fileName = req.file.filename;
    //                 //value = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
    //                 value = kycpdf.generateKYCPDF + '/uploads/' + fileName;
    //                 let obj0 = new ModelRawQuery(req, res);
    //                 obj0.qrysql = "SELECT `form_type` FROM `know_your_customer` WHERE `iduser`='" + sessData.iduser + "' AND `idaccount`='" + sessData.idaccount + "' AND `form_type`='PDF'";
    //                 obj0.prepare();
    //                 obj0.execute((_error: any, result: any) => {
    //                     if (result.length > 0) {
    //                         let obj1 = new ModelRawNonQuery(req, res);
    //                         obj1.nonqrysql = "UPDATE `know_your_customer` SET `user_type`='" + sessData.type + "',`filename`='" + fileName + "',`value`='" + value + "' WHERE `iduser`='" + sessData.iduser + "' AND `idaccount`='" + sessData.idaccount + "' AND `form_type`='PDF' AND `key`='file_pdf'";
    //                         obj1.prepare();
    //                         obj1.execute((error: any, result: any) => {
    //                             console.log("PDF update Successfully");
    //                         });

    //                     }
    //                     else {
    //                         let obj2 = new ModelRawNonQuery(req, res);
    //                         obj2.nonqrysql = "INSERT INTO `know_your_customer`(`idaccount`,`iduser`,`user_type`,`filename`,`key`,`value`,`form_type`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + sessData.type + "','" + fileName + "','file_pdf','" + value + "','PDF')";
    //                         obj2.prepare();
    //                         obj2.execute((error: any, result: any) => {
    //                             console.log("PDF Insert Successfully");

    //                         });
    //                     }

    //                 })

    //             }
    //             else {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
    //                 objv.execute()
    //             }
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
    //             objv.execute();
    //         }
    //     })
    // }

    public saveKycpdf(req: Request, res: Response, next: NextFunction) {
        let sdata = JSON.parse(req.body.payload);
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (req.file) {
                    let value: any = '';
                    const fileName = req.file.filename;
                    let userType = 2;
                    //value = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
                    value = kycpdf.generateKYCPDF + fileName;
                    let obj0 = new ModelRawQuery(req, res);
                    // obj0.qrysql = "SELECT `form_type` FROM `know_your_customer` WHERE `iduser`='" + sessData.iduser + "' AND `idaccount`='" + sessData.idaccount + "' AND `form_type`='PDF'";
                    obj0.qrysql = "SELECT `form_type` FROM `know_your_customer` WHERE `iduser`='" + sdata.iduser + "' AND `idaccount`='" + sdata.idaccount + "' AND `form_type`='PDF'";
                    obj0.prepare();
                    obj0.execute((_error: any, result: any) => {
                        if (result.length > 0) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            // obj1.nonqrysql = "UPDATE `know_your_customer` SET `user_type`='" + sessData.type + "',`filename`='" + fileName + "',`value`='" + value + "' WHERE `iduser`='" + sessData.iduser + "' AND `idaccount`='" + sessData.idaccount + "' AND `form_type`='PDF' AND `key`='file_pdf'";
                            obj1.nonqrysql = "UPDATE `know_your_customer` SET `user_type`='" + userType + "',`filename`='" + fileName + "',`value`='" + value + "' WHERE `iduser`='" + sdata.iduser + "' AND `idaccount`='" + sdata.idaccount + "' AND `form_type`='PDF' AND `key`='file_pdf'";
                            obj1.prepare();
                            obj1.execute((error: any, result: any) => {
                                console.log("PDF update Successfully");
                            });
                        }
                        else {
                            let obj2 = new ModelRawNonQuery(req, res);
                            // obj2.nonqrysql = "INSERT INTO `know_your_customer`(`idaccount`,`iduser`,`user_type`,`filename`,`key`,`value`,`form_type`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + sessData.type + "','" + fileName + "','file_pdf','" + value + "','PDF')";
                            obj2.nonqrysql = "INSERT INTO `know_your_customer`(`idaccount`,`iduser`,`user_type`,`filename`,`key`,`value`,`form_type`) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "','" + userType + "','" + fileName + "','file_pdf','" + value + "','PDF')";
                            obj2.prepare();
                            obj2.execute((error: any, result: any) => {
                                console.log("PDF Insert Successfully");

                            });
                        }

                    })

                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
                    objv.execute()
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        })
    }

    /**GET query for KYC PDF */
    getKycPdf_ques(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id`,`question`,`answer1`,`answer2`,`click_yes`,`question_description`,`sub_question`, `service_type`,`question_type` FROM `kyc_question`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "KYC Question Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get KYC Question List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**GET All data for pdf */
    // getallData(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             var sdata = req.query;
    //             console.log("dataaaaaaa::",sdata);

    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "SELECT k.`id`,k.`question_id`,k.`user_type`,k.`form_type`,k.`key`,k.`value`,DATE_FORMAT(k.`kyc_date`, '%Y-%m-%d %T') AS kyc_date,kq.`question`,kq.`answer1`,kq.`answer2`,kq.`yes_to_continue`,kq.`click_yes`,kq.`question_description`,kq.`sub_question`,kq.`question_type`,kq.`customer_type` FROM `know_your_customer` AS k LEFT JOIN `kyc_question` AS kq ON  kq.id= k.question_id  WHERE k.`iduser`='" + sessdata.iduser + "' AND k.`idaccount`='" + sessdata.idaccount + "'";
    //             obj.prepare();
    //             obj.execute((_error: any, result: any) => {
    //                 if (_error == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "KYC Details Fetched Successfully!", data: result, status: 200 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "Something Went Wrong With Get KYC Details List!", status: 502, error: result });
    //                     objv.execute();
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    getallData(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.query;
                let iduser: any;
                let idaccount: any;
                if (sdata.iduser !== '' && sdata.idaccount !== '') {
                    iduser = sdata.iduser;
                    idaccount = sdata.idaccount;
                }
                if (sdata.iduser == 'undefined' && sdata.idaccount == 'undefined') {
                    iduser = sessdata.iduser;
                    idaccount = sessdata.idaccount;
                }
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT k.`id`,k.`question_id`,k.`user_type`,k.`form_type`,k.`key`,k.`value`,DATE_FORMAT(k.`kyc_date`, '%Y-%m-%d %T') AS kyc_date,kq.`question`,kq.`answer1`,kq.`answer2`,kq.`yes_to_continue`,kq.`click_yes`,kq.`question_description`,kq.`sub_question`,kq.`question_type`,kq.`customer_type` FROM `know_your_customer` AS k LEFT JOIN `kyc_question` AS kq ON  kq.id= k.question_id  WHERE k.`iduser`='" + iduser + "' AND k.`idaccount`='" + idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "KYC Details Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get KYC Details List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    rejectKycStatus(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `user` SET `kyc_verify_status`='3' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `know_your_customer` SET `value`='' WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `form_type`='kycSignature' AND `key`='kyc_signature'";
                        obj1.prepare();
                        obj1.execute((errors: any, result: any) => {
                            if(errors == 1){
                                let objv0 = new RawView(res);
                                objv0.prepare({ error: 0, status: 201, message: "KYC rejected successfully!" });
                                objv0.execute();
                            }
                            else{
                                let objv1 = new RawView(res);
                                objv1.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv1.execute();
                            }
                        })
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    /**GET data by id */
    checkKycRoute(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `id`,`question_id`,`user_type`,`form_type`,`key`,`value` FROM `know_your_customer` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Kyc Details All Ready Exists!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get KYC Details!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    /**GET data by id */
    downloadPdfForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT  kyc.`id`,kyc.`question_id`,kyc.`user_type`,kyc.`form_type`,kyc.`key`,kyc.`value`,user.`card_pdf` FROM `know_your_customer`AS kyc JOIN `user` ON user.`iduser`=kyc.`iduser`  WHERE kyc.`iduser`='"+iduser+"' AND kyc.`idaccount`='"+idaccount+"'  AND kyc.`form_type`='PDF' AND kyc.`key`='file_pdf'";
                obj.qrysql = "SELECT  `iduser`,`idaccount`,`key`,`value` FROM `know_your_customer` WHERE `form_type`='PDF' AND `key`='file_pdf'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetch Successfully", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getFederalPdfForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`,`idaccount`,`filename`,`value` FROM `federal_answer`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetch Successfully", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    public CustomerProfileInformation(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT u.`idaccount`,u.`iduser`,ba.`first_name`,ba.`last_name`,up.`email`,ba.`address1`,ba.`address2`,ba.`city`,ba.`state`,ba.`postal_code`,ba.`country`,ba.`title`,ba.`ein`,ba.`website`,ba.`legal_name`, ba.`groupExmpt_number`,ba.`businessName`,ba.`customerType`,up.`phone` FROM `user` AS u JOIN billing_address AS ba ON  ba.idaccount=u.idaccount JOIN user_profile AS up ON up.iduser=u.iduser WHERE u.`idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getFedrlQuestion(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `id_federal`, `question`, `question_description1`, `question_type`, `federal_status` FROM `federal_dnc`";
                obj0.prepare();
                obj0.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            status: 200
                        });
                        objv.execute();
                    }
                })
            }
        });
    }

    public saveFederal(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let QusID = '';
        // console.log("sdatasdata",sdata);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                Object.entries(sdata).forEach(([key]) => {
                    if (key.includes("federal_question") && !key.includes("sub")) {
                        QusID = key.substring(key.lastIndexOf('_') + 1);
                    }
                });
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`, `idaccount` FROM `federal_answer` where `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result.length > 0) {
                        let obj0 = new ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "UPDATE `federal_answer` SET `answer1`='" + sdata.federal_question_1 + "',`answer2`='" + sdata.sub_federal_question_2 + "',`question_id`='" + QusID + "',`fullname`='" + sdata.fullname + "',`signature`='" + sdata.kyc_signature + "' WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "'";
                        obj0.prepare();
                        obj0.execute((_errors: any, result: any) => {
                            if (_errors == 1) {
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `user` SET `federal_status` = '2' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj2.prepare()
                                obj2.execute((error: any, result2: any) => {
                                    if (error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Federal Updated Successfully!", status: 200 });
                                        objv.execute();
                                    }
                                })
                            }
                        });
                    }
                    else {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `federal_answer`(`idaccount`,`iduser`,`answer1`,`answer2`,`question_id`,`fullname`,`signature`) VALUES ('" + sessdata.idaccount + "','" + sessdata.iduser + "','" + sdata.federal_question_1 + "','" + sdata.sub_federal_question_2 + "','" + QusID + "','" + sdata.fullname + "','" + sdata.kyc_signature + "')";
                        obj1.prepare();
                        obj1.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `user` SET `federal_status` = '2' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj2.prepare()
                                obj2.execute((error: any, result2: any) => {
                                    if (error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Federal Saved Successfully!", status: 200 });
                                        objv.execute();
                                    }
                                })
                            }
                        })
                    }
                })
            }
        });
    }

    public getFederalPdf(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let iduser: any;
                let idaccount: any;
                if (sdata.iduser !== '' && sdata.idaccount !== '') {
                    iduser = sdata.iduser;
                    idaccount = sdata.idaccount;
                }
                if (sdata.iduser == 'undefined' && sdata.idaccount == 'undefined') {
                    iduser = sessdata.iduser;
                    idaccount = sessdata.idaccount;
                }
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT fa.`id_answer`,fa.`question_id`,fa.`fullname`,fa.`signature`,fa.`filename`,fa.`answer1`,fa.`answer2`,fa.`created_at`,fd.`id_federal`,fd.`question`,fd.`question_description1`,fd.`question_type`,fd.`federal_status`, u.`federal_status` FROM `federal_answer` AS fa JOIN `federal_dnc` AS fd ON  fd.id_federal= fa.question_id LEFT JOIN `user` AS u ON u.iduser=fa.iduser WHERE fa.`iduser`='" + iduser + "' AND fa.`idaccount`='" + idaccount + "'";
                obj0.prepare();
                obj0.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            status: 200
                        });
                        objv.execute();
                    }
                })
            }
        });
    }

    getkycstatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.query;
                var sdata = req.query;
                let iduser: any;
                let idaccount: any;
                if (sdata.iduser !== '' && sdata.idaccount !== '') {
                    iduser = sdata.iduser;
                    idaccount = sdata.idaccount;
                }
                if (sdata.iduser == 'undefined' && sdata.idaccount == 'undefined') {
                    iduser = sessdata.iduser;
                    idaccount = sessdata.idaccount;
                }
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT DISTINCT(kq.`customer_type`) FROM `know_your_customer` AS k JOIN `kyc_question` AS kq ON  kq.id= k.question_id WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Kyc Details All Ready Exists!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get KYC Details!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    public savefederalpdf(req: Request, res: Response, next: NextFunction) {
        let sdata = JSON.parse(req.body.payload);
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (req.file) {
                    let value: any = '';
                    const fileName = req.file.filename;
                    //value = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
                    value = kycpdf.generateFederalPDF + fileName;
                    if(sdata.federal_status == 3){
                            let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `pdf` From `federal_log` WHERE `iduser`='" + sdata.iduser + "' AND `idaccount`='" + sdata.idaccount + "' AND `federal_status`='1'"; 
                        obj0.prepare();
                        obj0.execute((_error: any, result: any) => {
                            if (result.length > 0) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `federal_log` SET `federal_status`='3' WHERE `iduser`='" + sdata.iduser + "' AND `idaccount`='" + sdata.idaccount + "' AND federal_status= '1'"; 
                                obj1.prepare();
                                obj1.execute((error: any, result: any) => {
                                    console.log("PDF update Successfully");
                                });
                            } 
                            else{
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "INSERT INTO `federal_log`(`idaccount`,`iduser`,`pdf`,federal_status) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "','" + value + "','3')"; 
                                obj2.prepare();
                                obj2.execute((error: any, result: any) => {
                                    console.log("PDF Insert Successfully");
            
                                });
                            }
                        });
                    }
                        else if(sdata.federal_status == 4){
                            let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `pdf` From `federal_log` WHERE `iduser`='" + sdata.iduser + "' AND `idaccount`='" + sdata.idaccount + "' AND `federal_status`='1'"; 
                        obj0.prepare();
                        obj0.execute((_error: any, result: any) => {
                            if (result.length > 0) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `federal_log` SET `federal_status`='4' WHERE `iduser`='" + sdata.iduser + "' AND `idaccount`='" + sdata.idaccount + "' AND federal_status= '1'"; 
                                obj1.prepare();
                                obj1.execute((error: any, result: any) => {
                                    console.log("PDF update Successfully");
                                });
                            } 
                            else{
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "INSERT INTO `federal_log`(`idaccount`,`iduser`,`pdf`,federal_status) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "','" + value + "','4')"; 
                                obj2.prepare();
                                obj2.execute((error: any, result: any) => {
                                    console.log("PDF Insert Successfully");
            
                                });
                            }
                        });
                    }
                    else{
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO `federal_log`(`idaccount`,`iduser`,`pdf`,federal_status) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "','" + value + "','1')"; 
                        obj2.prepare();
                        obj2.execute((error: any, result: any) => {
                            console.log("PDF Insert Successfully");
                        });
                    }
                    
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
                    objv.execute()
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        })
    }

    getFederalPDFAccount(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `pdf`, `federal_status`, `iduser`, `idaccount`, `created_at` FROM `federal_log` ORDER BY `federal_log_id` DESC";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv0 = new RawView(res);
                        objv0.prepare({ data: result, status: 200, message: "Federal DNC PDF Fetched Successfully" });
                        objv0.execute();
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    verifyfederalStatus(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `user` SET `federal_status`='1' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 0, status: 201, message: "Federal DNC Successfully Verified." });
                        objv0.execute();
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    rejectfederalStatus(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `user` SET `federal_status`='3' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 0, status: 201, message: "Rejected Federal DNC Status From Admin." });
                        objv0.execute();
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    cancelFederalStatus(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `user` SET `federal_status`='4' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 0, status: 201, message: "Cancel Federal DNC Status From Admin." });
                        objv0.execute();
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    getAccSettingStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT a.`idaccount`,a.`cps`,a.`ib_channel`, a.`ob_channel`, u.`federal_status` FROM `account` AS a JOIN `user` AS u ON a.`idaccount` = u.`idaccount` WHERE a.`idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Data Fetched Successfully", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


}