"use strict";
const multer1 = require('multer');
import { UploadDirectory } from '../config/setting.config';

const MIME_TYPE_MAP1: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',    
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx'
};

const storage1 = multer1.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        //let upload: any = '';
        // if (req.get('origin') == "https://preprod.crmdialer.us" || req.get('origin') == "https://portal.signalmash.com" || req.get('origin') == "https://api.crmdialer.us" || req.get('origin') == "https://doc.signalmash.com") {
        //     upload = '/var/www/html/signalmash_mms';
        // } else {
        //     upload = 'uploads';
        // }
        let mmsdir = new UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let error: any = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, mmsdir.MMSUPLOADS);
    },
    filename: (req: any, file: any, cb: any) => {
        const name = file.originalname.toLowerCase().split(' ').join('_');
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, Date.now() + '-' + name);
    }
});

module.exports = multer1({ storage: storage1 }).single('ATTACHMENT');

// exports.extMMS =  function(){
//     return multer1({ storage: storage1 }).single('ATTACHMENT');
// }