import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { CSPApiConfig } from "../config/setting.config";
import { sessiondata } from "../server";
import checkDesc from "./markError";

const request = require("request");
const cspSetting = new CSPApiConfig();
const authKey = cspSetting.AUTHKEY;
const apiUrl = cspSetting.APIURL;
const checkDescription = (desc: any) => {
    let result = '';
    if (desc) {
        result = desc.replace(/"/g, '\\"').replace(/'/g, "\\'");
        return result;
    } else {
        result = '';
        return result;
    }
}
export class NewCampaign extends AppRoute {
    constructor() {
        super();
    }

    /****************************************************************************
    * Start Brand Functionality  ************************************************
    ****************************************************************************/

    /**************************
    * Get Brand Relationship  *
    **************************/
    public brandRelationship(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/brandRelationship',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Brand Relationship Types!", data: JSON.parse(response.body), status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    public getBrandFeedback(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                var options = {
                    'method': 'GET',
                    'url': apiUrl + 'brand/feedback/' + req.query.type,
                    'headers': {
                        'Content-Type': 'application/json',
                        //   'Authorization': 'Basic MjQ1QUJEQjExODFENDI0QTgzRDNGNjU4MzhGNDFCNTA6Qjg0OTMzMUM1NTA3NEI0MkFCMTQ0MEYzNjI2M0IwOEI='
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Brand feedback Status!", data: JSON.parse(response.body), status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    /***************************
    * Get Brand Vertical Type  *
    ***************************/
    public brandVertical(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/vertical',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any) => {
                    if (!error) {
                        if (response) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand Vertical Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************
    * Brand Entity Type  *
    **********************/
    public brandEntityType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/entityType',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand Entity Types!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Entity Type Fetching!", error: error, status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*************************
    * Brand DCAs List  *
    *************************/
    public brandDCA(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/dca',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand DCA Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went Wrong With Fetch DCAs List!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*************************
    * Brand Identity Status  *
    *************************/
    public brandIdentityStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/brandIdentityStatus',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any) => {
                    if (!error) {
                        if (response) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Identity Status Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Identity Status Fetching!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**************************
    * Brand Alt Business Type *
    **************************/
    public altBusinessIdType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/altBusinessIdType',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "Brand Business Type Fetched!", data: data });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went Wrong With Get Brand Business Type Id List!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went Wrong With Connection!", error: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**********************
    * Brand stockExchange *
    **********************/
    public stockExchange(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/stockExchange',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "Brand stockExchange List!", data: data });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went Wrong With Get stockExchange List!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went Wrong With Connection!", error: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
    * Add Brand      *
    *****************/
    addBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let brandData: any = req.body;
                let obj5 = new ModelRawQuery(req, res);
                obj5.qrysql = "SELECT * FROM `brand` WHERE `brandId` = '" + brandData.brand_key + "'";
                obj5.prepare();
                obj5.execute((error: any, brand: any) => {
                    if (error == 1) {
                        if (brand.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Brand Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let obj4 = new ModelRawQuery(req, res);
                            obj4.qrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_relation`,`vertical_type`,`website`, `city`,`country`,`brand_name`, `brandId`, `brandType`) VALUES('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + brandData.companyName + "','" + brandData.brandRelationship + "','" + brandData.vertical + "','" + brandData.website + "','" + brandData.city + "','" + brandData.country + "', '" + brandData.companyName + "','" + brandData.brand_key + "', 'add')";
                            obj4.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 201, data: result, message: "Brand Added Successfully!" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ error: result, message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: brand, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /******************************
    * Brand Register Normal       *
    ******************************/
    public BrandRegister(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let brandData: any = req.body;
                let objv = new RawView(res);

                if (brandData.displayName && brandData.firstName && brandData.lastName && brandData.phone && brandData.street && brandData.city && brandData.state && brandData.postalCode && brandData.country && brandData.email && brandData.referenceId) {
                    let options: any = {
                        'method': 'POST',
                        'url': apiUrl + 'brand',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify(brandData)
                    };
                    request(options, (error: any, response: any, body: any) => {
                        if (!error) {
                            let resData = JSON.parse(response.body);
                            if (resData.brandId) {
                                let obj3 = new ModelRawQuery(req, res);
                                obj3.qrysql = "INSERT into `brand` (`iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `brandId`, `cspId`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`) VALUES('" + sessdata.iduser + "', '" + brandData.companyName + "', '" + brandData.displayName + "', '" + brandData.entityType + "', '" + brandData.ein + "', '" + brandData.brandRelationship + "', '" + brandData.street + "', '" + brandData.city + "', '" + brandData.state + "', '" + brandData.postalCode + "', '" + brandData.website + "', '" + brandData.vertical + "', '" + brandData.country + "', '" + brandData.email + "', '" + brandData.phone + "', '" + resData.brandId + "', '" + resData.cspId + "', '" + resData.registrationScore + "', '" + resData.universalEin + "',  '" + resData.referenceId + "', '" + resData.entityType + "', '" + resData.identityStatus + "', '" + resData.einIssuingCountry + "', '" + resData.mock + "', '" + brandData.firstName + "', '" + brandData.lastName + "', '" + brandData.ipAddress + "')";
                                obj3.execute((error: any, result: any) => {
                                    if (result) {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`='" + sessdata.idaccount + "'";
                                        obj.prepare();
                                        obj.execute((_error, _resp) => {
                                            if (_error == 1) {

                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                iQry += "`amount`='-4', "

                                                iQry += "`purpose`='Wallet amount successfully updated for brand registration', "

                                                iQry += "`status`=1;"

                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    console.log("Transaction response::", result)
                                                })

                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `date`, `description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.brandId + "', '4', '" + Date.now() + "', 'Brand_Rate')";
                                                obj3.prepare();
                                                obj3.execute((__error, resp) => {
                                                    if (__error == 1) {
                                                        objv.prepare({
                                                            data: {
                                                                brandId: resData.brandId,
                                                                cspId: resData.cspId
                                                            },
                                                            message: "Brand Register Successfully!",
                                                            status: 201
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        objv.prepare({
                                                            error: resp,
                                                            message: "Something Went Wrong With Connection!",
                                                            status: 502
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                objv.prepare({
                                                    error: _resp,
                                                    message: "Something Went Wrong With Connection!",
                                                    status: 502
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        objv.prepare({
                                            error: error,
                                            message: "Something Went Wrong!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                objv.prepare({
                                    message: resData[0].field + " " + resData[0].description,
                                    error: error,
                                    status: 502
                                });
                                objv.execute();
                            }
                        }
                    });
                }
                else {
                    objv.prepare({
                        status: 502,
                        error: "displayName, firstName, lastName, phone, street, city, state, postalCode, country, email, and referenceId are mendatory fields!"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /******************************
    * Brand Register None Blocking*
    ******************************/
    public brandRegisterNonBlocking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        let brandData: any = req.body;
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                if (brandData.entityType && brandData.entityType == "SOLE_PROPRIETOR") {
                    let ObjA = new ModelRawQuery(req, res);
                    ObjA.qrysql = "SELECT address,city,state,postal_code,country FROM `brand` WHERE `address`='" + checkDescription(brandData.street) + "' AND `city`='" + checkDescription(brandData.city) + "' AND `state`='" + brandData.state + "' AND `postal_code`='" + brandData.postalCode + "' AND `country`='" + brandData.country + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                    ObjA.prepare();
                    ObjA.execute((adErr: any, addressRes) => {
                        if (addressRes.length < 10) {
                            let Obj0 = new ModelRawQuery(req, res);
                            Obj0.qrysql = "SELECT email FROM `brand` WHERE `email`='" + brandData.email + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                            Obj0.prepare();
                            Obj0.execute((brErr: any, brandRes) => {
                                if (brandRes.length < 3) {
                                    let Obj00 = new ModelRawQuery(req, res);
                                    Obj00.qrysql = "SELECT phone FROM `brand` WHERE `phone`='" + brandData.phone + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                                    Obj00.prepare();
                                    Obj00.execute((brPhErr: any, brandPhRes) => {
                                        if (brandPhRes.length < 3) {
                                            let fun = new NewCampaign();
                                            fun.inbrandRegisterNonBlocking(req, res, next);
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ error: brPhErr, message: "Phone No. Already Exits 3 Times", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Email Id Already Exits 3 Times", status: 502 });
                                    objv.execute();

                                }
                            });

                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ error: adErr, message: "Address Already Exits 10 Times", status: 502 });
                            objv.execute();

                        }

                    })
                } else {
                    let fun = new NewCampaign();
                    fun.inbrandRegisterNonBlocking(req, res, next);
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    public inbrandRegisterNonBlocking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        let brandData: any = req.body;
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let Obj = new ModelRawQuery(req, res);
                Obj.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 4";
                Obj.prepare();
                Obj.execute((crErr: any, crRes) => {
                    if (crErr == 1 && crRes.length > 0) {
                        let options: any = {
                            'method': 'POST',
                            'url': apiUrl + 'brand/nonBlocking',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            body: JSON.stringify(brandData)
                        };
                        request(options, (error: any, response: any, body: any) => {
                            if (!error) {
                                let resultData = JSON.parse(response.body);
                                if (resultData.brandId && resultData.brandId !== undefined) {
                                    let obj3 = new ModelRawQuery(req, res);
                                    obj3.qrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `mobilePhone`, `brandId`,`cspId`, `altBusinessId`, `altBusinessIdType`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `stockSymbol`, `stockExchange`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`,`optionalAttributes`,`createDate`,`evpVettingScore`,`mobilePhoneVerifiedDate`, `brandType`) VALUES('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + checkDescription(resultData.companyName) + "', '" + checkDescription(resultData.displayName) + "', '" + resultData.entityType + "', '" + resultData.ein + "', '" + resultData.brandRelationship + "', '" + checkDescription(resultData.street) + "', '" + checkDescription(resultData.city) + "', '" + resultData.state + "', '" + resultData.postalCode + "', '" + resultData.website + "', '" + resultData.vertical + "', '" + resultData.country + "', '" + resultData.email + "', '" + brandData.phone + "','" + brandData.mobilePhone + "', '" + resultData.brandId + "', '" + resultData.cspId + "', '" + brandData.altBusinessId + "', '" + brandData.altBusinessIdType + "', '" + resultData.registrationScore + "', '" + resultData.universalEin + "',  '" + resultData.referenceId + "', '" + resultData.entityType + "', '" + resultData.identityStatus + "', '" + resultData.stockSymbol + "', '" + resultData.stockExchange + "', '" + resultData.einIssuingCountry + "', '" + resultData.mock + "', '" + checkDescription(brandData.firstName) + "', '" + checkDescription(resultData.lastName) + "', '" + resultData.ipAddress + "', '" + JSON.stringify(resultData.optionalAttributes) + "', '" + resultData.createDate + "', '" + resultData.evpVettingScore + "', '" + resultData.mobilePhoneVerifiedDate + "', 'register')";
                                    obj3.execute((__error: any, result: any) => {
                                        if (__error == 1) {
                                            let swaggerResChn = resultData;
                                            delete swaggerResChn.cspId;
                                            delete swaggerResChn.mock;
                                            let swaggerResponse = swaggerResChn
                                            if (resultData.entityType == "SOLE_PROPRIETOR") {
                                                let otp = new BrandManager();
                                                otp.smsOTPBrand(req, res, resultData.brandId, (smsErr: any, smsOtp: any) => {
                                                    if (smsErr == 1) {

                                                        let obj = new ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `iduser`='" + sessdata.iduser + "' AND `brandId`='" + resultData.brandId + "' AND `deleted`=0";
                                                        obj.prepare();
                                                        obj.execute((___error, resp) => { });

                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "New Brand Created Successfully And " +
                                                                smsOtp.message
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 201, brandId: resultData.brandId, data: swaggerResponse, message: "New Brand Created Successfully." });
                                                objv.execute();
                                            }


                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`='" + sessdata.idaccount + "'";
                                            obj.prepare();
                                            obj.execute((___error, resp) => {
                                                if (___error == 1) {
                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                    iQry += "`amount`='-4', "
                                                    iQry += "`purpose`='Wallet amount successfully updated for brand registration', "
                                                    iQry += "`status`=1;"

                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {

                                                    })
                                                }
                                                else {
                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                    iQry += "`amount`='-4', "
                                                    iQry += "`purpose`='Wallet amount not successfully updated for brand registration', "
                                                    iQry += "`status`=2;"

                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {

                                                    })
                                                }
                                            });
                                            let obj3 = new ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resultData.brandId + "', '4', '" + Date.now() + "','1', 'Brand Registered')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });

                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 504, brandId: resultData.brandId, message: "Result Not Saved Successfully!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resultData.brandId + "', '4', '" + Date.now() + "','2', 'Brand Register Failed')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                    let objv = new RawView(res);
                                    objv.prepare({ message: resultData[0].field + " " + resultData[0].description, status: resultData[0].code });
                                    objv.execute();
                                }
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: crErr, message: "Account Balance is Low!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**********************
    * Start Update Brand  *
    **********************/
    public updateBrand(req: Request, res: Response, next: NextFunction) {
        let brandId: any = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
            let Obj0 = new ModelRawQuery(req, res);
            Obj0.qrysql = "SELECT identityStatus FROM `brand` WHERE `brandId`='" + brandId + "' AND `iduser`='" + iduser + "' AND `deleted`=0";
            Obj0.prepare();
            Obj0.execute((_err: any, resStatus) => {
                if (resStatus[0].identityStatus == 'UNVERIFIED') {
                    let Obj00 = new ModelRawQuery(req, res);
                    Obj00.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 4";
                    Obj00.prepare();
                    Obj00.execute((crErr: any, crRes) => {
                        if (crErr == 1 && crRes.length > 0) {
                            let fun = new NewCampaign();
                            fun.inUpdateBrand(req, res, next);
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let fun = new NewCampaign();
                    fun.inUpdateBrand(req, res, next);
                }
            });
        });
    }

    public inUpdateBrand(req: Request, res: Response, next: NextFunction) {
        let data: any = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
        let brandId: any = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
            let Obj0 = new ModelRawQuery(req, res);
            Obj0.qrysql = "SELECT identityStatus,entityType FROM `brand` WHERE `brandId`='" + brandId + "' AND `iduser`='" + iduser + "' AND `deleted`=0";
            Obj0.prepare();
            Obj0.execute((_err: any, resStatus) => {
                var resultAllBrand = [];
                for (var i in data) {
                    // data[i] !== '' && 
                    if (data[i] !== 'undefined') {
                        resultAllBrand.push([i, data[i]]);
                    }
                }
                let brandData = Object.fromEntries(resultAllBrand);
                if (error == 1) {
                    let options: any = {
                        'method': 'PUT',
                        'url': apiUrl + 'brand/' + brandId,
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify(brandData)
                    };
                    request(options, (__error: any, response: any, body: any) => {
                        let resultData = JSON.parse(response.body);
                        if (resultData.brandId && resultData.brandId !== undefined) {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `brand` SET `company_name`='" + checkDescription(resultData.companyName) + "',`brand_name`='" + checkDescription(resultData.displayName) + "',`entityType`='" + resultData.entityType + "',`ein`='" + resultData.ein + "',`einIssuingCountry`='" + resultData.einIssuingCountry + "', `identityStatus`='" + resultData.identityStatus + "', `cspId`='" + resultData.cspId + "',`address`='" + checkDescription(resultData.street) + "',`city`='" + checkDescription(resultData.city) + "',`state`='" + resultData.state + "',`postal_code`='" + resultData.postalCode + "',`country`='" + resultData.country + "',`website`='" + resultData.website + "',`stockSymbol`='" + resultData.stockSymbol + "',`stockExchange`='" + resultData.stockExchange + "',`vertical_type`='" + resultData.vertical + "',`referenceId`='" + resultData.referenceId + "',`brand_relation`='" + resultData.brandRelationship + "',`email`='" + resultData.email + "',`phone`='" + resultData.phone + "',`mobilePhone`='" + resultData.mobilePhone + "',`firstName`='" + checkDescription(resultData.firstName) + "',`lastName`='" + checkDescription(resultData.lastName) + "',`altBusinessId`='" + brandData.altBusinessId + "',`altBusinessIdType`='" + brandData.altBusinessIdType + "',`ipAddress`='" + resultData.ipAddress + "',`optionalAttributes`='" + JSON.stringify(resultData.optionalAttributes) + "',`mock`='" + resultData.mock + "',`createDate`='" + resultData.createDate + "',`evpVettingScore`='" + resultData.evpVettingScore + "',`mobilePhoneVerifiedDate`='" + resultData.mobilePhoneVerifiedDate + "' WHERE `iduser`='" + iduser + "' AND `brandId`='" + brandId + "' AND `deleted`=0";
                            obj.prepare();
                            obj.execute((___error: any, result: any) => {
                                let swaggerResChn = resultData;
                                delete swaggerResChn.cspId;
                                delete swaggerResChn.mock;
                                let swaggerResponse = swaggerResChn
                                if (___error == 1) {
                                    if (resStatus[0].entityType !== 'SOLE_PROPRIETOR' && resStatus[0].identityStatus == 'UNVERIFIED' && resultData.identityStatus == "VERIFIED") {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`='" + sessdata.idaccount + "'";
                                        obj.prepare();
                                        obj.execute((____error, resp) => {
                                            if (____error) {
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                iQry += "`amount`='-4', "
                                                iQry += "`purpose`='Wallet amount successfully updated for brand identity status changed ', "
                                                iQry += "`status`=1;"
                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    console.log("Wallet amount successfully updated.");
                                                })
                                            }
                                            else {
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                iQry += "`amount`='-4', "
                                                iQry += "`purpose`='Wallet amount successfully not updated for brand identity status changed', "
                                                iQry += "`status`=2;"
                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                    console.log("Wallet amount not updated!");
                                                })
                                            }
                                        })
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '4', '" + Date.now() + "','3', 'Brand Updated')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                    }
                                    if (resStatus[0].entityType == 'SOLE_PROPRIETOR' && (!resStatus[0].identityStatus || resStatus[0].identityStatus == '' || resStatus[0].identityStatus == 'undefined' || resStatus[0].identityStatus == null || resStatus[0].identityStatus == undefined || resStatus[0].identityStatus == 'UNDEFINED' || resStatus[0].identityStatus == 'SELF_DECLARED')) {
                                        let otp = new BrandManager();
                                        otp.smsOTPBrand(req, res, resultData.brandId, (smsErr: any, smsOtp: any) => {
                                            if (smsErr == 1) {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `iduser`='" + sessdata.iduser + "' AND `brandId`='" + resultData.brandId + "'";
                                                obj.prepare();
                                                obj.execute((___error, resp) => { });
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "Brand Updated Successfully And " +
                                                        smsOtp.message
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                objv.execute();
                                            }
                                        });
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '4', '" + Date.now() + "','3', 'Brand Updated')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: "Brand Updated Successfully!", data: swaggerResponse, status: 201
                                        });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong With Brand Update!" });
                                    objv.execute();
                                }
                            })
                        }
                        else {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '', '" + Date.now() + "','4', 'Brand Update Failed')";
                            obj3.prepare();
                            obj3.execute((log_error, _resp) => {
                                if (log_error == 1) {
                                    console.log("Brand Log Updated.");
                                }
                                else {
                                    console.log("Brand Log Not Updated.");
                                }
                            });
                            let objv = new RawView(res);
                            objv.prepare({
                                message: resultData[0].field + ' ' + resultData[0].description,
                                status: resultData[0].code
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        });
    }

    /********************
    * End Update Brand  *
    ********************/

    /************************************
    * Start Revet Brand Identity Status *
    *************************************/
    public brandRvtForIdenSttsUp(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let Obj00 = new ModelRawQuery(req, res);
            Obj00.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 4";
            Obj00.prepare();
            Obj00.execute((crErr: any, crRes) => {
                if (crErr == 1 && crRes.length > 0) {
                    let fun = new NewCampaign();
                    fun.inRevet(req, res, next);
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                    objv.execute();
                }
            });
        });
    }
    public inRevet(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let brandId: any = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.body.brandId;
            let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
            if (error == 1) {
                let Obj0 = new ModelRawQuery(req, res);
                Obj0.qrysql = "SELECT identityStatus,brandId FROM `brand` WHERE `brandId`='" + brandId + "' AND `iduser`='" + iduser + "' AND `deleted`=0";
                Obj0.prepare();
                Obj0.execute((_err: any, resStatus) => {
                    if (resStatus.length > 0) {
                        let options: any = {
                            'method': 'PUT',
                            'url': apiUrl + 'brand/' + brandId + '/revet',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            body: JSON.stringify({ nonBlocking: true })
                        };
                        request(options, (error: any, response: any, body: any) => {
                            if (!error && response.body) {
                                let resultData = JSON.parse(response.body);
                                if (resStatus[0].identityStatus == "UNVERIFIED" && resultData.identityStatus == "VERIFIED") {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='" + resultData.identityStatus + "' WHERE `iduser`='" + iduser + "' AND `brandId`='" + brandId + "' AND `deleted`=0";
                                    obj.prepare();
                                    obj.execute((___error, resp) => {
                                        if (___error == 1) {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`='" + sessdata.idaccount + "'";
                                            obj.prepare();
                                            obj.execute((____error, resp) => {
                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                iQry += "`amount`='-4', "
                                                iQry += "`purpose`='Wallet amount successfully updated for identity status changed', "
                                                iQry += "`status`=1;"
                                                let objWL = new ModelRawNonQuery(req, res);
                                                objWL.nonqrysql = iQry
                                                objWL.prepare()
                                                objWL.execute((error: any, result: any) => {
                                                })
                                            })
                                            let obj3 = new ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '4', '" + Date.now() + "','7', 'Brand Re-Submitted')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Brand Status Updated Successfully.", data: resStatus.identityStatus, status: 200 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Brand Status!", status: 502 });
                                            objv.execute();
                                        }
                                    })
                                }
                                else {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '4', '" + Date.now() + "','8', 'Brand Re-Submit Failed')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "No Change in Brand Status.", data: resStatus.identityStatus, status: 502 });
                                    objv.execute();
                                }
                            }
                            else {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '4', '" + Date.now() + "','8', 'Brand Re-Submit Failed')";
                                obj3.prepare();
                                obj3.execute((log_error, _resp) => {
                                    if (log_error == 1) {
                                        console.log("Brand Log Updated.");
                                    }
                                    else {
                                        console.log("Brand Log Not Updated.");
                                    }
                                });
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: resStatus[0].field + ' ' + resStatus[0].description,
                                    status: resStatus[0].code
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Brand Expired!", status: 503 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /***********************************
    * End Identtity Status Of Brand  *
    ***********************************/

    /****************
    * Delete Brand  *
    ****************/
    public deleteBrand(req: Request, res: Response, next: NextFunction) {
        let brandId = req.query.id !== undefined ? req.query.id : req.query.brandId;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'DELETE',
                    'url': apiUrl + 'brand/' + brandId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (__error: any, response: any, body: any) => {
                    if (!__error) {
                        if ((response.statusCode == 405) || (response.statusCode == 204 && response.statusCode !== undefined) || (JSON.parse(body)[0].code == 502 && JSON.parse(body)[0].code !== undefined)) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "UPDATE `brand` SET `deleted`=1, `delete_date`=NOW() WHERE `brandId`='" + brandId + "' AND `iduser`='" + sessdata.iduser + "'";
                            obj0.prepare();
                            obj0.execute((__errorb: any, resbrand: any) => {
                                if (__errorb == 1) {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "DELETE FROM `brand_log` WHERE `brand_key`='" + brandId + "' AND `iduser`='" + sessdata.iduser + "'";
                                    obj.prepare();
                                    obj.execute((__errlog: any, lastid: any) => {
                                        if (__errlog == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Brand Deleted Successfully!",
                                                data: lastid[0],
                                                status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong With Brand!",
                                                error: lastid,
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '', '" + Date.now() + "','5', 'Brand Removed')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                }
                                else {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '', '" + Date.now() + "','6', 'Brand Remove Failed')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With Delete Brand!",
                                        error: resbrand,
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });

                        }
                        else {
                            let data = JSON.parse(body);
                            let objv = new RawView(res);
                            objv.prepare({
                                message: data[0].field + ' ' + data[0].description,
                                status: data[0].code
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Brand Can't be Delete!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
    * Get All Brand  *
    *****************/
    public getAllBrands(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser: any = sessdata.iduser;
                let condition = '';
                if (sessdata.type == 1) {
                    condition += ''
                }
                if (sessdata.type == 2) {
                    condition += "AND `idaccount`='" + sessdata.idaccount + "'"
                }
                if (sessdata.type == 22) {
                    condition += "AND `iduser`='" + sessdata.iduser + "'"
                }
                let ext_field = req.query.type ? "idbrand,iduser, idaccount,cspId,registrationScore,CONCAT(brand_name,' - ',brandId)brand_name_with_key, DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On, deleted, delete_date, mock,company_type," : '';
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`,created_at FROM brand WHERE `status`='0' AND `deleted`='0' " + condition + " ORDER BY `idbrand` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************
    * Brand Filter  *
    ****************/
    public brandFilter(req: Request, res: Response, next: NextFunction) {
        let data = req.body.data;
        let condition: any = "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += ''
                }
                if (sessdata.type == 2) {
                    conditionU += "`idaccount`='" + sessdata.idaccount + "' AND"
                }
                if (sessdata.type == 22) {
                    conditionU += "`iduser`='" + sessdata.iduser + "' AND"
                }

                let obj = new ModelRawQuery(req, res);
                if (data.brandId)
                    condition += '`brandId` LIKE "%' + checkDesc(data.brandId) + '%" AND ';

                if (data.brand_name)
                    condition += '`brand_name` LIKE "%' + checkDesc(data.brand_name) + '%" AND ';

                if (data.country)
                    condition += '`country`="' + data.country + '" AND ';

                if (data.entityType)
                    condition += '`entityType` LIKE "%' + data.entityType + '%" AND ';

                if (data.ein)
                    condition += '`ein` LIKE "%' + data.ein + '%" AND ';

                if (data.identityStatus)
                    condition += '`identityStatus` LIKE "' + data.identityStatus + '%" AND ';

                if (data.referenceId)
                    condition += '`referenceId` LIKE "%' + checkDesc(data.referenceId) + '%" AND ';

                // obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE deleted='0' AND " + condition + " " + conditionU + " ";
                obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE " + conditionU + " " + condition + " deleted='0'"
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /****************
    * CNP Brand Filter  *
    ****************/
    public cnpBrandFilter(req: Request, res: Response, next: NextFunction) {
        let data = req.body.data;
        let condition: any = "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += ''
                }
                if (sessdata.type == 2) {
                    conditionU += "`idaccount`='" + sessdata.idaccount + "' AND"
                }
                if (sessdata.type == 22) {
                    conditionU += "`iduser`='" + sessdata.iduser + "' AND"
                }

                let obj = new ModelRawQuery(req, res);
                if (data.brandId)
                    condition += '`brandId` LIKE "%' + checkDesc(data.brandId) + '%" AND ';

                if (data.displayName)
                    condition += '`displayName` LIKE "%' + checkDesc(data.displayName) + '%" AND ';

                if (data.company_name)
                    condition += '`company_name` LIKE "%' + checkDesc(data.company_name) + '" AND ';

                if (data.website)
                    condition += '`website` LIKE "%' + checkDesc(data.website) + '%" AND ';

                // obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE deleted='0' AND " + condition + " " + conditionU + " ";
                obj.qrysql = "SELECT iduser, idaccount, brandId, company_name, displayName, website , status, DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE " + conditionU + " " + condition + " deleted='0' AND `status`='1' ORDER BY `idbrand` DESC"
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    /*******************
    * Campaign Filter  *
    *******************/
    public campaignFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let data = req.body.data;
            let condition: any = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += ''
                }
                if (sessdata.type == 2) {
                    conditionU += "c.`idaccount`='" + sessdata.idaccount + "' AND"
                }
                if (sessdata.type == 22) {
                    conditionU += "c.`iduser`='" + sessdata.iduser + "' AND"
                }

                if (data.brandId)
                    condition += '`brandId` LIKE "%' + checkDesc(data.brandId) + '%" AND ';

                if (data.brand_name)
                    condition += '`brand_name` LIKE "%' + checkDesc(data.brand_name) + '%" AND ';

                if (data.campaign_key)
                    condition += '`campaign_key` LIKE "%' + checkDesc(data.campaign_key) + '%" AND ';

                if (data.usecase)
                    condition += '`usecase`="' + data.usecase + '" AND ';
                if (data.tcrStatus == 'Both') {
                    condition += '';
                }
                else {
                    condition += 'c.`deleted`="' + data.tcrStatus + '" AND ';
                }

                // if (data.referenceId)
                //     condition += '`referenceId` LIKE "%' + data.referenceId + '%" AND ';

                // obj.qrysql = "SELECT c.iduser, c.idaccount, b.brandId, b.brand_name,c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + " c.`iduser` = '" + sessdata.iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                // obj.qrysql = "SELECT c.iduser, c.idaccount, b.brandId, b.brand_name,c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.deleted FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + conditionU + " " + condition + " c.`deleted` = 0 AND c.`status`=0 GROUP BY campaign_key";

                obj.qrysql = "SELECT c.iduser, c.idaccount, b.brandId, b.brand_name,c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.deleted FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + conditionU + " " + condition + " c.`status`=0 GROUP BY campaign_key";


                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign List Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*******************
    * Campaign Filter  *
    *******************/

    /********************
    * Get Brand Detail  *
    ********************/

    public getBrandsDetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let gdata: any = req.query;
            let data: any = gdata.type !== undefined ? JSON.parse(gdata.type) : gdata;
            let iduser: any = data.iduser !== undefined ? data.iduser : sessdata.iduser;

            let ext_field = gdata.type ? "idbrand,iduser, idaccount,cspId,registrationScore,mock,deleted, delete_date , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On,createDate,company_type," : '';
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation,altBusinessId, altBusinessIdType, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes,mobilePhoneVerifiedDate, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`, created_at  FROM brand WHERE `deleted`='0' AND brandId='" + data.brandId + "' AND iduser = '" + iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Brand Fetched Successfully!",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: result,
                                message: "No Result Found!",
                                status: 502
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    /***************************
    * Get OTP Status For Brand *
    ***************************/
    sendOTPforBrand(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let otp = new BrandManager();
                otp.smsOTPBrand(req, res, sdata.brandId, (smsErr: any, smsOtp: any) => {
                    if (smsErr == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: smsOtp.status, data: smsOtp.data, message: smsOtp.message });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: smsOtp.status, brandId: sdata.brandId, message: smsOtp.message });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***************************
    * Get OTP Status For Brand *
    ***************************/
    verifyBrandOTP(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let otpdata: any;
                otpdata = {
                    otpPin: sdata.brandOTP,
                }
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'brand/' + sdata.brandId + '/smsOtp',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(otpdata)
                };
                request(options, (error: any, response: any, body: any) => {

                    if (!error) {
                        let data = JSON.stringify(response.body);
                        let objv = new RawView(res);
                        objv.prepare({ message: 'OTP Updated !', data: data, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "OTP Not Updated!", data: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /*********************
    * Send OTP For Brand *
    *********************/
    getOTPStatusForBrand(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'brand/smsOtp/' + sdata.referenceId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let resData = JSON.parse(response.body);
                        if (resData.referenceId && resData.referenceId !== undefined) {
                            let objv = new RawView(res);
                            objv.prepare({ message: 'Brand OTP Status!', data: resData, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: resData[0].field + ' ' + resData[0].description, status: resData[0].code });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "No Status Available!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************
    * Vetting Class *
    *****************/
    public brandVettingClass(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/vettingClass',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand Vetting Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went Wrong With Brand Vetting Fetching!", error: error, status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /***********************
    * Get Vetting Provider *
    ***********************/
    public brandVettingProvider(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/extVettingProvider',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand Vetting Provider Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went Wrong With Brand Vetting Provider Fetching!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***********************
    * Get Vetting Status   *
    ***********************/
    public brandVettingStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/vettingStatus',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand Vetting Status Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went Wrong With Brand Vetting Status Fetching!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /*****************************************
    * Get Vetting Class Class By Entity Type *
    *****************************************/
    public getVettingClassByEtype(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let data: any = JSON.parse(sdata.type);
        let entityType: any = data.entityType;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT vettingClass,VC_displayName,evpId,EI_displayName,price,waitTime FROM `brand_vetting_additional` WHERE entityType='" + entityType + "' GROUP BY `vettingClass`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Vetting Class and Provider Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Vetting Class and Provider Not Fetched!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /**************************************
    * Get Vetting Provider By Entity Type *
    **************************************/
    public getVettingPartner(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let data: any = JSON.parse(sdata.type);
        let entityType: any = data.entityType;
        let vettingClass: any = data.vettingClass;

        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT vettingClass,VC_displayName,evpId,EI_displayName,price,waitTime FROM `brand_vetting_additional` WHERE entityType='" + entityType + "' AND `vettingClass`='" + vettingClass + "'";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Vetting Class and Provider Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Vetting Class and Provider Not Fetched!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************************
    * Get Vetting List By Brand *
    ****************************/
    public getBrandsVettingList(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let data: any = JSON.parse(sdata.type);
        let brandId: any = data.brandId;
        let iduser: any = data.iduser;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,brandID,type,evpId,vettingId,vettingToken,vettingScore,vettingClass,vettingStatus,reasons,vettingDetails,VettedDate,createdDate FROM `brand_vetting` WHERE brandId='" + brandId + "' AND iduser='" + iduser + "' GROUP BY `vettingId`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Vetting Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO Vetting available in this Brand!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************
    * Apply Vetting *
    ****************/
    public applyVetting(req: Request, res: Response, next: NextFunction) {
        let vettingData: any = req.body;
        let vettingData1: any = req.query;
        let brandId: any = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT entityType,einIssuingCountry FROM `brand` WHERE brandId='" + brandId + "' AND `iduser` = '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((errBrand: any, resultBrand: any) => {
                    if (errBrand == 1 && resultBrand.length > 0) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT vettingClass,evpId,price,waitTime,failedPrice FROM `brand_vetting_additional` WHERE evpId='" + vettingData.evpId + "' AND vettingClass='" + vettingData.vettingClass + "' AND entityType='" + resultBrand[0].entityType + "'";
                        obj.prepare();
                        obj.execute((errV: any, resulttV: any) => {

                            let resultV: any = resulttV.length > 0 ? resulttV : [0];

                            // For pinPreference (swagger side request)
                            let price: any;
                            if ((resultBrand[0].entityType == "NON_PROFIT" && resultBrand[0].einIssuingCountry == "US" && resultV[0].vettingClass == "POLITICAL" && resultV[0].evpId == "AEGIS") || (resultBrand[0].entityType == "SOLE_PROPRIETOR" && resultBrand[0].einIssuingCountry == "US" && resultV[0].vettingClass == "POLITICAL" && resultV[0].evpId == "AEGIS")) {
                                let pinPre: any = JSON.parse(vettingData.additionalRequestPayload).pinPreference;
                                switch (pinPre) {
                                    case "Regular":
                                        price = 64;
                                        break;
                                    case "Email":
                                        price = 64;
                                        break;
                                    default: // Express
                                        price = 91.95;
                                }
                            }
                            else {
                                price = resultV[0].price !== undefined ? resultV[0].price : 0;
                            }
                            let deductPrice: any = price;
                            let waittime = resultV[0].waitTime !== undefined ? resultV[0].waitTime : '';
                            let Obj = new ModelRawQuery(req, res);
                            Obj.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + deductPrice + "'";
                            Obj.prepare();
                            Obj.execute((bErr: any, bRes) => {
                                if (bErr == 1 && bRes.length > 0) {
                                    let options: any = {
                                        'method': 'POST',
                                        'url': apiUrl + 'brand/' + brandId + '/externalVetting/',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + authKey
                                        },
                                        body: JSON.stringify({
                                            "evpId": vettingData.evpId,
                                            "vettingClass": vettingData.vettingClass,
                                            "additionalRequestPayload": vettingData.additionalRequestPayload
                                        })
                                    };
                                    request(options, (error: any, response: any, body: any) => {
                                        if (!error) {
                                            let resData = JSON.parse(response.body);
                                            if (resData.vettingId && resData.vettingId !== undefined) {

                                                // To Charge deduct from wallet
                                                //let deductPrice: any = price;
                                                /*switch (resData.vettingStatus) {
                                                    case "FAILED":
                                                        switch (vettingData.evpId) {
                                                            case "STANDARD":
                                                                deductPrice = resultV[0].failedPrice;
                                                                break;
                                                            case "POLITICAL":
                                                                deductPrice = resultV[0].failedPrice;
                                                                break;
                                                            default:
                                                                deductPrice = 0;
                                                        }
                                                        break;
                                                    default:
                                                        deductPrice = price;
                                                }*/
                                                // To brand log update
                                                let Objbl = new ModelRawQuery(req, res);
                                                Objbl.qrysql = "SELECT brand_key FROM `brand_log` WHERE `brand_key`='" + brandId + "' AND `iduser`='" + sessdata.iduser + "'";
                                                Objbl.prepare();
                                                Objbl.execute((BlErr: any, BlRes) => {
                                                    if (BlRes.length > 0) {
                                                        let objv00 = new ModelRawNonQuery(req, res);
                                                        objv00.nonqrysql = "UPDATE `brand_log` SET `vettingCharge`=`vettingCharge`+" + deductPrice + " WHERE `iduser`='" + sessdata.iduser + "' AND `brand_key`='" + brandId + "'";
                                                        objv00.prepare();
                                                        objv00.execute((errwalleup, sucwalletup) => {
                                                            console.log("Brand Log Updated");
                                                        });
                                                    }
                                                    else {
                                                        let objbl0 = new ModelRawNonQuery(req, res);
                                                        objbl0.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `date`, `description`, `vettingCharge`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "', '', '" + Date.now() + "', 'Vetting_Charge', '" + deductPrice + "')";
                                                        objbl0.prepare();
                                                        objbl0.execute((__errorbl, respbl) => {
                                                            console.log("Brand Log Inserted");
                                                        });
                                                    }
                                                });

                                                //To deduct price from wallet
                                                let objv = new ModelRawNonQuery(req, res);
                                                objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + deductPrice + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                objv.prepare();
                                                objv.execute((wallet_error, wallet_success) => {
                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                    iQry += "`amount`='-" + deductPrice + "', "
                                                    iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "
                                                    iQry += "`status`=1;"
                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {
                                                        console.log("Transaction response::", result)
                                                    })
                                                    console.log("Charge deducted $", deductPrice);
                                                });

                                                //To inser brand vetting detail
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `brand_vetting` (`idaccount`, `iduser`, `brandId`,`type`, `evpId`, `vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate`,`priceDeducted`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + brandId + "', 'applyVetting', '" + resData.evpId + "', '" + resData.vettingId + "','" + resData.vettingToken + "','" + resData.vettingScore + "','" + resData.vettingClass + "','" + resData.vettingStatus + "','" + resData.reasons + "','" + JSON.stringify(resData.vettingDetails) + "','" + resData.vettedDate + "','" + resData.createDate + "','" + deductPrice + "')";
                                                obj.prepare();
                                                obj.execute((___error, resp) => {
                                                    if (___error == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 200, message: "Vetting Applied Successfully.Vetting Price " + deductPrice + " and Estimated Time for Vetting: " + waittime + "", data: resData });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 501, message: "Vetting Data Not Saved!", data: resData });
                                                        objv.execute();
                                                    }
                                                })
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ error: error, message: "Your Currect Balance is Low From $" + price + "!", status: 502 });
                                    objv.execute();
                                }
                            });
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: error, message: "Brand Does Not Exist!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
    * Import Vetting *
    *****************/
    public importVetting(req: Request, res: Response, next: NextFunction) {
        let vettingData: any = req.body;
        let vettingData1: any = req.query;
        let brandId: any = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let Obj = new ModelRawQuery(req, res);
                Obj.qrysql = "SELECT evpId FROM `brand_vetting` WHERE `evpId`='" + vettingData.evpId + "' AND `vettingId`='" + vettingData.vettingId + "' AND `iduser`='" + sessdata.iduser + "'";
                Obj.prepare();
                Obj.execute((VErr: any, VRes) => {
                    let options: any = {
                        'method': 'PUT',
                        'url': apiUrl + 'brand/' + brandId + '/externalVetting/',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify({
                            "evpId": vettingData.evpId,
                            "vettingId": vettingData.vettingId,
                            "vettingToken": vettingData.vettingToken
                        })
                    }
                    request(options, (error: any, response: any, body: any) => {
                        if (!error) {
                            let resData = JSON.parse(response.body);
                            if (resData.vettingId && resData.vettingId !== undefined) {
                                let qry: any = '';
                                if (VRes.length > 0) {
                                    qry = "UPDATE `brand_vetting` SET `evpId`='" + resData.evpId + "',`vettingToken`='" + resData.vettingToken + "', `vettingScore`='" + resData.vettingScore + "',`vettingClass`='" + resData.vettingClass + "',`vettingStatus`='" + resData.vettingStatus + "',`reasons`='" + resData.reasons + "',`type`='importVetting',`vettingDetails`='" + JSON.stringify(resData.vettingDetails) + "',`vettedDate`='" + resData.vettedDate + "',`createdDate`='" + resData.createDate + "' WHERE `iduser`='" + sessdata.iduser + "' AND `brandId`='" + brandId + "' AND `vettingId`='" + vettingData.vettingId + "'";
                                }
                                else {
                                    qry = "INSERT INTO `brand_vetting` (`idaccount`, `iduser`, `brandId`,`type`, `evpId`, `vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + brandId + "', 'importVetting', '" + resData.evpId + "', '" + resData.vettingId + "','" + resData.vettingToken + "','" + resData.vettingScore + "','" + resData.vettingClass + "','" + resData.vettingStatus + "','" + resData.reasons + "','" + JSON.stringify(resData.vettingDetails) + "','" + resData.vettedDate + "','" + resData.createDate + "')";
                                }
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = qry;
                                obj.prepare();
                                obj.execute((___error, resp) => {
                                    if (___error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Vetting Imported Successfully!", data: resData, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Vetting Not Inserted", status: 501 });
                                        objv.execute();
                                    }
                                })
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                objv.execute();

                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                            objv.execute();

                        }
                    });
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************************************************************
    * Get Single External Vetting List By Brand Id And Status Update *
    *****************************************************************/
    public externalVettingList(req: Request, res: Response, next: NextFunction) {
        let vettingData: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            // To Check Brand Exist Or Not
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + vettingData.brandId + "' AND `iduser` = '" + sessdata.iduser + "'";
            obj.prepare();
            obj.execute((errBrand: any, resultBrand: any) => {
                if (errBrand == 1 && resultBrand.length > 0) {
                    if (error == 1) {
                        // To Get Brand Vetting List
                        let options: any = {
                            'method': 'GET',
                            'url': apiUrl + 'brand/' + vettingData.brandId + '/externalVetting/?evpId=' + vettingData.evpId + '&vettingClass=' + vettingData.vettingClass + '&vettingStatus=' + vettingData.vettingStatus + '',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        request(options, (error: any, response: any) => {
                            if (!error) {
                                let resData: any = JSON.parse(response.body);
                                if (resData.length == 0) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "No Record Found!", status: 502 });
                                    objv.execute();
                                }
                                else if (resData[0].code && resData[0].code !== undefined && resData.length > 0) {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                    objv.execute();
                                }
                                else {
                                    resData.forEach((element: any) => {

                                        // To Update Brand Vetting

                                        let obj0 = new ModelRawNonQuery(req, res);
                                        obj0.nonqrysql = "UPDATE `brand_vetting` SET `evpId`='" + element.evpId + "', `vettingId`='" + element.vettingId + "',`vettingToken`='" + element.vettingToken + "',`vettingScore`='" + element.vettingScore + "',`vettingClass`='" + element.vettingClass + "',`vettingStatus`='" + element.vettingStatus + "',`reasons`='" + element.reasons + "',`vettingDetails`='" + JSON.stringify(element.vettingDetails) + "',`vettedDate`='" + element.vettedDate + "',`createdDate`='" + element.createDate + "' WHERE `vettingId` = '" + element.vettingId + "' AND `vettingStatus` != 'ACTIVE' AND `iduser`='" + sessdata.iduser + "'";
                                        obj0.prepare();
                                        obj0.execute((___error, resp) => { });

                                    });

                                    // To Show Brand Vetting Response
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 200, message: "Record Fetched Successfully!", data: resData });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Request!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new Res406(res);
                        objv.prepare(session);
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                    objv.execute();
                }
            });
        });
    }

    /*******************************************************************
    * Get Multiple External Vetting List By Brand Id And Status Update *
    *******************************************************************/
    public externalVettingBulkUpdate(req: Request, res: Response, next: NextFunction) {
        let data: any = JSON.parse(req.body.data);
        let brandId: any = data.brandId;
        let iduserVal: any = data.iduser;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {

            let iduser: any = iduserVal !== undefined ? iduserVal : sessdata.iduser;
            // To Check Brand Exist Or Not
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + brandId + "' AND `iduser` = '" + iduser + "'";
            obj.prepare();
            obj.execute((errBrand: any, resultBrand: any) => {
                if (errBrand == 1 && resultBrand.length > 0) {
                    if (error == 1) {

                        // To Get All Vetting Detail By Brand

                        let obj00 = new ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT vettingStatus,brandId,vettingClass,evpId,paid_time FROM `brand_vetting` WHERE brandId='" + brandId + "' AND `iduser` = '" + iduser + "'";
                        obj00.prepare();
                        obj00.execute((errAll: any, resultAll: any) => {

                            if (errAll == 1 && resultAll.length > 0) {
                                resultAll.forEach((ele: any) => {

                                    // To Get Brand Vetting List
                                    let options: any = {
                                        'method': 'GET',
                                        'url': apiUrl + 'brand/' + ele.brandId + '/externalVetting',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + authKey
                                        },
                                    };
                                    request(options, (error: any, response: any) => {
                                        if (!error) {
                                            let resData: any = JSON.parse(response.body);
                                            if (resData.length == 0) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "No Record Found!", status: 502 });
                                                objv.execute();
                                            }
                                            else if (resData[0].code && resData[0].code !== undefined && resData.length > 0) {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                objv.execute();
                                            }
                                            else {
                                                resData.forEach((element: any) => {

                                                    // To Update Brand Vetting with Price Deduction

                                                    let obj0 = new ModelRawNonQuery(req, res);
                                                    obj0.nonqrysql = "UPDATE `brand_vetting` SET `evpId`='" + element.evpId + "', `vettingId`='" + element.vettingId + "',`vettingToken`='" + element.vettingToken + "',`vettingScore`='" + element.vettingScore + "',`vettingClass`='" + element.vettingClass + "',`vettingStatus`='" + element.vettingStatus + "',`reasons`='" + element.reasons + "',`vettingDetails`='" + JSON.stringify(element.vettingDetails) + "',`vettedDate`='" + element.vettedDate + "',`createdDate`='" + element.createDate + "' WHERE `vettingId` = '" + element.vettingId + "' AND `iduser`='" + iduser + "'";
                                                    obj0.prepare();
                                                    obj0.execute((___error, resp) => { });
                                                });
                                            }
                                        }
                                    });
                                });
                                // To Show Brand Vetting Response
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Record Updated!", data: resultAll });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "No Record Found!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new Res406(res);
                        objv.prepare(session);
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                    objv.execute();
                }
            });
        });
    }
    /***************
    * Revet Brand  * 
    ***************/
    public revetBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let reqQry: any = req.query;
            let reqData: any = req.body;
            if (error == 1) {
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 4";
                Obj00.prepare();
                Obj00.execute((crErr: any, crRes) => {
                    if (crErr == 1 && crRes.length > 0) {
                        let Obj0 = new ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT identityStatus,brandId FROM `brand` WHERE `brandId`='" + reqQry.brandId + "' AND `iduser`='" + sessdata.iduser + "' AND `deleted`=0";
                        Obj0.prepare();
                        Obj0.execute((_err: any, resStatus) => {
                            if (resStatus.length > 0) {
                                let options: any = {
                                    'method': 'PUT',
                                    'url': apiUrl + 'brand/' + reqQry.brandId + '/revet',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': 'Basic ' + authKey
                                    },
                                    body: JSON.stringify({ nonBlocking: reqData.nonBlocking })
                                };
                                request(options, (error: any, response: any, body: any) => {
                                    if (!error && response.body) {
                                        let resultData = JSON.parse(response.body);
                                        if (resStatus[0].identityStatus == "UNVERIFIED" && resultData.identityStatus == "VERIFIED") {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='" + resultData.identityStatus + "' WHERE `iduser`='" + sessdata.iduser + "' AND `brandId`='" + reqQry.brandId + "' AND `deleted`=0";
                                            obj.prepare();
                                            obj.execute((___error, resp) => {
                                                if (___error == 1) {
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                    obj.prepare();
                                                    obj.execute((____error, resp) => {
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                        iQry += "`amount`='-4', "
                                                        iQry += "`purpose`='Wallet amount successfully updated for Resubmit Brand', "
                                                        iQry += "`status`=1;"
                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                        })
                                                    })
                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + reqQry.brandId + "', '4', '" + Date.now() + "','7', 'Brand Re-Submitted')";
                                                    obj3.prepare();
                                                    obj3.execute((log_error, _resp) => {
                                                        if (log_error == 1) {
                                                            console.log("Brand Log Updated.");
                                                        }
                                                        else {
                                                            console.log("Brand Log Not Updated.");
                                                        }
                                                    });
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Brand Revet Successfully.", data: resStatus.identityStatus, status: 200 });
                                                    objv.execute();
                                                }
                                                else {
                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + reqQry.brandId + "', '', '" + Date.now() + "','8', 'Brand Re-Submit Failed')";
                                                    obj3.prepare();
                                                    obj3.execute((log_error, _resp) => {
                                                        if (log_error == 1) {
                                                            console.log("Brand Log Updated.");
                                                        }
                                                        else {
                                                            console.log("Brand Log Not Updated.");
                                                        }
                                                    });
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Brand Revet!", status: 502 });
                                                    objv.execute();
                                                }
                                            })
                                        }
                                        else {
                                            let obj3 = new ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + reqQry.brandId + "', '', '" + Date.now() + "','8', 'Brand Re-Submit Failed')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "No Change in Brand Status.", data: resStatus.identityStatus, status: 502 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: resStatus[0].field + ' ' + resStatus[0].description,
                                            status: resStatus[0].code
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Expired!", status: 503 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /****************************************
    * Get campaing's DID limit and counting *
    ****************************************/
    getCampaignDIDCount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let camp_key = sdata.type;
                let iduser = sdata.filter;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT did_limit, did_count FROM `campaign` WHERE campaign_key='" + camp_key + "' AND iduser='" + iduser + "' GROUP BY `campaign_key`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'DID Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /*********************
    * Get campaing's DID *
    **********************/

    public getCampaignDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let camp_key = sdata.type;
                let iduser = sdata.filter;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT did FROM `did_buy` WHERE camp_registry='" + camp_key + "' AND iduser='" + iduser + "' GROUP BY `did`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'DID Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************
    * Update CSP ID *
    ****************/
    updateCSPID(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessdata: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `account` SET `csp_id`= '" + sdata.csp_id + "' WHERE idaccount= '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "CSP ID Updated Successfully", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                })
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access", status: 401 });
                objv.execute();
            }
        })
    }

    /****************
    * Get CSP ID *
    ****************/
    getCspId(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `csp_id` FROM `account` WHERE idaccount='" + sessData.idaccount + "'";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'CSP ID Fatched', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /********************
  * CNP Campaigns Filters *
  ********************/

    public CNPcampaignFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let data = req.body.data;
            let condition: any = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += ''
                }
                if (sessdata.type == 2) {
                    conditionU += " AND c.`idaccount`='" + sessdata.idaccount + "'"
                }
                if (sessdata.type == 22) {
                    conditionU += " AND c.`iduser`='" + sessdata.iduser + "'"
                }

                if (data.brandId)
                    condition += 'b.`brandId` LIKE "%' + checkDesc(data.brandId) + '%" AND ';

                if (data.brand_name)
                    condition += 'b.`brand_name` LIKE "%' + checkDesc(data.brand_name) + '%" AND ';

                if (data.campaign_key)
                    condition += 'c.`campaign_key` LIKE "%' + checkDesc(data.campaign_key) + '%" AND ';

                if (data.usecase)
                    condition += 'c.`usecase`="' + data.usecase + '" AND ';

                //obj.qrysql = "SELECT * FROM `campaign` WHERE `iduser` = '" + sessdata.iduser + "' AND " + condition + " `status`=1 GROUP BY campaign_key";

                obj.qrysql = "SELECT c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.id_campaign,c.idaccount,c.iduser,c.usecase,c.start_date,c.did_count,c.did_limit,c.`status` FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + " c.`status`= '1' " + conditionU + " GROUP BY c.`campaign_key` ORDER BY c.`id_campaign` DESC";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Campaign List Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched CNP Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /********************
    * Get CNP Campaigns *
    ********************/
    public getCNPCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata = req.query;
            if (error == 1) {
                let condition = '';
                if (sessdata.type == 1) {
                    condition += ''
                }
                if (sessdata.type == 2) {
                    condition += "AND c.`idaccount`='" + sessdata.idaccount + "'"
                }
                if (sessdata.type == 22) {
                    condition += "AND c.`iduser`='" + sessdata.iduser + "'"
                }
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId, b.brand_name,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + sessdata.iduser + "' AND c.`status`= 1 GROUP BY campaign_key";
                obj.qrysql = "SELECT c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.id_campaign,c.idaccount,c.iduser,c.usecase,c.start_date,c.did_count,c.did_limit,c.`status` FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`status`= 1 " + condition + "  GROUP BY campaign_key ORDER BY c.`id_campaign` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
 * Get CNP Brand LIST *
 *****************/
    public getBrandCnpList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser: any = sessdata.iduser;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `brandId`,`iduser`,`company_name`,`website`,`displayName`,`status` FROM `brand` WHERE `status`= 1 ORDER BY `idbrand` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************************************
    * Send a mock webhook to your endpoint  *
    ****************************************/

    public mockWebhookEndpoint(req: Request, res: Response, next: NextFunction) {
        let reqQry: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let iduser: any = sessdata.iduser;
            if (error == 1) {
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'webhook/subscription/eventType/' + reqQry.eventType + '/mock',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                }
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let resData = JSON.parse(response.body);
                        if (resData.brandId && resData.brandId !== undefined) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Revet Successfully!", data: resData, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                            objv.execute();
                        }
                    }
                    // if (!error) {
                    //     let resData = JSON.parse(response.body);
                    //     if (resData.campaignId && resData.campaignId !== undefined) {
                    //         let obj = new ModelRawNonQuery(req, res);
                    //         obj.nonqrysql = "UPDATE `campaign` SET `campaign_description`='" + resData.description + "',`sample1`='" + resData.sample1 + "',`sample2`='" + resData.sample2 + "',`sample3`='" + resData.sample3 + "',`sample4`='" + resData.sample4 + "',`sample5`='" + resData.sample5 + "',`messageFlow`='" + resData.messageFlow + "',`helpMessage`='" + resData.helpMessage + "',`optinKeywords`='" + resData.optinKeywords + "',`optoutKeywords`='" + resData.optoutKeywords + "',`helpKeywords`='" + resData.helpKeywords + "',`optinMessage`='" + resData.optinMessage + "',`optoutMessage`='" + resData.optoutMessage + "',`autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "' WHERE `campaign_key`='" + campId + "' AND `iduser`='" + iduser + "'";
                    //         obj.prepare();
                    //         obj.execute((___error, resp) => {
                    //             if (!error) {
                    //                 let objv = new RawView(res);
                    //                 objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: resData });
                    //                 objv.execute();
                    //             }
                    //             else {
                    //                 let objv = new RawView(res);
                    //                 objv.prepare({ message: "Campaign details Not updated", data: resData, status: 501 });
                    //                 objv.execute();
                    //             }
                    //         })
                    //     }
                    //     else {
                    //         let objv = new RawView(res);
                    //         objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                    //         objv.execute();
                    //     }
                    // }
                    // else {
                    //     let objv = new RawView(res);
                    //     objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                    //     objv.execute();
                    // }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /**************************************************************************
    * End Brand Functionality  ************************************************
    **************************************************************************/

    /***************************************************************************
    * Start Campaign Functionality *********************************************
    ***************************************************************************/
    public campaignFilterForBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let Cdata: any = JSON.parse(req.body.data);
            let data = Cdata.companyFilter;
            let condition: any = "";

            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                if (data.usecase)
                    condition += '`usecase`="' + data.usecase + '" AND ';

                if (data.description)
                    condition += '`campaign_description` LIKE "%' + data.description + '%" AND ';

                if (data.campaignId)
                    condition += '`campaign_key` LIKE "%' + data.campaignId + '%" AND ';

                obj.qrysql = "SELECT `campaign_key`,`usecase`,`campaign_description`,DATE_FORMAT(start_date,'%Y-%m-%d')`start_date` FROM `campaign` WHERE " + condition + " `idbrand` = '" + Cdata.brandId + "'AND iduser='" + Cdata.iduser + "' AND `deleted`=0 GROUP BY campaign_key";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaignByBrandId(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let brandId: any = req.query.type !== undefined ? JSON.parse(data.type).brandId : req.query.brandId
                let iduser: any = req.query.type !== undefined ? JSON.parse(data.type).iduser : sessdata.iduser
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `campaign_key`,`iduser`,`usecase`,`campaign_description`,DATE_FORMAT(start_date,'%Y-%m-%d')`start_date` FROM `campaign` WHERE `idbrand` = '" + brandId + "'AND iduser='" + iduser + "' AND `status`=0 AND `deleted`=0 GROUP BY campaign_key";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getSwaggerCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata: any = req.query;
            let iduser: any = sessdata.iduser;
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata: any = req.query;
            // let iduser: any = sdata.type == 'main' ? JSON.parse(sdata.type).iduser : sessdata.iduser;
            //let iduser: any = sdata.type.iduser !== undefined ? sdata.type.iduser : JSON.parse(sdata.type).iduser;
            let condition = '';
            if (sessdata.type == 1) {
                condition += ''
            }
            if (sessdata.type == 2) {
                condition += "c.`idaccount`='" + sessdata.idaccount + "' AND"
            }
            if (sessdata.type == 22) {
                condition += "c.`iduser`='" + sessdata.iduser + "' AND"
            }
            let ext_field: any = "c.iduser,c.idaccount,";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, "+ext_field+" c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                // obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, " + ext_field + " c.campaign_key,c.id_campaign,c.usecase,c.start_date,c.did_count,c.did_limit,c.campaign_description FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`deleted` = 0 "+condition+" AND c.`status`=0 GROUP BY campaign_key ORDER BY c.`id_campaign` DESC";
                //obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, " + ext_field + " c.campaign_key,c.id_campaign,c.usecase,c.start_date,c.did_count,c.did_limit,c.campaign_description,c.deleted FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + "  c.`status`=0 GROUP BY campaign_key ORDER BY c.`id_campaign` DESC";
                obj.qrysql = "SELECT b.brandId,b.brand_name, " + ext_field + " c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + "  c.`status`=0 GROUP BY campaign_key ORDER BY c.`id_campaign` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaignForReview(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata: any = req.query;
            let idaccount = JSON.parse(sdata.type).idaccount
            let ext_field: any = "c.iduser,c.idaccount,";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, "+ext_field+" c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, " + ext_field + " c.campaign_key,c.id_campaign,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`idaccount` = '" + idaccount + "' AND c.`deleted` = 0 GROUP BY campaign_key ORDER BY c.`id_campaign` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // Get Campaign For Admin
    public getCampaignForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata = req.query;
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `campaign` WHERE `deleted`=0 AND `status`=0 GROUP BY `campaign_key`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Loaded Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaignCases(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let id: any;
        let options: any = {
            'method': 'Get',
            'url': apiUrl + 'enum/usecase',
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + authKey
            }
        };

        request(options, (_err: any, response: any, body: any) => {
            if (response.body) {
                let data = JSON.parse(response.body);
                if (!_err) {
                    /*let tmp:any=[];
                    Object.entries(data).forEach((ele:any)=>{
                      let t=ele[1];
                      t["isDisable"] = false;
                      t["name"]=ele[0];
                      tmp.push(t);
                    });

                    console.log(tmp);

                    let tmpqurty="INSERT INTO `campaign_cases` (`name`, `displayName`, `minSubUsecases`, `maxSubUsecases`, `validSubUsecase`, `classification`) VALUES ";
                    tmp.forEach((campaignData: any) => {
                        console.log(campaignData, "campData");
                        tmpqurty += "('"+campaignData.name+"', '"+campaignData.displayName+"', '"+campaignData.minSubUsecases+"', '"+campaignData.maxSubUsecases+"', '"+campaignData.validSubUsecase+"', '"+campaignData.classification+"'),";
                    });
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql =tmpqurty.slice(0, -1);
                    obj.prepare();
                    obj.execute((_error: any, data: any) => {
                        if(data.length > 0){
                            let objv = new RawView(res);
                            objv.prepare({ message: "Cases Fetched Successfully!", data: data });
                            objv.execute();
                        }
                        else{
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", error: _error });
                            objv.execute();
                        }
                    });*/
                    let objv = new RawView(res);
                    objv.prepare({ message: "Campaign Cases Fetched!", data: data, status: 200 });
                    objv.execute();
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Connection!", error: data, status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Something Went Wrong With Connection!", error: _err, status: 502 });
                objv.execute();
            }
        });
    }

    public campaignCases(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata = req.query;
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idcamp_cases`,`name`,`displayName`,`minSubUsecases`,`validSubUsecase`,`maxSubUsecases`,`rate`,`classification`,`nrc_rates`,`service_limit`,`description` FROM `campaign_cases`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Case Fetches",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    addCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campData = req.body;
                let id: any;
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'partnerCampaign/' + campData.campaign_key + '/sharing',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (_err: any, response: any, body: any) => {
                    let data = JSON.parse(response.body);
                    if (response.statusCode == 200) {
                        if (!_err) {
                            let obj5 = new ModelRawQuery(req, res);
                            obj5.qrysql = "SELECT * FROM `campaign` WHERE `campaign_key` = '" + campData.campaign_key + "'";
                            obj5.prepare();
                            obj5.execute((_error: any, campaign: any) => {
                                if (_error == 1) {
                                    //-- Get SMS Provider 
                                    obj5.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                                    obj5.prepare();
                                    obj5.execute((proerr: any, provider: any) => {
                                        if (proerr == 1 && provider.length > 0) {
                                            if (campaign.length > 0) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: "Campaign Already Exists!",
                                                    status: 404
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let tmp: any = [];
                                                let options: any = {
                                                    'method': 'PUT',
                                                    'url': apiUrl + 'partnerCampaign/' + data.campaignId + '/sharing/' + provider[0].username,
                                                    'headers': {
                                                        'Content-Type': 'application/json',
                                                        'Authorization': 'Basic ' + authKey
                                                    }
                                                };
                                                request(options, (error: any, response: any, body: any) => {
                                                    let partnerCampaign = JSON.parse(response.body);
                                                    if (response.statusCode == 200) {
                                                        let obj = new ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idbrand`,`campaign_key`, `campaign_name`, `status`) VALUES ('" + sessdata.iduser + "','" + campData.brandId + "', '" + campData.campaign_key + "', '" + campData.campaignName + "', '1')";
                                                        obj.prepare();
                                                        obj.execute((__error: any, data: any) => {
                                                            if (__error == 1) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Campaign Added Successfully!", result: data, status: 201 });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Something Went Wrong With Connection!", error: data, status: 502 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: data[0].field + " " + data[0].description, error: error, status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                status: 502,
                                                message: "Service Profile not found!",
                                                error: proerr,
                                                campaignId: null
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", error: campaign, status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: data[0].field + " " + data[0].description, status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: data[0].field + " " + data[0].description, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public registerCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let campData: any = req.body;
                let objb = new ModelRawQuery(req, res);
                objb.qrysql = "SELECT brandId,entityType,identityStatus From `brand` WHERE `brandId`='" + campData.brandId + "' AND `entityType`='SOLE_PROPRIETOR' AND `deleted`=0";
                objb.prepare();
                objb.execute((bError, bRes) => {
                    if (bError == 1 && bRes.length > 0) {
                        let objc = new ModelRawQuery(req, res);
                        objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0";
                        objc.prepare();
                        objc.execute((cError, cRes) => {
                            if (cError == 1 && cRes.length < 1) {
                                // fOR Sole proprietor
                                let fun = new NewCampaign();
                                fun.inRegisterCampaign(req, res, next);
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded " + campData.brandId, status: 502 });
                                objv.execute();

                            }
                        })
                    }
                    else {
                        // FOR any entity type 
                        let fun = new NewCampaign();
                        fun.inRegisterCampaign(req, res, next);
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public inRegisterCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let campData: any = req.body;

                campData.optinKeywords = campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                campData.optoutKeywords = campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                campData.helpKeywords = campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');

                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                obj0.prepare();
                obj0.execute((campError, camp) => {
                    if (campError == 1 && camp.length > 0) {
                        //-- Get SMS Provider 
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                        obj1.prepare();
                        obj1.execute((proerr: any, provider: any) => {
                            if (proerr == 1 && provider.length > 0) {

                                let CRate: any = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0
                                let __rate: any = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0
                                let __nrc_rates: any = typeof camp[0].nrc_rates != 'undefined' && camp[0].nrc_rates > 0 ? camp[0].nrc_rates : 0

                                if (CRate > 0) {
                                    let Obj = new ModelRawQuery(req, res);
                                    Obj.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + CRate + "'";
                                    Obj.prepare();
                                    Obj.execute((bErr: any, bRes) => {
                                        if (bErr == 1) {
                                            if (bRes.length > 0) {
                                                var key: any;
                                                let options: any = {
                                                    'method': 'POST',
                                                    'url': apiUrl + 'campaignBuilder',
                                                    'headers': {
                                                        'Content-Type': 'application/json',
                                                        'Authorization': 'Basic ' + authKey
                                                    },
                                                    body: JSON.stringify(campData)
                                                };
                                                request(options, (error: any, response: any, body: any) => {
                                                    if (!error) {
                                                        let resData = JSON.parse(response.body);
                                                        if (resData.campaignId) {
                                                            let tmp: any = [];
                                                            let options: any = {
                                                                'method': 'PUT',
                                                                'url': apiUrl + 'partnerCampaign/' + resData.campaignId + '/sharing/' + provider[0].username,
                                                                'headers': {
                                                                    'Content-Type': 'application/json',
                                                                    'Authorization': 'Basic ' + authKey
                                                                }
                                                            };

                                                            request(options, (error: any, response: any, body: any) => {
                                                                let partnerCampaign = JSON.parse(response.body);
                                                                if (response.body) {
                                                                    Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                                                                        let t = ele[1];
                                                                        t["class"] = ele[0];
                                                                        tmp.push(t);
                                                                    });
                                                                    let campaignData1 = tmp;
                                                                    let obj00 = new ModelRawNonQuery(req, res);
                                                                    obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`campaign_key`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `downstreamCnpId`, `upstreamCnpId`, `sharingStatus`, `sharedDate`, `statusDate`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + campData.brandId + "', '" + resData.campaignId + "','" + campData.campaignName + "', '" + campData.embeddedLink + "', '" + campData.embeddedPhone + "','" + checkDescription(campData.description) + "', '" + checkDescription(campData.messageFlow) + "', '" + checkDescription(campData.optinMessage) + "', '" + checkDescription(campData.optinKeywords) + "', '" + checkDescription(campData.optoutMessage) + "', '" + checkDescription(campData.optoutKeywords) + "', '" + checkDescription(campData.helpMessage) + "', '" + checkDescription(campData.helpKeywords) + "', '" + partnerCampaign.downstreamCnpId + "', '" + partnerCampaign.upstreamCnpId + "', '" + partnerCampaign.sharingStatus + "', '" + partnerCampaign.sharedDate + "', '" + partnerCampaign.statusDate + "', '" + campData.vertical + "', '" + checkDescription(campData.sample1) + "', '" + checkDescription(campData.sample2) + "', '" + checkDescription(campData.sample3) + "', '" + checkDescription(campData.sample4) + "', '" + checkDescription(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + campData.termsAndConditions + "', '" + campData.numberPool + "', '" + campData.ageGated + "', '" + campData.directLending + "', '" + camp[0].service_limit + "','" + campData.subscriberOptin + "','" + campData.subscriberOptout + "','" + campData.subscriberHelp + "')";

                                                                    obj00.prepare();
                                                                    obj00.execute((_errorr: any, data: any) => {
                                                                        if (_errorr == 1) {
                                                                            //insert mno
                                                                            let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`campaign_key`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`) VALUES";
                                                                            campaignData1.forEach((campaignData: any) => {
                                                                                campMno += "('" + sessdata.iduser + "','" + sessdata.idaccount + "', '" + resData.campaignId + "', '" + campaignData.class + "','" + campaignData.minMsgSamples + "', '" + campaignData.mno + "', '" + campaignData.mnoReview + "', '" + campaignData.mnoSupport + "', '" + campaignData.msgClass + "','" + campaignData.noEmbeddedLink + "','" + campaignData.noEmbeddedPhone + "','" + campaignData.qualify + "', '" + campaignData.reqSubscriberHelp + "', '" + campaignData.reqSubscriberOptin + "', '" + campaignData.reqSubscriberOptout + "','" + campaignData.brandTier + "','" + campaignData.tpm + "','" + campaignData.mmsTpm + "','" + campaignData.tpmScope + "','" + campaignData.brandDailyCap + "','" + campaignData.surcharge + "','" + campaignData.tpn + "'),";
                                                                            });
                                                                            let obj01 = new ModelRawNonQuery(req, res);
                                                                            obj01.nonqrysql = campMno.slice(0, -1);
                                                                            obj01.prepare();
                                                                            obj01.execute((_errorr: any, campMnoData: any) => {

                                                                            })

                                                                            //Update Campaign
                                                                            let fun = new NewCampaign();
                                                                            fun.updateinRegisterCampaign(req, resData.campaignId, res, next);

                                                                            // // To brand Log Update
                                                                            // let obj3 = new ModelRawNonQuery(req, res);
                                                                            // obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `campaign_key`,`cost`, `date`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', '" + __rate + "', '" + Date.now() + "','" + __nrc_rates + "','3','Campaign Registered in this Brand')";
                                                                            // obj3.prepare();
                                                                            // obj3.execute((___error, _resp) => {
                                                                            //     if (___error == 1) {
                                                                            //         console.log("Brand Log Updated Successfully.");
                                                                            //     }
                                                                            //     else {
                                                                            //         console.log("Brand Log Not Updated!");
                                                                            //     }
                                                                            // });
                                                                            // To Campaign Log Update
                                                                            let obj4 = new ModelRawNonQuery(req, res);
                                                                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', '" + __rate + "','" + __nrc_rates + "','1','Campaign Registered')";
                                                                            obj4.prepare();
                                                                            obj4.execute((campErr, __resp) => {
                                                                                if (campErr == 1) {
                                                                                    console.log("Campaign Log Updated Successfully.");
                                                                                }
                                                                                else {
                                                                                    console.log("Campaign Log Not Updated!");
                                                                                }
                                                                            });
                                                                            // To brand Log Update
                                                                            let obj2 = new ModelRawNonQuery(req, res);
                                                                            obj2.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                                            obj2.prepare();
                                                                            obj2.execute((__error, resp) => {
                                                                                if (__error == 1) {
                                                                                    // To Insert Data in wallet_recharge_log 
                                                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                                    iQry += "`amount`='-" + CRate + "', "
                                                                                    iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "
                                                                                    iQry += "`status`=1;"
                                                                                    let objWL = new ModelRawNonQuery(req, res);
                                                                                    objWL.nonqrysql = iQry
                                                                                    objWL.prepare()
                                                                                    objWL.execute((error: any, result: any) => {
                                                                                        console.log("Transaction response::", result)
                                                                                    })
                                                                                }
                                                                                else {
                                                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                                    iQry += "`amount`='-" + CRate + "', "
                                                                                    iQry += "`purpose`='Wallet amount not successfully updated for campaign registration', "
                                                                                    iQry += "`status`=2;"
                                                                                    let objWL = new ModelRawNonQuery(req, res);
                                                                                    objWL.nonqrysql = iQry
                                                                                    objWL.prepare()
                                                                                    objWL.execute((error: any, result: any) => {
                                                                                        console.log("Transaction response::", result)
                                                                                    })
                                                                                    console.log("Wallet Not Updated!")
                                                                                }
                                                                            });
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ status: 201, message: "Campaign Registered Successfully!", campaignId: resData.campaignId, data: resData });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Campaign Detail Error.", error: error, status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    // To brand Log Update
                                                                    // let obj3 = new ModelRawNonQuery(req, res);
                                                                    // obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `campaign_key`,`cost`, `date`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', '" + __rate + "', '" + Date.now() + "','" + __nrc_rates + "','4','Campaign Register failed in this Brand')";
                                                                    // obj3.prepare();
                                                                    // obj3.execute((___error, _resp) => {
                                                                    //     if (___error == 1) {
                                                                    //         console.log("Brand Log Updated Successfully.");
                                                                    //     }
                                                                    //     else {
                                                                    //         console.log("Brand Log Not Updated!");
                                                                    //     }
                                                                    // });
                                                                    // To Campaign Log Update
                                                                    let obj4 = new ModelRawNonQuery(req, res);
                                                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', '" + __rate + "','" + __nrc_rates + "','2','Campaign Register Failed')";
                                                                    obj4.prepare();
                                                                    obj4.execute((campErr, __resp) => {
                                                                        if (campErr == 1) {
                                                                            console.log("Campaign Log Updated Successfully.");
                                                                        }
                                                                        else {
                                                                            console.log("Campaign Log Not Updated!");
                                                                        }
                                                                    });
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Campaign Not Registered!", error: error, status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: resData[0].field + " " + resData[0].description, status: 502 });
                                                            objv.execute();
                                                        }
                                                    }
                                                });

                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ error: bErr, message: "Please add funds to your account or contact support.", status: 503 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ error: bErr, message: "Something Went Wrong to Fetch Account Balance!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                    iQry += "`amount`='-" + CRate + "', "
                                    iQry += "`purpose`='Billing prorate should be greater then 0 to register a campaign', "
                                    iQry += "`status`=2;"

                                    let objWL = new ModelRawNonQuery(req, res);
                                    objWL.nonqrysql = iQry
                                    objWL.prepare()
                                    objWL.execute((error: any, result: any) => {
                                        console.log("Transaction response::", result)
                                    })

                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Billing prorate should be greater then 0 to register a campaign!",
                                        error: ""
                                    });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Service Profile not found!",
                                    error: proerr,
                                    campaignId: null
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Error With Fatching Campaign Rates!",
                            error: camp,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public updateinRegisterCampaign(req: Request, campaignId: any, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let campData: any = req.body;
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campaignId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                };
                request(options, (errorr: any, response: any, body: any) => {
                    if (!errorr) {
                        let getCamp = JSON.parse(response.body);
                        if (getCamp.campaignId && getCamp.campaignId !== undefined) {
                            let obj01 = new ModelRawNonQuery(req, res);
                            obj01.nonqrysql = "UPDATE `campaign` SET `campaign_status`='" + getCamp.status + "',`nextRenewalOrExpirationDate`='" + getCamp.nextRenewalOrExpirationDate + "',`billedDate`='" + getCamp.billedDate + "',`createDate`='" + getCamp.createDate + "' WHERE `campaign_key`='" + getCamp.campaignId + "' AND `iduser`='" + sessdata.iduser + "' AND `deleted`=0";
                            obj01.prepare();
                            obj01.execute((____error, resp) => {
                                if (!____error) {
                                    console.log("nextRenewalOrExpirationDate updated");
                                }
                                else {
                                    console.log("nextRenewalOrExpirationDate not updated");
                                }
                            })
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: getCamp[0].field + " " + getCamp[0].description, error: getCamp, status: getCamp[0].code });
                            objv.execute();
                        }
                    }
                });

            }
        })

    }

    public CampaignRegister(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let campData: any = req.body;
                let CRate: any = typeof campData.rate != 'undefined' && campData.rate > 0 ? campData.rate : 0

                //-- Get SMS Provider 
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                obj1.prepare();
                obj1.execute((proerr: any, provider: any) => {
                    if (proerr == 1 && provider.length > 0) {
                        if (CRate > 0) {
                            let objv = new RawView(res);
                            if (campData.brandId) {
                                var key: any;
                                let options: any = {
                                    'method': 'POST',
                                    'url': apiUrl + 'campaignBuilder',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': 'Basic ' + authKey
                                    },
                                    body: JSON.stringify(campData)
                                };
                                request(options, (error: any, response: any, body: any) => {
                                    let body2: any = {}
                                    try {
                                        body2 = JSON.parse(body)
                                    } catch {
                                        body2 = body
                                    }
                                    let campaignId: any = typeof body2.campaignId != 'undefined' ? body2.campaignId : ""
                                    if (!error) {
                                        let resData = JSON.parse(response.body);
                                        if (resData.campaignId) {
                                            let tmp: any = [];
                                            let options: any = {
                                                'method': 'PUT',
                                                'url': apiUrl + 'partnerCampaign/' + resData.campaignId + '/sharing/' + provider[0].username,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            request(options, (error: any, response: any, body: any) => {
                                                let partnerCampaign = JSON.parse(response.body);
                                                if (response.body) {
                                                    Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                                                        let t = ele[1];
                                                        t["class"] = ele[0];
                                                        tmp.push(t);
                                                    });
                                                    let campaignData1 = tmp;
                                                    let tmpqurty = "INSERT INTO `campaign` (`iduser`,`idbrand`,`campaign_key`, `campaign_class`, `campaign_name`, `minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`, `surcharge`, `tpn`, `brandTier`, `campaign_description`, `downstreamCnpId`, `upstreamCnpId`, `sharingStatus`, `sharedDate`, `statusDate`) VALUES ";
                                                    campaignData1.forEach((campaignData: any) => {
                                                        tmpqurty += "('" + sessdata.iduser + "','" + campData.brandId + "', '" + resData.campaignId + "', '" + campaignData.class + "', '" + campData.campaignName + "', '" + campaignData.minMsgSamples + "', '" + campaignData.mno + "', '" + campaignData.mnoReview + "', '" + campaignData.mnoSupport + "', '" + campaignData.msgClass + "', '" + campaignData.noEmbeddedLink + "', '" + campaignData.noEmbeddedPhone + "', '" + campaignData.qualify + "', '" + campaignData.reqSubscriberHelp + "', '" + campaignData.reqSubscriberOptin + "', '" + campaignData.reqSubscriberOptin + "', '" + campaignData.surcharge + "', '" + campaignData.tpn + "', '" + campaignData.brandTier + "', '" + campData.description + "', '" + partnerCampaign.downstreamCnpId + "', '" + partnerCampaign.upstreamCnpId + "', '" + partnerCampaign.sharingStatus + "', '" + partnerCampaign.sharedDate + "', '" + partnerCampaign.statusDate + "'),";
                                                    });

                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = tmpqurty.slice(0, -1);
                                                    obj.prepare();
                                                    obj.execute((_error: any, data: any) => {
                                                        if (_error == 1) {

                                                            if (campData.rate) {
                                                                obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                                obj.prepare();
                                                                obj.execute((__error, resp) => {
                                                                    if (__error == 1) {

                                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                                        iQry += "`amount`='-" + CRate + "', "

                                                                        iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "

                                                                        iQry += "`status`=1;"

                                                                        let objWL = new ModelRawNonQuery(req, res);
                                                                        objWL.nonqrysql = iQry
                                                                        objWL.prepare()
                                                                        objWL.execute((error: any, result: any) => {
                                                                            console.log("Transaction response::", result)
                                                                        })
                                                                        let obj3 = new ModelRawNonQuery(req, res);
                                                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `campaign_key`,`cost`, `date`, `description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + resData.campaignId + "', '" + campData.rate + "', '" + Date.now() + "', 'Campaign_Rate')";
                                                                        obj3.prepare();
                                                                        obj3.execute((___error, resp) => {
                                                                            if (___error == 1) {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ status: 201, message: "Campaign Register Successfully!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let obj2 = new ModelRawQuery(req, res);
                                                                obj2.qrysql = "SELECT * From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                                                                obj2.prepare();
                                                                obj2.execute((campError, camp) => {
                                                                    if (campError == 1) {

                                                                        let CRate: any = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0

                                                                        obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                                        obj.prepare();
                                                                        obj.execute((__error, resp) => {
                                                                            if (__error == 1) {

                                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                                                iQry += "`amount`='-" + CRate + "', "

                                                                                iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "

                                                                                iQry += "`status`=1;"

                                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                                objWL.nonqrysql = iQry
                                                                                objWL.prepare()
                                                                                objWL.execute((error: any, result: any) => {
                                                                                    console.log("Transaction response::", result)
                                                                                })

                                                                                let obj3 = new ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`campaign_key`,`cost`, `date`, `description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', '" + camp[0].rate + "', '" + Date.now() + "', 'Campaign_Rate')";
                                                                                obj3.prepare();
                                                                                obj3.execute((___error, resp) => {
                                                                                    if (___error == 1) {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ status: 201, message: "Campaign Register Successfully!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            objv.prepare({
                                                                message: "Something Went Wrong With Conection!",
                                                                error: error,
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    objv.prepare({
                                                        message: "Something Went Wrong With Connection!",
                                                        error: error,
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            objv.prepare({
                                                message: resData[0].field + " " + resData[0].description,
                                                error: "Campaign did not registered!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        objv.prepare({
                                            message: "Something Went Wrong With Connection!",
                                            error: error,
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                objv.prepare({
                                    err: 401,
                                    message: "brandId is mendatory field!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        }
                        else {
                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                            iQry += "`idaccount`=" + sessdata.idaccount + ", "

                            iQry += "`amount`='-" + CRate + "', "

                            iQry += "`purpose`='Billing prorate should be greater then 0 to register a campaign', "

                            iQry += "`status`=2;"

                            let objWL = new ModelRawNonQuery(req, res);
                            objWL.nonqrysql = iQry
                            objWL.prepare()
                            objWL.execute((error: any, result: any) => {
                                console.log("Transaction response::", result)
                            })

                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Billing prorate should be greater then 0 to register a campaign!",
                                error: ""
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Service Profile not found!",
                            error: proerr,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
        });
    }

    public mnoIddetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/mno',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "MNO Details Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With MNO Details Fetched!", error: error, status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
    * get campaign details based on campaign id  *
    *********************************************/

    public getCampDetailById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name,c.iduser,c.idaccount,c.reqSubscriberOptin,c.reqSubscriberOptout,c.reqSubscriberHelp,c.campaign_key,c.usecase,c.start_date,c.sharedDate,c.statusDate,c.subUsecases,c.campaign_description,c.sample1,c.sample2,c.sample3,c.sample4,c.sample5,c.messageFlow,c.helpMessage,c.optinMessage,c.optoutMessage,c.optinKeywords,c.optoutKeywords,c.helpKeywords,c.autoRenewal,c.noEmbeddedLink,c.noEmbeddedPhone,c.affiliateMarketing,c.termsAndConditions,c.numberPool,c.ageGated,c.directLending,c.subscriberOptin,c.subscriberOptout,c.subscriberHelp,c.nextRenewalOrExpirationDate FROM `campaign`c INNER JOIN `brand`b ON b.brandId = c.idbrand WHERE `campaign_key`='" + sdata.campId + "' AND c.`iduser` = '" + sdata.iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.qrysql = "SELECT b.brandId,b.brand_name,b.deleted `brand_deleted`,b.identityStatus,c.iduser,c.idaccount,c.reqSubscriberOptin,c.reqSubscriberOptout,c.reqSubscriberHelp,c.campaign_key,c.usecase,c.start_date,c.sharedDate,c.statusDate,c.subUsecases,c.campaign_description,c.sample1,c.sample2,c.sample3,c.sample4,c.sample5,c.messageFlow,c.helpMessage,c.optinMessage,c.optoutMessage,c.optinKeywords,c.optoutKeywords,c.helpKeywords,c.autoRenewal,c.noEmbeddedLink,c.noEmbeddedPhone,c.affiliateMarketing,c.termsAndConditions,c.numberPool,c.ageGated,c.directLending,c.subscriberOptin,c.subscriberOptout,c.subscriberHelp,c.nextRenewalOrExpirationDate,c.deleted FROM `campaign`c INNER JOIN `brand`b ON b.brandId = c.idbrand WHERE `campaign_key`='" + sdata.campId + "' AND c.`iduser` = '" + sdata.iduser + "' GROUP BY campaign_key";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    /*********************************************
    * get campaign Mno details based on campaign id  *
    *********************************************/

    public getMnoMetaDataDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,usecase,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE brandDailyCap END )`brandDailyCap` FROM `campaign` WHERE `campaign_key`='" + sdata.campId + "' AND `iduser`='" + sdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Mno Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Mno Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    public getCampMnoMetaDataDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE brandDailyCap END )`brandDailyCap` FROM `campaign_mno` WHERE `campaign_key`='" + sdata.campId + "' AND `iduser`='" + sdata.iduser + "'";
                obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE CASE WHEN brandDailyCap ='null' THEN 'No' ELSE brandDailyCap END END )`brandDailyCap` FROM `campaign_mno` WHERE `campaign_key`='" + sdata.campId + "' AND `iduser`='" + sdata.iduser + "'";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Mno Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Mno Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getMnoMetaDataForRegister(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let data: any = req.query;
            let brandId: any = data.type !== undefined ? JSON.parse(data.type).brandId : data.brandId;
            let usecase: any = data.type !== undefined ? JSON.parse(data.type).usecase : data.usecase;
            if (error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaignBuilder/brand/' + brandId + '/usecase/' + usecase,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let data = JSON.parse(response.body);
                        if (data.mnoMetadata && data.mnoMetadata != undefined) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Mno Meta Details Records Fetched!", data: data.mnoMetadata, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: data[0].field + " " + data[0].description, status: data[0].code });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With API!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public brandQualifyAllUseCases(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let data: any = req.query;
            let brandId: any = data.type !== undefined ? JSON.parse(data.type).brandId : data.brandId;
            if (error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaignBuilder/brand/' + brandId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let data = JSON.parse(response.body);
                        if (data && data != undefined) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Use Case Records Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: data[0].field + " " + data[0].description, status: data[0].code });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Use Case!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getConnPartnersDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/cnp',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Connectivity Partners Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getResellerDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'reseller/RAP07Z4',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        if (response.body) {
                            let data = JSON.parse(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Reseller Records Fetched!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Reseller Records Not Fetched!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getMNOList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/mno',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error && response.body) {
                        let data = JSON.parse(response.body);
                        let objv = new RawView(res);
                        objv.prepare({ message: "MNO ID's Fetched Successfully!", data: data, status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetched MNO ID's!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public mnoMetaData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campId = req.query;
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaign/' + campId.campaignId + '/mnoMetadata',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error && response.body) {
                        let data = JSON.parse(response.body);
                        let objv = new RawView(res);
                        objv.prepare({ message: "MNO MetaData Fetched successfully!", data: data, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "MNO MetaData Not Fetched!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campId = req.query;
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaign/' + campId.campaignId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let data = JSON.parse(response.body);
                        delete data.cspId;
                        delete data.mock;
                        delete data.resellerId;
                        if (data.campaignId && data.campaignId !== undefined) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Campaign Details Fetched successfully!", data: data, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: data[0].field + " " + data[0].description, error: data, status: data[0].code });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Campaign Detail!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************
    * 's AutoRenual * 
    ****************/
    public updateCamapign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let reqData: any = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
            let campId: any = req.body.data !== undefined ? JSON.parse(req.body.data).campId : req.query.campaignId;
            let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
            var resultAllCampaign = [];
            for (var i in reqData) {
                // reqData[i] !== '' &&
                if (reqData[i] !== 'undefined') {
                    resultAllCampaign.push([i, reqData[i]]);
                }
            }
            let campData = Object.fromEntries(resultAllCampaign);
            
            campData.optinKeywords = campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
            campData.optoutKeywords = campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
            campData.helpKeywords = campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');

            if (error == 1) {
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                }
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let resData = JSON.parse(response.body);
                        if (resData.campaignId && resData.campaignId !== undefined) {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `campaign` SET `campaign_description`='" + checkDescription(resData.description) + "',`sample1`='" + checkDescription(resData.sample1) + "',`sample2`='" + checkDescription(resData.sample2) + "',`sample3`='" + checkDescription(resData.sample3) + "',`sample4`='" + checkDescription(resData.sample4) + "',`sample5`='" + checkDescription(resData.sample5) + "',`messageFlow`='" + checkDescription(resData.messageFlow) + "',`helpMessage`='" + checkDescription(resData.helpMessage) + "',`optinKeywords`='" + checkDescription(resData.optinKeywords) + "',`optoutKeywords`='" + checkDescription(resData.optoutKeywords) + "',`helpKeywords`='" + checkDescription(resData.helpKeywords) + "',`optinMessage`='" + checkDescription(resData.optinMessage) + "',`optoutMessage`='" + checkDescription(resData.optoutMessage) + "',`autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "',`subscriberOptin`='" + resData.subscriberOptin + "',`subscriberOptout`='" + resData.subscriberOptout + "',`subscriberHelp`='" + resData.subscriberHelp + "',`noEmbeddedLink`='" + resData.embeddedLink + "',`noEmbeddedPhone`='" + resData.embeddedPhone + "',`termsAndConditions`='" + resData.termsAndConditions + "',`numberPool`='" + resData.numberPool + "',`ageGated`='" + resData.ageGated + "',`directLending`='" + resData.directLending + "',`affiliateMarketing`='" + resData.affiliateMarketing + "',`nextRenewalOrExpirationDate`='" + resData.nextRenewalOrExpirationDate + "',`billedDate`='" + resData.billedDate + "',`createDate`='" + resData.createDate + "' WHERE `campaign_key`='" + campId + "' AND `iduser`='" + iduser + "' AND `deleted`=0";
                            obj.prepare();
                            obj.execute((___error, resp) => {
                                if (!error) {
                                    delete resData.cspId;
                                    delete resData.mock;
                                    delete resData.resellerId;
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: resData });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Campaign details Not updated!", data: resData, status: 501 });
                                    objv.execute();
                                }
                            })

                            // To Campaign Log Update
                            let obj4 = new ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campId + "', '','','3','Campaign Updated')";
                            obj4.prepare();
                            obj4.execute((campErr, __resp) => {
                                if (campErr == 1) {
                                    console.log("Campaign Log Updated Successfully.");
                                }
                                else {
                                    console.log("Campaign Log Not Updated!");
                                }
                            });
                        }
                        else {
                            // To Campaign Log Update
                            let obj4 = new ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campId + "', '','','4','Campaign Update Failed')";
                            obj4.prepare();
                            obj4.execute((campErr, __resp) => {
                                if (campErr == 1) {
                                    console.log("Campaign Log Updated Successfully.");
                                }
                                else {
                                    console.log("Campaign Log Not Updated!");
                                }
                            });
                            let objv = new RawView(res);
                            objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*******************************
    *  Update Campaign's AutoRenual*
    *******************************/

    public updateAutoRenualCampaign(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let reqData: any = req.body;
            let campId: any = req.query.campaignId;
            let iduser: any = sessdata.iduser;
            var reqCampaign = [];
            for (var i in reqData) {
                if (reqData[i] !== '' && reqData[i] !== 'undefined') {
                    reqCampaign.push([i, reqData[i]]);
                }
            }
            let campData = Object.fromEntries(reqCampaign);
            if (error == 1) {
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                }
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        let resData = JSON.parse(response.body);
                        if (resData.campaignId && resData.campaignId !== undefined) {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `campaign` SET `autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "' WHERE `campaign_key`='" + campId + "' AND `iduser`='" + iduser + "' AND `deleted`=0";
                            obj.prepare();
                            obj.execute((___error, resp) => {
                                if (!error) {
                                    delete resData.cspId;
                                    delete resData.mock;
                                    delete resData.resellerId;
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 200, message: "Auto Renewal Updated Successfully!", data: resData });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Auto Renewal Not updated", data: resData, status: 501 });
                                    objv.execute();
                                }
                            })
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deleteCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let campID = req.query.id && req.query.id !== undefined ? req.query.id : req.query.campaignId;
            if (error == 1) {
                let options: any = {
                    'method': 'DELETE',
                    'url': apiUrl + 'campaign/' + campID,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if ((response.statusCode == 204 && response.statusCode !== undefined) || (JSON.parse(body)[0].code == 502 && JSON.parse(body)[0].code !== undefined)) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `campaign` SET `deleted`=1, `delete_date`=NOW() WHERE `campaign_key`='" + campID + "' AND `iduser`='" + sessdata.iduser + "'";
                        obj.prepare();
                        obj.execute((__error: any, camp: any) => {
                            if (__error == 1) {
                                obj.nonqrysql = "DELETE FROM `brand_log` WHERE `campaign_key`='" + campID + "' ";
                                obj.prepare();
                                obj.execute((__error: any, lastid: any) => {
                                    if (__error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Campaign Deleted Successfully!", campaignId: campID, data: lastid[0], status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                        objv.execute();
                                    }
                                });

                                // To Campaign Log Update
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campID + "', '','','7','Camapaign Removed')";
                                obj4.prepare();
                                obj4.execute((campErr, __resp) => {
                                    if (campErr == 1) {
                                        console.log("Campaign Log Updated Successfully.");
                                    }
                                    else {
                                        console.log("Campaign Log Not Updated!");
                                    }
                                });
                            }
                            else {
                                // To Campaign Log Update
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campID + "', '','','8','Camapaign Remove Failed')";
                                obj4.prepare();
                                obj4.execute((campErr, __resp) => {
                                    if (campErr == 1) {
                                        console.log("Campaign Log Updated Successfully.");
                                    }
                                    else {
                                        console.log("Campaign Log Not Updated!");
                                    }
                                });

                                let objv = new RawView(res);
                                objv.prepare({ message: "Campaign Not Deleted!", status: 502 });
                                objv.execute();
                            }
                        });
                    } else {
                        let data = JSON.parse(body);
                        let objv = new RawView(res);
                        objv.prepare({
                            message: data[0].field + ' ' + data[0].description,
                            status: data[0].code
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
       *Start Resubmit Campaign  *
       *********************************************/

    public resubmitCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata: any = JSON.parse(req.body.data);
            let campID = sdata.campId;
            // let mnoDetail:any =[];
            let mnoDetail = sdata.mnodetail;
            //  let resultAllBrand:any = [];
            // mnoDetail.forEach((campaignmnoData: any) => {
            //     resultAllBrand.push(campaignmnoData.campaign_class); 
            // })
            // let mnoData = resultAllBrand;
            if (error == 1) {
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campID + '/resubmit',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify({ 'mnoIds': mnoDetail })
                };
                request(options, (error: any, response: any, body: any) => {
                    let resData = JSON.parse(response.body);
                    if (resData.campaignId) {
                        let tmp: any = [];
                        Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                            let t = ele[1];
                            t["class"] = ele[0];
                            tmp.push(t);
                        });
                        let campaignMNOData1 = tmp;
                        campaignMNOData1.forEach((mnoData: any) => {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `campaign` SET `tpmScope`='" + mnoData.tpmScope + "', `minMsgSamples`='" + mnoData.minMsgSamples + "',`msgClass`='" + mnoData.msgClass + "',`reqSubscriberOptout`='" + mnoData.reqSubscriberOptout + "',`mnoReview`='" + mnoData.mnoReview + "',`mmsTpm`='" + mnoData.mmsTpm + "',`noEmbeddedPhoneForMNO`='" + mnoData.noEmbeddedPhone + "',`mno`='" + mnoData.mno + "',`tpm`='" + mnoData.tpm + "',`reqSubscriberHelp`='" + mnoData.reqSubscriberHelp + "',`reqSubscriberOptin`='" + mnoData.reqSubscriberOptin + "',`mnoSupport`='" + mnoData.mnoSupport + "',`noEmbeddedLinkForMNO`='" + mnoData.noEmbeddedLink + "',`qualify`='" + mnoData.qualify + "',`campaign_class`='" + mnoData.class + "',`brandDailyCap`='" + mnoData.brandDailyCap + "',`brandTier`='" + mnoData.brandTier + "' WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `iduser`='" + sessdata.iduser + "'";
                            // obj.nonqrysql = obj.slice(0, -1);
                            obj.prepare();
                            obj.execute((_errorr: any, data: any) => {
                                if (_errorr == 1) {
                                    console.log("Mno Update Successfully", mnoData.class);
                                }
                                else {
                                    console.log("Mno Not Updated", mnoData.class);
                                }
                            })
                            let obj4 = new ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campID + "','','','5','Campaign Re-Submitted')";
                            obj4.prepare();
                            obj4.execute((campErr, __resp) => {
                                if (campErr == 1) {
                                    console.log("Campaign Log Updated Successfully.");
                                }
                                else {
                                    console.log("Campaign Log Not Updated!");
                                }
                            });
                        })
                        let objv = new RawView(res);
                        objv.prepare({ message: "Campaign Resubmit Successfully!", campaignId: campID, status: 201 });
                        objv.execute();
                    }
                    else {
                        let obj4 = new ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campID + "', '','','6','Campaign Re-Submit Failed')";
                        obj4.prepare();
                        obj4.execute((campErr, __resp) => {
                            if (campErr == 1) {
                                console.log("Campaign Log Updated Successfully.");
                            }
                            else {
                                console.log("Campaign Log Not Updated!");
                            }
                        });

                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    /*************************************************************************
    * Campaign Event Log         *********************************************
    **************************************************************************/

    public getCampaignEvents(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idaccount, iduser, campaign_key, date, webhook_event_type, webhook_description_detail FROM `campaign_log` WHERE `request_type` = '1' AND `campaign_key`= '" + sdata.campId + "' ORDER BY `idcampaign_log` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Events Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "No Event Fetched!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /*************************************************************************
    * End Campaign Functionality *********************************************
    **************************************************************************/


    /*********************************************
    *Start get Tariff details based on TariffId  *
    *********************************************/

    public getSubscriptionPlan(req: Request, res: Response, next: NextFunction) {
        let data: any = req.query;
        let sdata: any = JSON.parse(data.type);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT u.idtariff,t.name FROM `user`u INNER JOIN `tariff`t ON u.idtariff = t.idtariff WHERE u.`iduser`='" + sdata.iduser + "' AND u.`idaccount` = '" + sdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Tariff Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched Tariff Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
    *End get Tariff details based on TariffId  *
    *********************************************/
    // Start Create Campaign File Sample
    public createCampaignFile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let campFileData: any = req.body.data;
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "INSERT INTO `campaign_file` (`mimeType`,`fileName`) VALUES ('" + campFileData.mimeType + "', '" + campFileData.fileName + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT fileName FROM `campaign_file` WHERE `camp_file_id`='" + result.insertId + "'";
                        obj1.prepare();
                        obj1.execute((__error: any, CamFileRes: any) => {
                            if (__error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    data: CamFileRes,
                                    message: "Image Insert Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Record not found!",
                                    status: 502
                                });
                                objv.execute();
                            }

                        })
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Insert Campaign File Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                })


            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    /*********************************************
    *Start get CDR details based on User Id  *
    *********************************************/

    // public getSummeryCDRList(req: Request, res: Response, next: NextFunction) {
    //     //  let sdata: any = req.query;
    //     //  let data: any = JSON.parse(sdata.type);
    //     //  let iduser: any = data.iduser;
    //     let days: any = 'L7D';
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let con:any ;
    //             let currentDate=new Date().toISOString().split('T')[0];
    //             if(days=='L7D')
    //             {   
    //                 const sevenDaysBeforeDate = new Date(new Date().setDate(new Date().getDate() - 7)).toISOString().split('T')[0];
    //                 con  +=  sevenDaysBeforeDate
    //             }
    //             if(days=='This week')
    //             {   
    //                 const sevenDaysBeforeDate = new Date(new Date().setDate(new Date().getDate() - 7)).toISOString().split('T')[0];
    //                 con  +=  "BETWEEN '"+sevenDaysBeforeDate+"' AND '"+currentDate+"'sevenDaysBeforeDate"
    //             }
    //             if(days=='Last week')
    //             {   
    //                 const sevenDaysBeforeDate = new Date(new Date().setDate(new Date().getDate() - 7)).toISOString().split('T')[0];
    //                 con  +=  "BETWEEN '"+sevenDaysBeforeDate+"' AND '"+currentDate+"'sevenDaysBeforeDate"
    //             }
    //             if(days=='This Month')
    //             {

    //             }
    //             if(days=='Last Month')
    //             {

    //             }

    //         //     let obj = new ModelRawQuery(req, res);
    //         //     obj.qrysql = "SELECT direction,start_stamp FROM `cdr` WHERE start_stamp "+con+" AND iduser='" + '287' + "'";
    //         //     obj.prepare();
    //         //     obj.execute((err: any, result: any) => {
    //         //     if (err == 1 && result.length > 0) { 
    //         //         let objv = new RawView(res);
    //         //         objv.prepare({ message: 'CDR Fatched Successfully!', data: result, status: 200 });
    //         //         objv.execute();
    //         //     }
    //         //     else {
    //         //         let objv = new RawView(res);
    //         //         objv.prepare({ message: "NO CDR available", data: [], status: 502 });
    //         //         objv.execute();
    //         //     }
    //         // })


    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Authorization!", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

    /*********************************************
    *End CDR details based on User Id  *
    *********************************************/

    /** start createMockCvToken */

    //  public createMockCvToken(req: Request, res: Response, next: NextFunction) {
    //     let vettingData: any = req.body;
    //     let vettingData1: any = req.query;
    //     let brandId: any = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let options: any = {
    //                 'method': 'POST',
    //                 'url': apiUrl + 'brand/'+brandId+'/externalVetting/mockCvToken',
    //                 'headers': {
    //                     'Content-Type': 'application/json',
    //                     'Authorization': 'Basic ' + authKey
    //                 },
    //                 body: JSON.stringify(brandId)


    //             };
    //             request(options, (error: any, response: any, body: any) => {


    //             })
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    /** end createMockCvToken */




}
exports.NewCampaign = NewCampaign;


class BrandManager {
    constructor() { }
    /*********************
    * Send OTP For Brand *
    *********************/
    public smsOTPBrand(req: Request, res: Response, brandId: string, callback: (err: any, data: any) => void) {
        let otpdata: any;
        otpdata = {
            pinSms: "Please reply @OTP_YES@ to confirm your SMS Brand Registration",
            successSms: "Your SMS Brand Registration has been confirmed successfully"
        }
        let options: any = {
            'method': 'POST',
            'url': apiUrl + 'brand/' + brandId + '/smsOtp',
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + authKey
            },
            body: JSON.stringify(otpdata)
        };
        request(options, (error: any, response: any, body: any) => {
            if (!error) {
                let resData = JSON.parse(response.body);
                if (resData.referenceId && resData.referenceId !== undefined) {
                    callback(1, {
                        message: 'Message to be sent to the mobile phone of registered brand !', data: resData, status: 201
                    })
                }
                else {
                    callback(0, {
                        message: resData[0].field + ' ' + resData[0].description, status: resData[0].code
                    })
                }
            }
            else {
                callback(0, {
                    message: "smsOtp is Not Working!", status: 502
                })
            }

        });
    }
}

exports.BrandManager = BrandManager;
