import { Request, Response, NextFunction, response } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { SinchSMS } from "./SinchSMS";
import { TeleSMS } from "./TeleApiSMS";
import { SMS } from "./APISMSBase";
import { InteliquentSMS } from "./InteliquentSMS";
import { LergApi } from "./lrnApi";
var request = require("request");
var key = "30b32113d0eb4ec9984d9042a49171c6";
import { sessiondata } from '../server';

export class Sms extends AppRoute {
  constructor() {
    super();
  }

  messages(req: Request, res: Response, next: NextFunction){
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        var data: any = req.body.data == undefined ? req.body : JSON.parse(req.body.data);    
        if (data.FROM !== undefined && data.TO !== undefined) {

          if(req.file && req.file != null && req.file != undefined){
            let mms = new Sms();
            mms.SendMms(req, res, next);
          }
          else{
            let sms = new Sms();
            sms.SendSms(req, res, next);
          }

        }
        else {
          let objv = new RawView(res);
          objv.prepare({ message: 'All Fields are Required,FROM ,TO' });
          objv.execute();
        }
      }
      else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });  
  }

  public SendSms(req: Request, res: Response, next: NextFunction) {
    let data = req.body;
    if (data.FROM !== undefined && data.TO !== undefined && data.BODY) {

      let session = new SessionManagment(req, res, next);
      session.GetSession((error: any, sessdata: any) => {
        if (error == 1) {
          // To check the LRN details
          let PayLoad: any = {
            TO: data.TO
          }
          let lerg = new LergApi("", "");
          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : data.TO

            // To get the overall data for sms
            let objV1 = new ModelRawQuery(req, res);
            objV1.qrysql = "CALL SendSMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "');"
            objV1.prepare();
            objV1.execute((Error: any, Result: any) => {
              if (Error == 1) {
                let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
                let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
                let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""

                // To check the account balance
                if (dWallet && dWallet.TotalBalance > 0) {

                  // To check the DID
                  if (dDID) {

                    // To check the lerg info data
                    if (dLergDt) {
                      let sms: SMS;
                      let Data: any = {
                        sessdata: sessdata,
                        lergData: [dLergDt]
                      };

                      switch (dDID.SmsProvider) {
                        // TeleAPI sms provider
                        case 'teleapi':
                          sms = new TeleSMS();
                          sms.SendSms(req, res, next, Data, "teleapi", (error, resp) => { })
                          break;

                        // Sinch sms provider
                        case 'sinch':
                          sms = new SinchSMS();
                          sms.SendSms(req, res, next, Data, "sinch", (error, resp) => { })
                          break;

                        // Inteliquent sms provider
                        case 'Inteliquent':
                          sms = new InteliquentSMS();
                          sms.SendSms(req, res, next, Data, "inteliquent", (error, resp) => { });
                          break;

                        // Syneverse sms provider
                        case 'syniv':
                          let cSess: any = new CSESSION()
                          cSess.GetSynv((error: any, result: any) => {
                            if (error == 1) {
                              let ID: string = "synverse" + result
                              console.log("SMSID::", ID)

                              cSess.SetSynv({
                                id: result
                              })

                              sms = new SinchSMS();
                              sms.SendSms(req, res, next, Data, ID, (error, resp) => { })
                            }
                          })
                          break;

                        default:
                          console.log("CASE::Default")
                          let objv = new RawView(res);
                          objv.prepare({ message: "Invalid Account Setting", status: 502 });
                          objv.execute();
                          break;
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({ message: "Lerg Info Not Found" });
                      objv.execute();
                    }
                  }
                  else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                    objv.execute();
                  }
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({
                    error: "",
                    message: "Please add funds to your account or contact support.",
                    status: 503
                  });
                  objv.execute();
                }
              }
              else {
                let objv = new RawView(res);
                objv.prepare({
                  error: Error,
                  message: "Something Went Wrong to Fetch Account Data!",
                  status: 404
                });
                objv.execute();
              }
            })
          })
        }
        else {
          let objv = new RawView(res);
          objv.prepare({ status: 401, message: 'Invalid authorization!' });
          objv.execute();
        }
      });
    }
    else {
      let objv = new RawView(res);
      objv.prepare({ status: 400, message: 'All Fields are Required, FROM, TO, BODY' });
      objv.execute();
    }
  }

  // public SendMms(req: Request, res: Response, next: NextFunction) {
  //   let data = req.body;
  //   console.log("dataaaaaaaaaaaa",data);

  //   if(data.FROM !== undefined && data.TO !== undefined && data.BODY && data.ATTCHMENT !== undefined){
  //   let sdata: any = [];
  //   let session = new SessionManagment(req, res, next);
  //   session.GetSession((error: any, sessdata: any) => {
  //     if (error == 1) {
  //       let lergLogin = new LergApi("", "");
  //       lergLogin.signIn(req, res, (auth_err, auth_details) => {
  //         if (auth_details) {
  //           console.log("auth_details", auth_details);
  //           let auth_token = auth_details.auth_token
  //           let obj1 = new ModelRawQuery(req, res);
  //           obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
  //           obj1.prepare();
  //           obj1.execute((error, responce) => {
  //             if (responce.length > 0) {
  //               let tmp: any = responce;
  //               sdata["type"] = tmp[0].username;
  //               let sms: SMS;
  //               switch (sdata.type) {
  //                 case 'teleapi':
  //                   sms = new TeleSMS();
  //                   sms.SendMms(req, res, next, auth_token, "teleapi", (error, resp) => {
  //                     if (resp) {
  //                       let obj1 = new RawView(res);
  //                       obj1.prepare({ "message": "SMS Send Successfully", "result": resp });
  //                       obj1.execute();
  //                     } else {
  //                       let obj = new RawView(res);
  //                       obj.prepare({ "message": "Somthing went Wrong", "result": error })
  //                       obj.execute();
  //                     }
  //                   })
  //                   break;
  //                 case 'Sinch':
  //                   sms = new SinchSMS();
  //                   sms.SendMms(req, res, next, auth_token, "sinch", (error, resp) => {
  //                     if (resp) {
  //                       let obj1 = new RawView(res);
  //                       obj1.prepare({ "message": "SMS Send Successfully", "result": resp });
  //                       obj1.execute();
  //                     } else {
  //                       let obj = new RawView(res);
  //                       obj.prepare({ "message": "Somthing went Wrong", "result": error })
  //                       obj.execute();
  //                     }
  //                   })
  //                   break;
  //                 case 'Inteliquent':
  //                   sms = new InteliquentSMS();
  //                   sms.SendSms(req, res, next, auth_token, "inteliquent", (error, resp) => {
  //                     if (resp) {
  //                       let obj1 = new RawView(res);
  //                       obj1.prepare({ "message": "SMS Send Successfully", "result": resp });
  //                       obj1.execute();
  //                     } else {
  //                       let obj = new RawView(res);
  //                       obj.prepare({ "message": "Somthing went Wrong", "result": error })
  //                       obj.execute();
  //                     }
  //                   })
  //                   break;
  //               }
  //             } else {
  //               let objv = new RawView(res);
  //               objv.prepare({ message: "Invalid  Setting" });
  //               objv.execute();
  //             }
  //           });
  //         }
  //       });
  //     }
  //     else {
  //       let objv = new Res406(res);
  //       objv.prepare("No session data there");
  //       objv.execute();
  //     }
  //   });
  //   }else{
  //     let objv = new RawView(res);
  //     objv.prepare({ message: 'All Fields are Required,FROM ,TO, BODY, ATTCHMENT'});
  //     objv.execute();
  //   }
  // }



  // public SendMms(req: Request, res: Response, next: NextFunction) {
  //   var sdata: any = req.body;
  //   let session = new SessionManagment(req, res, next);    
  //   session.GetSession((sessErr: any, sessData: any) => {
  //     let text: any;
  //     let file: any;
  //     if (sdata.BODY != null && sdata.BODY != undefined && req.file == null && req.file == undefined) {
  //       text = sdata.BODY;
  //       file = "";
  //     }
  //     if (req.file != null && req.file != undefined && sdata.BODY == null && sdata.BODY == undefined) {
  //       text = "";
  //       if (req.file) {
  //         const fileName = req.file.filename;
  //         file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
  //       }
  //     }
  //     if (sdata.BODY != null && sdata.BODY != undefined && req.file != null && req.file != undefined) {
  //       text = sdata.BODY;
  //       if (req.file) {
  //         const fileName = req.file.filename;
  //         file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
  //       }
  //     }
  //     if (sessErr == 1) {
  //       let obj = new ModelRawNonQuery(req, res);
  //       obj.nonqrysql = "INSERT INTO `mms_template`(`idaccount`,`iduser`, `body`,`file_path`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + text + "','" + file + "')";
  //       obj.prepare();
  //       obj.execute((error: any, result: any) => {
  //         let obj = new ModelRawNonQuery(req, res);
  //         obj.nonqrysql = "INSERT INTO `mms_send`(`idaccount`,`iduser`,`mms_body`,`attachment`,`from`,`to`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + text + "','" + file + "','" + sdata.FROM + "','" + sdata.TO + "')";
  //         obj.prepare();
  //         obj.execute((err: any, ress: any) => {

  //           if (error == 1) {
  //             let objv = new RawView(res);
  //             objv.prepare({ message: "MMS Template Saved Successfully", data: result, status: 200 });
  //             objv.execute();
  //           } else {
  //             let objv = new RawView(res);
  //             objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
  //             objv.execute();
  //           }
  //         });
  //       });
  //     } else {
  //       let objv = new RawView(res);
  //       objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
  //       objv.execute();
  //     }
  //   })
  // }

  /*  public SendMms(req: Request, res: Response, next: NextFunction) {
     var sdata: any = req.body;
     let session = new SessionManagment(req, res, next);
     session.GetSession((sessErr: any, sessData: any) => {
       if (sessErr == 1) {
         let file_path = req.file.filename
         let extension = file_path.split('.').pop();
         let fsize: any;
         let mesg: any;
         if (extension == 'jpg' || extension == 'jpeg' || extension == 'png' || extension == 'gif' || extension == 'webp') {
           fsize = 1024 * 740;
           mesg = 'File too Big, please select a file less than 740KB!'
         } else if (extension == 'mp4') {
           fsize = 1024 * 1024;
           mesg = 'File too Big, please select a file less than 1MB!'
         }
         else if (extension == 'mp3') {
           fsize = 1024 * 740;
           mesg = 'File too Big, please select a file less than 740KB!'
         } else {
           fsize = 1024 * 740;
           mesg = 'File too Big, please select a file less than 740KB!'
         }
         let PayLoad: any = {
           TO: sdata.TO
         }
           let toNum = PayLoad.TO;
           if (toNum && toNum.length == 10 && isNaN(toNum) === false) {
             let lerg = new LergApi("", "");
             lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
             let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
             let baseapi = new APIBase();
               baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                 if (lerg_info.length > 0) {
                   if (req.file.size <= fsize) {
                     let text: any;
                     let file: any;
                     // if (sdata.BODY != null && sdata.BODY != undefined && req.file == null && req.file == undefined) {
                     //   text = sdata.BODY;
                     //   file = "";
                     // }
                     if (req.file != null && req.file != undefined && sdata.BODY == null && sdata.BODY == undefined) {
                       text = "";
                       if (req.file) {
                         const fileName = req.file.filename;
                         //file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
                         file = 'https://mms.signalmash.com/content/' + fileName;
                       }
                     }
                     if (sdata.BODY != null && sdata.BODY != undefined && req.file != null && req.file != undefined) {
                       text = sdata.BODY;
                       if (req.file) {
                         const fileName = req.file.filename;
                         //file = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
                         file = 'https://mms.signalmash.com/content/' + fileName;
                       }
                     }
                     let obj1 = new ModelRawQuery(req, res);
                     obj1.qrysql = "SELECT d.did, c.campaign_key, d.iduser FROM `did_buy` d INNER JOIN `campaign` c ON c.campaign_key=d.camp_registry WHERE d.did='" + sdata.FROM + "' AND d.iduser='" + sessData.iduser + "'";
                     obj1.prepare();
                     obj1.execute((err_r: any, res_t: any) => {
                       if (err_r == 1 && res_t.length > 0) {
                         let campaignID = res_t[0].campaign_key;
                         let obj2 = new ModelRawQuery(req, res);
                         obj2.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`=(SELECT upstreamCnpId FROM `campaign` WHERE `campaign_key`='" + campaignID + "' AND `deleted`=0 LIMIT 1)";
                         obj2.prepare();
                         obj2.execute((camperr: any, campres: any) => {
                           if (camperr == 1 && campres.length > 0) {
                             let fType
                             if (extension == 'jpg' || extension == 'jpeg' || extension == 'png' || extension == 'gif' || extension == 'webp') {
                               fType = [{ image: { "url": file }, 'message-text': text }];
                             }
                             else if (extension == 'pdf') {
                               fType = [{ pdf: { url: file }, 'message-text': text }];
                             }
                             else if (extension == 'mp3') {
                               fType = [{ audio: { url: file }, 'message-text': text }]
 
                             } else {
                               fType = [{ video: { url: file }, 'message-text': text }]
                             }
                             var options = {
                               'method': 'POST',
                               'url': 'https://api.ci.mblox.com/ep/v2/',
                               'headers': {
                                 'Content-Type': 'application/json',
                                 'x-api-key': '4ZFnGzsQnEspkuOsUWxMHY5FSBaqmue0'
                               },
                               body: JSON.stringify({
                                 "action": "sendMMS",
                                 "service-id": campaignID,
                                 "to": "1" + sdata.TO,
                                 "from": "1" + sdata.FROM,
                                 "from-mask": "1" + sdata.FROM,
                                 "fallback-sms-text": "MMS",
                                 "disable-fallback-sms-link": false,
                                 "disable-fallback-sms": false,
                                 "slide": fType
                               })
                             };
                             request(options, (error: any, response: any) => {
                               let OptionStatus: any = JSON.parse(options.body);
                               let From_number: any = OptionStatus['from'];
                               let To_number: any = OptionStatus['to'];
                               let from_mask: any = OptionStatus['from-mask'];
                               let dStatus: any = JSON.parse(response.body);
                               let dSta: any = dStatus['status'];
                               let messageData: any = '';
                               if (dSta == 'success') {
                                 messageData = dStatus['status-details'];
                               }
                               if (dSta == 'failure') {
                                 messageData = dStatus['error-info'];
                               }
                               if (!error && dSta == 'success') {
                                 let obj3 = new ModelRawNonQuery(req, res);
                                 obj3.nonqrysql = "INSERT INTO `mms_template`(`idaccount`,`iduser`, `body`,`file_path`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + text + "','" + file + "')";
                                 obj3.prepare();
                                 obj3.execute((error: any, result: any) => {
                                   let obj5 = new ModelRawNonQuery(req, res);
                                   obj5.nonqrysql = "INSERT INTO `mms_mdr`(`idaccount`,`iduser`,`batch_id`,`number_type`,`to_number`,`from_number`,`messsage_body`,`status`,`service_id`,`from_mask`,`message_subject`,`fallback-sms-text`,`slide`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','','','" + To_number + "','" + From_number + "','" + text + "','" + dSta + "','" + campaignID + "','" + from_mask + "','','" + text + "','" + file + "')";
                                   obj5.prepare();
                                   obj5.execute((error11: any, ress: any) => {
                                     if (error == 1) {
                                       let objv = new RawView(res);
                                       objv.prepare({ message: "MMS Template Saved and Send Successfully", data: result, status: 200 });
                                       objv.execute();
                                     } else {
                                       let objv = new RawView(res);
                                       objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                       objv.execute();
                                     }
                                   });
                                 });
                               }
                               else {
                                 let obj4 = new ModelRawNonQuery(req, res);
                                 obj4.nonqrysql = "INSERT INTO `mms_mdr`(`idaccount`,`iduser`,`batch_id`,`number_type`,`to_number`,`from_number`,`messsage_body`,`status`,`service_id`,`from_mask`,`message_subject`,`fallback-sms-text`,`slide`,`direction`,`status_details`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','failed','','" + To_number + "','" + From_number + "','" + text + "','" + dSta + "','" + campaignID + "','" + from_mask + "','','" + text + "','" + file + "','outbound','" + messageData + "')";
                                 obj4.prepare();
                                 obj4.execute((error15: any, ress: any) => {
                                   if (error15 == 1) {
                                     let objv = new RawView(res);
                                     objv.prepare({ message: `MMS not Send due to ${messageData}`, status: 400 });
                                     objv.execute();
                                   }
                                 });
                               }
                             });
                           }
                           else {
                             let objv = new RawView(res);
                             objv.prepare({ status: 404, message: "CampaignId does not match!" });
                             objv.execute();
                           }
                         });
                       }
                       else {
                         let objv = new RawView(res);
                         objv.prepare({ status: 404, message: "CampaignID Not Found on this DID!" });
                         objv.execute();
                       }
                     });
                   }
                   else {
                     let objv = new RawView(res);
                     objv.prepare({ status: 400, message: mesg });
                     objv.execute()
                   }
                 } else {
                   let objv = new RawView(res);
                   objv.prepare("Lerg Info Not Found");
                   objv.execute();
                 }
               })
             })
           }
           else {
             let objv = new RawView(res);
             objv.prepare({ message: "Invalid Number Please Enter Only 10 Digit!", status: 401 });
             objv.execute();
           }
 
       } else {
         let objv = new RawView(res);
         objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
         objv.execute();
       }
     })
   } */

  public SendMms(req: Request, res: Response, next: NextFunction) {
    var sdata: any = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
    //var sdata: any = req.body;
    if (sdata.FROM !== undefined && sdata.TO !== undefined) {
      let session = new SessionManagment(req, res, next);
      session.GetSession((sessErr: any, sessdata: any) => {
        if (sessErr == 1) {
          let extension = req.file.filename.split('.').pop();
          let fsize: any;
          let mesg: any;
          let file: any = (req.file != null && req.file != undefined) ? 'https://mms.signalmash.com/content/' + req.file.filename : "";
          let text: any = (sdata.BODY != null && sdata.BODY != undefined) ? sdata.BODY : "";
          let fType: any
          switch (extension) {

            case 'jpg':
            case 'jpeg':
            case 'png':
            case 'gif':
            case 'webp':
              fsize = 1024 * 1024;
              mesg = 'File too Big, please select a file less than 1MB!';
              fType = [{ image: { "url": file }, 'message-text': text }];
              break;

            case 'pdf':
              fsize = 1024 * 1024;
              mesg = 'File too Big, please select a file less than 1MB!';
              fType = [{ pdf: { url: file }, 'message-text': text }];
              break;

            case 'mp4':
              fsize = 1024 * 1024;
              mesg = 'File too Big, please select a file less than 1MB!'
              fType = [{ video: { url: file }, 'message-text': text }];
              break;

            case 'mp3':
              fsize = 1024 * 1024;
              mesg = 'File too Big, please select a file less than 1MB!';
              fType = [{ audio: { url: file }, 'message-text': text }];
              break;

            default:
              fsize = 1024 * 1024;
              mesg = 'File type is not allowed!';
              fType = [{ image: { "url": file }, 'message-text': text }];
              break;
          }

          // To check the LRN details
          let PayLoad: any = {
            TO: sdata.TO
          }
          let lerg = new LergApi("", "");
          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : sdata.TO;

            if (req.file.size <= fsize) {

              // To get the overall data for sms
              let objV1 = new ModelRawQuery(req, res);
              objV1.qrysql = "CALL SendMMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + sdata.FROM + "', '" + ToNumber + "');";
              objV1.prepare();
              objV1.execute((Error: any, Result: any) => {
                if (Error == 1) {
                  let dWallet: any = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : ""
                  let dDID: any = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : ""
                  let dLergDt: any = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : ""

                  // To check the account balance
                  if (dWallet && dWallet.TotalBalance > 0) {

                    // To check the DID
                    if (dDID) {

                      // To check the lerg info data
                      if (dLergDt) {
                        let sms: SMS;
                        let Data: any = {
                          sessdata: sessdata,
                          DIDdata: dDID,
                          lergData: [dLergDt],
                          fileType: fType
                        };

                        switch (dDID.SmsProvider) {

                          // Sinch mms provider
                          case 'sinch':
                            sms = new SinchSMS();
                            sms.SendMms(req, res, next, Data, "sinch", (error, resp) => { })
                            break;

                          // Syneverse mms provider
                          case 'syniv':
                            let objv1 = new RawView(res);
                            objv1.prepare({ message: "MMS is not allowed.", status: 403 });
                            objv1.execute();
                            break;

                          default:
                            console.log("CASE::Default")
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Account Setting", status: 502 });
                            objv.execute();
                            break;
                        }

                      }
                      else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Lerg Info Not Found" });
                        objv.execute();
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                      objv.execute();
                    }
                  }
                  else {
                    let objv = new RawView(res);
                    objv.prepare({
                      error: "",
                      message: "Please add funds to your account or contact support.",
                      status: 503
                    });
                    objv.execute();
                  }
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({
                    error: Error,
                    message: "Something Went Wrong to Fetch Account Data!",
                    status: 502
                  });
                  objv.execute();
                }
              });
            } else {
              let objv = new RawView(res);
              objv.prepare({ status: 400, message: mesg });
              objv.execute()
            }
          });
        } else {
          let objv = new RawView(res);
          objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
          objv.execute();
        }
      });
    }
    else {
      let objv = new RawView(res);
      objv.prepare({ message: 'All Fields are Required,FROM ,TO' });
      objv.execute();
    }
  }

  public mdrsearch(req: Request, res: Response, next: NextFunction) {
    console.log("Req==>" + JSON.stringify(req.body));
    var sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        var options = {
          'method': 'GET',
          'url': 'https://sms.api.sinch.com/xms/v1/IPLink_gw111/batches/' + `${sdata.Batch_Id}` + '/delivery_report/' + `${sdata.Recipient_id}`,
          'headers': {
            'Authorization': "Bearer " + key,
            'Content-Type': 'application/json'
          }
        };
        request(options, function (error: any, response: any) {
          if (error) {
            let obj = new RawView(res);
            obj.prepare({ "message": error })
            obj.execute();
          } else {
            console.log("Body==>", response.body);
            var smsdetails = JSON.parse(response.body);
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "UPDATE `mdr` SET `status`='" + smsdetails.status + "' , `deliver_at`='" + smsdetails.at + "' , `operator_status_at`='" + smsdetails.operator_status_at + "' WHERE `batch_id`='" + sdata.Batch_Id + "' AND `idaccount`='" + sessdata.idaccount + "'";
            obj.prepare();
            obj.execute((error, responce) => {
              if (responce) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `mdr` WHERE `batch_id`='" + sdata.Batch_Id + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((err, resp) => {
                  let obj1 = new RawView(res);
                  obj1.prepare({ "message": "Sms Details", "result": resp });
                  obj1.execute();
                })
              } else {
                let obj = new RawView(res);
                obj.prepare({ "message": error })
                obj.execute();
              }
            })
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    })
  }


  /**
   * @un-used APIs
   */
  public SendSms_Old(req: Request, res: Response, next: NextFunction) {
    let data = req.body;
    if (data.FROM !== undefined && data.TO !== undefined && data.BODY) {
      let sdata: any = [];
      let session = new SessionManagment(req, res, next);
      session.GetSession((error: any, sessdata: any) => {
        if (error == 1) {
          let obj5 = new ModelRawQuery(req, res);
          obj5.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= 0"
          obj5.prepare();
          obj5.execute((walletError: any, wallet: any) => {
            if (walletError == 1) {
              if (wallet.length > 0) {
                let lergLogin = new LergApi("", "");
                lergLogin.signIn(req, res, (auth_err, auth_details) => {
                  if (auth_details !== undefined) {
                    let auth_token = auth_details.auth_token
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `sms_provider` FROM `did_buy` WHERE iduser='" + sessdata.iduser + "' AND `did`='" + data.FROM + "'";
                    obj1.prepare();
                    obj1.execute((error, responce) => {
                      if (responce.length > 0) {
                        let sms: SMS;

                        switch (responce[0].sms_provider) {
                          case 'teleapi':
                            sms = new TeleSMS();
                            sms.SendSms(req, res, next, auth_token, "teleapi", (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Send Successfully", "result": resp, status: 201 });
                                obj1.execute();
                              } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                obj.execute();
                              }
                            })
                            break;

                          case 'sinch':
                            sms = new SinchSMS();
                            sms.SendSms(req, res, next, auth_token, "sinch", (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Send Successfully", "result": resp, status: 201 });
                                obj1.execute();
                              } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                obj.execute();
                              }
                            })
                            break;

                          case 'Inteliquent':
                            sms = new InteliquentSMS();
                            sms.SendSms(req, res, next, auth_token, "inteliquent", (error, resp) => {
                              if (resp) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ message: "SMS Send Successfully", "result": resp, status: 201 });
                                obj1.execute();
                              } else {
                                let obj = new RawView(res);
                                obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                obj.execute();
                              }
                            });
                            break;

                          case 'syniv':
                            let cSess: any = new CSESSION()
                            cSess.GetSynv((error: any, result: any) => {
                              if (error == 1) {
                                let ID: string = "synverse" + result
                                console.log("SMSID::", ID)

                                cSess.SetSynv({
                                  id: result
                                })

                                sms = new SinchSMS();
                                sms.SendSms(req, res, next, auth_token, ID, (error, resp) => {
                                  if (resp) {
                                    let obj1 = new RawView(res);
                                    obj1.prepare({ message: "SMS Send Successfully", "result": resp, status: 201 });
                                    obj1.execute();
                                  }
                                  else {
                                    let obj = new RawView(res);
                                    obj.prepare({ message: "Somthing went Wrong", "result": error, status: 502 })
                                    obj.execute();
                                  }
                                })
                              }
                            })
                            break;

                          default:
                            console.log("CASE::Default")
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Account Setting", status: 502 });
                            objv.execute();
                            break;
                        }
                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Invalid Account Setting", status: 502 });
                        objv.execute();
                      }
                    });
                  }
                });
              }
              else {
                let objv = new RawView(res);
                objv.prepare({ error: wallet, message: "Please add funds to your account or contact support.", status: 503 });
                objv.execute();
              }
            }
            else {
              let objv = new RawView(res);
              objv.prepare({ error: wallet, message: "Something Went Wrong to Fetch Account Balance!", status: 502 });
              objv.execute();
            }
          });
        }
        else {
          let objv = new Res406(res);
          objv.prepare("No session data there");
          objv.execute();
        }
      });
    }
    else {
      let objv = new RawView(res);
      objv.prepare({ message: 'All Fields are Required,FROM ,TO, BODY' });
      objv.execute();
    }
  }

}

export class CSESSION {
  constructor() { }

  public GetSynv(callback: (error: any, data: any) => void) {
    callback(1, sessiondata.get("smscID"))
  }

  public SetSynv(data: any) {
    switch (data.id) {
      case 4: {
        sessiondata.set("smscID", 5)
        break
      }

      case 5: {
        sessiondata.set("smscID", 6)
        break
      }

      case 6: {
        sessiondata.set("smscID", 7)
        break
      }

      case 7: {
        sessiondata.set("smscID", 4)
        break
      }

      default: {
        sessiondata.set("smscID", 4)
      }
    }
  }


}